#ifndef _AREA_DBASE_H
#define _AREA_DBASE_H

#include <stdio.h>

#include "mudobject.h"
#include "entity.h"
#include "btree.h"
#include "errlog.h"
#include "lexer.h"
#include "flags.h"
#include "timespan.h"
#include "dirread.h"


class Rope;
class Object_List;

struct reload_obj_info {
   Strings         last_loc_name;
   Strings         last_loc_area;
   MudObject       *the_obj;
   special_holder  *spec_holder;
   Strings         spec_name;
   reload_obj_info *next_info;
};

class Area_Dbase
{
public:

   Area_Dbase(char *areaname);
   ~Area_Dbase();
   Entity *get_areaobject(char *the_object);
   int delete_areaobject(Entity *the_object);
   int remove_areaobject(Entity *the_object);
   int add_areaobject(Entity *the_object);
   int delete_areaobject(char *the_obj);
   void reset_list();
   Entity *get_next_obj();
   char *get_read_deny();
   char *get_write_allow();
   void set_read_deny(char *the_list);
   void set_write_allow(char *the_list);
   void describe(Builder *the_builder);
   int can_read(Builder *the_builder);
   int can_write(Builder *the_builder);
   int load_area(FILE *areafile, ErrLog *error_log, int for_builder, 
                                                          int for_build_port);
   int load_area(DirRead *the_dir, char *pattern, ErrLog *error_log, 
		                     int for_builder, int for_build_port);
   char *get_areaname();
   void set_areaname(char *new_name);
   int  is_valid();
   int  reload_area(FILE *the_file);
   int  add_reboot_info(MudObject *new_obj);
   void add_spec_reboot_info(MudObject *new_obj, char *the_area);
   int  update_reboot_info(char *oldname, char *newname);
   int  add_inv_reboot_info(MudObject *new_obj, char *the_area, 
                                                    Object_List *the_dbase);

   int  coord_area1(ErrLog *error_log, Object_List *obj_dbase);
   int  coord_area2(ErrLog *error_log, Object_List *obj_dbase);
 
   long get_reload_interval();
   void set_reload_interval(long new_val);

   Flags *get_areaflags();

   int  write_area(FILE *the_file, int is_builder_file);
   int  try_reload();

   int  display_brief_data(Player *the_player);

   int  get_num_obj_loaded();
   void save_state();
   void restore_state();

   void set_time_till_reset(int new_secs);
   long get_time_till_reset();
   int  get_stored_mem();
   int  empty_objects();

private:

   int add_dual_reboot_info(MudObject *new_obj, MudObject *inside_loc,
                                                    MudObject *outside_loc);
   int reboot_door(MudObject *tmp_obj, ErrLog *error_log, 
                                                       int in_zone);

   /**************************************************
    ** Private read functions for objects 
    **************************************************/

   Entity *read_marker(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_location(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_door(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_moveable(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_wearable(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_weapon(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_merger(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_key(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_boat(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_book(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_mobile(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format, int for_build_port);
   Entity *read_money(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_food(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_rope(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format);
   Entity *read_specials(FILE *read_file, char *areaname,
                ErrLog *error_log, int build_format, int for_build_port);
   Entity *read_level(FILE *read_file, ErrLog *error_log, int build_format);
   Entity *read_quest(FILE *read_file, ErrLog *error_log, int build_format);
   Entity *read_race(FILE *read_file, ErrLog *error_log, int build_format);
   Entity *read_inclination(FILE *read_file, ErrLog *error_log, int build_format);
   Entity *read_talent(FILE *read_file, ErrLog *error_log, int build_format);
   Entity *read_mask(FILE *read_file, token_record *the_token, 
                     ErrLog *error_log, int build_format);
   Entity *read_chatline(FILE *read_file, ErrLog *error_log, int build_format);

   Entity *read_mudobject(FILE *read_file, token_record *the_tok, 
                         char *areaname, ErrLog *error_log, int build_format,
                                           int for_build_port);



   /*********************************************************
    ** Attributes
    *********************************************************/

   btree<Entity> the_dbase;     /* the actual btree database */

   Strings  area_name;     /* name of this area */
   Strings  read_deny;     /* who can't read what zones */
   Strings  write_allow;   /* who can write to a zone */

   Flags    *area_flags;     /* flags that mark area attributes */
   long     reload_interval; /* time between reloads */ 
   Timespan reload_time; 

   int valid;

   reload_obj_info *reload_list;

   int num_obj_loaded;

};

#endif







