#ifndef _CHATLINE_H
#define _CHATLINE_H

#include "entity.h"

class Player;
class Builder;
class Flags;

class ChatLine : public Entity {
 public:

   ChatLine();
   virtual ~ChatLine();
   ChatLine(char *action_name);

   int set_lead_in_actor(char *the_string);
   char *get_lead_in_actor();
   int set_lead_in_crowd(char *the_string);
   char *get_lead_in_crowd();
   int set_text_color(char *the_string);
   char *get_text_color();
   int set_border(char *the_string);
   char *get_border();
   int execute_chat(Parse *the_parsed, MudObject *the_user);

   int load_chatline(FILE *the_file, ErrLog *error_log, int is_builder);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   virtual void write_object(FILE *the_file, int is_builder);
   int is_modified();
   void set_modified(int the_num);

   Flags *get_lineflags();
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:

   int modified;

   Strings lead_in_actor;
   Strings lead_in_crowd;
   Strings text_color;
   Strings border;

   Flags *line_flags;
};

#endif
