#!/usr/bin/perl
#
# Program name: rename_axyl_tables.pl
# Written to support Axyl global table renaming.

use File::Path;
use File::Copy;


# =========================================================================
# MAIN SECTION
# =========================================================================
#print STDERR "story-import::MAIN\n";

# First check to see if there are any new stories to process..
my @files = ();
unless ( opendir dirH, "." ) {
  print STDERR "can't read directory";
  exit 0;
}
@files = grep /.*\.php|.*\.pl|.*\.sql|.*\.pm|.*\.inc/, readdir dirH;
closedir dirH;

if (scalar(@files) eq 0) {
  print STDERR "no files found.";
  exit 0;
}

my %table_renames = (
      'block'          => 'ax_block',
      'block_blocklet' => 'ax_block_blocklet',
      'blocklet'       => 'ax_blocklet',
      'catalog'        => 'ax_catalog',
      'config'         => 'ax_config',
      'configuration'  => 'ax_configuration',
      'contactinfo'    => 'ax_contactinfo',
      'forum'          => 'ax_forum',
      'forum_member'   => 'ax_forum_member',
      'forum_msg'      => 'ax_forum_msg',
      'layout'         => 'ax_layout',
      'layout_set'     => 'ax_layout_set',
      'menu'           => 'ax_menu',
      'menuoption'     => 'ax_menuoption',
      'organisation'   => 'ax_organisation',
      'query_resource' => 'ax_query_resource',
      'sitepage'       => 'ax_sitepage',
      'ugroup'         => 'ax_group',
      'uuser'          => 'ax_user',
      'uuser_group'    => 'ax_user_group',
      'uuser_ip'       => 'ax_user_ip',
      'wwwsession'     => 'ax_wwwsession'
      );

# Process each file we found
foreach my $ifile (@files) {
  $ofile = $ifile . ".new";

  unless (open inputH, "<$ifile" ) {
    return "failed to open input file $ifile";
  }
  unless (open outputH, ">$ofile" ) {
    return "failed to open output file $ofile";
  }

  my $line = 0;
  my $changes = 0;
  my $chgdline = false;
  while ( <inputH> ) {
    $line++ ;
    $original = $_;
    $chgdline = false;
    $comment = false;

    /\/\/|\/\*|^[ ]*\*/ && do {
      $comment = true;
    };

    if ( $comment eq false ) {
      while ( ($oldtbname, $newtbname) = each %table_renames ) {
        # print "find_category: checking: \'" . $catid . "\' against pattern: \'" . $pattern . "\'" . "\n";
        /(["' ,.(])$oldtbname(["' ,.])/ && do {
          $delim1 = $1;
          $delim2 = $2;
          $changes++;
          $chgdline = true;
          s/$delim1$oldtbname$delim2/$delim1$newtbname$delim2/gm ;
        };
      }
      if ( $chgdline eq true ) {
        print outputH $_;
        print outputH "//@@" . $original;
      }
      else {
        print outputH $original;
      }
    }
    else {
      print outputH $original;
    }

  } # while
  close inputH;
  close outputH;

  print STDERR "$ifile: $changes changes\n";
  if ($changes eq 0) {
    unlink $ofile;
  }

} # foreach @files


# THE END
