# Copyright (C) 2002-2003 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX

$GLOBAL_TEST{'Apache'}{'deactivate_hpapache2'} = 
    sub {
	# see if the hpapache2 service or the hpws_apache service
	# is scheduled to run
	my $isServiceOff =  &B_is_service_off('apache');
	my $isHPWServiceOff = &B_is_service_off('hpws_apache');
	                    

	if(defined $isServiceOff && $isServiceOff == 0) {
	    # if it is running ask the question
	    return 0;
	}
	elsif(defined $isHPWServiceOff && $isHPWServiceOff == 0) {
	    # HPWS version is running
	    return 0;
	}
	else {
	    # otherwise don't ask the question
	    return 1;
	}
    };

$GLOBAL_TEST{'Apache'}{'chrootapache'} = 
    sub { 
	# location of httpd.conf file for apache V.1.3.x
	my $httpd_conf_1_3 = &getGlobal('FILE',"httpd.conf");
	# location of chroot os cp script for apache V.2.0.x
	my $chroot_os_cp_1_3 = &getGlobal('FILE',"chroot_os_cp.sh");

	# location of httpd.conf file for apache V.2.0.x
	my $httpd_conf_2_0 = &getGlobal('FILE',"httpd.conf2");
	# location of chroot os cp script for apache V.2.0.x
	my $chroot_os_cp_2_0 = &getGlobal('FILE',"chroot_os_cp.sh2");

	# location of httpd.conf file for HPWS apache V.2.0.x
	my $hpws_httpd_conf = &getGlobal('FILE',"hpws_httpd.conf");
	# location of chroot os cp script for HPWS apache V.2.0.x
	my $hpws_chroot_os_cp = &getGlobal('FILE',"hpws_chroot_os_cp.sh");

	# if a httpd.conf file and a chroot_os_cp.sh file exist for Apache 1.3 then
	if(-e $httpd_conf_1_3 && -e $chroot_os_cp_1_3){
	    # if Apache 1.3 has not already been chrooted then
	    if(! &B_match_line($httpd_conf_1_3,"\^\\s\*Chroot\\s\+\.\+\$")){
		# ask the question
		return 0;
	    }
	}

	# if a httpd.conf file and a chroot_os_cp.sh file exist for Apache 2.0 then
	if(-e $httpd_conf_2_0 && -e $chroot_os_cp_2_0){
	    # if Apache 2.0 has not already been chrooted then
	    if(! &B_match_line($httpd_conf_2_0,"\^\\s\*Chroot\\s\+\.\+\$")){
		# ask the question
		return 0;
	    }
	}

	# if a httpd.conf file and a chroot_os_cp.sh file exist for HPWS Apache then
	if(-e $hpws_httpd_conf && -e $hpws_chroot_os_cp){
	    # if Apache 2.0 has not already been chrooted then
	    if(! &B_match_line($hpws_httpd_conf,"\^\\s\*Chroot\\s\+\.\+\$")){
		# ask the question
		return 0;
	    }
	}

	# if no apache version can be chrooted or if
	# they have already been chrooted then don't ask
	# the question
	return 1;

    };

1;
