#include "includes.h"

void addpartition(struct struc_bootmanager *btmgr, int addfloppy, int addhard, char * adddrive, int addpartid, char * addname)
{
    struct struc_bootrecord towrite;
    int i;
    int drid;
    int firstfree;
    
    if ((addfloppy) || ((addhard) && (!addpartid)))
    {
	if (addhard)
	{
	    drid=addhard+127;
	    towrite.drive_id=drid;
	    towrite.part_id=0;
	    towrite.flags=DRVFLAG_DRIVEOK | INFOFLAG_ISDRIVER;
	    if (addhard >= MIN_CDROM_ID)
	    {
		towrite.flags|= DRVFLAG_ISCDROM | DRVFLAG_REMOVABLE;
		towrite.drive_id=addhard;
	    }
	    towrite.type=0;
	    towrite.father_abs_addr=0;
	    towrite.abs_addr=0;
	    towrite.password=0;
	    memset(towrite.name,0,sizeof(towrite.name));
	    strcpy((char*)towrite.name,addname);
	    towrite.reserved=0;
	    memset(towrite.keystrokes,0,sizeof(towrite.keystrokes));
	    towrite.schedule_time=0;
	}
	else
	{
	    drid=addfloppy-1;
	    towrite.drive_id=drid;
	    towrite.part_id=0;
	    towrite.flags=INFOFLAG_ISDRIVER | DRVFLAG_DRIVEOK | 
			  DRVFLAG_CHSVALID | DRVFLAG_REMOVABLE;
	    towrite.type=0;
	    towrite.father_abs_addr=0;
	    towrite.abs_addr=0;
	    towrite.password=0;
	    memset(towrite.name,0,sizeof(towrite.name));
	    strcpy((char*)towrite.name,addname);
	    towrite.reserved=0;
	    memset(towrite.keystrokes,0,sizeof(towrite.keystrokes));
	    towrite.schedule_time=0;
	}
    }
    else if (addhard) 
    {
        struct struc_table *table;
	struct struc_table *act;
	
	readtable(&table, adddrive);
	act=table;
	while ((act) && (act->partition.number!=addpartid))
	{
	    act=act->next;
	}
	if (!act)
	{
	    fprintf(stderr,"Wrong partition number\n");
	    usage();
	}
	if (!act->partition.bootable)
	{
	    fprintf(stderr,"No boot loader on this partition!\n");
	    usage();
	}
	drid=addhard+127;
	towrite.drive_id=drid;
	towrite.part_id=addpartid;
	towrite.flags=DRVFLAG_DRIVEOK | DRVFLAG_CHSVALID;
	if (towrite.part_id>4) towrite.flags|=INFOFLAG_LOGICAL;
	towrite.type=act->partition.type;
	if ((towrite.type>0x10) && (towrite.type<0x20) && 
	    (towrite.type!=0x12) && (towrite.type!=0x18))
	{
	    towrite.type=towrite.type-0x10;
	}
	towrite.father_abs_addr=act->partition.fathers_addr;
	towrite.abs_addr=act->partition.absolute_addr;
	towrite.password=0;
	memset(towrite.name,0,sizeof(towrite.name));
	strcpy((char*)towrite.name,addname);
	towrite.reserved=0;
	memset(towrite.keystrokes,0,sizeof(towrite.keystrokes));
        towrite.schedule_time=0;
	freetable(&table);
    }
    else 
    {
        fprintf(stderr,"Strange error. Neither addfloppy, nor addhard is true\n");
        abort();
    }
    i=0;
    firstfree=-1;
    while ((firstfree==-1) && (i<MAX_RECORD_NUM))
    {
	if (! (btmgr->sbmkdata.boot_records[i].flags & DRVFLAG_DRIVEOK))
	{
	    firstfree=i;
	}
	i++;
    }
    if (firstfree==-1)
    {
	fprintf(stderr,"You can't make more than 32 menuitem!\n");
	usage();
    }
    btmgr->sbmkdata.boot_records[firstfree]=towrite;
}
