/* A 'C' rendering of the example in section 11.4 of the JLS */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <setjmp.h>

struct exception;
extern struct exception *newdbzexception(void);
extern struct exception *newnullexception(void);
extern struct exception *newtestexception(const char *);
extern void Test_main(int, const char *const *);
extern int Test_thrower(const char *);

#define try { jmp_buf handler, *oldhandler=curhandler; if (setjmp(handler)==0) { curhandler=&handler;
#define catch curhandler=oldhandler; } else { curhandler=oldhandler;
#define endtry } }
#define throw(e) { caught=e; longjmp(*curhandler, 1); }

jmp_buf *curhandler;

struct exception { const char *class; const char *message; };

struct exception *caught;

struct exception *
newdbzexception(void)
{
	struct exception *n=malloc(sizeof(struct exception));
	n->class="java.lang.ArithmeticException";
	n->message="/ by zero";
	return n;
}

struct exception *
newnullexception(void)
{
	struct exception *n=malloc(sizeof(struct exception));
	n->class="java.lang.NullPointerException";
	n->message="(null)";
	return n;
}

struct exception *
newtestexception(const char *s)
{
	struct exception *n=malloc(sizeof(struct exception));
	n->class="TestException";
	n->message=s ? s : "(null)";
	return n;
}

void Test_main(int argslength, const char *const *args)
{
	volatile int i;

	for (i=0; i<argslength; i++) {
		try
			Test_thrower(args[i]);
			printf("Test \"%s"
			   "\" didn't throw an exception\n", args[i]);
		catch
			printf("Test \"%s"
			   "\" threw a %s"
			   "\n    with message: %s\n",
			   args[i], caught->class, caught->message);
		endtry
	}
}

int Test_thrower(const char *s)
{
	try
		if (strcmp(s, "divide")==0) {
			throw(newdbzexception());
		}
		if (strcmp(s, "null")==0) {
			throw(newnullexception());
		}
		if (strcmp(s, "test")==0) {
			throw(newtestexception("Test message"));
		}
	catch
		printf("[thrower(\"%s\") done]\n", s);
		throw(caught);
	endtry

	printf("[thrower(\"%s\") done]\n", s);
	return 0;
}

int
main(int ac, const char *av[])
{
	try
		Test_main(ac-1, &(av[1]));
	catch
		puts("Uncaught exception!");
	endtry
	return 0;
}
