#ifndef _QTTEEDIT_H_
#define _QTTEEDIT_H_

#include <kmainwindow.h>

#include "prPartEditor.h"
#include "position.h"

class Part;
class QLineEdit;
class QListBox;
class QPushButton;
class QPopupMenu;
class MasterEvent;
class KdeEditorToolBar;
class KdeEditorScrollBar;

class KdeMasterEditor : public KMainWindow, public PrPartEditor
{
  Q_OBJECT

 private:
  
  int index;
  char * author;
  QListBox * view;
  QLineEdit * posline;
  QLineEdit * templine;
  QLineEdit * metline0;
  QLineEdit * metline1;
  QPushButton * delBtn;
  virtual int Pitch(int);
  QPopupMenu      * _filemenu;
  QPopupMenu      * _editmenu;
  QPopupMenu      * _viewmenu;
  KdeEditorScrollBar * _scrollbar;
  KdeEditorToolBar   * _toolbar;
  bool _toolbarstate;
  bool _sliderstate;

 protected:

  int time1;
  int time2;
  Position newPos;
  int newTempo;
  int newMeter0;
  int newMeter1;


 public:

  KdeMasterEditor(Part * part);

  ~KdeMasterEditor();

  /**
   * returns the part under consideration
   */
  Part * gPart();

  void insertTE(MasterEvent*);
  void showView();
  void pos();
  void temp();
  void meter();

  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);


 public slots:
  
  void addTempo();
  void addMeter();
  void remove();
  void enableDelete(int);
  void exit();

  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void slotMenu( int );
  void slotViewMenu( int );
};


#endif
