#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  READMAIL screen container handler
// ============================================================================

// class to give arguments for tags/containers inside this screen
class ReadmailLocalArgs {
  int p;
  int msgshown;
  int part;
  int linkshown;
  int showlink;
  int showpart;
  int showdata;
  string name;
  string partno;
  array(string) partnos;
  array parenttypes;
  array(object) msgs;
  mapping refparts;
  mapping parenttype;
  object mess;

  void create()
  {
    p = 0; msgshown = 0; part = 0;
    refparts = ([ ]);
    partnos = ({ });
    parenttypes = ({ });
    msgs = ({ });
    parenttype = 0;
  }
};

string screen(mapping args, string contents, object id)
{
  string out = "";
  CSESSION->screen = "readmail";	// Admin screen name

  int nextuid = -1;
  int prevuid = -1;
  int mails = sizeof(CSESSION->mails);
  string mbox_name;

  if (mails>CSESSION->cmailidx + 1)
    nextuid=((int)CSESSION->mails[(CSESSION->cmailidx) + 1]->imap->UID);
  if (CSESSION->cmailidx>0 && mails > (CSESSION->cmailidx - 1))
    prevuid=((int)CSESSION->mails[(CSESSION->cmailidx) - 1]->imap->UID);
  // fail safe
  if(CSESSION->cmailidx < 0 || CSESSION->cmailidx >= mails)
    mbox_name = CSESSION->mailbox[MB_FOLDERNAME_IDX];
  else
    mbox_name = CSESSION->mails[CSESSION->cmailidx]->imap->MAILBOX;

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                         "camas_reply"                : tag_camas_readmail,
                         "camas_replytoall"           : tag_camas_readmail,
                         "camas_replymove"            : tag_camas_readmail,
                         "camas_replytoallmove"       : tag_camas_readmail,
                         "camas_trashthis"            : tag_camas_readmail,
                         "camas_forward"              : tag_camas_readmail,
                         "camas_forwardmove"          : tag_camas_readmail,
                         "camas_showprev"             : tag_camas_readmail,
                         "camas_shownext"             : tag_camas_readmail,
                         "camas_continuecompose"      : tag_camas_readmail,
                         "camas_fullheaders"          : tag_camas_readmail,
												 "camas_movemarkedlist"				: tag_camas_readmail,
												 "camas_movemarkedbutton"     : tag_camas_readmail,
                         "camas_option_movethislist"  : tag_camas_readmail,
                         "camas_input_movethisbutton" : tag_camas_readmail,
                         "camas_backtomailindex"      : tag_camas_readmail,
                         "camas_face"                 : tag_camas_readmail,
                         ]),
                        ([
                         "camas_showemail"            : container_camas_showemail,
                         "camas_loop_headers"         : container_camas_loop_headers,
                         ]),
                        id, ReadmailLocalArgs(), nextuid, prevuid);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
      contents = parse_scopes(contents,cb_scopes,id);

  contents += CAMAS.Tools.make_tag("input", ([ 
                                                "type":"hidden",
                                                "name":"mbox",
                                                "value": mbox_name,
                                            ])) + "\n";
  contents += CAMAS.Tools.make_tag("input", ([ 
                                                "type":"hidden", 
                                                "name":"msg"+(string)CSESSION->cmailuid,
                                                "value":"1"
                                            ]) ) + "\n";
  contents += CAMAS.Tools.make_tag("input", ([
                                                "type":"hidden",
                                                "name":"prevuid",
                                                "value":(string)prevuid
                                            ]) ) + "\n";
  contents += CAMAS.Tools.make_tag("input", ([
                                                "type":"hidden",
                                                "name":"nextuid",
                                                "value":(string)nextuid 
                                            ]) ) + "\n";
  args->method = "post";
  args->name = "camasreadmailform";

  args = CAMAS.Tools.set_target(id, args);
  
  out += CAMAS.Tools.make_container("form", args, contents) + "\n";
  return out;
}

//! container: camas_showemail
//!  Zone for HTML/RXML code when body of email is to be displayed
//! note: screen: readmail
string container_camas_showemail(string tag_name, mapping args, string contents, object id, object largs)
{
  object mail = CSESSION->cmail;

  string out = "<!-- Beginning of camas_emailbody-->";

  if(mail->body_parts)
  {
    largs->msgs += mail->body_parts;
  }
  else
  {
    largs->msgs += ({ mail });
  }

  int n = sizeof(largs->msgs);
  
  if (n)
  {
    for(int i = 0; i < n; i++)
    {
      largs->partnos += ({ ((string)largs->p++) });
      largs->parenttypes += ({ ([ "type": mail->type, "subtype": mail->subtype]) });
    }

    out += CAMAS.Parse.parse_html(contents,
                      ([ ]),
                      ([
                     "camas_mailpart": container_camas_showemail_mailpart,
                       ]),
                      id, largs);
  }

  out += "<!-- End of camas_emailbody -->";
  return out;
}

string add_addressbook_link(string string_emails, mapping aargs, object id)
{
  object addressbooks = id->conf->get_providers("camas_addressbook");
  if(sizeof(addressbooks) > 0 && !aargs->nolinks)
  {
    array emails = CAMAS.Tools.address_split(string_emails);
    array(string) links = ({ });
    foreach(emails, string email)
    {
      aargs->href = CAMAS.Tools.make_get_url(id, aargs, 
        ([ 
         "address": CAMAS.Tools.fix_header(email),
         "actioneditaddressfromreadmail": "1",
        ])
        );
      links += ({ CAMAS.Tools.make_container("a", aargs, CAMAS.Tools.fix_header(email)) });
    }
    if(sizeof(links) > 0)
      string_emails = links * ", ";
  }
  else
    string_emails = CAMAS.Tools.fix_header(string_emails);
  return string_emails;
}

//! container: camas_loop_headers
//!  Container to display email headers
//! args: headers 
//!  The fields to display, field are separated by ",".
//!  If not args are provided subject, date, from, to, cc will be displayed
//! args: a_nolinks
//!  If set the links to the address book will be disabled.
//! note: screen: readmail
//!  Every arguments beginning with 'a_' will be appended to the links
string container_camas_loop_headers(string tag_name, mapping args, string contents, object id, object largs)
{
  string out = "";
  array(string) headers = ({ "subject","date","from","to","cc"});
  mapping headername2msg = ([ 
                              "subject" : MSG(M_SUBJECT),
                              "to"      : MSG(M_TO),
                              "cc"      : MSG(M_CC),
                              "from"    : MSG(M_FROM),
                              "date"    : MSG(M_DATE),
                           ]);
  if(args->headers)
    headers = map(args->headers / ",", String.trim_whites);
  // if show full header is there, show all of them
  if(CSESSION->showheaders)
  {
    foreach (indices(CSESSION->cmail->headers), string h)
      if (search(headers, h) == -1)
        headers += ({ h });
  }
  mapping aargs = CAMAS.Tools.extract_html_attributes(args, "a");

  foreach(headers, string header)
  {
    if(CSESSION->cmail && CSESSION->cmail->headers && CSESSION->cmail->headers[header])
    {
      string field_content = CSESSION->cmail->headers[header];
      string field_name;
      if(headername2msg[header])
        field_name = headername2msg[header];
      else
        field_name = String.capitalize(header);
      // if show all headers are off, display sexy date format
      if(!CSESSION->showheaders && header == "date")
        field_content = CAMAS.DateTools.mailindex_date(id, field_content, field_content,
	    CAMAS_MODULE->QUERY (indexdateshortformat),
	    CAMAS_MODULE->QUERY (indexdatelongformat));
      foreach(field_content / "\0", string real_field_content)
      {
        // add a link to the address book if possible
        if(field_name == headername2msg["from"] 
            || field_name == headername2msg["to"] 
            || field_name == headername2msg["cc"])
          real_field_content = add_addressbook_link(real_field_content, aargs, id);
        else
          real_field_content = CAMAS.Tools.fix_header(real_field_content);
          array outlet = ({
                        ([
                          "field_name": CAMAS.Tools.fixstring(field_name),
                          "field_content": real_field_content,
                         ])
                      });
          out += do_output_tag(args, outlet, contents, id);
      }
    }
  }
  return out;
}

//! subcontainer : camas_mailpart
//!  Zone for HTML/RXML code for each part available in current displayed mail
//! parentcontainer : camas_showemail
//! childtag : camas_img_mimetype
//! childcontainer : camas_href
//! childcontainer : camas_showcontents
//! childcontainer : camas_showlink
//!  &lt;camas_showcontents&gt;&lt;/&gt; and &lt;camas_showlink&gt;&lt;/&gt; are mutually exclusive.
//!  Code for links to open the file can be put in the &lt;camas_mailpart&gt;&lt;/&gt; container to show link even if data is shown.
//! note: screen: readmail
string container_camas_showemail_mailpart(string tag_name, mapping args, string contents, object id, object largs)
{
  string out = "<!-- Begining of camas_mailpart -->";

  object camas_main = id->conf->get_provider("camas_main");
  if (!objectp(camas_main))
  {
    CDEBUG("module camas_main is not present");
    return "foobar";
  }
  
  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  string originalcontents = contents;

  string attachmentname = "";

  string attachmenttype = "";

  string attachmentsubtype = "";

  string attachmentfulltype = "";

  string attachmentsentence = "";

  for (largs->mess = largs->msgs[0]; largs->mess != 0; )
  {
    largs->partno = largs->partnos[0];
    largs->parenttype = largs->parenttypes[0];
    // this one is an array of MIME.Message object
    // each entry is one part of the email
    largs->msgs = largs->msgs[1..];
    largs->partnos = largs->partnos[1..];
    largs->parenttypes = largs->parenttypes[1..];

    if (largs->mess->body_parts)
    {
      largs->msgs = largs->mess->body_parts + largs->msgs;
      //write("largs->mess->body_parts=%O\n", largs->mess->body_parts);
      for (largs->p = sizeof (largs->mess->body_parts) - 1; largs->p >= 0; largs->p--)
      {
        largs->partnos =  ({ largs->partno + "," + ((string)largs->p) }) + largs->partnos;
				largs->parenttypes =
					({ 
	  				([ 
	    				"type": largs->mess->type, 
	    				"subtype": largs->mess->subtype
	  				]) 
					}) + largs->parenttypes;
      }
    }
    else
    {
      string name = CAMAS.Tools.fix_coding (largs->mess->disp_params->filename || largs->mess->params->name || "");
      largs->name = name;

      int linkshown = 0;
      largs->linkshown = linkshown;

      string mime_remap = camas_features->QUERY(mime_remap);
      
      if (mime_remap && strlen(mime_remap))
      {
        array remap = mime_remap / "\n";
        foreach (remap, string rem)
        {
          array fromto = rem / ":";
          string tmp = largs->mess->type + "/" + largs->mess->subtype;
          if (tmp == fromto[0])
          {
            largs->mess->type = (fromto[1] / "/")[0];
            largs->mess->subtype = (fromto[1] / "/")[1];
            break;
          }
        }
      }

      // Decide wether the mailpart should be shown or not
      largs->showpart = 1;

      // Decide wether the link to the document should be shown
      largs->showlink = 0;

      // Decide wether the data for the document should be shown
      largs->showdata = 0;
      //write("largs->mess->parenttype=%O\n, largs->mess->subtype=%O\n",
      //  largs->parenttype, largs->mess->subtype);

      // Big clause for deciding wether link *OR* data should be shown
      // WARNING :
      //   !!!! showdata and showlink are mutually exclusive               !!!!
      // HOWTO USE THIS CLAUSE :
      //   !!!! set showdata in the clause, either 0 or 1                  !!!!
      //   !!!! showlink is set !showdata at the end of the clause         !!!!
      //   !!!! Thus, don't set showlink inside this clause for avoiding   !!!!
      //   !!!! consistency problems                                       !!!!
      //   !!!! showpart is used to decide if mailpart is interresting     !!!!
      //   !!!! if !showpart, neither link or data will be displayed       !!!!
      // -- Bertrand
      if (!largs->mess->headers["content-id"] || !largs->refparts[largs->mess->headers["content-id"]])
      {
        if(largs->parenttype->type == "multipart")
        {
          switch(largs->parenttype->subtype)
          {
            /* multipart/alternative */
          case "alternative":
            switch(largs->mess->subtype)
            {
              /* xxx/html */
            case "html":
              if((camas_features->feature(FEAT_SHOWHTML)) && 
		 (CSESSION->showhtml == "1"))
              {
                largs->showdata = 1;
              }
              break;
              /* xxx/plain */
            case "plain":
              if(!((camas_features->feature(FEAT_SHOWHTML)) && 
		   (CSESSION->showhtml == "1")))
              {
                largs->showdata = 1;
              }
	      else {
              // If we don't want to ever see text parts
		if(!(int)CSESSION->showlinkforalternatives )
		{
		  largs->showpart = 0;
		}
	      }
              break;
              /* xxx/xxx */
            default:
            }
            break;
            /* multipart/related */
          case "related":
            switch(largs->mess->subtype)
            {
              /* xxx/html */
            case "html":
              if((camas_features->feature(FEAT_SHOWHTML)) && 
		 (CSESSION->showhtml == "1"))
              {
                largs->showdata = 1;
              }
	      break;
            case "plain":
              if(!largs->part>0)
              {
                largs->showdata = 1;
              }
              break;
              /* xxx/xxx */
            default:
            }
	  case "image":
	    
            break;

          default:
	    /* multipart/mixed and unrecognized types (see RFC 2046, 5.1.3) */
            switch(largs->mess->type)
            {
              case "text":
                switch(largs->mess->subtype)
                {
		case "plain":
		  largs->showdata = 1;
		  break;
		case "html":
		  if((camas_features->feature(FEAT_SHOWHTML)) && 
		     (CSESSION->showhtml == "1"))
		  {
		    largs->showdata = 1;
		  }
		  break;
                }
                break;
		/* image/xxx */
            case "image":
              if((int)CSESSION->showinlineimages
	        && camas_main->image_types[lower_case (largs->mess->subtype)])
              {
                largs->showdata = 1;
              }
              break;
	    }
          }
        }
	else if (largs->parenttype->type == "image" &&
		 (int)CSESSION->showinlineimages
		 && camas_main->image_types[lower_case (largs->mess->subtype)])
      	{
      	  /* image/xxx */
            largs->showdata = 1;
      	}
        else
        {
          switch(largs->mess->subtype)
          {
          case "plain":
            largs->showdata = 1;
            break;
          case "html":
            if((camas_features->feature(FEAT_SHOWHTML)) && 
	       (CSESSION->showhtml == "1"))
            {
              largs->showdata = 1;
            }
            break;
          }
        }
      }

      largs->showlink    = !largs->showdata;

      attachmentname     = sizeof (largs->name) ? HTML_ENCODE_STRING (largs->name) : "";
      attachmenttype     = largs->mess->type;
      attachmentsubtype  = largs->mess->subtype;
      attachmentfulltype = largs->mess->type + "/" + largs->mess->subtype;
      attachmentsentence = MSGA(M_ATTACHMENTLINK, ({ (attachmentname != "")?attachmentname + ", ":"", attachmentfulltype }));

      array outlet = ({
                        ([
			  "attachmentname"     : attachmentname,
			  "attachmenttype"     : attachmenttype,
			  "attachmentsubtype"  : attachmentsubtype,
			  "attachmentfulltype" : attachmentfulltype,
			  "attachmentsentence" : attachmentsentence,
                         ])
                      });

      contents = do_output_tag(args, outlet, originalcontents, id);
      if(largs->showpart)
      {
        out += CAMAS.Parse.parse_html(contents,
                          ([
			    "camas_img_mimetype"   : tag_camas_showemail_mailpart_showlink
			  ]),
                          ([
			    "camas_href"           : container_camas_showemail_mailpart_showlink_href,
			    "camas_showlink"       : container_camas_showemail_mailpart_showlink,
			    "camas_showcontents"   : container_camas_showemail_mailpart_showcontents,
			  ]),
                          id, largs);
      }

    } // else

    largs -> part++;
    largs -> mess = (sizeof(largs->msgs) > 0)? largs->msgs[0]:0;

  } // for

  out += "<!-- End of mailpart -->";
  return out;
}

//! subcontainer : camas_showlink
//! parentcontainer : camas_mailpart
//!  Zone for HTML/RXML code to be displayed if current mail link should be shown
//! note: screen: readmail
string container_camas_showemail_mailpart_showlink(string tag_name, mapping args, string contents, object id, object largs)
{
  string out = "<!-- Begining of camas_showlink -->";

  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  if(largs->showlink)
  {
    largs->linkshown = 1;
    out += contents;
  }

  out += "<!-- End of camas_showlink -->";
  return out;
}

/* Code for <camas_showlink> </> nested tags */
string tag_camas_showemail_mailpart_showlink(string tag_name, mapping args, object id, object largs)
{
  string out = "";

  switch(tag_name)
  {
  case "camas_img_mimetype":
    //! subtag : camas_img_mimetype
    //! parentcontainer : mailpart
    //!  Image displayed depending the type of the mail part
    //! attributes : all attributes applicable to <img>
    //! note: screen: readmail
    args->src = IMAGE_FROM_TYPE(((largs->mess->type) / "/")[0]);
    out = CAMAS.Tools.make_tag("img", args);
    break;

  default:
    CDEBUG("container_camas_showemail_mailpart_tags: tag "+tag_name+" is not handled");
  }

  return out;
}

//! subcontainer : camas_href
//! parentcontainer : camas_showlink
//! attribute : action=read
//!  Read the current part of the mail in a new window
//! attribute : action=download
//!  Show a link but don't open the part in a new window, usefull for
//!  downloading
//! note: screen: readmail
string container_camas_showemail_mailpart_showlink_href(string tag_name, mapping args, string contents, object id, object largs)
{
  string out = "<!-- Begining of camas_href -->";
  switch(args->action)
  {
    case "read":
    case "download":
      string filename = (sizeof (largs->name) ? largs->name : "unknown");
		
      mapping hrefvars = ([ "mailpart" : largs->partno, "filename" : filename ]);

      if(args->action == "read")
        hrefvars->newwindow = "1";
      args->href = CAMAS.Tools.make_get_url(id, args, hrefvars, filename);
    
      out += CAMAS.Tools.make_container("a", args, contents);
      break;

    default:
      CDEBUG("The arg "+args->action+" in camas_href is not available");
      out = "The arg "+args->action+" in camas_href is not available";
  }
  out += "<!-- End of camas_href -->";
  return out;
}

//! subcontainer : camas_showcontents
//! parentcontainer : camas_mailpart
//! childtag : camas_contents
//!  Zone for HTML/RXML code to be displayed only if current mail part should be shown
//! note: screen: readmail
string container_camas_showemail_mailpart_showcontents(string tag_name, mapping args, string contents, object id, object largs)
{
  string out="<!-- Begining of camas_showcontents -->";

  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  object camas_main = CAMAS_MODULE;
  if(!objectp(camas_main))
  {
    CDEBUG("module camas_main is not present");
    return "foobar";
  }

  if(largs->showdata)
  {
    out += CAMAS.Parse.parse_html(contents,
                      ([
                        "camas_contents" : tag_camas_showemail_mailpart_showcontents_contents,
                       ]),
                      ([ ]),
                      id, largs);
  }

  out += "<!-- End of camas_showcontents -->";
  return out;
}

//! subtag : camas_contents
//! parentcontainer : camas_showcontents
//!  Shows the content of the current mail part
//! attribute: htmldisplay=(inline|iframe)
//!  Decide wether html mails should be displayed inline or into an iframe
//!  - Displaying inline is more compatible but some HTML mails could not be right displayed, eg those with a body background color
//!    Some minor side effects could also be noticed ie:
//!      - css from your camas layout could redifine attributes of the element of the HTML mail
//!      - malformed HTML mail could mess up your camas interface
//!  - &lt;iframe&gt;&lt;/&gt; were introduced with HTML 4 for displaying an HTML document inside another one.
//!    Since both HTML documents (CAMAS interface and HTML mail) are independant, they can't mess up each other
//!    See http://www.w3.org/TR/REC-html40/present/frames.html#h-16.5 for more information
//!  defaults to iframe
//! attribute: iframe_*
//!  All attributes available for <iframe></>
//!  Requires htmldisplay="iframe"
//! attribute: img_*
//!  All attributes available for <img />
//! attribute: a_*
//!  Al attributes available for <a></>
//!  We don't use a* for avoiding html attributes name collision
//! note: screen: readmail
string tag_camas_showemail_mailpart_showcontents_contents(string tag_name, mapping args, object id, object largs)
{
  object camas_features = id->conf->get_provider("camas_features");
  if (!objectp(camas_features))
  {
    CDEBUG("module camas_features is not present");
    return "foobar";
  }

  object camas_main = CAMAS_MODULE;
  if(!objectp(camas_main))
  {
    CDEBUG("module camas_main is not present");
    return "foobar";
  }

  string out = "", tmp="";

  // Fix for M$ Passeport fscking mails
  if (largs->mess->headers["content-transfer-encoding"] == "7-bit")
    largs->mess->headers["content-transfer-encoding"] = "7bit";
  if (largs->mess->transfer_encoding == "7-bit")
    largs->mess->transfer_encoding = "7bit";

  string data = largs->mess->getdata () || "";

  args->htmldisplay = (zero_type(args->htmldisplay) ? "iframe" : args->htmldisplay);

  mapping iframeargs = CAMAS.Tools.extract_html_attributes(args, "iframe");
  mapping imgargs    = CAMAS.Tools.extract_html_attributes(args, "img");
  mapping aargs   = CAMAS.Tools.extract_html_attributes(args, "a");
  
  mixed err = 0;
  string _mess;
  err = catch
  {
    // TODO: use CAMAS.Tools.decode_from_internal() here 
    _mess = Locale.Charset->decoder (largs->mess->charset)->feed (data)->drain ();
  };

  if (err)
  {
    out += " " + replace (MSGA(M_CHARSETWARNING, ({ "\0" })), "\0", HTML_ENCODE_STRING (largs->mess->charset)) + "<hr />";
  }

  if(largs->mess->type == "text")
  {
    CDEBUG("mail is text");
    // If mail is too big
    if (sizeof (data) > ((int)camas_main->QUERY(maxmailsize)))
    {
      CDEBUG("mail too big");

      mapping hrefvars = ([ "mailpart" : largs->partno ]);
      aargs->target = "_blank";
      aargs->href = CAMAS.Tools.make_get_url(id, aargs, hrefvars, (sizeof(largs->name) ? HTTP_ENCODE_URL (largs->name) : "mail.txt"));
      out += CAMAS.Tools.make_container("a", aargs, MSG(M_MAILTOOBIG));

    }
    else
    {
      string noparsecontents = "";
      mixed err_parser;
      
      err_parser = catch {
	      // If email is HTML, first try to see if we manage to parse it 
      	// using the HTML Parser, if not revert to text
        if (largs->mess->subtype == "html")
      	{
	        CDEBUG("html mail part");
    	    if(args->htmldisplay == "inline")
    	    {
            // Safing HTML in CAMAS HTML module
            noparsecontents += id->conf->get_provider ("camas_html")->safe_html ((err ? data : _mess), 
  	         id, largs->refparts, largs->mess->headers["content-base"]);
    	    }
    	    // iframe or default
    	    else
    	    {
    	      // this mail will be parsed later on in Camas HTML module
    	      mapping iframevars = ([ "mailpart" : largs->partno ]); 
    	      iframeargs->src = CAMAS.Tools.make_get_url(id, iframeargs, iframevars, (sizeof (largs->name) ? largs->name : "unknown"));
    	      noparsecontents += CAMAS.Tools.make_container("iframe", iframeargs, "");
    	    }
        }
      };
      // Email should be text
      if(largs->mess->subtype != "html" || err_parser)
      {
        if(err_parser)
        {
          report_warning("Camas HTML: fail to safe parse mail, reverting to text.\n%s\n", err_parser[0]);
          array(string) res = id->conf->get_provider ("camas_html")->gettext_from_mail(largs->mess, id);
          _mess = res[0];
        }
        CDEBUG("text mail part");
        tmp = CAMAS.ScreenTools.make_links (CAMAS.Tools.fixstring (err ? data : _mess), camas_features->QUERY(linkwindow),({ id->misc->camas->uptarget, id->misc->camas->nextuptarget }));
        // if the data comes from HTML it was already encoded before starting make_links
        // so we have to decode it
        if (err_parser)
          tmp = replace(tmp, "&amp;", "&");
        noparsecontents += replace (tmp, "  ", "&nbsp;&nbsp;");
      }
  
      // Avoid parsing mails
      out += CAMAS.Tools.make_container("noparse", ([ ]), noparsecontents);
    } // else mail is too big
  } // mail is text

  if(largs->mess->type == "image")
  {
    mapping imgvars = ([ "mailpart" : largs->partno ]);
    imgargs->alt = largs->name;
    imgargs->src = CAMAS.Tools.make_get_url(id, imgargs, imgvars, largs->name); 
    out += CAMAS.Tools.make_tag("img", imgargs);
  }
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
