/*
 * Decompiled with CFR 0.152.
 */
package se.idonex.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import se.idonex.servlet.RoxenServletContext;

class ServletResponse
implements HttpServletResponse {
    int contentLength = -1;
    String contentType = null;
    String encoding = null;
    ServletOutputStream pikeStream;
    ServletOutputStream outputStream = null;
    PrintWriter writer = null;
    Dictionary headers = null;
    int status = 200;
    String statusmsg = null;
    static Dictionary statusTexts = new Hashtable();

    static {
        statusTexts.put(new Integer(200), "OK");
        statusTexts.put(new Integer(201), "Created");
        statusTexts.put(new Integer(202), "Accepted");
        statusTexts.put(new Integer(203), "Provisional Information");
        statusTexts.put(new Integer(204), "No Content");
        statusTexts.put(new Integer(300), "Moved");
        statusTexts.put(new Integer(301), "Permanent Relocation");
        statusTexts.put(new Integer(302), "Temporary Relocation");
        statusTexts.put(new Integer(303), "See Other");
        statusTexts.put(new Integer(304), "Not Modified");
        statusTexts.put(new Integer(400), "Bad Request");
        statusTexts.put(new Integer(401), "Access denied");
        statusTexts.put(new Integer(402), "Payment Required");
        statusTexts.put(new Integer(403), "Forbidden");
        statusTexts.put(new Integer(404), "No such file or directory");
        statusTexts.put(new Integer(405), "Method not allowed");
        statusTexts.put(new Integer(407), "Proxy authorization needed");
        statusTexts.put(new Integer(408), "Request timeout");
        statusTexts.put(new Integer(409), "Conflict");
        statusTexts.put(new Integer(410), "Gone");
        statusTexts.put(new Integer(500), "Internal Server Error");
        statusTexts.put(new Integer(501), "Not Implemented");
        statusTexts.put(new Integer(502), "Gateway Timeout");
        statusTexts.put(new Integer(503), "Service unavailable");
    }

    ServletResponse(ServletOutputStream servletOutputStream) {
        this.pikeStream = servletOutputStream;
    }

    public void addCookie(Cookie cookie) {
        int n;
        String string = this.getHeader("Set-Cookie");
        string = string == null ? "" : String.valueOf(string) + ",\r\n\t";
        string = String.valueOf(string) + cookie.getName() + "=" + ServletResponse.encodeValue(cookie.getValue());
        String string2 = cookie.getComment();
        if (string2 != null) {
            string = String.valueOf(string) + "; Comment=" + ServletResponse.encodeValue(string2);
        }
        if ((string2 = cookie.getDomain()) != null) {
            string = String.valueOf(string) + "; Domain=" + ServletResponse.encodeValue(string2);
        }
        if ((n = cookie.getMaxAge()) != -1) {
            string = String.valueOf(string) + "; Max-Age=" + n;
        }
        if ((string2 = cookie.getPath()) != null) {
            string = String.valueOf(string) + "; Path=" + ServletResponse.encodeValue(string2);
        }
        if (cookie.getSecure()) {
            string = String.valueOf(string) + "; Secure";
        }
        if ((n = cookie.getVersion()) != 0) {
            string = String.valueOf(string) + "; Version=" + n;
        }
        this.setHeader("Set-Cookie", string);
    }

    protected static final boolean badAtomChar(char c) {
        return c <= ' ' || c >= '\u007f' || c == '(' || c == ')' || c == '[' || c == ']' || c == '\"' || c == ',' || c == '\\' || c == '/' || c >= ':' && c <= '@';
    }

    public boolean containsHeader(String string) {
        return this.headers != null && this.headers.get(string.toLowerCase()) != null;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public String encodeUrl(String string) {
        return string;
    }

    protected static final String encodeValue(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        int n = 0;
        while (n < string.length()) {
            if (ServletResponse.badAtomChar(string.charAt(n))) {
                int n2 = 0;
                while ((n2 = string.indexOf(92, n2)) >= 0) {
                    string = String.valueOf(string.substring(0, n2)) + '\\' + string.substring(n2);
                    n2 += 2;
                }
                int n3 = 0;
                while ((n3 = string.indexOf(34, n3)) >= 0) {
                    string = String.valueOf(string.substring(0, n3)) + '\\' + string.substring(n3);
                    n3 += 2;
                }
                return String.valueOf('\"') + string + '\"';
            }
            ++n;
        }
        return string;
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            if (this.contentType == null) {
                this.contentType = "text/plain";
            }
            this.contentType = String.valueOf(this.contentType) + "; charset=iso-8559-1";
            this.encoding = "8859_1";
        }
        return this.encoding;
    }

    protected String getHeader(String string) {
        String string2;
        if (this.headers == null || (string2 = (String)this.headers.get(string.toLowerCase())) == null) {
            return null;
        }
        return string2.substring(string.length() + 2);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.writer != null) {
                throw new IllegalStateException();
            }
            this.getWriter();
            this.writer.flush();
            this.writer = null;
            this.outputStream = this.pikeStream;
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            Object v;
            if (this.outputStream != null) {
                throw new IllegalStateException();
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.pikeStream, this.getCharacterEncoding()));
            this.writer.print("HTTP/1.0 " + this.status + " " + ((v = statusTexts.get(new Integer(this.status))) == null ? "Foo" : (String)v) + "\r\n");
            if (!this.containsHeader("Content-Type")) {
                this.writer.print("Content-Type: " + this.contentType + "\r\n");
            }
            if (this.contentLength != -1 && !this.containsHeader("Content-Length")) {
                this.writer.print("Content-Length: " + this.contentLength + "\r\n");
            }
            if (this.headers != null) {
                Enumeration enumeration = this.headers.elements();
                while (enumeration.hasMoreElements()) {
                    this.writer.print(String.valueOf(String.valueOf(enumeration.nextElement())) + "\r\n");
                }
            }
            this.writer.print("\r\n");
            if (this.statusmsg != null) {
                this.writer.print(this.statusmsg);
            }
        }
        return this.writer;
    }

    public void sendError(int n) throws IOException {
        this.setContentType("text/html");
        this.setContentLength(this.statusmsg == null ? 0 : this.statusmsg.length());
        this.setStatus(n);
        this.getWriter().close();
    }

    public void sendError(int n, String string) throws IOException {
        this.statusmsg = "<body>" + string + "</body>\r\n";
        this.sendError(n);
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.sendError(302);
    }

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    public void setContentType(String string) {
        if (this.contentType == null) {
            this.contentType = string;
        }
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, RoxenServletContext.dateformat.format(new Date(l)));
    }

    public void setHeader(String string, String string2) {
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(string.toLowerCase(), String.valueOf(string) + ": " + string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatus(int n, String string) {
        this.statusmsg = "<body>" + string + "</body>\r\n";
        this.setContentType("text/html");
        this.setContentLength(this.statusmsg.length());
        this.setStatus(n);
    }

    void wrapUp() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.pikeStream.close();
    }
}

