/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import sun.servlet.http.HttpDate;
import sun.servlet.http.MessageString;

public class MimeHeaderField {
    protected final MessageString name = new MessageString();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected final HttpDate dateValue = new HttpDate(0L);
    protected int type = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.type = 0;
    }

    public void setName(String string) {
        this.name.setString(string);
    }

    public void setName(byte[] byArray, int n, int n2) {
        this.name.setBytes(byArray, n, n2);
    }

    public void setValue(String string) {
        this.value.setString(string);
        this.type = 1;
    }

    public void setValue(byte[] byArray, int n, int n2) {
        this.value.setBytes(byArray, n, n2);
        this.type = 1;
    }

    public void setIntValue(int n) {
        this.intValue = n;
        this.type = 2;
    }

    public void setDateValue(long l) {
        this.dateValue.setTime(l);
        this.type = 3;
    }

    public void setDateValue() {
        this.dateValue.setTime();
        this.type = 3;
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return this.dateValue.toString();
            }
        }
        return null;
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
        }
        throw new NumberFormatException("invalid integer format");
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 3: {
                return this.dateValue.getTime();
            }
            case 1: {
                return this.value.toDate(this.dateValue);
            }
        }
        throw new IllegalArgumentException("invalid date format");
    }

    /*
     * Unable to fully structure code
     */
    private int intGetBytes(int var1_1, byte[] var2_2, int var3_3) {
        var4_4 = 1000000000;
        var6_5 = 0;
        if (var1_1 != 0) ** GOTO lbl11
        var2_2[var3_3] = MimeHeaderField.charval[0];
        return 1;
lbl-1000:
        // 1 sources

        {
            var5_6 = var1_1 / var4_4;
            if (var5_6 != 0 || var6_5 > 0) {
                var2_2[var3_3 + var6_5++] = MimeHeaderField.charval[var5_6];
            }
            var1_1 %= var4_4;
            var4_4 /= 10;
lbl11:
            // 2 sources

            ** while (var4_4 > 0)
        }
lbl12:
        // 1 sources

        return var6_5;
    }

    public int getBytes(byte[] byArray, int n) {
        int n2 = n;
        n += this.name.getBytes(byArray, n);
        byArray[n++] = 58;
        byArray[n++] = 32;
        switch (this.type) {
            case 1: {
                n += this.value.getBytes(byArray, n);
                break;
            }
            case 2: {
                n += this.intGetBytes(this.intValue, byArray, n);
                break;
            }
            case 3: {
                n += this.dateValue.getBytes(byArray, n, HttpDate.DATELEN);
                break;
            }
        }
        byArray[n++] = 13;
        byArray[n++] = 10;
        return n - n2;
    }

    public void parse(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte by;
        int n3 = n;
        while ((by = byArray[n++]) != 58 && by != 32) {
            if (by != 10) continue;
            throw new IllegalArgumentException("invalid header format");
        }
        this.setName(byArray, n3, n - n3 - 1);
        while (by == 32) {
            by = byArray[n++];
        }
        if (by != 58) {
            throw new IllegalArgumentException("invalid header format");
        }
        while ((by = byArray[n++]) == 32) {
        }
        this.setValue(byArray, n - 1, n2 - (n - n3 - 1));
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        this.name.write(servletOutputStream);
        servletOutputStream.print(": ");
        switch (this.type) {
            case 1: {
                this.value.write(servletOutputStream);
                servletOutputStream.println();
                return;
            }
            case 2: {
                servletOutputStream.println(this.intValue);
                return;
            }
            case 3: {
                this.dateValue.write(servletOutputStream);
                servletOutputStream.println();
                return;
            }
        }
        servletOutputStream.println();
    }

    public boolean nameEquals(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public boolean nameEquals(byte[] byArray, int n, int n2) {
        return this.name.equalsIgnoreCase(byArray, n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name.toString());
        stringBuffer.append(": ");
        switch (this.type) {
            case 1: {
                stringBuffer.append(this.value.toString());
                break;
            }
            case 2: {
                stringBuffer.append(this.intValue);
                break;
            }
            case 3: {
                stringBuffer.append(this.dateValue.toString());
                break;
            }
        }
        return stringBuffer.toString();
    }
}

