*
* $Id: ctq2opd.F,v 1.1.1.2 1996/10/30 08:27:43 cernlib Exp $
*
* $Log: ctq2opd.F,v $
* Revision 1.1.1.2  1996/10/30 08:27:43  cernlib
* Version 7.04
*
* Revision 1.1.1.1  1996/04/12 15:29:09  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
      FUNCTION Ctq2OPd (Iset, Iprtn, XX, QQ, Irt)

C            Returns xf(x,Q) -- the momentum fraction distribution !!
C            Returns valence and sea rather than combined flavor distr.

C            Iset : PDF set label

C            Iprtn  : Parton label:   2, 1 = d_ and u_ valence
C                                     0 = gluon
C                            -1, ... -6 = u, d, s, c, b, t sea quarks

C            XX  : Bjorken-x
C            QQ  : scale parameter "Q"
C      Irt : Return code
C      0 : no error
C      1 : parametrization is slightly negative; reset to 0.0.
C          (This condition happens rarely -- only for large x where the
C           absolute value of the parton distribution is extremely small.)


C     IMPLICIT DOUBLE PRECISION (A-H, O-Z)
C+SEQ, IMPDP.

      PARAMETER (D0=0D0, D1=1D0, D2=2D0, D3=3D0, D4=4D0, D10=1D1)
      PARAMETER (Nex = 5, MxFl = 6, Npn = 3, Nst = 30, Nexpt=20)
      Parameter (Nst4 = Nst*4)

#include "pdf/expdp.inc"
     +       P012, P34, P5, PDFD
      REAL PDF

      DIMENSION
     >   Iord(Nst), Isch(Nst), Nqrk(Nst),Alm(Nst)
     > , Vlm(4:6,Nst), Qms(4:6, Nst)
     > , Xmn(Nst), Qmn(Nst), Qmx(Nst), Nexp(Nexpt)
     > , Mex(Nst), Mpn(Nst), ExpN(Nexpt, Nst), ExpNor(Nexpt)

C                                          Run le26 - CTEQ2M
C
      DATA
     >  Isch(1), Iord(1), Nqrk(1), Alm(1) /  1,  2,  6, .213  /
     > ,(Vlm(I,1), I=4,6) / .213,    .139,     .053   /
     > ,(Qms(I,1), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(1), Qmn(1), Qmx(1) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(1), Mpn(1), Nexp(1) /  5, 3, 10 /
     > ,(ExpN(I,1), I=1,10 )
     >  / 0.990,1.012,1.022,0.980,1.062,0.870,0.843
     >   ,0.815,0.974,1.029 /

C                                          Run sa17 - CTEQ2MS
C
      DATA
     >  Isch(2), Iord(2), Nqrk(2), Alm(2) /  1,  2,  6, .208  /
     > ,(Vlm(I,2), I=4,6) / .208,    .135,     .051   /
     > ,(Qms(I,2), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(2), Qmn(2), Qmx(2) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(2), Mpn(2), Nexp(2) /  5, 3, 10 /
     > ,(ExpN(I,2), I=1,10 )
     >  / 0.992,1.017,1.023,0.982,1.079,0.879,0.845
     >   ,0.814,0.984,1.036 /

C                                          Run fa06 - CTEQ2MF
C
      DATA
     >  Isch(3), Iord(3), Nqrk(3), Alm(3) /  1,  2,  6, .208  /
     > ,(Vlm(I,3), I=4,6) / .208,    .135,     .051   /
     > ,(Qms(I,3), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(3), Qmn(3), Qmx(3) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(3), Mpn(3), Nexp(3) /  5, 3, 10 /
     > ,(ExpN(I,3), I=1,10 )
     >  / 0.989,1.014,1.021,0.977,1.099,0.812,0.789
     >   ,0.822,0.909,0.950 /

C                                          Run ll25 - CTEQ2ML
C
      DATA
     >  Isch(4), Iord(4), Nqrk(4), Alm(4) /  1,  2,  6, .322  /
     > ,(Vlm(I,4), I=4,6) / .322,    .220,     .088   /
     > ,(Qms(I,4), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(4), Qmn(4), Qmx(4) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(4), Mpn(4), Nexp(4) /  5, 3, 10 /
     > ,(ExpN(I,4), I=1,10 )
     >  / 0.990,1.009,1.022,0.978,1.050,1.027,0.955
     >   ,0.848,0.985,1.053 /

C                                          Run lo24 - CTEQ2L
C
      DATA
     >  Isch(5), Iord(5), Nqrk(5), Alm(5) /  0,  1,  6, .190  /
     > ,(Vlm(I,5), I=4,6) / .190,    .143,     .072   /
     > ,(Qms(I,5), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(5), Qmn(5), Qmx(5) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(5), Mpn(5), Nexp(5) /  5, 3, 10 /
     > ,(ExpN(I,5), I=1,10 )
     >  / 0.990,1.018,1.022,0.982,0.725,0.931,0.855
     >   ,0.795,0.965,1.007 /

C                                          Run da06 - CTEQ2D
C
      DATA
     >  Isch(6), Iord(6), Nqrk(6), Alm(6) /  2,  2,  6, .235  /
     > ,(Vlm(I,6), I=4,6) / .235,    .155,     .060   /
     > ,(Qms(I,6), I=4,6) / 1.60,   5.00,  180.0 /
     > ,Xmn(6), Qmn(6), Qmx(6) /  1.E-5,  1.60,  1.E3  /
     > ,Mex(6), Mpn(6), Nexp(6) /  5, 3, 10 /
     > ,(ExpN(I,6), I=1,10 )
     >  / 0.989,1.019,1.021,0.978,0.961,0.958,0.904
     >   ,0.857,0.965,1.022 /

      Data Ist, Lp, Qsto, Aln2 / 0, -10, 1.2345, 0.6931 /

      SAVE Ist, Lp, Qsto, Alam, SBL, SB, SB2, SB3

      X  = XX
      Irt = 0
      if(Iset.eq.Ist .and. Qsto.eq.QQ) then
C                                             if only change is in x:
        if (Iprtn.eq.Lp) goto 100
C                         if change in flv is within "light" partons:
        if (Iprtn.ge.-3 .and. Lp.ge.-3) goto 501
      endif

      Ip = abs(Iprtn)
C                                                  Set up Qi for SB
      If (Ip .GE. 4) then
         If (QQ .LE. Qms(Ip, Iset)) Then
           Ctq2OPd = 0.0
           Return
         Endif
         Qi = Qms(ip, Iset)
      Else
         Qi = Qmn(Iset)
      Endif
C                   Use "standard lambda" of parametrization program
      Alam = Alm (Iset)

      SBL = LOG(QQ/Alam) / LOG(Qi/Alam)
      SB  = LOG (SBL)
      SB2 = SB*SB
      SB3 = SB2*SB

 501  Iflv = 3 - Iprtn

      Goto (1,2,3,4,5,6, 311) Iset

 1    Goto(11,12,13,14,15,16,17,18,19)Iflv
C   Ifl =   2
  11  A0=Exp( 0.2140E+00+0.1896E+01*SB -0.4966E+01*SB2+0.2354E+01*SB3)
      A1= 0.5210E+00-0.4886E+00*SB +0.1091E+01*SB2-0.5217E+00*SB3
      A2= 0.3178E+01+0.3404E+01*SB -0.6563E+01*SB2+0.3287E+01*SB3
      A3=-0.8550E+00+0.1898E+01*SB -0.4134E+01*SB2+0.2052E+01*SB3
      A4= 0.1821E+01-0.5544E+01*SB +0.9966E+01*SB2-0.4592E+01*SB3
      A5= 0.0000E+00-0.2554E+01*SB +0.6574E+01*SB2-0.3145E+01*SB3
      goto 100
C   Ifl =   1
  12  A0=Exp(-0.1314E+01-0.3117E-01*SB +0.1706E+00*SB2-0.1956E+00*SB3)
      A1= 0.2780E+00+0.2593E-01*SB +0.1416E-01*SB2-0.1153E-01*SB3
      A2= 0.3672E+01+0.5254E+00*SB +0.4441E-01*SB2-0.1651E-02*SB3
      A3= 0.2963E+02-0.1997E+02*SB +0.5682E+01*SB2+0.6001E+00*SB3
      A4= 0.8070E+00-0.2918E+00*SB +0.5498E-01*SB2-0.7655E-02*SB3
      A5= 0.0000E+00+0.2347E+00*SB -0.1332E-01*SB2+0.2772E-01*SB3
      goto 100
C   Ifl =   0
  13  A0=Exp(-0.1060E+00-0.1488E+01*SB -0.2040E+00*SB2+0.4899E-01*SB3)
      A1=-0.2580E+00+0.1448E+00*SB -0.1548E+00*SB2+0.4470E-01*SB3
      A2= 0.5195E+01+0.9257E+00*SB -0.1613E+00*SB2-0.5502E-01*SB3
      A3= 0.5126E+01+0.2061E+01*SB -0.2862E+01*SB2+0.6837E+00*SB3
      A4= 0.1118E+01+0.2549E+00*SB -0.5194E+00*SB2+0.1831E+00*SB3
      A5= 0.0000E+00+0.2507E+01*SB -0.9946E+00*SB2+0.2547E+00*SB3
      goto 100
C   Ifl =  -1
  14  A0=Exp(-0.1141E+00-0.3683E+01*SB +0.4654E+01*SB2-0.2191E+01*SB3)
      A1=-0.4269E+00-0.4266E-01*SB -0.1957E+00*SB2+0.1341E+00*SB3
      A2= 0.9960E+01-0.3425E+01*SB +0.4851E+01*SB2-0.2131E+01*SB3
      A3=-0.6381E+00+0.9855E+00*SB -0.1629E+01*SB2+0.7407E+00*SB3
      A4= 0.3091E-03-0.1846E+00*SB +0.2512E+00*SB2-0.1031E+00*SB3
      A5=-0.1310E+01+0.1654E+01*SB -0.1672E+01*SB2+0.8606E+00*SB3
      goto 100
C   Ifl =  -2
  15  A0=Exp(-0.2025E+01-0.4256E+01*SB +0.4815E+01*SB2-0.1907E+01*SB3)
      A1=-0.2622E+00+0.2118E+00*SB -0.2479E+00*SB2+0.6284E-01*SB3
      A2= 0.9113E+01-0.2913E+01*SB +0.5533E+01*SB2-0.2438E+01*SB3
      A3= 0.2999E+02+0.2693E+02*SB -0.2000E+02*SB2-0.4426E+00*SB3
      A4= 0.1524E+01-0.9878E+00*SB +0.1582E+01*SB2-0.7228E+00*SB3
      A5=-0.2241E+00+0.3366E+01*SB -0.3198E+01*SB2+0.1113E+01*SB3
      goto 100
C   Ifl =  -3
  16  A0=Exp(-0.1855E+01-0.5294E+01*SB +0.7825E+00*SB2-0.5312E-01*SB3)
      A1=-0.4000E-02-0.1379E+01*SB +0.1215E+01*SB2-0.6000E-02*SB3
      A2= 0.6870E+01+0.1088E+01*SB -0.5497E+00*SB2-0.1920E+00*SB3
      A3= 0.0000E+00+0.4829E+01*SB +0.8971E+01*SB2+0.2999E+02*SB3
      A4= 0.1000E-02+0.3239E+00*SB -0.2326E+00*SB2-0.2922E+00*SB3
      A5= 0.0000E+00-0.2450E+01*SB +0.3630E+01*SB2-0.1137E+01*SB3
      goto 100
C   Ifl =  -4
  17  A0=SB** 0.4376E+00*Exp(-0.6933E+01+0.2995E+01*SB -0.2304E+01*SB2)
      A1=-0.4228E+00+0.1222E+01*SB -0.1971E+01*SB2+0.8951E+00*SB3
      A2= 0.6926E+01-0.1031E+02*SB +0.1468E+02*SB2-0.6065E+01*SB3
      A3= 0.8573E+01-0.1998E+02*SB +0.1965E+02*SB2-0.4859E+01*SB3
      A4= 0.9299E-01-0.4951E+00*SB +0.6898E+00*SB2-0.1069E+00*SB3
      A5=-0.5687E-01+0.5526E+01*SB -0.7217E+01*SB2+0.3569E+01*SB3
      goto 100
C   Ifl =  -5
  18  A0=SB** 0.2274E+00*Exp(-0.2564E+01-0.7256E+01*SB +0.4891E+01*SB2)
      A1=-0.1423E+00-0.5363E+00*SB +0.9826E+00*SB2-0.6096E+00*SB3
      A2= 0.6238E+01-0.2785E+01*SB +0.5089E+00*SB2+0.2333E+01*SB3
      A3=-0.1029E+01+0.4684E+00*SB +0.3126E+01*SB2-0.2893E+01*SB3
      A4= 0.1729E-01+0.7293E-01*SB -0.5278E+00*SB2+0.3967E+00*SB3
      A5= 0.6208E+00+0.3942E+01*SB -0.3736E+01*SB2+0.1039E+01*SB3
      goto 100
C   Ifl =  -6
  19  A0=SB** 0.6663E+00*Exp(-0.7572E+01+0.4202E+01*SB -0.7464E+01*SB2)
      A1=-0.1951E+00-0.1041E+01*SB +0.6688E+01*SB2-0.9976E+01*SB3
      A2= 0.5920E+01-0.7929E+01*SB +0.2997E+02*SB2+0.2991E+02*SB3
      A3= 0.1616E+01-0.9668E+01*SB +0.2995E+02*SB2+0.3000E+02*SB3
      A4= 0.4595E+00-0.3761E+01*SB +0.5663E+01*SB2+0.2066E+01*SB3
      A5= 0.2664E+01+0.1067E+00*SB -0.9717E+01*SB2+0.9980E+01*SB3
      goto 100

 2    Goto(21,22,23,24,25,26,27,28,29)Iflv
C   Ifl =   2
  21  A0=Exp( 0.2790E+00+0.1526E+01*SB -0.4306E+01*SB2+0.2060E+01*SB3)
      A1= 0.5380E+00-0.4199E+00*SB +0.9582E+00*SB2-0.4624E+00*SB3
      A2= 0.3259E+01+0.3236E+01*SB -0.6130E+01*SB2+0.3073E+01*SB3
      A3=-0.8390E+00+0.2092E+01*SB -0.4528E+01*SB2+0.2251E+01*SB3
      A4= 0.1847E+01-0.5377E+01*SB +0.9994E+01*SB2-0.4699E+01*SB3
      A5= 0.0000E+00-0.2097E+01*SB +0.5742E+01*SB2-0.2774E+01*SB3
      goto 100
C   Ifl =   1
  22  A0=Exp(-0.1318E+01+0.2387E-01*SB +0.4416E-01*SB2-0.1337E+00*SB3)
      A1= 0.2760E+00+0.4302E-01*SB -0.1992E-01*SB2+0.2945E-02*SB3
      A2= 0.3660E+01+0.5319E+00*SB +0.2772E-01*SB2+0.1030E-01*SB3
      A3= 0.2910E+02-0.2000E+02*SB +0.6756E+01*SB2-0.1017E-01*SB3
      A4= 0.8010E+00-0.2702E+00*SB +0.1663E-01*SB2+0.8604E-02*SB3
      A5= 0.0000E+00+0.2822E+00*SB -0.1064E+00*SB2+0.6349E-01*SB3
      goto 100
C   Ifl =   0
  23  A0=Exp(-0.1623E+01-0.1156E+01*SB +0.7802E+00*SB2-0.3593E-01*SB3)
      A1=-0.5000E+00-0.2854E-01*SB +0.2212E+00*SB2-0.9403E-01*SB3
      A2= 0.3821E+01+0.8254E+00*SB +0.5031E+00*SB2-0.3367E+00*SB3
      A3= 0.5809E+01-0.3042E+01*SB -0.2726E+01*SB2+0.1371E+01*SB3
      A4= 0.4500E+00-0.6445E+00*SB +0.3019E+00*SB2-0.5642E-01*SB3
      A5= 0.0000E+00+0.8833E+00*SB -0.8495E-01*SB2+0.1565E+00*SB3
      goto 100
C   Ifl =  -1
  24  A0=Exp(-0.2693E-01-0.5523E+00*SB -0.1741E+01*SB2+0.6360E+00*SB3)
      A1=-0.8634E+00+0.2368E+00*SB +0.8493E-01*SB2-0.6031E-01*SB3
      A2= 0.1200E+02+0.2398E+01*SB -0.6554E+01*SB2+0.2441E+01*SB3
      A3= 0.2528E+02+0.3000E+02*SB +0.2826E+02*SB2-0.2000E+02*SB3
      A4= 0.4000E+01-0.1239E+01*SB +0.2344E+01*SB2-0.5239E+00*SB3
      A5=-0.3466E+01+0.1731E+01*SB +0.1155E+01*SB2-0.5539E+00*SB3
      goto 100
C   Ifl =  -2
  25  A0=Exp(-0.1881E+01-0.2404E+01*SB +0.2946E+01*SB2-0.1553E+01*SB3)
      A1=-0.6715E+00+0.4590E+00*SB -0.4233E+00*SB2+0.1678E+00*SB3
      A2= 0.9530E+01-0.2395E+01*SB +0.4102E+01*SB2-0.1921E+01*SB3
      A3= 0.1828E+02+0.3982E+00*SB -0.7874E+01*SB2+0.5451E+01*SB3
      A4= 0.1019E+01-0.1596E+00*SB +0.5041E+00*SB2-0.2586E+00*SB3
      A5=-0.1804E+01+0.3477E+01*SB -0.3082E+01*SB2+0.1389E+01*SB3
      goto 100
C   Ifl =  -3
  26  A0=Exp(-0.3180E+01-0.4460E+01*SB +0.2338E+01*SB2-0.6414E+00*SB3)
      A1=-0.3873E+00-0.4457E+00*SB +0.1845E+00*SB2+0.2391E-01*SB3
      A2= 0.9287E+01-0.3698E+01*SB +0.2525E+01*SB2-0.8127E+00*SB3
      A3= 0.8968E+01+0.2853E+02*SB -0.9043E+01*SB2-0.1270E+01*SB3
      A4= 0.4911E-02-0.1111E+00*SB +0.6279E+00*SB2-0.3286E+00*SB3
      A5=-0.1892E+01+0.1020E+01*SB +0.1200E+01*SB2-0.5246E+00*SB3
      goto 100
C   Ifl =  -4
  27  A0=SB** 0.5061E+00*Exp(-0.6545E+01+0.2128E+01*SB -0.2682E+01*SB2)
      A1=-0.6422E+00+0.1348E+01*SB -0.2112E+01*SB2+0.1023E+01*SB3
      A2= 0.8633E+01-0.1098E+02*SB +0.1297E+02*SB2-0.5481E+01*SB3
      A3= 0.1094E+02-0.1999E+02*SB +0.1569E+02*SB2+0.1640E+01*SB3
      A4= 0.6101E-01-0.4030E+00*SB +0.6944E+00*SB2-0.1071E+00*SB3
      A5=-0.1031E+01+0.6066E+01*SB -0.7177E+01*SB2+0.3941E+01*SB3
      goto 100
C   Ifl =  -5
  28  A0=SB** 0.9548E+00*Exp(-0.3509E+01-0.4622E+01*SB +0.2158E+01*SB2)
      A1=-0.3843E+00+0.3255E-01*SB +0.1015E+01*SB2-0.8073E+00*SB3
      A2= 0.7119E+01-0.6982E+01*SB +0.1057E+02*SB2-0.5042E+01*SB3
      A3=-0.2830E+00+0.6828E+00*SB +0.3744E+01*SB2-0.3577E+01*SB3
      A4=-0.7753E-02-0.6807E-01*SB -0.5997E+00*SB2+0.5024E+00*SB3
      A5= 0.5160E+00+0.2897E+01*SB -0.1816E+01*SB2+0.5683E+00*SB3
      goto 100
C   Ifl =  -6
  29  A0=SB** 0.6174E+00*Exp(-0.7663E+01+0.7381E+01*SB +0.1136E+01*SB2)
      A1=-0.8717E-01-0.2683E+01*SB +0.9103E+01*SB2-0.7527E+01*SB3
      A2= 0.6726E+01-0.9855E+01*SB +0.2906E+02*SB2+0.2793E+02*SB3
      A3= 0.1893E+01-0.1341E+02*SB +0.1923E+02*SB2-0.4600E+01*SB3
      A4=-0.2237E+00+0.1519E+01*SB +0.3735E+00*SB2-0.7050E+01*SB3
      A5= 0.1873E+01+0.2195E+01*SB -0.8159E+01*SB2+0.6019E+01*SB3
      goto 100

 3    Goto(31,32,33,34,35,36,37,38,39)Iflv
C   Ifl =   2
  31  A0=Exp( 0.1670E+00+0.1075E+01*SB -0.3383E+01*SB2+0.1614E+01*SB3)
      A1= 0.5080E+00-0.3170E+00*SB +0.7692E+00*SB2-0.3742E+00*SB3
      A2= 0.3243E+01+0.4730E+01*SB -0.8685E+01*SB2+0.4224E+01*SB3
      A3=-0.8320E+00+0.5206E+01*SB -0.1064E+02*SB2+0.5154E+01*SB3
      A4= 0.2189E+01-0.1541E+01*SB +0.3218E+01*SB2-0.1573E+01*SB3
      A5= 0.0000E+00-0.1513E+01*SB +0.4587E+01*SB2-0.2226E+01*SB3
      goto 100
C   Ifl =   1
  32  A0=Exp(-0.1344E+01-0.1748E-01*SB +0.1351E+00*SB2-0.1933E+00*SB3)
      A1= 0.2760E+00+0.3213E-01*SB +0.4936E-02*SB2-0.9453E-02*SB3
      A2= 0.3660E+01+0.5253E+00*SB +0.4304E-01*SB2+0.5047E-03*SB3
      A3= 0.2982E+02-0.2000E+02*SB +0.5957E+01*SB2+0.6646E+00*SB3
      A4= 0.7950E+00-0.2861E+00*SB +0.5038E-01*SB2-0.5960E-02*SB3
      A5= 0.0000E+00+0.2441E+00*SB -0.2216E-01*SB2+0.2776E-01*SB3
      goto 100
C   Ifl =   0
  33  A0=Exp( 0.1116E+01-0.3529E+01*SB +0.1456E+01*SB2-0.1419E+00*SB3)
      A1= 0.0000E+00-0.5181E+00*SB +0.5405E+00*SB2-0.2205E+00*SB3
      A2= 0.6529E+01-0.1407E+01*SB +0.5685E-01*SB2+0.3105E+00*SB3
      A3= 0.2643E+01-0.5811E+01*SB +0.4343E+01*SB2-0.1257E+01*SB3
      A4= 0.2221E+01-0.3929E+01*SB +0.2208E+01*SB2-0.3916E+00*SB3
      A5= 0.0000E+00+0.2176E+01*SB -0.8498E+00*SB2+0.2041E+00*SB3
      goto 100
C   Ifl =  -1
  34  A0=Exp(-0.6345E+00-0.3473E+01*SB +0.3619E+01*SB2-0.1521E+01*SB3)
      A1=-0.2746E-01-0.2354E+00*SB -0.9563E-01*SB2+0.9076E-01*SB3
      A2= 0.9349E+01-0.2734E+01*SB +0.4205E+01*SB2-0.1868E+01*SB3
      A3=-0.4148E+00+0.1275E+01*SB -0.1762E+01*SB2+0.6678E+00*SB3
      A4=-0.6941E-02-0.3389E-01*SB +0.2910E-01*SB2-0.7428E-03*SB3
      A5=-0.2328E+00+0.1099E+01*SB -0.1257E+01*SB2+0.6759E+00*SB3
      goto 100
C   Ifl =  -2
  35  A0=Exp(-0.1043E+01-0.4115E+01*SB +0.4084E+01*SB2-0.1564E+01*SB3)
      A1=-0.4823E-01+0.5433E-02*SB -0.3178E+00*SB2+0.1413E+00*SB3
      A2= 0.1038E+02-0.3667E+01*SB +0.4441E+01*SB2-0.1471E+01*SB3
      A3= 0.3729E+02-0.1991E+02*SB +0.2565E+01*SB2+0.3049E+01*SB3
      A4= 0.1831E+01-0.1349E+01*SB +0.1416E+01*SB2-0.4872E+00*SB3
      A5=-0.3255E+00+0.3095E+01*SB -0.3465E+01*SB2+0.1337E+01*SB3
      goto 100
C   Ifl =  -3
  36  A0=Exp(-0.2887E+01-0.4406E+01*SB +0.1392E+01*SB2-0.2654E+00*SB3)
      A1=-0.1081E+00-0.1614E+00*SB -0.1005E+00*SB2+0.5118E-01*SB3
      A2= 0.7105E+01-0.1613E+01*SB +0.1555E+01*SB2-0.4143E+00*SB3
      A3= 0.9845E+00+0.7054E+01*SB +0.9067E+01*SB2+0.4381E+00*SB3
      A4= 0.4347E-01-0.4131E-01*SB +0.4727E+00*SB2-0.2627E+00*SB3
      A5= 0.1497E+00+0.7286E+00*SB +0.1079E+01*SB2-0.6934E+00*SB3
      goto 100
C   Ifl =  -4
  37  A0=SB** 0.5386E+00*Exp(-0.6447E+01+0.1532E+01*SB -0.2501E+01*SB2)
      A1=-0.2340E+00+0.1158E+01*SB -0.2199E+01*SB2+0.1110E+01*SB3
      A2= 0.9582E+01-0.1232E+02*SB +0.1417E+02*SB2-0.5780E+01*SB3
      A3= 0.1136E+02-0.1977E+02*SB +0.1412E+02*SB2+0.4260E+01*SB3
      A4= 0.4897E-01-0.3630E+00*SB +0.6748E+00*SB2-0.8826E-01*SB3
      A5= 0.1638E+00+0.5938E+01*SB -0.7697E+01*SB2+0.4287E+01*SB3
      goto 100
C   Ifl =  -5
  38  A0=SB** 0.6821E+00*Exp(-0.3091E+01-0.6402E+01*SB +0.3642E+01*SB2)
      A1=-0.6025E-01-0.3351E+00*SB +0.6665E+00*SB2-0.4328E+00*SB3
      A2= 0.7107E+01-0.2327E+01*SB +0.1482E+01*SB2+0.6384E+00*SB3
      A3=-0.9249E+00+0.1607E+01*SB +0.3734E+01*SB2-0.3985E+01*SB3
      A4= 0.5565E-01+0.5489E-01*SB -0.5636E+00*SB2+0.4372E+00*SB3
      A5= 0.1252E+01+0.2915E+01*SB -0.2690E+01*SB2+0.8944E+00*SB3
      goto 100
C   Ifl =  -6
  39  A0=SB** 0.5589E+00*Exp(-0.8150E+01+0.5395E+01*SB -0.6026E+00*SB2)
      A1=-0.1062E-01-0.2427E+01*SB +0.8547E+01*SB2-0.6318E+01*SB3
      A2= 0.6721E+01-0.8373E+01*SB +0.2805E+02*SB2+0.2977E+02*SB3
      A3= 0.1926E+01-0.5905E+01*SB +0.2880E+01*SB2-0.1004E+02*SB3
      A4=-0.1701E+00+0.1258E+01*SB +0.4202E+01*SB2-0.9911E+01*SB3
      A5= 0.2429E+01+0.2037E+01*SB -0.2878E+01*SB2+0.3858E+01*SB3
      goto 100

 4    Goto(41,42,43,44,45,46,47,48,49)Iflv
C   Ifl =   2
  41  A0=Exp( 0.3760E+00+0.8053E+00*SB -0.2513E+01*SB2+0.1042E+01*SB3)
      A1= 0.5650E+00-0.2477E+00*SB +0.5156E+00*SB2-0.2174E+00*SB3
      A2= 0.3464E+01+0.4958E+01*SB -0.8038E+01*SB2+0.3416E+01*SB3
      A3=-0.5850E+00+0.7780E+01*SB -0.1388E+02*SB2+0.5883E+01*SB3
      A4= 0.2322E+01-0.1325E+01*SB +0.2338E+01*SB2-0.9912E+00*SB3
      A5= 0.0000E+00-0.1051E+01*SB +0.3148E+01*SB2-0.1331E+01*SB3
      goto 100
C   Ifl =   1
  42  A0=Exp(-0.1324E+01+0.4762E-01*SB -0.9509E-01*SB2-0.1792E-01*SB3)
      A1= 0.2890E+00+0.6535E-01*SB -0.3082E-01*SB2+0.1996E-03*SB3
      A2= 0.3580E+01+0.5494E+00*SB -0.6856E-01*SB2+0.6323E-01*SB3
      A3= 0.3021E+02-0.2000E+02*SB +0.7011E+01*SB2-0.7697E+00*SB3
      A4= 0.7990E+00-0.2426E+00*SB +0.8071E-03*SB2+0.4460E-02*SB3
      A5= 0.0000E+00+0.3810E+00*SB -0.8815E-01*SB2-0.3724E-02*SB3
      goto 100
C   Ifl =   0
  43  A0=Exp(-0.1920E+00-0.1130E+01*SB -0.2375E+00*SB2+0.4022E-01*SB3)
      A1=-0.2120E+00+0.6095E-01*SB -0.9243E-01*SB2+0.2470E-01*SB3
      A2= 0.4549E+01+0.9281E+00*SB +0.4614E-01*SB2-0.4467E-01*SB3
      A3= 0.1197E+02-0.3295E+01*SB -0.1085E+01*SB2+0.4984E+00*SB3
      A4= 0.1616E+01-0.1152E+00*SB -0.3057E+00*SB2+0.1216E+00*SB3
      A5= 0.0000E+00+0.2254E+01*SB -0.8923E+00*SB2+0.2191E+00*SB3
      goto 100
C   Ifl =  -1
  44  A0=Exp(-0.1409E+01-0.8736E+00*SB -0.3396E+00*SB2+0.1329E+00*SB3)
      A1=-0.2732E+00-0.7161E-01*SB +0.8535E-01*SB2-0.4319E-01*SB3
      A2= 0.9948E+01-0.2571E+01*SB +0.5435E+00*SB2+0.1048E+00*SB3
      A3= 0.3191E+02-0.6723E+01*SB -0.2000E+02*SB2+0.9788E+01*SB3
      A4= 0.3999E+01+0.2953E+00*SB -0.9248E+00*SB2+0.5909E+00*SB3
      A5=-0.6366E+00+0.6347E+00*SB +0.5611E+00*SB2-0.2659E+00*SB3
      goto 100
C   Ifl =  -2
  45  A0=Exp(-0.1935E+01-0.3640E+01*SB +0.3418E+01*SB2-0.1162E+01*SB3)
      A1=-0.2333E+00+0.3532E+00*SB -0.4772E+00*SB2+0.1515E+00*SB3
      A2= 0.1009E+02-0.4327E+01*SB +0.4977E+01*SB2-0.1588E+01*SB3
      A3= 0.4998E+02-0.1658E+02*SB -0.1299E+01*SB2+0.1680E+01*SB3
      A4= 0.1717E+01-0.8842E+00*SB +0.8121E+00*SB2-0.2623E+00*SB3
      A5=-0.1852E+00+0.3591E+01*SB -0.3439E+01*SB2+0.1119E+01*SB3
      goto 100
C   Ifl =  -3
  46  A0=Exp(-0.1864E+01-0.3708E+01*SB -0.5756E+00*SB2+0.4375E+00*SB3)
      A1= 0.1000E-02-0.1191E+01*SB +0.1129E+01*SB2-0.1823E+00*SB3
      A2= 0.6898E+01+0.7131E+00*SB -0.1816E+01*SB2+0.7422E+00*SB3
      A3= 0.0000E+00+0.3461E+01*SB +0.5716E+01*SB2+0.1099E+02*SB3
      A4= 0.1000E-02+0.2346E+00*SB -0.2442E+00*SB2-0.8945E-01*SB3
      A5= 0.0000E+00-0.2307E+01*SB +0.3654E+01*SB2-0.1229E+01*SB3
      goto 100
C   Ifl =  -4
  47  A0=SB** 0.5944E+00*Exp(-0.6580E+01+0.1186E+01*SB -0.8149E+00*SB2)
      A1=-0.4012E+00+0.1013E+01*SB -0.1345E+01*SB2+0.4858E+00*SB3
      A2= 0.5745E+01-0.1001E+02*SB +0.1332E+02*SB2-0.4777E+01*SB3
      A3= 0.9501E+01-0.2000E+02*SB +0.2158E+02*SB2-0.7159E+01*SB3
      A4= 0.1330E+00-0.5430E+00*SB +0.6810E+00*SB2-0.2441E+00*SB3
      A5= 0.7665E-01+0.4725E+01*SB -0.5315E+01*SB2+0.1948E+01*SB3
      goto 100
C   Ifl =  -5
  48  A0=SB** 0.1171E+00*Exp(-0.4100E+01-0.4162E+01*SB +0.2139E+01*SB2)
      A1=-0.1266E+00-0.3860E+00*SB +0.5611E+00*SB2-0.2887E+00*SB3
      A2= 0.4416E+01-0.2970E+00*SB +0.8367E-01*SB2+0.5844E+00*SB3
      A3=-0.1007E+01+0.7322E+00*SB +0.4878E+01*SB2-0.3640E+01*SB3
      A4= 0.1202E-01+0.2368E+00*SB -0.6270E+00*SB2+0.3810E+00*SB3
      A5= 0.1117E+01+0.2026E+01*SB -0.1649E+01*SB2+0.5582E+00*SB3
      goto 100
C   Ifl =  -6
  49  A0=SB** 0.4778E+00*Exp(-0.8672E+01+0.7464E+01*SB -0.2952E+01*SB2)
      A1=-0.2503E-01-0.2713E+01*SB +0.9002E+01*SB2-0.6336E+01*SB3
      A2= 0.6266E+01-0.1191E+02*SB +0.2982E+02*SB2-0.7350E+01*SB3
      A3= 0.2402E+01-0.7116E+01*SB -0.9642E+01*SB2+0.2415E+02*SB3
      A4=-0.2056E+00+0.1537E+01*SB +0.2850E+01*SB2-0.9850E+01*SB3
      A5= 0.2237E+01+0.2495E+01*SB -0.6424E+01*SB2+0.9998E+01*SB3
      goto 100

 5    Goto(51,52,53,54,55,56,57,58,59)Iflv
C   Ifl =   2
  51  A0=Exp( 0.8000E-01+0.7364E+00*SB -0.2714E+01*SB2+0.1311E+01*SB3)
      A1= 0.4930E+00-0.2001E+00*SB +0.5784E+00*SB2-0.2915E+00*SB3
      A2= 0.3001E+01+0.3538E+01*SB -0.6155E+01*SB2+0.3083E+01*SB3
      A3=-0.1000E+01+0.3871E+01*SB -0.8334E+01*SB2+0.4219E+01*SB3
      A4= 0.2986E+01+0.1597E+01*SB -0.3368E+01*SB2+0.1644E+01*SB3
      A5= 0.0000E+00-0.9256E+00*SB +0.3570E+01*SB2-0.1777E+01*SB3
      goto 100
C   Ifl =   1
  52  A0=Exp(-0.1806E+01-0.6672E-01*SB -0.2605E+00*SB2+0.2341E-01*SB3)
      A1= 0.1750E+00+0.3872E-01*SB -0.2189E-01*SB2+0.1415E-01*SB3
      A2= 0.3322E+01+0.7786E+00*SB -0.2902E+00*SB2+0.1517E+00*SB3
      A3= 0.4414E+02-0.1987E+02*SB +0.2597E+01*SB2+0.2670E+01*SB3
      A4= 0.9610E+00-0.2864E+00*SB -0.5524E-01*SB2+0.6229E-01*SB3
      A5= 0.0000E+00+0.2658E+00*SB -0.4728E-02*SB2+0.6048E-01*SB3
      goto 100
C   Ifl =   0
  53  A0=Exp(-0.6510E+00-0.1128E+01*SB -0.6239E-01*SB2-0.8838E-01*SB3)
      A1=-0.2590E+00+0.1822E+00*SB -0.2682E+00*SB2+0.9422E-01*SB3
      A2= 0.4607E+01+0.7792E+00*SB +0.8937E+00*SB2-0.5553E+00*SB3
      A3= 0.1627E+02-0.1114E+02*SB +0.4928E+01*SB2-0.1715E+01*SB3
      A4= 0.1236E+01+0.1945E+00*SB -0.3297E+00*SB2+0.6489E-01*SB3
      A5= 0.0000E+00+0.3346E+01*SB -0.2337E+01*SB2+0.7850E+00*SB3
      goto 100
C   Ifl =  -1
  54  A0=Exp(-0.1508E+01-0.5560E+00*SB -0.3523E+00*SB2+0.6562E-01*SB3)
      A1=-0.3223E+00+0.2095E-01*SB -0.2049E-02*SB2-0.3475E-01*SB3
      A2= 0.9469E+01-0.3923E+01*SB +0.4333E+01*SB2-0.1654E+01*SB3
      A3= 0.1646E+02-0.1082E+02*SB +0.8941E+01*SB2-0.5494E+01*SB3
      A4= 0.2908E+01+0.2162E+01*SB -0.3233E+01*SB2+0.1267E+01*SB3
      A5=-0.5819E+00+0.3914E+00*SB +0.6460E+00*SB2-0.3239E+00*SB3
      goto 100
C   Ifl =  -2
  55  A0=Exp(-0.1951E+01-0.3435E+01*SB +0.3424E+01*SB2-0.1249E+01*SB3)
      A1=-0.2942E+00+0.4408E+00*SB -0.5453E+00*SB2+0.1552E+00*SB3
      A2= 0.9782E+01-0.3454E+01*SB +0.4510E+01*SB2-0.1649E+01*SB3
      A3= 0.4999E+02-0.1993E+02*SB -0.2039E+01*SB2+0.5694E+00*SB3
      A4= 0.1938E+01-0.1351E+01*SB +0.1386E+01*SB2-0.5324E+00*SB3
      A5=-0.2410E+00+0.3434E+01*SB -0.3334E+01*SB2+0.1067E+01*SB3
      goto 100
C   Ifl =  -3
  56  A0=Exp(-0.1804E+01-0.4381E+01*SB -0.3699E+00*SB2+0.3878E+00*SB3)
      A1=-0.1000E-02-0.9334E+00*SB +0.7156E+00*SB2-0.2029E+00*SB3
      A2= 0.6896E+01+0.2462E+01*SB -0.2885E+01*SB2+0.8701E+00*SB3
      A3= 0.0000E+00+0.5589E+01*SB +0.1047E+02*SB2+0.3000E+02*SB3
      A4= 0.1000E-02-0.5600E-02*SB +0.5618E-02*SB2+0.6598E-02*SB3
      A5= 0.0000E+00-0.3151E+01*SB +0.4025E+01*SB2-0.1232E+01*SB3
      goto 100
C   Ifl =  -4
  57  A0=SB** 0.7860E+00*Exp(-0.5041E+01-0.3357E+00*SB -0.4718E+00*SB2)
      A1=-0.4989E+00+0.9571E+00*SB -0.1359E+01*SB2+0.5384E+00*SB3
      A2= 0.5986E+01-0.8541E+01*SB +0.1274E+02*SB2-0.5275E+01*SB3
      A3= 0.8121E+01-0.1753E+02*SB +0.2194E+02*SB2-0.8538E+01*SB3
      A4= 0.9290E-01-0.4390E+00*SB +0.6162E+00*SB2-0.2231E+00*SB3
      A5=-0.1257E+01+0.5677E+01*SB -0.5977E+01*SB2+0.2387E+01*SB3
      goto 100
C   Ifl =  -5
  58  A0=SB** 0.4537E+00*Exp(-0.3269E+01-0.5398E+01*SB +0.2893E+01*SB2)
      A1=-0.1977E+00-0.4126E+00*SB +0.7058E+00*SB2-0.4038E+00*SB3
      A2= 0.4522E+01+0.6167E-01*SB -0.1849E+00*SB2+0.7345E+00*SB3
      A3=-0.1003E+01+0.1531E+01*SB +0.4515E+01*SB2-0.4368E+01*SB3
      A4= 0.3579E-01+0.1919E+00*SB -0.7268E+00*SB2+0.5192E+00*SB3
      A5= 0.5129E+00+0.2447E+01*SB -0.1989E+01*SB2+0.7529E+00*SB3
      goto 100
C   Ifl =  -6
  59  A0=SB** 0.7178E+00*Exp(-0.7327E+01+0.2277E+01*SB +0.3913E+01*SB2)
      A1=-0.9842E-01-0.2362E+01*SB +0.8851E+01*SB2-0.7208E+01*SB3
      A2= 0.5552E+01-0.8935E+01*SB +0.2676E+02*SB2-0.1344E+02*SB3
      A3= 0.1593E+01-0.3505E+01*SB -0.1234E+01*SB2-0.1867E+02*SB3
      A4=-0.1723E+00+0.1530E+01*SB +0.2323E+01*SB2-0.9344E+01*SB3
      A5= 0.2081E+01+0.1939E+01*SB -0.3273E+01*SB2+0.9935E+01*SB3
      goto 100

 6    Goto(61,62,63,64,65,66,67,68,69)Iflv
C   Ifl =   2
  61  A0=Exp( 0.1590E+00+0.8361E+00*SB -0.2713E+01*SB2+0.1231E+01*SB3)
      A1= 0.5110E+00-0.2081E+00*SB +0.5090E+00*SB2-0.2365E+00*SB3
      A2= 0.3158E+01+0.4946E+01*SB -0.8738E+01*SB2+0.4063E+01*SB3
      A3=-0.6000E+00+0.7591E+01*SB -0.1479E+02*SB2+0.6851E+01*SB3
      A4= 0.2306E+01-0.1913E+01*SB +0.3615E+01*SB2-0.1663E+01*SB3
      A5= 0.0000E+00-0.9682E+00*SB +0.3247E+01*SB2-0.1503E+01*SB3
      goto 100
C   Ifl =   1
  62  A0=Exp(-0.1182E+01+0.1223E+00*SB +0.6512E-01*SB2-0.1208E+00*SB3)
      A1= 0.2540E+00+0.2297E-01*SB -0.4249E-02*SB2+0.1143E-03*SB3
      A2= 0.3442E+01+0.5458E+00*SB +0.3803E-01*SB2-0.1598E-02*SB3
      A3= 0.2545E+02-0.2000E+02*SB +0.7516E+01*SB2-0.7726E+00*SB3
      A4= 0.9170E+00-0.3214E+00*SB +0.4666E-01*SB2-0.5126E-02*SB3
      A5= 0.0000E+00+0.1379E+00*SB -0.4579E-01*SB2+0.4988E-01*SB3
      goto 100
C   Ifl =   0
  63  A0=Exp(-0.3410E+00-0.9586E+00*SB -0.4561E+00*SB2+0.1041E+00*SB3)
      A1=-0.2400E+00+0.1498E+00*SB -0.1717E+00*SB2+0.4922E-01*SB3
      A2= 0.4841E+01+0.8606E+00*SB +0.1611E+00*SB2-0.1785E+00*SB3
      A3= 0.7427E+01-0.2102E+01*SB +0.1371E+01*SB2-0.8831E+00*SB3
      A4= 0.9600E+00+0.3385E+00*SB -0.3549E+00*SB2+0.8291E-01*SB3
      A5= 0.0000E+00+0.2516E+01*SB -0.1115E+01*SB2+0.2961E+00*SB3
      goto 100
C   Ifl =  -1
  64  A0=Exp( 0.3709E-01-0.3427E+01*SB +0.4188E+01*SB2-0.1910E+01*SB3)
      A1=-0.3664E+00+0.1406E+00*SB -0.1340E+00*SB2+0.2966E-01*SB3
      A2= 0.1093E+02-0.3215E+01*SB +0.1803E+01*SB2-0.3219E+00*SB3
      A3=-0.7324E+00+0.9441E+00*SB -0.1698E+01*SB2+0.7797E+00*SB3
      A4= 0.7923E-01-0.5296E-01*SB +0.9541E-01*SB2-0.4648E-01*SB3
      A5=-0.1426E+01+0.2324E+01*SB -0.1860E+01*SB2+0.7350E+00*SB3
      goto 100
C   Ifl =  -2
  65  A0=Exp(-0.2396E+01-0.2506E+01*SB +0.3192E+01*SB2-0.1398E+01*SB3)
      A1=-0.2366E+00+0.3132E+00*SB -0.5087E+00*SB2+0.1892E+00*SB3
      A2= 0.9013E+01-0.2295E+01*SB +0.4380E+01*SB2-0.1909E+01*SB3
      A3= 0.4999E+02-0.1713E+02*SB -0.1184E+01*SB2+0.5404E+00*SB3
      A4= 0.1739E+01-0.7946E+00*SB +0.9877E+00*SB2-0.4258E+00*SB3
      A5= 0.3889E-01+0.2840E+01*SB -0.3389E+01*SB2+0.1358E+01*SB3
      goto 100
C   Ifl =  -3
  66  A0=Exp(-0.1966E+01-0.4423E+01*SB -0.2825E+00*SB2+0.4253E+00*SB3)
      A1=-0.4000E-02-0.1327E+01*SB +0.1367E+01*SB2-0.4343E+00*SB3
      A2= 0.6902E+01+0.2127E+01*SB -0.3095E+01*SB2+0.1140E+01*SB3
      A3= 0.0000E+00+0.4494E+01*SB +0.1085E+02*SB2+0.2149E+02*SB3
      A4= 0.1000E-02+0.3120E+00*SB -0.3684E+00*SB2+0.1059E+00*SB3
      A5= 0.0000E+00-0.2796E+01*SB +0.4415E+01*SB2-0.1559E+01*SB3
      goto 100
C   Ifl =  -4
  67  A0=SB** 0.5299E+00*Exp(-0.6308E+01+0.2148E+01*SB -0.1356E+01*SB2)
      A1=-0.4240E+00+0.1047E+01*SB -0.1558E+01*SB2+0.6376E+00*SB3
      A2= 0.6562E+01-0.9971E+01*SB +0.1510E+02*SB2-0.6222E+01*SB3
      A3= 0.8340E+01-0.1952E+02*SB +0.2047E+02*SB2-0.6962E+01*SB3
      A4= 0.9903E-01-0.4558E+00*SB +0.5885E+00*SB2-0.1425E+00*SB3
      A5=-0.3086E+00+0.5061E+01*SB -0.6202E+01*SB2+0.2690E+01*SB3
      goto 100
C   Ifl =  -5
  68  A0=SB** 0.2033E+00*Exp(-0.2686E+01-0.5308E+01*SB +0.1509E+01*SB2)
      A1=-0.1704E+00-0.2444E+00*SB +0.3557E+00*SB2-0.2174E+00*SB3
      A2= 0.5074E+01+0.1516E+01*SB -0.3815E+01*SB2+0.2956E+01*SB3
      A3=-0.1024E+01+0.6055E+00*SB +0.1338E+01*SB2+0.1855E+01*SB3
      A4= 0.9655E-02+0.1397E+00*SB -0.3254E+00*SB2+0.2057E+00*SB3
      A5= 0.5681E+00+0.2772E+01*SB -0.1963E+01*SB2+0.4607E+00*SB3
      goto 100
C   Ifl =  -6
  69  A0=SB** 0.8044E+00*Exp(-0.6946E+01+0.3617E+01*SB -0.9973E+01*SB2)
      A1=-0.1901E+00-0.8342E+00*SB +0.4663E+01*SB2-0.9999E+01*SB3
      A2= 0.6194E+01-0.9668E+01*SB +0.2997E+02*SB2+0.2987E+02*SB3
      A3= 0.1173E+01-0.8138E+01*SB +0.2924E+02*SB2-0.2860E+00*SB3
      A4= 0.4761E+00-0.3683E+01*SB +0.4966E+01*SB2+0.9593E+01*SB3
      A5= 0.2691E+01-0.9906E+00*SB -0.4504E+01*SB2+0.9999E+01*SB3
      goto 100

 311  stop 'This option is not currently supported.'

 100  CONTINUE
      P012   = A0 *(X**A1) *((1.-X)**A2)
      P34    = (1.+A3*(X**A4))
      P5     = (log(1.+1./X))**A5
C
      PDFD = P012 * P34 * P5
      PDF  = PDFD
C
      Ctq2OPd = PDF
      if(Ctq2OPd.lt.0.0) then
        Ctq2OPd = 0.0
        Irt=1
      endif

      Ist = Iset

      Lp  = Iprtn
      Qsto = QQ

      Return
C                                  -----------------------
      ENTRY Wlamd2O (Iset, Iorder, Neff)

      Iorder = IORD (Iset)
      Wlamd2O = VLM  (Neff, Iset)

           Ctq2OPd = 0.0
      RETURN
C                                  -----------------------
      Entry PrCtq2O
     >        (Iset, Iordr, Ischeme, MxFlv,
     >         Alam4, Alam5, Alam6, Amas4, Amas5, Amas6,
     >         Xmin, Qini, Qmax, ExpNor)

C                           Return QCD parameters and Fitting parameters
C                           associated with parton distribution set Iset.
C    Iord    : Order Of Fit
C    Ischeme : (0, 1, 2)  for  (LO, MS-bar-NLO, DIS-NLO) resp.
C    MxFlv   : Maximum number of flavors included
C    Alam_i  : i = 4,5,6  Effective lambda for i-flavors

C    Amas_i  : i = 4,5,6  Mass parameter for flavor i
C    Xmin, Qini, Qmax : self explanary
C    ExpNor(I) : Normalization factor for the experimental data set used in
C                obtaining the best global fit for parton distributions Iset:
C     I = 1,     2,      3,     4,     5,     6,     7,     8,    9,    10
C      BCDMS   NMC90  NMC280  CCFR   E605    WA70   E706   UA6    H1   ZEUS

      Iordr  = Iord (Iset)
      Ischeme= Isch (Iset)
      MxFlv  = Nqrk (Iset)

      Alam4  = Vlm(4,Iset)
      Alam5  = Vlm(5,Iset)
      Alam6  = Vlm(6,Iset)

      Amas4  = Qms(4,Iset)
      Amas5  = Qms(5,Iset)
      Amas6  = Qms(6,Iset)

      Xmin   = Xmn  (Iset)
      Qini   = Qmn  (Iset)
      Qmax   = Qmx  (Iset)

      Do 201 Iexp = 1, Nexp(Iset)
 201     ExpNor(Iexp) = ExpN(Iexp, Iset)

           Ctq2OPd = 0.0
      Return
C                         *************************
      END
