/*
** Routine for setting the background color by name.
** ff, 1997.
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>


int set_name(char *name)
{
	XColor		exact, color;
	Colormap	cmap;
	Display		*display;
	Window		window;
	int		screen;

	display = XOpenDisplay(NULL);
	screen = DefaultScreen(display);
	window = DefaultRootWindow(display);

	cmap = DefaultColormap(display, screen);

	if(XAllocNamedColor(display, cmap, name, &exact, &color)==0) {
		XCloseDisplay(display);
		return 1;
	}

	XSetWindowBackground(display, window, color.pixel);
	XClearWindow(display, window);

	XFreeColormap(display, cmap);

	XFlush(display);
	XCloseDisplay(display);

	return 0;
}
