/* 
 * CUSTOMIZABLE CONSTANTS
 */

/* Does your machine have <unistd.h> ?
 * Yes => 1, No => 0
 * Sorry, I don't know how to determine automatically... */
#define HAVE_UNISTD_H	1

/*
 * *****************************************************************
 */

#ifndef LOCALEDIR
#define LOCALEDIR	"/usr/local/share/locale/"
#endif

#define NEW_DIRECTORY_MODE	00777
#define NEW_FILE_MODE		00644

/* background color of thumbnail panel */
#define BASE_COLOR		{ 255, 255, 255 }
/* foreground color (the color to draw string in the thumbnail panel) */
#define DRAW_COLOR		{ 0, 0, 0 }
/* the color to draw the names of symbolic links */
#define SLINK_COLOR		{ 46, 139, 87 }
/* the color to show selection frame */
#define FRAME_COLOR		{ 255, 0, 0 }
#define USE_UPDATE_BUTTON	1
#define USE_REDRAW_BUTTON	1
#define DND_DIRECTORY_CHANGE_TIMEOUT	3200 /* [msec] */
/*
 * **********************************************************************
 * the followings are optional.
 * **********************************************************************
 */

/* You can set inihibit suffixes by guash-inhibit-suffix in gimprc */
#define GUASH_INHIBIT_SUFFIX_TABLE_DEFAULT \
	".avi:core:.mov:.mpeg:.mpg:.MPG:.tar:.gz:.tgz:.bz2:.h:.MP3:.mp3:.ZIP:.zip:.TXT:.txt:.VCS:.vcs:.LYX:.lyx:.lzh"

/* You can set the default command by guash-mapping-command in gimprc 
 * {} in the string is replaced by the selected file name in execution time.
 */ 
#define MAPPING_COMMAND_DEFAULT \
	"xv -root -maxpect -quit {}"

/* You can set the history size by guash-directory-history-length in gimprc
 * If your machine has small (physical) memory, try smaller value (use top). */
#define DIRECTORY_CACHE_TABLE_MAX_SIZE	6

/* You can set the polling interval by guash-directory-monitor-interval in
 * gimprc. 10 seconds seems too long to me but would be modest.
 * You need not change the value, even if you don't want to use
 * directory-monitor. Whether use it or not is controlled by the 6th letter
 * in guash-option-string. */
#define DIRECTORY_MONITOR_INTERVAL_DEFAULT 10 /* [second] */

/* You can set the default size by guash-ncol and guash-nrow in gimprc */
#define NCOL_OF_THUMBNAIL_PANEL_DEFAULT	5
#define NROW_OF_THUMBNAIL_PANEL_DEFAULT	3

#define THUMBNAIL_PANEL_DEFAULT_FONT "-*-courier-medium-r-normal--*-140-*-*-*-*-*-*"

/* 
 * ARCHITECTURE-DEPENDED CONSTANTS
 */
#define GCHAR	gchar

#define GUASH_ENABLE_DND	1
#undef USE_UPDATE_BUTTON

/* 
 * MISC SWITCHES
 */
#define	DRAW_STRING_BY_CHARACTER	1

/* */
#define ENABLE_NLS 1
/* */

/* *
#define DEBUG 1
* */
/* *
#define DEATH_ATTACK	1
#define UNDER_DEVELOPMENT 1
* */
#ifndef DEATH_ATTACK
#undef UNDER_DEVELOPMENT
#endif
/* *
#define CHECK_PERFORMANCE 1
* */

/* BROKEN_SCRIPT_FU means:
 * result of script invoked from menu != result of script called from a plug-in
 * All gimps since 1.0.1 (if my memory is right) are BROKEN
 */
#define BROKEN_SCRIPT_FU	1

#ifdef DEBUG
#define DEBUG_SUPPRESS_LEVEL	9
#undef DIRECTORY_MONITOR_INTERVAL_DEFAULT
#define DIRECTORY_MONITOR_INTERVAL_DEFAULT 6
#undef DIRECTORY_CACHE_TABLE_MAX_SIZE
#define DIRECTORY_CACHE_TABLE_MAX_SIZE	6
#undef DIRECTORY_MONITOR_INTERVAL_DEFAULT
#define DIRECTORY_MONITOR_INTERVAL_DEFAULT 30 /* [second] */
#endif

#define HAVE_LC_MESSAGES 1
#ifdef ENABLE_NLS
#define HAVE_SETLOCALE 1
#define HAVE_GETTEXT 1
#define TEXT_DOMAIN	"gimp-std-plugins"
#endif

/*
 * Local variables:
 * compile-command: "gimptool --install guash.c"
 * End:
 */
/* config.h ends here */
