/*
   cipelib - library routines common to CIPE (user-mode part) and PKCIPE

   Copyright 2000 Olaf Titz <olaf@bigred.inka.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the License, or (at your option) any later version.
*/
/* $Id: retstatus.c,v 1.1 2000/11/17 13:59:42 olaf Exp $ */

#include <stdio.h>
#include <sys/wait.h>
#include "cipelib.h"

char *retstatus(int r)
{
    static char buf[32];
    if (WIFEXITED(r)) {
	int i=WEXITSTATUS(r);
	if (!i)
	    return NULL; /* no error */
	snprintf(buf, sizeof(buf), "returned %d", i);
    } else {
	if (WIFSIGNALED(r))
	    snprintf(buf, sizeof(buf), "killed by signal %d", WTERMSIG(r));
	else
	    snprintf(buf, sizeof(buf), "unknown status %d", r);
    }
    return buf;
}

