;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CL-INTERPOL; Base: 10 -*-
;;; $Header: /usr/local/cvsrep/cl-interpol/unicode.lisp,v 1.6 2003/10/22 09:22:45 edi Exp $

;;; Copyright (c) 2003, Dr. Edmund Weitz. All rights reserved.

;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:

;;;   * Redistributions of source code must retain the above copyright
;;;     notice, this list of conditions and the following disclaimer.

;;;   * Redistributions in binary form must reproduce the above
;;;     copyright notice, this list of conditions and the following
;;;     disclaimer in the documentation and/or other materials
;;;     provided with the distribution.

;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR 'AS IS' AND ANY EXPRESSED
;;; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

(in-package #:cl-interpol)

;;; this code prepares the hashtable *UNICODE-NAMES*

(loop for (name . code) in '(("NULL" . 0)
                             ("START OF HEADING" . 1)
                             ("START OF TEXT" . 2)
                             ("END OF TEXT" . 3)
                             ("END OF TRANSMISSION" . 4)
                             ("ENQUIRY" . 5)
                             ("ACKNOWLEDGE" . 6)
                             ("BELL" . 7)
                             ("BACKSPACE" . 8)
                             ("CHARACTER TABULATION" . 9)
                             ("LINE FEED (LF)" . 10)
                             ("LINE TABULATION" . 11)
                             ("FORM FEED (FF)" . 12)
                             ("CARRIAGE RETURN (CR)" . 13)
                             ("SHIFT OUT" . 14)
                             ("SHIFT IN" . 15)
                             ("DATA LINK ESCAPE" . 16)
                             ("DEVICE CONTROL ONE" . 17)
                             ("DEVICE CONTROL TWO" . 18)
                             ("DEVICE CONTROL THREE" . 19)
                             ("DEVICE CONTROL FOUR" . 20)
                             ("NEGATIVE ACKNOWLEDGE" . 21)
                             ("SYNCHRONOUS IDLE" . 22)
                             ("END OF TRANSMISSION BLOCK" . 23)
                             ("CANCEL" . 24)
                             ("END OF MEDIUM" . 25)
                             ("SUBSTITUTE" . 26)
                             ("ESCAPE" . 27)
                             ("INFORMATION SEPARATOR FOUR" . 28)
                             ("INFORMATION SEPARATOR THREE" . 29)
                             ("INFORMATION SEPARATOR TWO" . 30)
                             ("INFORMATION SEPARATOR ONE" . 31)
                             ("SPACE" . 32)
                             ("EXCLAMATION MARK" . 33)
                             ("QUOTATION MARK" . 34)
                             ("NUMBER SIGN" . 35)
                             ("DOLLAR SIGN" . 36)
                             ("PERCENT SIGN" . 37)
                             ("AMPERSAND" . 38)
                             ("APOSTROPHE" . 39)
                             ("LEFT PARENTHESIS" . 40)
                             ("RIGHT PARENTHESIS" . 41)
                             ("ASTERISK" . 42)
                             ("PLUS SIGN" . 43)
                             ("COMMA" . 44)
                             ("HYPHEN-MINUS" . 45)
                             ("FULL STOP" . 46)
                             ("SOLIDUS" . 47)
                             ("DIGIT ZERO" . 48)
                             ("DIGIT ONE" . 49)
                             ("DIGIT TWO" . 50)
                             ("DIGIT THREE" . 51)
                             ("DIGIT FOUR" . 52)
                             ("DIGIT FIVE" . 53)
                             ("DIGIT SIX" . 54)
                             ("DIGIT SEVEN" . 55)
                             ("DIGIT EIGHT" . 56)
                             ("DIGIT NINE" . 57)
                             ("COLON" . 58)
                             ("SEMICOLON" . 59)
                             ("LESS-THAN SIGN" . 60)
                             ("EQUALS SIGN" . 61)
                             ("GREATER-THAN SIGN" . 62)
                             ("QUESTION MARK" . 63)
                             ("COMMERCIAL AT" . 64)
                             ("LATIN CAPITAL LETTER A" . 65)
                             ("LATIN CAPITAL LETTER B" . 66)
                             ("LATIN CAPITAL LETTER C" . 67)
                             ("LATIN CAPITAL LETTER D" . 68)
                             ("LATIN CAPITAL LETTER E" . 69)
                             ("LATIN CAPITAL LETTER F" . 70)
                             ("LATIN CAPITAL LETTER G" . 71)
                             ("LATIN CAPITAL LETTER H" . 72)
                             ("LATIN CAPITAL LETTER I" . 73)
                             ("LATIN CAPITAL LETTER J" . 74)
                             ("LATIN CAPITAL LETTER K" . 75)
                             ("LATIN CAPITAL LETTER L" . 76)
                             ("LATIN CAPITAL LETTER M" . 77)
                             ("LATIN CAPITAL LETTER N" . 78)
                             ("LATIN CAPITAL LETTER O" . 79)
                             ("LATIN CAPITAL LETTER P" . 80)
                             ("LATIN CAPITAL LETTER Q" . 81)
                             ("LATIN CAPITAL LETTER R" . 82)
                             ("LATIN CAPITAL LETTER S" . 83)
                             ("LATIN CAPITAL LETTER T" . 84)
                             ("LATIN CAPITAL LETTER U" . 85)
                             ("LATIN CAPITAL LETTER V" . 86)
                             ("LATIN CAPITAL LETTER W" . 87)
                             ("LATIN CAPITAL LETTER X" . 88)
                             ("LATIN CAPITAL LETTER Y" . 89)
                             ("LATIN CAPITAL LETTER Z" . 90)
                             ("LEFT SQUARE BRACKET" . 91)
                             ("REVERSE SOLIDUS" . 92)
                             ("RIGHT SQUARE BRACKET" . 93)
                             ("CIRCUMFLEX ACCENT" . 94)
                             ("LOW LINE" . 95)
                             ("GRAVE ACCENT" . 96)
                             ("LATIN SMALL LETTER A" . 97)
                             ("LATIN SMALL LETTER B" . 98)
                             ("LATIN SMALL LETTER C" . 99)
                             ("LATIN SMALL LETTER D" . 100)
                             ("LATIN SMALL LETTER E" . 101)
                             ("LATIN SMALL LETTER F" . 102)
                             ("LATIN SMALL LETTER G" . 103)
                             ("LATIN SMALL LETTER H" . 104)
                             ("LATIN SMALL LETTER I" . 105)
                             ("LATIN SMALL LETTER J" . 106)
                             ("LATIN SMALL LETTER K" . 107)
                             ("LATIN SMALL LETTER L" . 108)
                             ("LATIN SMALL LETTER M" . 109)
                             ("LATIN SMALL LETTER N" . 110)
                             ("LATIN SMALL LETTER O" . 111)
                             ("LATIN SMALL LETTER P" . 112)
                             ("LATIN SMALL LETTER Q" . 113)
                             ("LATIN SMALL LETTER R" . 114)
                             ("LATIN SMALL LETTER S" . 115)
                             ("LATIN SMALL LETTER T" . 116)
                             ("LATIN SMALL LETTER U" . 117)
                             ("LATIN SMALL LETTER V" . 118)
                             ("LATIN SMALL LETTER W" . 119)
                             ("LATIN SMALL LETTER X" . 120)
                             ("LATIN SMALL LETTER Y" . 121)
                             ("LATIN SMALL LETTER Z" . 122)
                             ("LEFT CURLY BRACKET" . 123)
                             ("VERTICAL LINE" . 124)
                             ("RIGHT CURLY BRACKET" . 125)
                             ("TILDE" . 126)
                             ("DELETE" . 127)
                             ("BREAK PERMITTED HERE" . 130)
                             ("NO BREAK HERE" . 131)
                             ("NEXT LINE (NEL)" . 133)
                             ("START OF SELECTED AREA" . 134)
                             ("END OF SELECTED AREA" . 135)
                             ("CHARACTER TABULATION SET" . 136)
                             ("CHARACTER TABULATION WITH JUSTIFICATION" . 137)
                             ("LINE TABULATION SET" . 138)
                             ("PARTIAL LINE FORWARD" . 139)
                             ("PARTIAL LINE BACKWARD" . 140)
                             ("REVERSE LINE FEED" . 141)
                             ("SINGLE SHIFT TWO" . 142)
                             ("SINGLE SHIFT THREE" . 143)
                             ("DEVICE CONTROL STRING" . 144)
                             ("PRIVATE USE ONE" . 145)
                             ("PRIVATE USE TWO" . 146)
                             ("SET TRANSMIT STATE" . 147)
                             ("CANCEL CHARACTER" . 148)
                             ("MESSAGE WAITING" . 149)
                             ("START OF GUARDED AREA" . 150)
                             ("END OF GUARDED AREA" . 151)
                             ("START OF STRING" . 152)
                             ("SINGLE CHARACTER INTRODUCER" . 154)
                             ("CONTROL SEQUENCE INTRODUCER" . 155)
                             ("STRING TERMINATOR" . 156)
                             ("OPERATING SYSTEM COMMAND" . 157)
                             ("PRIVACY MESSAGE" . 158)
                             ("APPLICATION PROGRAM COMMAND" . 159)
                             ("NO-BREAK SPACE" . 160)
                             ("INVERTED EXCLAMATION MARK" . 161)
                             ("CENT SIGN" . 162)
                             ("POUND SIGN" . 163)
                             ("CURRENCY SIGN" . 164)
                             ("YEN SIGN" . 165)
                             ("BROKEN BAR" . 166)
                             ("SECTION SIGN" . 167)
                             ("DIAERESIS" . 168)
                             ("COPYRIGHT SIGN" . 169)
                             ("FEMININE ORDINAL INDICATOR" . 170)
                             ("LEFT-POINTING DOUBLE ANGLE QUOTATION MARK" . 171)
                             ("NOT SIGN" . 172)
                             ("SOFT HYPHEN" . 173)
                             ("REGISTERED SIGN" . 174)
                             ("MACRON" . 175)
                             ("DEGREE SIGN" . 176)
                             ("PLUS-MINUS SIGN" . 177)
                             ("SUPERSCRIPT TWO" . 178)
                             ("SUPERSCRIPT THREE" . 179)
                             ("ACUTE ACCENT" . 180)
                             ("MICRO SIGN" . 181)
                             ("PILCROW SIGN" . 182)
                             ("MIDDLE DOT" . 183)
                             ("CEDILLA" . 184)
                             ("SUPERSCRIPT ONE" . 185)
                             ("MASCULINE ORDINAL INDICATOR" . 186)
                             ("RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK" . 187)
                             ("VULGAR FRACTION ONE QUARTER" . 188)
                             ("VULGAR FRACTION ONE HALF" . 189)
                             ("VULGAR FRACTION THREE QUARTERS" . 190)
                             ("INVERTED QUESTION MARK" . 191)
                             ("LATIN CAPITAL LETTER A WITH GRAVE" . 192)
                             ("LATIN CAPITAL LETTER A WITH ACUTE" . 193)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX" . 194)
                             ("LATIN CAPITAL LETTER A WITH TILDE" . 195)
                             ("LATIN CAPITAL LETTER A WITH DIAERESIS" . 196)
                             ("LATIN CAPITAL LETTER A WITH RING ABOVE" . 197)
                             ("LATIN CAPITAL LETTER AE" . 198)
                             ("LATIN CAPITAL LETTER C WITH CEDILLA" . 199)
                             ("LATIN CAPITAL LETTER E WITH GRAVE" . 200)
                             ("LATIN CAPITAL LETTER E WITH ACUTE" . 201)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX" . 202)
                             ("LATIN CAPITAL LETTER E WITH DIAERESIS" . 203)
                             ("LATIN CAPITAL LETTER I WITH GRAVE" . 204)
                             ("LATIN CAPITAL LETTER I WITH ACUTE" . 205)
                             ("LATIN CAPITAL LETTER I WITH CIRCUMFLEX" . 206)
                             ("LATIN CAPITAL LETTER I WITH DIAERESIS" . 207)
                             ("LATIN CAPITAL LETTER ETH" . 208)
                             ("LATIN CAPITAL LETTER N WITH TILDE" . 209)
                             ("LATIN CAPITAL LETTER O WITH GRAVE" . 210)
                             ("LATIN CAPITAL LETTER O WITH ACUTE" . 211)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX" . 212)
                             ("LATIN CAPITAL LETTER O WITH TILDE" . 213)
                             ("LATIN CAPITAL LETTER O WITH DIAERESIS" . 214)
                             ("MULTIPLICATION SIGN" . 215)
                             ("LATIN CAPITAL LETTER O WITH STROKE" . 216)
                             ("LATIN CAPITAL LETTER U WITH GRAVE" . 217)
                             ("LATIN CAPITAL LETTER U WITH ACUTE" . 218)
                             ("LATIN CAPITAL LETTER U WITH CIRCUMFLEX" . 219)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS" . 220)
                             ("LATIN CAPITAL LETTER Y WITH ACUTE" . 221)
                             ("LATIN CAPITAL LETTER THORN" . 222)
                             ("LATIN SMALL LETTER SHARP S" . 223)
                             ("LATIN SMALL LETTER A WITH GRAVE" . 224)
                             ("LATIN SMALL LETTER A WITH ACUTE" . 225)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX" . 226)
                             ("LATIN SMALL LETTER A WITH TILDE" . 227)
                             ("LATIN SMALL LETTER A WITH DIAERESIS" . 228)
                             ("LATIN SMALL LETTER A WITH RING ABOVE" . 229)
                             ("LATIN SMALL LETTER AE" . 230)
                             ("LATIN SMALL LETTER C WITH CEDILLA" . 231)
                             ("LATIN SMALL LETTER E WITH GRAVE" . 232)
                             ("LATIN SMALL LETTER E WITH ACUTE" . 233)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX" . 234)
                             ("LATIN SMALL LETTER E WITH DIAERESIS" . 235)
                             ("LATIN SMALL LETTER I WITH GRAVE" . 236)
                             ("LATIN SMALL LETTER I WITH ACUTE" . 237)
                             ("LATIN SMALL LETTER I WITH CIRCUMFLEX" . 238)
                             ("LATIN SMALL LETTER I WITH DIAERESIS" . 239)
                             ("LATIN SMALL LETTER ETH" . 240)
                             ("LATIN SMALL LETTER N WITH TILDE" . 241)
                             ("LATIN SMALL LETTER O WITH GRAVE" . 242)
                             ("LATIN SMALL LETTER O WITH ACUTE" . 243)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX" . 244)
                             ("LATIN SMALL LETTER O WITH TILDE" . 245)
                             ("LATIN SMALL LETTER O WITH DIAERESIS" . 246)
                             ("DIVISION SIGN" . 247)
                             ("LATIN SMALL LETTER O WITH STROKE" . 248)
                             ("LATIN SMALL LETTER U WITH GRAVE" . 249)
                             ("LATIN SMALL LETTER U WITH ACUTE" . 250)
                             ("LATIN SMALL LETTER U WITH CIRCUMFLEX" . 251)
                             ("LATIN SMALL LETTER U WITH DIAERESIS" . 252)
                             ("LATIN SMALL LETTER Y WITH ACUTE" . 253)
                             ("LATIN SMALL LETTER THORN" . 254)
                             ("LATIN SMALL LETTER Y WITH DIAERESIS" . 255)
                             ("LATIN CAPITAL LETTER A WITH MACRON" . 256)
                             ("LATIN SMALL LETTER A WITH MACRON" . 257)
                             ("LATIN CAPITAL LETTER A WITH BREVE" . 258)
                             ("LATIN SMALL LETTER A WITH BREVE" . 259)
                             ("LATIN CAPITAL LETTER A WITH OGONEK" . 260)
                             ("LATIN SMALL LETTER A WITH OGONEK" . 261)
                             ("LATIN CAPITAL LETTER C WITH ACUTE" . 262)
                             ("LATIN SMALL LETTER C WITH ACUTE" . 263)
                             ("LATIN CAPITAL LETTER C WITH CIRCUMFLEX" . 264)
                             ("LATIN SMALL LETTER C WITH CIRCUMFLEX" . 265)
                             ("LATIN CAPITAL LETTER C WITH DOT ABOVE" . 266)
                             ("LATIN SMALL LETTER C WITH DOT ABOVE" . 267)
                             ("LATIN CAPITAL LETTER C WITH CARON" . 268)
                             ("LATIN SMALL LETTER C WITH CARON" . 269)
                             ("LATIN CAPITAL LETTER D WITH CARON" . 270)
                             ("LATIN SMALL LETTER D WITH CARON" . 271)
                             ("LATIN CAPITAL LETTER D WITH STROKE" . 272)
                             ("LATIN SMALL LETTER D WITH STROKE" . 273)
                             ("LATIN CAPITAL LETTER E WITH MACRON" . 274)
                             ("LATIN SMALL LETTER E WITH MACRON" . 275)
                             ("LATIN CAPITAL LETTER E WITH BREVE" . 276)
                             ("LATIN SMALL LETTER E WITH BREVE" . 277)
                             ("LATIN CAPITAL LETTER E WITH DOT ABOVE" . 278)
                             ("LATIN SMALL LETTER E WITH DOT ABOVE" . 279)
                             ("LATIN CAPITAL LETTER E WITH OGONEK" . 280)
                             ("LATIN SMALL LETTER E WITH OGONEK" . 281)
                             ("LATIN CAPITAL LETTER E WITH CARON" . 282)
                             ("LATIN SMALL LETTER E WITH CARON" . 283)
                             ("LATIN CAPITAL LETTER G WITH CIRCUMFLEX" . 284)
                             ("LATIN SMALL LETTER G WITH CIRCUMFLEX" . 285)
                             ("LATIN CAPITAL LETTER G WITH BREVE" . 286)
                             ("LATIN SMALL LETTER G WITH BREVE" . 287)
                             ("LATIN CAPITAL LETTER G WITH DOT ABOVE" . 288)
                             ("LATIN SMALL LETTER G WITH DOT ABOVE" . 289)
                             ("LATIN CAPITAL LETTER G WITH CEDILLA" . 290)
                             ("LATIN SMALL LETTER G WITH CEDILLA" . 291)
                             ("LATIN CAPITAL LETTER H WITH CIRCUMFLEX" . 292)
                             ("LATIN SMALL LETTER H WITH CIRCUMFLEX" . 293)
                             ("LATIN CAPITAL LETTER H WITH STROKE" . 294)
                             ("LATIN SMALL LETTER H WITH STROKE" . 295)
                             ("LATIN CAPITAL LETTER I WITH TILDE" . 296)
                             ("LATIN SMALL LETTER I WITH TILDE" . 297)
                             ("LATIN CAPITAL LETTER I WITH MACRON" . 298)
                             ("LATIN SMALL LETTER I WITH MACRON" . 299)
                             ("LATIN CAPITAL LETTER I WITH BREVE" . 300)
                             ("LATIN SMALL LETTER I WITH BREVE" . 301)
                             ("LATIN CAPITAL LETTER I WITH OGONEK" . 302)
                             ("LATIN SMALL LETTER I WITH OGONEK" . 303)
                             ("LATIN CAPITAL LETTER I WITH DOT ABOVE" . 304)
                             ("LATIN SMALL LETTER DOTLESS I" . 305)
                             ("LATIN CAPITAL LIGATURE IJ" . 306)
                             ("LATIN SMALL LIGATURE IJ" . 307)
                             ("LATIN CAPITAL LETTER J WITH CIRCUMFLEX" . 308)
                             ("LATIN SMALL LETTER J WITH CIRCUMFLEX" . 309)
                             ("LATIN CAPITAL LETTER K WITH CEDILLA" . 310)
                             ("LATIN SMALL LETTER K WITH CEDILLA" . 311)
                             ("LATIN SMALL LETTER KRA" . 312)
                             ("LATIN CAPITAL LETTER L WITH ACUTE" . 313)
                             ("LATIN SMALL LETTER L WITH ACUTE" . 314)
                             ("LATIN CAPITAL LETTER L WITH CEDILLA" . 315)
                             ("LATIN SMALL LETTER L WITH CEDILLA" . 316)
                             ("LATIN CAPITAL LETTER L WITH CARON" . 317)
                             ("LATIN SMALL LETTER L WITH CARON" . 318)
                             ("LATIN CAPITAL LETTER L WITH MIDDLE DOT" . 319)
                             ("LATIN SMALL LETTER L WITH MIDDLE DOT" . 320)
                             ("LATIN CAPITAL LETTER L WITH STROKE" . 321)
                             ("LATIN SMALL LETTER L WITH STROKE" . 322)
                             ("LATIN CAPITAL LETTER N WITH ACUTE" . 323)
                             ("LATIN SMALL LETTER N WITH ACUTE" . 324)
                             ("LATIN CAPITAL LETTER N WITH CEDILLA" . 325)
                             ("LATIN SMALL LETTER N WITH CEDILLA" . 326)
                             ("LATIN CAPITAL LETTER N WITH CARON" . 327)
                             ("LATIN SMALL LETTER N WITH CARON" . 328)
                             ("LATIN SMALL LETTER N PRECEDED BY APOSTROPHE" . 329)
                             ("LATIN CAPITAL LETTER ENG" . 330)
                             ("LATIN SMALL LETTER ENG" . 331)
                             ("LATIN CAPITAL LETTER O WITH MACRON" . 332)
                             ("LATIN SMALL LETTER O WITH MACRON" . 333)
                             ("LATIN CAPITAL LETTER O WITH BREVE" . 334)
                             ("LATIN SMALL LETTER O WITH BREVE" . 335)
                             ("LATIN CAPITAL LETTER O WITH DOUBLE ACUTE" . 336)
                             ("LATIN SMALL LETTER O WITH DOUBLE ACUTE" . 337)
                             ("LATIN CAPITAL LIGATURE OE" . 338)
                             ("LATIN SMALL LIGATURE OE" . 339)
                             ("LATIN CAPITAL LETTER R WITH ACUTE" . 340)
                             ("LATIN SMALL LETTER R WITH ACUTE" . 341)
                             ("LATIN CAPITAL LETTER R WITH CEDILLA" . 342)
                             ("LATIN SMALL LETTER R WITH CEDILLA" . 343)
                             ("LATIN CAPITAL LETTER R WITH CARON" . 344)
                             ("LATIN SMALL LETTER R WITH CARON" . 345)
                             ("LATIN CAPITAL LETTER S WITH ACUTE" . 346)
                             ("LATIN SMALL LETTER S WITH ACUTE" . 347)
                             ("LATIN CAPITAL LETTER S WITH CIRCUMFLEX" . 348)
                             ("LATIN SMALL LETTER S WITH CIRCUMFLEX" . 349)
                             ("LATIN CAPITAL LETTER S WITH CEDILLA" . 350)
                             ("LATIN SMALL LETTER S WITH CEDILLA" . 351)
                             ("LATIN CAPITAL LETTER S WITH CARON" . 352)
                             ("LATIN SMALL LETTER S WITH CARON" . 353)
                             ("LATIN CAPITAL LETTER T WITH CEDILLA" . 354)
                             ("LATIN SMALL LETTER T WITH CEDILLA" . 355)
                             ("LATIN CAPITAL LETTER T WITH CARON" . 356)
                             ("LATIN SMALL LETTER T WITH CARON" . 357)
                             ("LATIN CAPITAL LETTER T WITH STROKE" . 358)
                             ("LATIN SMALL LETTER T WITH STROKE" . 359)
                             ("LATIN CAPITAL LETTER U WITH TILDE" . 360)
                             ("LATIN SMALL LETTER U WITH TILDE" . 361)
                             ("LATIN CAPITAL LETTER U WITH MACRON" . 362)
                             ("LATIN SMALL LETTER U WITH MACRON" . 363)
                             ("LATIN CAPITAL LETTER U WITH BREVE" . 364)
                             ("LATIN SMALL LETTER U WITH BREVE" . 365)
                             ("LATIN CAPITAL LETTER U WITH RING ABOVE" . 366)
                             ("LATIN SMALL LETTER U WITH RING ABOVE" . 367)
                             ("LATIN CAPITAL LETTER U WITH DOUBLE ACUTE" . 368)
                             ("LATIN SMALL LETTER U WITH DOUBLE ACUTE" . 369)
                             ("LATIN CAPITAL LETTER U WITH OGONEK" . 370)
                             ("LATIN SMALL LETTER U WITH OGONEK" . 371)
                             ("LATIN CAPITAL LETTER W WITH CIRCUMFLEX" . 372)
                             ("LATIN SMALL LETTER W WITH CIRCUMFLEX" . 373)
                             ("LATIN CAPITAL LETTER Y WITH CIRCUMFLEX" . 374)
                             ("LATIN SMALL LETTER Y WITH CIRCUMFLEX" . 375)
                             ("LATIN CAPITAL LETTER Y WITH DIAERESIS" . 376)
                             ("LATIN CAPITAL LETTER Z WITH ACUTE" . 377)
                             ("LATIN SMALL LETTER Z WITH ACUTE" . 378)
                             ("LATIN CAPITAL LETTER Z WITH DOT ABOVE" . 379)
                             ("LATIN SMALL LETTER Z WITH DOT ABOVE" . 380)
                             ("LATIN CAPITAL LETTER Z WITH CARON" . 381)
                             ("LATIN SMALL LETTER Z WITH CARON" . 382)
                             ("LATIN SMALL LETTER LONG S" . 383)
                             ("LATIN SMALL LETTER B WITH STROKE" . 384)
                             ("LATIN CAPITAL LETTER B WITH HOOK" . 385)
                             ("LATIN CAPITAL LETTER B WITH TOPBAR" . 386)
                             ("LATIN SMALL LETTER B WITH TOPBAR" . 387)
                             ("LATIN CAPITAL LETTER TONE SIX" . 388)
                             ("LATIN SMALL LETTER TONE SIX" . 389)
                             ("LATIN CAPITAL LETTER OPEN O" . 390)
                             ("LATIN CAPITAL LETTER C WITH HOOK" . 391)
                             ("LATIN SMALL LETTER C WITH HOOK" . 392)
                             ("LATIN CAPITAL LETTER AFRICAN D" . 393)
                             ("LATIN CAPITAL LETTER D WITH HOOK" . 394)
                             ("LATIN CAPITAL LETTER D WITH TOPBAR" . 395)
                             ("LATIN SMALL LETTER D WITH TOPBAR" . 396)
                             ("LATIN SMALL LETTER TURNED DELTA" . 397)
                             ("LATIN CAPITAL LETTER REVERSED E" . 398)
                             ("LATIN CAPITAL LETTER SCHWA" . 399)
                             ("LATIN CAPITAL LETTER OPEN E" . 400)
                             ("LATIN CAPITAL LETTER F WITH HOOK" . 401)
                             ("LATIN SMALL LETTER F WITH HOOK" . 402)
                             ("LATIN CAPITAL LETTER G WITH HOOK" . 403)
                             ("LATIN CAPITAL LETTER GAMMA" . 404)
                             ("LATIN SMALL LETTER HV" . 405)
                             ("LATIN CAPITAL LETTER IOTA" . 406)
                             ("LATIN CAPITAL LETTER I WITH STROKE" . 407)
                             ("LATIN CAPITAL LETTER K WITH HOOK" . 408)
                             ("LATIN SMALL LETTER K WITH HOOK" . 409)
                             ("LATIN SMALL LETTER L WITH BAR" . 410)
                             ("LATIN SMALL LETTER LAMBDA WITH STROKE" . 411)
                             ("LATIN CAPITAL LETTER TURNED M" . 412)
                             ("LATIN CAPITAL LETTER N WITH LEFT HOOK" . 413)
                             ("LATIN SMALL LETTER N WITH LONG RIGHT LEG" . 414)
                             ("LATIN CAPITAL LETTER O WITH MIDDLE TILDE" . 415)
                             ("LATIN CAPITAL LETTER O WITH HORN" . 416)
                             ("LATIN SMALL LETTER O WITH HORN" . 417)
                             ("LATIN CAPITAL LETTER OI" . 418)
                             ("LATIN SMALL LETTER OI" . 419)
                             ("LATIN CAPITAL LETTER P WITH HOOK" . 420)
                             ("LATIN SMALL LETTER P WITH HOOK" . 421)
                             ("LATIN LETTER YR" . 422)
                             ("LATIN CAPITAL LETTER TONE TWO" . 423)
                             ("LATIN SMALL LETTER TONE TWO" . 424)
                             ("LATIN CAPITAL LETTER ESH" . 425)
                             ("LATIN LETTER REVERSED ESH LOOP" . 426)
                             ("LATIN SMALL LETTER T WITH PALATAL HOOK" . 427)
                             ("LATIN CAPITAL LETTER T WITH HOOK" . 428)
                             ("LATIN SMALL LETTER T WITH HOOK" . 429)
                             ("LATIN CAPITAL LETTER T WITH RETROFLEX HOOK" . 430)
                             ("LATIN CAPITAL LETTER U WITH HORN" . 431)
                             ("LATIN SMALL LETTER U WITH HORN" . 432)
                             ("LATIN CAPITAL LETTER UPSILON" . 433)
                             ("LATIN CAPITAL LETTER V WITH HOOK" . 434)
                             ("LATIN CAPITAL LETTER Y WITH HOOK" . 435)
                             ("LATIN SMALL LETTER Y WITH HOOK" . 436)
                             ("LATIN CAPITAL LETTER Z WITH STROKE" . 437)
                             ("LATIN SMALL LETTER Z WITH STROKE" . 438)
                             ("LATIN CAPITAL LETTER EZH" . 439)
                             ("LATIN CAPITAL LETTER EZH REVERSED" . 440)
                             ("LATIN SMALL LETTER EZH REVERSED" . 441)
                             ("LATIN SMALL LETTER EZH WITH TAIL" . 442)
                             ("LATIN LETTER TWO WITH STROKE" . 443)
                             ("LATIN CAPITAL LETTER TONE FIVE" . 444)
                             ("LATIN SMALL LETTER TONE FIVE" . 445)
                             ("LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE" . 446)
                             ("LATIN LETTER WYNN" . 447)
                             ("LATIN LETTER DENTAL CLICK" . 448)
                             ("LATIN LETTER LATERAL CLICK" . 449)
                             ("LATIN LETTER ALVEOLAR CLICK" . 450)
                             ("LATIN LETTER RETROFLEX CLICK" . 451)
                             ("LATIN CAPITAL LETTER DZ WITH CARON" . 452)
                             ("LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON" . 453)
                             ("LATIN SMALL LETTER DZ WITH CARON" . 454)
                             ("LATIN CAPITAL LETTER LJ" . 455)
                             ("LATIN CAPITAL LETTER L WITH SMALL LETTER J" . 456)
                             ("LATIN SMALL LETTER LJ" . 457)
                             ("LATIN CAPITAL LETTER NJ" . 458)
                             ("LATIN CAPITAL LETTER N WITH SMALL LETTER J" . 459)
                             ("LATIN SMALL LETTER NJ" . 460)
                             ("LATIN CAPITAL LETTER A WITH CARON" . 461)
                             ("LATIN SMALL LETTER A WITH CARON" . 462)
                             ("LATIN CAPITAL LETTER I WITH CARON" . 463)
                             ("LATIN SMALL LETTER I WITH CARON" . 464)
                             ("LATIN CAPITAL LETTER O WITH CARON" . 465)
                             ("LATIN SMALL LETTER O WITH CARON" . 466)
                             ("LATIN CAPITAL LETTER U WITH CARON" . 467)
                             ("LATIN SMALL LETTER U WITH CARON" . 468)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON" . 469)
                             ("LATIN SMALL LETTER U WITH DIAERESIS AND MACRON" . 470)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE" . 471)
                             ("LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE" . 472)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON" . 473)
                             ("LATIN SMALL LETTER U WITH DIAERESIS AND CARON" . 474)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE" . 475)
                             ("LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE" . 476)
                             ("LATIN SMALL LETTER TURNED E" . 477)
                             ("LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON" . 478)
                             ("LATIN SMALL LETTER A WITH DIAERESIS AND MACRON" . 479)
                             ("LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON" . 480)
                             ("LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON" . 481)
                             ("LATIN CAPITAL LETTER AE WITH MACRON" . 482)
                             ("LATIN SMALL LETTER AE WITH MACRON" . 483)
                             ("LATIN CAPITAL LETTER G WITH STROKE" . 484)
                             ("LATIN SMALL LETTER G WITH STROKE" . 485)
                             ("LATIN CAPITAL LETTER G WITH CARON" . 486)
                             ("LATIN SMALL LETTER G WITH CARON" . 487)
                             ("LATIN CAPITAL LETTER K WITH CARON" . 488)
                             ("LATIN SMALL LETTER K WITH CARON" . 489)
                             ("LATIN CAPITAL LETTER O WITH OGONEK" . 490)
                             ("LATIN SMALL LETTER O WITH OGONEK" . 491)
                             ("LATIN CAPITAL LETTER O WITH OGONEK AND MACRON" . 492)
                             ("LATIN SMALL LETTER O WITH OGONEK AND MACRON" . 493)
                             ("LATIN CAPITAL LETTER EZH WITH CARON" . 494)
                             ("LATIN SMALL LETTER EZH WITH CARON" . 495)
                             ("LATIN SMALL LETTER J WITH CARON" . 496)
                             ("LATIN CAPITAL LETTER DZ" . 497)
                             ("LATIN CAPITAL LETTER D WITH SMALL LETTER Z" . 498)
                             ("LATIN SMALL LETTER DZ" . 499)
                             ("LATIN CAPITAL LETTER G WITH ACUTE" . 500)
                             ("LATIN SMALL LETTER G WITH ACUTE" . 501)
                             ("LATIN CAPITAL LETTER HWAIR" . 502)
                             ("LATIN CAPITAL LETTER WYNN" . 503)
                             ("LATIN CAPITAL LETTER N WITH GRAVE" . 504)
                             ("LATIN SMALL LETTER N WITH GRAVE" . 505)
                             ("LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE" . 506)
                             ("LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE" . 507)
                             ("LATIN CAPITAL LETTER AE WITH ACUTE" . 508)
                             ("LATIN SMALL LETTER AE WITH ACUTE" . 509)
                             ("LATIN CAPITAL LETTER O WITH STROKE AND ACUTE" . 510)
                             ("LATIN SMALL LETTER O WITH STROKE AND ACUTE" . 511)
                             ("LATIN CAPITAL LETTER A WITH DOUBLE GRAVE" . 512)
                             ("LATIN SMALL LETTER A WITH DOUBLE GRAVE" . 513)
                             ("LATIN CAPITAL LETTER A WITH INVERTED BREVE" . 514)
                             ("LATIN SMALL LETTER A WITH INVERTED BREVE" . 515)
                             ("LATIN CAPITAL LETTER E WITH DOUBLE GRAVE" . 516)
                             ("LATIN SMALL LETTER E WITH DOUBLE GRAVE" . 517)
                             ("LATIN CAPITAL LETTER E WITH INVERTED BREVE" . 518)
                             ("LATIN SMALL LETTER E WITH INVERTED BREVE" . 519)
                             ("LATIN CAPITAL LETTER I WITH DOUBLE GRAVE" . 520)
                             ("LATIN SMALL LETTER I WITH DOUBLE GRAVE" . 521)
                             ("LATIN CAPITAL LETTER I WITH INVERTED BREVE" . 522)
                             ("LATIN SMALL LETTER I WITH INVERTED BREVE" . 523)
                             ("LATIN CAPITAL LETTER O WITH DOUBLE GRAVE" . 524)
                             ("LATIN SMALL LETTER O WITH DOUBLE GRAVE" . 525)
                             ("LATIN CAPITAL LETTER O WITH INVERTED BREVE" . 526)
                             ("LATIN SMALL LETTER O WITH INVERTED BREVE" . 527)
                             ("LATIN CAPITAL LETTER R WITH DOUBLE GRAVE" . 528)
                             ("LATIN SMALL LETTER R WITH DOUBLE GRAVE" . 529)
                             ("LATIN CAPITAL LETTER R WITH INVERTED BREVE" . 530)
                             ("LATIN SMALL LETTER R WITH INVERTED BREVE" . 531)
                             ("LATIN CAPITAL LETTER U WITH DOUBLE GRAVE" . 532)
                             ("LATIN SMALL LETTER U WITH DOUBLE GRAVE" . 533)
                             ("LATIN CAPITAL LETTER U WITH INVERTED BREVE" . 534)
                             ("LATIN SMALL LETTER U WITH INVERTED BREVE" . 535)
                             ("LATIN CAPITAL LETTER S WITH COMMA BELOW" . 536)
                             ("LATIN SMALL LETTER S WITH COMMA BELOW" . 537)
                             ("LATIN CAPITAL LETTER T WITH COMMA BELOW" . 538)
                             ("LATIN SMALL LETTER T WITH COMMA BELOW" . 539)
                             ("LATIN CAPITAL LETTER YOGH" . 540)
                             ("LATIN SMALL LETTER YOGH" . 541)
                             ("LATIN CAPITAL LETTER H WITH CARON" . 542)
                             ("LATIN SMALL LETTER H WITH CARON" . 543)
                             ("LATIN CAPITAL LETTER N WITH LONG RIGHT LEG" . 544)
                             ("LATIN CAPITAL LETTER OU" . 546)
                             ("LATIN SMALL LETTER OU" . 547)
                             ("LATIN CAPITAL LETTER Z WITH HOOK" . 548)
                             ("LATIN SMALL LETTER Z WITH HOOK" . 549)
                             ("LATIN CAPITAL LETTER A WITH DOT ABOVE" . 550)
                             ("LATIN SMALL LETTER A WITH DOT ABOVE" . 551)
                             ("LATIN CAPITAL LETTER E WITH CEDILLA" . 552)
                             ("LATIN SMALL LETTER E WITH CEDILLA" . 553)
                             ("LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON" . 554)
                             ("LATIN SMALL LETTER O WITH DIAERESIS AND MACRON" . 555)
                             ("LATIN CAPITAL LETTER O WITH TILDE AND MACRON" . 556)
                             ("LATIN SMALL LETTER O WITH TILDE AND MACRON" . 557)
                             ("LATIN CAPITAL LETTER O WITH DOT ABOVE" . 558)
                             ("LATIN SMALL LETTER O WITH DOT ABOVE" . 559)
                             ("LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON" . 560)
                             ("LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON" . 561)
                             ("LATIN CAPITAL LETTER Y WITH MACRON" . 562)
                             ("LATIN SMALL LETTER Y WITH MACRON" . 563)
                             ("LATIN SMALL LETTER TURNED A" . 592)
                             ("LATIN SMALL LETTER ALPHA" . 593)
                             ("LATIN SMALL LETTER TURNED ALPHA" . 594)
                             ("LATIN SMALL LETTER B WITH HOOK" . 595)
                             ("LATIN SMALL LETTER OPEN O" . 596)
                             ("LATIN SMALL LETTER C WITH CURL" . 597)
                             ("LATIN SMALL LETTER D WITH TAIL" . 598)
                             ("LATIN SMALL LETTER D WITH HOOK" . 599)
                             ("LATIN SMALL LETTER REVERSED E" . 600)
                             ("LATIN SMALL LETTER SCHWA" . 601)
                             ("LATIN SMALL LETTER SCHWA WITH HOOK" . 602)
                             ("LATIN SMALL LETTER OPEN E" . 603)
                             ("LATIN SMALL LETTER REVERSED OPEN E" . 604)
                             ("LATIN SMALL LETTER REVERSED OPEN E WITH HOOK" . 605)
                             ("LATIN SMALL LETTER CLOSED REVERSED OPEN E" . 606)
                             ("LATIN SMALL LETTER DOTLESS J WITH STROKE" . 607)
                             ("LATIN SMALL LETTER G WITH HOOK" . 608)
                             ("LATIN SMALL LETTER SCRIPT G" . 609)
                             ("LATIN LETTER SMALL CAPITAL G" . 610)
                             ("LATIN SMALL LETTER GAMMA" . 611)
                             ("LATIN SMALL LETTER RAMS HORN" . 612)
                             ("LATIN SMALL LETTER TURNED H" . 613)
                             ("LATIN SMALL LETTER H WITH HOOK" . 614)
                             ("LATIN SMALL LETTER HENG WITH HOOK" . 615)
                             ("LATIN SMALL LETTER I WITH STROKE" . 616)
                             ("LATIN SMALL LETTER IOTA" . 617)
                             ("LATIN LETTER SMALL CAPITAL I" . 618)
                             ("LATIN SMALL LETTER L WITH MIDDLE TILDE" . 619)
                             ("LATIN SMALL LETTER L WITH BELT" . 620)
                             ("LATIN SMALL LETTER L WITH RETROFLEX HOOK" . 621)
                             ("LATIN SMALL LETTER LEZH" . 622)
                             ("LATIN SMALL LETTER TURNED M" . 623)
                             ("LATIN SMALL LETTER TURNED M WITH LONG LEG" . 624)
                             ("LATIN SMALL LETTER M WITH HOOK" . 625)
                             ("LATIN SMALL LETTER N WITH LEFT HOOK" . 626)
                             ("LATIN SMALL LETTER N WITH RETROFLEX HOOK" . 627)
                             ("LATIN LETTER SMALL CAPITAL N" . 628)
                             ("LATIN SMALL LETTER BARRED O" . 629)
                             ("LATIN LETTER SMALL CAPITAL OE" . 630)
                             ("LATIN SMALL LETTER CLOSED OMEGA" . 631)
                             ("LATIN SMALL LETTER PHI" . 632)
                             ("LATIN SMALL LETTER TURNED R" . 633)
                             ("LATIN SMALL LETTER TURNED R WITH LONG LEG" . 634)
                             ("LATIN SMALL LETTER TURNED R WITH HOOK" . 635)
                             ("LATIN SMALL LETTER R WITH LONG LEG" . 636)
                             ("LATIN SMALL LETTER R WITH TAIL" . 637)
                             ("LATIN SMALL LETTER R WITH FISHHOOK" . 638)
                             ("LATIN SMALL LETTER REVERSED R WITH FISHHOOK" . 639)
                             ("LATIN LETTER SMALL CAPITAL R" . 640)
                             ("LATIN LETTER SMALL CAPITAL INVERTED R" . 641)
                             ("LATIN SMALL LETTER S WITH HOOK" . 642)
                             ("LATIN SMALL LETTER ESH" . 643)
                             ("LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK" . 644)
                             ("LATIN SMALL LETTER SQUAT REVERSED ESH" . 645)
                             ("LATIN SMALL LETTER ESH WITH CURL" . 646)
                             ("LATIN SMALL LETTER TURNED T" . 647)
                             ("LATIN SMALL LETTER T WITH RETROFLEX HOOK" . 648)
                             ("LATIN SMALL LETTER U BAR" . 649)
                             ("LATIN SMALL LETTER UPSILON" . 650)
                             ("LATIN SMALL LETTER V WITH HOOK" . 651)
                             ("LATIN SMALL LETTER TURNED V" . 652)
                             ("LATIN SMALL LETTER TURNED W" . 653)
                             ("LATIN SMALL LETTER TURNED Y" . 654)
                             ("LATIN LETTER SMALL CAPITAL Y" . 655)
                             ("LATIN SMALL LETTER Z WITH RETROFLEX HOOK" . 656)
                             ("LATIN SMALL LETTER Z WITH CURL" . 657)
                             ("LATIN SMALL LETTER EZH" . 658)
                             ("LATIN SMALL LETTER EZH WITH CURL" . 659)
                             ("LATIN LETTER GLOTTAL STOP" . 660)
                             ("LATIN LETTER PHARYNGEAL VOICED FRICATIVE" . 661)
                             ("LATIN LETTER INVERTED GLOTTAL STOP" . 662)
                             ("LATIN LETTER STRETCHED C" . 663)
                             ("LATIN LETTER BILABIAL CLICK" . 664)
                             ("LATIN LETTER SMALL CAPITAL B" . 665)
                             ("LATIN SMALL LETTER CLOSED OPEN E" . 666)
                             ("LATIN LETTER SMALL CAPITAL G WITH HOOK" . 667)
                             ("LATIN LETTER SMALL CAPITAL H" . 668)
                             ("LATIN SMALL LETTER J WITH CROSSED-TAIL" . 669)
                             ("LATIN SMALL LETTER TURNED K" . 670)
                             ("LATIN LETTER SMALL CAPITAL L" . 671)
                             ("LATIN SMALL LETTER Q WITH HOOK" . 672)
                             ("LATIN LETTER GLOTTAL STOP WITH STROKE" . 673)
                             ("LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE" . 674)
                             ("LATIN SMALL LETTER DZ DIGRAPH" . 675)
                             ("LATIN SMALL LETTER DEZH DIGRAPH" . 676)
                             ("LATIN SMALL LETTER DZ DIGRAPH WITH CURL" . 677)
                             ("LATIN SMALL LETTER TS DIGRAPH" . 678)
                             ("LATIN SMALL LETTER TESH DIGRAPH" . 679)
                             ("LATIN SMALL LETTER TC DIGRAPH WITH CURL" . 680)
                             ("LATIN SMALL LETTER FENG DIGRAPH" . 681)
                             ("LATIN SMALL LETTER LS DIGRAPH" . 682)
                             ("LATIN SMALL LETTER LZ DIGRAPH" . 683)
                             ("LATIN LETTER BILABIAL PERCUSSIVE" . 684)
                             ("LATIN LETTER BIDENTAL PERCUSSIVE" . 685)
                             ("MODIFIER LETTER SMALL H" . 688)
                             ("MODIFIER LETTER SMALL H WITH HOOK" . 689)
                             ("MODIFIER LETTER SMALL J" . 690)
                             ("MODIFIER LETTER SMALL R" . 691)
                             ("MODIFIER LETTER SMALL TURNED R" . 692)
                             ("MODIFIER LETTER SMALL TURNED R WITH HOOK" . 693)
                             ("MODIFIER LETTER SMALL CAPITAL INVERTED R" . 694)
                             ("MODIFIER LETTER SMALL W" . 695)
                             ("MODIFIER LETTER SMALL Y" . 696)
                             ("MODIFIER LETTER PRIME" . 697)
                             ("MODIFIER LETTER DOUBLE PRIME" . 698)
                             ("MODIFIER LETTER TURNED COMMA" . 699)
                             ("MODIFIER LETTER APOSTROPHE" . 700)
                             ("MODIFIER LETTER REVERSED COMMA" . 701)
                             ("MODIFIER LETTER RIGHT HALF RING" . 702)
                             ("MODIFIER LETTER LEFT HALF RING" . 703)
                             ("MODIFIER LETTER GLOTTAL STOP" . 704)
                             ("MODIFIER LETTER REVERSED GLOTTAL STOP" . 705)
                             ("MODIFIER LETTER LEFT ARROWHEAD" . 706)
                             ("MODIFIER LETTER RIGHT ARROWHEAD" . 707)
                             ("MODIFIER LETTER UP ARROWHEAD" . 708)
                             ("MODIFIER LETTER DOWN ARROWHEAD" . 709)
                             ("MODIFIER LETTER CIRCUMFLEX ACCENT" . 710)
                             ("CARON" . 711)
                             ("MODIFIER LETTER VERTICAL LINE" . 712)
                             ("MODIFIER LETTER MACRON" . 713)
                             ("MODIFIER LETTER ACUTE ACCENT" . 714)
                             ("MODIFIER LETTER GRAVE ACCENT" . 715)
                             ("MODIFIER LETTER LOW VERTICAL LINE" . 716)
                             ("MODIFIER LETTER LOW MACRON" . 717)
                             ("MODIFIER LETTER LOW GRAVE ACCENT" . 718)
                             ("MODIFIER LETTER LOW ACUTE ACCENT" . 719)
                             ("MODIFIER LETTER TRIANGULAR COLON" . 720)
                             ("MODIFIER LETTER HALF TRIANGULAR COLON" . 721)
                             ("MODIFIER LETTER CENTRED RIGHT HALF RING" . 722)
                             ("MODIFIER LETTER CENTRED LEFT HALF RING" . 723)
                             ("MODIFIER LETTER UP TACK" . 724)
                             ("MODIFIER LETTER DOWN TACK" . 725)
                             ("MODIFIER LETTER PLUS SIGN" . 726)
                             ("MODIFIER LETTER MINUS SIGN" . 727)
                             ("BREVE" . 728)
                             ("DOT ABOVE" . 729)
                             ("RING ABOVE" . 730)
                             ("OGONEK" . 731)
                             ("SMALL TILDE" . 732)
                             ("DOUBLE ACUTE ACCENT" . 733)
                             ("MODIFIER LETTER RHOTIC HOOK" . 734)
                             ("MODIFIER LETTER CROSS ACCENT" . 735)
                             ("MODIFIER LETTER SMALL GAMMA" . 736)
                             ("MODIFIER LETTER SMALL L" . 737)
                             ("MODIFIER LETTER SMALL S" . 738)
                             ("MODIFIER LETTER SMALL X" . 739)
                             ("MODIFIER LETTER SMALL REVERSED GLOTTAL STOP" . 740)
                             ("MODIFIER LETTER EXTRA-HIGH TONE BAR" . 741)
                             ("MODIFIER LETTER HIGH TONE BAR" . 742)
                             ("MODIFIER LETTER MID TONE BAR" . 743)
                             ("MODIFIER LETTER LOW TONE BAR" . 744)
                             ("MODIFIER LETTER EXTRA-LOW TONE BAR" . 745)
                             ("MODIFIER LETTER YIN DEPARTING TONE MARK" . 746)
                             ("MODIFIER LETTER YANG DEPARTING TONE MARK" . 747)
                             ("MODIFIER LETTER VOICING" . 748)
                             ("MODIFIER LETTER UNASPIRATED" . 749)
                             ("MODIFIER LETTER DOUBLE APOSTROPHE" . 750)
                             ("COMBINING GRAVE ACCENT" . 768)
                             ("COMBINING ACUTE ACCENT" . 769)
                             ("COMBINING CIRCUMFLEX ACCENT" . 770)
                             ("COMBINING TILDE" . 771)
                             ("COMBINING MACRON" . 772)
                             ("COMBINING OVERLINE" . 773)
                             ("COMBINING BREVE" . 774)
                             ("COMBINING DOT ABOVE" . 775)
                             ("COMBINING DIAERESIS" . 776)
                             ("COMBINING HOOK ABOVE" . 777)
                             ("COMBINING RING ABOVE" . 778)
                             ("COMBINING DOUBLE ACUTE ACCENT" . 779)
                             ("COMBINING CARON" . 780)
                             ("COMBINING VERTICAL LINE ABOVE" . 781)
                             ("COMBINING DOUBLE VERTICAL LINE ABOVE" . 782)
                             ("COMBINING DOUBLE GRAVE ACCENT" . 783)
                             ("COMBINING CANDRABINDU" . 784)
                             ("COMBINING INVERTED BREVE" . 785)
                             ("COMBINING TURNED COMMA ABOVE" . 786)
                             ("COMBINING COMMA ABOVE" . 787)
                             ("COMBINING REVERSED COMMA ABOVE" . 788)
                             ("COMBINING COMMA ABOVE RIGHT" . 789)
                             ("COMBINING GRAVE ACCENT BELOW" . 790)
                             ("COMBINING ACUTE ACCENT BELOW" . 791)
                             ("COMBINING LEFT TACK BELOW" . 792)
                             ("COMBINING RIGHT TACK BELOW" . 793)
                             ("COMBINING LEFT ANGLE ABOVE" . 794)
                             ("COMBINING HORN" . 795)
                             ("COMBINING LEFT HALF RING BELOW" . 796)
                             ("COMBINING UP TACK BELOW" . 797)
                             ("COMBINING DOWN TACK BELOW" . 798)
                             ("COMBINING PLUS SIGN BELOW" . 799)
                             ("COMBINING MINUS SIGN BELOW" . 800)
                             ("COMBINING PALATALIZED HOOK BELOW" . 801)
                             ("COMBINING RETROFLEX HOOK BELOW" . 802)
                             ("COMBINING DOT BELOW" . 803)
                             ("COMBINING DIAERESIS BELOW" . 804)
                             ("COMBINING RING BELOW" . 805)
                             ("COMBINING COMMA BELOW" . 806)
                             ("COMBINING CEDILLA" . 807)
                             ("COMBINING OGONEK" . 808)
                             ("COMBINING VERTICAL LINE BELOW" . 809)
                             ("COMBINING BRIDGE BELOW" . 810)
                             ("COMBINING INVERTED DOUBLE ARCH BELOW" . 811)
                             ("COMBINING CARON BELOW" . 812)
                             ("COMBINING CIRCUMFLEX ACCENT BELOW" . 813)
                             ("COMBINING BREVE BELOW" . 814)
                             ("COMBINING INVERTED BREVE BELOW" . 815)
                             ("COMBINING TILDE BELOW" . 816)
                             ("COMBINING MACRON BELOW" . 817)
                             ("COMBINING LOW LINE" . 818)
                             ("COMBINING DOUBLE LOW LINE" . 819)
                             ("COMBINING TILDE OVERLAY" . 820)
                             ("COMBINING SHORT STROKE OVERLAY" . 821)
                             ("COMBINING LONG STROKE OVERLAY" . 822)
                             ("COMBINING SHORT SOLIDUS OVERLAY" . 823)
                             ("COMBINING LONG SOLIDUS OVERLAY" . 824)
                             ("COMBINING RIGHT HALF RING BELOW" . 825)
                             ("COMBINING INVERTED BRIDGE BELOW" . 826)
                             ("COMBINING SQUARE BELOW" . 827)
                             ("COMBINING SEAGULL BELOW" . 828)
                             ("COMBINING X ABOVE" . 829)
                             ("COMBINING VERTICAL TILDE" . 830)
                             ("COMBINING DOUBLE OVERLINE" . 831)
                             ("COMBINING GRAVE TONE MARK" . 832)
                             ("COMBINING ACUTE TONE MARK" . 833)
                             ("COMBINING GREEK PERISPOMENI" . 834)
                             ("COMBINING GREEK KORONIS" . 835)
                             ("COMBINING GREEK DIALYTIKA TONOS" . 836)
                             ("COMBINING GREEK YPOGEGRAMMENI" . 837)
                             ("COMBINING BRIDGE ABOVE" . 838)
                             ("COMBINING EQUALS SIGN BELOW" . 839)
                             ("COMBINING DOUBLE VERTICAL LINE BELOW" . 840)
                             ("COMBINING LEFT ANGLE BELOW" . 841)
                             ("COMBINING NOT TILDE ABOVE" . 842)
                             ("COMBINING HOMOTHETIC ABOVE" . 843)
                             ("COMBINING ALMOST EQUAL TO ABOVE" . 844)
                             ("COMBINING LEFT RIGHT ARROW BELOW" . 845)
                             ("COMBINING UPWARDS ARROW BELOW" . 846)
                             ("COMBINING GRAPHEME JOINER" . 847)
                             ("COMBINING DOUBLE TILDE" . 864)
                             ("COMBINING DOUBLE INVERTED BREVE" . 865)
                             ("COMBINING DOUBLE RIGHTWARDS ARROW BELOW" . 866)
                             ("COMBINING LATIN SMALL LETTER A" . 867)
                             ("COMBINING LATIN SMALL LETTER E" . 868)
                             ("COMBINING LATIN SMALL LETTER I" . 869)
                             ("COMBINING LATIN SMALL LETTER O" . 870)
                             ("COMBINING LATIN SMALL LETTER U" . 871)
                             ("COMBINING LATIN SMALL LETTER C" . 872)
                             ("COMBINING LATIN SMALL LETTER D" . 873)
                             ("COMBINING LATIN SMALL LETTER H" . 874)
                             ("COMBINING LATIN SMALL LETTER M" . 875)
                             ("COMBINING LATIN SMALL LETTER R" . 876)
                             ("COMBINING LATIN SMALL LETTER T" . 877)
                             ("COMBINING LATIN SMALL LETTER V" . 878)
                             ("COMBINING LATIN SMALL LETTER X" . 879)
                             ("GREEK NUMERAL SIGN" . 884)
                             ("GREEK LOWER NUMERAL SIGN" . 885)
                             ("GREEK YPOGEGRAMMENI" . 890)
                             ("GREEK QUESTION MARK" . 894)
                             ("GREEK TONOS" . 900)
                             ("GREEK DIALYTIKA TONOS" . 901)
                             ("GREEK CAPITAL LETTER ALPHA WITH TONOS" . 902)
                             ("GREEK ANO TELEIA" . 903)
                             ("GREEK CAPITAL LETTER EPSILON WITH TONOS" . 904)
                             ("GREEK CAPITAL LETTER ETA WITH TONOS" . 905)
                             ("GREEK CAPITAL LETTER IOTA WITH TONOS" . 906)
                             ("GREEK CAPITAL LETTER OMICRON WITH TONOS" . 908)
                             ("GREEK CAPITAL LETTER UPSILON WITH TONOS" . 910)
                             ("GREEK CAPITAL LETTER OMEGA WITH TONOS" . 911)
                             ("GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" . 912)
                             ("GREEK CAPITAL LETTER ALPHA" . 913)
                             ("GREEK CAPITAL LETTER BETA" . 914)
                             ("GREEK CAPITAL LETTER GAMMA" . 915)
                             ("GREEK CAPITAL LETTER DELTA" . 916)
                             ("GREEK CAPITAL LETTER EPSILON" . 917)
                             ("GREEK CAPITAL LETTER ZETA" . 918)
                             ("GREEK CAPITAL LETTER ETA" . 919)
                             ("GREEK CAPITAL LETTER THETA" . 920)
                             ("GREEK CAPITAL LETTER IOTA" . 921)
                             ("GREEK CAPITAL LETTER KAPPA" . 922)
                             ("GREEK CAPITAL LETTER LAMDA" . 923)
                             ("GREEK CAPITAL LETTER MU" . 924)
                             ("GREEK CAPITAL LETTER NU" . 925)
                             ("GREEK CAPITAL LETTER XI" . 926)
                             ("GREEK CAPITAL LETTER OMICRON" . 927)
                             ("GREEK CAPITAL LETTER PI" . 928)
                             ("GREEK CAPITAL LETTER RHO" . 929)
                             ("GREEK CAPITAL LETTER SIGMA" . 931)
                             ("GREEK CAPITAL LETTER TAU" . 932)
                             ("GREEK CAPITAL LETTER UPSILON" . 933)
                             ("GREEK CAPITAL LETTER PHI" . 934)
                             ("GREEK CAPITAL LETTER CHI" . 935)
                             ("GREEK CAPITAL LETTER PSI" . 936)
                             ("GREEK CAPITAL LETTER OMEGA" . 937)
                             ("GREEK CAPITAL LETTER IOTA WITH DIALYTIKA" . 938)
                             ("GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA" . 939)
                             ("GREEK SMALL LETTER ALPHA WITH TONOS" . 940)
                             ("GREEK SMALL LETTER EPSILON WITH TONOS" . 941)
                             ("GREEK SMALL LETTER ETA WITH TONOS" . 942)
                             ("GREEK SMALL LETTER IOTA WITH TONOS" . 943)
                             ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS" . 944)
                             ("GREEK SMALL LETTER ALPHA" . 945)
                             ("GREEK SMALL LETTER BETA" . 946)
                             ("GREEK SMALL LETTER GAMMA" . 947)
                             ("GREEK SMALL LETTER DELTA" . 948)
                             ("GREEK SMALL LETTER EPSILON" . 949)
                             ("GREEK SMALL LETTER ZETA" . 950)
                             ("GREEK SMALL LETTER ETA" . 951)
                             ("GREEK SMALL LETTER THETA" . 952)
                             ("GREEK SMALL LETTER IOTA" . 953)
                             ("GREEK SMALL LETTER KAPPA" . 954)
                             ("GREEK SMALL LETTER LAMDA" . 955)
                             ("GREEK SMALL LETTER MU" . 956)
                             ("GREEK SMALL LETTER NU" . 957)
                             ("GREEK SMALL LETTER XI" . 958)
                             ("GREEK SMALL LETTER OMICRON" . 959)
                             ("GREEK SMALL LETTER PI" . 960)
                             ("GREEK SMALL LETTER RHO" . 961)
                             ("GREEK SMALL LETTER FINAL SIGMA" . 962)
                             ("GREEK SMALL LETTER SIGMA" . 963)
                             ("GREEK SMALL LETTER TAU" . 964)
                             ("GREEK SMALL LETTER UPSILON" . 965)
                             ("GREEK SMALL LETTER PHI" . 966)
                             ("GREEK SMALL LETTER CHI" . 967)
                             ("GREEK SMALL LETTER PSI" . 968)
                             ("GREEK SMALL LETTER OMEGA" . 969)
                             ("GREEK SMALL LETTER IOTA WITH DIALYTIKA" . 970)
                             ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA" . 971)
                             ("GREEK SMALL LETTER OMICRON WITH TONOS" . 972)
                             ("GREEK SMALL LETTER UPSILON WITH TONOS" . 973)
                             ("GREEK SMALL LETTER OMEGA WITH TONOS" . 974)
                             ("GREEK BETA SYMBOL" . 976)
                             ("GREEK THETA SYMBOL" . 977)
                             ("GREEK UPSILON WITH HOOK SYMBOL" . 978)
                             ("GREEK UPSILON WITH ACUTE AND HOOK SYMBOL" . 979)
                             ("GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL" . 980)
                             ("GREEK PHI SYMBOL" . 981)
                             ("GREEK PI SYMBOL" . 982)
                             ("GREEK KAI SYMBOL" . 983)
                             ("GREEK LETTER ARCHAIC KOPPA" . 984)
                             ("GREEK SMALL LETTER ARCHAIC KOPPA" . 985)
                             ("GREEK LETTER STIGMA" . 986)
                             ("GREEK SMALL LETTER STIGMA" . 987)
                             ("GREEK LETTER DIGAMMA" . 988)
                             ("GREEK SMALL LETTER DIGAMMA" . 989)
                             ("GREEK LETTER KOPPA" . 990)
                             ("GREEK SMALL LETTER KOPPA" . 991)
                             ("GREEK LETTER SAMPI" . 992)
                             ("GREEK SMALL LETTER SAMPI" . 993)
                             ("COPTIC CAPITAL LETTER SHEI" . 994)
                             ("COPTIC SMALL LETTER SHEI" . 995)
                             ("COPTIC CAPITAL LETTER FEI" . 996)
                             ("COPTIC SMALL LETTER FEI" . 997)
                             ("COPTIC CAPITAL LETTER KHEI" . 998)
                             ("COPTIC SMALL LETTER KHEI" . 999)
                             ("COPTIC CAPITAL LETTER HORI" . 1000)
                             ("COPTIC SMALL LETTER HORI" . 1001)
                             ("COPTIC CAPITAL LETTER GANGIA" . 1002)
                             ("COPTIC SMALL LETTER GANGIA" . 1003)
                             ("COPTIC CAPITAL LETTER SHIMA" . 1004)
                             ("COPTIC SMALL LETTER SHIMA" . 1005)
                             ("COPTIC CAPITAL LETTER DEI" . 1006)
                             ("COPTIC SMALL LETTER DEI" . 1007)
                             ("GREEK KAPPA SYMBOL" . 1008)
                             ("GREEK RHO SYMBOL" . 1009)
                             ("GREEK LUNATE SIGMA SYMBOL" . 1010)
                             ("GREEK LETTER YOT" . 1011)
                             ("GREEK CAPITAL THETA SYMBOL" . 1012)
                             ("GREEK LUNATE EPSILON SYMBOL" . 1013)
                             ("GREEK REVERSED LUNATE EPSILON SYMBOL" . 1014)
                             ("CYRILLIC CAPITAL LETTER IE WITH GRAVE" . 1024)
                             ("CYRILLIC CAPITAL LETTER IO" . 1025)
                             ("CYRILLIC CAPITAL LETTER DJE" . 1026)
                             ("CYRILLIC CAPITAL LETTER GJE" . 1027)
                             ("CYRILLIC CAPITAL LETTER UKRAINIAN IE" . 1028)
                             ("CYRILLIC CAPITAL LETTER DZE" . 1029)
                             ("CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I" . 1030)
                             ("CYRILLIC CAPITAL LETTER YI" . 1031)
                             ("CYRILLIC CAPITAL LETTER JE" . 1032)
                             ("CYRILLIC CAPITAL LETTER LJE" . 1033)
                             ("CYRILLIC CAPITAL LETTER NJE" . 1034)
                             ("CYRILLIC CAPITAL LETTER TSHE" . 1035)
                             ("CYRILLIC CAPITAL LETTER KJE" . 1036)
                             ("CYRILLIC CAPITAL LETTER I WITH GRAVE" . 1037)
                             ("CYRILLIC CAPITAL LETTER SHORT U" . 1038)
                             ("CYRILLIC CAPITAL LETTER DZHE" . 1039)
                             ("CYRILLIC CAPITAL LETTER A" . 1040)
                             ("CYRILLIC CAPITAL LETTER BE" . 1041)
                             ("CYRILLIC CAPITAL LETTER VE" . 1042)
                             ("CYRILLIC CAPITAL LETTER GHE" . 1043)
                             ("CYRILLIC CAPITAL LETTER DE" . 1044)
                             ("CYRILLIC CAPITAL LETTER IE" . 1045)
                             ("CYRILLIC CAPITAL LETTER ZHE" . 1046)
                             ("CYRILLIC CAPITAL LETTER ZE" . 1047)
                             ("CYRILLIC CAPITAL LETTER I" . 1048)
                             ("CYRILLIC CAPITAL LETTER SHORT I" . 1049)
                             ("CYRILLIC CAPITAL LETTER KA" . 1050)
                             ("CYRILLIC CAPITAL LETTER EL" . 1051)
                             ("CYRILLIC CAPITAL LETTER EM" . 1052)
                             ("CYRILLIC CAPITAL LETTER EN" . 1053)
                             ("CYRILLIC CAPITAL LETTER O" . 1054)
                             ("CYRILLIC CAPITAL LETTER PE" . 1055)
                             ("CYRILLIC CAPITAL LETTER ER" . 1056)
                             ("CYRILLIC CAPITAL LETTER ES" . 1057)
                             ("CYRILLIC CAPITAL LETTER TE" . 1058)
                             ("CYRILLIC CAPITAL LETTER U" . 1059)
                             ("CYRILLIC CAPITAL LETTER EF" . 1060)
                             ("CYRILLIC CAPITAL LETTER HA" . 1061)
                             ("CYRILLIC CAPITAL LETTER TSE" . 1062)
                             ("CYRILLIC CAPITAL LETTER CHE" . 1063)
                             ("CYRILLIC CAPITAL LETTER SHA" . 1064)
                             ("CYRILLIC CAPITAL LETTER SHCHA" . 1065)
                             ("CYRILLIC CAPITAL LETTER HARD SIGN" . 1066)
                             ("CYRILLIC CAPITAL LETTER YERU" . 1067)
                             ("CYRILLIC CAPITAL LETTER SOFT SIGN" . 1068)
                             ("CYRILLIC CAPITAL LETTER E" . 1069)
                             ("CYRILLIC CAPITAL LETTER YU" . 1070)
                             ("CYRILLIC CAPITAL LETTER YA" . 1071)
                             ("CYRILLIC SMALL LETTER A" . 1072)
                             ("CYRILLIC SMALL LETTER BE" . 1073)
                             ("CYRILLIC SMALL LETTER VE" . 1074)
                             ("CYRILLIC SMALL LETTER GHE" . 1075)
                             ("CYRILLIC SMALL LETTER DE" . 1076)
                             ("CYRILLIC SMALL LETTER IE" . 1077)
                             ("CYRILLIC SMALL LETTER ZHE" . 1078)
                             ("CYRILLIC SMALL LETTER ZE" . 1079)
                             ("CYRILLIC SMALL LETTER I" . 1080)
                             ("CYRILLIC SMALL LETTER SHORT I" . 1081)
                             ("CYRILLIC SMALL LETTER KA" . 1082)
                             ("CYRILLIC SMALL LETTER EL" . 1083)
                             ("CYRILLIC SMALL LETTER EM" . 1084)
                             ("CYRILLIC SMALL LETTER EN" . 1085)
                             ("CYRILLIC SMALL LETTER O" . 1086)
                             ("CYRILLIC SMALL LETTER PE" . 1087)
                             ("CYRILLIC SMALL LETTER ER" . 1088)
                             ("CYRILLIC SMALL LETTER ES" . 1089)
                             ("CYRILLIC SMALL LETTER TE" . 1090)
                             ("CYRILLIC SMALL LETTER U" . 1091)
                             ("CYRILLIC SMALL LETTER EF" . 1092)
                             ("CYRILLIC SMALL LETTER HA" . 1093)
                             ("CYRILLIC SMALL LETTER TSE" . 1094)
                             ("CYRILLIC SMALL LETTER CHE" . 1095)
                             ("CYRILLIC SMALL LETTER SHA" . 1096)
                             ("CYRILLIC SMALL LETTER SHCHA" . 1097)
                             ("CYRILLIC SMALL LETTER HARD SIGN" . 1098)
                             ("CYRILLIC SMALL LETTER YERU" . 1099)
                             ("CYRILLIC SMALL LETTER SOFT SIGN" . 1100)
                             ("CYRILLIC SMALL LETTER E" . 1101)
                             ("CYRILLIC SMALL LETTER YU" . 1102)
                             ("CYRILLIC SMALL LETTER YA" . 1103)
                             ("CYRILLIC SMALL LETTER IE WITH GRAVE" . 1104)
                             ("CYRILLIC SMALL LETTER IO" . 1105)
                             ("CYRILLIC SMALL LETTER DJE" . 1106)
                             ("CYRILLIC SMALL LETTER GJE" . 1107)
                             ("CYRILLIC SMALL LETTER UKRAINIAN IE" . 1108)
                             ("CYRILLIC SMALL LETTER DZE" . 1109)
                             ("CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I" . 1110)
                             ("CYRILLIC SMALL LETTER YI" . 1111)
                             ("CYRILLIC SMALL LETTER JE" . 1112)
                             ("CYRILLIC SMALL LETTER LJE" . 1113)
                             ("CYRILLIC SMALL LETTER NJE" . 1114)
                             ("CYRILLIC SMALL LETTER TSHE" . 1115)
                             ("CYRILLIC SMALL LETTER KJE" . 1116)
                             ("CYRILLIC SMALL LETTER I WITH GRAVE" . 1117)
                             ("CYRILLIC SMALL LETTER SHORT U" . 1118)
                             ("CYRILLIC SMALL LETTER DZHE" . 1119)
                             ("CYRILLIC CAPITAL LETTER OMEGA" . 1120)
                             ("CYRILLIC SMALL LETTER OMEGA" . 1121)
                             ("CYRILLIC CAPITAL LETTER YAT" . 1122)
                             ("CYRILLIC SMALL LETTER YAT" . 1123)
                             ("CYRILLIC CAPITAL LETTER IOTIFIED E" . 1124)
                             ("CYRILLIC SMALL LETTER IOTIFIED E" . 1125)
                             ("CYRILLIC CAPITAL LETTER LITTLE YUS" . 1126)
                             ("CYRILLIC SMALL LETTER LITTLE YUS" . 1127)
                             ("CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS" . 1128)
                             ("CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS" . 1129)
                             ("CYRILLIC CAPITAL LETTER BIG YUS" . 1130)
                             ("CYRILLIC SMALL LETTER BIG YUS" . 1131)
                             ("CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS" . 1132)
                             ("CYRILLIC SMALL LETTER IOTIFIED BIG YUS" . 1133)
                             ("CYRILLIC CAPITAL LETTER KSI" . 1134)
                             ("CYRILLIC SMALL LETTER KSI" . 1135)
                             ("CYRILLIC CAPITAL LETTER PSI" . 1136)
                             ("CYRILLIC SMALL LETTER PSI" . 1137)
                             ("CYRILLIC CAPITAL LETTER FITA" . 1138)
                             ("CYRILLIC SMALL LETTER FITA" . 1139)
                             ("CYRILLIC CAPITAL LETTER IZHITSA" . 1140)
                             ("CYRILLIC SMALL LETTER IZHITSA" . 1141)
                             ("CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" . 1142)
                             ("CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT" . 1143)
                             ("CYRILLIC CAPITAL LETTER UK" . 1144)
                             ("CYRILLIC SMALL LETTER UK" . 1145)
                             ("CYRILLIC CAPITAL LETTER ROUND OMEGA" . 1146)
                             ("CYRILLIC SMALL LETTER ROUND OMEGA" . 1147)
                             ("CYRILLIC CAPITAL LETTER OMEGA WITH TITLO" . 1148)
                             ("CYRILLIC SMALL LETTER OMEGA WITH TITLO" . 1149)
                             ("CYRILLIC CAPITAL LETTER OT" . 1150)
                             ("CYRILLIC SMALL LETTER OT" . 1151)
                             ("CYRILLIC CAPITAL LETTER KOPPA" . 1152)
                             ("CYRILLIC SMALL LETTER KOPPA" . 1153)
                             ("CYRILLIC THOUSANDS SIGN" . 1154)
                             ("COMBINING CYRILLIC TITLO" . 1155)
                             ("COMBINING CYRILLIC PALATALIZATION" . 1156)
                             ("COMBINING CYRILLIC DASIA PNEUMATA" . 1157)
                             ("COMBINING CYRILLIC PSILI PNEUMATA" . 1158)
                             ("COMBINING CYRILLIC HUNDRED THOUSANDS SIGN" . 1160)
                             ("COMBINING CYRILLIC MILLIONS SIGN" . 1161)
                             ("CYRILLIC CAPITAL LETTER SHORT I WITH TAIL" . 1162)
                             ("CYRILLIC SMALL LETTER SHORT I WITH TAIL" . 1163)
                             ("CYRILLIC CAPITAL LETTER SEMISOFT SIGN" . 1164)
                             ("CYRILLIC SMALL LETTER SEMISOFT SIGN" . 1165)
                             ("CYRILLIC CAPITAL LETTER ER WITH TICK" . 1166)
                             ("CYRILLIC SMALL LETTER ER WITH TICK" . 1167)
                             ("CYRILLIC CAPITAL LETTER GHE WITH UPTURN" . 1168)
                             ("CYRILLIC SMALL LETTER GHE WITH UPTURN" . 1169)
                             ("CYRILLIC CAPITAL LETTER GHE WITH STROKE" . 1170)
                             ("CYRILLIC SMALL LETTER GHE WITH STROKE" . 1171)
                             ("CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK" . 1172)
                             ("CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK" . 1173)
                             ("CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER" . 1174)
                             ("CYRILLIC SMALL LETTER ZHE WITH DESCENDER" . 1175)
                             ("CYRILLIC CAPITAL LETTER ZE WITH DESCENDER" . 1176)
                             ("CYRILLIC SMALL LETTER ZE WITH DESCENDER" . 1177)
                             ("CYRILLIC CAPITAL LETTER KA WITH DESCENDER" . 1178)
                             ("CYRILLIC SMALL LETTER KA WITH DESCENDER" . 1179)
                             ("CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE" . 1180)
                             ("CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE" . 1181)
                             ("CYRILLIC CAPITAL LETTER KA WITH STROKE" . 1182)
                             ("CYRILLIC SMALL LETTER KA WITH STROKE" . 1183)
                             ("CYRILLIC CAPITAL LETTER BASHKIR KA" . 1184)
                             ("CYRILLIC SMALL LETTER BASHKIR KA" . 1185)
                             ("CYRILLIC CAPITAL LETTER EN WITH DESCENDER" . 1186)
                             ("CYRILLIC SMALL LETTER EN WITH DESCENDER" . 1187)
                             ("CYRILLIC CAPITAL LIGATURE EN GHE" . 1188)
                             ("CYRILLIC SMALL LIGATURE EN GHE" . 1189)
                             ("CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK" . 1190)
                             ("CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK" . 1191)
                             ("CYRILLIC CAPITAL LETTER ABKHASIAN HA" . 1192)
                             ("CYRILLIC SMALL LETTER ABKHASIAN HA" . 1193)
                             ("CYRILLIC CAPITAL LETTER ES WITH DESCENDER" . 1194)
                             ("CYRILLIC SMALL LETTER ES WITH DESCENDER" . 1195)
                             ("CYRILLIC CAPITAL LETTER TE WITH DESCENDER" . 1196)
                             ("CYRILLIC SMALL LETTER TE WITH DESCENDER" . 1197)
                             ("CYRILLIC CAPITAL LETTER STRAIGHT U" . 1198)
                             ("CYRILLIC SMALL LETTER STRAIGHT U" . 1199)
                             ("CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE" . 1200)
                             ("CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE" . 1201)
                             ("CYRILLIC CAPITAL LETTER HA WITH DESCENDER" . 1202)
                             ("CYRILLIC SMALL LETTER HA WITH DESCENDER" . 1203)
                             ("CYRILLIC CAPITAL LIGATURE TE TSE" . 1204)
                             ("CYRILLIC SMALL LIGATURE TE TSE" . 1205)
                             ("CYRILLIC CAPITAL LETTER CHE WITH DESCENDER" . 1206)
                             ("CYRILLIC SMALL LETTER CHE WITH DESCENDER" . 1207)
                             ("CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE" . 1208)
                             ("CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE" . 1209)
                             ("CYRILLIC CAPITAL LETTER SHHA" . 1210)
                             ("CYRILLIC SMALL LETTER SHHA" . 1211)
                             ("CYRILLIC CAPITAL LETTER ABKHASIAN CHE" . 1212)
                             ("CYRILLIC SMALL LETTER ABKHASIAN CHE" . 1213)
                             ("CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER" . 1214)
                             ("CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER" . 1215)
                             ("CYRILLIC LETTER PALOCHKA" . 1216)
                             ("CYRILLIC CAPITAL LETTER ZHE WITH BREVE" . 1217)
                             ("CYRILLIC SMALL LETTER ZHE WITH BREVE" . 1218)
                             ("CYRILLIC CAPITAL LETTER KA WITH HOOK" . 1219)
                             ("CYRILLIC SMALL LETTER KA WITH HOOK" . 1220)
                             ("CYRILLIC CAPITAL LETTER EL WITH TAIL" . 1221)
                             ("CYRILLIC SMALL LETTER EL WITH TAIL" . 1222)
                             ("CYRILLIC CAPITAL LETTER EN WITH HOOK" . 1223)
                             ("CYRILLIC SMALL LETTER EN WITH HOOK" . 1224)
                             ("CYRILLIC CAPITAL LETTER EN WITH TAIL" . 1225)
                             ("CYRILLIC SMALL LETTER EN WITH TAIL" . 1226)
                             ("CYRILLIC CAPITAL LETTER KHAKASSIAN CHE" . 1227)
                             ("CYRILLIC SMALL LETTER KHAKASSIAN CHE" . 1228)
                             ("CYRILLIC CAPITAL LETTER EM WITH TAIL" . 1229)
                             ("CYRILLIC SMALL LETTER EM WITH TAIL" . 1230)
                             ("CYRILLIC CAPITAL LETTER A WITH BREVE" . 1232)
                             ("CYRILLIC SMALL LETTER A WITH BREVE" . 1233)
                             ("CYRILLIC CAPITAL LETTER A WITH DIAERESIS" . 1234)
                             ("CYRILLIC SMALL LETTER A WITH DIAERESIS" . 1235)
                             ("CYRILLIC CAPITAL LIGATURE A IE" . 1236)
                             ("CYRILLIC SMALL LIGATURE A IE" . 1237)
                             ("CYRILLIC CAPITAL LETTER IE WITH BREVE" . 1238)
                             ("CYRILLIC SMALL LETTER IE WITH BREVE" . 1239)
                             ("CYRILLIC CAPITAL LETTER SCHWA" . 1240)
                             ("CYRILLIC SMALL LETTER SCHWA" . 1241)
                             ("CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS" . 1242)
                             ("CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS" . 1243)
                             ("CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS" . 1244)
                             ("CYRILLIC SMALL LETTER ZHE WITH DIAERESIS" . 1245)
                             ("CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS" . 1246)
                             ("CYRILLIC SMALL LETTER ZE WITH DIAERESIS" . 1247)
                             ("CYRILLIC CAPITAL LETTER ABKHASIAN DZE" . 1248)
                             ("CYRILLIC SMALL LETTER ABKHASIAN DZE" . 1249)
                             ("CYRILLIC CAPITAL LETTER I WITH MACRON" . 1250)
                             ("CYRILLIC SMALL LETTER I WITH MACRON" . 1251)
                             ("CYRILLIC CAPITAL LETTER I WITH DIAERESIS" . 1252)
                             ("CYRILLIC SMALL LETTER I WITH DIAERESIS" . 1253)
                             ("CYRILLIC CAPITAL LETTER O WITH DIAERESIS" . 1254)
                             ("CYRILLIC SMALL LETTER O WITH DIAERESIS" . 1255)
                             ("CYRILLIC CAPITAL LETTER BARRED O" . 1256)
                             ("CYRILLIC SMALL LETTER BARRED O" . 1257)
                             ("CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS" . 1258)
                             ("CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS" . 1259)
                             ("CYRILLIC CAPITAL LETTER E WITH DIAERESIS" . 1260)
                             ("CYRILLIC SMALL LETTER E WITH DIAERESIS" . 1261)
                             ("CYRILLIC CAPITAL LETTER U WITH MACRON" . 1262)
                             ("CYRILLIC SMALL LETTER U WITH MACRON" . 1263)
                             ("CYRILLIC CAPITAL LETTER U WITH DIAERESIS" . 1264)
                             ("CYRILLIC SMALL LETTER U WITH DIAERESIS" . 1265)
                             ("CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE" . 1266)
                             ("CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE" . 1267)
                             ("CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS" . 1268)
                             ("CYRILLIC SMALL LETTER CHE WITH DIAERESIS" . 1269)
                             ("CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS" . 1272)
                             ("CYRILLIC SMALL LETTER YERU WITH DIAERESIS" . 1273)
                             ("CYRILLIC CAPITAL LETTER KOMI DE" . 1280)
                             ("CYRILLIC SMALL LETTER KOMI DE" . 1281)
                             ("CYRILLIC CAPITAL LETTER KOMI DJE" . 1282)
                             ("CYRILLIC SMALL LETTER KOMI DJE" . 1283)
                             ("CYRILLIC CAPITAL LETTER KOMI ZJE" . 1284)
                             ("CYRILLIC SMALL LETTER KOMI ZJE" . 1285)
                             ("CYRILLIC CAPITAL LETTER KOMI DZJE" . 1286)
                             ("CYRILLIC SMALL LETTER KOMI DZJE" . 1287)
                             ("CYRILLIC CAPITAL LETTER KOMI LJE" . 1288)
                             ("CYRILLIC SMALL LETTER KOMI LJE" . 1289)
                             ("CYRILLIC CAPITAL LETTER KOMI NJE" . 1290)
                             ("CYRILLIC SMALL LETTER KOMI NJE" . 1291)
                             ("CYRILLIC CAPITAL LETTER KOMI SJE" . 1292)
                             ("CYRILLIC SMALL LETTER KOMI SJE" . 1293)
                             ("CYRILLIC CAPITAL LETTER KOMI TJE" . 1294)
                             ("CYRILLIC SMALL LETTER KOMI TJE" . 1295)
                             ("ARMENIAN CAPITAL LETTER AYB" . 1329)
                             ("ARMENIAN CAPITAL LETTER BEN" . 1330)
                             ("ARMENIAN CAPITAL LETTER GIM" . 1331)
                             ("ARMENIAN CAPITAL LETTER DA" . 1332)
                             ("ARMENIAN CAPITAL LETTER ECH" . 1333)
                             ("ARMENIAN CAPITAL LETTER ZA" . 1334)
                             ("ARMENIAN CAPITAL LETTER EH" . 1335)
                             ("ARMENIAN CAPITAL LETTER ET" . 1336)
                             ("ARMENIAN CAPITAL LETTER TO" . 1337)
                             ("ARMENIAN CAPITAL LETTER ZHE" . 1338)
                             ("ARMENIAN CAPITAL LETTER INI" . 1339)
                             ("ARMENIAN CAPITAL LETTER LIWN" . 1340)
                             ("ARMENIAN CAPITAL LETTER XEH" . 1341)
                             ("ARMENIAN CAPITAL LETTER CA" . 1342)
                             ("ARMENIAN CAPITAL LETTER KEN" . 1343)
                             ("ARMENIAN CAPITAL LETTER HO" . 1344)
                             ("ARMENIAN CAPITAL LETTER JA" . 1345)
                             ("ARMENIAN CAPITAL LETTER GHAD" . 1346)
                             ("ARMENIAN CAPITAL LETTER CHEH" . 1347)
                             ("ARMENIAN CAPITAL LETTER MEN" . 1348)
                             ("ARMENIAN CAPITAL LETTER YI" . 1349)
                             ("ARMENIAN CAPITAL LETTER NOW" . 1350)
                             ("ARMENIAN CAPITAL LETTER SHA" . 1351)
                             ("ARMENIAN CAPITAL LETTER VO" . 1352)
                             ("ARMENIAN CAPITAL LETTER CHA" . 1353)
                             ("ARMENIAN CAPITAL LETTER PEH" . 1354)
                             ("ARMENIAN CAPITAL LETTER JHEH" . 1355)
                             ("ARMENIAN CAPITAL LETTER RA" . 1356)
                             ("ARMENIAN CAPITAL LETTER SEH" . 1357)
                             ("ARMENIAN CAPITAL LETTER VEW" . 1358)
                             ("ARMENIAN CAPITAL LETTER TIWN" . 1359)
                             ("ARMENIAN CAPITAL LETTER REH" . 1360)
                             ("ARMENIAN CAPITAL LETTER CO" . 1361)
                             ("ARMENIAN CAPITAL LETTER YIWN" . 1362)
                             ("ARMENIAN CAPITAL LETTER PIWR" . 1363)
                             ("ARMENIAN CAPITAL LETTER KEH" . 1364)
                             ("ARMENIAN CAPITAL LETTER OH" . 1365)
                             ("ARMENIAN CAPITAL LETTER FEH" . 1366)
                             ("ARMENIAN MODIFIER LETTER LEFT HALF RING" . 1369)
                             ("ARMENIAN APOSTROPHE" . 1370)
                             ("ARMENIAN EMPHASIS MARK" . 1371)
                             ("ARMENIAN EXCLAMATION MARK" . 1372)
                             ("ARMENIAN COMMA" . 1373)
                             ("ARMENIAN QUESTION MARK" . 1374)
                             ("ARMENIAN ABBREVIATION MARK" . 1375)
                             ("ARMENIAN SMALL LETTER AYB" . 1377)
                             ("ARMENIAN SMALL LETTER BEN" . 1378)
                             ("ARMENIAN SMALL LETTER GIM" . 1379)
                             ("ARMENIAN SMALL LETTER DA" . 1380)
                             ("ARMENIAN SMALL LETTER ECH" . 1381)
                             ("ARMENIAN SMALL LETTER ZA" . 1382)
                             ("ARMENIAN SMALL LETTER EH" . 1383)
                             ("ARMENIAN SMALL LETTER ET" . 1384)
                             ("ARMENIAN SMALL LETTER TO" . 1385)
                             ("ARMENIAN SMALL LETTER ZHE" . 1386)
                             ("ARMENIAN SMALL LETTER INI" . 1387)
                             ("ARMENIAN SMALL LETTER LIWN" . 1388)
                             ("ARMENIAN SMALL LETTER XEH" . 1389)
                             ("ARMENIAN SMALL LETTER CA" . 1390)
                             ("ARMENIAN SMALL LETTER KEN" . 1391)
                             ("ARMENIAN SMALL LETTER HO" . 1392)
                             ("ARMENIAN SMALL LETTER JA" . 1393)
                             ("ARMENIAN SMALL LETTER GHAD" . 1394)
                             ("ARMENIAN SMALL LETTER CHEH" . 1395)
                             ("ARMENIAN SMALL LETTER MEN" . 1396)
                             ("ARMENIAN SMALL LETTER YI" . 1397)
                             ("ARMENIAN SMALL LETTER NOW" . 1398)
                             ("ARMENIAN SMALL LETTER SHA" . 1399)
                             ("ARMENIAN SMALL LETTER VO" . 1400)
                             ("ARMENIAN SMALL LETTER CHA" . 1401)
                             ("ARMENIAN SMALL LETTER PEH" . 1402)
                             ("ARMENIAN SMALL LETTER JHEH" . 1403)
                             ("ARMENIAN SMALL LETTER RA" . 1404)
                             ("ARMENIAN SMALL LETTER SEH" . 1405)
                             ("ARMENIAN SMALL LETTER VEW" . 1406)
                             ("ARMENIAN SMALL LETTER TIWN" . 1407)
                             ("ARMENIAN SMALL LETTER REH" . 1408)
                             ("ARMENIAN SMALL LETTER CO" . 1409)
                             ("ARMENIAN SMALL LETTER YIWN" . 1410)
                             ("ARMENIAN SMALL LETTER PIWR" . 1411)
                             ("ARMENIAN SMALL LETTER KEH" . 1412)
                             ("ARMENIAN SMALL LETTER OH" . 1413)
                             ("ARMENIAN SMALL LETTER FEH" . 1414)
                             ("ARMENIAN SMALL LIGATURE ECH YIWN" . 1415)
                             ("ARMENIAN FULL STOP" . 1417)
                             ("ARMENIAN HYPHEN" . 1418)
                             ("HEBREW ACCENT ETNAHTA" . 1425)
                             ("HEBREW ACCENT SEGOL" . 1426)
                             ("HEBREW ACCENT SHALSHELET" . 1427)
                             ("HEBREW ACCENT ZAQEF QATAN" . 1428)
                             ("HEBREW ACCENT ZAQEF GADOL" . 1429)
                             ("HEBREW ACCENT TIPEHA" . 1430)
                             ("HEBREW ACCENT REVIA" . 1431)
                             ("HEBREW ACCENT ZARQA" . 1432)
                             ("HEBREW ACCENT PASHTA" . 1433)
                             ("HEBREW ACCENT YETIV" . 1434)
                             ("HEBREW ACCENT TEVIR" . 1435)
                             ("HEBREW ACCENT GERESH" . 1436)
                             ("HEBREW ACCENT GERESH MUQDAM" . 1437)
                             ("HEBREW ACCENT GERSHAYIM" . 1438)
                             ("HEBREW ACCENT QARNEY PARA" . 1439)
                             ("HEBREW ACCENT TELISHA GEDOLA" . 1440)
                             ("HEBREW ACCENT PAZER" . 1441)
                             ("HEBREW ACCENT MUNAH" . 1443)
                             ("HEBREW ACCENT MAHAPAKH" . 1444)
                             ("HEBREW ACCENT MERKHA" . 1445)
                             ("HEBREW ACCENT MERKHA KEFULA" . 1446)
                             ("HEBREW ACCENT DARGA" . 1447)
                             ("HEBREW ACCENT QADMA" . 1448)
                             ("HEBREW ACCENT TELISHA QETANA" . 1449)
                             ("HEBREW ACCENT YERAH BEN YOMO" . 1450)
                             ("HEBREW ACCENT OLE" . 1451)
                             ("HEBREW ACCENT ILUY" . 1452)
                             ("HEBREW ACCENT DEHI" . 1453)
                             ("HEBREW ACCENT ZINOR" . 1454)
                             ("HEBREW MARK MASORA CIRCLE" . 1455)
                             ("HEBREW POINT SHEVA" . 1456)
                             ("HEBREW POINT HATAF SEGOL" . 1457)
                             ("HEBREW POINT HATAF PATAH" . 1458)
                             ("HEBREW POINT HATAF QAMATS" . 1459)
                             ("HEBREW POINT HIRIQ" . 1460)
                             ("HEBREW POINT TSERE" . 1461)
                             ("HEBREW POINT SEGOL" . 1462)
                             ("HEBREW POINT PATAH" . 1463)
                             ("HEBREW POINT QAMATS" . 1464)
                             ("HEBREW POINT HOLAM" . 1465)
                             ("HEBREW POINT QUBUTS" . 1467)
                             ("HEBREW POINT DAGESH OR MAPIQ" . 1468)
                             ("HEBREW POINT METEG" . 1469)
                             ("HEBREW PUNCTUATION MAQAF" . 1470)
                             ("HEBREW POINT RAFE" . 1471)
                             ("HEBREW PUNCTUATION PASEQ" . 1472)
                             ("HEBREW POINT SHIN DOT" . 1473)
                             ("HEBREW POINT SIN DOT" . 1474)
                             ("HEBREW PUNCTUATION SOF PASUQ" . 1475)
                             ("HEBREW MARK UPPER DOT" . 1476)
                             ("HEBREW LETTER ALEF" . 1488)
                             ("HEBREW LETTER BET" . 1489)
                             ("HEBREW LETTER GIMEL" . 1490)
                             ("HEBREW LETTER DALET" . 1491)
                             ("HEBREW LETTER HE" . 1492)
                             ("HEBREW LETTER VAV" . 1493)
                             ("HEBREW LETTER ZAYIN" . 1494)
                             ("HEBREW LETTER HET" . 1495)
                             ("HEBREW LETTER TET" . 1496)
                             ("HEBREW LETTER YOD" . 1497)
                             ("HEBREW LETTER FINAL KAF" . 1498)
                             ("HEBREW LETTER KAF" . 1499)
                             ("HEBREW LETTER LAMED" . 1500)
                             ("HEBREW LETTER FINAL MEM" . 1501)
                             ("HEBREW LETTER MEM" . 1502)
                             ("HEBREW LETTER FINAL NUN" . 1503)
                             ("HEBREW LETTER NUN" . 1504)
                             ("HEBREW LETTER SAMEKH" . 1505)
                             ("HEBREW LETTER AYIN" . 1506)
                             ("HEBREW LETTER FINAL PE" . 1507)
                             ("HEBREW LETTER PE" . 1508)
                             ("HEBREW LETTER FINAL TSADI" . 1509)
                             ("HEBREW LETTER TSADI" . 1510)
                             ("HEBREW LETTER QOF" . 1511)
                             ("HEBREW LETTER RESH" . 1512)
                             ("HEBREW LETTER SHIN" . 1513)
                             ("HEBREW LETTER TAV" . 1514)
                             ("HEBREW LIGATURE YIDDISH DOUBLE VAV" . 1520)
                             ("HEBREW LIGATURE YIDDISH VAV YOD" . 1521)
                             ("HEBREW LIGATURE YIDDISH DOUBLE YOD" . 1522)
                             ("HEBREW PUNCTUATION GERESH" . 1523)
                             ("HEBREW PUNCTUATION GERSHAYIM" . 1524)
                             ("ARABIC COMMA" . 1548)
                             ("ARABIC SEMICOLON" . 1563)
                             ("ARABIC QUESTION MARK" . 1567)
                             ("ARABIC LETTER HAMZA" . 1569)
                             ("ARABIC LETTER ALEF WITH MADDA ABOVE" . 1570)
                             ("ARABIC LETTER ALEF WITH HAMZA ABOVE" . 1571)
                             ("ARABIC LETTER WAW WITH HAMZA ABOVE" . 1572)
                             ("ARABIC LETTER ALEF WITH HAMZA BELOW" . 1573)
                             ("ARABIC LETTER YEH WITH HAMZA ABOVE" . 1574)
                             ("ARABIC LETTER ALEF" . 1575)
                             ("ARABIC LETTER BEH" . 1576)
                             ("ARABIC LETTER TEH MARBUTA" . 1577)
                             ("ARABIC LETTER TEH" . 1578)
                             ("ARABIC LETTER THEH" . 1579)
                             ("ARABIC LETTER JEEM" . 1580)
                             ("ARABIC LETTER HAH" . 1581)
                             ("ARABIC LETTER KHAH" . 1582)
                             ("ARABIC LETTER DAL" . 1583)
                             ("ARABIC LETTER THAL" . 1584)
                             ("ARABIC LETTER REH" . 1585)
                             ("ARABIC LETTER ZAIN" . 1586)
                             ("ARABIC LETTER SEEN" . 1587)
                             ("ARABIC LETTER SHEEN" . 1588)
                             ("ARABIC LETTER SAD" . 1589)
                             ("ARABIC LETTER DAD" . 1590)
                             ("ARABIC LETTER TAH" . 1591)
                             ("ARABIC LETTER ZAH" . 1592)
                             ("ARABIC LETTER AIN" . 1593)
                             ("ARABIC LETTER GHAIN" . 1594)
                             ("ARABIC TATWEEL" . 1600)
                             ("ARABIC LETTER FEH" . 1601)
                             ("ARABIC LETTER QAF" . 1602)
                             ("ARABIC LETTER KAF" . 1603)
                             ("ARABIC LETTER LAM" . 1604)
                             ("ARABIC LETTER MEEM" . 1605)
                             ("ARABIC LETTER NOON" . 1606)
                             ("ARABIC LETTER HEH" . 1607)
                             ("ARABIC LETTER WAW" . 1608)
                             ("ARABIC LETTER ALEF MAKSURA" . 1609)
                             ("ARABIC LETTER YEH" . 1610)
                             ("ARABIC FATHATAN" . 1611)
                             ("ARABIC DAMMATAN" . 1612)
                             ("ARABIC KASRATAN" . 1613)
                             ("ARABIC FATHA" . 1614)
                             ("ARABIC DAMMA" . 1615)
                             ("ARABIC KASRA" . 1616)
                             ("ARABIC SHADDA" . 1617)
                             ("ARABIC SUKUN" . 1618)
                             ("ARABIC MADDAH ABOVE" . 1619)
                             ("ARABIC HAMZA ABOVE" . 1620)
                             ("ARABIC HAMZA BELOW" . 1621)
                             ("ARABIC-INDIC DIGIT ZERO" . 1632)
                             ("ARABIC-INDIC DIGIT ONE" . 1633)
                             ("ARABIC-INDIC DIGIT TWO" . 1634)
                             ("ARABIC-INDIC DIGIT THREE" . 1635)
                             ("ARABIC-INDIC DIGIT FOUR" . 1636)
                             ("ARABIC-INDIC DIGIT FIVE" . 1637)
                             ("ARABIC-INDIC DIGIT SIX" . 1638)
                             ("ARABIC-INDIC DIGIT SEVEN" . 1639)
                             ("ARABIC-INDIC DIGIT EIGHT" . 1640)
                             ("ARABIC-INDIC DIGIT NINE" . 1641)
                             ("ARABIC PERCENT SIGN" . 1642)
                             ("ARABIC DECIMAL SEPARATOR" . 1643)
                             ("ARABIC THOUSANDS SEPARATOR" . 1644)
                             ("ARABIC FIVE POINTED STAR" . 1645)
                             ("ARABIC LETTER DOTLESS BEH" . 1646)
                             ("ARABIC LETTER DOTLESS QAF" . 1647)
                             ("ARABIC LETTER SUPERSCRIPT ALEF" . 1648)
                             ("ARABIC LETTER ALEF WASLA" . 1649)
                             ("ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE" . 1650)
                             ("ARABIC LETTER ALEF WITH WAVY HAMZA BELOW" . 1651)
                             ("ARABIC LETTER HIGH HAMZA" . 1652)
                             ("ARABIC LETTER HIGH HAMZA ALEF" . 1653)
                             ("ARABIC LETTER HIGH HAMZA WAW" . 1654)
                             ("ARABIC LETTER U WITH HAMZA ABOVE" . 1655)
                             ("ARABIC LETTER HIGH HAMZA YEH" . 1656)
                             ("ARABIC LETTER TTEH" . 1657)
                             ("ARABIC LETTER TTEHEH" . 1658)
                             ("ARABIC LETTER BEEH" . 1659)
                             ("ARABIC LETTER TEH WITH RING" . 1660)
                             ("ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS" . 1661)
                             ("ARABIC LETTER PEH" . 1662)
                             ("ARABIC LETTER TEHEH" . 1663)
                             ("ARABIC LETTER BEHEH" . 1664)
                             ("ARABIC LETTER HAH WITH HAMZA ABOVE" . 1665)
                             ("ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE" . 1666)
                             ("ARABIC LETTER NYEH" . 1667)
                             ("ARABIC LETTER DYEH" . 1668)
                             ("ARABIC LETTER HAH WITH THREE DOTS ABOVE" . 1669)
                             ("ARABIC LETTER TCHEH" . 1670)
                             ("ARABIC LETTER TCHEHEH" . 1671)
                             ("ARABIC LETTER DDAL" . 1672)
                             ("ARABIC LETTER DAL WITH RING" . 1673)
                             ("ARABIC LETTER DAL WITH DOT BELOW" . 1674)
                             ("ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH" . 1675)
                             ("ARABIC LETTER DAHAL" . 1676)
                             ("ARABIC LETTER DDAHAL" . 1677)
                             ("ARABIC LETTER DUL" . 1678)
                             ("ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS" . 1679)
                             ("ARABIC LETTER DAL WITH FOUR DOTS ABOVE" . 1680)
                             ("ARABIC LETTER RREH" . 1681)
                             ("ARABIC LETTER REH WITH SMALL V" . 1682)
                             ("ARABIC LETTER REH WITH RING" . 1683)
                             ("ARABIC LETTER REH WITH DOT BELOW" . 1684)
                             ("ARABIC LETTER REH WITH SMALL V BELOW" . 1685)
                             ("ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE" . 1686)
                             ("ARABIC LETTER REH WITH TWO DOTS ABOVE" . 1687)
                             ("ARABIC LETTER JEH" . 1688)
                             ("ARABIC LETTER REH WITH FOUR DOTS ABOVE" . 1689)
                             ("ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE" . 1690)
                             ("ARABIC LETTER SEEN WITH THREE DOTS BELOW" . 1691)
                             ("ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE" . 1692)
                             ("ARABIC LETTER SAD WITH TWO DOTS BELOW" . 1693)
                             ("ARABIC LETTER SAD WITH THREE DOTS ABOVE" . 1694)
                             ("ARABIC LETTER TAH WITH THREE DOTS ABOVE" . 1695)
                             ("ARABIC LETTER AIN WITH THREE DOTS ABOVE" . 1696)
                             ("ARABIC LETTER DOTLESS FEH" . 1697)
                             ("ARABIC LETTER FEH WITH DOT MOVED BELOW" . 1698)
                             ("ARABIC LETTER FEH WITH DOT BELOW" . 1699)
                             ("ARABIC LETTER VEH" . 1700)
                             ("ARABIC LETTER FEH WITH THREE DOTS BELOW" . 1701)
                             ("ARABIC LETTER PEHEH" . 1702)
                             ("ARABIC LETTER QAF WITH DOT ABOVE" . 1703)
                             ("ARABIC LETTER QAF WITH THREE DOTS ABOVE" . 1704)
                             ("ARABIC LETTER KEHEH" . 1705)
                             ("ARABIC LETTER SWASH KAF" . 1706)
                             ("ARABIC LETTER KAF WITH RING" . 1707)
                             ("ARABIC LETTER KAF WITH DOT ABOVE" . 1708)
                             ("ARABIC LETTER NG" . 1709)
                             ("ARABIC LETTER KAF WITH THREE DOTS BELOW" . 1710)
                             ("ARABIC LETTER GAF" . 1711)
                             ("ARABIC LETTER GAF WITH RING" . 1712)
                             ("ARABIC LETTER NGOEH" . 1713)
                             ("ARABIC LETTER GAF WITH TWO DOTS BELOW" . 1714)
                             ("ARABIC LETTER GUEH" . 1715)
                             ("ARABIC LETTER GAF WITH THREE DOTS ABOVE" . 1716)
                             ("ARABIC LETTER LAM WITH SMALL V" . 1717)
                             ("ARABIC LETTER LAM WITH DOT ABOVE" . 1718)
                             ("ARABIC LETTER LAM WITH THREE DOTS ABOVE" . 1719)
                             ("ARABIC LETTER LAM WITH THREE DOTS BELOW" . 1720)
                             ("ARABIC LETTER NOON WITH DOT BELOW" . 1721)
                             ("ARABIC LETTER NOON GHUNNA" . 1722)
                             ("ARABIC LETTER RNOON" . 1723)
                             ("ARABIC LETTER NOON WITH RING" . 1724)
                             ("ARABIC LETTER NOON WITH THREE DOTS ABOVE" . 1725)
                             ("ARABIC LETTER HEH DOACHASHMEE" . 1726)
                             ("ARABIC LETTER TCHEH WITH DOT ABOVE" . 1727)
                             ("ARABIC LETTER HEH WITH YEH ABOVE" . 1728)
                             ("ARABIC LETTER HEH GOAL" . 1729)
                             ("ARABIC LETTER HEH GOAL WITH HAMZA ABOVE" . 1730)
                             ("ARABIC LETTER TEH MARBUTA GOAL" . 1731)
                             ("ARABIC LETTER WAW WITH RING" . 1732)
                             ("ARABIC LETTER KIRGHIZ OE" . 1733)
                             ("ARABIC LETTER OE" . 1734)
                             ("ARABIC LETTER U" . 1735)
                             ("ARABIC LETTER YU" . 1736)
                             ("ARABIC LETTER KIRGHIZ YU" . 1737)
                             ("ARABIC LETTER WAW WITH TWO DOTS ABOVE" . 1738)
                             ("ARABIC LETTER VE" . 1739)
                             ("ARABIC LETTER FARSI YEH" . 1740)
                             ("ARABIC LETTER YEH WITH TAIL" . 1741)
                             ("ARABIC LETTER YEH WITH SMALL V" . 1742)
                             ("ARABIC LETTER WAW WITH DOT ABOVE" . 1743)
                             ("ARABIC LETTER E" . 1744)
                             ("ARABIC LETTER YEH WITH THREE DOTS BELOW" . 1745)
                             ("ARABIC LETTER YEH BARREE" . 1746)
                             ("ARABIC LETTER YEH BARREE WITH HAMZA ABOVE" . 1747)
                             ("ARABIC FULL STOP" . 1748)
                             ("ARABIC LETTER AE" . 1749)
                             ("ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA" . 1750)
                             ("ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA" . 1751)
                             ("ARABIC SMALL HIGH MEEM INITIAL FORM" . 1752)
                             ("ARABIC SMALL HIGH LAM ALEF" . 1753)
                             ("ARABIC SMALL HIGH JEEM" . 1754)
                             ("ARABIC SMALL HIGH THREE DOTS" . 1755)
                             ("ARABIC SMALL HIGH SEEN" . 1756)
                             ("ARABIC END OF AYAH" . 1757)
                             ("ARABIC START OF RUB EL HIZB" . 1758)
                             ("ARABIC SMALL HIGH ROUNDED ZERO" . 1759)
                             ("ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO" . 1760)
                             ("ARABIC SMALL HIGH DOTLESS HEAD OF KHAH" . 1761)
                             ("ARABIC SMALL HIGH MEEM ISOLATED FORM" . 1762)
                             ("ARABIC SMALL LOW SEEN" . 1763)
                             ("ARABIC SMALL HIGH MADDA" . 1764)
                             ("ARABIC SMALL WAW" . 1765)
                             ("ARABIC SMALL YEH" . 1766)
                             ("ARABIC SMALL HIGH YEH" . 1767)
                             ("ARABIC SMALL HIGH NOON" . 1768)
                             ("ARABIC PLACE OF SAJDAH" . 1769)
                             ("ARABIC EMPTY CENTRE LOW STOP" . 1770)
                             ("ARABIC EMPTY CENTRE HIGH STOP" . 1771)
                             ("ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE" . 1772)
                             ("ARABIC SMALL LOW MEEM" . 1773)
                             ("EXTENDED ARABIC-INDIC DIGIT ZERO" . 1776)
                             ("EXTENDED ARABIC-INDIC DIGIT ONE" . 1777)
                             ("EXTENDED ARABIC-INDIC DIGIT TWO" . 1778)
                             ("EXTENDED ARABIC-INDIC DIGIT THREE" . 1779)
                             ("EXTENDED ARABIC-INDIC DIGIT FOUR" . 1780)
                             ("EXTENDED ARABIC-INDIC DIGIT FIVE" . 1781)
                             ("EXTENDED ARABIC-INDIC DIGIT SIX" . 1782)
                             ("EXTENDED ARABIC-INDIC DIGIT SEVEN" . 1783)
                             ("EXTENDED ARABIC-INDIC DIGIT EIGHT" . 1784)
                             ("EXTENDED ARABIC-INDIC DIGIT NINE" . 1785)
                             ("ARABIC LETTER SHEEN WITH DOT BELOW" . 1786)
                             ("ARABIC LETTER DAD WITH DOT BELOW" . 1787)
                             ("ARABIC LETTER GHAIN WITH DOT BELOW" . 1788)
                             ("ARABIC SIGN SINDHI AMPERSAND" . 1789)
                             ("ARABIC SIGN SINDHI POSTPOSITION MEN" . 1790)
                             ("SYRIAC END OF PARAGRAPH" . 1792)
                             ("SYRIAC SUPRALINEAR FULL STOP" . 1793)
                             ("SYRIAC SUBLINEAR FULL STOP" . 1794)
                             ("SYRIAC SUPRALINEAR COLON" . 1795)
                             ("SYRIAC SUBLINEAR COLON" . 1796)
                             ("SYRIAC HORIZONTAL COLON" . 1797)
                             ("SYRIAC COLON SKEWED LEFT" . 1798)
                             ("SYRIAC COLON SKEWED RIGHT" . 1799)
                             ("SYRIAC SUPRALINEAR COLON SKEWED LEFT" . 1800)
                             ("SYRIAC SUBLINEAR COLON SKEWED RIGHT" . 1801)
                             ("SYRIAC CONTRACTION" . 1802)
                             ("SYRIAC HARKLEAN OBELUS" . 1803)
                             ("SYRIAC HARKLEAN METOBELUS" . 1804)
                             ("SYRIAC HARKLEAN ASTERISCUS" . 1805)
                             ("SYRIAC ABBREVIATION MARK" . 1807)
                             ("SYRIAC LETTER ALAPH" . 1808)
                             ("SYRIAC LETTER SUPERSCRIPT ALAPH" . 1809)
                             ("SYRIAC LETTER BETH" . 1810)
                             ("SYRIAC LETTER GAMAL" . 1811)
                             ("SYRIAC LETTER GAMAL GARSHUNI" . 1812)
                             ("SYRIAC LETTER DALATH" . 1813)
                             ("SYRIAC LETTER DOTLESS DALATH RISH" . 1814)
                             ("SYRIAC LETTER HE" . 1815)
                             ("SYRIAC LETTER WAW" . 1816)
                             ("SYRIAC LETTER ZAIN" . 1817)
                             ("SYRIAC LETTER HETH" . 1818)
                             ("SYRIAC LETTER TETH" . 1819)
                             ("SYRIAC LETTER TETH GARSHUNI" . 1820)
                             ("SYRIAC LETTER YUDH" . 1821)
                             ("SYRIAC LETTER YUDH HE" . 1822)
                             ("SYRIAC LETTER KAPH" . 1823)
                             ("SYRIAC LETTER LAMADH" . 1824)
                             ("SYRIAC LETTER MIM" . 1825)
                             ("SYRIAC LETTER NUN" . 1826)
                             ("SYRIAC LETTER SEMKATH" . 1827)
                             ("SYRIAC LETTER FINAL SEMKATH" . 1828)
                             ("SYRIAC LETTER E" . 1829)
                             ("SYRIAC LETTER PE" . 1830)
                             ("SYRIAC LETTER REVERSED PE" . 1831)
                             ("SYRIAC LETTER SADHE" . 1832)
                             ("SYRIAC LETTER QAPH" . 1833)
                             ("SYRIAC LETTER RISH" . 1834)
                             ("SYRIAC LETTER SHIN" . 1835)
                             ("SYRIAC LETTER TAW" . 1836)
                             ("SYRIAC PTHAHA ABOVE" . 1840)
                             ("SYRIAC PTHAHA BELOW" . 1841)
                             ("SYRIAC PTHAHA DOTTED" . 1842)
                             ("SYRIAC ZQAPHA ABOVE" . 1843)
                             ("SYRIAC ZQAPHA BELOW" . 1844)
                             ("SYRIAC ZQAPHA DOTTED" . 1845)
                             ("SYRIAC RBASA ABOVE" . 1846)
                             ("SYRIAC RBASA BELOW" . 1847)
                             ("SYRIAC DOTTED ZLAMA HORIZONTAL" . 1848)
                             ("SYRIAC DOTTED ZLAMA ANGULAR" . 1849)
                             ("SYRIAC HBASA ABOVE" . 1850)
                             ("SYRIAC HBASA BELOW" . 1851)
                             ("SYRIAC HBASA-ESASA DOTTED" . 1852)
                             ("SYRIAC ESASA ABOVE" . 1853)
                             ("SYRIAC ESASA BELOW" . 1854)
                             ("SYRIAC RWAHA" . 1855)
                             ("SYRIAC FEMININE DOT" . 1856)
                             ("SYRIAC QUSHSHAYA" . 1857)
                             ("SYRIAC RUKKAKHA" . 1858)
                             ("SYRIAC TWO VERTICAL DOTS ABOVE" . 1859)
                             ("SYRIAC TWO VERTICAL DOTS BELOW" . 1860)
                             ("SYRIAC THREE DOTS ABOVE" . 1861)
                             ("SYRIAC THREE DOTS BELOW" . 1862)
                             ("SYRIAC OBLIQUE LINE ABOVE" . 1863)
                             ("SYRIAC OBLIQUE LINE BELOW" . 1864)
                             ("SYRIAC MUSIC" . 1865)
                             ("SYRIAC BARREKH" . 1866)
                             ("THAANA LETTER HAA" . 1920)
                             ("THAANA LETTER SHAVIYANI" . 1921)
                             ("THAANA LETTER NOONU" . 1922)
                             ("THAANA LETTER RAA" . 1923)
                             ("THAANA LETTER BAA" . 1924)
                             ("THAANA LETTER LHAVIYANI" . 1925)
                             ("THAANA LETTER KAAFU" . 1926)
                             ("THAANA LETTER ALIFU" . 1927)
                             ("THAANA LETTER VAAVU" . 1928)
                             ("THAANA LETTER MEEMU" . 1929)
                             ("THAANA LETTER FAAFU" . 1930)
                             ("THAANA LETTER DHAALU" . 1931)
                             ("THAANA LETTER THAA" . 1932)
                             ("THAANA LETTER LAAMU" . 1933)
                             ("THAANA LETTER GAAFU" . 1934)
                             ("THAANA LETTER GNAVIYANI" . 1935)
                             ("THAANA LETTER SEENU" . 1936)
                             ("THAANA LETTER DAVIYANI" . 1937)
                             ("THAANA LETTER ZAVIYANI" . 1938)
                             ("THAANA LETTER TAVIYANI" . 1939)
                             ("THAANA LETTER YAA" . 1940)
                             ("THAANA LETTER PAVIYANI" . 1941)
                             ("THAANA LETTER JAVIYANI" . 1942)
                             ("THAANA LETTER CHAVIYANI" . 1943)
                             ("THAANA LETTER TTAA" . 1944)
                             ("THAANA LETTER HHAA" . 1945)
                             ("THAANA LETTER KHAA" . 1946)
                             ("THAANA LETTER THAALU" . 1947)
                             ("THAANA LETTER ZAA" . 1948)
                             ("THAANA LETTER SHEENU" . 1949)
                             ("THAANA LETTER SAADHU" . 1950)
                             ("THAANA LETTER DAADHU" . 1951)
                             ("THAANA LETTER TO" . 1952)
                             ("THAANA LETTER ZO" . 1953)
                             ("THAANA LETTER AINU" . 1954)
                             ("THAANA LETTER GHAINU" . 1955)
                             ("THAANA LETTER QAAFU" . 1956)
                             ("THAANA LETTER WAAVU" . 1957)
                             ("THAANA ABAFILI" . 1958)
                             ("THAANA AABAAFILI" . 1959)
                             ("THAANA IBIFILI" . 1960)
                             ("THAANA EEBEEFILI" . 1961)
                             ("THAANA UBUFILI" . 1962)
                             ("THAANA OOBOOFILI" . 1963)
                             ("THAANA EBEFILI" . 1964)
                             ("THAANA EYBEYFILI" . 1965)
                             ("THAANA OBOFILI" . 1966)
                             ("THAANA OABOAFILI" . 1967)
                             ("THAANA SUKUN" . 1968)
                             ("THAANA LETTER NAA" . 1969)
                             ("DEVANAGARI SIGN CANDRABINDU" . 2305)
                             ("DEVANAGARI SIGN ANUSVARA" . 2306)
                             ("DEVANAGARI SIGN VISARGA" . 2307)
                             ("DEVANAGARI LETTER A" . 2309)
                             ("DEVANAGARI LETTER AA" . 2310)
                             ("DEVANAGARI LETTER I" . 2311)
                             ("DEVANAGARI LETTER II" . 2312)
                             ("DEVANAGARI LETTER U" . 2313)
                             ("DEVANAGARI LETTER UU" . 2314)
                             ("DEVANAGARI LETTER VOCALIC R" . 2315)
                             ("DEVANAGARI LETTER VOCALIC L" . 2316)
                             ("DEVANAGARI LETTER CANDRA E" . 2317)
                             ("DEVANAGARI LETTER SHORT E" . 2318)
                             ("DEVANAGARI LETTER E" . 2319)
                             ("DEVANAGARI LETTER AI" . 2320)
                             ("DEVANAGARI LETTER CANDRA O" . 2321)
                             ("DEVANAGARI LETTER SHORT O" . 2322)
                             ("DEVANAGARI LETTER O" . 2323)
                             ("DEVANAGARI LETTER AU" . 2324)
                             ("DEVANAGARI LETTER KA" . 2325)
                             ("DEVANAGARI LETTER KHA" . 2326)
                             ("DEVANAGARI LETTER GA" . 2327)
                             ("DEVANAGARI LETTER GHA" . 2328)
                             ("DEVANAGARI LETTER NGA" . 2329)
                             ("DEVANAGARI LETTER CA" . 2330)
                             ("DEVANAGARI LETTER CHA" . 2331)
                             ("DEVANAGARI LETTER JA" . 2332)
                             ("DEVANAGARI LETTER JHA" . 2333)
                             ("DEVANAGARI LETTER NYA" . 2334)
                             ("DEVANAGARI LETTER TTA" . 2335)
                             ("DEVANAGARI LETTER TTHA" . 2336)
                             ("DEVANAGARI LETTER DDA" . 2337)
                             ("DEVANAGARI LETTER DDHA" . 2338)
                             ("DEVANAGARI LETTER NNA" . 2339)
                             ("DEVANAGARI LETTER TA" . 2340)
                             ("DEVANAGARI LETTER THA" . 2341)
                             ("DEVANAGARI LETTER DA" . 2342)
                             ("DEVANAGARI LETTER DHA" . 2343)
                             ("DEVANAGARI LETTER NA" . 2344)
                             ("DEVANAGARI LETTER NNNA" . 2345)
                             ("DEVANAGARI LETTER PA" . 2346)
                             ("DEVANAGARI LETTER PHA" . 2347)
                             ("DEVANAGARI LETTER BA" . 2348)
                             ("DEVANAGARI LETTER BHA" . 2349)
                             ("DEVANAGARI LETTER MA" . 2350)
                             ("DEVANAGARI LETTER YA" . 2351)
                             ("DEVANAGARI LETTER RA" . 2352)
                             ("DEVANAGARI LETTER RRA" . 2353)
                             ("DEVANAGARI LETTER LA" . 2354)
                             ("DEVANAGARI LETTER LLA" . 2355)
                             ("DEVANAGARI LETTER LLLA" . 2356)
                             ("DEVANAGARI LETTER VA" . 2357)
                             ("DEVANAGARI LETTER SHA" . 2358)
                             ("DEVANAGARI LETTER SSA" . 2359)
                             ("DEVANAGARI LETTER SA" . 2360)
                             ("DEVANAGARI LETTER HA" . 2361)
                             ("DEVANAGARI SIGN NUKTA" . 2364)
                             ("DEVANAGARI SIGN AVAGRAHA" . 2365)
                             ("DEVANAGARI VOWEL SIGN AA" . 2366)
                             ("DEVANAGARI VOWEL SIGN I" . 2367)
                             ("DEVANAGARI VOWEL SIGN II" . 2368)
                             ("DEVANAGARI VOWEL SIGN U" . 2369)
                             ("DEVANAGARI VOWEL SIGN UU" . 2370)
                             ("DEVANAGARI VOWEL SIGN VOCALIC R" . 2371)
                             ("DEVANAGARI VOWEL SIGN VOCALIC RR" . 2372)
                             ("DEVANAGARI VOWEL SIGN CANDRA E" . 2373)
                             ("DEVANAGARI VOWEL SIGN SHORT E" . 2374)
                             ("DEVANAGARI VOWEL SIGN E" . 2375)
                             ("DEVANAGARI VOWEL SIGN AI" . 2376)
                             ("DEVANAGARI VOWEL SIGN CANDRA O" . 2377)
                             ("DEVANAGARI VOWEL SIGN SHORT O" . 2378)
                             ("DEVANAGARI VOWEL SIGN O" . 2379)
                             ("DEVANAGARI VOWEL SIGN AU" . 2380)
                             ("DEVANAGARI SIGN VIRAMA" . 2381)
                             ("DEVANAGARI OM" . 2384)
                             ("DEVANAGARI STRESS SIGN UDATTA" . 2385)
                             ("DEVANAGARI STRESS SIGN ANUDATTA" . 2386)
                             ("DEVANAGARI GRAVE ACCENT" . 2387)
                             ("DEVANAGARI ACUTE ACCENT" . 2388)
                             ("DEVANAGARI LETTER QA" . 2392)
                             ("DEVANAGARI LETTER KHHA" . 2393)
                             ("DEVANAGARI LETTER GHHA" . 2394)
                             ("DEVANAGARI LETTER ZA" . 2395)
                             ("DEVANAGARI LETTER DDDHA" . 2396)
                             ("DEVANAGARI LETTER RHA" . 2397)
                             ("DEVANAGARI LETTER FA" . 2398)
                             ("DEVANAGARI LETTER YYA" . 2399)
                             ("DEVANAGARI LETTER VOCALIC RR" . 2400)
                             ("DEVANAGARI LETTER VOCALIC LL" . 2401)
                             ("DEVANAGARI VOWEL SIGN VOCALIC L" . 2402)
                             ("DEVANAGARI VOWEL SIGN VOCALIC LL" . 2403)
                             ("DEVANAGARI DANDA" . 2404)
                             ("DEVANAGARI DOUBLE DANDA" . 2405)
                             ("DEVANAGARI DIGIT ZERO" . 2406)
                             ("DEVANAGARI DIGIT ONE" . 2407)
                             ("DEVANAGARI DIGIT TWO" . 2408)
                             ("DEVANAGARI DIGIT THREE" . 2409)
                             ("DEVANAGARI DIGIT FOUR" . 2410)
                             ("DEVANAGARI DIGIT FIVE" . 2411)
                             ("DEVANAGARI DIGIT SIX" . 2412)
                             ("DEVANAGARI DIGIT SEVEN" . 2413)
                             ("DEVANAGARI DIGIT EIGHT" . 2414)
                             ("DEVANAGARI DIGIT NINE" . 2415)
                             ("DEVANAGARI ABBREVIATION SIGN" . 2416)
                             ("BENGALI SIGN CANDRABINDU" . 2433)
                             ("BENGALI SIGN ANUSVARA" . 2434)
                             ("BENGALI SIGN VISARGA" . 2435)
                             ("BENGALI LETTER A" . 2437)
                             ("BENGALI LETTER AA" . 2438)
                             ("BENGALI LETTER I" . 2439)
                             ("BENGALI LETTER II" . 2440)
                             ("BENGALI LETTER U" . 2441)
                             ("BENGALI LETTER UU" . 2442)
                             ("BENGALI LETTER VOCALIC R" . 2443)
                             ("BENGALI LETTER VOCALIC L" . 2444)
                             ("BENGALI LETTER E" . 2447)
                             ("BENGALI LETTER AI" . 2448)
                             ("BENGALI LETTER O" . 2451)
                             ("BENGALI LETTER AU" . 2452)
                             ("BENGALI LETTER KA" . 2453)
                             ("BENGALI LETTER KHA" . 2454)
                             ("BENGALI LETTER GA" . 2455)
                             ("BENGALI LETTER GHA" . 2456)
                             ("BENGALI LETTER NGA" . 2457)
                             ("BENGALI LETTER CA" . 2458)
                             ("BENGALI LETTER CHA" . 2459)
                             ("BENGALI LETTER JA" . 2460)
                             ("BENGALI LETTER JHA" . 2461)
                             ("BENGALI LETTER NYA" . 2462)
                             ("BENGALI LETTER TTA" . 2463)
                             ("BENGALI LETTER TTHA" . 2464)
                             ("BENGALI LETTER DDA" . 2465)
                             ("BENGALI LETTER DDHA" . 2466)
                             ("BENGALI LETTER NNA" . 2467)
                             ("BENGALI LETTER TA" . 2468)
                             ("BENGALI LETTER THA" . 2469)
                             ("BENGALI LETTER DA" . 2470)
                             ("BENGALI LETTER DHA" . 2471)
                             ("BENGALI LETTER NA" . 2472)
                             ("BENGALI LETTER PA" . 2474)
                             ("BENGALI LETTER PHA" . 2475)
                             ("BENGALI LETTER BA" . 2476)
                             ("BENGALI LETTER BHA" . 2477)
                             ("BENGALI LETTER MA" . 2478)
                             ("BENGALI LETTER YA" . 2479)
                             ("BENGALI LETTER RA" . 2480)
                             ("BENGALI LETTER LA" . 2482)
                             ("BENGALI LETTER SHA" . 2486)
                             ("BENGALI LETTER SSA" . 2487)
                             ("BENGALI LETTER SA" . 2488)
                             ("BENGALI LETTER HA" . 2489)
                             ("BENGALI SIGN NUKTA" . 2492)
                             ("BENGALI VOWEL SIGN AA" . 2494)
                             ("BENGALI VOWEL SIGN I" . 2495)
                             ("BENGALI VOWEL SIGN II" . 2496)
                             ("BENGALI VOWEL SIGN U" . 2497)
                             ("BENGALI VOWEL SIGN UU" . 2498)
                             ("BENGALI VOWEL SIGN VOCALIC R" . 2499)
                             ("BENGALI VOWEL SIGN VOCALIC RR" . 2500)
                             ("BENGALI VOWEL SIGN E" . 2503)
                             ("BENGALI VOWEL SIGN AI" . 2504)
                             ("BENGALI VOWEL SIGN O" . 2507)
                             ("BENGALI VOWEL SIGN AU" . 2508)
                             ("BENGALI SIGN VIRAMA" . 2509)
                             ("BENGALI AU LENGTH MARK" . 2519)
                             ("BENGALI LETTER RRA" . 2524)
                             ("BENGALI LETTER RHA" . 2525)
                             ("BENGALI LETTER YYA" . 2527)
                             ("BENGALI LETTER VOCALIC RR" . 2528)
                             ("BENGALI LETTER VOCALIC LL" . 2529)
                             ("BENGALI VOWEL SIGN VOCALIC L" . 2530)
                             ("BENGALI VOWEL SIGN VOCALIC LL" . 2531)
                             ("BENGALI DIGIT ZERO" . 2534)
                             ("BENGALI DIGIT ONE" . 2535)
                             ("BENGALI DIGIT TWO" . 2536)
                             ("BENGALI DIGIT THREE" . 2537)
                             ("BENGALI DIGIT FOUR" . 2538)
                             ("BENGALI DIGIT FIVE" . 2539)
                             ("BENGALI DIGIT SIX" . 2540)
                             ("BENGALI DIGIT SEVEN" . 2541)
                             ("BENGALI DIGIT EIGHT" . 2542)
                             ("BENGALI DIGIT NINE" . 2543)
                             ("BENGALI LETTER RA WITH MIDDLE DIAGONAL" . 2544)
                             ("BENGALI LETTER RA WITH LOWER DIAGONAL" . 2545)
                             ("BENGALI RUPEE MARK" . 2546)
                             ("BENGALI RUPEE SIGN" . 2547)
                             ("BENGALI CURRENCY NUMERATOR ONE" . 2548)
                             ("BENGALI CURRENCY NUMERATOR TWO" . 2549)
                             ("BENGALI CURRENCY NUMERATOR THREE" . 2550)
                             ("BENGALI CURRENCY NUMERATOR FOUR" . 2551)
                             ("BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR" . 2552)
                             ("BENGALI CURRENCY DENOMINATOR SIXTEEN" . 2553)
                             ("BENGALI ISSHAR" . 2554)
                             ("GURMUKHI SIGN BINDI" . 2562)
                             ("GURMUKHI LETTER A" . 2565)
                             ("GURMUKHI LETTER AA" . 2566)
                             ("GURMUKHI LETTER I" . 2567)
                             ("GURMUKHI LETTER II" . 2568)
                             ("GURMUKHI LETTER U" . 2569)
                             ("GURMUKHI LETTER UU" . 2570)
                             ("GURMUKHI LETTER EE" . 2575)
                             ("GURMUKHI LETTER AI" . 2576)
                             ("GURMUKHI LETTER OO" . 2579)
                             ("GURMUKHI LETTER AU" . 2580)
                             ("GURMUKHI LETTER KA" . 2581)
                             ("GURMUKHI LETTER KHA" . 2582)
                             ("GURMUKHI LETTER GA" . 2583)
                             ("GURMUKHI LETTER GHA" . 2584)
                             ("GURMUKHI LETTER NGA" . 2585)
                             ("GURMUKHI LETTER CA" . 2586)
                             ("GURMUKHI LETTER CHA" . 2587)
                             ("GURMUKHI LETTER JA" . 2588)
                             ("GURMUKHI LETTER JHA" . 2589)
                             ("GURMUKHI LETTER NYA" . 2590)
                             ("GURMUKHI LETTER TTA" . 2591)
                             ("GURMUKHI LETTER TTHA" . 2592)
                             ("GURMUKHI LETTER DDA" . 2593)
                             ("GURMUKHI LETTER DDHA" . 2594)
                             ("GURMUKHI LETTER NNA" . 2595)
                             ("GURMUKHI LETTER TA" . 2596)
                             ("GURMUKHI LETTER THA" . 2597)
                             ("GURMUKHI LETTER DA" . 2598)
                             ("GURMUKHI LETTER DHA" . 2599)
                             ("GURMUKHI LETTER NA" . 2600)
                             ("GURMUKHI LETTER PA" . 2602)
                             ("GURMUKHI LETTER PHA" . 2603)
                             ("GURMUKHI LETTER BA" . 2604)
                             ("GURMUKHI LETTER BHA" . 2605)
                             ("GURMUKHI LETTER MA" . 2606)
                             ("GURMUKHI LETTER YA" . 2607)
                             ("GURMUKHI LETTER RA" . 2608)
                             ("GURMUKHI LETTER LA" . 2610)
                             ("GURMUKHI LETTER LLA" . 2611)
                             ("GURMUKHI LETTER VA" . 2613)
                             ("GURMUKHI LETTER SHA" . 2614)
                             ("GURMUKHI LETTER SA" . 2616)
                             ("GURMUKHI LETTER HA" . 2617)
                             ("GURMUKHI SIGN NUKTA" . 2620)
                             ("GURMUKHI VOWEL SIGN AA" . 2622)
                             ("GURMUKHI VOWEL SIGN I" . 2623)
                             ("GURMUKHI VOWEL SIGN II" . 2624)
                             ("GURMUKHI VOWEL SIGN U" . 2625)
                             ("GURMUKHI VOWEL SIGN UU" . 2626)
                             ("GURMUKHI VOWEL SIGN EE" . 2631)
                             ("GURMUKHI VOWEL SIGN AI" . 2632)
                             ("GURMUKHI VOWEL SIGN OO" . 2635)
                             ("GURMUKHI VOWEL SIGN AU" . 2636)
                             ("GURMUKHI SIGN VIRAMA" . 2637)
                             ("GURMUKHI LETTER KHHA" . 2649)
                             ("GURMUKHI LETTER GHHA" . 2650)
                             ("GURMUKHI LETTER ZA" . 2651)
                             ("GURMUKHI LETTER RRA" . 2652)
                             ("GURMUKHI LETTER FA" . 2654)
                             ("GURMUKHI DIGIT ZERO" . 2662)
                             ("GURMUKHI DIGIT ONE" . 2663)
                             ("GURMUKHI DIGIT TWO" . 2664)
                             ("GURMUKHI DIGIT THREE" . 2665)
                             ("GURMUKHI DIGIT FOUR" . 2666)
                             ("GURMUKHI DIGIT FIVE" . 2667)
                             ("GURMUKHI DIGIT SIX" . 2668)
                             ("GURMUKHI DIGIT SEVEN" . 2669)
                             ("GURMUKHI DIGIT EIGHT" . 2670)
                             ("GURMUKHI DIGIT NINE" . 2671)
                             ("GURMUKHI TIPPI" . 2672)
                             ("GURMUKHI ADDAK" . 2673)
                             ("GURMUKHI IRI" . 2674)
                             ("GURMUKHI URA" . 2675)
                             ("GURMUKHI EK ONKAR" . 2676)
                             ("GUJARATI SIGN CANDRABINDU" . 2689)
                             ("GUJARATI SIGN ANUSVARA" . 2690)
                             ("GUJARATI SIGN VISARGA" . 2691)
                             ("GUJARATI LETTER A" . 2693)
                             ("GUJARATI LETTER AA" . 2694)
                             ("GUJARATI LETTER I" . 2695)
                             ("GUJARATI LETTER II" . 2696)
                             ("GUJARATI LETTER U" . 2697)
                             ("GUJARATI LETTER UU" . 2698)
                             ("GUJARATI LETTER VOCALIC R" . 2699)
                             ("GUJARATI VOWEL CANDRA E" . 2701)
                             ("GUJARATI LETTER E" . 2703)
                             ("GUJARATI LETTER AI" . 2704)
                             ("GUJARATI VOWEL CANDRA O" . 2705)
                             ("GUJARATI LETTER O" . 2707)
                             ("GUJARATI LETTER AU" . 2708)
                             ("GUJARATI LETTER KA" . 2709)
                             ("GUJARATI LETTER KHA" . 2710)
                             ("GUJARATI LETTER GA" . 2711)
                             ("GUJARATI LETTER GHA" . 2712)
                             ("GUJARATI LETTER NGA" . 2713)
                             ("GUJARATI LETTER CA" . 2714)
                             ("GUJARATI LETTER CHA" . 2715)
                             ("GUJARATI LETTER JA" . 2716)
                             ("GUJARATI LETTER JHA" . 2717)
                             ("GUJARATI LETTER NYA" . 2718)
                             ("GUJARATI LETTER TTA" . 2719)
                             ("GUJARATI LETTER TTHA" . 2720)
                             ("GUJARATI LETTER DDA" . 2721)
                             ("GUJARATI LETTER DDHA" . 2722)
                             ("GUJARATI LETTER NNA" . 2723)
                             ("GUJARATI LETTER TA" . 2724)
                             ("GUJARATI LETTER THA" . 2725)
                             ("GUJARATI LETTER DA" . 2726)
                             ("GUJARATI LETTER DHA" . 2727)
                             ("GUJARATI LETTER NA" . 2728)
                             ("GUJARATI LETTER PA" . 2730)
                             ("GUJARATI LETTER PHA" . 2731)
                             ("GUJARATI LETTER BA" . 2732)
                             ("GUJARATI LETTER BHA" . 2733)
                             ("GUJARATI LETTER MA" . 2734)
                             ("GUJARATI LETTER YA" . 2735)
                             ("GUJARATI LETTER RA" . 2736)
                             ("GUJARATI LETTER LA" . 2738)
                             ("GUJARATI LETTER LLA" . 2739)
                             ("GUJARATI LETTER VA" . 2741)
                             ("GUJARATI LETTER SHA" . 2742)
                             ("GUJARATI LETTER SSA" . 2743)
                             ("GUJARATI LETTER SA" . 2744)
                             ("GUJARATI LETTER HA" . 2745)
                             ("GUJARATI SIGN NUKTA" . 2748)
                             ("GUJARATI SIGN AVAGRAHA" . 2749)
                             ("GUJARATI VOWEL SIGN AA" . 2750)
                             ("GUJARATI VOWEL SIGN I" . 2751)
                             ("GUJARATI VOWEL SIGN II" . 2752)
                             ("GUJARATI VOWEL SIGN U" . 2753)
                             ("GUJARATI VOWEL SIGN UU" . 2754)
                             ("GUJARATI VOWEL SIGN VOCALIC R" . 2755)
                             ("GUJARATI VOWEL SIGN VOCALIC RR" . 2756)
                             ("GUJARATI VOWEL SIGN CANDRA E" . 2757)
                             ("GUJARATI VOWEL SIGN E" . 2759)
                             ("GUJARATI VOWEL SIGN AI" . 2760)
                             ("GUJARATI VOWEL SIGN CANDRA O" . 2761)
                             ("GUJARATI VOWEL SIGN O" . 2763)
                             ("GUJARATI VOWEL SIGN AU" . 2764)
                             ("GUJARATI SIGN VIRAMA" . 2765)
                             ("GUJARATI OM" . 2768)
                             ("GUJARATI LETTER VOCALIC RR" . 2784)
                             ("GUJARATI DIGIT ZERO" . 2790)
                             ("GUJARATI DIGIT ONE" . 2791)
                             ("GUJARATI DIGIT TWO" . 2792)
                             ("GUJARATI DIGIT THREE" . 2793)
                             ("GUJARATI DIGIT FOUR" . 2794)
                             ("GUJARATI DIGIT FIVE" . 2795)
                             ("GUJARATI DIGIT SIX" . 2796)
                             ("GUJARATI DIGIT SEVEN" . 2797)
                             ("GUJARATI DIGIT EIGHT" . 2798)
                             ("GUJARATI DIGIT NINE" . 2799)
                             ("ORIYA SIGN CANDRABINDU" . 2817)
                             ("ORIYA SIGN ANUSVARA" . 2818)
                             ("ORIYA SIGN VISARGA" . 2819)
                             ("ORIYA LETTER A" . 2821)
                             ("ORIYA LETTER AA" . 2822)
                             ("ORIYA LETTER I" . 2823)
                             ("ORIYA LETTER II" . 2824)
                             ("ORIYA LETTER U" . 2825)
                             ("ORIYA LETTER UU" . 2826)
                             ("ORIYA LETTER VOCALIC R" . 2827)
                             ("ORIYA LETTER VOCALIC L" . 2828)
                             ("ORIYA LETTER E" . 2831)
                             ("ORIYA LETTER AI" . 2832)
                             ("ORIYA LETTER O" . 2835)
                             ("ORIYA LETTER AU" . 2836)
                             ("ORIYA LETTER KA" . 2837)
                             ("ORIYA LETTER KHA" . 2838)
                             ("ORIYA LETTER GA" . 2839)
                             ("ORIYA LETTER GHA" . 2840)
                             ("ORIYA LETTER NGA" . 2841)
                             ("ORIYA LETTER CA" . 2842)
                             ("ORIYA LETTER CHA" . 2843)
                             ("ORIYA LETTER JA" . 2844)
                             ("ORIYA LETTER JHA" . 2845)
                             ("ORIYA LETTER NYA" . 2846)
                             ("ORIYA LETTER TTA" . 2847)
                             ("ORIYA LETTER TTHA" . 2848)
                             ("ORIYA LETTER DDA" . 2849)
                             ("ORIYA LETTER DDHA" . 2850)
                             ("ORIYA LETTER NNA" . 2851)
                             ("ORIYA LETTER TA" . 2852)
                             ("ORIYA LETTER THA" . 2853)
                             ("ORIYA LETTER DA" . 2854)
                             ("ORIYA LETTER DHA" . 2855)
                             ("ORIYA LETTER NA" . 2856)
                             ("ORIYA LETTER PA" . 2858)
                             ("ORIYA LETTER PHA" . 2859)
                             ("ORIYA LETTER BA" . 2860)
                             ("ORIYA LETTER BHA" . 2861)
                             ("ORIYA LETTER MA" . 2862)
                             ("ORIYA LETTER YA" . 2863)
                             ("ORIYA LETTER RA" . 2864)
                             ("ORIYA LETTER LA" . 2866)
                             ("ORIYA LETTER LLA" . 2867)
                             ("ORIYA LETTER SHA" . 2870)
                             ("ORIYA LETTER SSA" . 2871)
                             ("ORIYA LETTER SA" . 2872)
                             ("ORIYA LETTER HA" . 2873)
                             ("ORIYA SIGN NUKTA" . 2876)
                             ("ORIYA SIGN AVAGRAHA" . 2877)
                             ("ORIYA VOWEL SIGN AA" . 2878)
                             ("ORIYA VOWEL SIGN I" . 2879)
                             ("ORIYA VOWEL SIGN II" . 2880)
                             ("ORIYA VOWEL SIGN U" . 2881)
                             ("ORIYA VOWEL SIGN UU" . 2882)
                             ("ORIYA VOWEL SIGN VOCALIC R" . 2883)
                             ("ORIYA VOWEL SIGN E" . 2887)
                             ("ORIYA VOWEL SIGN AI" . 2888)
                             ("ORIYA VOWEL SIGN O" . 2891)
                             ("ORIYA VOWEL SIGN AU" . 2892)
                             ("ORIYA SIGN VIRAMA" . 2893)
                             ("ORIYA AI LENGTH MARK" . 2902)
                             ("ORIYA AU LENGTH MARK" . 2903)
                             ("ORIYA LETTER RRA" . 2908)
                             ("ORIYA LETTER RHA" . 2909)
                             ("ORIYA LETTER YYA" . 2911)
                             ("ORIYA LETTER VOCALIC RR" . 2912)
                             ("ORIYA LETTER VOCALIC LL" . 2913)
                             ("ORIYA DIGIT ZERO" . 2918)
                             ("ORIYA DIGIT ONE" . 2919)
                             ("ORIYA DIGIT TWO" . 2920)
                             ("ORIYA DIGIT THREE" . 2921)
                             ("ORIYA DIGIT FOUR" . 2922)
                             ("ORIYA DIGIT FIVE" . 2923)
                             ("ORIYA DIGIT SIX" . 2924)
                             ("ORIYA DIGIT SEVEN" . 2925)
                             ("ORIYA DIGIT EIGHT" . 2926)
                             ("ORIYA DIGIT NINE" . 2927)
                             ("ORIYA ISSHAR" . 2928)
                             ("TAMIL SIGN ANUSVARA" . 2946)
                             ("TAMIL SIGN VISARGA" . 2947)
                             ("TAMIL LETTER A" . 2949)
                             ("TAMIL LETTER AA" . 2950)
                             ("TAMIL LETTER I" . 2951)
                             ("TAMIL LETTER II" . 2952)
                             ("TAMIL LETTER U" . 2953)
                             ("TAMIL LETTER UU" . 2954)
                             ("TAMIL LETTER E" . 2958)
                             ("TAMIL LETTER EE" . 2959)
                             ("TAMIL LETTER AI" . 2960)
                             ("TAMIL LETTER O" . 2962)
                             ("TAMIL LETTER OO" . 2963)
                             ("TAMIL LETTER AU" . 2964)
                             ("TAMIL LETTER KA" . 2965)
                             ("TAMIL LETTER NGA" . 2969)
                             ("TAMIL LETTER CA" . 2970)
                             ("TAMIL LETTER JA" . 2972)
                             ("TAMIL LETTER NYA" . 2974)
                             ("TAMIL LETTER TTA" . 2975)
                             ("TAMIL LETTER NNA" . 2979)
                             ("TAMIL LETTER TA" . 2980)
                             ("TAMIL LETTER NA" . 2984)
                             ("TAMIL LETTER NNNA" . 2985)
                             ("TAMIL LETTER PA" . 2986)
                             ("TAMIL LETTER MA" . 2990)
                             ("TAMIL LETTER YA" . 2991)
                             ("TAMIL LETTER RA" . 2992)
                             ("TAMIL LETTER RRA" . 2993)
                             ("TAMIL LETTER LA" . 2994)
                             ("TAMIL LETTER LLA" . 2995)
                             ("TAMIL LETTER LLLA" . 2996)
                             ("TAMIL LETTER VA" . 2997)
                             ("TAMIL LETTER SSA" . 2999)
                             ("TAMIL LETTER SA" . 3000)
                             ("TAMIL LETTER HA" . 3001)
                             ("TAMIL VOWEL SIGN AA" . 3006)
                             ("TAMIL VOWEL SIGN I" . 3007)
                             ("TAMIL VOWEL SIGN II" . 3008)
                             ("TAMIL VOWEL SIGN U" . 3009)
                             ("TAMIL VOWEL SIGN UU" . 3010)
                             ("TAMIL VOWEL SIGN E" . 3014)
                             ("TAMIL VOWEL SIGN EE" . 3015)
                             ("TAMIL VOWEL SIGN AI" . 3016)
                             ("TAMIL VOWEL SIGN O" . 3018)
                             ("TAMIL VOWEL SIGN OO" . 3019)
                             ("TAMIL VOWEL SIGN AU" . 3020)
                             ("TAMIL SIGN VIRAMA" . 3021)
                             ("TAMIL AU LENGTH MARK" . 3031)
                             ("TAMIL DIGIT ONE" . 3047)
                             ("TAMIL DIGIT TWO" . 3048)
                             ("TAMIL DIGIT THREE" . 3049)
                             ("TAMIL DIGIT FOUR" . 3050)
                             ("TAMIL DIGIT FIVE" . 3051)
                             ("TAMIL DIGIT SIX" . 3052)
                             ("TAMIL DIGIT SEVEN" . 3053)
                             ("TAMIL DIGIT EIGHT" . 3054)
                             ("TAMIL DIGIT NINE" . 3055)
                             ("TAMIL NUMBER TEN" . 3056)
                             ("TAMIL NUMBER ONE HUNDRED" . 3057)
                             ("TAMIL NUMBER ONE THOUSAND" . 3058)
                             ("TELUGU SIGN CANDRABINDU" . 3073)
                             ("TELUGU SIGN ANUSVARA" . 3074)
                             ("TELUGU SIGN VISARGA" . 3075)
                             ("TELUGU LETTER A" . 3077)
                             ("TELUGU LETTER AA" . 3078)
                             ("TELUGU LETTER I" . 3079)
                             ("TELUGU LETTER II" . 3080)
                             ("TELUGU LETTER U" . 3081)
                             ("TELUGU LETTER UU" . 3082)
                             ("TELUGU LETTER VOCALIC R" . 3083)
                             ("TELUGU LETTER VOCALIC L" . 3084)
                             ("TELUGU LETTER E" . 3086)
                             ("TELUGU LETTER EE" . 3087)
                             ("TELUGU LETTER AI" . 3088)
                             ("TELUGU LETTER O" . 3090)
                             ("TELUGU LETTER OO" . 3091)
                             ("TELUGU LETTER AU" . 3092)
                             ("TELUGU LETTER KA" . 3093)
                             ("TELUGU LETTER KHA" . 3094)
                             ("TELUGU LETTER GA" . 3095)
                             ("TELUGU LETTER GHA" . 3096)
                             ("TELUGU LETTER NGA" . 3097)
                             ("TELUGU LETTER CA" . 3098)
                             ("TELUGU LETTER CHA" . 3099)
                             ("TELUGU LETTER JA" . 3100)
                             ("TELUGU LETTER JHA" . 3101)
                             ("TELUGU LETTER NYA" . 3102)
                             ("TELUGU LETTER TTA" . 3103)
                             ("TELUGU LETTER TTHA" . 3104)
                             ("TELUGU LETTER DDA" . 3105)
                             ("TELUGU LETTER DDHA" . 3106)
                             ("TELUGU LETTER NNA" . 3107)
                             ("TELUGU LETTER TA" . 3108)
                             ("TELUGU LETTER THA" . 3109)
                             ("TELUGU LETTER DA" . 3110)
                             ("TELUGU LETTER DHA" . 3111)
                             ("TELUGU LETTER NA" . 3112)
                             ("TELUGU LETTER PA" . 3114)
                             ("TELUGU LETTER PHA" . 3115)
                             ("TELUGU LETTER BA" . 3116)
                             ("TELUGU LETTER BHA" . 3117)
                             ("TELUGU LETTER MA" . 3118)
                             ("TELUGU LETTER YA" . 3119)
                             ("TELUGU LETTER RA" . 3120)
                             ("TELUGU LETTER RRA" . 3121)
                             ("TELUGU LETTER LA" . 3122)
                             ("TELUGU LETTER LLA" . 3123)
                             ("TELUGU LETTER VA" . 3125)
                             ("TELUGU LETTER SHA" . 3126)
                             ("TELUGU LETTER SSA" . 3127)
                             ("TELUGU LETTER SA" . 3128)
                             ("TELUGU LETTER HA" . 3129)
                             ("TELUGU VOWEL SIGN AA" . 3134)
                             ("TELUGU VOWEL SIGN I" . 3135)
                             ("TELUGU VOWEL SIGN II" . 3136)
                             ("TELUGU VOWEL SIGN U" . 3137)
                             ("TELUGU VOWEL SIGN UU" . 3138)
                             ("TELUGU VOWEL SIGN VOCALIC R" . 3139)
                             ("TELUGU VOWEL SIGN VOCALIC RR" . 3140)
                             ("TELUGU VOWEL SIGN E" . 3142)
                             ("TELUGU VOWEL SIGN EE" . 3143)
                             ("TELUGU VOWEL SIGN AI" . 3144)
                             ("TELUGU VOWEL SIGN O" . 3146)
                             ("TELUGU VOWEL SIGN OO" . 3147)
                             ("TELUGU VOWEL SIGN AU" . 3148)
                             ("TELUGU SIGN VIRAMA" . 3149)
                             ("TELUGU LENGTH MARK" . 3157)
                             ("TELUGU AI LENGTH MARK" . 3158)
                             ("TELUGU LETTER VOCALIC RR" . 3168)
                             ("TELUGU LETTER VOCALIC LL" . 3169)
                             ("TELUGU DIGIT ZERO" . 3174)
                             ("TELUGU DIGIT ONE" . 3175)
                             ("TELUGU DIGIT TWO" . 3176)
                             ("TELUGU DIGIT THREE" . 3177)
                             ("TELUGU DIGIT FOUR" . 3178)
                             ("TELUGU DIGIT FIVE" . 3179)
                             ("TELUGU DIGIT SIX" . 3180)
                             ("TELUGU DIGIT SEVEN" . 3181)
                             ("TELUGU DIGIT EIGHT" . 3182)
                             ("TELUGU DIGIT NINE" . 3183)
                             ("KANNADA SIGN ANUSVARA" . 3202)
                             ("KANNADA SIGN VISARGA" . 3203)
                             ("KANNADA LETTER A" . 3205)
                             ("KANNADA LETTER AA" . 3206)
                             ("KANNADA LETTER I" . 3207)
                             ("KANNADA LETTER II" . 3208)
                             ("KANNADA LETTER U" . 3209)
                             ("KANNADA LETTER UU" . 3210)
                             ("KANNADA LETTER VOCALIC R" . 3211)
                             ("KANNADA LETTER VOCALIC L" . 3212)
                             ("KANNADA LETTER E" . 3214)
                             ("KANNADA LETTER EE" . 3215)
                             ("KANNADA LETTER AI" . 3216)
                             ("KANNADA LETTER O" . 3218)
                             ("KANNADA LETTER OO" . 3219)
                             ("KANNADA LETTER AU" . 3220)
                             ("KANNADA LETTER KA" . 3221)
                             ("KANNADA LETTER KHA" . 3222)
                             ("KANNADA LETTER GA" . 3223)
                             ("KANNADA LETTER GHA" . 3224)
                             ("KANNADA LETTER NGA" . 3225)
                             ("KANNADA LETTER CA" . 3226)
                             ("KANNADA LETTER CHA" . 3227)
                             ("KANNADA LETTER JA" . 3228)
                             ("KANNADA LETTER JHA" . 3229)
                             ("KANNADA LETTER NYA" . 3230)
                             ("KANNADA LETTER TTA" . 3231)
                             ("KANNADA LETTER TTHA" . 3232)
                             ("KANNADA LETTER DDA" . 3233)
                             ("KANNADA LETTER DDHA" . 3234)
                             ("KANNADA LETTER NNA" . 3235)
                             ("KANNADA LETTER TA" . 3236)
                             ("KANNADA LETTER THA" . 3237)
                             ("KANNADA LETTER DA" . 3238)
                             ("KANNADA LETTER DHA" . 3239)
                             ("KANNADA LETTER NA" . 3240)
                             ("KANNADA LETTER PA" . 3242)
                             ("KANNADA LETTER PHA" . 3243)
                             ("KANNADA LETTER BA" . 3244)
                             ("KANNADA LETTER BHA" . 3245)
                             ("KANNADA LETTER MA" . 3246)
                             ("KANNADA LETTER YA" . 3247)
                             ("KANNADA LETTER RA" . 3248)
                             ("KANNADA LETTER RRA" . 3249)
                             ("KANNADA LETTER LA" . 3250)
                             ("KANNADA LETTER LLA" . 3251)
                             ("KANNADA LETTER VA" . 3253)
                             ("KANNADA LETTER SHA" . 3254)
                             ("KANNADA LETTER SSA" . 3255)
                             ("KANNADA LETTER SA" . 3256)
                             ("KANNADA LETTER HA" . 3257)
                             ("KANNADA VOWEL SIGN AA" . 3262)
                             ("KANNADA VOWEL SIGN I" . 3263)
                             ("KANNADA VOWEL SIGN II" . 3264)
                             ("KANNADA VOWEL SIGN U" . 3265)
                             ("KANNADA VOWEL SIGN UU" . 3266)
                             ("KANNADA VOWEL SIGN VOCALIC R" . 3267)
                             ("KANNADA VOWEL SIGN VOCALIC RR" . 3268)
                             ("KANNADA VOWEL SIGN E" . 3270)
                             ("KANNADA VOWEL SIGN EE" . 3271)
                             ("KANNADA VOWEL SIGN AI" . 3272)
                             ("KANNADA VOWEL SIGN O" . 3274)
                             ("KANNADA VOWEL SIGN OO" . 3275)
                             ("KANNADA VOWEL SIGN AU" . 3276)
                             ("KANNADA SIGN VIRAMA" . 3277)
                             ("KANNADA LENGTH MARK" . 3285)
                             ("KANNADA AI LENGTH MARK" . 3286)
                             ("KANNADA LETTER FA" . 3294)
                             ("KANNADA LETTER VOCALIC RR" . 3296)
                             ("KANNADA LETTER VOCALIC LL" . 3297)
                             ("KANNADA DIGIT ZERO" . 3302)
                             ("KANNADA DIGIT ONE" . 3303)
                             ("KANNADA DIGIT TWO" . 3304)
                             ("KANNADA DIGIT THREE" . 3305)
                             ("KANNADA DIGIT FOUR" . 3306)
                             ("KANNADA DIGIT FIVE" . 3307)
                             ("KANNADA DIGIT SIX" . 3308)
                             ("KANNADA DIGIT SEVEN" . 3309)
                             ("KANNADA DIGIT EIGHT" . 3310)
                             ("KANNADA DIGIT NINE" . 3311)
                             ("MALAYALAM SIGN ANUSVARA" . 3330)
                             ("MALAYALAM SIGN VISARGA" . 3331)
                             ("MALAYALAM LETTER A" . 3333)
                             ("MALAYALAM LETTER AA" . 3334)
                             ("MALAYALAM LETTER I" . 3335)
                             ("MALAYALAM LETTER II" . 3336)
                             ("MALAYALAM LETTER U" . 3337)
                             ("MALAYALAM LETTER UU" . 3338)
                             ("MALAYALAM LETTER VOCALIC R" . 3339)
                             ("MALAYALAM LETTER VOCALIC L" . 3340)
                             ("MALAYALAM LETTER E" . 3342)
                             ("MALAYALAM LETTER EE" . 3343)
                             ("MALAYALAM LETTER AI" . 3344)
                             ("MALAYALAM LETTER O" . 3346)
                             ("MALAYALAM LETTER OO" . 3347)
                             ("MALAYALAM LETTER AU" . 3348)
                             ("MALAYALAM LETTER KA" . 3349)
                             ("MALAYALAM LETTER KHA" . 3350)
                             ("MALAYALAM LETTER GA" . 3351)
                             ("MALAYALAM LETTER GHA" . 3352)
                             ("MALAYALAM LETTER NGA" . 3353)
                             ("MALAYALAM LETTER CA" . 3354)
                             ("MALAYALAM LETTER CHA" . 3355)
                             ("MALAYALAM LETTER JA" . 3356)
                             ("MALAYALAM LETTER JHA" . 3357)
                             ("MALAYALAM LETTER NYA" . 3358)
                             ("MALAYALAM LETTER TTA" . 3359)
                             ("MALAYALAM LETTER TTHA" . 3360)
                             ("MALAYALAM LETTER DDA" . 3361)
                             ("MALAYALAM LETTER DDHA" . 3362)
                             ("MALAYALAM LETTER NNA" . 3363)
                             ("MALAYALAM LETTER TA" . 3364)
                             ("MALAYALAM LETTER THA" . 3365)
                             ("MALAYALAM LETTER DA" . 3366)
                             ("MALAYALAM LETTER DHA" . 3367)
                             ("MALAYALAM LETTER NA" . 3368)
                             ("MALAYALAM LETTER PA" . 3370)
                             ("MALAYALAM LETTER PHA" . 3371)
                             ("MALAYALAM LETTER BA" . 3372)
                             ("MALAYALAM LETTER BHA" . 3373)
                             ("MALAYALAM LETTER MA" . 3374)
                             ("MALAYALAM LETTER YA" . 3375)
                             ("MALAYALAM LETTER RA" . 3376)
                             ("MALAYALAM LETTER RRA" . 3377)
                             ("MALAYALAM LETTER LA" . 3378)
                             ("MALAYALAM LETTER LLA" . 3379)
                             ("MALAYALAM LETTER LLLA" . 3380)
                             ("MALAYALAM LETTER VA" . 3381)
                             ("MALAYALAM LETTER SHA" . 3382)
                             ("MALAYALAM LETTER SSA" . 3383)
                             ("MALAYALAM LETTER SA" . 3384)
                             ("MALAYALAM LETTER HA" . 3385)
                             ("MALAYALAM VOWEL SIGN AA" . 3390)
                             ("MALAYALAM VOWEL SIGN I" . 3391)
                             ("MALAYALAM VOWEL SIGN II" . 3392)
                             ("MALAYALAM VOWEL SIGN U" . 3393)
                             ("MALAYALAM VOWEL SIGN UU" . 3394)
                             ("MALAYALAM VOWEL SIGN VOCALIC R" . 3395)
                             ("MALAYALAM VOWEL SIGN E" . 3398)
                             ("MALAYALAM VOWEL SIGN EE" . 3399)
                             ("MALAYALAM VOWEL SIGN AI" . 3400)
                             ("MALAYALAM VOWEL SIGN O" . 3402)
                             ("MALAYALAM VOWEL SIGN OO" . 3403)
                             ("MALAYALAM VOWEL SIGN AU" . 3404)
                             ("MALAYALAM SIGN VIRAMA" . 3405)
                             ("MALAYALAM AU LENGTH MARK" . 3415)
                             ("MALAYALAM LETTER VOCALIC RR" . 3424)
                             ("MALAYALAM LETTER VOCALIC LL" . 3425)
                             ("MALAYALAM DIGIT ZERO" . 3430)
                             ("MALAYALAM DIGIT ONE" . 3431)
                             ("MALAYALAM DIGIT TWO" . 3432)
                             ("MALAYALAM DIGIT THREE" . 3433)
                             ("MALAYALAM DIGIT FOUR" . 3434)
                             ("MALAYALAM DIGIT FIVE" . 3435)
                             ("MALAYALAM DIGIT SIX" . 3436)
                             ("MALAYALAM DIGIT SEVEN" . 3437)
                             ("MALAYALAM DIGIT EIGHT" . 3438)
                             ("MALAYALAM DIGIT NINE" . 3439)
                             ("SINHALA SIGN ANUSVARAYA" . 3458)
                             ("SINHALA SIGN VISARGAYA" . 3459)
                             ("SINHALA LETTER AYANNA" . 3461)
                             ("SINHALA LETTER AAYANNA" . 3462)
                             ("SINHALA LETTER AEYANNA" . 3463)
                             ("SINHALA LETTER AEEYANNA" . 3464)
                             ("SINHALA LETTER IYANNA" . 3465)
                             ("SINHALA LETTER IIYANNA" . 3466)
                             ("SINHALA LETTER UYANNA" . 3467)
                             ("SINHALA LETTER UUYANNA" . 3468)
                             ("SINHALA LETTER IRUYANNA" . 3469)
                             ("SINHALA LETTER IRUUYANNA" . 3470)
                             ("SINHALA LETTER ILUYANNA" . 3471)
                             ("SINHALA LETTER ILUUYANNA" . 3472)
                             ("SINHALA LETTER EYANNA" . 3473)
                             ("SINHALA LETTER EEYANNA" . 3474)
                             ("SINHALA LETTER AIYANNA" . 3475)
                             ("SINHALA LETTER OYANNA" . 3476)
                             ("SINHALA LETTER OOYANNA" . 3477)
                             ("SINHALA LETTER AUYANNA" . 3478)
                             ("SINHALA LETTER ALPAPRAANA KAYANNA" . 3482)
                             ("SINHALA LETTER MAHAAPRAANA KAYANNA" . 3483)
                             ("SINHALA LETTER ALPAPRAANA GAYANNA" . 3484)
                             ("SINHALA LETTER MAHAAPRAANA GAYANNA" . 3485)
                             ("SINHALA LETTER KANTAJA NAASIKYAYA" . 3486)
                             ("SINHALA LETTER SANYAKA GAYANNA" . 3487)
                             ("SINHALA LETTER ALPAPRAANA CAYANNA" . 3488)
                             ("SINHALA LETTER MAHAAPRAANA CAYANNA" . 3489)
                             ("SINHALA LETTER ALPAPRAANA JAYANNA" . 3490)
                             ("SINHALA LETTER MAHAAPRAANA JAYANNA" . 3491)
                             ("SINHALA LETTER TAALUJA NAASIKYAYA" . 3492)
                             ("SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA" . 3493)
                             ("SINHALA LETTER SANYAKA JAYANNA" . 3494)
                             ("SINHALA LETTER ALPAPRAANA TTAYANNA" . 3495)
                             ("SINHALA LETTER MAHAAPRAANA TTAYANNA" . 3496)
                             ("SINHALA LETTER ALPAPRAANA DDAYANNA" . 3497)
                             ("SINHALA LETTER MAHAAPRAANA DDAYANNA" . 3498)
                             ("SINHALA LETTER MUURDHAJA NAYANNA" . 3499)
                             ("SINHALA LETTER SANYAKA DDAYANNA" . 3500)
                             ("SINHALA LETTER ALPAPRAANA TAYANNA" . 3501)
                             ("SINHALA LETTER MAHAAPRAANA TAYANNA" . 3502)
                             ("SINHALA LETTER ALPAPRAANA DAYANNA" . 3503)
                             ("SINHALA LETTER MAHAAPRAANA DAYANNA" . 3504)
                             ("SINHALA LETTER DANTAJA NAYANNA" . 3505)
                             ("SINHALA LETTER SANYAKA DAYANNA" . 3507)
                             ("SINHALA LETTER ALPAPRAANA PAYANNA" . 3508)
                             ("SINHALA LETTER MAHAAPRAANA PAYANNA" . 3509)
                             ("SINHALA LETTER ALPAPRAANA BAYANNA" . 3510)
                             ("SINHALA LETTER MAHAAPRAANA BAYANNA" . 3511)
                             ("SINHALA LETTER MAYANNA" . 3512)
                             ("SINHALA LETTER AMBA BAYANNA" . 3513)
                             ("SINHALA LETTER YAYANNA" . 3514)
                             ("SINHALA LETTER RAYANNA" . 3515)
                             ("SINHALA LETTER DANTAJA LAYANNA" . 3517)
                             ("SINHALA LETTER VAYANNA" . 3520)
                             ("SINHALA LETTER TAALUJA SAYANNA" . 3521)
                             ("SINHALA LETTER MUURDHAJA SAYANNA" . 3522)
                             ("SINHALA LETTER DANTAJA SAYANNA" . 3523)
                             ("SINHALA LETTER HAYANNA" . 3524)
                             ("SINHALA LETTER MUURDHAJA LAYANNA" . 3525)
                             ("SINHALA LETTER FAYANNA" . 3526)
                             ("SINHALA SIGN AL-LAKUNA" . 3530)
                             ("SINHALA VOWEL SIGN AELA-PILLA" . 3535)
                             ("SINHALA VOWEL SIGN KETTI AEDA-PILLA" . 3536)
                             ("SINHALA VOWEL SIGN DIGA AEDA-PILLA" . 3537)
                             ("SINHALA VOWEL SIGN KETTI IS-PILLA" . 3538)
                             ("SINHALA VOWEL SIGN DIGA IS-PILLA" . 3539)
                             ("SINHALA VOWEL SIGN KETTI PAA-PILLA" . 3540)
                             ("SINHALA VOWEL SIGN DIGA PAA-PILLA" . 3542)
                             ("SINHALA VOWEL SIGN GAETTA-PILLA" . 3544)
                             ("SINHALA VOWEL SIGN KOMBUVA" . 3545)
                             ("SINHALA VOWEL SIGN DIGA KOMBUVA" . 3546)
                             ("SINHALA VOWEL SIGN KOMBU DEKA" . 3547)
                             ("SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA" . 3548)
                             ("SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA" . 3549)
                             ("SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA" . 3550)
                             ("SINHALA VOWEL SIGN GAYANUKITTA" . 3551)
                             ("SINHALA VOWEL SIGN DIGA GAETTA-PILLA" . 3570)
                             ("SINHALA VOWEL SIGN DIGA GAYANUKITTA" . 3571)
                             ("SINHALA PUNCTUATION KUNDDALIYA" . 3572)
                             ("THAI CHARACTER KO KAI" . 3585)
                             ("THAI CHARACTER KHO KHAI" . 3586)
                             ("THAI CHARACTER KHO KHUAT" . 3587)
                             ("THAI CHARACTER KHO KHWAI" . 3588)
                             ("THAI CHARACTER KHO KHON" . 3589)
                             ("THAI CHARACTER KHO RAKHANG" . 3590)
                             ("THAI CHARACTER NGO NGU" . 3591)
                             ("THAI CHARACTER CHO CHAN" . 3592)
                             ("THAI CHARACTER CHO CHING" . 3593)
                             ("THAI CHARACTER CHO CHANG" . 3594)
                             ("THAI CHARACTER SO SO" . 3595)
                             ("THAI CHARACTER CHO CHOE" . 3596)
                             ("THAI CHARACTER YO YING" . 3597)
                             ("THAI CHARACTER DO CHADA" . 3598)
                             ("THAI CHARACTER TO PATAK" . 3599)
                             ("THAI CHARACTER THO THAN" . 3600)
                             ("THAI CHARACTER THO NANGMONTHO" . 3601)
                             ("THAI CHARACTER THO PHUTHAO" . 3602)
                             ("THAI CHARACTER NO NEN" . 3603)
                             ("THAI CHARACTER DO DEK" . 3604)
                             ("THAI CHARACTER TO TAO" . 3605)
                             ("THAI CHARACTER THO THUNG" . 3606)
                             ("THAI CHARACTER THO THAHAN" . 3607)
                             ("THAI CHARACTER THO THONG" . 3608)
                             ("THAI CHARACTER NO NU" . 3609)
                             ("THAI CHARACTER BO BAIMAI" . 3610)
                             ("THAI CHARACTER PO PLA" . 3611)
                             ("THAI CHARACTER PHO PHUNG" . 3612)
                             ("THAI CHARACTER FO FA" . 3613)
                             ("THAI CHARACTER PHO PHAN" . 3614)
                             ("THAI CHARACTER FO FAN" . 3615)
                             ("THAI CHARACTER PHO SAMPHAO" . 3616)
                             ("THAI CHARACTER MO MA" . 3617)
                             ("THAI CHARACTER YO YAK" . 3618)
                             ("THAI CHARACTER RO RUA" . 3619)
                             ("THAI CHARACTER RU" . 3620)
                             ("THAI CHARACTER LO LING" . 3621)
                             ("THAI CHARACTER LU" . 3622)
                             ("THAI CHARACTER WO WAEN" . 3623)
                             ("THAI CHARACTER SO SALA" . 3624)
                             ("THAI CHARACTER SO RUSI" . 3625)
                             ("THAI CHARACTER SO SUA" . 3626)
                             ("THAI CHARACTER HO HIP" . 3627)
                             ("THAI CHARACTER LO CHULA" . 3628)
                             ("THAI CHARACTER O ANG" . 3629)
                             ("THAI CHARACTER HO NOKHUK" . 3630)
                             ("THAI CHARACTER PAIYANNOI" . 3631)
                             ("THAI CHARACTER SARA A" . 3632)
                             ("THAI CHARACTER MAI HAN-AKAT" . 3633)
                             ("THAI CHARACTER SARA AA" . 3634)
                             ("THAI CHARACTER SARA AM" . 3635)
                             ("THAI CHARACTER SARA I" . 3636)
                             ("THAI CHARACTER SARA II" . 3637)
                             ("THAI CHARACTER SARA UE" . 3638)
                             ("THAI CHARACTER SARA UEE" . 3639)
                             ("THAI CHARACTER SARA U" . 3640)
                             ("THAI CHARACTER SARA UU" . 3641)
                             ("THAI CHARACTER PHINTHU" . 3642)
                             ("THAI CURRENCY SYMBOL BAHT" . 3647)
                             ("THAI CHARACTER SARA E" . 3648)
                             ("THAI CHARACTER SARA AE" . 3649)
                             ("THAI CHARACTER SARA O" . 3650)
                             ("THAI CHARACTER SARA AI MAIMUAN" . 3651)
                             ("THAI CHARACTER SARA AI MAIMALAI" . 3652)
                             ("THAI CHARACTER LAKKHANGYAO" . 3653)
                             ("THAI CHARACTER MAIYAMOK" . 3654)
                             ("THAI CHARACTER MAITAIKHU" . 3655)
                             ("THAI CHARACTER MAI EK" . 3656)
                             ("THAI CHARACTER MAI THO" . 3657)
                             ("THAI CHARACTER MAI TRI" . 3658)
                             ("THAI CHARACTER MAI CHATTAWA" . 3659)
                             ("THAI CHARACTER THANTHAKHAT" . 3660)
                             ("THAI CHARACTER NIKHAHIT" . 3661)
                             ("THAI CHARACTER YAMAKKAN" . 3662)
                             ("THAI CHARACTER FONGMAN" . 3663)
                             ("THAI DIGIT ZERO" . 3664)
                             ("THAI DIGIT ONE" . 3665)
                             ("THAI DIGIT TWO" . 3666)
                             ("THAI DIGIT THREE" . 3667)
                             ("THAI DIGIT FOUR" . 3668)
                             ("THAI DIGIT FIVE" . 3669)
                             ("THAI DIGIT SIX" . 3670)
                             ("THAI DIGIT SEVEN" . 3671)
                             ("THAI DIGIT EIGHT" . 3672)
                             ("THAI DIGIT NINE" . 3673)
                             ("THAI CHARACTER ANGKHANKHU" . 3674)
                             ("THAI CHARACTER KHOMUT" . 3675)
                             ("LAO LETTER KO" . 3713)
                             ("LAO LETTER KHO SUNG" . 3714)
                             ("LAO LETTER KHO TAM" . 3716)
                             ("LAO LETTER NGO" . 3719)
                             ("LAO LETTER CO" . 3720)
                             ("LAO LETTER SO TAM" . 3722)
                             ("LAO LETTER NYO" . 3725)
                             ("LAO LETTER DO" . 3732)
                             ("LAO LETTER TO" . 3733)
                             ("LAO LETTER THO SUNG" . 3734)
                             ("LAO LETTER THO TAM" . 3735)
                             ("LAO LETTER NO" . 3737)
                             ("LAO LETTER BO" . 3738)
                             ("LAO LETTER PO" . 3739)
                             ("LAO LETTER PHO SUNG" . 3740)
                             ("LAO LETTER FO TAM" . 3741)
                             ("LAO LETTER PHO TAM" . 3742)
                             ("LAO LETTER FO SUNG" . 3743)
                             ("LAO LETTER MO" . 3745)
                             ("LAO LETTER YO" . 3746)
                             ("LAO LETTER LO LING" . 3747)
                             ("LAO LETTER LO LOOT" . 3749)
                             ("LAO LETTER WO" . 3751)
                             ("LAO LETTER SO SUNG" . 3754)
                             ("LAO LETTER HO SUNG" . 3755)
                             ("LAO LETTER O" . 3757)
                             ("LAO LETTER HO TAM" . 3758)
                             ("LAO ELLIPSIS" . 3759)
                             ("LAO VOWEL SIGN A" . 3760)
                             ("LAO VOWEL SIGN MAI KAN" . 3761)
                             ("LAO VOWEL SIGN AA" . 3762)
                             ("LAO VOWEL SIGN AM" . 3763)
                             ("LAO VOWEL SIGN I" . 3764)
                             ("LAO VOWEL SIGN II" . 3765)
                             ("LAO VOWEL SIGN Y" . 3766)
                             ("LAO VOWEL SIGN YY" . 3767)
                             ("LAO VOWEL SIGN U" . 3768)
                             ("LAO VOWEL SIGN UU" . 3769)
                             ("LAO VOWEL SIGN MAI KON" . 3771)
                             ("LAO SEMIVOWEL SIGN LO" . 3772)
                             ("LAO SEMIVOWEL SIGN NYO" . 3773)
                             ("LAO VOWEL SIGN E" . 3776)
                             ("LAO VOWEL SIGN EI" . 3777)
                             ("LAO VOWEL SIGN O" . 3778)
                             ("LAO VOWEL SIGN AY" . 3779)
                             ("LAO VOWEL SIGN AI" . 3780)
                             ("LAO KO LA" . 3782)
                             ("LAO TONE MAI EK" . 3784)
                             ("LAO TONE MAI THO" . 3785)
                             ("LAO TONE MAI TI" . 3786)
                             ("LAO TONE MAI CATAWA" . 3787)
                             ("LAO CANCELLATION MARK" . 3788)
                             ("LAO NIGGAHITA" . 3789)
                             ("LAO DIGIT ZERO" . 3792)
                             ("LAO DIGIT ONE" . 3793)
                             ("LAO DIGIT TWO" . 3794)
                             ("LAO DIGIT THREE" . 3795)
                             ("LAO DIGIT FOUR" . 3796)
                             ("LAO DIGIT FIVE" . 3797)
                             ("LAO DIGIT SIX" . 3798)
                             ("LAO DIGIT SEVEN" . 3799)
                             ("LAO DIGIT EIGHT" . 3800)
                             ("LAO DIGIT NINE" . 3801)
                             ("LAO HO NO" . 3804)
                             ("LAO HO MO" . 3805)
                             ("TIBETAN SYLLABLE OM" . 3840)
                             ("TIBETAN MARK GTER YIG MGO TRUNCATED A" . 3841)
                             ("TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA" . 3842)
                             ("TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA" . 3843)
                             ("TIBETAN MARK INITIAL YIG MGO MDUN MA" . 3844)
                             ("TIBETAN MARK CLOSING YIG MGO SGAB MA" . 3845)
                             ("TIBETAN MARK CARET YIG MGO PHUR SHAD MA" . 3846)
                             ("TIBETAN MARK YIG MGO TSHEG SHAD MA" . 3847)
                             ("TIBETAN MARK SBRUL SHAD" . 3848)
                             ("TIBETAN MARK BSKUR YIG MGO" . 3849)
                             ("TIBETAN MARK BKA- SHOG YIG MGO" . 3850)
                             ("TIBETAN MARK INTERSYLLABIC TSHEG" . 3851)
                             ("TIBETAN MARK DELIMITER TSHEG BSTAR" . 3852)
                             ("TIBETAN MARK SHAD" . 3853)
                             ("TIBETAN MARK NYIS SHAD" . 3854)
                             ("TIBETAN MARK TSHEG SHAD" . 3855)
                             ("TIBETAN MARK NYIS TSHEG SHAD" . 3856)
                             ("TIBETAN MARK RIN CHEN SPUNGS SHAD" . 3857)
                             ("TIBETAN MARK RGYA GRAM SHAD" . 3858)
                             ("TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN" . 3859)
                             ("TIBETAN MARK GTER TSHEG" . 3860)
                             ("TIBETAN LOGOTYPE SIGN CHAD RTAGS" . 3861)
                             ("TIBETAN LOGOTYPE SIGN LHAG RTAGS" . 3862)
                             ("TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS" . 3863)
                             ("TIBETAN ASTROLOGICAL SIGN -KHYUD PA" . 3864)
                             ("TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS" . 3865)
                             ("TIBETAN SIGN RDEL DKAR GCIG" . 3866)
                             ("TIBETAN SIGN RDEL DKAR GNYIS" . 3867)
                             ("TIBETAN SIGN RDEL DKAR GSUM" . 3868)
                             ("TIBETAN SIGN RDEL NAG GCIG" . 3869)
                             ("TIBETAN SIGN RDEL NAG GNYIS" . 3870)
                             ("TIBETAN SIGN RDEL DKAR RDEL NAG" . 3871)
                             ("TIBETAN DIGIT ZERO" . 3872)
                             ("TIBETAN DIGIT ONE" . 3873)
                             ("TIBETAN DIGIT TWO" . 3874)
                             ("TIBETAN DIGIT THREE" . 3875)
                             ("TIBETAN DIGIT FOUR" . 3876)
                             ("TIBETAN DIGIT FIVE" . 3877)
                             ("TIBETAN DIGIT SIX" . 3878)
                             ("TIBETAN DIGIT SEVEN" . 3879)
                             ("TIBETAN DIGIT EIGHT" . 3880)
                             ("TIBETAN DIGIT NINE" . 3881)
                             ("TIBETAN DIGIT HALF ONE" . 3882)
                             ("TIBETAN DIGIT HALF TWO" . 3883)
                             ("TIBETAN DIGIT HALF THREE" . 3884)
                             ("TIBETAN DIGIT HALF FOUR" . 3885)
                             ("TIBETAN DIGIT HALF FIVE" . 3886)
                             ("TIBETAN DIGIT HALF SIX" . 3887)
                             ("TIBETAN DIGIT HALF SEVEN" . 3888)
                             ("TIBETAN DIGIT HALF EIGHT" . 3889)
                             ("TIBETAN DIGIT HALF NINE" . 3890)
                             ("TIBETAN DIGIT HALF ZERO" . 3891)
                             ("TIBETAN MARK BSDUS RTAGS" . 3892)
                             ("TIBETAN MARK NGAS BZUNG NYI ZLA" . 3893)
                             ("TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN" . 3894)
                             ("TIBETAN MARK NGAS BZUNG SGOR RTAGS" . 3895)
                             ("TIBETAN MARK CHE MGO" . 3896)
                             ("TIBETAN MARK TSA -PHRU" . 3897)
                             ("TIBETAN MARK GUG RTAGS GYON" . 3898)
                             ("TIBETAN MARK GUG RTAGS GYAS" . 3899)
                             ("TIBETAN MARK ANG KHANG GYON" . 3900)
                             ("TIBETAN MARK ANG KHANG GYAS" . 3901)
                             ("TIBETAN SIGN YAR TSHES" . 3902)
                             ("TIBETAN SIGN MAR TSHES" . 3903)
                             ("TIBETAN LETTER KA" . 3904)
                             ("TIBETAN LETTER KHA" . 3905)
                             ("TIBETAN LETTER GA" . 3906)
                             ("TIBETAN LETTER GHA" . 3907)
                             ("TIBETAN LETTER NGA" . 3908)
                             ("TIBETAN LETTER CA" . 3909)
                             ("TIBETAN LETTER CHA" . 3910)
                             ("TIBETAN LETTER JA" . 3911)
                             ("TIBETAN LETTER NYA" . 3913)
                             ("TIBETAN LETTER TTA" . 3914)
                             ("TIBETAN LETTER TTHA" . 3915)
                             ("TIBETAN LETTER DDA" . 3916)
                             ("TIBETAN LETTER DDHA" . 3917)
                             ("TIBETAN LETTER NNA" . 3918)
                             ("TIBETAN LETTER TA" . 3919)
                             ("TIBETAN LETTER THA" . 3920)
                             ("TIBETAN LETTER DA" . 3921)
                             ("TIBETAN LETTER DHA" . 3922)
                             ("TIBETAN LETTER NA" . 3923)
                             ("TIBETAN LETTER PA" . 3924)
                             ("TIBETAN LETTER PHA" . 3925)
                             ("TIBETAN LETTER BA" . 3926)
                             ("TIBETAN LETTER BHA" . 3927)
                             ("TIBETAN LETTER MA" . 3928)
                             ("TIBETAN LETTER TSA" . 3929)
                             ("TIBETAN LETTER TSHA" . 3930)
                             ("TIBETAN LETTER DZA" . 3931)
                             ("TIBETAN LETTER DZHA" . 3932)
                             ("TIBETAN LETTER WA" . 3933)
                             ("TIBETAN LETTER ZHA" . 3934)
                             ("TIBETAN LETTER ZA" . 3935)
                             ("TIBETAN LETTER -A" . 3936)
                             ("TIBETAN LETTER YA" . 3937)
                             ("TIBETAN LETTER RA" . 3938)
                             ("TIBETAN LETTER LA" . 3939)
                             ("TIBETAN LETTER SHA" . 3940)
                             ("TIBETAN LETTER SSA" . 3941)
                             ("TIBETAN LETTER SA" . 3942)
                             ("TIBETAN LETTER HA" . 3943)
                             ("TIBETAN LETTER A" . 3944)
                             ("TIBETAN LETTER KSSA" . 3945)
                             ("TIBETAN LETTER FIXED-FORM RA" . 3946)
                             ("TIBETAN VOWEL SIGN AA" . 3953)
                             ("TIBETAN VOWEL SIGN I" . 3954)
                             ("TIBETAN VOWEL SIGN II" . 3955)
                             ("TIBETAN VOWEL SIGN U" . 3956)
                             ("TIBETAN VOWEL SIGN UU" . 3957)
                             ("TIBETAN VOWEL SIGN VOCALIC R" . 3958)
                             ("TIBETAN VOWEL SIGN VOCALIC RR" . 3959)
                             ("TIBETAN VOWEL SIGN VOCALIC L" . 3960)
                             ("TIBETAN VOWEL SIGN VOCALIC LL" . 3961)
                             ("TIBETAN VOWEL SIGN E" . 3962)
                             ("TIBETAN VOWEL SIGN EE" . 3963)
                             ("TIBETAN VOWEL SIGN O" . 3964)
                             ("TIBETAN VOWEL SIGN OO" . 3965)
                             ("TIBETAN SIGN RJES SU NGA RO" . 3966)
                             ("TIBETAN SIGN RNAM BCAD" . 3967)
                             ("TIBETAN VOWEL SIGN REVERSED I" . 3968)
                             ("TIBETAN VOWEL SIGN REVERSED II" . 3969)
                             ("TIBETAN SIGN NYI ZLA NAA DA" . 3970)
                             ("TIBETAN SIGN SNA LDAN" . 3971)
                             ("TIBETAN MARK HALANTA" . 3972)
                             ("TIBETAN MARK PALUTA" . 3973)
                             ("TIBETAN SIGN LCI RTAGS" . 3974)
                             ("TIBETAN SIGN YANG RTAGS" . 3975)
                             ("TIBETAN SIGN LCE TSA CAN" . 3976)
                             ("TIBETAN SIGN MCHU CAN" . 3977)
                             ("TIBETAN SIGN GRU CAN RGYINGS" . 3978)
                             ("TIBETAN SIGN GRU MED RGYINGS" . 3979)
                             ("TIBETAN SUBJOINED LETTER KA" . 3984)
                             ("TIBETAN SUBJOINED LETTER KHA" . 3985)
                             ("TIBETAN SUBJOINED LETTER GA" . 3986)
                             ("TIBETAN SUBJOINED LETTER GHA" . 3987)
                             ("TIBETAN SUBJOINED LETTER NGA" . 3988)
                             ("TIBETAN SUBJOINED LETTER CA" . 3989)
                             ("TIBETAN SUBJOINED LETTER CHA" . 3990)
                             ("TIBETAN SUBJOINED LETTER JA" . 3991)
                             ("TIBETAN SUBJOINED LETTER NYA" . 3993)
                             ("TIBETAN SUBJOINED LETTER TTA" . 3994)
                             ("TIBETAN SUBJOINED LETTER TTHA" . 3995)
                             ("TIBETAN SUBJOINED LETTER DDA" . 3996)
                             ("TIBETAN SUBJOINED LETTER DDHA" . 3997)
                             ("TIBETAN SUBJOINED LETTER NNA" . 3998)
                             ("TIBETAN SUBJOINED LETTER TA" . 3999)
                             ("TIBETAN SUBJOINED LETTER THA" . 4000)
                             ("TIBETAN SUBJOINED LETTER DA" . 4001)
                             ("TIBETAN SUBJOINED LETTER DHA" . 4002)
                             ("TIBETAN SUBJOINED LETTER NA" . 4003)
                             ("TIBETAN SUBJOINED LETTER PA" . 4004)
                             ("TIBETAN SUBJOINED LETTER PHA" . 4005)
                             ("TIBETAN SUBJOINED LETTER BA" . 4006)
                             ("TIBETAN SUBJOINED LETTER BHA" . 4007)
                             ("TIBETAN SUBJOINED LETTER MA" . 4008)
                             ("TIBETAN SUBJOINED LETTER TSA" . 4009)
                             ("TIBETAN SUBJOINED LETTER TSHA" . 4010)
                             ("TIBETAN SUBJOINED LETTER DZA" . 4011)
                             ("TIBETAN SUBJOINED LETTER DZHA" . 4012)
                             ("TIBETAN SUBJOINED LETTER WA" . 4013)
                             ("TIBETAN SUBJOINED LETTER ZHA" . 4014)
                             ("TIBETAN SUBJOINED LETTER ZA" . 4015)
                             ("TIBETAN SUBJOINED LETTER -A" . 4016)
                             ("TIBETAN SUBJOINED LETTER YA" . 4017)
                             ("TIBETAN SUBJOINED LETTER RA" . 4018)
                             ("TIBETAN SUBJOINED LETTER LA" . 4019)
                             ("TIBETAN SUBJOINED LETTER SHA" . 4020)
                             ("TIBETAN SUBJOINED LETTER SSA" . 4021)
                             ("TIBETAN SUBJOINED LETTER SA" . 4022)
                             ("TIBETAN SUBJOINED LETTER HA" . 4023)
                             ("TIBETAN SUBJOINED LETTER A" . 4024)
                             ("TIBETAN SUBJOINED LETTER KSSA" . 4025)
                             ("TIBETAN SUBJOINED LETTER FIXED-FORM WA" . 4026)
                             ("TIBETAN SUBJOINED LETTER FIXED-FORM YA" . 4027)
                             ("TIBETAN SUBJOINED LETTER FIXED-FORM RA" . 4028)
                             ("TIBETAN KU RU KHA" . 4030)
                             ("TIBETAN KU RU KHA BZHI MIG CAN" . 4031)
                             ("TIBETAN CANTILLATION SIGN HEAVY BEAT" . 4032)
                             ("TIBETAN CANTILLATION SIGN LIGHT BEAT" . 4033)
                             ("TIBETAN CANTILLATION SIGN CANG TE-U" . 4034)
                             ("TIBETAN CANTILLATION SIGN SBUB -CHAL" . 4035)
                             ("TIBETAN SYMBOL DRIL BU" . 4036)
                             ("TIBETAN SYMBOL RDO RJE" . 4037)
                             ("TIBETAN SYMBOL PADMA GDAN" . 4038)
                             ("TIBETAN SYMBOL RDO RJE RGYA GRAM" . 4039)
                             ("TIBETAN SYMBOL PHUR PA" . 4040)
                             ("TIBETAN SYMBOL NOR BU" . 4041)
                             ("TIBETAN SYMBOL NOR BU NYIS -KHYIL" . 4042)
                             ("TIBETAN SYMBOL NOR BU GSUM -KHYIL" . 4043)
                             ("TIBETAN SYMBOL NOR BU BZHI -KHYIL" . 4044)
                             ("TIBETAN SIGN RDEL NAG GSUM" . 4047)
                             ("MYANMAR LETTER KA" . 4096)
                             ("MYANMAR LETTER KHA" . 4097)
                             ("MYANMAR LETTER GA" . 4098)
                             ("MYANMAR LETTER GHA" . 4099)
                             ("MYANMAR LETTER NGA" . 4100)
                             ("MYANMAR LETTER CA" . 4101)
                             ("MYANMAR LETTER CHA" . 4102)
                             ("MYANMAR LETTER JA" . 4103)
                             ("MYANMAR LETTER JHA" . 4104)
                             ("MYANMAR LETTER NYA" . 4105)
                             ("MYANMAR LETTER NNYA" . 4106)
                             ("MYANMAR LETTER TTA" . 4107)
                             ("MYANMAR LETTER TTHA" . 4108)
                             ("MYANMAR LETTER DDA" . 4109)
                             ("MYANMAR LETTER DDHA" . 4110)
                             ("MYANMAR LETTER NNA" . 4111)
                             ("MYANMAR LETTER TA" . 4112)
                             ("MYANMAR LETTER THA" . 4113)
                             ("MYANMAR LETTER DA" . 4114)
                             ("MYANMAR LETTER DHA" . 4115)
                             ("MYANMAR LETTER NA" . 4116)
                             ("MYANMAR LETTER PA" . 4117)
                             ("MYANMAR LETTER PHA" . 4118)
                             ("MYANMAR LETTER BA" . 4119)
                             ("MYANMAR LETTER BHA" . 4120)
                             ("MYANMAR LETTER MA" . 4121)
                             ("MYANMAR LETTER YA" . 4122)
                             ("MYANMAR LETTER RA" . 4123)
                             ("MYANMAR LETTER LA" . 4124)
                             ("MYANMAR LETTER WA" . 4125)
                             ("MYANMAR LETTER SA" . 4126)
                             ("MYANMAR LETTER HA" . 4127)
                             ("MYANMAR LETTER LLA" . 4128)
                             ("MYANMAR LETTER A" . 4129)
                             ("MYANMAR LETTER I" . 4131)
                             ("MYANMAR LETTER II" . 4132)
                             ("MYANMAR LETTER U" . 4133)
                             ("MYANMAR LETTER UU" . 4134)
                             ("MYANMAR LETTER E" . 4135)
                             ("MYANMAR LETTER O" . 4137)
                             ("MYANMAR LETTER AU" . 4138)
                             ("MYANMAR VOWEL SIGN AA" . 4140)
                             ("MYANMAR VOWEL SIGN I" . 4141)
                             ("MYANMAR VOWEL SIGN II" . 4142)
                             ("MYANMAR VOWEL SIGN U" . 4143)
                             ("MYANMAR VOWEL SIGN UU" . 4144)
                             ("MYANMAR VOWEL SIGN E" . 4145)
                             ("MYANMAR VOWEL SIGN AI" . 4146)
                             ("MYANMAR SIGN ANUSVARA" . 4150)
                             ("MYANMAR SIGN DOT BELOW" . 4151)
                             ("MYANMAR SIGN VISARGA" . 4152)
                             ("MYANMAR SIGN VIRAMA" . 4153)
                             ("MYANMAR DIGIT ZERO" . 4160)
                             ("MYANMAR DIGIT ONE" . 4161)
                             ("MYANMAR DIGIT TWO" . 4162)
                             ("MYANMAR DIGIT THREE" . 4163)
                             ("MYANMAR DIGIT FOUR" . 4164)
                             ("MYANMAR DIGIT FIVE" . 4165)
                             ("MYANMAR DIGIT SIX" . 4166)
                             ("MYANMAR DIGIT SEVEN" . 4167)
                             ("MYANMAR DIGIT EIGHT" . 4168)
                             ("MYANMAR DIGIT NINE" . 4169)
                             ("MYANMAR SIGN LITTLE SECTION" . 4170)
                             ("MYANMAR SIGN SECTION" . 4171)
                             ("MYANMAR SYMBOL LOCATIVE" . 4172)
                             ("MYANMAR SYMBOL COMPLETED" . 4173)
                             ("MYANMAR SYMBOL AFOREMENTIONED" . 4174)
                             ("MYANMAR SYMBOL GENITIVE" . 4175)
                             ("MYANMAR LETTER SHA" . 4176)
                             ("MYANMAR LETTER SSA" . 4177)
                             ("MYANMAR LETTER VOCALIC R" . 4178)
                             ("MYANMAR LETTER VOCALIC RR" . 4179)
                             ("MYANMAR LETTER VOCALIC L" . 4180)
                             ("MYANMAR LETTER VOCALIC LL" . 4181)
                             ("MYANMAR VOWEL SIGN VOCALIC R" . 4182)
                             ("MYANMAR VOWEL SIGN VOCALIC RR" . 4183)
                             ("MYANMAR VOWEL SIGN VOCALIC L" . 4184)
                             ("MYANMAR VOWEL SIGN VOCALIC LL" . 4185)
                             ("GEORGIAN CAPITAL LETTER AN" . 4256)
                             ("GEORGIAN CAPITAL LETTER BAN" . 4257)
                             ("GEORGIAN CAPITAL LETTER GAN" . 4258)
                             ("GEORGIAN CAPITAL LETTER DON" . 4259)
                             ("GEORGIAN CAPITAL LETTER EN" . 4260)
                             ("GEORGIAN CAPITAL LETTER VIN" . 4261)
                             ("GEORGIAN CAPITAL LETTER ZEN" . 4262)
                             ("GEORGIAN CAPITAL LETTER TAN" . 4263)
                             ("GEORGIAN CAPITAL LETTER IN" . 4264)
                             ("GEORGIAN CAPITAL LETTER KAN" . 4265)
                             ("GEORGIAN CAPITAL LETTER LAS" . 4266)
                             ("GEORGIAN CAPITAL LETTER MAN" . 4267)
                             ("GEORGIAN CAPITAL LETTER NAR" . 4268)
                             ("GEORGIAN CAPITAL LETTER ON" . 4269)
                             ("GEORGIAN CAPITAL LETTER PAR" . 4270)
                             ("GEORGIAN CAPITAL LETTER ZHAR" . 4271)
                             ("GEORGIAN CAPITAL LETTER RAE" . 4272)
                             ("GEORGIAN CAPITAL LETTER SAN" . 4273)
                             ("GEORGIAN CAPITAL LETTER TAR" . 4274)
                             ("GEORGIAN CAPITAL LETTER UN" . 4275)
                             ("GEORGIAN CAPITAL LETTER PHAR" . 4276)
                             ("GEORGIAN CAPITAL LETTER KHAR" . 4277)
                             ("GEORGIAN CAPITAL LETTER GHAN" . 4278)
                             ("GEORGIAN CAPITAL LETTER QAR" . 4279)
                             ("GEORGIAN CAPITAL LETTER SHIN" . 4280)
                             ("GEORGIAN CAPITAL LETTER CHIN" . 4281)
                             ("GEORGIAN CAPITAL LETTER CAN" . 4282)
                             ("GEORGIAN CAPITAL LETTER JIL" . 4283)
                             ("GEORGIAN CAPITAL LETTER CIL" . 4284)
                             ("GEORGIAN CAPITAL LETTER CHAR" . 4285)
                             ("GEORGIAN CAPITAL LETTER XAN" . 4286)
                             ("GEORGIAN CAPITAL LETTER JHAN" . 4287)
                             ("GEORGIAN CAPITAL LETTER HAE" . 4288)
                             ("GEORGIAN CAPITAL LETTER HE" . 4289)
                             ("GEORGIAN CAPITAL LETTER HIE" . 4290)
                             ("GEORGIAN CAPITAL LETTER WE" . 4291)
                             ("GEORGIAN CAPITAL LETTER HAR" . 4292)
                             ("GEORGIAN CAPITAL LETTER HOE" . 4293)
                             ("GEORGIAN LETTER AN" . 4304)
                             ("GEORGIAN LETTER BAN" . 4305)
                             ("GEORGIAN LETTER GAN" . 4306)
                             ("GEORGIAN LETTER DON" . 4307)
                             ("GEORGIAN LETTER EN" . 4308)
                             ("GEORGIAN LETTER VIN" . 4309)
                             ("GEORGIAN LETTER ZEN" . 4310)
                             ("GEORGIAN LETTER TAN" . 4311)
                             ("GEORGIAN LETTER IN" . 4312)
                             ("GEORGIAN LETTER KAN" . 4313)
                             ("GEORGIAN LETTER LAS" . 4314)
                             ("GEORGIAN LETTER MAN" . 4315)
                             ("GEORGIAN LETTER NAR" . 4316)
                             ("GEORGIAN LETTER ON" . 4317)
                             ("GEORGIAN LETTER PAR" . 4318)
                             ("GEORGIAN LETTER ZHAR" . 4319)
                             ("GEORGIAN LETTER RAE" . 4320)
                             ("GEORGIAN LETTER SAN" . 4321)
                             ("GEORGIAN LETTER TAR" . 4322)
                             ("GEORGIAN LETTER UN" . 4323)
                             ("GEORGIAN LETTER PHAR" . 4324)
                             ("GEORGIAN LETTER KHAR" . 4325)
                             ("GEORGIAN LETTER GHAN" . 4326)
                             ("GEORGIAN LETTER QAR" . 4327)
                             ("GEORGIAN LETTER SHIN" . 4328)
                             ("GEORGIAN LETTER CHIN" . 4329)
                             ("GEORGIAN LETTER CAN" . 4330)
                             ("GEORGIAN LETTER JIL" . 4331)
                             ("GEORGIAN LETTER CIL" . 4332)
                             ("GEORGIAN LETTER CHAR" . 4333)
                             ("GEORGIAN LETTER XAN" . 4334)
                             ("GEORGIAN LETTER JHAN" . 4335)
                             ("GEORGIAN LETTER HAE" . 4336)
                             ("GEORGIAN LETTER HE" . 4337)
                             ("GEORGIAN LETTER HIE" . 4338)
                             ("GEORGIAN LETTER WE" . 4339)
                             ("GEORGIAN LETTER HAR" . 4340)
                             ("GEORGIAN LETTER HOE" . 4341)
                             ("GEORGIAN LETTER FI" . 4342)
                             ("GEORGIAN LETTER YN" . 4343)
                             ("GEORGIAN LETTER ELIFI" . 4344)
                             ("GEORGIAN PARAGRAPH SEPARATOR" . 4347)
                             ("HANGUL CHOSEONG KIYEOK" . 4352)
                             ("HANGUL CHOSEONG SSANGKIYEOK" . 4353)
                             ("HANGUL CHOSEONG NIEUN" . 4354)
                             ("HANGUL CHOSEONG TIKEUT" . 4355)
                             ("HANGUL CHOSEONG SSANGTIKEUT" . 4356)
                             ("HANGUL CHOSEONG RIEUL" . 4357)
                             ("HANGUL CHOSEONG MIEUM" . 4358)
                             ("HANGUL CHOSEONG PIEUP" . 4359)
                             ("HANGUL CHOSEONG SSANGPIEUP" . 4360)
                             ("HANGUL CHOSEONG SIOS" . 4361)
                             ("HANGUL CHOSEONG SSANGSIOS" . 4362)
                             ("HANGUL CHOSEONG IEUNG" . 4363)
                             ("HANGUL CHOSEONG CIEUC" . 4364)
                             ("HANGUL CHOSEONG SSANGCIEUC" . 4365)
                             ("HANGUL CHOSEONG CHIEUCH" . 4366)
                             ("HANGUL CHOSEONG KHIEUKH" . 4367)
                             ("HANGUL CHOSEONG THIEUTH" . 4368)
                             ("HANGUL CHOSEONG PHIEUPH" . 4369)
                             ("HANGUL CHOSEONG HIEUH" . 4370)
                             ("HANGUL CHOSEONG NIEUN-KIYEOK" . 4371)
                             ("HANGUL CHOSEONG SSANGNIEUN" . 4372)
                             ("HANGUL CHOSEONG NIEUN-TIKEUT" . 4373)
                             ("HANGUL CHOSEONG NIEUN-PIEUP" . 4374)
                             ("HANGUL CHOSEONG TIKEUT-KIYEOK" . 4375)
                             ("HANGUL CHOSEONG RIEUL-NIEUN" . 4376)
                             ("HANGUL CHOSEONG SSANGRIEUL" . 4377)
                             ("HANGUL CHOSEONG RIEUL-HIEUH" . 4378)
                             ("HANGUL CHOSEONG KAPYEOUNRIEUL" . 4379)
                             ("HANGUL CHOSEONG MIEUM-PIEUP" . 4380)
                             ("HANGUL CHOSEONG KAPYEOUNMIEUM" . 4381)
                             ("HANGUL CHOSEONG PIEUP-KIYEOK" . 4382)
                             ("HANGUL CHOSEONG PIEUP-NIEUN" . 4383)
                             ("HANGUL CHOSEONG PIEUP-TIKEUT" . 4384)
                             ("HANGUL CHOSEONG PIEUP-SIOS" . 4385)
                             ("HANGUL CHOSEONG PIEUP-SIOS-KIYEOK" . 4386)
                             ("HANGUL CHOSEONG PIEUP-SIOS-TIKEUT" . 4387)
                             ("HANGUL CHOSEONG PIEUP-SIOS-PIEUP" . 4388)
                             ("HANGUL CHOSEONG PIEUP-SSANGSIOS" . 4389)
                             ("HANGUL CHOSEONG PIEUP-SIOS-CIEUC" . 4390)
                             ("HANGUL CHOSEONG PIEUP-CIEUC" . 4391)
                             ("HANGUL CHOSEONG PIEUP-CHIEUCH" . 4392)
                             ("HANGUL CHOSEONG PIEUP-THIEUTH" . 4393)
                             ("HANGUL CHOSEONG PIEUP-PHIEUPH" . 4394)
                             ("HANGUL CHOSEONG KAPYEOUNPIEUP" . 4395)
                             ("HANGUL CHOSEONG KAPYEOUNSSANGPIEUP" . 4396)
                             ("HANGUL CHOSEONG SIOS-KIYEOK" . 4397)
                             ("HANGUL CHOSEONG SIOS-NIEUN" . 4398)
                             ("HANGUL CHOSEONG SIOS-TIKEUT" . 4399)
                             ("HANGUL CHOSEONG SIOS-RIEUL" . 4400)
                             ("HANGUL CHOSEONG SIOS-MIEUM" . 4401)
                             ("HANGUL CHOSEONG SIOS-PIEUP" . 4402)
                             ("HANGUL CHOSEONG SIOS-PIEUP-KIYEOK" . 4403)
                             ("HANGUL CHOSEONG SIOS-SSANGSIOS" . 4404)
                             ("HANGUL CHOSEONG SIOS-IEUNG" . 4405)
                             ("HANGUL CHOSEONG SIOS-CIEUC" . 4406)
                             ("HANGUL CHOSEONG SIOS-CHIEUCH" . 4407)
                             ("HANGUL CHOSEONG SIOS-KHIEUKH" . 4408)
                             ("HANGUL CHOSEONG SIOS-THIEUTH" . 4409)
                             ("HANGUL CHOSEONG SIOS-PHIEUPH" . 4410)
                             ("HANGUL CHOSEONG SIOS-HIEUH" . 4411)
                             ("HANGUL CHOSEONG CHITUEUMSIOS" . 4412)
                             ("HANGUL CHOSEONG CHITUEUMSSANGSIOS" . 4413)
                             ("HANGUL CHOSEONG CEONGCHIEUMSIOS" . 4414)
                             ("HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS" . 4415)
                             ("HANGUL CHOSEONG PANSIOS" . 4416)
                             ("HANGUL CHOSEONG IEUNG-KIYEOK" . 4417)
                             ("HANGUL CHOSEONG IEUNG-TIKEUT" . 4418)
                             ("HANGUL CHOSEONG IEUNG-MIEUM" . 4419)
                             ("HANGUL CHOSEONG IEUNG-PIEUP" . 4420)
                             ("HANGUL CHOSEONG IEUNG-SIOS" . 4421)
                             ("HANGUL CHOSEONG IEUNG-PANSIOS" . 4422)
                             ("HANGUL CHOSEONG SSANGIEUNG" . 4423)
                             ("HANGUL CHOSEONG IEUNG-CIEUC" . 4424)
                             ("HANGUL CHOSEONG IEUNG-CHIEUCH" . 4425)
                             ("HANGUL CHOSEONG IEUNG-THIEUTH" . 4426)
                             ("HANGUL CHOSEONG IEUNG-PHIEUPH" . 4427)
                             ("HANGUL CHOSEONG YESIEUNG" . 4428)
                             ("HANGUL CHOSEONG CIEUC-IEUNG" . 4429)
                             ("HANGUL CHOSEONG CHITUEUMCIEUC" . 4430)
                             ("HANGUL CHOSEONG CHITUEUMSSANGCIEUC" . 4431)
                             ("HANGUL CHOSEONG CEONGCHIEUMCIEUC" . 4432)
                             ("HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC" . 4433)
                             ("HANGUL CHOSEONG CHIEUCH-KHIEUKH" . 4434)
                             ("HANGUL CHOSEONG CHIEUCH-HIEUH" . 4435)
                             ("HANGUL CHOSEONG CHITUEUMCHIEUCH" . 4436)
                             ("HANGUL CHOSEONG CEONGCHIEUMCHIEUCH" . 4437)
                             ("HANGUL CHOSEONG PHIEUPH-PIEUP" . 4438)
                             ("HANGUL CHOSEONG KAPYEOUNPHIEUPH" . 4439)
                             ("HANGUL CHOSEONG SSANGHIEUH" . 4440)
                             ("HANGUL CHOSEONG YEORINHIEUH" . 4441)
                             ("HANGUL CHOSEONG FILLER" . 4447)
                             ("HANGUL JUNGSEONG FILLER" . 4448)
                             ("HANGUL JUNGSEONG A" . 4449)
                             ("HANGUL JUNGSEONG AE" . 4450)
                             ("HANGUL JUNGSEONG YA" . 4451)
                             ("HANGUL JUNGSEONG YAE" . 4452)
                             ("HANGUL JUNGSEONG EO" . 4453)
                             ("HANGUL JUNGSEONG E" . 4454)
                             ("HANGUL JUNGSEONG YEO" . 4455)
                             ("HANGUL JUNGSEONG YE" . 4456)
                             ("HANGUL JUNGSEONG O" . 4457)
                             ("HANGUL JUNGSEONG WA" . 4458)
                             ("HANGUL JUNGSEONG WAE" . 4459)
                             ("HANGUL JUNGSEONG OE" . 4460)
                             ("HANGUL JUNGSEONG YO" . 4461)
                             ("HANGUL JUNGSEONG U" . 4462)
                             ("HANGUL JUNGSEONG WEO" . 4463)
                             ("HANGUL JUNGSEONG WE" . 4464)
                             ("HANGUL JUNGSEONG WI" . 4465)
                             ("HANGUL JUNGSEONG YU" . 4466)
                             ("HANGUL JUNGSEONG EU" . 4467)
                             ("HANGUL JUNGSEONG YI" . 4468)
                             ("HANGUL JUNGSEONG I" . 4469)
                             ("HANGUL JUNGSEONG A-O" . 4470)
                             ("HANGUL JUNGSEONG A-U" . 4471)
                             ("HANGUL JUNGSEONG YA-O" . 4472)
                             ("HANGUL JUNGSEONG YA-YO" . 4473)
                             ("HANGUL JUNGSEONG EO-O" . 4474)
                             ("HANGUL JUNGSEONG EO-U" . 4475)
                             ("HANGUL JUNGSEONG EO-EU" . 4476)
                             ("HANGUL JUNGSEONG YEO-O" . 4477)
                             ("HANGUL JUNGSEONG YEO-U" . 4478)
                             ("HANGUL JUNGSEONG O-EO" . 4479)
                             ("HANGUL JUNGSEONG O-E" . 4480)
                             ("HANGUL JUNGSEONG O-YE" . 4481)
                             ("HANGUL JUNGSEONG O-O" . 4482)
                             ("HANGUL JUNGSEONG O-U" . 4483)
                             ("HANGUL JUNGSEONG YO-YA" . 4484)
                             ("HANGUL JUNGSEONG YO-YAE" . 4485)
                             ("HANGUL JUNGSEONG YO-YEO" . 4486)
                             ("HANGUL JUNGSEONG YO-O" . 4487)
                             ("HANGUL JUNGSEONG YO-I" . 4488)
                             ("HANGUL JUNGSEONG U-A" . 4489)
                             ("HANGUL JUNGSEONG U-AE" . 4490)
                             ("HANGUL JUNGSEONG U-EO-EU" . 4491)
                             ("HANGUL JUNGSEONG U-YE" . 4492)
                             ("HANGUL JUNGSEONG U-U" . 4493)
                             ("HANGUL JUNGSEONG YU-A" . 4494)
                             ("HANGUL JUNGSEONG YU-EO" . 4495)
                             ("HANGUL JUNGSEONG YU-E" . 4496)
                             ("HANGUL JUNGSEONG YU-YEO" . 4497)
                             ("HANGUL JUNGSEONG YU-YE" . 4498)
                             ("HANGUL JUNGSEONG YU-U" . 4499)
                             ("HANGUL JUNGSEONG YU-I" . 4500)
                             ("HANGUL JUNGSEONG EU-U" . 4501)
                             ("HANGUL JUNGSEONG EU-EU" . 4502)
                             ("HANGUL JUNGSEONG YI-U" . 4503)
                             ("HANGUL JUNGSEONG I-A" . 4504)
                             ("HANGUL JUNGSEONG I-YA" . 4505)
                             ("HANGUL JUNGSEONG I-O" . 4506)
                             ("HANGUL JUNGSEONG I-U" . 4507)
                             ("HANGUL JUNGSEONG I-EU" . 4508)
                             ("HANGUL JUNGSEONG I-ARAEA" . 4509)
                             ("HANGUL JUNGSEONG ARAEA" . 4510)
                             ("HANGUL JUNGSEONG ARAEA-EO" . 4511)
                             ("HANGUL JUNGSEONG ARAEA-U" . 4512)
                             ("HANGUL JUNGSEONG ARAEA-I" . 4513)
                             ("HANGUL JUNGSEONG SSANGARAEA" . 4514)
                             ("HANGUL JONGSEONG KIYEOK" . 4520)
                             ("HANGUL JONGSEONG SSANGKIYEOK" . 4521)
                             ("HANGUL JONGSEONG KIYEOK-SIOS" . 4522)
                             ("HANGUL JONGSEONG NIEUN" . 4523)
                             ("HANGUL JONGSEONG NIEUN-CIEUC" . 4524)
                             ("HANGUL JONGSEONG NIEUN-HIEUH" . 4525)
                             ("HANGUL JONGSEONG TIKEUT" . 4526)
                             ("HANGUL JONGSEONG RIEUL" . 4527)
                             ("HANGUL JONGSEONG RIEUL-KIYEOK" . 4528)
                             ("HANGUL JONGSEONG RIEUL-MIEUM" . 4529)
                             ("HANGUL JONGSEONG RIEUL-PIEUP" . 4530)
                             ("HANGUL JONGSEONG RIEUL-SIOS" . 4531)
                             ("HANGUL JONGSEONG RIEUL-THIEUTH" . 4532)
                             ("HANGUL JONGSEONG RIEUL-PHIEUPH" . 4533)
                             ("HANGUL JONGSEONG RIEUL-HIEUH" . 4534)
                             ("HANGUL JONGSEONG MIEUM" . 4535)
                             ("HANGUL JONGSEONG PIEUP" . 4536)
                             ("HANGUL JONGSEONG PIEUP-SIOS" . 4537)
                             ("HANGUL JONGSEONG SIOS" . 4538)
                             ("HANGUL JONGSEONG SSANGSIOS" . 4539)
                             ("HANGUL JONGSEONG IEUNG" . 4540)
                             ("HANGUL JONGSEONG CIEUC" . 4541)
                             ("HANGUL JONGSEONG CHIEUCH" . 4542)
                             ("HANGUL JONGSEONG KHIEUKH" . 4543)
                             ("HANGUL JONGSEONG THIEUTH" . 4544)
                             ("HANGUL JONGSEONG PHIEUPH" . 4545)
                             ("HANGUL JONGSEONG HIEUH" . 4546)
                             ("HANGUL JONGSEONG KIYEOK-RIEUL" . 4547)
                             ("HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK" . 4548)
                             ("HANGUL JONGSEONG NIEUN-KIYEOK" . 4549)
                             ("HANGUL JONGSEONG NIEUN-TIKEUT" . 4550)
                             ("HANGUL JONGSEONG NIEUN-SIOS" . 4551)
                             ("HANGUL JONGSEONG NIEUN-PANSIOS" . 4552)
                             ("HANGUL JONGSEONG NIEUN-THIEUTH" . 4553)
                             ("HANGUL JONGSEONG TIKEUT-KIYEOK" . 4554)
                             ("HANGUL JONGSEONG TIKEUT-RIEUL" . 4555)
                             ("HANGUL JONGSEONG RIEUL-KIYEOK-SIOS" . 4556)
                             ("HANGUL JONGSEONG RIEUL-NIEUN" . 4557)
                             ("HANGUL JONGSEONG RIEUL-TIKEUT" . 4558)
                             ("HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH" . 4559)
                             ("HANGUL JONGSEONG SSANGRIEUL" . 4560)
                             ("HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK" . 4561)
                             ("HANGUL JONGSEONG RIEUL-MIEUM-SIOS" . 4562)
                             ("HANGUL JONGSEONG RIEUL-PIEUP-SIOS" . 4563)
                             ("HANGUL JONGSEONG RIEUL-PIEUP-HIEUH" . 4564)
                             ("HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP" . 4565)
                             ("HANGUL JONGSEONG RIEUL-SSANGSIOS" . 4566)
                             ("HANGUL JONGSEONG RIEUL-PANSIOS" . 4567)
                             ("HANGUL JONGSEONG RIEUL-KHIEUKH" . 4568)
                             ("HANGUL JONGSEONG RIEUL-YEORINHIEUH" . 4569)
                             ("HANGUL JONGSEONG MIEUM-KIYEOK" . 4570)
                             ("HANGUL JONGSEONG MIEUM-RIEUL" . 4571)
                             ("HANGUL JONGSEONG MIEUM-PIEUP" . 4572)
                             ("HANGUL JONGSEONG MIEUM-SIOS" . 4573)
                             ("HANGUL JONGSEONG MIEUM-SSANGSIOS" . 4574)
                             ("HANGUL JONGSEONG MIEUM-PANSIOS" . 4575)
                             ("HANGUL JONGSEONG MIEUM-CHIEUCH" . 4576)
                             ("HANGUL JONGSEONG MIEUM-HIEUH" . 4577)
                             ("HANGUL JONGSEONG KAPYEOUNMIEUM" . 4578)
                             ("HANGUL JONGSEONG PIEUP-RIEUL" . 4579)
                             ("HANGUL JONGSEONG PIEUP-PHIEUPH" . 4580)
                             ("HANGUL JONGSEONG PIEUP-HIEUH" . 4581)
                             ("HANGUL JONGSEONG KAPYEOUNPIEUP" . 4582)
                             ("HANGUL JONGSEONG SIOS-KIYEOK" . 4583)
                             ("HANGUL JONGSEONG SIOS-TIKEUT" . 4584)
                             ("HANGUL JONGSEONG SIOS-RIEUL" . 4585)
                             ("HANGUL JONGSEONG SIOS-PIEUP" . 4586)
                             ("HANGUL JONGSEONG PANSIOS" . 4587)
                             ("HANGUL JONGSEONG IEUNG-KIYEOK" . 4588)
                             ("HANGUL JONGSEONG IEUNG-SSANGKIYEOK" . 4589)
                             ("HANGUL JONGSEONG SSANGIEUNG" . 4590)
                             ("HANGUL JONGSEONG IEUNG-KHIEUKH" . 4591)
                             ("HANGUL JONGSEONG YESIEUNG" . 4592)
                             ("HANGUL JONGSEONG YESIEUNG-SIOS" . 4593)
                             ("HANGUL JONGSEONG YESIEUNG-PANSIOS" . 4594)
                             ("HANGUL JONGSEONG PHIEUPH-PIEUP" . 4595)
                             ("HANGUL JONGSEONG KAPYEOUNPHIEUPH" . 4596)
                             ("HANGUL JONGSEONG HIEUH-NIEUN" . 4597)
                             ("HANGUL JONGSEONG HIEUH-RIEUL" . 4598)
                             ("HANGUL JONGSEONG HIEUH-MIEUM" . 4599)
                             ("HANGUL JONGSEONG HIEUH-PIEUP" . 4600)
                             ("HANGUL JONGSEONG YEORINHIEUH" . 4601)
                             ("ETHIOPIC SYLLABLE HA" . 4608)
                             ("ETHIOPIC SYLLABLE HU" . 4609)
                             ("ETHIOPIC SYLLABLE HI" . 4610)
                             ("ETHIOPIC SYLLABLE HAA" . 4611)
                             ("ETHIOPIC SYLLABLE HEE" . 4612)
                             ("ETHIOPIC SYLLABLE HE" . 4613)
                             ("ETHIOPIC SYLLABLE HO" . 4614)
                             ("ETHIOPIC SYLLABLE LA" . 4616)
                             ("ETHIOPIC SYLLABLE LU" . 4617)
                             ("ETHIOPIC SYLLABLE LI" . 4618)
                             ("ETHIOPIC SYLLABLE LAA" . 4619)
                             ("ETHIOPIC SYLLABLE LEE" . 4620)
                             ("ETHIOPIC SYLLABLE LE" . 4621)
                             ("ETHIOPIC SYLLABLE LO" . 4622)
                             ("ETHIOPIC SYLLABLE LWA" . 4623)
                             ("ETHIOPIC SYLLABLE HHA" . 4624)
                             ("ETHIOPIC SYLLABLE HHU" . 4625)
                             ("ETHIOPIC SYLLABLE HHI" . 4626)
                             ("ETHIOPIC SYLLABLE HHAA" . 4627)
                             ("ETHIOPIC SYLLABLE HHEE" . 4628)
                             ("ETHIOPIC SYLLABLE HHE" . 4629)
                             ("ETHIOPIC SYLLABLE HHO" . 4630)
                             ("ETHIOPIC SYLLABLE HHWA" . 4631)
                             ("ETHIOPIC SYLLABLE MA" . 4632)
                             ("ETHIOPIC SYLLABLE MU" . 4633)
                             ("ETHIOPIC SYLLABLE MI" . 4634)
                             ("ETHIOPIC SYLLABLE MAA" . 4635)
                             ("ETHIOPIC SYLLABLE MEE" . 4636)
                             ("ETHIOPIC SYLLABLE ME" . 4637)
                             ("ETHIOPIC SYLLABLE MO" . 4638)
                             ("ETHIOPIC SYLLABLE MWA" . 4639)
                             ("ETHIOPIC SYLLABLE SZA" . 4640)
                             ("ETHIOPIC SYLLABLE SZU" . 4641)
                             ("ETHIOPIC SYLLABLE SZI" . 4642)
                             ("ETHIOPIC SYLLABLE SZAA" . 4643)
                             ("ETHIOPIC SYLLABLE SZEE" . 4644)
                             ("ETHIOPIC SYLLABLE SZE" . 4645)
                             ("ETHIOPIC SYLLABLE SZO" . 4646)
                             ("ETHIOPIC SYLLABLE SZWA" . 4647)
                             ("ETHIOPIC SYLLABLE RA" . 4648)
                             ("ETHIOPIC SYLLABLE RU" . 4649)
                             ("ETHIOPIC SYLLABLE RI" . 4650)
                             ("ETHIOPIC SYLLABLE RAA" . 4651)
                             ("ETHIOPIC SYLLABLE REE" . 4652)
                             ("ETHIOPIC SYLLABLE RE" . 4653)
                             ("ETHIOPIC SYLLABLE RO" . 4654)
                             ("ETHIOPIC SYLLABLE RWA" . 4655)
                             ("ETHIOPIC SYLLABLE SA" . 4656)
                             ("ETHIOPIC SYLLABLE SU" . 4657)
                             ("ETHIOPIC SYLLABLE SI" . 4658)
                             ("ETHIOPIC SYLLABLE SAA" . 4659)
                             ("ETHIOPIC SYLLABLE SEE" . 4660)
                             ("ETHIOPIC SYLLABLE SE" . 4661)
                             ("ETHIOPIC SYLLABLE SO" . 4662)
                             ("ETHIOPIC SYLLABLE SWA" . 4663)
                             ("ETHIOPIC SYLLABLE SHA" . 4664)
                             ("ETHIOPIC SYLLABLE SHU" . 4665)
                             ("ETHIOPIC SYLLABLE SHI" . 4666)
                             ("ETHIOPIC SYLLABLE SHAA" . 4667)
                             ("ETHIOPIC SYLLABLE SHEE" . 4668)
                             ("ETHIOPIC SYLLABLE SHE" . 4669)
                             ("ETHIOPIC SYLLABLE SHO" . 4670)
                             ("ETHIOPIC SYLLABLE SHWA" . 4671)
                             ("ETHIOPIC SYLLABLE QA" . 4672)
                             ("ETHIOPIC SYLLABLE QU" . 4673)
                             ("ETHIOPIC SYLLABLE QI" . 4674)
                             ("ETHIOPIC SYLLABLE QAA" . 4675)
                             ("ETHIOPIC SYLLABLE QEE" . 4676)
                             ("ETHIOPIC SYLLABLE QE" . 4677)
                             ("ETHIOPIC SYLLABLE QO" . 4678)
                             ("ETHIOPIC SYLLABLE QWA" . 4680)
                             ("ETHIOPIC SYLLABLE QWI" . 4682)
                             ("ETHIOPIC SYLLABLE QWAA" . 4683)
                             ("ETHIOPIC SYLLABLE QWEE" . 4684)
                             ("ETHIOPIC SYLLABLE QWE" . 4685)
                             ("ETHIOPIC SYLLABLE QHA" . 4688)
                             ("ETHIOPIC SYLLABLE QHU" . 4689)
                             ("ETHIOPIC SYLLABLE QHI" . 4690)
                             ("ETHIOPIC SYLLABLE QHAA" . 4691)
                             ("ETHIOPIC SYLLABLE QHEE" . 4692)
                             ("ETHIOPIC SYLLABLE QHE" . 4693)
                             ("ETHIOPIC SYLLABLE QHO" . 4694)
                             ("ETHIOPIC SYLLABLE QHWA" . 4696)
                             ("ETHIOPIC SYLLABLE QHWI" . 4698)
                             ("ETHIOPIC SYLLABLE QHWAA" . 4699)
                             ("ETHIOPIC SYLLABLE QHWEE" . 4700)
                             ("ETHIOPIC SYLLABLE QHWE" . 4701)
                             ("ETHIOPIC SYLLABLE BA" . 4704)
                             ("ETHIOPIC SYLLABLE BU" . 4705)
                             ("ETHIOPIC SYLLABLE BI" . 4706)
                             ("ETHIOPIC SYLLABLE BAA" . 4707)
                             ("ETHIOPIC SYLLABLE BEE" . 4708)
                             ("ETHIOPIC SYLLABLE BE" . 4709)
                             ("ETHIOPIC SYLLABLE BO" . 4710)
                             ("ETHIOPIC SYLLABLE BWA" . 4711)
                             ("ETHIOPIC SYLLABLE VA" . 4712)
                             ("ETHIOPIC SYLLABLE VU" . 4713)
                             ("ETHIOPIC SYLLABLE VI" . 4714)
                             ("ETHIOPIC SYLLABLE VAA" . 4715)
                             ("ETHIOPIC SYLLABLE VEE" . 4716)
                             ("ETHIOPIC SYLLABLE VE" . 4717)
                             ("ETHIOPIC SYLLABLE VO" . 4718)
                             ("ETHIOPIC SYLLABLE VWA" . 4719)
                             ("ETHIOPIC SYLLABLE TA" . 4720)
                             ("ETHIOPIC SYLLABLE TU" . 4721)
                             ("ETHIOPIC SYLLABLE TI" . 4722)
                             ("ETHIOPIC SYLLABLE TAA" . 4723)
                             ("ETHIOPIC SYLLABLE TEE" . 4724)
                             ("ETHIOPIC SYLLABLE TE" . 4725)
                             ("ETHIOPIC SYLLABLE TO" . 4726)
                             ("ETHIOPIC SYLLABLE TWA" . 4727)
                             ("ETHIOPIC SYLLABLE CA" . 4728)
                             ("ETHIOPIC SYLLABLE CU" . 4729)
                             ("ETHIOPIC SYLLABLE CI" . 4730)
                             ("ETHIOPIC SYLLABLE CAA" . 4731)
                             ("ETHIOPIC SYLLABLE CEE" . 4732)
                             ("ETHIOPIC SYLLABLE CE" . 4733)
                             ("ETHIOPIC SYLLABLE CO" . 4734)
                             ("ETHIOPIC SYLLABLE CWA" . 4735)
                             ("ETHIOPIC SYLLABLE XA" . 4736)
                             ("ETHIOPIC SYLLABLE XU" . 4737)
                             ("ETHIOPIC SYLLABLE XI" . 4738)
                             ("ETHIOPIC SYLLABLE XAA" . 4739)
                             ("ETHIOPIC SYLLABLE XEE" . 4740)
                             ("ETHIOPIC SYLLABLE XE" . 4741)
                             ("ETHIOPIC SYLLABLE XO" . 4742)
                             ("ETHIOPIC SYLLABLE XWA" . 4744)
                             ("ETHIOPIC SYLLABLE XWI" . 4746)
                             ("ETHIOPIC SYLLABLE XWAA" . 4747)
                             ("ETHIOPIC SYLLABLE XWEE" . 4748)
                             ("ETHIOPIC SYLLABLE XWE" . 4749)
                             ("ETHIOPIC SYLLABLE NA" . 4752)
                             ("ETHIOPIC SYLLABLE NU" . 4753)
                             ("ETHIOPIC SYLLABLE NI" . 4754)
                             ("ETHIOPIC SYLLABLE NAA" . 4755)
                             ("ETHIOPIC SYLLABLE NEE" . 4756)
                             ("ETHIOPIC SYLLABLE NE" . 4757)
                             ("ETHIOPIC SYLLABLE NO" . 4758)
                             ("ETHIOPIC SYLLABLE NWA" . 4759)
                             ("ETHIOPIC SYLLABLE NYA" . 4760)
                             ("ETHIOPIC SYLLABLE NYU" . 4761)
                             ("ETHIOPIC SYLLABLE NYI" . 4762)
                             ("ETHIOPIC SYLLABLE NYAA" . 4763)
                             ("ETHIOPIC SYLLABLE NYEE" . 4764)
                             ("ETHIOPIC SYLLABLE NYE" . 4765)
                             ("ETHIOPIC SYLLABLE NYO" . 4766)
                             ("ETHIOPIC SYLLABLE NYWA" . 4767)
                             ("ETHIOPIC SYLLABLE GLOTTAL A" . 4768)
                             ("ETHIOPIC SYLLABLE GLOTTAL U" . 4769)
                             ("ETHIOPIC SYLLABLE GLOTTAL I" . 4770)
                             ("ETHIOPIC SYLLABLE GLOTTAL AA" . 4771)
                             ("ETHIOPIC SYLLABLE GLOTTAL EE" . 4772)
                             ("ETHIOPIC SYLLABLE GLOTTAL E" . 4773)
                             ("ETHIOPIC SYLLABLE GLOTTAL O" . 4774)
                             ("ETHIOPIC SYLLABLE GLOTTAL WA" . 4775)
                             ("ETHIOPIC SYLLABLE KA" . 4776)
                             ("ETHIOPIC SYLLABLE KU" . 4777)
                             ("ETHIOPIC SYLLABLE KI" . 4778)
                             ("ETHIOPIC SYLLABLE KAA" . 4779)
                             ("ETHIOPIC SYLLABLE KEE" . 4780)
                             ("ETHIOPIC SYLLABLE KE" . 4781)
                             ("ETHIOPIC SYLLABLE KO" . 4782)
                             ("ETHIOPIC SYLLABLE KWA" . 4784)
                             ("ETHIOPIC SYLLABLE KWI" . 4786)
                             ("ETHIOPIC SYLLABLE KWAA" . 4787)
                             ("ETHIOPIC SYLLABLE KWEE" . 4788)
                             ("ETHIOPIC SYLLABLE KWE" . 4789)
                             ("ETHIOPIC SYLLABLE KXA" . 4792)
                             ("ETHIOPIC SYLLABLE KXU" . 4793)
                             ("ETHIOPIC SYLLABLE KXI" . 4794)
                             ("ETHIOPIC SYLLABLE KXAA" . 4795)
                             ("ETHIOPIC SYLLABLE KXEE" . 4796)
                             ("ETHIOPIC SYLLABLE KXE" . 4797)
                             ("ETHIOPIC SYLLABLE KXO" . 4798)
                             ("ETHIOPIC SYLLABLE KXWA" . 4800)
                             ("ETHIOPIC SYLLABLE KXWI" . 4802)
                             ("ETHIOPIC SYLLABLE KXWAA" . 4803)
                             ("ETHIOPIC SYLLABLE KXWEE" . 4804)
                             ("ETHIOPIC SYLLABLE KXWE" . 4805)
                             ("ETHIOPIC SYLLABLE WA" . 4808)
                             ("ETHIOPIC SYLLABLE WU" . 4809)
                             ("ETHIOPIC SYLLABLE WI" . 4810)
                             ("ETHIOPIC SYLLABLE WAA" . 4811)
                             ("ETHIOPIC SYLLABLE WEE" . 4812)
                             ("ETHIOPIC SYLLABLE WE" . 4813)
                             ("ETHIOPIC SYLLABLE WO" . 4814)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL A" . 4816)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL U" . 4817)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL I" . 4818)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL AA" . 4819)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL EE" . 4820)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL E" . 4821)
                             ("ETHIOPIC SYLLABLE PHARYNGEAL O" . 4822)
                             ("ETHIOPIC SYLLABLE ZA" . 4824)
                             ("ETHIOPIC SYLLABLE ZU" . 4825)
                             ("ETHIOPIC SYLLABLE ZI" . 4826)
                             ("ETHIOPIC SYLLABLE ZAA" . 4827)
                             ("ETHIOPIC SYLLABLE ZEE" . 4828)
                             ("ETHIOPIC SYLLABLE ZE" . 4829)
                             ("ETHIOPIC SYLLABLE ZO" . 4830)
                             ("ETHIOPIC SYLLABLE ZWA" . 4831)
                             ("ETHIOPIC SYLLABLE ZHA" . 4832)
                             ("ETHIOPIC SYLLABLE ZHU" . 4833)
                             ("ETHIOPIC SYLLABLE ZHI" . 4834)
                             ("ETHIOPIC SYLLABLE ZHAA" . 4835)
                             ("ETHIOPIC SYLLABLE ZHEE" . 4836)
                             ("ETHIOPIC SYLLABLE ZHE" . 4837)
                             ("ETHIOPIC SYLLABLE ZHO" . 4838)
                             ("ETHIOPIC SYLLABLE ZHWA" . 4839)
                             ("ETHIOPIC SYLLABLE YA" . 4840)
                             ("ETHIOPIC SYLLABLE YU" . 4841)
                             ("ETHIOPIC SYLLABLE YI" . 4842)
                             ("ETHIOPIC SYLLABLE YAA" . 4843)
                             ("ETHIOPIC SYLLABLE YEE" . 4844)
                             ("ETHIOPIC SYLLABLE YE" . 4845)
                             ("ETHIOPIC SYLLABLE YO" . 4846)
                             ("ETHIOPIC SYLLABLE DA" . 4848)
                             ("ETHIOPIC SYLLABLE DU" . 4849)
                             ("ETHIOPIC SYLLABLE DI" . 4850)
                             ("ETHIOPIC SYLLABLE DAA" . 4851)
                             ("ETHIOPIC SYLLABLE DEE" . 4852)
                             ("ETHIOPIC SYLLABLE DE" . 4853)
                             ("ETHIOPIC SYLLABLE DO" . 4854)
                             ("ETHIOPIC SYLLABLE DWA" . 4855)
                             ("ETHIOPIC SYLLABLE DDA" . 4856)
                             ("ETHIOPIC SYLLABLE DDU" . 4857)
                             ("ETHIOPIC SYLLABLE DDI" . 4858)
                             ("ETHIOPIC SYLLABLE DDAA" . 4859)
                             ("ETHIOPIC SYLLABLE DDEE" . 4860)
                             ("ETHIOPIC SYLLABLE DDE" . 4861)
                             ("ETHIOPIC SYLLABLE DDO" . 4862)
                             ("ETHIOPIC SYLLABLE DDWA" . 4863)
                             ("ETHIOPIC SYLLABLE JA" . 4864)
                             ("ETHIOPIC SYLLABLE JU" . 4865)
                             ("ETHIOPIC SYLLABLE JI" . 4866)
                             ("ETHIOPIC SYLLABLE JAA" . 4867)
                             ("ETHIOPIC SYLLABLE JEE" . 4868)
                             ("ETHIOPIC SYLLABLE JE" . 4869)
                             ("ETHIOPIC SYLLABLE JO" . 4870)
                             ("ETHIOPIC SYLLABLE JWA" . 4871)
                             ("ETHIOPIC SYLLABLE GA" . 4872)
                             ("ETHIOPIC SYLLABLE GU" . 4873)
                             ("ETHIOPIC SYLLABLE GI" . 4874)
                             ("ETHIOPIC SYLLABLE GAA" . 4875)
                             ("ETHIOPIC SYLLABLE GEE" . 4876)
                             ("ETHIOPIC SYLLABLE GE" . 4877)
                             ("ETHIOPIC SYLLABLE GO" . 4878)
                             ("ETHIOPIC SYLLABLE GWA" . 4880)
                             ("ETHIOPIC SYLLABLE GWI" . 4882)
                             ("ETHIOPIC SYLLABLE GWAA" . 4883)
                             ("ETHIOPIC SYLLABLE GWEE" . 4884)
                             ("ETHIOPIC SYLLABLE GWE" . 4885)
                             ("ETHIOPIC SYLLABLE GGA" . 4888)
                             ("ETHIOPIC SYLLABLE GGU" . 4889)
                             ("ETHIOPIC SYLLABLE GGI" . 4890)
                             ("ETHIOPIC SYLLABLE GGAA" . 4891)
                             ("ETHIOPIC SYLLABLE GGEE" . 4892)
                             ("ETHIOPIC SYLLABLE GGE" . 4893)
                             ("ETHIOPIC SYLLABLE GGO" . 4894)
                             ("ETHIOPIC SYLLABLE THA" . 4896)
                             ("ETHIOPIC SYLLABLE THU" . 4897)
                             ("ETHIOPIC SYLLABLE THI" . 4898)
                             ("ETHIOPIC SYLLABLE THAA" . 4899)
                             ("ETHIOPIC SYLLABLE THEE" . 4900)
                             ("ETHIOPIC SYLLABLE THE" . 4901)
                             ("ETHIOPIC SYLLABLE THO" . 4902)
                             ("ETHIOPIC SYLLABLE THWA" . 4903)
                             ("ETHIOPIC SYLLABLE CHA" . 4904)
                             ("ETHIOPIC SYLLABLE CHU" . 4905)
                             ("ETHIOPIC SYLLABLE CHI" . 4906)
                             ("ETHIOPIC SYLLABLE CHAA" . 4907)
                             ("ETHIOPIC SYLLABLE CHEE" . 4908)
                             ("ETHIOPIC SYLLABLE CHE" . 4909)
                             ("ETHIOPIC SYLLABLE CHO" . 4910)
                             ("ETHIOPIC SYLLABLE CHWA" . 4911)
                             ("ETHIOPIC SYLLABLE PHA" . 4912)
                             ("ETHIOPIC SYLLABLE PHU" . 4913)
                             ("ETHIOPIC SYLLABLE PHI" . 4914)
                             ("ETHIOPIC SYLLABLE PHAA" . 4915)
                             ("ETHIOPIC SYLLABLE PHEE" . 4916)
                             ("ETHIOPIC SYLLABLE PHE" . 4917)
                             ("ETHIOPIC SYLLABLE PHO" . 4918)
                             ("ETHIOPIC SYLLABLE PHWA" . 4919)
                             ("ETHIOPIC SYLLABLE TSA" . 4920)
                             ("ETHIOPIC SYLLABLE TSU" . 4921)
                             ("ETHIOPIC SYLLABLE TSI" . 4922)
                             ("ETHIOPIC SYLLABLE TSAA" . 4923)
                             ("ETHIOPIC SYLLABLE TSEE" . 4924)
                             ("ETHIOPIC SYLLABLE TSE" . 4925)
                             ("ETHIOPIC SYLLABLE TSO" . 4926)
                             ("ETHIOPIC SYLLABLE TSWA" . 4927)
                             ("ETHIOPIC SYLLABLE TZA" . 4928)
                             ("ETHIOPIC SYLLABLE TZU" . 4929)
                             ("ETHIOPIC SYLLABLE TZI" . 4930)
                             ("ETHIOPIC SYLLABLE TZAA" . 4931)
                             ("ETHIOPIC SYLLABLE TZEE" . 4932)
                             ("ETHIOPIC SYLLABLE TZE" . 4933)
                             ("ETHIOPIC SYLLABLE TZO" . 4934)
                             ("ETHIOPIC SYLLABLE FA" . 4936)
                             ("ETHIOPIC SYLLABLE FU" . 4937)
                             ("ETHIOPIC SYLLABLE FI" . 4938)
                             ("ETHIOPIC SYLLABLE FAA" . 4939)
                             ("ETHIOPIC SYLLABLE FEE" . 4940)
                             ("ETHIOPIC SYLLABLE FE" . 4941)
                             ("ETHIOPIC SYLLABLE FO" . 4942)
                             ("ETHIOPIC SYLLABLE FWA" . 4943)
                             ("ETHIOPIC SYLLABLE PA" . 4944)
                             ("ETHIOPIC SYLLABLE PU" . 4945)
                             ("ETHIOPIC SYLLABLE PI" . 4946)
                             ("ETHIOPIC SYLLABLE PAA" . 4947)
                             ("ETHIOPIC SYLLABLE PEE" . 4948)
                             ("ETHIOPIC SYLLABLE PE" . 4949)
                             ("ETHIOPIC SYLLABLE PO" . 4950)
                             ("ETHIOPIC SYLLABLE PWA" . 4951)
                             ("ETHIOPIC SYLLABLE RYA" . 4952)
                             ("ETHIOPIC SYLLABLE MYA" . 4953)
                             ("ETHIOPIC SYLLABLE FYA" . 4954)
                             ("ETHIOPIC WORDSPACE" . 4961)
                             ("ETHIOPIC FULL STOP" . 4962)
                             ("ETHIOPIC COMMA" . 4963)
                             ("ETHIOPIC SEMICOLON" . 4964)
                             ("ETHIOPIC COLON" . 4965)
                             ("ETHIOPIC PREFACE COLON" . 4966)
                             ("ETHIOPIC QUESTION MARK" . 4967)
                             ("ETHIOPIC PARAGRAPH SEPARATOR" . 4968)
                             ("ETHIOPIC DIGIT ONE" . 4969)
                             ("ETHIOPIC DIGIT TWO" . 4970)
                             ("ETHIOPIC DIGIT THREE" . 4971)
                             ("ETHIOPIC DIGIT FOUR" . 4972)
                             ("ETHIOPIC DIGIT FIVE" . 4973)
                             ("ETHIOPIC DIGIT SIX" . 4974)
                             ("ETHIOPIC DIGIT SEVEN" . 4975)
                             ("ETHIOPIC DIGIT EIGHT" . 4976)
                             ("ETHIOPIC DIGIT NINE" . 4977)
                             ("ETHIOPIC NUMBER TEN" . 4978)
                             ("ETHIOPIC NUMBER TWENTY" . 4979)
                             ("ETHIOPIC NUMBER THIRTY" . 4980)
                             ("ETHIOPIC NUMBER FORTY" . 4981)
                             ("ETHIOPIC NUMBER FIFTY" . 4982)
                             ("ETHIOPIC NUMBER SIXTY" . 4983)
                             ("ETHIOPIC NUMBER SEVENTY" . 4984)
                             ("ETHIOPIC NUMBER EIGHTY" . 4985)
                             ("ETHIOPIC NUMBER NINETY" . 4986)
                             ("ETHIOPIC NUMBER HUNDRED" . 4987)
                             ("ETHIOPIC NUMBER TEN THOUSAND" . 4988)
                             ("CHEROKEE LETTER A" . 5024)
                             ("CHEROKEE LETTER E" . 5025)
                             ("CHEROKEE LETTER I" . 5026)
                             ("CHEROKEE LETTER O" . 5027)
                             ("CHEROKEE LETTER U" . 5028)
                             ("CHEROKEE LETTER V" . 5029)
                             ("CHEROKEE LETTER GA" . 5030)
                             ("CHEROKEE LETTER KA" . 5031)
                             ("CHEROKEE LETTER GE" . 5032)
                             ("CHEROKEE LETTER GI" . 5033)
                             ("CHEROKEE LETTER GO" . 5034)
                             ("CHEROKEE LETTER GU" . 5035)
                             ("CHEROKEE LETTER GV" . 5036)
                             ("CHEROKEE LETTER HA" . 5037)
                             ("CHEROKEE LETTER HE" . 5038)
                             ("CHEROKEE LETTER HI" . 5039)
                             ("CHEROKEE LETTER HO" . 5040)
                             ("CHEROKEE LETTER HU" . 5041)
                             ("CHEROKEE LETTER HV" . 5042)
                             ("CHEROKEE LETTER LA" . 5043)
                             ("CHEROKEE LETTER LE" . 5044)
                             ("CHEROKEE LETTER LI" . 5045)
                             ("CHEROKEE LETTER LO" . 5046)
                             ("CHEROKEE LETTER LU" . 5047)
                             ("CHEROKEE LETTER LV" . 5048)
                             ("CHEROKEE LETTER MA" . 5049)
                             ("CHEROKEE LETTER ME" . 5050)
                             ("CHEROKEE LETTER MI" . 5051)
                             ("CHEROKEE LETTER MO" . 5052)
                             ("CHEROKEE LETTER MU" . 5053)
                             ("CHEROKEE LETTER NA" . 5054)
                             ("CHEROKEE LETTER HNA" . 5055)
                             ("CHEROKEE LETTER NAH" . 5056)
                             ("CHEROKEE LETTER NE" . 5057)
                             ("CHEROKEE LETTER NI" . 5058)
                             ("CHEROKEE LETTER NO" . 5059)
                             ("CHEROKEE LETTER NU" . 5060)
                             ("CHEROKEE LETTER NV" . 5061)
                             ("CHEROKEE LETTER QUA" . 5062)
                             ("CHEROKEE LETTER QUE" . 5063)
                             ("CHEROKEE LETTER QUI" . 5064)
                             ("CHEROKEE LETTER QUO" . 5065)
                             ("CHEROKEE LETTER QUU" . 5066)
                             ("CHEROKEE LETTER QUV" . 5067)
                             ("CHEROKEE LETTER SA" . 5068)
                             ("CHEROKEE LETTER S" . 5069)
                             ("CHEROKEE LETTER SE" . 5070)
                             ("CHEROKEE LETTER SI" . 5071)
                             ("CHEROKEE LETTER SO" . 5072)
                             ("CHEROKEE LETTER SU" . 5073)
                             ("CHEROKEE LETTER SV" . 5074)
                             ("CHEROKEE LETTER DA" . 5075)
                             ("CHEROKEE LETTER TA" . 5076)
                             ("CHEROKEE LETTER DE" . 5077)
                             ("CHEROKEE LETTER TE" . 5078)
                             ("CHEROKEE LETTER DI" . 5079)
                             ("CHEROKEE LETTER TI" . 5080)
                             ("CHEROKEE LETTER DO" . 5081)
                             ("CHEROKEE LETTER DU" . 5082)
                             ("CHEROKEE LETTER DV" . 5083)
                             ("CHEROKEE LETTER DLA" . 5084)
                             ("CHEROKEE LETTER TLA" . 5085)
                             ("CHEROKEE LETTER TLE" . 5086)
                             ("CHEROKEE LETTER TLI" . 5087)
                             ("CHEROKEE LETTER TLO" . 5088)
                             ("CHEROKEE LETTER TLU" . 5089)
                             ("CHEROKEE LETTER TLV" . 5090)
                             ("CHEROKEE LETTER TSA" . 5091)
                             ("CHEROKEE LETTER TSE" . 5092)
                             ("CHEROKEE LETTER TSI" . 5093)
                             ("CHEROKEE LETTER TSO" . 5094)
                             ("CHEROKEE LETTER TSU" . 5095)
                             ("CHEROKEE LETTER TSV" . 5096)
                             ("CHEROKEE LETTER WA" . 5097)
                             ("CHEROKEE LETTER WE" . 5098)
                             ("CHEROKEE LETTER WI" . 5099)
                             ("CHEROKEE LETTER WO" . 5100)
                             ("CHEROKEE LETTER WU" . 5101)
                             ("CHEROKEE LETTER WV" . 5102)
                             ("CHEROKEE LETTER YA" . 5103)
                             ("CHEROKEE LETTER YE" . 5104)
                             ("CHEROKEE LETTER YI" . 5105)
                             ("CHEROKEE LETTER YO" . 5106)
                             ("CHEROKEE LETTER YU" . 5107)
                             ("CHEROKEE LETTER YV" . 5108)
                             ("CANADIAN SYLLABICS E" . 5121)
                             ("CANADIAN SYLLABICS AAI" . 5122)
                             ("CANADIAN SYLLABICS I" . 5123)
                             ("CANADIAN SYLLABICS II" . 5124)
                             ("CANADIAN SYLLABICS O" . 5125)
                             ("CANADIAN SYLLABICS OO" . 5126)
                             ("CANADIAN SYLLABICS Y-CREE OO" . 5127)
                             ("CANADIAN SYLLABICS CARRIER EE" . 5128)
                             ("CANADIAN SYLLABICS CARRIER I" . 5129)
                             ("CANADIAN SYLLABICS A" . 5130)
                             ("CANADIAN SYLLABICS AA" . 5131)
                             ("CANADIAN SYLLABICS WE" . 5132)
                             ("CANADIAN SYLLABICS WEST-CREE WE" . 5133)
                             ("CANADIAN SYLLABICS WI" . 5134)
                             ("CANADIAN SYLLABICS WEST-CREE WI" . 5135)
                             ("CANADIAN SYLLABICS WII" . 5136)
                             ("CANADIAN SYLLABICS WEST-CREE WII" . 5137)
                             ("CANADIAN SYLLABICS WO" . 5138)
                             ("CANADIAN SYLLABICS WEST-CREE WO" . 5139)
                             ("CANADIAN SYLLABICS WOO" . 5140)
                             ("CANADIAN SYLLABICS WEST-CREE WOO" . 5141)
                             ("CANADIAN SYLLABICS NASKAPI WOO" . 5142)
                             ("CANADIAN SYLLABICS WA" . 5143)
                             ("CANADIAN SYLLABICS WEST-CREE WA" . 5144)
                             ("CANADIAN SYLLABICS WAA" . 5145)
                             ("CANADIAN SYLLABICS WEST-CREE WAA" . 5146)
                             ("CANADIAN SYLLABICS NASKAPI WAA" . 5147)
                             ("CANADIAN SYLLABICS AI" . 5148)
                             ("CANADIAN SYLLABICS Y-CREE W" . 5149)
                             ("CANADIAN SYLLABICS GLOTTAL STOP" . 5150)
                             ("CANADIAN SYLLABICS FINAL ACUTE" . 5151)
                             ("CANADIAN SYLLABICS FINAL GRAVE" . 5152)
                             ("CANADIAN SYLLABICS FINAL BOTTOM HALF RING" . 5153)
                             ("CANADIAN SYLLABICS FINAL TOP HALF RING" . 5154)
                             ("CANADIAN SYLLABICS FINAL RIGHT HALF RING" . 5155)
                             ("CANADIAN SYLLABICS FINAL RING" . 5156)
                             ("CANADIAN SYLLABICS FINAL DOUBLE ACUTE" . 5157)
                             ("CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES" . 5158)
                             ("CANADIAN SYLLABICS FINAL MIDDLE DOT" . 5159)
                             ("CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE" . 5160)
                             ("CANADIAN SYLLABICS FINAL PLUS" . 5161)
                             ("CANADIAN SYLLABICS FINAL DOWN TACK" . 5162)
                             ("CANADIAN SYLLABICS EN" . 5163)
                             ("CANADIAN SYLLABICS IN" . 5164)
                             ("CANADIAN SYLLABICS ON" . 5165)
                             ("CANADIAN SYLLABICS AN" . 5166)
                             ("CANADIAN SYLLABICS PE" . 5167)
                             ("CANADIAN SYLLABICS PAAI" . 5168)
                             ("CANADIAN SYLLABICS PI" . 5169)
                             ("CANADIAN SYLLABICS PII" . 5170)
                             ("CANADIAN SYLLABICS PO" . 5171)
                             ("CANADIAN SYLLABICS POO" . 5172)
                             ("CANADIAN SYLLABICS Y-CREE POO" . 5173)
                             ("CANADIAN SYLLABICS CARRIER HEE" . 5174)
                             ("CANADIAN SYLLABICS CARRIER HI" . 5175)
                             ("CANADIAN SYLLABICS PA" . 5176)
                             ("CANADIAN SYLLABICS PAA" . 5177)
                             ("CANADIAN SYLLABICS PWE" . 5178)
                             ("CANADIAN SYLLABICS WEST-CREE PWE" . 5179)
                             ("CANADIAN SYLLABICS PWI" . 5180)
                             ("CANADIAN SYLLABICS WEST-CREE PWI" . 5181)
                             ("CANADIAN SYLLABICS PWII" . 5182)
                             ("CANADIAN SYLLABICS WEST-CREE PWII" . 5183)
                             ("CANADIAN SYLLABICS PWO" . 5184)
                             ("CANADIAN SYLLABICS WEST-CREE PWO" . 5185)
                             ("CANADIAN SYLLABICS PWOO" . 5186)
                             ("CANADIAN SYLLABICS WEST-CREE PWOO" . 5187)
                             ("CANADIAN SYLLABICS PWA" . 5188)
                             ("CANADIAN SYLLABICS WEST-CREE PWA" . 5189)
                             ("CANADIAN SYLLABICS PWAA" . 5190)
                             ("CANADIAN SYLLABICS WEST-CREE PWAA" . 5191)
                             ("CANADIAN SYLLABICS Y-CREE PWAA" . 5192)
                             ("CANADIAN SYLLABICS P" . 5193)
                             ("CANADIAN SYLLABICS WEST-CREE P" . 5194)
                             ("CANADIAN SYLLABICS CARRIER H" . 5195)
                             ("CANADIAN SYLLABICS TE" . 5196)
                             ("CANADIAN SYLLABICS TAAI" . 5197)
                             ("CANADIAN SYLLABICS TI" . 5198)
                             ("CANADIAN SYLLABICS TII" . 5199)
                             ("CANADIAN SYLLABICS TO" . 5200)
                             ("CANADIAN SYLLABICS TOO" . 5201)
                             ("CANADIAN SYLLABICS Y-CREE TOO" . 5202)
                             ("CANADIAN SYLLABICS CARRIER DEE" . 5203)
                             ("CANADIAN SYLLABICS CARRIER DI" . 5204)
                             ("CANADIAN SYLLABICS TA" . 5205)
                             ("CANADIAN SYLLABICS TAA" . 5206)
                             ("CANADIAN SYLLABICS TWE" . 5207)
                             ("CANADIAN SYLLABICS WEST-CREE TWE" . 5208)
                             ("CANADIAN SYLLABICS TWI" . 5209)
                             ("CANADIAN SYLLABICS WEST-CREE TWI" . 5210)
                             ("CANADIAN SYLLABICS TWII" . 5211)
                             ("CANADIAN SYLLABICS WEST-CREE TWII" . 5212)
                             ("CANADIAN SYLLABICS TWO" . 5213)
                             ("CANADIAN SYLLABICS WEST-CREE TWO" . 5214)
                             ("CANADIAN SYLLABICS TWOO" . 5215)
                             ("CANADIAN SYLLABICS WEST-CREE TWOO" . 5216)
                             ("CANADIAN SYLLABICS TWA" . 5217)
                             ("CANADIAN SYLLABICS WEST-CREE TWA" . 5218)
                             ("CANADIAN SYLLABICS TWAA" . 5219)
                             ("CANADIAN SYLLABICS WEST-CREE TWAA" . 5220)
                             ("CANADIAN SYLLABICS NASKAPI TWAA" . 5221)
                             ("CANADIAN SYLLABICS T" . 5222)
                             ("CANADIAN SYLLABICS TTE" . 5223)
                             ("CANADIAN SYLLABICS TTI" . 5224)
                             ("CANADIAN SYLLABICS TTO" . 5225)
                             ("CANADIAN SYLLABICS TTA" . 5226)
                             ("CANADIAN SYLLABICS KE" . 5227)
                             ("CANADIAN SYLLABICS KAAI" . 5228)
                             ("CANADIAN SYLLABICS KI" . 5229)
                             ("CANADIAN SYLLABICS KII" . 5230)
                             ("CANADIAN SYLLABICS KO" . 5231)
                             ("CANADIAN SYLLABICS KOO" . 5232)
                             ("CANADIAN SYLLABICS Y-CREE KOO" . 5233)
                             ("CANADIAN SYLLABICS KA" . 5234)
                             ("CANADIAN SYLLABICS KAA" . 5235)
                             ("CANADIAN SYLLABICS KWE" . 5236)
                             ("CANADIAN SYLLABICS WEST-CREE KWE" . 5237)
                             ("CANADIAN SYLLABICS KWI" . 5238)
                             ("CANADIAN SYLLABICS WEST-CREE KWI" . 5239)
                             ("CANADIAN SYLLABICS KWII" . 5240)
                             ("CANADIAN SYLLABICS WEST-CREE KWII" . 5241)
                             ("CANADIAN SYLLABICS KWO" . 5242)
                             ("CANADIAN SYLLABICS WEST-CREE KWO" . 5243)
                             ("CANADIAN SYLLABICS KWOO" . 5244)
                             ("CANADIAN SYLLABICS WEST-CREE KWOO" . 5245)
                             ("CANADIAN SYLLABICS KWA" . 5246)
                             ("CANADIAN SYLLABICS WEST-CREE KWA" . 5247)
                             ("CANADIAN SYLLABICS KWAA" . 5248)
                             ("CANADIAN SYLLABICS WEST-CREE KWAA" . 5249)
                             ("CANADIAN SYLLABICS NASKAPI KWAA" . 5250)
                             ("CANADIAN SYLLABICS K" . 5251)
                             ("CANADIAN SYLLABICS KW" . 5252)
                             ("CANADIAN SYLLABICS SOUTH-SLAVEY KEH" . 5253)
                             ("CANADIAN SYLLABICS SOUTH-SLAVEY KIH" . 5254)
                             ("CANADIAN SYLLABICS SOUTH-SLAVEY KOH" . 5255)
                             ("CANADIAN SYLLABICS SOUTH-SLAVEY KAH" . 5256)
                             ("CANADIAN SYLLABICS CE" . 5257)
                             ("CANADIAN SYLLABICS CAAI" . 5258)
                             ("CANADIAN SYLLABICS CI" . 5259)
                             ("CANADIAN SYLLABICS CII" . 5260)
                             ("CANADIAN SYLLABICS CO" . 5261)
                             ("CANADIAN SYLLABICS COO" . 5262)
                             ("CANADIAN SYLLABICS Y-CREE COO" . 5263)
                             ("CANADIAN SYLLABICS CA" . 5264)
                             ("CANADIAN SYLLABICS CAA" . 5265)
                             ("CANADIAN SYLLABICS CWE" . 5266)
                             ("CANADIAN SYLLABICS WEST-CREE CWE" . 5267)
                             ("CANADIAN SYLLABICS CWI" . 5268)
                             ("CANADIAN SYLLABICS WEST-CREE CWI" . 5269)
                             ("CANADIAN SYLLABICS CWII" . 5270)
                             ("CANADIAN SYLLABICS WEST-CREE CWII" . 5271)
                             ("CANADIAN SYLLABICS CWO" . 5272)
                             ("CANADIAN SYLLABICS WEST-CREE CWO" . 5273)
                             ("CANADIAN SYLLABICS CWOO" . 5274)
                             ("CANADIAN SYLLABICS WEST-CREE CWOO" . 5275)
                             ("CANADIAN SYLLABICS CWA" . 5276)
                             ("CANADIAN SYLLABICS WEST-CREE CWA" . 5277)
                             ("CANADIAN SYLLABICS CWAA" . 5278)
                             ("CANADIAN SYLLABICS WEST-CREE CWAA" . 5279)
                             ("CANADIAN SYLLABICS NASKAPI CWAA" . 5280)
                             ("CANADIAN SYLLABICS C" . 5281)
                             ("CANADIAN SYLLABICS SAYISI TH" . 5282)
                             ("CANADIAN SYLLABICS ME" . 5283)
                             ("CANADIAN SYLLABICS MAAI" . 5284)
                             ("CANADIAN SYLLABICS MI" . 5285)
                             ("CANADIAN SYLLABICS MII" . 5286)
                             ("CANADIAN SYLLABICS MO" . 5287)
                             ("CANADIAN SYLLABICS MOO" . 5288)
                             ("CANADIAN SYLLABICS Y-CREE MOO" . 5289)
                             ("CANADIAN SYLLABICS MA" . 5290)
                             ("CANADIAN SYLLABICS MAA" . 5291)
                             ("CANADIAN SYLLABICS MWE" . 5292)
                             ("CANADIAN SYLLABICS WEST-CREE MWE" . 5293)
                             ("CANADIAN SYLLABICS MWI" . 5294)
                             ("CANADIAN SYLLABICS WEST-CREE MWI" . 5295)
                             ("CANADIAN SYLLABICS MWII" . 5296)
                             ("CANADIAN SYLLABICS WEST-CREE MWII" . 5297)
                             ("CANADIAN SYLLABICS MWO" . 5298)
                             ("CANADIAN SYLLABICS WEST-CREE MWO" . 5299)
                             ("CANADIAN SYLLABICS MWOO" . 5300)
                             ("CANADIAN SYLLABICS WEST-CREE MWOO" . 5301)
                             ("CANADIAN SYLLABICS MWA" . 5302)
                             ("CANADIAN SYLLABICS WEST-CREE MWA" . 5303)
                             ("CANADIAN SYLLABICS MWAA" . 5304)
                             ("CANADIAN SYLLABICS WEST-CREE MWAA" . 5305)
                             ("CANADIAN SYLLABICS NASKAPI MWAA" . 5306)
                             ("CANADIAN SYLLABICS M" . 5307)
                             ("CANADIAN SYLLABICS WEST-CREE M" . 5308)
                             ("CANADIAN SYLLABICS MH" . 5309)
                             ("CANADIAN SYLLABICS ATHAPASCAN M" . 5310)
                             ("CANADIAN SYLLABICS SAYISI M" . 5311)
                             ("CANADIAN SYLLABICS NE" . 5312)
                             ("CANADIAN SYLLABICS NAAI" . 5313)
                             ("CANADIAN SYLLABICS NI" . 5314)
                             ("CANADIAN SYLLABICS NII" . 5315)
                             ("CANADIAN SYLLABICS NO" . 5316)
                             ("CANADIAN SYLLABICS NOO" . 5317)
                             ("CANADIAN SYLLABICS Y-CREE NOO" . 5318)
                             ("CANADIAN SYLLABICS NA" . 5319)
                             ("CANADIAN SYLLABICS NAA" . 5320)
                             ("CANADIAN SYLLABICS NWE" . 5321)
                             ("CANADIAN SYLLABICS WEST-CREE NWE" . 5322)
                             ("CANADIAN SYLLABICS NWA" . 5323)
                             ("CANADIAN SYLLABICS WEST-CREE NWA" . 5324)
                             ("CANADIAN SYLLABICS NWAA" . 5325)
                             ("CANADIAN SYLLABICS WEST-CREE NWAA" . 5326)
                             ("CANADIAN SYLLABICS NASKAPI NWAA" . 5327)
                             ("CANADIAN SYLLABICS N" . 5328)
                             ("CANADIAN SYLLABICS CARRIER NG" . 5329)
                             ("CANADIAN SYLLABICS NH" . 5330)
                             ("CANADIAN SYLLABICS LE" . 5331)
                             ("CANADIAN SYLLABICS LAAI" . 5332)
                             ("CANADIAN SYLLABICS LI" . 5333)
                             ("CANADIAN SYLLABICS LII" . 5334)
                             ("CANADIAN SYLLABICS LO" . 5335)
                             ("CANADIAN SYLLABICS LOO" . 5336)
                             ("CANADIAN SYLLABICS Y-CREE LOO" . 5337)
                             ("CANADIAN SYLLABICS LA" . 5338)
                             ("CANADIAN SYLLABICS LAA" . 5339)
                             ("CANADIAN SYLLABICS LWE" . 5340)
                             ("CANADIAN SYLLABICS WEST-CREE LWE" . 5341)
                             ("CANADIAN SYLLABICS LWI" . 5342)
                             ("CANADIAN SYLLABICS WEST-CREE LWI" . 5343)
                             ("CANADIAN SYLLABICS LWII" . 5344)
                             ("CANADIAN SYLLABICS WEST-CREE LWII" . 5345)
                             ("CANADIAN SYLLABICS LWO" . 5346)
                             ("CANADIAN SYLLABICS WEST-CREE LWO" . 5347)
                             ("CANADIAN SYLLABICS LWOO" . 5348)
                             ("CANADIAN SYLLABICS WEST-CREE LWOO" . 5349)
                             ("CANADIAN SYLLABICS LWA" . 5350)
                             ("CANADIAN SYLLABICS WEST-CREE LWA" . 5351)
                             ("CANADIAN SYLLABICS LWAA" . 5352)
                             ("CANADIAN SYLLABICS WEST-CREE LWAA" . 5353)
                             ("CANADIAN SYLLABICS L" . 5354)
                             ("CANADIAN SYLLABICS WEST-CREE L" . 5355)
                             ("CANADIAN SYLLABICS MEDIAL L" . 5356)
                             ("CANADIAN SYLLABICS SE" . 5357)
                             ("CANADIAN SYLLABICS SAAI" . 5358)
                             ("CANADIAN SYLLABICS SI" . 5359)
                             ("CANADIAN SYLLABICS SII" . 5360)
                             ("CANADIAN SYLLABICS SO" . 5361)
                             ("CANADIAN SYLLABICS SOO" . 5362)
                             ("CANADIAN SYLLABICS Y-CREE SOO" . 5363)
                             ("CANADIAN SYLLABICS SA" . 5364)
                             ("CANADIAN SYLLABICS SAA" . 5365)
                             ("CANADIAN SYLLABICS SWE" . 5366)
                             ("CANADIAN SYLLABICS WEST-CREE SWE" . 5367)
                             ("CANADIAN SYLLABICS SWI" . 5368)
                             ("CANADIAN SYLLABICS WEST-CREE SWI" . 5369)
                             ("CANADIAN SYLLABICS SWII" . 5370)
                             ("CANADIAN SYLLABICS WEST-CREE SWII" . 5371)
                             ("CANADIAN SYLLABICS SWO" . 5372)
                             ("CANADIAN SYLLABICS WEST-CREE SWO" . 5373)
                             ("CANADIAN SYLLABICS SWOO" . 5374)
                             ("CANADIAN SYLLABICS WEST-CREE SWOO" . 5375)
                             ("CANADIAN SYLLABICS SWA" . 5376)
                             ("CANADIAN SYLLABICS WEST-CREE SWA" . 5377)
                             ("CANADIAN SYLLABICS SWAA" . 5378)
                             ("CANADIAN SYLLABICS WEST-CREE SWAA" . 5379)
                             ("CANADIAN SYLLABICS NASKAPI SWAA" . 5380)
                             ("CANADIAN SYLLABICS S" . 5381)
                             ("CANADIAN SYLLABICS ATHAPASCAN S" . 5382)
                             ("CANADIAN SYLLABICS SW" . 5383)
                             ("CANADIAN SYLLABICS BLACKFOOT S" . 5384)
                             ("CANADIAN SYLLABICS MOOSE-CREE SK" . 5385)
                             ("CANADIAN SYLLABICS NASKAPI SKW" . 5386)
                             ("CANADIAN SYLLABICS NASKAPI S-W" . 5387)
                             ("CANADIAN SYLLABICS NASKAPI SPWA" . 5388)
                             ("CANADIAN SYLLABICS NASKAPI STWA" . 5389)
                             ("CANADIAN SYLLABICS NASKAPI SKWA" . 5390)
                             ("CANADIAN SYLLABICS NASKAPI SCWA" . 5391)
                             ("CANADIAN SYLLABICS SHE" . 5392)
                             ("CANADIAN SYLLABICS SHI" . 5393)
                             ("CANADIAN SYLLABICS SHII" . 5394)
                             ("CANADIAN SYLLABICS SHO" . 5395)
                             ("CANADIAN SYLLABICS SHOO" . 5396)
                             ("CANADIAN SYLLABICS SHA" . 5397)
                             ("CANADIAN SYLLABICS SHAA" . 5398)
                             ("CANADIAN SYLLABICS SHWE" . 5399)
                             ("CANADIAN SYLLABICS WEST-CREE SHWE" . 5400)
                             ("CANADIAN SYLLABICS SHWI" . 5401)
                             ("CANADIAN SYLLABICS WEST-CREE SHWI" . 5402)
                             ("CANADIAN SYLLABICS SHWII" . 5403)
                             ("CANADIAN SYLLABICS WEST-CREE SHWII" . 5404)
                             ("CANADIAN SYLLABICS SHWO" . 5405)
                             ("CANADIAN SYLLABICS WEST-CREE SHWO" . 5406)
                             ("CANADIAN SYLLABICS SHWOO" . 5407)
                             ("CANADIAN SYLLABICS WEST-CREE SHWOO" . 5408)
                             ("CANADIAN SYLLABICS SHWA" . 5409)
                             ("CANADIAN SYLLABICS WEST-CREE SHWA" . 5410)
                             ("CANADIAN SYLLABICS SHWAA" . 5411)
                             ("CANADIAN SYLLABICS WEST-CREE SHWAA" . 5412)
                             ("CANADIAN SYLLABICS SH" . 5413)
                             ("CANADIAN SYLLABICS YE" . 5414)
                             ("CANADIAN SYLLABICS YAAI" . 5415)
                             ("CANADIAN SYLLABICS YI" . 5416)
                             ("CANADIAN SYLLABICS YII" . 5417)
                             ("CANADIAN SYLLABICS YO" . 5418)
                             ("CANADIAN SYLLABICS YOO" . 5419)
                             ("CANADIAN SYLLABICS Y-CREE YOO" . 5420)
                             ("CANADIAN SYLLABICS YA" . 5421)
                             ("CANADIAN SYLLABICS YAA" . 5422)
                             ("CANADIAN SYLLABICS YWE" . 5423)
                             ("CANADIAN SYLLABICS WEST-CREE YWE" . 5424)
                             ("CANADIAN SYLLABICS YWI" . 5425)
                             ("CANADIAN SYLLABICS WEST-CREE YWI" . 5426)
                             ("CANADIAN SYLLABICS YWII" . 5427)
                             ("CANADIAN SYLLABICS WEST-CREE YWII" . 5428)
                             ("CANADIAN SYLLABICS YWO" . 5429)
                             ("CANADIAN SYLLABICS WEST-CREE YWO" . 5430)
                             ("CANADIAN SYLLABICS YWOO" . 5431)
                             ("CANADIAN SYLLABICS WEST-CREE YWOO" . 5432)
                             ("CANADIAN SYLLABICS YWA" . 5433)
                             ("CANADIAN SYLLABICS WEST-CREE YWA" . 5434)
                             ("CANADIAN SYLLABICS YWAA" . 5435)
                             ("CANADIAN SYLLABICS WEST-CREE YWAA" . 5436)
                             ("CANADIAN SYLLABICS NASKAPI YWAA" . 5437)
                             ("CANADIAN SYLLABICS Y" . 5438)
                             ("CANADIAN SYLLABICS BIBLE-CREE Y" . 5439)
                             ("CANADIAN SYLLABICS WEST-CREE Y" . 5440)
                             ("CANADIAN SYLLABICS SAYISI YI" . 5441)
                             ("CANADIAN SYLLABICS RE" . 5442)
                             ("CANADIAN SYLLABICS R-CREE RE" . 5443)
                             ("CANADIAN SYLLABICS WEST-CREE LE" . 5444)
                             ("CANADIAN SYLLABICS RAAI" . 5445)
                             ("CANADIAN SYLLABICS RI" . 5446)
                             ("CANADIAN SYLLABICS RII" . 5447)
                             ("CANADIAN SYLLABICS RO" . 5448)
                             ("CANADIAN SYLLABICS ROO" . 5449)
                             ("CANADIAN SYLLABICS WEST-CREE LO" . 5450)
                             ("CANADIAN SYLLABICS RA" . 5451)
                             ("CANADIAN SYLLABICS RAA" . 5452)
                             ("CANADIAN SYLLABICS WEST-CREE LA" . 5453)
                             ("CANADIAN SYLLABICS RWAA" . 5454)
                             ("CANADIAN SYLLABICS WEST-CREE RWAA" . 5455)
                             ("CANADIAN SYLLABICS R" . 5456)
                             ("CANADIAN SYLLABICS WEST-CREE R" . 5457)
                             ("CANADIAN SYLLABICS MEDIAL R" . 5458)
                             ("CANADIAN SYLLABICS FE" . 5459)
                             ("CANADIAN SYLLABICS FAAI" . 5460)
                             ("CANADIAN SYLLABICS FI" . 5461)
                             ("CANADIAN SYLLABICS FII" . 5462)
                             ("CANADIAN SYLLABICS FO" . 5463)
                             ("CANADIAN SYLLABICS FOO" . 5464)
                             ("CANADIAN SYLLABICS FA" . 5465)
                             ("CANADIAN SYLLABICS FAA" . 5466)
                             ("CANADIAN SYLLABICS FWAA" . 5467)
                             ("CANADIAN SYLLABICS WEST-CREE FWAA" . 5468)
                             ("CANADIAN SYLLABICS F" . 5469)
                             ("CANADIAN SYLLABICS THE" . 5470)
                             ("CANADIAN SYLLABICS N-CREE THE" . 5471)
                             ("CANADIAN SYLLABICS THI" . 5472)
                             ("CANADIAN SYLLABICS N-CREE THI" . 5473)
                             ("CANADIAN SYLLABICS THII" . 5474)
                             ("CANADIAN SYLLABICS N-CREE THII" . 5475)
                             ("CANADIAN SYLLABICS THO" . 5476)
                             ("CANADIAN SYLLABICS THOO" . 5477)
                             ("CANADIAN SYLLABICS THA" . 5478)
                             ("CANADIAN SYLLABICS THAA" . 5479)
                             ("CANADIAN SYLLABICS THWAA" . 5480)
                             ("CANADIAN SYLLABICS WEST-CREE THWAA" . 5481)
                             ("CANADIAN SYLLABICS TH" . 5482)
                             ("CANADIAN SYLLABICS TTHE" . 5483)
                             ("CANADIAN SYLLABICS TTHI" . 5484)
                             ("CANADIAN SYLLABICS TTHO" . 5485)
                             ("CANADIAN SYLLABICS TTHA" . 5486)
                             ("CANADIAN SYLLABICS TTH" . 5487)
                             ("CANADIAN SYLLABICS TYE" . 5488)
                             ("CANADIAN SYLLABICS TYI" . 5489)
                             ("CANADIAN SYLLABICS TYO" . 5490)
                             ("CANADIAN SYLLABICS TYA" . 5491)
                             ("CANADIAN SYLLABICS NUNAVIK HE" . 5492)
                             ("CANADIAN SYLLABICS NUNAVIK HI" . 5493)
                             ("CANADIAN SYLLABICS NUNAVIK HII" . 5494)
                             ("CANADIAN SYLLABICS NUNAVIK HO" . 5495)
                             ("CANADIAN SYLLABICS NUNAVIK HOO" . 5496)
                             ("CANADIAN SYLLABICS NUNAVIK HA" . 5497)
                             ("CANADIAN SYLLABICS NUNAVIK HAA" . 5498)
                             ("CANADIAN SYLLABICS NUNAVIK H" . 5499)
                             ("CANADIAN SYLLABICS NUNAVUT H" . 5500)
                             ("CANADIAN SYLLABICS HK" . 5501)
                             ("CANADIAN SYLLABICS QAAI" . 5502)
                             ("CANADIAN SYLLABICS QI" . 5503)
                             ("CANADIAN SYLLABICS QII" . 5504)
                             ("CANADIAN SYLLABICS QO" . 5505)
                             ("CANADIAN SYLLABICS QOO" . 5506)
                             ("CANADIAN SYLLABICS QA" . 5507)
                             ("CANADIAN SYLLABICS QAA" . 5508)
                             ("CANADIAN SYLLABICS Q" . 5509)
                             ("CANADIAN SYLLABICS TLHE" . 5510)
                             ("CANADIAN SYLLABICS TLHI" . 5511)
                             ("CANADIAN SYLLABICS TLHO" . 5512)
                             ("CANADIAN SYLLABICS TLHA" . 5513)
                             ("CANADIAN SYLLABICS WEST-CREE RE" . 5514)
                             ("CANADIAN SYLLABICS WEST-CREE RI" . 5515)
                             ("CANADIAN SYLLABICS WEST-CREE RO" . 5516)
                             ("CANADIAN SYLLABICS WEST-CREE RA" . 5517)
                             ("CANADIAN SYLLABICS NGAAI" . 5518)
                             ("CANADIAN SYLLABICS NGI" . 5519)
                             ("CANADIAN SYLLABICS NGII" . 5520)
                             ("CANADIAN SYLLABICS NGO" . 5521)
                             ("CANADIAN SYLLABICS NGOO" . 5522)
                             ("CANADIAN SYLLABICS NGA" . 5523)
                             ("CANADIAN SYLLABICS NGAA" . 5524)
                             ("CANADIAN SYLLABICS NG" . 5525)
                             ("CANADIAN SYLLABICS NNG" . 5526)
                             ("CANADIAN SYLLABICS SAYISI SHE" . 5527)
                             ("CANADIAN SYLLABICS SAYISI SHI" . 5528)
                             ("CANADIAN SYLLABICS SAYISI SHO" . 5529)
                             ("CANADIAN SYLLABICS SAYISI SHA" . 5530)
                             ("CANADIAN SYLLABICS WOODS-CREE THE" . 5531)
                             ("CANADIAN SYLLABICS WOODS-CREE THI" . 5532)
                             ("CANADIAN SYLLABICS WOODS-CREE THO" . 5533)
                             ("CANADIAN SYLLABICS WOODS-CREE THA" . 5534)
                             ("CANADIAN SYLLABICS WOODS-CREE TH" . 5535)
                             ("CANADIAN SYLLABICS LHI" . 5536)
                             ("CANADIAN SYLLABICS LHII" . 5537)
                             ("CANADIAN SYLLABICS LHO" . 5538)
                             ("CANADIAN SYLLABICS LHOO" . 5539)
                             ("CANADIAN SYLLABICS LHA" . 5540)
                             ("CANADIAN SYLLABICS LHAA" . 5541)
                             ("CANADIAN SYLLABICS LH" . 5542)
                             ("CANADIAN SYLLABICS TH-CREE THE" . 5543)
                             ("CANADIAN SYLLABICS TH-CREE THI" . 5544)
                             ("CANADIAN SYLLABICS TH-CREE THII" . 5545)
                             ("CANADIAN SYLLABICS TH-CREE THO" . 5546)
                             ("CANADIAN SYLLABICS TH-CREE THOO" . 5547)
                             ("CANADIAN SYLLABICS TH-CREE THA" . 5548)
                             ("CANADIAN SYLLABICS TH-CREE THAA" . 5549)
                             ("CANADIAN SYLLABICS TH-CREE TH" . 5550)
                             ("CANADIAN SYLLABICS AIVILIK B" . 5551)
                             ("CANADIAN SYLLABICS BLACKFOOT E" . 5552)
                             ("CANADIAN SYLLABICS BLACKFOOT I" . 5553)
                             ("CANADIAN SYLLABICS BLACKFOOT O" . 5554)
                             ("CANADIAN SYLLABICS BLACKFOOT A" . 5555)
                             ("CANADIAN SYLLABICS BLACKFOOT WE" . 5556)
                             ("CANADIAN SYLLABICS BLACKFOOT WI" . 5557)
                             ("CANADIAN SYLLABICS BLACKFOOT WO" . 5558)
                             ("CANADIAN SYLLABICS BLACKFOOT WA" . 5559)
                             ("CANADIAN SYLLABICS BLACKFOOT NE" . 5560)
                             ("CANADIAN SYLLABICS BLACKFOOT NI" . 5561)
                             ("CANADIAN SYLLABICS BLACKFOOT NO" . 5562)
                             ("CANADIAN SYLLABICS BLACKFOOT NA" . 5563)
                             ("CANADIAN SYLLABICS BLACKFOOT KE" . 5564)
                             ("CANADIAN SYLLABICS BLACKFOOT KI" . 5565)
                             ("CANADIAN SYLLABICS BLACKFOOT KO" . 5566)
                             ("CANADIAN SYLLABICS BLACKFOOT KA" . 5567)
                             ("CANADIAN SYLLABICS SAYISI HE" . 5568)
                             ("CANADIAN SYLLABICS SAYISI HI" . 5569)
                             ("CANADIAN SYLLABICS SAYISI HO" . 5570)
                             ("CANADIAN SYLLABICS SAYISI HA" . 5571)
                             ("CANADIAN SYLLABICS CARRIER GHU" . 5572)
                             ("CANADIAN SYLLABICS CARRIER GHO" . 5573)
                             ("CANADIAN SYLLABICS CARRIER GHE" . 5574)
                             ("CANADIAN SYLLABICS CARRIER GHEE" . 5575)
                             ("CANADIAN SYLLABICS CARRIER GHI" . 5576)
                             ("CANADIAN SYLLABICS CARRIER GHA" . 5577)
                             ("CANADIAN SYLLABICS CARRIER RU" . 5578)
                             ("CANADIAN SYLLABICS CARRIER RO" . 5579)
                             ("CANADIAN SYLLABICS CARRIER RE" . 5580)
                             ("CANADIAN SYLLABICS CARRIER REE" . 5581)
                             ("CANADIAN SYLLABICS CARRIER RI" . 5582)
                             ("CANADIAN SYLLABICS CARRIER RA" . 5583)
                             ("CANADIAN SYLLABICS CARRIER WU" . 5584)
                             ("CANADIAN SYLLABICS CARRIER WO" . 5585)
                             ("CANADIAN SYLLABICS CARRIER WE" . 5586)
                             ("CANADIAN SYLLABICS CARRIER WEE" . 5587)
                             ("CANADIAN SYLLABICS CARRIER WI" . 5588)
                             ("CANADIAN SYLLABICS CARRIER WA" . 5589)
                             ("CANADIAN SYLLABICS CARRIER HWU" . 5590)
                             ("CANADIAN SYLLABICS CARRIER HWO" . 5591)
                             ("CANADIAN SYLLABICS CARRIER HWE" . 5592)
                             ("CANADIAN SYLLABICS CARRIER HWEE" . 5593)
                             ("CANADIAN SYLLABICS CARRIER HWI" . 5594)
                             ("CANADIAN SYLLABICS CARRIER HWA" . 5595)
                             ("CANADIAN SYLLABICS CARRIER THU" . 5596)
                             ("CANADIAN SYLLABICS CARRIER THO" . 5597)
                             ("CANADIAN SYLLABICS CARRIER THE" . 5598)
                             ("CANADIAN SYLLABICS CARRIER THEE" . 5599)
                             ("CANADIAN SYLLABICS CARRIER THI" . 5600)
                             ("CANADIAN SYLLABICS CARRIER THA" . 5601)
                             ("CANADIAN SYLLABICS CARRIER TTU" . 5602)
                             ("CANADIAN SYLLABICS CARRIER TTO" . 5603)
                             ("CANADIAN SYLLABICS CARRIER TTE" . 5604)
                             ("CANADIAN SYLLABICS CARRIER TTEE" . 5605)
                             ("CANADIAN SYLLABICS CARRIER TTI" . 5606)
                             ("CANADIAN SYLLABICS CARRIER TTA" . 5607)
                             ("CANADIAN SYLLABICS CARRIER PU" . 5608)
                             ("CANADIAN SYLLABICS CARRIER PO" . 5609)
                             ("CANADIAN SYLLABICS CARRIER PE" . 5610)
                             ("CANADIAN SYLLABICS CARRIER PEE" . 5611)
                             ("CANADIAN SYLLABICS CARRIER PI" . 5612)
                             ("CANADIAN SYLLABICS CARRIER PA" . 5613)
                             ("CANADIAN SYLLABICS CARRIER P" . 5614)
                             ("CANADIAN SYLLABICS CARRIER GU" . 5615)
                             ("CANADIAN SYLLABICS CARRIER GO" . 5616)
                             ("CANADIAN SYLLABICS CARRIER GE" . 5617)
                             ("CANADIAN SYLLABICS CARRIER GEE" . 5618)
                             ("CANADIAN SYLLABICS CARRIER GI" . 5619)
                             ("CANADIAN SYLLABICS CARRIER GA" . 5620)
                             ("CANADIAN SYLLABICS CARRIER KHU" . 5621)
                             ("CANADIAN SYLLABICS CARRIER KHO" . 5622)
                             ("CANADIAN SYLLABICS CARRIER KHE" . 5623)
                             ("CANADIAN SYLLABICS CARRIER KHEE" . 5624)
                             ("CANADIAN SYLLABICS CARRIER KHI" . 5625)
                             ("CANADIAN SYLLABICS CARRIER KHA" . 5626)
                             ("CANADIAN SYLLABICS CARRIER KKU" . 5627)
                             ("CANADIAN SYLLABICS CARRIER KKO" . 5628)
                             ("CANADIAN SYLLABICS CARRIER KKE" . 5629)
                             ("CANADIAN SYLLABICS CARRIER KKEE" . 5630)
                             ("CANADIAN SYLLABICS CARRIER KKI" . 5631)
                             ("CANADIAN SYLLABICS CARRIER KKA" . 5632)
                             ("CANADIAN SYLLABICS CARRIER KK" . 5633)
                             ("CANADIAN SYLLABICS CARRIER NU" . 5634)
                             ("CANADIAN SYLLABICS CARRIER NO" . 5635)
                             ("CANADIAN SYLLABICS CARRIER NE" . 5636)
                             ("CANADIAN SYLLABICS CARRIER NEE" . 5637)
                             ("CANADIAN SYLLABICS CARRIER NI" . 5638)
                             ("CANADIAN SYLLABICS CARRIER NA" . 5639)
                             ("CANADIAN SYLLABICS CARRIER MU" . 5640)
                             ("CANADIAN SYLLABICS CARRIER MO" . 5641)
                             ("CANADIAN SYLLABICS CARRIER ME" . 5642)
                             ("CANADIAN SYLLABICS CARRIER MEE" . 5643)
                             ("CANADIAN SYLLABICS CARRIER MI" . 5644)
                             ("CANADIAN SYLLABICS CARRIER MA" . 5645)
                             ("CANADIAN SYLLABICS CARRIER YU" . 5646)
                             ("CANADIAN SYLLABICS CARRIER YO" . 5647)
                             ("CANADIAN SYLLABICS CARRIER YE" . 5648)
                             ("CANADIAN SYLLABICS CARRIER YEE" . 5649)
                             ("CANADIAN SYLLABICS CARRIER YI" . 5650)
                             ("CANADIAN SYLLABICS CARRIER YA" . 5651)
                             ("CANADIAN SYLLABICS CARRIER JU" . 5652)
                             ("CANADIAN SYLLABICS SAYISI JU" . 5653)
                             ("CANADIAN SYLLABICS CARRIER JO" . 5654)
                             ("CANADIAN SYLLABICS CARRIER JE" . 5655)
                             ("CANADIAN SYLLABICS CARRIER JEE" . 5656)
                             ("CANADIAN SYLLABICS CARRIER JI" . 5657)
                             ("CANADIAN SYLLABICS SAYISI JI" . 5658)
                             ("CANADIAN SYLLABICS CARRIER JA" . 5659)
                             ("CANADIAN SYLLABICS CARRIER JJU" . 5660)
                             ("CANADIAN SYLLABICS CARRIER JJO" . 5661)
                             ("CANADIAN SYLLABICS CARRIER JJE" . 5662)
                             ("CANADIAN SYLLABICS CARRIER JJEE" . 5663)
                             ("CANADIAN SYLLABICS CARRIER JJI" . 5664)
                             ("CANADIAN SYLLABICS CARRIER JJA" . 5665)
                             ("CANADIAN SYLLABICS CARRIER LU" . 5666)
                             ("CANADIAN SYLLABICS CARRIER LO" . 5667)
                             ("CANADIAN SYLLABICS CARRIER LE" . 5668)
                             ("CANADIAN SYLLABICS CARRIER LEE" . 5669)
                             ("CANADIAN SYLLABICS CARRIER LI" . 5670)
                             ("CANADIAN SYLLABICS CARRIER LA" . 5671)
                             ("CANADIAN SYLLABICS CARRIER DLU" . 5672)
                             ("CANADIAN SYLLABICS CARRIER DLO" . 5673)
                             ("CANADIAN SYLLABICS CARRIER DLE" . 5674)
                             ("CANADIAN SYLLABICS CARRIER DLEE" . 5675)
                             ("CANADIAN SYLLABICS CARRIER DLI" . 5676)
                             ("CANADIAN SYLLABICS CARRIER DLA" . 5677)
                             ("CANADIAN SYLLABICS CARRIER LHU" . 5678)
                             ("CANADIAN SYLLABICS CARRIER LHO" . 5679)
                             ("CANADIAN SYLLABICS CARRIER LHE" . 5680)
                             ("CANADIAN SYLLABICS CARRIER LHEE" . 5681)
                             ("CANADIAN SYLLABICS CARRIER LHI" . 5682)
                             ("CANADIAN SYLLABICS CARRIER LHA" . 5683)
                             ("CANADIAN SYLLABICS CARRIER TLHU" . 5684)
                             ("CANADIAN SYLLABICS CARRIER TLHO" . 5685)
                             ("CANADIAN SYLLABICS CARRIER TLHE" . 5686)
                             ("CANADIAN SYLLABICS CARRIER TLHEE" . 5687)
                             ("CANADIAN SYLLABICS CARRIER TLHI" . 5688)
                             ("CANADIAN SYLLABICS CARRIER TLHA" . 5689)
                             ("CANADIAN SYLLABICS CARRIER TLU" . 5690)
                             ("CANADIAN SYLLABICS CARRIER TLO" . 5691)
                             ("CANADIAN SYLLABICS CARRIER TLE" . 5692)
                             ("CANADIAN SYLLABICS CARRIER TLEE" . 5693)
                             ("CANADIAN SYLLABICS CARRIER TLI" . 5694)
                             ("CANADIAN SYLLABICS CARRIER TLA" . 5695)
                             ("CANADIAN SYLLABICS CARRIER ZU" . 5696)
                             ("CANADIAN SYLLABICS CARRIER ZO" . 5697)
                             ("CANADIAN SYLLABICS CARRIER ZE" . 5698)
                             ("CANADIAN SYLLABICS CARRIER ZEE" . 5699)
                             ("CANADIAN SYLLABICS CARRIER ZI" . 5700)
                             ("CANADIAN SYLLABICS CARRIER ZA" . 5701)
                             ("CANADIAN SYLLABICS CARRIER Z" . 5702)
                             ("CANADIAN SYLLABICS CARRIER INITIAL Z" . 5703)
                             ("CANADIAN SYLLABICS CARRIER DZU" . 5704)
                             ("CANADIAN SYLLABICS CARRIER DZO" . 5705)
                             ("CANADIAN SYLLABICS CARRIER DZE" . 5706)
                             ("CANADIAN SYLLABICS CARRIER DZEE" . 5707)
                             ("CANADIAN SYLLABICS CARRIER DZI" . 5708)
                             ("CANADIAN SYLLABICS CARRIER DZA" . 5709)
                             ("CANADIAN SYLLABICS CARRIER SU" . 5710)
                             ("CANADIAN SYLLABICS CARRIER SO" . 5711)
                             ("CANADIAN SYLLABICS CARRIER SE" . 5712)
                             ("CANADIAN SYLLABICS CARRIER SEE" . 5713)
                             ("CANADIAN SYLLABICS CARRIER SI" . 5714)
                             ("CANADIAN SYLLABICS CARRIER SA" . 5715)
                             ("CANADIAN SYLLABICS CARRIER SHU" . 5716)
                             ("CANADIAN SYLLABICS CARRIER SHO" . 5717)
                             ("CANADIAN SYLLABICS CARRIER SHE" . 5718)
                             ("CANADIAN SYLLABICS CARRIER SHEE" . 5719)
                             ("CANADIAN SYLLABICS CARRIER SHI" . 5720)
                             ("CANADIAN SYLLABICS CARRIER SHA" . 5721)
                             ("CANADIAN SYLLABICS CARRIER SH" . 5722)
                             ("CANADIAN SYLLABICS CARRIER TSU" . 5723)
                             ("CANADIAN SYLLABICS CARRIER TSO" . 5724)
                             ("CANADIAN SYLLABICS CARRIER TSE" . 5725)
                             ("CANADIAN SYLLABICS CARRIER TSEE" . 5726)
                             ("CANADIAN SYLLABICS CARRIER TSI" . 5727)
                             ("CANADIAN SYLLABICS CARRIER TSA" . 5728)
                             ("CANADIAN SYLLABICS CARRIER CHU" . 5729)
                             ("CANADIAN SYLLABICS CARRIER CHO" . 5730)
                             ("CANADIAN SYLLABICS CARRIER CHE" . 5731)
                             ("CANADIAN SYLLABICS CARRIER CHEE" . 5732)
                             ("CANADIAN SYLLABICS CARRIER CHI" . 5733)
                             ("CANADIAN SYLLABICS CARRIER CHA" . 5734)
                             ("CANADIAN SYLLABICS CARRIER TTSU" . 5735)
                             ("CANADIAN SYLLABICS CARRIER TTSO" . 5736)
                             ("CANADIAN SYLLABICS CARRIER TTSE" . 5737)
                             ("CANADIAN SYLLABICS CARRIER TTSEE" . 5738)
                             ("CANADIAN SYLLABICS CARRIER TTSI" . 5739)
                             ("CANADIAN SYLLABICS CARRIER TTSA" . 5740)
                             ("CANADIAN SYLLABICS CHI SIGN" . 5741)
                             ("CANADIAN SYLLABICS FULL STOP" . 5742)
                             ("CANADIAN SYLLABICS QAI" . 5743)
                             ("CANADIAN SYLLABICS NGAI" . 5744)
                             ("CANADIAN SYLLABICS NNGI" . 5745)
                             ("CANADIAN SYLLABICS NNGII" . 5746)
                             ("CANADIAN SYLLABICS NNGO" . 5747)
                             ("CANADIAN SYLLABICS NNGOO" . 5748)
                             ("CANADIAN SYLLABICS NNGA" . 5749)
                             ("CANADIAN SYLLABICS NNGAA" . 5750)
                             ("OGHAM SPACE MARK" . 5760)
                             ("OGHAM LETTER BEITH" . 5761)
                             ("OGHAM LETTER LUIS" . 5762)
                             ("OGHAM LETTER FEARN" . 5763)
                             ("OGHAM LETTER SAIL" . 5764)
                             ("OGHAM LETTER NION" . 5765)
                             ("OGHAM LETTER UATH" . 5766)
                             ("OGHAM LETTER DAIR" . 5767)
                             ("OGHAM LETTER TINNE" . 5768)
                             ("OGHAM LETTER COLL" . 5769)
                             ("OGHAM LETTER CEIRT" . 5770)
                             ("OGHAM LETTER MUIN" . 5771)
                             ("OGHAM LETTER GORT" . 5772)
                             ("OGHAM LETTER NGEADAL" . 5773)
                             ("OGHAM LETTER STRAIF" . 5774)
                             ("OGHAM LETTER RUIS" . 5775)
                             ("OGHAM LETTER AILM" . 5776)
                             ("OGHAM LETTER ONN" . 5777)
                             ("OGHAM LETTER UR" . 5778)
                             ("OGHAM LETTER EADHADH" . 5779)
                             ("OGHAM LETTER IODHADH" . 5780)
                             ("OGHAM LETTER EABHADH" . 5781)
                             ("OGHAM LETTER OR" . 5782)
                             ("OGHAM LETTER UILLEANN" . 5783)
                             ("OGHAM LETTER IFIN" . 5784)
                             ("OGHAM LETTER EAMHANCHOLL" . 5785)
                             ("OGHAM LETTER PEITH" . 5786)
                             ("OGHAM FEATHER MARK" . 5787)
                             ("OGHAM REVERSED FEATHER MARK" . 5788)
                             ("RUNIC LETTER FEHU FEOH FE F" . 5792)
                             ("RUNIC LETTER V" . 5793)
                             ("RUNIC LETTER URUZ UR U" . 5794)
                             ("RUNIC LETTER YR" . 5795)
                             ("RUNIC LETTER Y" . 5796)
                             ("RUNIC LETTER W" . 5797)
                             ("RUNIC LETTER THURISAZ THURS THORN" . 5798)
                             ("RUNIC LETTER ETH" . 5799)
                             ("RUNIC LETTER ANSUZ A" . 5800)
                             ("RUNIC LETTER OS O" . 5801)
                             ("RUNIC LETTER AC A" . 5802)
                             ("RUNIC LETTER AESC" . 5803)
                             ("RUNIC LETTER LONG-BRANCH-OSS O" . 5804)
                             ("RUNIC LETTER SHORT-TWIG-OSS O" . 5805)
                             ("RUNIC LETTER O" . 5806)
                             ("RUNIC LETTER OE" . 5807)
                             ("RUNIC LETTER ON" . 5808)
                             ("RUNIC LETTER RAIDO RAD REID R" . 5809)
                             ("RUNIC LETTER KAUNA" . 5810)
                             ("RUNIC LETTER CEN" . 5811)
                             ("RUNIC LETTER KAUN K" . 5812)
                             ("RUNIC LETTER G" . 5813)
                             ("RUNIC LETTER ENG" . 5814)
                             ("RUNIC LETTER GEBO GYFU G" . 5815)
                             ("RUNIC LETTER GAR" . 5816)
                             ("RUNIC LETTER WUNJO WYNN W" . 5817)
                             ("RUNIC LETTER HAGLAZ H" . 5818)
                             ("RUNIC LETTER HAEGL H" . 5819)
                             ("RUNIC LETTER LONG-BRANCH-HAGALL H" . 5820)
                             ("RUNIC LETTER SHORT-TWIG-HAGALL H" . 5821)
                             ("RUNIC LETTER NAUDIZ NYD NAUD N" . 5822)
                             ("RUNIC LETTER SHORT-TWIG-NAUD N" . 5823)
                             ("RUNIC LETTER DOTTED-N" . 5824)
                             ("RUNIC LETTER ISAZ IS ISS I" . 5825)
                             ("RUNIC LETTER E" . 5826)
                             ("RUNIC LETTER JERAN J" . 5827)
                             ("RUNIC LETTER GER" . 5828)
                             ("RUNIC LETTER LONG-BRANCH-AR AE" . 5829)
                             ("RUNIC LETTER SHORT-TWIG-AR A" . 5830)
                             ("RUNIC LETTER IWAZ EOH" . 5831)
                             ("RUNIC LETTER PERTHO PEORTH P" . 5832)
                             ("RUNIC LETTER ALGIZ EOLHX" . 5833)
                             ("RUNIC LETTER SOWILO S" . 5834)
                             ("RUNIC LETTER SIGEL LONG-BRANCH-SOL S" . 5835)
                             ("RUNIC LETTER SHORT-TWIG-SOL S" . 5836)
                             ("RUNIC LETTER C" . 5837)
                             ("RUNIC LETTER Z" . 5838)
                             ("RUNIC LETTER TIWAZ TIR TYR T" . 5839)
                             ("RUNIC LETTER SHORT-TWIG-TYR T" . 5840)
                             ("RUNIC LETTER D" . 5841)
                             ("RUNIC LETTER BERKANAN BEORC BJARKAN B" . 5842)
                             ("RUNIC LETTER SHORT-TWIG-BJARKAN B" . 5843)
                             ("RUNIC LETTER DOTTED-P" . 5844)
                             ("RUNIC LETTER OPEN-P" . 5845)
                             ("RUNIC LETTER EHWAZ EH E" . 5846)
                             ("RUNIC LETTER MANNAZ MAN M" . 5847)
                             ("RUNIC LETTER LONG-BRANCH-MADR M" . 5848)
                             ("RUNIC LETTER SHORT-TWIG-MADR M" . 5849)
                             ("RUNIC LETTER LAUKAZ LAGU LOGR L" . 5850)
                             ("RUNIC LETTER DOTTED-L" . 5851)
                             ("RUNIC LETTER INGWAZ" . 5852)
                             ("RUNIC LETTER ING" . 5853)
                             ("RUNIC LETTER DAGAZ DAEG D" . 5854)
                             ("RUNIC LETTER OTHALAN ETHEL O" . 5855)
                             ("RUNIC LETTER EAR" . 5856)
                             ("RUNIC LETTER IOR" . 5857)
                             ("RUNIC LETTER CWEORTH" . 5858)
                             ("RUNIC LETTER CALC" . 5859)
                             ("RUNIC LETTER CEALC" . 5860)
                             ("RUNIC LETTER STAN" . 5861)
                             ("RUNIC LETTER LONG-BRANCH-YR" . 5862)
                             ("RUNIC LETTER SHORT-TWIG-YR" . 5863)
                             ("RUNIC LETTER ICELANDIC-YR" . 5864)
                             ("RUNIC LETTER Q" . 5865)
                             ("RUNIC LETTER X" . 5866)
                             ("RUNIC SINGLE PUNCTUATION" . 5867)
                             ("RUNIC MULTIPLE PUNCTUATION" . 5868)
                             ("RUNIC CROSS PUNCTUATION" . 5869)
                             ("RUNIC ARLAUG SYMBOL" . 5870)
                             ("RUNIC TVIMADUR SYMBOL" . 5871)
                             ("RUNIC BELGTHOR SYMBOL" . 5872)
                             ("TAGALOG LETTER A" . 5888)
                             ("TAGALOG LETTER I" . 5889)
                             ("TAGALOG LETTER U" . 5890)
                             ("TAGALOG LETTER KA" . 5891)
                             ("TAGALOG LETTER GA" . 5892)
                             ("TAGALOG LETTER NGA" . 5893)
                             ("TAGALOG LETTER TA" . 5894)
                             ("TAGALOG LETTER DA" . 5895)
                             ("TAGALOG LETTER NA" . 5896)
                             ("TAGALOG LETTER PA" . 5897)
                             ("TAGALOG LETTER BA" . 5898)
                             ("TAGALOG LETTER MA" . 5899)
                             ("TAGALOG LETTER YA" . 5900)
                             ("TAGALOG LETTER LA" . 5902)
                             ("TAGALOG LETTER WA" . 5903)
                             ("TAGALOG LETTER SA" . 5904)
                             ("TAGALOG LETTER HA" . 5905)
                             ("TAGALOG VOWEL SIGN I" . 5906)
                             ("TAGALOG VOWEL SIGN U" . 5907)
                             ("TAGALOG SIGN VIRAMA" . 5908)
                             ("HANUNOO LETTER A" . 5920)
                             ("HANUNOO LETTER I" . 5921)
                             ("HANUNOO LETTER U" . 5922)
                             ("HANUNOO LETTER KA" . 5923)
                             ("HANUNOO LETTER GA" . 5924)
                             ("HANUNOO LETTER NGA" . 5925)
                             ("HANUNOO LETTER TA" . 5926)
                             ("HANUNOO LETTER DA" . 5927)
                             ("HANUNOO LETTER NA" . 5928)
                             ("HANUNOO LETTER PA" . 5929)
                             ("HANUNOO LETTER BA" . 5930)
                             ("HANUNOO LETTER MA" . 5931)
                             ("HANUNOO LETTER YA" . 5932)
                             ("HANUNOO LETTER RA" . 5933)
                             ("HANUNOO LETTER LA" . 5934)
                             ("HANUNOO LETTER WA" . 5935)
                             ("HANUNOO LETTER SA" . 5936)
                             ("HANUNOO LETTER HA" . 5937)
                             ("HANUNOO VOWEL SIGN I" . 5938)
                             ("HANUNOO VOWEL SIGN U" . 5939)
                             ("HANUNOO SIGN PAMUDPOD" . 5940)
                             ("PHILIPPINE SINGLE PUNCTUATION" . 5941)
                             ("PHILIPPINE DOUBLE PUNCTUATION" . 5942)
                             ("BUHID LETTER A" . 5952)
                             ("BUHID LETTER I" . 5953)
                             ("BUHID LETTER U" . 5954)
                             ("BUHID LETTER KA" . 5955)
                             ("BUHID LETTER GA" . 5956)
                             ("BUHID LETTER NGA" . 5957)
                             ("BUHID LETTER TA" . 5958)
                             ("BUHID LETTER DA" . 5959)
                             ("BUHID LETTER NA" . 5960)
                             ("BUHID LETTER PA" . 5961)
                             ("BUHID LETTER BA" . 5962)
                             ("BUHID LETTER MA" . 5963)
                             ("BUHID LETTER YA" . 5964)
                             ("BUHID LETTER RA" . 5965)
                             ("BUHID LETTER LA" . 5966)
                             ("BUHID LETTER WA" . 5967)
                             ("BUHID LETTER SA" . 5968)
                             ("BUHID LETTER HA" . 5969)
                             ("BUHID VOWEL SIGN I" . 5970)
                             ("BUHID VOWEL SIGN U" . 5971)
                             ("TAGBANWA LETTER A" . 5984)
                             ("TAGBANWA LETTER I" . 5985)
                             ("TAGBANWA LETTER U" . 5986)
                             ("TAGBANWA LETTER KA" . 5987)
                             ("TAGBANWA LETTER GA" . 5988)
                             ("TAGBANWA LETTER NGA" . 5989)
                             ("TAGBANWA LETTER TA" . 5990)
                             ("TAGBANWA LETTER DA" . 5991)
                             ("TAGBANWA LETTER NA" . 5992)
                             ("TAGBANWA LETTER PA" . 5993)
                             ("TAGBANWA LETTER BA" . 5994)
                             ("TAGBANWA LETTER MA" . 5995)
                             ("TAGBANWA LETTER YA" . 5996)
                             ("TAGBANWA LETTER LA" . 5998)
                             ("TAGBANWA LETTER WA" . 5999)
                             ("TAGBANWA LETTER SA" . 6000)
                             ("TAGBANWA VOWEL SIGN I" . 6002)
                             ("TAGBANWA VOWEL SIGN U" . 6003)
                             ("KHMER LETTER KA" . 6016)
                             ("KHMER LETTER KHA" . 6017)
                             ("KHMER LETTER KO" . 6018)
                             ("KHMER LETTER KHO" . 6019)
                             ("KHMER LETTER NGO" . 6020)
                             ("KHMER LETTER CA" . 6021)
                             ("KHMER LETTER CHA" . 6022)
                             ("KHMER LETTER CO" . 6023)
                             ("KHMER LETTER CHO" . 6024)
                             ("KHMER LETTER NYO" . 6025)
                             ("KHMER LETTER DA" . 6026)
                             ("KHMER LETTER TTHA" . 6027)
                             ("KHMER LETTER DO" . 6028)
                             ("KHMER LETTER TTHO" . 6029)
                             ("KHMER LETTER NNO" . 6030)
                             ("KHMER LETTER TA" . 6031)
                             ("KHMER LETTER THA" . 6032)
                             ("KHMER LETTER TO" . 6033)
                             ("KHMER LETTER THO" . 6034)
                             ("KHMER LETTER NO" . 6035)
                             ("KHMER LETTER BA" . 6036)
                             ("KHMER LETTER PHA" . 6037)
                             ("KHMER LETTER PO" . 6038)
                             ("KHMER LETTER PHO" . 6039)
                             ("KHMER LETTER MO" . 6040)
                             ("KHMER LETTER YO" . 6041)
                             ("KHMER LETTER RO" . 6042)
                             ("KHMER LETTER LO" . 6043)
                             ("KHMER LETTER VO" . 6044)
                             ("KHMER LETTER SHA" . 6045)
                             ("KHMER LETTER SSO" . 6046)
                             ("KHMER LETTER SA" . 6047)
                             ("KHMER LETTER HA" . 6048)
                             ("KHMER LETTER LA" . 6049)
                             ("KHMER LETTER QA" . 6050)
                             ("KHMER INDEPENDENT VOWEL QAQ" . 6051)
                             ("KHMER INDEPENDENT VOWEL QAA" . 6052)
                             ("KHMER INDEPENDENT VOWEL QI" . 6053)
                             ("KHMER INDEPENDENT VOWEL QII" . 6054)
                             ("KHMER INDEPENDENT VOWEL QU" . 6055)
                             ("KHMER INDEPENDENT VOWEL QUK" . 6056)
                             ("KHMER INDEPENDENT VOWEL QUU" . 6057)
                             ("KHMER INDEPENDENT VOWEL QUUV" . 6058)
                             ("KHMER INDEPENDENT VOWEL RY" . 6059)
                             ("KHMER INDEPENDENT VOWEL RYY" . 6060)
                             ("KHMER INDEPENDENT VOWEL LY" . 6061)
                             ("KHMER INDEPENDENT VOWEL LYY" . 6062)
                             ("KHMER INDEPENDENT VOWEL QE" . 6063)
                             ("KHMER INDEPENDENT VOWEL QAI" . 6064)
                             ("KHMER INDEPENDENT VOWEL QOO TYPE ONE" . 6065)
                             ("KHMER INDEPENDENT VOWEL QOO TYPE TWO" . 6066)
                             ("KHMER INDEPENDENT VOWEL QAU" . 6067)
                             ("KHMER VOWEL INHERENT AQ" . 6068)
                             ("KHMER VOWEL INHERENT AA" . 6069)
                             ("KHMER VOWEL SIGN AA" . 6070)
                             ("KHMER VOWEL SIGN I" . 6071)
                             ("KHMER VOWEL SIGN II" . 6072)
                             ("KHMER VOWEL SIGN Y" . 6073)
                             ("KHMER VOWEL SIGN YY" . 6074)
                             ("KHMER VOWEL SIGN U" . 6075)
                             ("KHMER VOWEL SIGN UU" . 6076)
                             ("KHMER VOWEL SIGN UA" . 6077)
                             ("KHMER VOWEL SIGN OE" . 6078)
                             ("KHMER VOWEL SIGN YA" . 6079)
                             ("KHMER VOWEL SIGN IE" . 6080)
                             ("KHMER VOWEL SIGN E" . 6081)
                             ("KHMER VOWEL SIGN AE" . 6082)
                             ("KHMER VOWEL SIGN AI" . 6083)
                             ("KHMER VOWEL SIGN OO" . 6084)
                             ("KHMER VOWEL SIGN AU" . 6085)
                             ("KHMER SIGN NIKAHIT" . 6086)
                             ("KHMER SIGN REAHMUK" . 6087)
                             ("KHMER SIGN YUUKALEAPINTU" . 6088)
                             ("KHMER SIGN MUUSIKATOAN" . 6089)
                             ("KHMER SIGN TRIISAP" . 6090)
                             ("KHMER SIGN BANTOC" . 6091)
                             ("KHMER SIGN ROBAT" . 6092)
                             ("KHMER SIGN TOANDAKHIAT" . 6093)
                             ("KHMER SIGN KAKABAT" . 6094)
                             ("KHMER SIGN AHSDA" . 6095)
                             ("KHMER SIGN SAMYOK SANNYA" . 6096)
                             ("KHMER SIGN VIRIAM" . 6097)
                             ("KHMER SIGN COENG" . 6098)
                             ("KHMER SIGN BATHAMASAT" . 6099)
                             ("KHMER SIGN KHAN" . 6100)
                             ("KHMER SIGN BARIYOOSAN" . 6101)
                             ("KHMER SIGN CAMNUC PII KUUH" . 6102)
                             ("KHMER SIGN LEK TOO" . 6103)
                             ("KHMER SIGN BEYYAL" . 6104)
                             ("KHMER SIGN PHNAEK MUAN" . 6105)
                             ("KHMER SIGN KOOMUUT" . 6106)
                             ("KHMER CURRENCY SYMBOL RIEL" . 6107)
                             ("KHMER SIGN AVAKRAHASANYA" . 6108)
                             ("KHMER DIGIT ZERO" . 6112)
                             ("KHMER DIGIT ONE" . 6113)
                             ("KHMER DIGIT TWO" . 6114)
                             ("KHMER DIGIT THREE" . 6115)
                             ("KHMER DIGIT FOUR" . 6116)
                             ("KHMER DIGIT FIVE" . 6117)
                             ("KHMER DIGIT SIX" . 6118)
                             ("KHMER DIGIT SEVEN" . 6119)
                             ("KHMER DIGIT EIGHT" . 6120)
                             ("KHMER DIGIT NINE" . 6121)
                             ("MONGOLIAN BIRGA" . 6144)
                             ("MONGOLIAN ELLIPSIS" . 6145)
                             ("MONGOLIAN COMMA" . 6146)
                             ("MONGOLIAN FULL STOP" . 6147)
                             ("MONGOLIAN COLON" . 6148)
                             ("MONGOLIAN FOUR DOTS" . 6149)
                             ("MONGOLIAN TODO SOFT HYPHEN" . 6150)
                             ("MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER" . 6151)
                             ("MONGOLIAN MANCHU COMMA" . 6152)
                             ("MONGOLIAN MANCHU FULL STOP" . 6153)
                             ("MONGOLIAN NIRUGU" . 6154)
                             ("MONGOLIAN FREE VARIATION SELECTOR ONE" . 6155)
                             ("MONGOLIAN FREE VARIATION SELECTOR TWO" . 6156)
                             ("MONGOLIAN FREE VARIATION SELECTOR THREE" . 6157)
                             ("MONGOLIAN VOWEL SEPARATOR" . 6158)
                             ("MONGOLIAN DIGIT ZERO" . 6160)
                             ("MONGOLIAN DIGIT ONE" . 6161)
                             ("MONGOLIAN DIGIT TWO" . 6162)
                             ("MONGOLIAN DIGIT THREE" . 6163)
                             ("MONGOLIAN DIGIT FOUR" . 6164)
                             ("MONGOLIAN DIGIT FIVE" . 6165)
                             ("MONGOLIAN DIGIT SIX" . 6166)
                             ("MONGOLIAN DIGIT SEVEN" . 6167)
                             ("MONGOLIAN DIGIT EIGHT" . 6168)
                             ("MONGOLIAN DIGIT NINE" . 6169)
                             ("MONGOLIAN LETTER A" . 6176)
                             ("MONGOLIAN LETTER E" . 6177)
                             ("MONGOLIAN LETTER I" . 6178)
                             ("MONGOLIAN LETTER O" . 6179)
                             ("MONGOLIAN LETTER U" . 6180)
                             ("MONGOLIAN LETTER OE" . 6181)
                             ("MONGOLIAN LETTER UE" . 6182)
                             ("MONGOLIAN LETTER EE" . 6183)
                             ("MONGOLIAN LETTER NA" . 6184)
                             ("MONGOLIAN LETTER ANG" . 6185)
                             ("MONGOLIAN LETTER BA" . 6186)
                             ("MONGOLIAN LETTER PA" . 6187)
                             ("MONGOLIAN LETTER QA" . 6188)
                             ("MONGOLIAN LETTER GA" . 6189)
                             ("MONGOLIAN LETTER MA" . 6190)
                             ("MONGOLIAN LETTER LA" . 6191)
                             ("MONGOLIAN LETTER SA" . 6192)
                             ("MONGOLIAN LETTER SHA" . 6193)
                             ("MONGOLIAN LETTER TA" . 6194)
                             ("MONGOLIAN LETTER DA" . 6195)
                             ("MONGOLIAN LETTER CHA" . 6196)
                             ("MONGOLIAN LETTER JA" . 6197)
                             ("MONGOLIAN LETTER YA" . 6198)
                             ("MONGOLIAN LETTER RA" . 6199)
                             ("MONGOLIAN LETTER WA" . 6200)
                             ("MONGOLIAN LETTER FA" . 6201)
                             ("MONGOLIAN LETTER KA" . 6202)
                             ("MONGOLIAN LETTER KHA" . 6203)
                             ("MONGOLIAN LETTER TSA" . 6204)
                             ("MONGOLIAN LETTER ZA" . 6205)
                             ("MONGOLIAN LETTER HAA" . 6206)
                             ("MONGOLIAN LETTER ZRA" . 6207)
                             ("MONGOLIAN LETTER LHA" . 6208)
                             ("MONGOLIAN LETTER ZHI" . 6209)
                             ("MONGOLIAN LETTER CHI" . 6210)
                             ("MONGOLIAN LETTER TODO LONG VOWEL SIGN" . 6211)
                             ("MONGOLIAN LETTER TODO E" . 6212)
                             ("MONGOLIAN LETTER TODO I" . 6213)
                             ("MONGOLIAN LETTER TODO O" . 6214)
                             ("MONGOLIAN LETTER TODO U" . 6215)
                             ("MONGOLIAN LETTER TODO OE" . 6216)
                             ("MONGOLIAN LETTER TODO UE" . 6217)
                             ("MONGOLIAN LETTER TODO ANG" . 6218)
                             ("MONGOLIAN LETTER TODO BA" . 6219)
                             ("MONGOLIAN LETTER TODO PA" . 6220)
                             ("MONGOLIAN LETTER TODO QA" . 6221)
                             ("MONGOLIAN LETTER TODO GA" . 6222)
                             ("MONGOLIAN LETTER TODO MA" . 6223)
                             ("MONGOLIAN LETTER TODO TA" . 6224)
                             ("MONGOLIAN LETTER TODO DA" . 6225)
                             ("MONGOLIAN LETTER TODO CHA" . 6226)
                             ("MONGOLIAN LETTER TODO JA" . 6227)
                             ("MONGOLIAN LETTER TODO TSA" . 6228)
                             ("MONGOLIAN LETTER TODO YA" . 6229)
                             ("MONGOLIAN LETTER TODO WA" . 6230)
                             ("MONGOLIAN LETTER TODO KA" . 6231)
                             ("MONGOLIAN LETTER TODO GAA" . 6232)
                             ("MONGOLIAN LETTER TODO HAA" . 6233)
                             ("MONGOLIAN LETTER TODO JIA" . 6234)
                             ("MONGOLIAN LETTER TODO NIA" . 6235)
                             ("MONGOLIAN LETTER TODO DZA" . 6236)
                             ("MONGOLIAN LETTER SIBE E" . 6237)
                             ("MONGOLIAN LETTER SIBE I" . 6238)
                             ("MONGOLIAN LETTER SIBE IY" . 6239)
                             ("MONGOLIAN LETTER SIBE UE" . 6240)
                             ("MONGOLIAN LETTER SIBE U" . 6241)
                             ("MONGOLIAN LETTER SIBE ANG" . 6242)
                             ("MONGOLIAN LETTER SIBE KA" . 6243)
                             ("MONGOLIAN LETTER SIBE GA" . 6244)
                             ("MONGOLIAN LETTER SIBE HA" . 6245)
                             ("MONGOLIAN LETTER SIBE PA" . 6246)
                             ("MONGOLIAN LETTER SIBE SHA" . 6247)
                             ("MONGOLIAN LETTER SIBE TA" . 6248)
                             ("MONGOLIAN LETTER SIBE DA" . 6249)
                             ("MONGOLIAN LETTER SIBE JA" . 6250)
                             ("MONGOLIAN LETTER SIBE FA" . 6251)
                             ("MONGOLIAN LETTER SIBE GAA" . 6252)
                             ("MONGOLIAN LETTER SIBE HAA" . 6253)
                             ("MONGOLIAN LETTER SIBE TSA" . 6254)
                             ("MONGOLIAN LETTER SIBE ZA" . 6255)
                             ("MONGOLIAN LETTER SIBE RAA" . 6256)
                             ("MONGOLIAN LETTER SIBE CHA" . 6257)
                             ("MONGOLIAN LETTER SIBE ZHA" . 6258)
                             ("MONGOLIAN LETTER MANCHU I" . 6259)
                             ("MONGOLIAN LETTER MANCHU KA" . 6260)
                             ("MONGOLIAN LETTER MANCHU RA" . 6261)
                             ("MONGOLIAN LETTER MANCHU FA" . 6262)
                             ("MONGOLIAN LETTER MANCHU ZHA" . 6263)
                             ("MONGOLIAN LETTER ALI GALI ANUSVARA ONE" . 6272)
                             ("MONGOLIAN LETTER ALI GALI VISARGA ONE" . 6273)
                             ("MONGOLIAN LETTER ALI GALI DAMARU" . 6274)
                             ("MONGOLIAN LETTER ALI GALI UBADAMA" . 6275)
                             ("MONGOLIAN LETTER ALI GALI INVERTED UBADAMA" . 6276)
                             ("MONGOLIAN LETTER ALI GALI BALUDA" . 6277)
                             ("MONGOLIAN LETTER ALI GALI THREE BALUDA" . 6278)
                             ("MONGOLIAN LETTER ALI GALI A" . 6279)
                             ("MONGOLIAN LETTER ALI GALI I" . 6280)
                             ("MONGOLIAN LETTER ALI GALI KA" . 6281)
                             ("MONGOLIAN LETTER ALI GALI NGA" . 6282)
                             ("MONGOLIAN LETTER ALI GALI CA" . 6283)
                             ("MONGOLIAN LETTER ALI GALI TTA" . 6284)
                             ("MONGOLIAN LETTER ALI GALI TTHA" . 6285)
                             ("MONGOLIAN LETTER ALI GALI DDA" . 6286)
                             ("MONGOLIAN LETTER ALI GALI NNA" . 6287)
                             ("MONGOLIAN LETTER ALI GALI TA" . 6288)
                             ("MONGOLIAN LETTER ALI GALI DA" . 6289)
                             ("MONGOLIAN LETTER ALI GALI PA" . 6290)
                             ("MONGOLIAN LETTER ALI GALI PHA" . 6291)
                             ("MONGOLIAN LETTER ALI GALI SSA" . 6292)
                             ("MONGOLIAN LETTER ALI GALI ZHA" . 6293)
                             ("MONGOLIAN LETTER ALI GALI ZA" . 6294)
                             ("MONGOLIAN LETTER ALI GALI AH" . 6295)
                             ("MONGOLIAN LETTER TODO ALI GALI TA" . 6296)
                             ("MONGOLIAN LETTER TODO ALI GALI ZHA" . 6297)
                             ("MONGOLIAN LETTER MANCHU ALI GALI GHA" . 6298)
                             ("MONGOLIAN LETTER MANCHU ALI GALI NGA" . 6299)
                             ("MONGOLIAN LETTER MANCHU ALI GALI CA" . 6300)
                             ("MONGOLIAN LETTER MANCHU ALI GALI JHA" . 6301)
                             ("MONGOLIAN LETTER MANCHU ALI GALI TTA" . 6302)
                             ("MONGOLIAN LETTER MANCHU ALI GALI DDHA" . 6303)
                             ("MONGOLIAN LETTER MANCHU ALI GALI TA" . 6304)
                             ("MONGOLIAN LETTER MANCHU ALI GALI DHA" . 6305)
                             ("MONGOLIAN LETTER MANCHU ALI GALI SSA" . 6306)
                             ("MONGOLIAN LETTER MANCHU ALI GALI CYA" . 6307)
                             ("MONGOLIAN LETTER MANCHU ALI GALI ZHA" . 6308)
                             ("MONGOLIAN LETTER MANCHU ALI GALI ZA" . 6309)
                             ("MONGOLIAN LETTER ALI GALI HALF U" . 6310)
                             ("MONGOLIAN LETTER ALI GALI HALF YA" . 6311)
                             ("MONGOLIAN LETTER MANCHU ALI GALI BHA" . 6312)
                             ("MONGOLIAN LETTER ALI GALI DAGALGA" . 6313)
                             ("LATIN CAPITAL LETTER A WITH RING BELOW" . 7680)
                             ("LATIN SMALL LETTER A WITH RING BELOW" . 7681)
                             ("LATIN CAPITAL LETTER B WITH DOT ABOVE" . 7682)
                             ("LATIN SMALL LETTER B WITH DOT ABOVE" . 7683)
                             ("LATIN CAPITAL LETTER B WITH DOT BELOW" . 7684)
                             ("LATIN SMALL LETTER B WITH DOT BELOW" . 7685)
                             ("LATIN CAPITAL LETTER B WITH LINE BELOW" . 7686)
                             ("LATIN SMALL LETTER B WITH LINE BELOW" . 7687)
                             ("LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE" . 7688)
                             ("LATIN SMALL LETTER C WITH CEDILLA AND ACUTE" . 7689)
                             ("LATIN CAPITAL LETTER D WITH DOT ABOVE" . 7690)
                             ("LATIN SMALL LETTER D WITH DOT ABOVE" . 7691)
                             ("LATIN CAPITAL LETTER D WITH DOT BELOW" . 7692)
                             ("LATIN SMALL LETTER D WITH DOT BELOW" . 7693)
                             ("LATIN CAPITAL LETTER D WITH LINE BELOW" . 7694)
                             ("LATIN SMALL LETTER D WITH LINE BELOW" . 7695)
                             ("LATIN CAPITAL LETTER D WITH CEDILLA" . 7696)
                             ("LATIN SMALL LETTER D WITH CEDILLA" . 7697)
                             ("LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW" . 7698)
                             ("LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW" . 7699)
                             ("LATIN CAPITAL LETTER E WITH MACRON AND GRAVE" . 7700)
                             ("LATIN SMALL LETTER E WITH MACRON AND GRAVE" . 7701)
                             ("LATIN CAPITAL LETTER E WITH MACRON AND ACUTE" . 7702)
                             ("LATIN SMALL LETTER E WITH MACRON AND ACUTE" . 7703)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW" . 7704)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW" . 7705)
                             ("LATIN CAPITAL LETTER E WITH TILDE BELOW" . 7706)
                             ("LATIN SMALL LETTER E WITH TILDE BELOW" . 7707)
                             ("LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE" . 7708)
                             ("LATIN SMALL LETTER E WITH CEDILLA AND BREVE" . 7709)
                             ("LATIN CAPITAL LETTER F WITH DOT ABOVE" . 7710)
                             ("LATIN SMALL LETTER F WITH DOT ABOVE" . 7711)
                             ("LATIN CAPITAL LETTER G WITH MACRON" . 7712)
                             ("LATIN SMALL LETTER G WITH MACRON" . 7713)
                             ("LATIN CAPITAL LETTER H WITH DOT ABOVE" . 7714)
                             ("LATIN SMALL LETTER H WITH DOT ABOVE" . 7715)
                             ("LATIN CAPITAL LETTER H WITH DOT BELOW" . 7716)
                             ("LATIN SMALL LETTER H WITH DOT BELOW" . 7717)
                             ("LATIN CAPITAL LETTER H WITH DIAERESIS" . 7718)
                             ("LATIN SMALL LETTER H WITH DIAERESIS" . 7719)
                             ("LATIN CAPITAL LETTER H WITH CEDILLA" . 7720)
                             ("LATIN SMALL LETTER H WITH CEDILLA" . 7721)
                             ("LATIN CAPITAL LETTER H WITH BREVE BELOW" . 7722)
                             ("LATIN SMALL LETTER H WITH BREVE BELOW" . 7723)
                             ("LATIN CAPITAL LETTER I WITH TILDE BELOW" . 7724)
                             ("LATIN SMALL LETTER I WITH TILDE BELOW" . 7725)
                             ("LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE" . 7726)
                             ("LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE" . 7727)
                             ("LATIN CAPITAL LETTER K WITH ACUTE" . 7728)
                             ("LATIN SMALL LETTER K WITH ACUTE" . 7729)
                             ("LATIN CAPITAL LETTER K WITH DOT BELOW" . 7730)
                             ("LATIN SMALL LETTER K WITH DOT BELOW" . 7731)
                             ("LATIN CAPITAL LETTER K WITH LINE BELOW" . 7732)
                             ("LATIN SMALL LETTER K WITH LINE BELOW" . 7733)
                             ("LATIN CAPITAL LETTER L WITH DOT BELOW" . 7734)
                             ("LATIN SMALL LETTER L WITH DOT BELOW" . 7735)
                             ("LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON" . 7736)
                             ("LATIN SMALL LETTER L WITH DOT BELOW AND MACRON" . 7737)
                             ("LATIN CAPITAL LETTER L WITH LINE BELOW" . 7738)
                             ("LATIN SMALL LETTER L WITH LINE BELOW" . 7739)
                             ("LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW" . 7740)
                             ("LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW" . 7741)
                             ("LATIN CAPITAL LETTER M WITH ACUTE" . 7742)
                             ("LATIN SMALL LETTER M WITH ACUTE" . 7743)
                             ("LATIN CAPITAL LETTER M WITH DOT ABOVE" . 7744)
                             ("LATIN SMALL LETTER M WITH DOT ABOVE" . 7745)
                             ("LATIN CAPITAL LETTER M WITH DOT BELOW" . 7746)
                             ("LATIN SMALL LETTER M WITH DOT BELOW" . 7747)
                             ("LATIN CAPITAL LETTER N WITH DOT ABOVE" . 7748)
                             ("LATIN SMALL LETTER N WITH DOT ABOVE" . 7749)
                             ("LATIN CAPITAL LETTER N WITH DOT BELOW" . 7750)
                             ("LATIN SMALL LETTER N WITH DOT BELOW" . 7751)
                             ("LATIN CAPITAL LETTER N WITH LINE BELOW" . 7752)
                             ("LATIN SMALL LETTER N WITH LINE BELOW" . 7753)
                             ("LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW" . 7754)
                             ("LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW" . 7755)
                             ("LATIN CAPITAL LETTER O WITH TILDE AND ACUTE" . 7756)
                             ("LATIN SMALL LETTER O WITH TILDE AND ACUTE" . 7757)
                             ("LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS" . 7758)
                             ("LATIN SMALL LETTER O WITH TILDE AND DIAERESIS" . 7759)
                             ("LATIN CAPITAL LETTER O WITH MACRON AND GRAVE" . 7760)
                             ("LATIN SMALL LETTER O WITH MACRON AND GRAVE" . 7761)
                             ("LATIN CAPITAL LETTER O WITH MACRON AND ACUTE" . 7762)
                             ("LATIN SMALL LETTER O WITH MACRON AND ACUTE" . 7763)
                             ("LATIN CAPITAL LETTER P WITH ACUTE" . 7764)
                             ("LATIN SMALL LETTER P WITH ACUTE" . 7765)
                             ("LATIN CAPITAL LETTER P WITH DOT ABOVE" . 7766)
                             ("LATIN SMALL LETTER P WITH DOT ABOVE" . 7767)
                             ("LATIN CAPITAL LETTER R WITH DOT ABOVE" . 7768)
                             ("LATIN SMALL LETTER R WITH DOT ABOVE" . 7769)
                             ("LATIN CAPITAL LETTER R WITH DOT BELOW" . 7770)
                             ("LATIN SMALL LETTER R WITH DOT BELOW" . 7771)
                             ("LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON" . 7772)
                             ("LATIN SMALL LETTER R WITH DOT BELOW AND MACRON" . 7773)
                             ("LATIN CAPITAL LETTER R WITH LINE BELOW" . 7774)
                             ("LATIN SMALL LETTER R WITH LINE BELOW" . 7775)
                             ("LATIN CAPITAL LETTER S WITH DOT ABOVE" . 7776)
                             ("LATIN SMALL LETTER S WITH DOT ABOVE" . 7777)
                             ("LATIN CAPITAL LETTER S WITH DOT BELOW" . 7778)
                             ("LATIN SMALL LETTER S WITH DOT BELOW" . 7779)
                             ("LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE" . 7780)
                             ("LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE" . 7781)
                             ("LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE" . 7782)
                             ("LATIN SMALL LETTER S WITH CARON AND DOT ABOVE" . 7783)
                             ("LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE" . 7784)
                             ("LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE" . 7785)
                             ("LATIN CAPITAL LETTER T WITH DOT ABOVE" . 7786)
                             ("LATIN SMALL LETTER T WITH DOT ABOVE" . 7787)
                             ("LATIN CAPITAL LETTER T WITH DOT BELOW" . 7788)
                             ("LATIN SMALL LETTER T WITH DOT BELOW" . 7789)
                             ("LATIN CAPITAL LETTER T WITH LINE BELOW" . 7790)
                             ("LATIN SMALL LETTER T WITH LINE BELOW" . 7791)
                             ("LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW" . 7792)
                             ("LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW" . 7793)
                             ("LATIN CAPITAL LETTER U WITH DIAERESIS BELOW" . 7794)
                             ("LATIN SMALL LETTER U WITH DIAERESIS BELOW" . 7795)
                             ("LATIN CAPITAL LETTER U WITH TILDE BELOW" . 7796)
                             ("LATIN SMALL LETTER U WITH TILDE BELOW" . 7797)
                             ("LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW" . 7798)
                             ("LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW" . 7799)
                             ("LATIN CAPITAL LETTER U WITH TILDE AND ACUTE" . 7800)
                             ("LATIN SMALL LETTER U WITH TILDE AND ACUTE" . 7801)
                             ("LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS" . 7802)
                             ("LATIN SMALL LETTER U WITH MACRON AND DIAERESIS" . 7803)
                             ("LATIN CAPITAL LETTER V WITH TILDE" . 7804)
                             ("LATIN SMALL LETTER V WITH TILDE" . 7805)
                             ("LATIN CAPITAL LETTER V WITH DOT BELOW" . 7806)
                             ("LATIN SMALL LETTER V WITH DOT BELOW" . 7807)
                             ("LATIN CAPITAL LETTER W WITH GRAVE" . 7808)
                             ("LATIN SMALL LETTER W WITH GRAVE" . 7809)
                             ("LATIN CAPITAL LETTER W WITH ACUTE" . 7810)
                             ("LATIN SMALL LETTER W WITH ACUTE" . 7811)
                             ("LATIN CAPITAL LETTER W WITH DIAERESIS" . 7812)
                             ("LATIN SMALL LETTER W WITH DIAERESIS" . 7813)
                             ("LATIN CAPITAL LETTER W WITH DOT ABOVE" . 7814)
                             ("LATIN SMALL LETTER W WITH DOT ABOVE" . 7815)
                             ("LATIN CAPITAL LETTER W WITH DOT BELOW" . 7816)
                             ("LATIN SMALL LETTER W WITH DOT BELOW" . 7817)
                             ("LATIN CAPITAL LETTER X WITH DOT ABOVE" . 7818)
                             ("LATIN SMALL LETTER X WITH DOT ABOVE" . 7819)
                             ("LATIN CAPITAL LETTER X WITH DIAERESIS" . 7820)
                             ("LATIN SMALL LETTER X WITH DIAERESIS" . 7821)
                             ("LATIN CAPITAL LETTER Y WITH DOT ABOVE" . 7822)
                             ("LATIN SMALL LETTER Y WITH DOT ABOVE" . 7823)
                             ("LATIN CAPITAL LETTER Z WITH CIRCUMFLEX" . 7824)
                             ("LATIN SMALL LETTER Z WITH CIRCUMFLEX" . 7825)
                             ("LATIN CAPITAL LETTER Z WITH DOT BELOW" . 7826)
                             ("LATIN SMALL LETTER Z WITH DOT BELOW" . 7827)
                             ("LATIN CAPITAL LETTER Z WITH LINE BELOW" . 7828)
                             ("LATIN SMALL LETTER Z WITH LINE BELOW" . 7829)
                             ("LATIN SMALL LETTER H WITH LINE BELOW" . 7830)
                             ("LATIN SMALL LETTER T WITH DIAERESIS" . 7831)
                             ("LATIN SMALL LETTER W WITH RING ABOVE" . 7832)
                             ("LATIN SMALL LETTER Y WITH RING ABOVE" . 7833)
                             ("LATIN SMALL LETTER A WITH RIGHT HALF RING" . 7834)
                             ("LATIN SMALL LETTER LONG S WITH DOT ABOVE" . 7835)
                             ("LATIN CAPITAL LETTER A WITH DOT BELOW" . 7840)
                             ("LATIN SMALL LETTER A WITH DOT BELOW" . 7841)
                             ("LATIN CAPITAL LETTER A WITH HOOK ABOVE" . 7842)
                             ("LATIN SMALL LETTER A WITH HOOK ABOVE" . 7843)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE" . 7844)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE" . 7845)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE" . 7846)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE" . 7847)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" . 7848)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE" . 7849)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE" . 7850)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE" . 7851)
                             ("LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW" . 7852)
                             ("LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW" . 7853)
                             ("LATIN CAPITAL LETTER A WITH BREVE AND ACUTE" . 7854)
                             ("LATIN SMALL LETTER A WITH BREVE AND ACUTE" . 7855)
                             ("LATIN CAPITAL LETTER A WITH BREVE AND GRAVE" . 7856)
                             ("LATIN SMALL LETTER A WITH BREVE AND GRAVE" . 7857)
                             ("LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE" . 7858)
                             ("LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE" . 7859)
                             ("LATIN CAPITAL LETTER A WITH BREVE AND TILDE" . 7860)
                             ("LATIN SMALL LETTER A WITH BREVE AND TILDE" . 7861)
                             ("LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW" . 7862)
                             ("LATIN SMALL LETTER A WITH BREVE AND DOT BELOW" . 7863)
                             ("LATIN CAPITAL LETTER E WITH DOT BELOW" . 7864)
                             ("LATIN SMALL LETTER E WITH DOT BELOW" . 7865)
                             ("LATIN CAPITAL LETTER E WITH HOOK ABOVE" . 7866)
                             ("LATIN SMALL LETTER E WITH HOOK ABOVE" . 7867)
                             ("LATIN CAPITAL LETTER E WITH TILDE" . 7868)
                             ("LATIN SMALL LETTER E WITH TILDE" . 7869)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE" . 7870)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE" . 7871)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE" . 7872)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE" . 7873)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" . 7874)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE" . 7875)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE" . 7876)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE" . 7877)
                             ("LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW" . 7878)
                             ("LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW" . 7879)
                             ("LATIN CAPITAL LETTER I WITH HOOK ABOVE" . 7880)
                             ("LATIN SMALL LETTER I WITH HOOK ABOVE" . 7881)
                             ("LATIN CAPITAL LETTER I WITH DOT BELOW" . 7882)
                             ("LATIN SMALL LETTER I WITH DOT BELOW" . 7883)
                             ("LATIN CAPITAL LETTER O WITH DOT BELOW" . 7884)
                             ("LATIN SMALL LETTER O WITH DOT BELOW" . 7885)
                             ("LATIN CAPITAL LETTER O WITH HOOK ABOVE" . 7886)
                             ("LATIN SMALL LETTER O WITH HOOK ABOVE" . 7887)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE" . 7888)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE" . 7889)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE" . 7890)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE" . 7891)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" . 7892)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE" . 7893)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE" . 7894)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE" . 7895)
                             ("LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW" . 7896)
                             ("LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW" . 7897)
                             ("LATIN CAPITAL LETTER O WITH HORN AND ACUTE" . 7898)
                             ("LATIN SMALL LETTER O WITH HORN AND ACUTE" . 7899)
                             ("LATIN CAPITAL LETTER O WITH HORN AND GRAVE" . 7900)
                             ("LATIN SMALL LETTER O WITH HORN AND GRAVE" . 7901)
                             ("LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE" . 7902)
                             ("LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE" . 7903)
                             ("LATIN CAPITAL LETTER O WITH HORN AND TILDE" . 7904)
                             ("LATIN SMALL LETTER O WITH HORN AND TILDE" . 7905)
                             ("LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW" . 7906)
                             ("LATIN SMALL LETTER O WITH HORN AND DOT BELOW" . 7907)
                             ("LATIN CAPITAL LETTER U WITH DOT BELOW" . 7908)
                             ("LATIN SMALL LETTER U WITH DOT BELOW" . 7909)
                             ("LATIN CAPITAL LETTER U WITH HOOK ABOVE" . 7910)
                             ("LATIN SMALL LETTER U WITH HOOK ABOVE" . 7911)
                             ("LATIN CAPITAL LETTER U WITH HORN AND ACUTE" . 7912)
                             ("LATIN SMALL LETTER U WITH HORN AND ACUTE" . 7913)
                             ("LATIN CAPITAL LETTER U WITH HORN AND GRAVE" . 7914)
                             ("LATIN SMALL LETTER U WITH HORN AND GRAVE" . 7915)
                             ("LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE" . 7916)
                             ("LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE" . 7917)
                             ("LATIN CAPITAL LETTER U WITH HORN AND TILDE" . 7918)
                             ("LATIN SMALL LETTER U WITH HORN AND TILDE" . 7919)
                             ("LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW" . 7920)
                             ("LATIN SMALL LETTER U WITH HORN AND DOT BELOW" . 7921)
                             ("LATIN CAPITAL LETTER Y WITH GRAVE" . 7922)
                             ("LATIN SMALL LETTER Y WITH GRAVE" . 7923)
                             ("LATIN CAPITAL LETTER Y WITH DOT BELOW" . 7924)
                             ("LATIN SMALL LETTER Y WITH DOT BELOW" . 7925)
                             ("LATIN CAPITAL LETTER Y WITH HOOK ABOVE" . 7926)
                             ("LATIN SMALL LETTER Y WITH HOOK ABOVE" . 7927)
                             ("LATIN CAPITAL LETTER Y WITH TILDE" . 7928)
                             ("LATIN SMALL LETTER Y WITH TILDE" . 7929)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI" . 7936)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA" . 7937)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA" . 7938)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA" . 7939)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA" . 7940)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA" . 7941)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI" . 7942)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI" . 7943)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI" . 7944)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA" . 7945)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA" . 7946)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA" . 7947)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA" . 7948)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA" . 7949)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI" . 7950)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI" . 7951)
                             ("GREEK SMALL LETTER EPSILON WITH PSILI" . 7952)
                             ("GREEK SMALL LETTER EPSILON WITH DASIA" . 7953)
                             ("GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA" . 7954)
                             ("GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA" . 7955)
                             ("GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA" . 7956)
                             ("GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA" . 7957)
                             ("GREEK CAPITAL LETTER EPSILON WITH PSILI" . 7960)
                             ("GREEK CAPITAL LETTER EPSILON WITH DASIA" . 7961)
                             ("GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA" . 7962)
                             ("GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA" . 7963)
                             ("GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA" . 7964)
                             ("GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA" . 7965)
                             ("GREEK SMALL LETTER ETA WITH PSILI" . 7968)
                             ("GREEK SMALL LETTER ETA WITH DASIA" . 7969)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND VARIA" . 7970)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND VARIA" . 7971)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND OXIA" . 7972)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND OXIA" . 7973)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI" . 7974)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI" . 7975)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI" . 7976)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA" . 7977)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA" . 7978)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA" . 7979)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA" . 7980)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA" . 7981)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI" . 7982)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI" . 7983)
                             ("GREEK SMALL LETTER IOTA WITH PSILI" . 7984)
                             ("GREEK SMALL LETTER IOTA WITH DASIA" . 7985)
                             ("GREEK SMALL LETTER IOTA WITH PSILI AND VARIA" . 7986)
                             ("GREEK SMALL LETTER IOTA WITH DASIA AND VARIA" . 7987)
                             ("GREEK SMALL LETTER IOTA WITH PSILI AND OXIA" . 7988)
                             ("GREEK SMALL LETTER IOTA WITH DASIA AND OXIA" . 7989)
                             ("GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI" . 7990)
                             ("GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI" . 7991)
                             ("GREEK CAPITAL LETTER IOTA WITH PSILI" . 7992)
                             ("GREEK CAPITAL LETTER IOTA WITH DASIA" . 7993)
                             ("GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA" . 7994)
                             ("GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA" . 7995)
                             ("GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA" . 7996)
                             ("GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA" . 7997)
                             ("GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI" . 7998)
                             ("GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI" . 7999)
                             ("GREEK SMALL LETTER OMICRON WITH PSILI" . 8000)
                             ("GREEK SMALL LETTER OMICRON WITH DASIA" . 8001)
                             ("GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA" . 8002)
                             ("GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA" . 8003)
                             ("GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA" . 8004)
                             ("GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA" . 8005)
                             ("GREEK CAPITAL LETTER OMICRON WITH PSILI" . 8008)
                             ("GREEK CAPITAL LETTER OMICRON WITH DASIA" . 8009)
                             ("GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA" . 8010)
                             ("GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA" . 8011)
                             ("GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA" . 8012)
                             ("GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA" . 8013)
                             ("GREEK SMALL LETTER UPSILON WITH PSILI" . 8016)
                             ("GREEK SMALL LETTER UPSILON WITH DASIA" . 8017)
                             ("GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA" . 8018)
                             ("GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA" . 8019)
                             ("GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA" . 8020)
                             ("GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA" . 8021)
                             ("GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI" . 8022)
                             ("GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI" . 8023)
                             ("GREEK CAPITAL LETTER UPSILON WITH DASIA" . 8025)
                             ("GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA" . 8027)
                             ("GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA" . 8029)
                             ("GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI" . 8031)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI" . 8032)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA" . 8033)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA" . 8034)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA" . 8035)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA" . 8036)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA" . 8037)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI" . 8038)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI" . 8039)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI" . 8040)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA" . 8041)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA" . 8042)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA" . 8043)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA" . 8044)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA" . 8045)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI" . 8046)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI" . 8047)
                             ("GREEK SMALL LETTER ALPHA WITH VARIA" . 8048)
                             ("GREEK SMALL LETTER ALPHA WITH OXIA" . 8049)
                             ("GREEK SMALL LETTER EPSILON WITH VARIA" . 8050)
                             ("GREEK SMALL LETTER EPSILON WITH OXIA" . 8051)
                             ("GREEK SMALL LETTER ETA WITH VARIA" . 8052)
                             ("GREEK SMALL LETTER ETA WITH OXIA" . 8053)
                             ("GREEK SMALL LETTER IOTA WITH VARIA" . 8054)
                             ("GREEK SMALL LETTER IOTA WITH OXIA" . 8055)
                             ("GREEK SMALL LETTER OMICRON WITH VARIA" . 8056)
                             ("GREEK SMALL LETTER OMICRON WITH OXIA" . 8057)
                             ("GREEK SMALL LETTER UPSILON WITH VARIA" . 8058)
                             ("GREEK SMALL LETTER UPSILON WITH OXIA" . 8059)
                             ("GREEK SMALL LETTER OMEGA WITH VARIA" . 8060)
                             ("GREEK SMALL LETTER OMEGA WITH OXIA" . 8061)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI" . 8064)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI" . 8065)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI" . 8066)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI" . 8067)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI" . 8068)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI" . 8069)
                             ("GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" . 8070)
                             ("GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" . 8071)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI" . 8072)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI" . 8073)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI" . 8074)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI" . 8075)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI" . 8076)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI" . 8077)
                             ("GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" . 8078)
                             ("GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" . 8079)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI" . 8080)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI" . 8081)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI" . 8082)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI" . 8083)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI" . 8084)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI" . 8085)
                             ("GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" . 8086)
                             ("GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" . 8087)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI" . 8088)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI" . 8089)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI" . 8090)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI" . 8091)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI" . 8092)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI" . 8093)
                             ("GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" . 8094)
                             ("GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" . 8095)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI" . 8096)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI" . 8097)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI" . 8098)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI" . 8099)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI" . 8100)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI" . 8101)
                             ("GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" . 8102)
                             ("GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI" . 8103)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI" . 8104)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI" . 8105)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI" . 8106)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI" . 8107)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI" . 8108)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI" . 8109)
                             ("GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI" . 8110)
                             ("GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI" . 8111)
                             ("GREEK SMALL LETTER ALPHA WITH VRACHY" . 8112)
                             ("GREEK SMALL LETTER ALPHA WITH MACRON" . 8113)
                             ("GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI" . 8114)
                             ("GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI" . 8115)
                             ("GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI" . 8116)
                             ("GREEK SMALL LETTER ALPHA WITH PERISPOMENI" . 8118)
                             ("GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI" . 8119)
                             ("GREEK CAPITAL LETTER ALPHA WITH VRACHY" . 8120)
                             ("GREEK CAPITAL LETTER ALPHA WITH MACRON" . 8121)
                             ("GREEK CAPITAL LETTER ALPHA WITH VARIA" . 8122)
                             ("GREEK CAPITAL LETTER ALPHA WITH OXIA" . 8123)
                             ("GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI" . 8124)
                             ("GREEK KORONIS" . 8125)
                             ("GREEK PROSGEGRAMMENI" . 8126)
                             ("GREEK PSILI" . 8127)
                             ("GREEK PERISPOMENI" . 8128)
                             ("GREEK DIALYTIKA AND PERISPOMENI" . 8129)
                             ("GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI" . 8130)
                             ("GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI" . 8131)
                             ("GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI" . 8132)
                             ("GREEK SMALL LETTER ETA WITH PERISPOMENI" . 8134)
                             ("GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI" . 8135)
                             ("GREEK CAPITAL LETTER EPSILON WITH VARIA" . 8136)
                             ("GREEK CAPITAL LETTER EPSILON WITH OXIA" . 8137)
                             ("GREEK CAPITAL LETTER ETA WITH VARIA" . 8138)
                             ("GREEK CAPITAL LETTER ETA WITH OXIA" . 8139)
                             ("GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI" . 8140)
                             ("GREEK PSILI AND VARIA" . 8141)
                             ("GREEK PSILI AND OXIA" . 8142)
                             ("GREEK PSILI AND PERISPOMENI" . 8143)
                             ("GREEK SMALL LETTER IOTA WITH VRACHY" . 8144)
                             ("GREEK SMALL LETTER IOTA WITH MACRON" . 8145)
                             ("GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA" . 8146)
                             ("GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA" . 8147)
                             ("GREEK SMALL LETTER IOTA WITH PERISPOMENI" . 8150)
                             ("GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI" . 8151)
                             ("GREEK CAPITAL LETTER IOTA WITH VRACHY" . 8152)
                             ("GREEK CAPITAL LETTER IOTA WITH MACRON" . 8153)
                             ("GREEK CAPITAL LETTER IOTA WITH VARIA" . 8154)
                             ("GREEK CAPITAL LETTER IOTA WITH OXIA" . 8155)
                             ("GREEK DASIA AND VARIA" . 8157)
                             ("GREEK DASIA AND OXIA" . 8158)
                             ("GREEK DASIA AND PERISPOMENI" . 8159)
                             ("GREEK SMALL LETTER UPSILON WITH VRACHY" . 8160)
                             ("GREEK SMALL LETTER UPSILON WITH MACRON" . 8161)
                             ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA" . 8162)
                             ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA" . 8163)
                             ("GREEK SMALL LETTER RHO WITH PSILI" . 8164)
                             ("GREEK SMALL LETTER RHO WITH DASIA" . 8165)
                             ("GREEK SMALL LETTER UPSILON WITH PERISPOMENI" . 8166)
                             ("GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI" . 8167)
                             ("GREEK CAPITAL LETTER UPSILON WITH VRACHY" . 8168)
                             ("GREEK CAPITAL LETTER UPSILON WITH MACRON" . 8169)
                             ("GREEK CAPITAL LETTER UPSILON WITH VARIA" . 8170)
                             ("GREEK CAPITAL LETTER UPSILON WITH OXIA" . 8171)
                             ("GREEK CAPITAL LETTER RHO WITH DASIA" . 8172)
                             ("GREEK DIALYTIKA AND VARIA" . 8173)
                             ("GREEK DIALYTIKA AND OXIA" . 8174)
                             ("GREEK VARIA" . 8175)
                             ("GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI" . 8178)
                             ("GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI" . 8179)
                             ("GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI" . 8180)
                             ("GREEK SMALL LETTER OMEGA WITH PERISPOMENI" . 8182)
                             ("GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI" . 8183)
                             ("GREEK CAPITAL LETTER OMICRON WITH VARIA" . 8184)
                             ("GREEK CAPITAL LETTER OMICRON WITH OXIA" . 8185)
                             ("GREEK CAPITAL LETTER OMEGA WITH VARIA" . 8186)
                             ("GREEK CAPITAL LETTER OMEGA WITH OXIA" . 8187)
                             ("GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI" . 8188)
                             ("GREEK OXIA" . 8189)
                             ("GREEK DASIA" . 8190)
                             ("EN QUAD" . 8192)
                             ("EM QUAD" . 8193)
                             ("EN SPACE" . 8194)
                             ("EM SPACE" . 8195)
                             ("THREE-PER-EM SPACE" . 8196)
                             ("FOUR-PER-EM SPACE" . 8197)
                             ("SIX-PER-EM SPACE" . 8198)
                             ("FIGURE SPACE" . 8199)
                             ("PUNCTUATION SPACE" . 8200)
                             ("THIN SPACE" . 8201)
                             ("HAIR SPACE" . 8202)
                             ("ZERO WIDTH SPACE" . 8203)
                             ("ZERO WIDTH NON-JOINER" . 8204)
                             ("ZERO WIDTH JOINER" . 8205)
                             ("LEFT-TO-RIGHT MARK" . 8206)
                             ("RIGHT-TO-LEFT MARK" . 8207)
                             ("HYPHEN" . 8208)
                             ("NON-BREAKING HYPHEN" . 8209)
                             ("FIGURE DASH" . 8210)
                             ("EN DASH" . 8211)
                             ("EM DASH" . 8212)
                             ("HORIZONTAL BAR" . 8213)
                             ("DOUBLE VERTICAL LINE" . 8214)
                             ("DOUBLE LOW LINE" . 8215)
                             ("LEFT SINGLE QUOTATION MARK" . 8216)
                             ("RIGHT SINGLE QUOTATION MARK" . 8217)
                             ("SINGLE LOW-9 QUOTATION MARK" . 8218)
                             ("SINGLE HIGH-REVERSED-9 QUOTATION MARK" . 8219)
                             ("LEFT DOUBLE QUOTATION MARK" . 8220)
                             ("RIGHT DOUBLE QUOTATION MARK" . 8221)
                             ("DOUBLE LOW-9 QUOTATION MARK" . 8222)
                             ("DOUBLE HIGH-REVERSED-9 QUOTATION MARK" . 8223)
                             ("DAGGER" . 8224)
                             ("DOUBLE DAGGER" . 8225)
                             ("BULLET" . 8226)
                             ("TRIANGULAR BULLET" . 8227)
                             ("ONE DOT LEADER" . 8228)
                             ("TWO DOT LEADER" . 8229)
                             ("HORIZONTAL ELLIPSIS" . 8230)
                             ("HYPHENATION POINT" . 8231)
                             ("LINE SEPARATOR" . 8232)
                             ("PARAGRAPH SEPARATOR" . 8233)
                             ("LEFT-TO-RIGHT EMBEDDING" . 8234)
                             ("RIGHT-TO-LEFT EMBEDDING" . 8235)
                             ("POP DIRECTIONAL FORMATTING" . 8236)
                             ("LEFT-TO-RIGHT OVERRIDE" . 8237)
                             ("RIGHT-TO-LEFT OVERRIDE" . 8238)
                             ("NARROW NO-BREAK SPACE" . 8239)
                             ("PER MILLE SIGN" . 8240)
                             ("PER TEN THOUSAND SIGN" . 8241)
                             ("PRIME" . 8242)
                             ("DOUBLE PRIME" . 8243)
                             ("TRIPLE PRIME" . 8244)
                             ("REVERSED PRIME" . 8245)
                             ("REVERSED DOUBLE PRIME" . 8246)
                             ("REVERSED TRIPLE PRIME" . 8247)
                             ("CARET" . 8248)
                             ("SINGLE LEFT-POINTING ANGLE QUOTATION MARK" . 8249)
                             ("SINGLE RIGHT-POINTING ANGLE QUOTATION MARK" . 8250)
                             ("REFERENCE MARK" . 8251)
                             ("DOUBLE EXCLAMATION MARK" . 8252)
                             ("INTERROBANG" . 8253)
                             ("OVERLINE" . 8254)
                             ("UNDERTIE" . 8255)
                             ("CHARACTER TIE" . 8256)
                             ("CARET INSERTION POINT" . 8257)
                             ("ASTERISM" . 8258)
                             ("HYPHEN BULLET" . 8259)
                             ("FRACTION SLASH" . 8260)
                             ("LEFT SQUARE BRACKET WITH QUILL" . 8261)
                             ("RIGHT SQUARE BRACKET WITH QUILL" . 8262)
                             ("DOUBLE QUESTION MARK" . 8263)
                             ("QUESTION EXCLAMATION MARK" . 8264)
                             ("EXCLAMATION QUESTION MARK" . 8265)
                             ("TIRONIAN SIGN ET" . 8266)
                             ("REVERSED PILCROW SIGN" . 8267)
                             ("BLACK LEFTWARDS BULLET" . 8268)
                             ("BLACK RIGHTWARDS BULLET" . 8269)
                             ("LOW ASTERISK" . 8270)
                             ("REVERSED SEMICOLON" . 8271)
                             ("CLOSE UP" . 8272)
                             ("TWO ASTERISKS ALIGNED VERTICALLY" . 8273)
                             ("COMMERCIAL MINUS SIGN" . 8274)
                             ("QUADRUPLE PRIME" . 8279)
                             ("MEDIUM MATHEMATICAL SPACE" . 8287)
                             ("WORD JOINER" . 8288)
                             ("FUNCTION APPLICATION" . 8289)
                             ("INVISIBLE TIMES" . 8290)
                             ("INVISIBLE SEPARATOR" . 8291)
                             ("INHIBIT SYMMETRIC SWAPPING" . 8298)
                             ("ACTIVATE SYMMETRIC SWAPPING" . 8299)
                             ("INHIBIT ARABIC FORM SHAPING" . 8300)
                             ("ACTIVATE ARABIC FORM SHAPING" . 8301)
                             ("NATIONAL DIGIT SHAPES" . 8302)
                             ("NOMINAL DIGIT SHAPES" . 8303)
                             ("SUPERSCRIPT ZERO" . 8304)
                             ("SUPERSCRIPT LATIN SMALL LETTER I" . 8305)
                             ("SUPERSCRIPT FOUR" . 8308)
                             ("SUPERSCRIPT FIVE" . 8309)
                             ("SUPERSCRIPT SIX" . 8310)
                             ("SUPERSCRIPT SEVEN" . 8311)
                             ("SUPERSCRIPT EIGHT" . 8312)
                             ("SUPERSCRIPT NINE" . 8313)
                             ("SUPERSCRIPT PLUS SIGN" . 8314)
                             ("SUPERSCRIPT MINUS" . 8315)
                             ("SUPERSCRIPT EQUALS SIGN" . 8316)
                             ("SUPERSCRIPT LEFT PARENTHESIS" . 8317)
                             ("SUPERSCRIPT RIGHT PARENTHESIS" . 8318)
                             ("SUPERSCRIPT LATIN SMALL LETTER N" . 8319)
                             ("SUBSCRIPT ZERO" . 8320)
                             ("SUBSCRIPT ONE" . 8321)
                             ("SUBSCRIPT TWO" . 8322)
                             ("SUBSCRIPT THREE" . 8323)
                             ("SUBSCRIPT FOUR" . 8324)
                             ("SUBSCRIPT FIVE" . 8325)
                             ("SUBSCRIPT SIX" . 8326)
                             ("SUBSCRIPT SEVEN" . 8327)
                             ("SUBSCRIPT EIGHT" . 8328)
                             ("SUBSCRIPT NINE" . 8329)
                             ("SUBSCRIPT PLUS SIGN" . 8330)
                             ("SUBSCRIPT MINUS" . 8331)
                             ("SUBSCRIPT EQUALS SIGN" . 8332)
                             ("SUBSCRIPT LEFT PARENTHESIS" . 8333)
                             ("SUBSCRIPT RIGHT PARENTHESIS" . 8334)
                             ("EURO-CURRENCY SIGN" . 8352)
                             ("COLON SIGN" . 8353)
                             ("CRUZEIRO SIGN" . 8354)
                             ("FRENCH FRANC SIGN" . 8355)
                             ("LIRA SIGN" . 8356)
                             ("MILL SIGN" . 8357)
                             ("NAIRA SIGN" . 8358)
                             ("PESETA SIGN" . 8359)
                             ("RUPEE SIGN" . 8360)
                             ("WON SIGN" . 8361)
                             ("NEW SHEQEL SIGN" . 8362)
                             ("DONG SIGN" . 8363)
                             ("EURO SIGN" . 8364)
                             ("KIP SIGN" . 8365)
                             ("TUGRIK SIGN" . 8366)
                             ("DRACHMA SIGN" . 8367)
                             ("GERMAN PENNY SIGN" . 8368)
                             ("PESO SIGN" . 8369)
                             ("COMBINING LEFT HARPOON ABOVE" . 8400)
                             ("COMBINING RIGHT HARPOON ABOVE" . 8401)
                             ("COMBINING LONG VERTICAL LINE OVERLAY" . 8402)
                             ("COMBINING SHORT VERTICAL LINE OVERLAY" . 8403)
                             ("COMBINING ANTICLOCKWISE ARROW ABOVE" . 8404)
                             ("COMBINING CLOCKWISE ARROW ABOVE" . 8405)
                             ("COMBINING LEFT ARROW ABOVE" . 8406)
                             ("COMBINING RIGHT ARROW ABOVE" . 8407)
                             ("COMBINING RING OVERLAY" . 8408)
                             ("COMBINING CLOCKWISE RING OVERLAY" . 8409)
                             ("COMBINING ANTICLOCKWISE RING OVERLAY" . 8410)
                             ("COMBINING THREE DOTS ABOVE" . 8411)
                             ("COMBINING FOUR DOTS ABOVE" . 8412)
                             ("COMBINING ENCLOSING CIRCLE" . 8413)
                             ("COMBINING ENCLOSING SQUARE" . 8414)
                             ("COMBINING ENCLOSING DIAMOND" . 8415)
                             ("COMBINING ENCLOSING CIRCLE BACKSLASH" . 8416)
                             ("COMBINING LEFT RIGHT ARROW ABOVE" . 8417)
                             ("COMBINING ENCLOSING SCREEN" . 8418)
                             ("COMBINING ENCLOSING KEYCAP" . 8419)
                             ("COMBINING ENCLOSING UPWARD POINTING TRIANGLE" . 8420)
                             ("COMBINING REVERSE SOLIDUS OVERLAY" . 8421)
                             ("COMBINING DOUBLE VERTICAL STROKE OVERLAY" . 8422)
                             ("COMBINING ANNUITY SYMBOL" . 8423)
                             ("COMBINING TRIPLE UNDERDOT" . 8424)
                             ("COMBINING WIDE BRIDGE ABOVE" . 8425)
                             ("COMBINING LEFTWARDS ARROW OVERLAY" . 8426)
                             ("ACCOUNT OF" . 8448)
                             ("ADDRESSED TO THE SUBJECT" . 8449)
                             ("DOUBLE-STRUCK CAPITAL C" . 8450)
                             ("DEGREE CELSIUS" . 8451)
                             ("CENTRE LINE SYMBOL" . 8452)
                             ("CARE OF" . 8453)
                             ("CADA UNA" . 8454)
                             ("EULER CONSTANT" . 8455)
                             ("SCRUPLE" . 8456)
                             ("DEGREE FAHRENHEIT" . 8457)
                             ("SCRIPT SMALL G" . 8458)
                             ("SCRIPT CAPITAL H" . 8459)
                             ("BLACK-LETTER CAPITAL H" . 8460)
                             ("DOUBLE-STRUCK CAPITAL H" . 8461)
                             ("PLANCK CONSTANT" . 8462)
                             ("PLANCK CONSTANT OVER TWO PI" . 8463)
                             ("SCRIPT CAPITAL I" . 8464)
                             ("BLACK-LETTER CAPITAL I" . 8465)
                             ("SCRIPT CAPITAL L" . 8466)
                             ("SCRIPT SMALL L" . 8467)
                             ("L B BAR SYMBOL" . 8468)
                             ("DOUBLE-STRUCK CAPITAL N" . 8469)
                             ("NUMERO SIGN" . 8470)
                             ("SOUND RECORDING COPYRIGHT" . 8471)
                             ("SCRIPT CAPITAL P" . 8472)
                             ("DOUBLE-STRUCK CAPITAL P" . 8473)
                             ("DOUBLE-STRUCK CAPITAL Q" . 8474)
                             ("SCRIPT CAPITAL R" . 8475)
                             ("BLACK-LETTER CAPITAL R" . 8476)
                             ("DOUBLE-STRUCK CAPITAL R" . 8477)
                             ("PRESCRIPTION TAKE" . 8478)
                             ("RESPONSE" . 8479)
                             ("SERVICE MARK" . 8480)
                             ("TELEPHONE SIGN" . 8481)
                             ("TRADE MARK SIGN" . 8482)
                             ("VERSICLE" . 8483)
                             ("DOUBLE-STRUCK CAPITAL Z" . 8484)
                             ("OUNCE SIGN" . 8485)
                             ("OHM SIGN" . 8486)
                             ("INVERTED OHM SIGN" . 8487)
                             ("BLACK-LETTER CAPITAL Z" . 8488)
                             ("TURNED GREEK SMALL LETTER IOTA" . 8489)
                             ("KELVIN SIGN" . 8490)
                             ("ANGSTROM SIGN" . 8491)
                             ("SCRIPT CAPITAL B" . 8492)
                             ("BLACK-LETTER CAPITAL C" . 8493)
                             ("ESTIMATED SYMBOL" . 8494)
                             ("SCRIPT SMALL E" . 8495)
                             ("SCRIPT CAPITAL E" . 8496)
                             ("SCRIPT CAPITAL F" . 8497)
                             ("TURNED CAPITAL F" . 8498)
                             ("SCRIPT CAPITAL M" . 8499)
                             ("SCRIPT SMALL O" . 8500)
                             ("ALEF SYMBOL" . 8501)
                             ("BET SYMBOL" . 8502)
                             ("GIMEL SYMBOL" . 8503)
                             ("DALET SYMBOL" . 8504)
                             ("INFORMATION SOURCE" . 8505)
                             ("ROTATED CAPITAL Q" . 8506)
                             ("DOUBLE-STRUCK SMALL GAMMA" . 8509)
                             ("DOUBLE-STRUCK CAPITAL GAMMA" . 8510)
                             ("DOUBLE-STRUCK CAPITAL PI" . 8511)
                             ("DOUBLE-STRUCK N-ARY SUMMATION" . 8512)
                             ("TURNED SANS-SERIF CAPITAL G" . 8513)
                             ("TURNED SANS-SERIF CAPITAL L" . 8514)
                             ("REVERSED SANS-SERIF CAPITAL L" . 8515)
                             ("TURNED SANS-SERIF CAPITAL Y" . 8516)
                             ("DOUBLE-STRUCK ITALIC CAPITAL D" . 8517)
                             ("DOUBLE-STRUCK ITALIC SMALL D" . 8518)
                             ("DOUBLE-STRUCK ITALIC SMALL E" . 8519)
                             ("DOUBLE-STRUCK ITALIC SMALL I" . 8520)
                             ("DOUBLE-STRUCK ITALIC SMALL J" . 8521)
                             ("PROPERTY LINE" . 8522)
                             ("TURNED AMPERSAND" . 8523)
                             ("VULGAR FRACTION ONE THIRD" . 8531)
                             ("VULGAR FRACTION TWO THIRDS" . 8532)
                             ("VULGAR FRACTION ONE FIFTH" . 8533)
                             ("VULGAR FRACTION TWO FIFTHS" . 8534)
                             ("VULGAR FRACTION THREE FIFTHS" . 8535)
                             ("VULGAR FRACTION FOUR FIFTHS" . 8536)
                             ("VULGAR FRACTION ONE SIXTH" . 8537)
                             ("VULGAR FRACTION FIVE SIXTHS" . 8538)
                             ("VULGAR FRACTION ONE EIGHTH" . 8539)
                             ("VULGAR FRACTION THREE EIGHTHS" . 8540)
                             ("VULGAR FRACTION FIVE EIGHTHS" . 8541)
                             ("VULGAR FRACTION SEVEN EIGHTHS" . 8542)
                             ("FRACTION NUMERATOR ONE" . 8543)
                             ("ROMAN NUMERAL ONE" . 8544)
                             ("ROMAN NUMERAL TWO" . 8545)
                             ("ROMAN NUMERAL THREE" . 8546)
                             ("ROMAN NUMERAL FOUR" . 8547)
                             ("ROMAN NUMERAL FIVE" . 8548)
                             ("ROMAN NUMERAL SIX" . 8549)
                             ("ROMAN NUMERAL SEVEN" . 8550)
                             ("ROMAN NUMERAL EIGHT" . 8551)
                             ("ROMAN NUMERAL NINE" . 8552)
                             ("ROMAN NUMERAL TEN" . 8553)
                             ("ROMAN NUMERAL ELEVEN" . 8554)
                             ("ROMAN NUMERAL TWELVE" . 8555)
                             ("ROMAN NUMERAL FIFTY" . 8556)
                             ("ROMAN NUMERAL ONE HUNDRED" . 8557)
                             ("ROMAN NUMERAL FIVE HUNDRED" . 8558)
                             ("ROMAN NUMERAL ONE THOUSAND" . 8559)
                             ("SMALL ROMAN NUMERAL ONE" . 8560)
                             ("SMALL ROMAN NUMERAL TWO" . 8561)
                             ("SMALL ROMAN NUMERAL THREE" . 8562)
                             ("SMALL ROMAN NUMERAL FOUR" . 8563)
                             ("SMALL ROMAN NUMERAL FIVE" . 8564)
                             ("SMALL ROMAN NUMERAL SIX" . 8565)
                             ("SMALL ROMAN NUMERAL SEVEN" . 8566)
                             ("SMALL ROMAN NUMERAL EIGHT" . 8567)
                             ("SMALL ROMAN NUMERAL NINE" . 8568)
                             ("SMALL ROMAN NUMERAL TEN" . 8569)
                             ("SMALL ROMAN NUMERAL ELEVEN" . 8570)
                             ("SMALL ROMAN NUMERAL TWELVE" . 8571)
                             ("SMALL ROMAN NUMERAL FIFTY" . 8572)
                             ("SMALL ROMAN NUMERAL ONE HUNDRED" . 8573)
                             ("SMALL ROMAN NUMERAL FIVE HUNDRED" . 8574)
                             ("SMALL ROMAN NUMERAL ONE THOUSAND" . 8575)
                             ("ROMAN NUMERAL ONE THOUSAND C D" . 8576)
                             ("ROMAN NUMERAL FIVE THOUSAND" . 8577)
                             ("ROMAN NUMERAL TEN THOUSAND" . 8578)
                             ("ROMAN NUMERAL REVERSED ONE HUNDRED" . 8579)
                             ("LEFTWARDS ARROW" . 8592)
                             ("UPWARDS ARROW" . 8593)
                             ("RIGHTWARDS ARROW" . 8594)
                             ("DOWNWARDS ARROW" . 8595)
                             ("LEFT RIGHT ARROW" . 8596)
                             ("UP DOWN ARROW" . 8597)
                             ("NORTH WEST ARROW" . 8598)
                             ("NORTH EAST ARROW" . 8599)
                             ("SOUTH EAST ARROW" . 8600)
                             ("SOUTH WEST ARROW" . 8601)
                             ("LEFTWARDS ARROW WITH STROKE" . 8602)
                             ("RIGHTWARDS ARROW WITH STROKE" . 8603)
                             ("LEFTWARDS WAVE ARROW" . 8604)
                             ("RIGHTWARDS WAVE ARROW" . 8605)
                             ("LEFTWARDS TWO HEADED ARROW" . 8606)
                             ("UPWARDS TWO HEADED ARROW" . 8607)
                             ("RIGHTWARDS TWO HEADED ARROW" . 8608)
                             ("DOWNWARDS TWO HEADED ARROW" . 8609)
                             ("LEFTWARDS ARROW WITH TAIL" . 8610)
                             ("RIGHTWARDS ARROW WITH TAIL" . 8611)
                             ("LEFTWARDS ARROW FROM BAR" . 8612)
                             ("UPWARDS ARROW FROM BAR" . 8613)
                             ("RIGHTWARDS ARROW FROM BAR" . 8614)
                             ("DOWNWARDS ARROW FROM BAR" . 8615)
                             ("UP DOWN ARROW WITH BASE" . 8616)
                             ("LEFTWARDS ARROW WITH HOOK" . 8617)
                             ("RIGHTWARDS ARROW WITH HOOK" . 8618)
                             ("LEFTWARDS ARROW WITH LOOP" . 8619)
                             ("RIGHTWARDS ARROW WITH LOOP" . 8620)
                             ("LEFT RIGHT WAVE ARROW" . 8621)
                             ("LEFT RIGHT ARROW WITH STROKE" . 8622)
                             ("DOWNWARDS ZIGZAG ARROW" . 8623)
                             ("UPWARDS ARROW WITH TIP LEFTWARDS" . 8624)
                             ("UPWARDS ARROW WITH TIP RIGHTWARDS" . 8625)
                             ("DOWNWARDS ARROW WITH TIP LEFTWARDS" . 8626)
                             ("DOWNWARDS ARROW WITH TIP RIGHTWARDS" . 8627)
                             ("RIGHTWARDS ARROW WITH CORNER DOWNWARDS" . 8628)
                             ("DOWNWARDS ARROW WITH CORNER LEFTWARDS" . 8629)
                             ("ANTICLOCKWISE TOP SEMICIRCLE ARROW" . 8630)
                             ("CLOCKWISE TOP SEMICIRCLE ARROW" . 8631)
                             ("NORTH WEST ARROW TO LONG BAR" . 8632)
                             ("LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR" . 8633)
                             ("ANTICLOCKWISE OPEN CIRCLE ARROW" . 8634)
                             ("CLOCKWISE OPEN CIRCLE ARROW" . 8635)
                             ("LEFTWARDS HARPOON WITH BARB UPWARDS" . 8636)
                             ("LEFTWARDS HARPOON WITH BARB DOWNWARDS" . 8637)
                             ("UPWARDS HARPOON WITH BARB RIGHTWARDS" . 8638)
                             ("UPWARDS HARPOON WITH BARB LEFTWARDS" . 8639)
                             ("RIGHTWARDS HARPOON WITH BARB UPWARDS" . 8640)
                             ("RIGHTWARDS HARPOON WITH BARB DOWNWARDS" . 8641)
                             ("DOWNWARDS HARPOON WITH BARB RIGHTWARDS" . 8642)
                             ("DOWNWARDS HARPOON WITH BARB LEFTWARDS" . 8643)
                             ("RIGHTWARDS ARROW OVER LEFTWARDS ARROW" . 8644)
                             ("UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW" . 8645)
                             ("LEFTWARDS ARROW OVER RIGHTWARDS ARROW" . 8646)
                             ("LEFTWARDS PAIRED ARROWS" . 8647)
                             ("UPWARDS PAIRED ARROWS" . 8648)
                             ("RIGHTWARDS PAIRED ARROWS" . 8649)
                             ("DOWNWARDS PAIRED ARROWS" . 8650)
                             ("LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON" . 8651)
                             ("RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON" . 8652)
                             ("LEFTWARDS DOUBLE ARROW WITH STROKE" . 8653)
                             ("LEFT RIGHT DOUBLE ARROW WITH STROKE" . 8654)
                             ("RIGHTWARDS DOUBLE ARROW WITH STROKE" . 8655)
                             ("LEFTWARDS DOUBLE ARROW" . 8656)
                             ("UPWARDS DOUBLE ARROW" . 8657)
                             ("RIGHTWARDS DOUBLE ARROW" . 8658)
                             ("DOWNWARDS DOUBLE ARROW" . 8659)
                             ("LEFT RIGHT DOUBLE ARROW" . 8660)
                             ("UP DOWN DOUBLE ARROW" . 8661)
                             ("NORTH WEST DOUBLE ARROW" . 8662)
                             ("NORTH EAST DOUBLE ARROW" . 8663)
                             ("SOUTH EAST DOUBLE ARROW" . 8664)
                             ("SOUTH WEST DOUBLE ARROW" . 8665)
                             ("LEFTWARDS TRIPLE ARROW" . 8666)
                             ("RIGHTWARDS TRIPLE ARROW" . 8667)
                             ("LEFTWARDS SQUIGGLE ARROW" . 8668)
                             ("RIGHTWARDS SQUIGGLE ARROW" . 8669)
                             ("UPWARDS ARROW WITH DOUBLE STROKE" . 8670)
                             ("DOWNWARDS ARROW WITH DOUBLE STROKE" . 8671)
                             ("LEFTWARDS DASHED ARROW" . 8672)
                             ("UPWARDS DASHED ARROW" . 8673)
                             ("RIGHTWARDS DASHED ARROW" . 8674)
                             ("DOWNWARDS DASHED ARROW" . 8675)
                             ("LEFTWARDS ARROW TO BAR" . 8676)
                             ("RIGHTWARDS ARROW TO BAR" . 8677)
                             ("LEFTWARDS WHITE ARROW" . 8678)
                             ("UPWARDS WHITE ARROW" . 8679)
                             ("RIGHTWARDS WHITE ARROW" . 8680)
                             ("DOWNWARDS WHITE ARROW" . 8681)
                             ("UPWARDS WHITE ARROW FROM BAR" . 8682)
                             ("UPWARDS WHITE ARROW ON PEDESTAL" . 8683)
                             ("UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR" . 8684)
                             ("UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR" . 8685)
                             ("UPWARDS WHITE DOUBLE ARROW" . 8686)
                             ("UPWARDS WHITE DOUBLE ARROW ON PEDESTAL" . 8687)
                             ("RIGHTWARDS WHITE ARROW FROM WALL" . 8688)
                             ("NORTH WEST ARROW TO CORNER" . 8689)
                             ("SOUTH EAST ARROW TO CORNER" . 8690)
                             ("UP DOWN WHITE ARROW" . 8691)
                             ("RIGHT ARROW WITH SMALL CIRCLE" . 8692)
                             ("DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW" . 8693)
                             ("THREE RIGHTWARDS ARROWS" . 8694)
                             ("LEFTWARDS ARROW WITH VERTICAL STROKE" . 8695)
                             ("RIGHTWARDS ARROW WITH VERTICAL STROKE" . 8696)
                             ("LEFT RIGHT ARROW WITH VERTICAL STROKE" . 8697)
                             ("LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE" . 8698)
                             ("RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE" . 8699)
                             ("LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE" . 8700)
                             ("LEFTWARDS OPEN-HEADED ARROW" . 8701)
                             ("RIGHTWARDS OPEN-HEADED ARROW" . 8702)
                             ("LEFT RIGHT OPEN-HEADED ARROW" . 8703)
                             ("FOR ALL" . 8704)
                             ("COMPLEMENT" . 8705)
                             ("PARTIAL DIFFERENTIAL" . 8706)
                             ("THERE EXISTS" . 8707)
                             ("THERE DOES NOT EXIST" . 8708)
                             ("EMPTY SET" . 8709)
                             ("INCREMENT" . 8710)
                             ("NABLA" . 8711)
                             ("ELEMENT OF" . 8712)
                             ("NOT AN ELEMENT OF" . 8713)
                             ("SMALL ELEMENT OF" . 8714)
                             ("CONTAINS AS MEMBER" . 8715)
                             ("DOES NOT CONTAIN AS MEMBER" . 8716)
                             ("SMALL CONTAINS AS MEMBER" . 8717)
                             ("END OF PROOF" . 8718)
                             ("N-ARY PRODUCT" . 8719)
                             ("N-ARY COPRODUCT" . 8720)
                             ("N-ARY SUMMATION" . 8721)
                             ("MINUS SIGN" . 8722)
                             ("MINUS-OR-PLUS SIGN" . 8723)
                             ("DOT PLUS" . 8724)
                             ("DIVISION SLASH" . 8725)
                             ("SET MINUS" . 8726)
                             ("ASTERISK OPERATOR" . 8727)
                             ("RING OPERATOR" . 8728)
                             ("BULLET OPERATOR" . 8729)
                             ("SQUARE ROOT" . 8730)
                             ("CUBE ROOT" . 8731)
                             ("FOURTH ROOT" . 8732)
                             ("PROPORTIONAL TO" . 8733)
                             ("INFINITY" . 8734)
                             ("RIGHT ANGLE" . 8735)
                             ("ANGLE" . 8736)
                             ("MEASURED ANGLE" . 8737)
                             ("SPHERICAL ANGLE" . 8738)
                             ("DIVIDES" . 8739)
                             ("DOES NOT DIVIDE" . 8740)
                             ("PARALLEL TO" . 8741)
                             ("NOT PARALLEL TO" . 8742)
                             ("LOGICAL AND" . 8743)
                             ("LOGICAL OR" . 8744)
                             ("INTERSECTION" . 8745)
                             ("UNION" . 8746)
                             ("INTEGRAL" . 8747)
                             ("DOUBLE INTEGRAL" . 8748)
                             ("TRIPLE INTEGRAL" . 8749)
                             ("CONTOUR INTEGRAL" . 8750)
                             ("SURFACE INTEGRAL" . 8751)
                             ("VOLUME INTEGRAL" . 8752)
                             ("CLOCKWISE INTEGRAL" . 8753)
                             ("CLOCKWISE CONTOUR INTEGRAL" . 8754)
                             ("ANTICLOCKWISE CONTOUR INTEGRAL" . 8755)
                             ("THEREFORE" . 8756)
                             ("BECAUSE" . 8757)
                             ("RATIO" . 8758)
                             ("PROPORTION" . 8759)
                             ("DOT MINUS" . 8760)
                             ("EXCESS" . 8761)
                             ("GEOMETRIC PROPORTION" . 8762)
                             ("HOMOTHETIC" . 8763)
                             ("TILDE OPERATOR" . 8764)
                             ("REVERSED TILDE" . 8765)
                             ("INVERTED LAZY S" . 8766)
                             ("SINE WAVE" . 8767)
                             ("WREATH PRODUCT" . 8768)
                             ("NOT TILDE" . 8769)
                             ("MINUS TILDE" . 8770)
                             ("ASYMPTOTICALLY EQUAL TO" . 8771)
                             ("NOT ASYMPTOTICALLY EQUAL TO" . 8772)
                             ("APPROXIMATELY EQUAL TO" . 8773)
                             ("APPROXIMATELY BUT NOT ACTUALLY EQUAL TO" . 8774)
                             ("NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO" . 8775)
                             ("ALMOST EQUAL TO" . 8776)
                             ("NOT ALMOST EQUAL TO" . 8777)
                             ("ALMOST EQUAL OR EQUAL TO" . 8778)
                             ("TRIPLE TILDE" . 8779)
                             ("ALL EQUAL TO" . 8780)
                             ("EQUIVALENT TO" . 8781)
                             ("GEOMETRICALLY EQUIVALENT TO" . 8782)
                             ("DIFFERENCE BETWEEN" . 8783)
                             ("APPROACHES THE LIMIT" . 8784)
                             ("GEOMETRICALLY EQUAL TO" . 8785)
                             ("APPROXIMATELY EQUAL TO OR THE IMAGE OF" . 8786)
                             ("IMAGE OF OR APPROXIMATELY EQUAL TO" . 8787)
                             ("COLON EQUALS" . 8788)
                             ("EQUALS COLON" . 8789)
                             ("RING IN EQUAL TO" . 8790)
                             ("RING EQUAL TO" . 8791)
                             ("CORRESPONDS TO" . 8792)
                             ("ESTIMATES" . 8793)
                             ("EQUIANGULAR TO" . 8794)
                             ("STAR EQUALS" . 8795)
                             ("DELTA EQUAL TO" . 8796)
                             ("EQUAL TO BY DEFINITION" . 8797)
                             ("MEASURED BY" . 8798)
                             ("QUESTIONED EQUAL TO" . 8799)
                             ("NOT EQUAL TO" . 8800)
                             ("IDENTICAL TO" . 8801)
                             ("NOT IDENTICAL TO" . 8802)
                             ("STRICTLY EQUIVALENT TO" . 8803)
                             ("LESS-THAN OR EQUAL TO" . 8804)
                             ("GREATER-THAN OR EQUAL TO" . 8805)
                             ("LESS-THAN OVER EQUAL TO" . 8806)
                             ("GREATER-THAN OVER EQUAL TO" . 8807)
                             ("LESS-THAN BUT NOT EQUAL TO" . 8808)
                             ("GREATER-THAN BUT NOT EQUAL TO" . 8809)
                             ("MUCH LESS-THAN" . 8810)
                             ("MUCH GREATER-THAN" . 8811)
                             ("BETWEEN" . 8812)
                             ("NOT EQUIVALENT TO" . 8813)
                             ("NOT LESS-THAN" . 8814)
                             ("NOT GREATER-THAN" . 8815)
                             ("NEITHER LESS-THAN NOR EQUAL TO" . 8816)
                             ("NEITHER GREATER-THAN NOR EQUAL TO" . 8817)
                             ("LESS-THAN OR EQUIVALENT TO" . 8818)
                             ("GREATER-THAN OR EQUIVALENT TO" . 8819)
                             ("NEITHER LESS-THAN NOR EQUIVALENT TO" . 8820)
                             ("NEITHER GREATER-THAN NOR EQUIVALENT TO" . 8821)
                             ("LESS-THAN OR GREATER-THAN" . 8822)
                             ("GREATER-THAN OR LESS-THAN" . 8823)
                             ("NEITHER LESS-THAN NOR GREATER-THAN" . 8824)
                             ("NEITHER GREATER-THAN NOR LESS-THAN" . 8825)
                             ("PRECEDES" . 8826)
                             ("SUCCEEDS" . 8827)
                             ("PRECEDES OR EQUAL TO" . 8828)
                             ("SUCCEEDS OR EQUAL TO" . 8829)
                             ("PRECEDES OR EQUIVALENT TO" . 8830)
                             ("SUCCEEDS OR EQUIVALENT TO" . 8831)
                             ("DOES NOT PRECEDE" . 8832)
                             ("DOES NOT SUCCEED" . 8833)
                             ("SUBSET OF" . 8834)
                             ("SUPERSET OF" . 8835)
                             ("NOT A SUBSET OF" . 8836)
                             ("NOT A SUPERSET OF" . 8837)
                             ("SUBSET OF OR EQUAL TO" . 8838)
                             ("SUPERSET OF OR EQUAL TO" . 8839)
                             ("NEITHER A SUBSET OF NOR EQUAL TO" . 8840)
                             ("NEITHER A SUPERSET OF NOR EQUAL TO" . 8841)
                             ("SUBSET OF WITH NOT EQUAL TO" . 8842)
                             ("SUPERSET OF WITH NOT EQUAL TO" . 8843)
                             ("MULTISET" . 8844)
                             ("MULTISET MULTIPLICATION" . 8845)
                             ("MULTISET UNION" . 8846)
                             ("SQUARE IMAGE OF" . 8847)
                             ("SQUARE ORIGINAL OF" . 8848)
                             ("SQUARE IMAGE OF OR EQUAL TO" . 8849)
                             ("SQUARE ORIGINAL OF OR EQUAL TO" . 8850)
                             ("SQUARE CAP" . 8851)
                             ("SQUARE CUP" . 8852)
                             ("CIRCLED PLUS" . 8853)
                             ("CIRCLED MINUS" . 8854)
                             ("CIRCLED TIMES" . 8855)
                             ("CIRCLED DIVISION SLASH" . 8856)
                             ("CIRCLED DOT OPERATOR" . 8857)
                             ("CIRCLED RING OPERATOR" . 8858)
                             ("CIRCLED ASTERISK OPERATOR" . 8859)
                             ("CIRCLED EQUALS" . 8860)
                             ("CIRCLED DASH" . 8861)
                             ("SQUARED PLUS" . 8862)
                             ("SQUARED MINUS" . 8863)
                             ("SQUARED TIMES" . 8864)
                             ("SQUARED DOT OPERATOR" . 8865)
                             ("RIGHT TACK" . 8866)
                             ("LEFT TACK" . 8867)
                             ("DOWN TACK" . 8868)
                             ("UP TACK" . 8869)
                             ("ASSERTION" . 8870)
                             ("MODELS" . 8871)
                             ("TRUE" . 8872)
                             ("FORCES" . 8873)
                             ("TRIPLE VERTICAL BAR RIGHT TURNSTILE" . 8874)
                             ("DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" . 8875)
                             ("DOES NOT PROVE" . 8876)
                             ("NOT TRUE" . 8877)
                             ("DOES NOT FORCE" . 8878)
                             ("NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE" . 8879)
                             ("PRECEDES UNDER RELATION" . 8880)
                             ("SUCCEEDS UNDER RELATION" . 8881)
                             ("NORMAL SUBGROUP OF" . 8882)
                             ("CONTAINS AS NORMAL SUBGROUP" . 8883)
                             ("NORMAL SUBGROUP OF OR EQUAL TO" . 8884)
                             ("CONTAINS AS NORMAL SUBGROUP OR EQUAL TO" . 8885)
                             ("ORIGINAL OF" . 8886)
                             ("IMAGE OF" . 8887)
                             ("MULTIMAP" . 8888)
                             ("HERMITIAN CONJUGATE MATRIX" . 8889)
                             ("INTERCALATE" . 8890)
                             ("XOR" . 8891)
                             ("NAND" . 8892)
                             ("NOR" . 8893)
                             ("RIGHT ANGLE WITH ARC" . 8894)
                             ("RIGHT TRIANGLE" . 8895)
                             ("N-ARY LOGICAL AND" . 8896)
                             ("N-ARY LOGICAL OR" . 8897)
                             ("N-ARY INTERSECTION" . 8898)
                             ("N-ARY UNION" . 8899)
                             ("DIAMOND OPERATOR" . 8900)
                             ("DOT OPERATOR" . 8901)
                             ("STAR OPERATOR" . 8902)
                             ("DIVISION TIMES" . 8903)
                             ("BOWTIE" . 8904)
                             ("LEFT NORMAL FACTOR SEMIDIRECT PRODUCT" . 8905)
                             ("RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT" . 8906)
                             ("LEFT SEMIDIRECT PRODUCT" . 8907)
                             ("RIGHT SEMIDIRECT PRODUCT" . 8908)
                             ("REVERSED TILDE EQUALS" . 8909)
                             ("CURLY LOGICAL OR" . 8910)
                             ("CURLY LOGICAL AND" . 8911)
                             ("DOUBLE SUBSET" . 8912)
                             ("DOUBLE SUPERSET" . 8913)
                             ("DOUBLE INTERSECTION" . 8914)
                             ("DOUBLE UNION" . 8915)
                             ("PITCHFORK" . 8916)
                             ("EQUAL AND PARALLEL TO" . 8917)
                             ("LESS-THAN WITH DOT" . 8918)
                             ("GREATER-THAN WITH DOT" . 8919)
                             ("VERY MUCH LESS-THAN" . 8920)
                             ("VERY MUCH GREATER-THAN" . 8921)
                             ("LESS-THAN EQUAL TO OR GREATER-THAN" . 8922)
                             ("GREATER-THAN EQUAL TO OR LESS-THAN" . 8923)
                             ("EQUAL TO OR LESS-THAN" . 8924)
                             ("EQUAL TO OR GREATER-THAN" . 8925)
                             ("EQUAL TO OR PRECEDES" . 8926)
                             ("EQUAL TO OR SUCCEEDS" . 8927)
                             ("DOES NOT PRECEDE OR EQUAL" . 8928)
                             ("DOES NOT SUCCEED OR EQUAL" . 8929)
                             ("NOT SQUARE IMAGE OF OR EQUAL TO" . 8930)
                             ("NOT SQUARE ORIGINAL OF OR EQUAL TO" . 8931)
                             ("SQUARE IMAGE OF OR NOT EQUAL TO" . 8932)
                             ("SQUARE ORIGINAL OF OR NOT EQUAL TO" . 8933)
                             ("LESS-THAN BUT NOT EQUIVALENT TO" . 8934)
                             ("GREATER-THAN BUT NOT EQUIVALENT TO" . 8935)
                             ("PRECEDES BUT NOT EQUIVALENT TO" . 8936)
                             ("SUCCEEDS BUT NOT EQUIVALENT TO" . 8937)
                             ("NOT NORMAL SUBGROUP OF" . 8938)
                             ("DOES NOT CONTAIN AS NORMAL SUBGROUP" . 8939)
                             ("NOT NORMAL SUBGROUP OF OR EQUAL TO" . 8940)
                             ("DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL" . 8941)
                             ("VERTICAL ELLIPSIS" . 8942)
                             ("MIDLINE HORIZONTAL ELLIPSIS" . 8943)
                             ("UP RIGHT DIAGONAL ELLIPSIS" . 8944)
                             ("DOWN RIGHT DIAGONAL ELLIPSIS" . 8945)
                             ("ELEMENT OF WITH LONG HORIZONTAL STROKE" . 8946)
                             ("ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . 8947)
                             ("SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . 8948)
                             ("ELEMENT OF WITH DOT ABOVE" . 8949)
                             ("ELEMENT OF WITH OVERBAR" . 8950)
                             ("SMALL ELEMENT OF WITH OVERBAR" . 8951)
                             ("ELEMENT OF WITH UNDERBAR" . 8952)
                             ("ELEMENT OF WITH TWO HORIZONTAL STROKES" . 8953)
                             ("CONTAINS WITH LONG HORIZONTAL STROKE" . 8954)
                             ("CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . 8955)
                             ("SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE" . 8956)
                             ("CONTAINS WITH OVERBAR" . 8957)
                             ("SMALL CONTAINS WITH OVERBAR" . 8958)
                             ("Z NOTATION BAG MEMBERSHIP" . 8959)
                             ("DIAMETER SIGN" . 8960)
                             ("ELECTRIC ARROW" . 8961)
                             ("HOUSE" . 8962)
                             ("UP ARROWHEAD" . 8963)
                             ("DOWN ARROWHEAD" . 8964)
                             ("PROJECTIVE" . 8965)
                             ("PERSPECTIVE" . 8966)
                             ("WAVY LINE" . 8967)
                             ("LEFT CEILING" . 8968)
                             ("RIGHT CEILING" . 8969)
                             ("LEFT FLOOR" . 8970)
                             ("RIGHT FLOOR" . 8971)
                             ("BOTTOM RIGHT CROP" . 8972)
                             ("BOTTOM LEFT CROP" . 8973)
                             ("TOP RIGHT CROP" . 8974)
                             ("TOP LEFT CROP" . 8975)
                             ("REVERSED NOT SIGN" . 8976)
                             ("SQUARE LOZENGE" . 8977)
                             ("ARC" . 8978)
                             ("SEGMENT" . 8979)
                             ("SECTOR" . 8980)
                             ("TELEPHONE RECORDER" . 8981)
                             ("POSITION INDICATOR" . 8982)
                             ("VIEWDATA SQUARE" . 8983)
                             ("PLACE OF INTEREST SIGN" . 8984)
                             ("TURNED NOT SIGN" . 8985)
                             ("WATCH" . 8986)
                             ("HOURGLASS" . 8987)
                             ("TOP LEFT CORNER" . 8988)
                             ("TOP RIGHT CORNER" . 8989)
                             ("BOTTOM LEFT CORNER" . 8990)
                             ("BOTTOM RIGHT CORNER" . 8991)
                             ("TOP HALF INTEGRAL" . 8992)
                             ("BOTTOM HALF INTEGRAL" . 8993)
                             ("FROWN" . 8994)
                             ("SMILE" . 8995)
                             ("UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS" . 8996)
                             ("OPTION KEY" . 8997)
                             ("ERASE TO THE RIGHT" . 8998)
                             ("X IN A RECTANGLE BOX" . 8999)
                             ("KEYBOARD" . 9000)
                             ("LEFT-POINTING ANGLE BRACKET" . 9001)
                             ("RIGHT-POINTING ANGLE BRACKET" . 9002)
                             ("ERASE TO THE LEFT" . 9003)
                             ("BENZENE RING" . 9004)
                             ("CYLINDRICITY" . 9005)
                             ("ALL AROUND-PROFILE" . 9006)
                             ("SYMMETRY" . 9007)
                             ("TOTAL RUNOUT" . 9008)
                             ("DIMENSION ORIGIN" . 9009)
                             ("CONICAL TAPER" . 9010)
                             ("SLOPE" . 9011)
                             ("COUNTERBORE" . 9012)
                             ("COUNTERSINK" . 9013)
                             ("APL FUNCTIONAL SYMBOL I-BEAM" . 9014)
                             ("APL FUNCTIONAL SYMBOL SQUISH QUAD" . 9015)
                             ("APL FUNCTIONAL SYMBOL QUAD EQUAL" . 9016)
                             ("APL FUNCTIONAL SYMBOL QUAD DIVIDE" . 9017)
                             ("APL FUNCTIONAL SYMBOL QUAD DIAMOND" . 9018)
                             ("APL FUNCTIONAL SYMBOL QUAD JOT" . 9019)
                             ("APL FUNCTIONAL SYMBOL QUAD CIRCLE" . 9020)
                             ("APL FUNCTIONAL SYMBOL CIRCLE STILE" . 9021)
                             ("APL FUNCTIONAL SYMBOL CIRCLE JOT" . 9022)
                             ("APL FUNCTIONAL SYMBOL SLASH BAR" . 9023)
                             ("APL FUNCTIONAL SYMBOL BACKSLASH BAR" . 9024)
                             ("APL FUNCTIONAL SYMBOL QUAD SLASH" . 9025)
                             ("APL FUNCTIONAL SYMBOL QUAD BACKSLASH" . 9026)
                             ("APL FUNCTIONAL SYMBOL QUAD LESS-THAN" . 9027)
                             ("APL FUNCTIONAL SYMBOL QUAD GREATER-THAN" . 9028)
                             ("APL FUNCTIONAL SYMBOL LEFTWARDS VANE" . 9029)
                             ("APL FUNCTIONAL SYMBOL RIGHTWARDS VANE" . 9030)
                             ("APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW" . 9031)
                             ("APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW" . 9032)
                             ("APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH" . 9033)
                             ("APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR" . 9034)
                             ("APL FUNCTIONAL SYMBOL DELTA STILE" . 9035)
                             ("APL FUNCTIONAL SYMBOL QUAD DOWN CARET" . 9036)
                             ("APL FUNCTIONAL SYMBOL QUAD DELTA" . 9037)
                             ("APL FUNCTIONAL SYMBOL DOWN TACK JOT" . 9038)
                             ("APL FUNCTIONAL SYMBOL UPWARDS VANE" . 9039)
                             ("APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW" . 9040)
                             ("APL FUNCTIONAL SYMBOL UP TACK OVERBAR" . 9041)
                             ("APL FUNCTIONAL SYMBOL DEL STILE" . 9042)
                             ("APL FUNCTIONAL SYMBOL QUAD UP CARET" . 9043)
                             ("APL FUNCTIONAL SYMBOL QUAD DEL" . 9044)
                             ("APL FUNCTIONAL SYMBOL UP TACK JOT" . 9045)
                             ("APL FUNCTIONAL SYMBOL DOWNWARDS VANE" . 9046)
                             ("APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW" . 9047)
                             ("APL FUNCTIONAL SYMBOL QUOTE UNDERBAR" . 9048)
                             ("APL FUNCTIONAL SYMBOL DELTA UNDERBAR" . 9049)
                             ("APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR" . 9050)
                             ("APL FUNCTIONAL SYMBOL JOT UNDERBAR" . 9051)
                             ("APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR" . 9052)
                             ("APL FUNCTIONAL SYMBOL UP SHOE JOT" . 9053)
                             ("APL FUNCTIONAL SYMBOL QUOTE QUAD" . 9054)
                             ("APL FUNCTIONAL SYMBOL CIRCLE STAR" . 9055)
                             ("APL FUNCTIONAL SYMBOL QUAD COLON" . 9056)
                             ("APL FUNCTIONAL SYMBOL UP TACK DIAERESIS" . 9057)
                             ("APL FUNCTIONAL SYMBOL DEL DIAERESIS" . 9058)
                             ("APL FUNCTIONAL SYMBOL STAR DIAERESIS" . 9059)
                             ("APL FUNCTIONAL SYMBOL JOT DIAERESIS" . 9060)
                             ("APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS" . 9061)
                             ("APL FUNCTIONAL SYMBOL DOWN SHOE STILE" . 9062)
                             ("APL FUNCTIONAL SYMBOL LEFT SHOE STILE" . 9063)
                             ("APL FUNCTIONAL SYMBOL TILDE DIAERESIS" . 9064)
                             ("APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS" . 9065)
                             ("APL FUNCTIONAL SYMBOL COMMA BAR" . 9066)
                             ("APL FUNCTIONAL SYMBOL DEL TILDE" . 9067)
                             ("APL FUNCTIONAL SYMBOL ZILDE" . 9068)
                             ("APL FUNCTIONAL SYMBOL STILE TILDE" . 9069)
                             ("APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR" . 9070)
                             ("APL FUNCTIONAL SYMBOL QUAD NOT EQUAL" . 9071)
                             ("APL FUNCTIONAL SYMBOL QUAD QUESTION" . 9072)
                             ("APL FUNCTIONAL SYMBOL DOWN CARET TILDE" . 9073)
                             ("APL FUNCTIONAL SYMBOL UP CARET TILDE" . 9074)
                             ("APL FUNCTIONAL SYMBOL IOTA" . 9075)
                             ("APL FUNCTIONAL SYMBOL RHO" . 9076)
                             ("APL FUNCTIONAL SYMBOL OMEGA" . 9077)
                             ("APL FUNCTIONAL SYMBOL ALPHA UNDERBAR" . 9078)
                             ("APL FUNCTIONAL SYMBOL EPSILON UNDERBAR" . 9079)
                             ("APL FUNCTIONAL SYMBOL IOTA UNDERBAR" . 9080)
                             ("APL FUNCTIONAL SYMBOL OMEGA UNDERBAR" . 9081)
                             ("APL FUNCTIONAL SYMBOL ALPHA" . 9082)
                             ("NOT CHECK MARK" . 9083)
                             ("RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW" . 9084)
                             ("SHOULDERED OPEN BOX" . 9085)
                             ("BELL SYMBOL" . 9086)
                             ("VERTICAL LINE WITH MIDDLE DOT" . 9087)
                             ("INSERTION SYMBOL" . 9088)
                             ("CONTINUOUS UNDERLINE SYMBOL" . 9089)
                             ("DISCONTINUOUS UNDERLINE SYMBOL" . 9090)
                             ("EMPHASIS SYMBOL" . 9091)
                             ("COMPOSITION SYMBOL" . 9092)
                             ("WHITE SQUARE WITH CENTRE VERTICAL LINE" . 9093)
                             ("ENTER SYMBOL" . 9094)
                             ("ALTERNATIVE KEY SYMBOL" . 9095)
                             ("HELM SYMBOL" . 9096)
                             ("CIRCLED HORIZONTAL BAR WITH NOTCH" . 9097)
                             ("CIRCLED TRIANGLE DOWN" . 9098)
                             ("BROKEN CIRCLE WITH NORTHWEST ARROW" . 9099)
                             ("UNDO SYMBOL" . 9100)
                             ("MONOSTABLE SYMBOL" . 9101)
                             ("HYSTERESIS SYMBOL" . 9102)
                             ("OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL" . 9103)
                             ("OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL" . 9104)
                             ("PASSIVE-PULL-DOWN-OUTPUT SYMBOL" . 9105)
                             ("PASSIVE-PULL-UP-OUTPUT SYMBOL" . 9106)
                             ("DIRECT CURRENT SYMBOL FORM TWO" . 9107)
                             ("SOFTWARE-FUNCTION SYMBOL" . 9108)
                             ("APL FUNCTIONAL SYMBOL QUAD" . 9109)
                             ("DECIMAL SEPARATOR KEY SYMBOL" . 9110)
                             ("PREVIOUS PAGE" . 9111)
                             ("NEXT PAGE" . 9112)
                             ("PRINT SCREEN SYMBOL" . 9113)
                             ("CLEAR SCREEN SYMBOL" . 9114)
                             ("LEFT PARENTHESIS UPPER HOOK" . 9115)
                             ("LEFT PARENTHESIS EXTENSION" . 9116)
                             ("LEFT PARENTHESIS LOWER HOOK" . 9117)
                             ("RIGHT PARENTHESIS UPPER HOOK" . 9118)
                             ("RIGHT PARENTHESIS EXTENSION" . 9119)
                             ("RIGHT PARENTHESIS LOWER HOOK" . 9120)
                             ("LEFT SQUARE BRACKET UPPER CORNER" . 9121)
                             ("LEFT SQUARE BRACKET EXTENSION" . 9122)
                             ("LEFT SQUARE BRACKET LOWER CORNER" . 9123)
                             ("RIGHT SQUARE BRACKET UPPER CORNER" . 9124)
                             ("RIGHT SQUARE BRACKET EXTENSION" . 9125)
                             ("RIGHT SQUARE BRACKET LOWER CORNER" . 9126)
                             ("LEFT CURLY BRACKET UPPER HOOK" . 9127)
                             ("LEFT CURLY BRACKET MIDDLE PIECE" . 9128)
                             ("LEFT CURLY BRACKET LOWER HOOK" . 9129)
                             ("CURLY BRACKET EXTENSION" . 9130)
                             ("RIGHT CURLY BRACKET UPPER HOOK" . 9131)
                             ("RIGHT CURLY BRACKET MIDDLE PIECE" . 9132)
                             ("RIGHT CURLY BRACKET LOWER HOOK" . 9133)
                             ("INTEGRAL EXTENSION" . 9134)
                             ("HORIZONTAL LINE EXTENSION" . 9135)
                             ("UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION" . 9136)
                             ("UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION" . 9137)
                             ("SUMMATION TOP" . 9138)
                             ("SUMMATION BOTTOM" . 9139)
                             ("TOP SQUARE BRACKET" . 9140)
                             ("BOTTOM SQUARE BRACKET" . 9141)
                             ("BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET" . 9142)
                             ("RADICAL SYMBOL BOTTOM" . 9143)
                             ("LEFT VERTICAL BOX LINE" . 9144)
                             ("RIGHT VERTICAL BOX LINE" . 9145)
                             ("HORIZONTAL SCAN LINE-1" . 9146)
                             ("HORIZONTAL SCAN LINE-3" . 9147)
                             ("HORIZONTAL SCAN LINE-7" . 9148)
                             ("HORIZONTAL SCAN LINE-9" . 9149)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT" . 9150)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT" . 9151)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE" . 9152)
                             ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE" . 9153)
                             ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE" . 9154)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE" . 9155)
                             ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE" . 9156)
                             ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE" . 9157)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE" . 9158)
                             ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE" . 9159)
                             ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE" . 9160)
                             ("DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL" . 9161)
                             ("DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL" . 9162)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT" . 9163)
                             ("DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT" . 9164)
                             ("SQUARE FOOT" . 9165)
                             ("RETURN SYMBOL" . 9166)
                             ("SYMBOL FOR NULL" . 9216)
                             ("SYMBOL FOR START OF HEADING" . 9217)
                             ("SYMBOL FOR START OF TEXT" . 9218)
                             ("SYMBOL FOR END OF TEXT" . 9219)
                             ("SYMBOL FOR END OF TRANSMISSION" . 9220)
                             ("SYMBOL FOR ENQUIRY" . 9221)
                             ("SYMBOL FOR ACKNOWLEDGE" . 9222)
                             ("SYMBOL FOR BELL" . 9223)
                             ("SYMBOL FOR BACKSPACE" . 9224)
                             ("SYMBOL FOR HORIZONTAL TABULATION" . 9225)
                             ("SYMBOL FOR LINE FEED" . 9226)
                             ("SYMBOL FOR VERTICAL TABULATION" . 9227)
                             ("SYMBOL FOR FORM FEED" . 9228)
                             ("SYMBOL FOR CARRIAGE RETURN" . 9229)
                             ("SYMBOL FOR SHIFT OUT" . 9230)
                             ("SYMBOL FOR SHIFT IN" . 9231)
                             ("SYMBOL FOR DATA LINK ESCAPE" . 9232)
                             ("SYMBOL FOR DEVICE CONTROL ONE" . 9233)
                             ("SYMBOL FOR DEVICE CONTROL TWO" . 9234)
                             ("SYMBOL FOR DEVICE CONTROL THREE" . 9235)
                             ("SYMBOL FOR DEVICE CONTROL FOUR" . 9236)
                             ("SYMBOL FOR NEGATIVE ACKNOWLEDGE" . 9237)
                             ("SYMBOL FOR SYNCHRONOUS IDLE" . 9238)
                             ("SYMBOL FOR END OF TRANSMISSION BLOCK" . 9239)
                             ("SYMBOL FOR CANCEL" . 9240)
                             ("SYMBOL FOR END OF MEDIUM" . 9241)
                             ("SYMBOL FOR SUBSTITUTE" . 9242)
                             ("SYMBOL FOR ESCAPE" . 9243)
                             ("SYMBOL FOR FILE SEPARATOR" . 9244)
                             ("SYMBOL FOR GROUP SEPARATOR" . 9245)
                             ("SYMBOL FOR RECORD SEPARATOR" . 9246)
                             ("SYMBOL FOR UNIT SEPARATOR" . 9247)
                             ("SYMBOL FOR SPACE" . 9248)
                             ("SYMBOL FOR DELETE" . 9249)
                             ("BLANK SYMBOL" . 9250)
                             ("OPEN BOX" . 9251)
                             ("SYMBOL FOR NEWLINE" . 9252)
                             ("SYMBOL FOR DELETE FORM TWO" . 9253)
                             ("SYMBOL FOR SUBSTITUTE FORM TWO" . 9254)
                             ("OCR HOOK" . 9280)
                             ("OCR CHAIR" . 9281)
                             ("OCR FORK" . 9282)
                             ("OCR INVERTED FORK" . 9283)
                             ("OCR BELT BUCKLE" . 9284)
                             ("OCR BOW TIE" . 9285)
                             ("OCR BRANCH BANK IDENTIFICATION" . 9286)
                             ("OCR AMOUNT OF CHECK" . 9287)
                             ("OCR DASH" . 9288)
                             ("OCR CUSTOMER ACCOUNT NUMBER" . 9289)
                             ("OCR DOUBLE BACKSLASH" . 9290)
                             ("CIRCLED DIGIT ONE" . 9312)
                             ("CIRCLED DIGIT TWO" . 9313)
                             ("CIRCLED DIGIT THREE" . 9314)
                             ("CIRCLED DIGIT FOUR" . 9315)
                             ("CIRCLED DIGIT FIVE" . 9316)
                             ("CIRCLED DIGIT SIX" . 9317)
                             ("CIRCLED DIGIT SEVEN" . 9318)
                             ("CIRCLED DIGIT EIGHT" . 9319)
                             ("CIRCLED DIGIT NINE" . 9320)
                             ("CIRCLED NUMBER TEN" . 9321)
                             ("CIRCLED NUMBER ELEVEN" . 9322)
                             ("CIRCLED NUMBER TWELVE" . 9323)
                             ("CIRCLED NUMBER THIRTEEN" . 9324)
                             ("CIRCLED NUMBER FOURTEEN" . 9325)
                             ("CIRCLED NUMBER FIFTEEN" . 9326)
                             ("CIRCLED NUMBER SIXTEEN" . 9327)
                             ("CIRCLED NUMBER SEVENTEEN" . 9328)
                             ("CIRCLED NUMBER EIGHTEEN" . 9329)
                             ("CIRCLED NUMBER NINETEEN" . 9330)
                             ("CIRCLED NUMBER TWENTY" . 9331)
                             ("PARENTHESIZED DIGIT ONE" . 9332)
                             ("PARENTHESIZED DIGIT TWO" . 9333)
                             ("PARENTHESIZED DIGIT THREE" . 9334)
                             ("PARENTHESIZED DIGIT FOUR" . 9335)
                             ("PARENTHESIZED DIGIT FIVE" . 9336)
                             ("PARENTHESIZED DIGIT SIX" . 9337)
                             ("PARENTHESIZED DIGIT SEVEN" . 9338)
                             ("PARENTHESIZED DIGIT EIGHT" . 9339)
                             ("PARENTHESIZED DIGIT NINE" . 9340)
                             ("PARENTHESIZED NUMBER TEN" . 9341)
                             ("PARENTHESIZED NUMBER ELEVEN" . 9342)
                             ("PARENTHESIZED NUMBER TWELVE" . 9343)
                             ("PARENTHESIZED NUMBER THIRTEEN" . 9344)
                             ("PARENTHESIZED NUMBER FOURTEEN" . 9345)
                             ("PARENTHESIZED NUMBER FIFTEEN" . 9346)
                             ("PARENTHESIZED NUMBER SIXTEEN" . 9347)
                             ("PARENTHESIZED NUMBER SEVENTEEN" . 9348)
                             ("PARENTHESIZED NUMBER EIGHTEEN" . 9349)
                             ("PARENTHESIZED NUMBER NINETEEN" . 9350)
                             ("PARENTHESIZED NUMBER TWENTY" . 9351)
                             ("DIGIT ONE FULL STOP" . 9352)
                             ("DIGIT TWO FULL STOP" . 9353)
                             ("DIGIT THREE FULL STOP" . 9354)
                             ("DIGIT FOUR FULL STOP" . 9355)
                             ("DIGIT FIVE FULL STOP" . 9356)
                             ("DIGIT SIX FULL STOP" . 9357)
                             ("DIGIT SEVEN FULL STOP" . 9358)
                             ("DIGIT EIGHT FULL STOP" . 9359)
                             ("DIGIT NINE FULL STOP" . 9360)
                             ("NUMBER TEN FULL STOP" . 9361)
                             ("NUMBER ELEVEN FULL STOP" . 9362)
                             ("NUMBER TWELVE FULL STOP" . 9363)
                             ("NUMBER THIRTEEN FULL STOP" . 9364)
                             ("NUMBER FOURTEEN FULL STOP" . 9365)
                             ("NUMBER FIFTEEN FULL STOP" . 9366)
                             ("NUMBER SIXTEEN FULL STOP" . 9367)
                             ("NUMBER SEVENTEEN FULL STOP" . 9368)
                             ("NUMBER EIGHTEEN FULL STOP" . 9369)
                             ("NUMBER NINETEEN FULL STOP" . 9370)
                             ("NUMBER TWENTY FULL STOP" . 9371)
                             ("PARENTHESIZED LATIN SMALL LETTER A" . 9372)
                             ("PARENTHESIZED LATIN SMALL LETTER B" . 9373)
                             ("PARENTHESIZED LATIN SMALL LETTER C" . 9374)
                             ("PARENTHESIZED LATIN SMALL LETTER D" . 9375)
                             ("PARENTHESIZED LATIN SMALL LETTER E" . 9376)
                             ("PARENTHESIZED LATIN SMALL LETTER F" . 9377)
                             ("PARENTHESIZED LATIN SMALL LETTER G" . 9378)
                             ("PARENTHESIZED LATIN SMALL LETTER H" . 9379)
                             ("PARENTHESIZED LATIN SMALL LETTER I" . 9380)
                             ("PARENTHESIZED LATIN SMALL LETTER J" . 9381)
                             ("PARENTHESIZED LATIN SMALL LETTER K" . 9382)
                             ("PARENTHESIZED LATIN SMALL LETTER L" . 9383)
                             ("PARENTHESIZED LATIN SMALL LETTER M" . 9384)
                             ("PARENTHESIZED LATIN SMALL LETTER N" . 9385)
                             ("PARENTHESIZED LATIN SMALL LETTER O" . 9386)
                             ("PARENTHESIZED LATIN SMALL LETTER P" . 9387)
                             ("PARENTHESIZED LATIN SMALL LETTER Q" . 9388)
                             ("PARENTHESIZED LATIN SMALL LETTER R" . 9389)
                             ("PARENTHESIZED LATIN SMALL LETTER S" . 9390)
                             ("PARENTHESIZED LATIN SMALL LETTER T" . 9391)
                             ("PARENTHESIZED LATIN SMALL LETTER U" . 9392)
                             ("PARENTHESIZED LATIN SMALL LETTER V" . 9393)
                             ("PARENTHESIZED LATIN SMALL LETTER W" . 9394)
                             ("PARENTHESIZED LATIN SMALL LETTER X" . 9395)
                             ("PARENTHESIZED LATIN SMALL LETTER Y" . 9396)
                             ("PARENTHESIZED LATIN SMALL LETTER Z" . 9397)
                             ("CIRCLED LATIN CAPITAL LETTER A" . 9398)
                             ("CIRCLED LATIN CAPITAL LETTER B" . 9399)
                             ("CIRCLED LATIN CAPITAL LETTER C" . 9400)
                             ("CIRCLED LATIN CAPITAL LETTER D" . 9401)
                             ("CIRCLED LATIN CAPITAL LETTER E" . 9402)
                             ("CIRCLED LATIN CAPITAL LETTER F" . 9403)
                             ("CIRCLED LATIN CAPITAL LETTER G" . 9404)
                             ("CIRCLED LATIN CAPITAL LETTER H" . 9405)
                             ("CIRCLED LATIN CAPITAL LETTER I" . 9406)
                             ("CIRCLED LATIN CAPITAL LETTER J" . 9407)
                             ("CIRCLED LATIN CAPITAL LETTER K" . 9408)
                             ("CIRCLED LATIN CAPITAL LETTER L" . 9409)
                             ("CIRCLED LATIN CAPITAL LETTER M" . 9410)
                             ("CIRCLED LATIN CAPITAL LETTER N" . 9411)
                             ("CIRCLED LATIN CAPITAL LETTER O" . 9412)
                             ("CIRCLED LATIN CAPITAL LETTER P" . 9413)
                             ("CIRCLED LATIN CAPITAL LETTER Q" . 9414)
                             ("CIRCLED LATIN CAPITAL LETTER R" . 9415)
                             ("CIRCLED LATIN CAPITAL LETTER S" . 9416)
                             ("CIRCLED LATIN CAPITAL LETTER T" . 9417)
                             ("CIRCLED LATIN CAPITAL LETTER U" . 9418)
                             ("CIRCLED LATIN CAPITAL LETTER V" . 9419)
                             ("CIRCLED LATIN CAPITAL LETTER W" . 9420)
                             ("CIRCLED LATIN CAPITAL LETTER X" . 9421)
                             ("CIRCLED LATIN CAPITAL LETTER Y" . 9422)
                             ("CIRCLED LATIN CAPITAL LETTER Z" . 9423)
                             ("CIRCLED LATIN SMALL LETTER A" . 9424)
                             ("CIRCLED LATIN SMALL LETTER B" . 9425)
                             ("CIRCLED LATIN SMALL LETTER C" . 9426)
                             ("CIRCLED LATIN SMALL LETTER D" . 9427)
                             ("CIRCLED LATIN SMALL LETTER E" . 9428)
                             ("CIRCLED LATIN SMALL LETTER F" . 9429)
                             ("CIRCLED LATIN SMALL LETTER G" . 9430)
                             ("CIRCLED LATIN SMALL LETTER H" . 9431)
                             ("CIRCLED LATIN SMALL LETTER I" . 9432)
                             ("CIRCLED LATIN SMALL LETTER J" . 9433)
                             ("CIRCLED LATIN SMALL LETTER K" . 9434)
                             ("CIRCLED LATIN SMALL LETTER L" . 9435)
                             ("CIRCLED LATIN SMALL LETTER M" . 9436)
                             ("CIRCLED LATIN SMALL LETTER N" . 9437)
                             ("CIRCLED LATIN SMALL LETTER O" . 9438)
                             ("CIRCLED LATIN SMALL LETTER P" . 9439)
                             ("CIRCLED LATIN SMALL LETTER Q" . 9440)
                             ("CIRCLED LATIN SMALL LETTER R" . 9441)
                             ("CIRCLED LATIN SMALL LETTER S" . 9442)
                             ("CIRCLED LATIN SMALL LETTER T" . 9443)
                             ("CIRCLED LATIN SMALL LETTER U" . 9444)
                             ("CIRCLED LATIN SMALL LETTER V" . 9445)
                             ("CIRCLED LATIN SMALL LETTER W" . 9446)
                             ("CIRCLED LATIN SMALL LETTER X" . 9447)
                             ("CIRCLED LATIN SMALL LETTER Y" . 9448)
                             ("CIRCLED LATIN SMALL LETTER Z" . 9449)
                             ("CIRCLED DIGIT ZERO" . 9450)
                             ("NEGATIVE CIRCLED NUMBER ELEVEN" . 9451)
                             ("NEGATIVE CIRCLED NUMBER TWELVE" . 9452)
                             ("NEGATIVE CIRCLED NUMBER THIRTEEN" . 9453)
                             ("NEGATIVE CIRCLED NUMBER FOURTEEN" . 9454)
                             ("NEGATIVE CIRCLED NUMBER FIFTEEN" . 9455)
                             ("NEGATIVE CIRCLED NUMBER SIXTEEN" . 9456)
                             ("NEGATIVE CIRCLED NUMBER SEVENTEEN" . 9457)
                             ("NEGATIVE CIRCLED NUMBER EIGHTEEN" . 9458)
                             ("NEGATIVE CIRCLED NUMBER NINETEEN" . 9459)
                             ("NEGATIVE CIRCLED NUMBER TWENTY" . 9460)
                             ("DOUBLE CIRCLED DIGIT ONE" . 9461)
                             ("DOUBLE CIRCLED DIGIT TWO" . 9462)
                             ("DOUBLE CIRCLED DIGIT THREE" . 9463)
                             ("DOUBLE CIRCLED DIGIT FOUR" . 9464)
                             ("DOUBLE CIRCLED DIGIT FIVE" . 9465)
                             ("DOUBLE CIRCLED DIGIT SIX" . 9466)
                             ("DOUBLE CIRCLED DIGIT SEVEN" . 9467)
                             ("DOUBLE CIRCLED DIGIT EIGHT" . 9468)
                             ("DOUBLE CIRCLED DIGIT NINE" . 9469)
                             ("DOUBLE CIRCLED NUMBER TEN" . 9470)
                             ("BOX DRAWINGS LIGHT HORIZONTAL" . 9472)
                             ("BOX DRAWINGS HEAVY HORIZONTAL" . 9473)
                             ("BOX DRAWINGS LIGHT VERTICAL" . 9474)
                             ("BOX DRAWINGS HEAVY VERTICAL" . 9475)
                             ("BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL" . 9476)
                             ("BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL" . 9477)
                             ("BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL" . 9478)
                             ("BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL" . 9479)
                             ("BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL" . 9480)
                             ("BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL" . 9481)
                             ("BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL" . 9482)
                             ("BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL" . 9483)
                             ("BOX DRAWINGS LIGHT DOWN AND RIGHT" . 9484)
                             ("BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY" . 9485)
                             ("BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT" . 9486)
                             ("BOX DRAWINGS HEAVY DOWN AND RIGHT" . 9487)
                             ("BOX DRAWINGS LIGHT DOWN AND LEFT" . 9488)
                             ("BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY" . 9489)
                             ("BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" . 9490)
                             ("BOX DRAWINGS HEAVY DOWN AND LEFT" . 9491)
                             ("BOX DRAWINGS LIGHT UP AND RIGHT" . 9492)
                             ("BOX DRAWINGS UP LIGHT AND RIGHT HEAVY" . 9493)
                             ("BOX DRAWINGS UP HEAVY AND RIGHT LIGHT" . 9494)
                             ("BOX DRAWINGS HEAVY UP AND RIGHT" . 9495)
                             ("BOX DRAWINGS LIGHT UP AND LEFT" . 9496)
                             ("BOX DRAWINGS UP LIGHT AND LEFT HEAVY" . 9497)
                             ("BOX DRAWINGS UP HEAVY AND LEFT LIGHT" . 9498)
                             ("BOX DRAWINGS HEAVY UP AND LEFT" . 9499)
                             ("BOX DRAWINGS LIGHT VERTICAL AND RIGHT" . 9500)
                             ("BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY" . 9501)
                             ("BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT" . 9502)
                             ("BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT" . 9503)
                             ("BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT" . 9504)
                             ("BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY" . 9505)
                             ("BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY" . 9506)
                             ("BOX DRAWINGS HEAVY VERTICAL AND RIGHT" . 9507)
                             ("BOX DRAWINGS LIGHT VERTICAL AND LEFT" . 9508)
                             ("BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY" . 9509)
                             ("BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT" . 9510)
                             ("BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT" . 9511)
                             ("BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT" . 9512)
                             ("BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY" . 9513)
                             ("BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY" . 9514)
                             ("BOX DRAWINGS HEAVY VERTICAL AND LEFT" . 9515)
                             ("BOX DRAWINGS LIGHT DOWN AND HORIZONTAL" . 9516)
                             ("BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT" . 9517)
                             ("BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT" . 9518)
                             ("BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY" . 9519)
                             ("BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT" . 9520)
                             ("BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY" . 9521)
                             ("BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY" . 9522)
                             ("BOX DRAWINGS HEAVY DOWN AND HORIZONTAL" . 9523)
                             ("BOX DRAWINGS LIGHT UP AND HORIZONTAL" . 9524)
                             ("BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT" . 9525)
                             ("BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT" . 9526)
                             ("BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY" . 9527)
                             ("BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT" . 9528)
                             ("BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY" . 9529)
                             ("BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY" . 9530)
                             ("BOX DRAWINGS HEAVY UP AND HORIZONTAL" . 9531)
                             ("BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL" . 9532)
                             ("BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT" . 9533)
                             ("BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT" . 9534)
                             ("BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY" . 9535)
                             ("BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT" . 9536)
                             ("BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT" . 9537)
                             ("BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT" . 9538)
                             ("BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT" . 9539)
                             ("BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT" . 9540)
                             ("BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT" . 9541)
                             ("BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT" . 9542)
                             ("BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY" . 9543)
                             ("BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY" . 9544)
                             ("BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY" . 9545)
                             ("BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY" . 9546)
                             ("BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL" . 9547)
                             ("BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL" . 9548)
                             ("BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL" . 9549)
                             ("BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL" . 9550)
                             ("BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL" . 9551)
                             ("BOX DRAWINGS DOUBLE HORIZONTAL" . 9552)
                             ("BOX DRAWINGS DOUBLE VERTICAL" . 9553)
                             ("BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE" . 9554)
                             ("BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE" . 9555)
                             ("BOX DRAWINGS DOUBLE DOWN AND RIGHT" . 9556)
                             ("BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE" . 9557)
                             ("BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE" . 9558)
                             ("BOX DRAWINGS DOUBLE DOWN AND LEFT" . 9559)
                             ("BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE" . 9560)
                             ("BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE" . 9561)
                             ("BOX DRAWINGS DOUBLE UP AND RIGHT" . 9562)
                             ("BOX DRAWINGS UP SINGLE AND LEFT DOUBLE" . 9563)
                             ("BOX DRAWINGS UP DOUBLE AND LEFT SINGLE" . 9564)
                             ("BOX DRAWINGS DOUBLE UP AND LEFT" . 9565)
                             ("BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE" . 9566)
                             ("BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE" . 9567)
                             ("BOX DRAWINGS DOUBLE VERTICAL AND RIGHT" . 9568)
                             ("BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE" . 9569)
                             ("BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE" . 9570)
                             ("BOX DRAWINGS DOUBLE VERTICAL AND LEFT" . 9571)
                             ("BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE" . 9572)
                             ("BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE" . 9573)
                             ("BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL" . 9574)
                             ("BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE" . 9575)
                             ("BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE" . 9576)
                             ("BOX DRAWINGS DOUBLE UP AND HORIZONTAL" . 9577)
                             ("BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE" . 9578)
                             ("BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE" . 9579)
                             ("BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL" . 9580)
                             ("BOX DRAWINGS LIGHT ARC DOWN AND RIGHT" . 9581)
                             ("BOX DRAWINGS LIGHT ARC DOWN AND LEFT" . 9582)
                             ("BOX DRAWINGS LIGHT ARC UP AND LEFT" . 9583)
                             ("BOX DRAWINGS LIGHT ARC UP AND RIGHT" . 9584)
                             ("BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT" . 9585)
                             ("BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT" . 9586)
                             ("BOX DRAWINGS LIGHT DIAGONAL CROSS" . 9587)
                             ("BOX DRAWINGS LIGHT LEFT" . 9588)
                             ("BOX DRAWINGS LIGHT UP" . 9589)
                             ("BOX DRAWINGS LIGHT RIGHT" . 9590)
                             ("BOX DRAWINGS LIGHT DOWN" . 9591)
                             ("BOX DRAWINGS HEAVY LEFT" . 9592)
                             ("BOX DRAWINGS HEAVY UP" . 9593)
                             ("BOX DRAWINGS HEAVY RIGHT" . 9594)
                             ("BOX DRAWINGS HEAVY DOWN" . 9595)
                             ("BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT" . 9596)
                             ("BOX DRAWINGS LIGHT UP AND HEAVY DOWN" . 9597)
                             ("BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT" . 9598)
                             ("BOX DRAWINGS HEAVY UP AND LIGHT DOWN" . 9599)
                             ("UPPER HALF BLOCK" . 9600)
                             ("LOWER ONE EIGHTH BLOCK" . 9601)
                             ("LOWER ONE QUARTER BLOCK" . 9602)
                             ("LOWER THREE EIGHTHS BLOCK" . 9603)
                             ("LOWER HALF BLOCK" . 9604)
                             ("LOWER FIVE EIGHTHS BLOCK" . 9605)
                             ("LOWER THREE QUARTERS BLOCK" . 9606)
                             ("LOWER SEVEN EIGHTHS BLOCK" . 9607)
                             ("FULL BLOCK" . 9608)
                             ("LEFT SEVEN EIGHTHS BLOCK" . 9609)
                             ("LEFT THREE QUARTERS BLOCK" . 9610)
                             ("LEFT FIVE EIGHTHS BLOCK" . 9611)
                             ("LEFT HALF BLOCK" . 9612)
                             ("LEFT THREE EIGHTHS BLOCK" . 9613)
                             ("LEFT ONE QUARTER BLOCK" . 9614)
                             ("LEFT ONE EIGHTH BLOCK" . 9615)
                             ("RIGHT HALF BLOCK" . 9616)
                             ("LIGHT SHADE" . 9617)
                             ("MEDIUM SHADE" . 9618)
                             ("DARK SHADE" . 9619)
                             ("UPPER ONE EIGHTH BLOCK" . 9620)
                             ("RIGHT ONE EIGHTH BLOCK" . 9621)
                             ("QUADRANT LOWER LEFT" . 9622)
                             ("QUADRANT LOWER RIGHT" . 9623)
                             ("QUADRANT UPPER LEFT" . 9624)
                             ("QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT" . 9625)
                             ("QUADRANT UPPER LEFT AND LOWER RIGHT" . 9626)
                             ("QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT" . 9627)
                             ("QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT" . 9628)
                             ("QUADRANT UPPER RIGHT" . 9629)
                             ("QUADRANT UPPER RIGHT AND LOWER LEFT" . 9630)
                             ("QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT" . 9631)
                             ("BLACK SQUARE" . 9632)
                             ("WHITE SQUARE" . 9633)
                             ("WHITE SQUARE WITH ROUNDED CORNERS" . 9634)
                             ("WHITE SQUARE CONTAINING BLACK SMALL SQUARE" . 9635)
                             ("SQUARE WITH HORIZONTAL FILL" . 9636)
                             ("SQUARE WITH VERTICAL FILL" . 9637)
                             ("SQUARE WITH ORTHOGONAL CROSSHATCH FILL" . 9638)
                             ("SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL" . 9639)
                             ("SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL" . 9640)
                             ("SQUARE WITH DIAGONAL CROSSHATCH FILL" . 9641)
                             ("BLACK SMALL SQUARE" . 9642)
                             ("WHITE SMALL SQUARE" . 9643)
                             ("BLACK RECTANGLE" . 9644)
                             ("WHITE RECTANGLE" . 9645)
                             ("BLACK VERTICAL RECTANGLE" . 9646)
                             ("WHITE VERTICAL RECTANGLE" . 9647)
                             ("BLACK PARALLELOGRAM" . 9648)
                             ("WHITE PARALLELOGRAM" . 9649)
                             ("BLACK UP-POINTING TRIANGLE" . 9650)
                             ("WHITE UP-POINTING TRIANGLE" . 9651)
                             ("BLACK UP-POINTING SMALL TRIANGLE" . 9652)
                             ("WHITE UP-POINTING SMALL TRIANGLE" . 9653)
                             ("BLACK RIGHT-POINTING TRIANGLE" . 9654)
                             ("WHITE RIGHT-POINTING TRIANGLE" . 9655)
                             ("BLACK RIGHT-POINTING SMALL TRIANGLE" . 9656)
                             ("WHITE RIGHT-POINTING SMALL TRIANGLE" . 9657)
                             ("BLACK RIGHT-POINTING POINTER" . 9658)
                             ("WHITE RIGHT-POINTING POINTER" . 9659)
                             ("BLACK DOWN-POINTING TRIANGLE" . 9660)
                             ("WHITE DOWN-POINTING TRIANGLE" . 9661)
                             ("BLACK DOWN-POINTING SMALL TRIANGLE" . 9662)
                             ("WHITE DOWN-POINTING SMALL TRIANGLE" . 9663)
                             ("BLACK LEFT-POINTING TRIANGLE" . 9664)
                             ("WHITE LEFT-POINTING TRIANGLE" . 9665)
                             ("BLACK LEFT-POINTING SMALL TRIANGLE" . 9666)
                             ("WHITE LEFT-POINTING SMALL TRIANGLE" . 9667)
                             ("BLACK LEFT-POINTING POINTER" . 9668)
                             ("WHITE LEFT-POINTING POINTER" . 9669)
                             ("BLACK DIAMOND" . 9670)
                             ("WHITE DIAMOND" . 9671)
                             ("WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND" . 9672)
                             ("FISHEYE" . 9673)
                             ("LOZENGE" . 9674)
                             ("WHITE CIRCLE" . 9675)
                             ("DOTTED CIRCLE" . 9676)
                             ("CIRCLE WITH VERTICAL FILL" . 9677)
                             ("BULLSEYE" . 9678)
                             ("BLACK CIRCLE" . 9679)
                             ("CIRCLE WITH LEFT HALF BLACK" . 9680)
                             ("CIRCLE WITH RIGHT HALF BLACK" . 9681)
                             ("CIRCLE WITH LOWER HALF BLACK" . 9682)
                             ("CIRCLE WITH UPPER HALF BLACK" . 9683)
                             ("CIRCLE WITH UPPER RIGHT QUADRANT BLACK" . 9684)
                             ("CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK" . 9685)
                             ("LEFT HALF BLACK CIRCLE" . 9686)
                             ("RIGHT HALF BLACK CIRCLE" . 9687)
                             ("INVERSE BULLET" . 9688)
                             ("INVERSE WHITE CIRCLE" . 9689)
                             ("UPPER HALF INVERSE WHITE CIRCLE" . 9690)
                             ("LOWER HALF INVERSE WHITE CIRCLE" . 9691)
                             ("UPPER LEFT QUADRANT CIRCULAR ARC" . 9692)
                             ("UPPER RIGHT QUADRANT CIRCULAR ARC" . 9693)
                             ("LOWER RIGHT QUADRANT CIRCULAR ARC" . 9694)
                             ("LOWER LEFT QUADRANT CIRCULAR ARC" . 9695)
                             ("UPPER HALF CIRCLE" . 9696)
                             ("LOWER HALF CIRCLE" . 9697)
                             ("BLACK LOWER RIGHT TRIANGLE" . 9698)
                             ("BLACK LOWER LEFT TRIANGLE" . 9699)
                             ("BLACK UPPER LEFT TRIANGLE" . 9700)
                             ("BLACK UPPER RIGHT TRIANGLE" . 9701)
                             ("WHITE BULLET" . 9702)
                             ("SQUARE WITH LEFT HALF BLACK" . 9703)
                             ("SQUARE WITH RIGHT HALF BLACK" . 9704)
                             ("SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK" . 9705)
                             ("SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK" . 9706)
                             ("WHITE SQUARE WITH VERTICAL BISECTING LINE" . 9707)
                             ("WHITE UP-POINTING TRIANGLE WITH DOT" . 9708)
                             ("UP-POINTING TRIANGLE WITH LEFT HALF BLACK" . 9709)
                             ("UP-POINTING TRIANGLE WITH RIGHT HALF BLACK" . 9710)
                             ("LARGE CIRCLE" . 9711)
                             ("WHITE SQUARE WITH UPPER LEFT QUADRANT" . 9712)
                             ("WHITE SQUARE WITH LOWER LEFT QUADRANT" . 9713)
                             ("WHITE SQUARE WITH LOWER RIGHT QUADRANT" . 9714)
                             ("WHITE SQUARE WITH UPPER RIGHT QUADRANT" . 9715)
                             ("WHITE CIRCLE WITH UPPER LEFT QUADRANT" . 9716)
                             ("WHITE CIRCLE WITH LOWER LEFT QUADRANT" . 9717)
                             ("WHITE CIRCLE WITH LOWER RIGHT QUADRANT" . 9718)
                             ("WHITE CIRCLE WITH UPPER RIGHT QUADRANT" . 9719)
                             ("UPPER LEFT TRIANGLE" . 9720)
                             ("UPPER RIGHT TRIANGLE" . 9721)
                             ("LOWER LEFT TRIANGLE" . 9722)
                             ("WHITE MEDIUM SQUARE" . 9723)
                             ("BLACK MEDIUM SQUARE" . 9724)
                             ("WHITE MEDIUM SMALL SQUARE" . 9725)
                             ("BLACK MEDIUM SMALL SQUARE" . 9726)
                             ("LOWER RIGHT TRIANGLE" . 9727)
                             ("BLACK SUN WITH RAYS" . 9728)
                             ("CLOUD" . 9729)
                             ("UMBRELLA" . 9730)
                             ("SNOWMAN" . 9731)
                             ("COMET" . 9732)
                             ("BLACK STAR" . 9733)
                             ("WHITE STAR" . 9734)
                             ("LIGHTNING" . 9735)
                             ("THUNDERSTORM" . 9736)
                             ("SUN" . 9737)
                             ("ASCENDING NODE" . 9738)
                             ("DESCENDING NODE" . 9739)
                             ("CONJUNCTION" . 9740)
                             ("OPPOSITION" . 9741)
                             ("BLACK TELEPHONE" . 9742)
                             ("WHITE TELEPHONE" . 9743)
                             ("BALLOT BOX" . 9744)
                             ("BALLOT BOX WITH CHECK" . 9745)
                             ("BALLOT BOX WITH X" . 9746)
                             ("SALTIRE" . 9747)
                             ("WHITE SHOGI PIECE" . 9750)
                             ("BLACK SHOGI PIECE" . 9751)
                             ("REVERSED ROTATED FLORAL HEART BULLET" . 9753)
                             ("BLACK LEFT POINTING INDEX" . 9754)
                             ("BLACK RIGHT POINTING INDEX" . 9755)
                             ("WHITE LEFT POINTING INDEX" . 9756)
                             ("WHITE UP POINTING INDEX" . 9757)
                             ("WHITE RIGHT POINTING INDEX" . 9758)
                             ("WHITE DOWN POINTING INDEX" . 9759)
                             ("SKULL AND CROSSBONES" . 9760)
                             ("CAUTION SIGN" . 9761)
                             ("RADIOACTIVE SIGN" . 9762)
                             ("BIOHAZARD SIGN" . 9763)
                             ("CADUCEUS" . 9764)
                             ("ANKH" . 9765)
                             ("ORTHODOX CROSS" . 9766)
                             ("CHI RHO" . 9767)
                             ("CROSS OF LORRAINE" . 9768)
                             ("CROSS OF JERUSALEM" . 9769)
                             ("STAR AND CRESCENT" . 9770)
                             ("FARSI SYMBOL" . 9771)
                             ("ADI SHAKTI" . 9772)
                             ("HAMMER AND SICKLE" . 9773)
                             ("PEACE SYMBOL" . 9774)
                             ("YIN YANG" . 9775)
                             ("TRIGRAM FOR HEAVEN" . 9776)
                             ("TRIGRAM FOR LAKE" . 9777)
                             ("TRIGRAM FOR FIRE" . 9778)
                             ("TRIGRAM FOR THUNDER" . 9779)
                             ("TRIGRAM FOR WIND" . 9780)
                             ("TRIGRAM FOR WATER" . 9781)
                             ("TRIGRAM FOR MOUNTAIN" . 9782)
                             ("TRIGRAM FOR EARTH" . 9783)
                             ("WHEEL OF DHARMA" . 9784)
                             ("WHITE FROWNING FACE" . 9785)
                             ("WHITE SMILING FACE" . 9786)
                             ("BLACK SMILING FACE" . 9787)
                             ("WHITE SUN WITH RAYS" . 9788)
                             ("FIRST QUARTER MOON" . 9789)
                             ("LAST QUARTER MOON" . 9790)
                             ("MERCURY" . 9791)
                             ("FEMALE SIGN" . 9792)
                             ("EARTH" . 9793)
                             ("MALE SIGN" . 9794)
                             ("JUPITER" . 9795)
                             ("SATURN" . 9796)
                             ("URANUS" . 9797)
                             ("NEPTUNE" . 9798)
                             ("PLUTO" . 9799)
                             ("ARIES" . 9800)
                             ("TAURUS" . 9801)
                             ("GEMINI" . 9802)
                             ("CANCER" . 9803)
                             ("LEO" . 9804)
                             ("VIRGO" . 9805)
                             ("LIBRA" . 9806)
                             ("SCORPIUS" . 9807)
                             ("SAGITTARIUS" . 9808)
                             ("CAPRICORN" . 9809)
                             ("AQUARIUS" . 9810)
                             ("PISCES" . 9811)
                             ("WHITE CHESS KING" . 9812)
                             ("WHITE CHESS QUEEN" . 9813)
                             ("WHITE CHESS ROOK" . 9814)
                             ("WHITE CHESS BISHOP" . 9815)
                             ("WHITE CHESS KNIGHT" . 9816)
                             ("WHITE CHESS PAWN" . 9817)
                             ("BLACK CHESS KING" . 9818)
                             ("BLACK CHESS QUEEN" . 9819)
                             ("BLACK CHESS ROOK" . 9820)
                             ("BLACK CHESS BISHOP" . 9821)
                             ("BLACK CHESS KNIGHT" . 9822)
                             ("BLACK CHESS PAWN" . 9823)
                             ("BLACK SPADE SUIT" . 9824)
                             ("WHITE HEART SUIT" . 9825)
                             ("WHITE DIAMOND SUIT" . 9826)
                             ("BLACK CLUB SUIT" . 9827)
                             ("WHITE SPADE SUIT" . 9828)
                             ("BLACK HEART SUIT" . 9829)
                             ("BLACK DIAMOND SUIT" . 9830)
                             ("WHITE CLUB SUIT" . 9831)
                             ("HOT SPRINGS" . 9832)
                             ("QUARTER NOTE" . 9833)
                             ("EIGHTH NOTE" . 9834)
                             ("BEAMED EIGHTH NOTES" . 9835)
                             ("BEAMED SIXTEENTH NOTES" . 9836)
                             ("MUSIC FLAT SIGN" . 9837)
                             ("MUSIC NATURAL SIGN" . 9838)
                             ("MUSIC SHARP SIGN" . 9839)
                             ("WEST SYRIAC CROSS" . 9840)
                             ("EAST SYRIAC CROSS" . 9841)
                             ("UNIVERSAL RECYCLING SYMBOL" . 9842)
                             ("RECYCLING SYMBOL FOR TYPE-1 PLASTICS" . 9843)
                             ("RECYCLING SYMBOL FOR TYPE-2 PLASTICS" . 9844)
                             ("RECYCLING SYMBOL FOR TYPE-3 PLASTICS" . 9845)
                             ("RECYCLING SYMBOL FOR TYPE-4 PLASTICS" . 9846)
                             ("RECYCLING SYMBOL FOR TYPE-5 PLASTICS" . 9847)
                             ("RECYCLING SYMBOL FOR TYPE-6 PLASTICS" . 9848)
                             ("RECYCLING SYMBOL FOR TYPE-7 PLASTICS" . 9849)
                             ("RECYCLING SYMBOL FOR GENERIC MATERIALS" . 9850)
                             ("BLACK UNIVERSAL RECYCLING SYMBOL" . 9851)
                             ("RECYCLED PAPER SYMBOL" . 9852)
                             ("PARTIALLY-RECYCLED PAPER SYMBOL" . 9853)
                             ("DIE FACE-1" . 9856)
                             ("DIE FACE-2" . 9857)
                             ("DIE FACE-3" . 9858)
                             ("DIE FACE-4" . 9859)
                             ("DIE FACE-5" . 9860)
                             ("DIE FACE-6" . 9861)
                             ("WHITE CIRCLE WITH DOT RIGHT" . 9862)
                             ("WHITE CIRCLE WITH TWO DOTS" . 9863)
                             ("BLACK CIRCLE WITH WHITE DOT RIGHT" . 9864)
                             ("BLACK CIRCLE WITH TWO WHITE DOTS" . 9865)
                             ("UPPER BLADE SCISSORS" . 9985)
                             ("BLACK SCISSORS" . 9986)
                             ("LOWER BLADE SCISSORS" . 9987)
                             ("WHITE SCISSORS" . 9988)
                             ("TELEPHONE LOCATION SIGN" . 9990)
                             ("TAPE DRIVE" . 9991)
                             ("AIRPLANE" . 9992)
                             ("ENVELOPE" . 9993)
                             ("VICTORY HAND" . 9996)
                             ("WRITING HAND" . 9997)
                             ("LOWER RIGHT PENCIL" . 9998)
                             ("PENCIL" . 9999)
                             ("UPPER RIGHT PENCIL" . 10000)
                             ("WHITE NIB" . 10001)
                             ("BLACK NIB" . 10002)
                             ("CHECK MARK" . 10003)
                             ("HEAVY CHECK MARK" . 10004)
                             ("MULTIPLICATION X" . 10005)
                             ("HEAVY MULTIPLICATION X" . 10006)
                             ("BALLOT X" . 10007)
                             ("HEAVY BALLOT X" . 10008)
                             ("OUTLINED GREEK CROSS" . 10009)
                             ("HEAVY GREEK CROSS" . 10010)
                             ("OPEN CENTRE CROSS" . 10011)
                             ("HEAVY OPEN CENTRE CROSS" . 10012)
                             ("LATIN CROSS" . 10013)
                             ("SHADOWED WHITE LATIN CROSS" . 10014)
                             ("OUTLINED LATIN CROSS" . 10015)
                             ("MALTESE CROSS" . 10016)
                             ("STAR OF DAVID" . 10017)
                             ("FOUR TEARDROP-SPOKED ASTERISK" . 10018)
                             ("FOUR BALLOON-SPOKED ASTERISK" . 10019)
                             ("HEAVY FOUR BALLOON-SPOKED ASTERISK" . 10020)
                             ("FOUR CLUB-SPOKED ASTERISK" . 10021)
                             ("BLACK FOUR POINTED STAR" . 10022)
                             ("WHITE FOUR POINTED STAR" . 10023)
                             ("STRESS OUTLINED WHITE STAR" . 10025)
                             ("CIRCLED WHITE STAR" . 10026)
                             ("OPEN CENTRE BLACK STAR" . 10027)
                             ("BLACK CENTRE WHITE STAR" . 10028)
                             ("OUTLINED BLACK STAR" . 10029)
                             ("HEAVY OUTLINED BLACK STAR" . 10030)
                             ("PINWHEEL STAR" . 10031)
                             ("SHADOWED WHITE STAR" . 10032)
                             ("HEAVY ASTERISK" . 10033)
                             ("OPEN CENTRE ASTERISK" . 10034)
                             ("EIGHT SPOKED ASTERISK" . 10035)
                             ("EIGHT POINTED BLACK STAR" . 10036)
                             ("EIGHT POINTED PINWHEEL STAR" . 10037)
                             ("SIX POINTED BLACK STAR" . 10038)
                             ("EIGHT POINTED RECTILINEAR BLACK STAR" . 10039)
                             ("HEAVY EIGHT POINTED RECTILINEAR BLACK STAR" . 10040)
                             ("TWELVE POINTED BLACK STAR" . 10041)
                             ("SIXTEEN POINTED ASTERISK" . 10042)
                             ("TEARDROP-SPOKED ASTERISK" . 10043)
                             ("OPEN CENTRE TEARDROP-SPOKED ASTERISK" . 10044)
                             ("HEAVY TEARDROP-SPOKED ASTERISK" . 10045)
                             ("SIX PETALLED BLACK AND WHITE FLORETTE" . 10046)
                             ("BLACK FLORETTE" . 10047)
                             ("WHITE FLORETTE" . 10048)
                             ("EIGHT PETALLED OUTLINED BLACK FLORETTE" . 10049)
                             ("CIRCLED OPEN CENTRE EIGHT POINTED STAR" . 10050)
                             ("HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK" . 10051)
                             ("SNOWFLAKE" . 10052)
                             ("TIGHT TRIFOLIATE SNOWFLAKE" . 10053)
                             ("HEAVY CHEVRON SNOWFLAKE" . 10054)
                             ("SPARKLE" . 10055)
                             ("HEAVY SPARKLE" . 10056)
                             ("BALLOON-SPOKED ASTERISK" . 10057)
                             ("EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" . 10058)
                             ("HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK" . 10059)
                             ("SHADOWED WHITE CIRCLE" . 10061)
                             ("LOWER RIGHT DROP-SHADOWED WHITE SQUARE" . 10063)
                             ("UPPER RIGHT DROP-SHADOWED WHITE SQUARE" . 10064)
                             ("LOWER RIGHT SHADOWED WHITE SQUARE" . 10065)
                             ("UPPER RIGHT SHADOWED WHITE SQUARE" . 10066)
                             ("BLACK DIAMOND MINUS WHITE X" . 10070)
                             ("LIGHT VERTICAL BAR" . 10072)
                             ("MEDIUM VERTICAL BAR" . 10073)
                             ("HEAVY VERTICAL BAR" . 10074)
                             ("HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT" . 10075)
                             ("HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT" . 10076)
                             ("HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT" . 10077)
                             ("HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT" . 10078)
                             ("CURVED STEM PARAGRAPH SIGN ORNAMENT" . 10081)
                             ("HEAVY EXCLAMATION MARK ORNAMENT" . 10082)
                             ("HEAVY HEART EXCLAMATION MARK ORNAMENT" . 10083)
                             ("HEAVY BLACK HEART" . 10084)
                             ("ROTATED HEAVY BLACK HEART BULLET" . 10085)
                             ("FLORAL HEART" . 10086)
                             ("ROTATED FLORAL HEART BULLET" . 10087)
                             ("MEDIUM LEFT PARENTHESIS ORNAMENT" . 10088)
                             ("MEDIUM RIGHT PARENTHESIS ORNAMENT" . 10089)
                             ("MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT" . 10090)
                             ("MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT" . 10091)
                             ("MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT" . 10092)
                             ("MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT" . 10093)
                             ("HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT" . 10094)
                             ("HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT" . 10095)
                             ("HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT" . 10096)
                             ("HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT" . 10097)
                             ("LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT" . 10098)
                             ("LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT" . 10099)
                             ("MEDIUM LEFT CURLY BRACKET ORNAMENT" . 10100)
                             ("MEDIUM RIGHT CURLY BRACKET ORNAMENT" . 10101)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT ONE" . 10102)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT TWO" . 10103)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT THREE" . 10104)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT FOUR" . 10105)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT FIVE" . 10106)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT SIX" . 10107)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT SEVEN" . 10108)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT EIGHT" . 10109)
                             ("DINGBAT NEGATIVE CIRCLED DIGIT NINE" . 10110)
                             ("DINGBAT NEGATIVE CIRCLED NUMBER TEN" . 10111)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT ONE" . 10112)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT TWO" . 10113)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT THREE" . 10114)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT FOUR" . 10115)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT FIVE" . 10116)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT SIX" . 10117)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN" . 10118)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT" . 10119)
                             ("DINGBAT CIRCLED SANS-SERIF DIGIT NINE" . 10120)
                             ("DINGBAT CIRCLED SANS-SERIF NUMBER TEN" . 10121)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE" . 10122)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO" . 10123)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE" . 10124)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR" . 10125)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE" . 10126)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX" . 10127)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN" . 10128)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT" . 10129)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE" . 10130)
                             ("DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN" . 10131)
                             ("HEAVY WIDE-HEADED RIGHTWARDS ARROW" . 10132)
                             ("HEAVY SOUTH EAST ARROW" . 10136)
                             ("HEAVY RIGHTWARDS ARROW" . 10137)
                             ("HEAVY NORTH EAST ARROW" . 10138)
                             ("DRAFTING POINT RIGHTWARDS ARROW" . 10139)
                             ("HEAVY ROUND-TIPPED RIGHTWARDS ARROW" . 10140)
                             ("TRIANGLE-HEADED RIGHTWARDS ARROW" . 10141)
                             ("HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW" . 10142)
                             ("DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" . 10143)
                             ("HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW" . 10144)
                             ("BLACK RIGHTWARDS ARROW" . 10145)
                             ("THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD" . 10146)
                             ("THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD" . 10147)
                             ("BLACK RIGHTWARDS ARROWHEAD" . 10148)
                             ("HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW" . 10149)
                             ("HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW" . 10150)
                             ("SQUAT BLACK RIGHTWARDS ARROW" . 10151)
                             ("HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW" . 10152)
                             ("RIGHT-SHADED WHITE RIGHTWARDS ARROW" . 10153)
                             ("LEFT-SHADED WHITE RIGHTWARDS ARROW" . 10154)
                             ("BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW" . 10155)
                             ("FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW" . 10156)
                             ("HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . 10157)
                             ("HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . 10158)
                             ("NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . 10159)
                             ("NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW" . 10161)
                             ("CIRCLED HEAVY WHITE RIGHTWARDS ARROW" . 10162)
                             ("WHITE-FEATHERED RIGHTWARDS ARROW" . 10163)
                             ("BLACK-FEATHERED SOUTH EAST ARROW" . 10164)
                             ("BLACK-FEATHERED RIGHTWARDS ARROW" . 10165)
                             ("BLACK-FEATHERED NORTH EAST ARROW" . 10166)
                             ("HEAVY BLACK-FEATHERED SOUTH EAST ARROW" . 10167)
                             ("HEAVY BLACK-FEATHERED RIGHTWARDS ARROW" . 10168)
                             ("HEAVY BLACK-FEATHERED NORTH EAST ARROW" . 10169)
                             ("TEARDROP-BARBED RIGHTWARDS ARROW" . 10170)
                             ("HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW" . 10171)
                             ("WEDGE-TAILED RIGHTWARDS ARROW" . 10172)
                             ("HEAVY WEDGE-TAILED RIGHTWARDS ARROW" . 10173)
                             ("OPEN-OUTLINED RIGHTWARDS ARROW" . 10174)
                             ("WHITE DIAMOND WITH CENTRED DOT" . 10192)
                             ("AND WITH DOT" . 10193)
                             ("ELEMENT OF OPENING UPWARDS" . 10194)
                             ("LOWER RIGHT CORNER WITH DOT" . 10195)
                             ("UPPER LEFT CORNER WITH DOT" . 10196)
                             ("LEFT OUTER JOIN" . 10197)
                             ("RIGHT OUTER JOIN" . 10198)
                             ("FULL OUTER JOIN" . 10199)
                             ("LARGE UP TACK" . 10200)
                             ("LARGE DOWN TACK" . 10201)
                             ("LEFT AND RIGHT DOUBLE TURNSTILE" . 10202)
                             ("LEFT AND RIGHT TACK" . 10203)
                             ("LEFT MULTIMAP" . 10204)
                             ("LONG RIGHT TACK" . 10205)
                             ("LONG LEFT TACK" . 10206)
                             ("UP TACK WITH CIRCLE ABOVE" . 10207)
                             ("LOZENGE DIVIDED BY HORIZONTAL RULE" . 10208)
                             ("WHITE CONCAVE-SIDED DIAMOND" . 10209)
                             ("WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK" . 10210)
                             ("WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK" . 10211)
                             ("WHITE SQUARE WITH LEFTWARDS TICK" . 10212)
                             ("WHITE SQUARE WITH RIGHTWARDS TICK" . 10213)
                             ("MATHEMATICAL LEFT WHITE SQUARE BRACKET" . 10214)
                             ("MATHEMATICAL RIGHT WHITE SQUARE BRACKET" . 10215)
                             ("MATHEMATICAL LEFT ANGLE BRACKET" . 10216)
                             ("MATHEMATICAL RIGHT ANGLE BRACKET" . 10217)
                             ("MATHEMATICAL LEFT DOUBLE ANGLE BRACKET" . 10218)
                             ("MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET" . 10219)
                             ("UPWARDS QUADRUPLE ARROW" . 10224)
                             ("DOWNWARDS QUADRUPLE ARROW" . 10225)
                             ("ANTICLOCKWISE GAPPED CIRCLE ARROW" . 10226)
                             ("CLOCKWISE GAPPED CIRCLE ARROW" . 10227)
                             ("RIGHT ARROW WITH CIRCLED PLUS" . 10228)
                             ("LONG LEFTWARDS ARROW" . 10229)
                             ("LONG RIGHTWARDS ARROW" . 10230)
                             ("LONG LEFT RIGHT ARROW" . 10231)
                             ("LONG LEFTWARDS DOUBLE ARROW" . 10232)
                             ("LONG RIGHTWARDS DOUBLE ARROW" . 10233)
                             ("LONG LEFT RIGHT DOUBLE ARROW" . 10234)
                             ("LONG LEFTWARDS ARROW FROM BAR" . 10235)
                             ("LONG RIGHTWARDS ARROW FROM BAR" . 10236)
                             ("LONG LEFTWARDS DOUBLE ARROW FROM BAR" . 10237)
                             ("LONG RIGHTWARDS DOUBLE ARROW FROM BAR" . 10238)
                             ("LONG RIGHTWARDS SQUIGGLE ARROW" . 10239)
                             ("BRAILLE PATTERN BLANK" . 10240)
                             ("BRAILLE PATTERN DOTS-1" . 10241)
                             ("BRAILLE PATTERN DOTS-2" . 10242)
                             ("BRAILLE PATTERN DOTS-12" . 10243)
                             ("BRAILLE PATTERN DOTS-3" . 10244)
                             ("BRAILLE PATTERN DOTS-13" . 10245)
                             ("BRAILLE PATTERN DOTS-23" . 10246)
                             ("BRAILLE PATTERN DOTS-123" . 10247)
                             ("BRAILLE PATTERN DOTS-4" . 10248)
                             ("BRAILLE PATTERN DOTS-14" . 10249)
                             ("BRAILLE PATTERN DOTS-24" . 10250)
                             ("BRAILLE PATTERN DOTS-124" . 10251)
                             ("BRAILLE PATTERN DOTS-34" . 10252)
                             ("BRAILLE PATTERN DOTS-134" . 10253)
                             ("BRAILLE PATTERN DOTS-234" . 10254)
                             ("BRAILLE PATTERN DOTS-1234" . 10255)
                             ("BRAILLE PATTERN DOTS-5" . 10256)
                             ("BRAILLE PATTERN DOTS-15" . 10257)
                             ("BRAILLE PATTERN DOTS-25" . 10258)
                             ("BRAILLE PATTERN DOTS-125" . 10259)
                             ("BRAILLE PATTERN DOTS-35" . 10260)
                             ("BRAILLE PATTERN DOTS-135" . 10261)
                             ("BRAILLE PATTERN DOTS-235" . 10262)
                             ("BRAILLE PATTERN DOTS-1235" . 10263)
                             ("BRAILLE PATTERN DOTS-45" . 10264)
                             ("BRAILLE PATTERN DOTS-145" . 10265)
                             ("BRAILLE PATTERN DOTS-245" . 10266)
                             ("BRAILLE PATTERN DOTS-1245" . 10267)
                             ("BRAILLE PATTERN DOTS-345" . 10268)
                             ("BRAILLE PATTERN DOTS-1345" . 10269)
                             ("BRAILLE PATTERN DOTS-2345" . 10270)
                             ("BRAILLE PATTERN DOTS-12345" . 10271)
                             ("BRAILLE PATTERN DOTS-6" . 10272)
                             ("BRAILLE PATTERN DOTS-16" . 10273)
                             ("BRAILLE PATTERN DOTS-26" . 10274)
                             ("BRAILLE PATTERN DOTS-126" . 10275)
                             ("BRAILLE PATTERN DOTS-36" . 10276)
                             ("BRAILLE PATTERN DOTS-136" . 10277)
                             ("BRAILLE PATTERN DOTS-236" . 10278)
                             ("BRAILLE PATTERN DOTS-1236" . 10279)
                             ("BRAILLE PATTERN DOTS-46" . 10280)
                             ("BRAILLE PATTERN DOTS-146" . 10281)
                             ("BRAILLE PATTERN DOTS-246" . 10282)
                             ("BRAILLE PATTERN DOTS-1246" . 10283)
                             ("BRAILLE PATTERN DOTS-346" . 10284)
                             ("BRAILLE PATTERN DOTS-1346" . 10285)
                             ("BRAILLE PATTERN DOTS-2346" . 10286)
                             ("BRAILLE PATTERN DOTS-12346" . 10287)
                             ("BRAILLE PATTERN DOTS-56" . 10288)
                             ("BRAILLE PATTERN DOTS-156" . 10289)
                             ("BRAILLE PATTERN DOTS-256" . 10290)
                             ("BRAILLE PATTERN DOTS-1256" . 10291)
                             ("BRAILLE PATTERN DOTS-356" . 10292)
                             ("BRAILLE PATTERN DOTS-1356" . 10293)
                             ("BRAILLE PATTERN DOTS-2356" . 10294)
                             ("BRAILLE PATTERN DOTS-12356" . 10295)
                             ("BRAILLE PATTERN DOTS-456" . 10296)
                             ("BRAILLE PATTERN DOTS-1456" . 10297)
                             ("BRAILLE PATTERN DOTS-2456" . 10298)
                             ("BRAILLE PATTERN DOTS-12456" . 10299)
                             ("BRAILLE PATTERN DOTS-3456" . 10300)
                             ("BRAILLE PATTERN DOTS-13456" . 10301)
                             ("BRAILLE PATTERN DOTS-23456" . 10302)
                             ("BRAILLE PATTERN DOTS-123456" . 10303)
                             ("BRAILLE PATTERN DOTS-7" . 10304)
                             ("BRAILLE PATTERN DOTS-17" . 10305)
                             ("BRAILLE PATTERN DOTS-27" . 10306)
                             ("BRAILLE PATTERN DOTS-127" . 10307)
                             ("BRAILLE PATTERN DOTS-37" . 10308)
                             ("BRAILLE PATTERN DOTS-137" . 10309)
                             ("BRAILLE PATTERN DOTS-237" . 10310)
                             ("BRAILLE PATTERN DOTS-1237" . 10311)
                             ("BRAILLE PATTERN DOTS-47" . 10312)
                             ("BRAILLE PATTERN DOTS-147" . 10313)
                             ("BRAILLE PATTERN DOTS-247" . 10314)
                             ("BRAILLE PATTERN DOTS-1247" . 10315)
                             ("BRAILLE PATTERN DOTS-347" . 10316)
                             ("BRAILLE PATTERN DOTS-1347" . 10317)
                             ("BRAILLE PATTERN DOTS-2347" . 10318)
                             ("BRAILLE PATTERN DOTS-12347" . 10319)
                             ("BRAILLE PATTERN DOTS-57" . 10320)
                             ("BRAILLE PATTERN DOTS-157" . 10321)
                             ("BRAILLE PATTERN DOTS-257" . 10322)
                             ("BRAILLE PATTERN DOTS-1257" . 10323)
                             ("BRAILLE PATTERN DOTS-357" . 10324)
                             ("BRAILLE PATTERN DOTS-1357" . 10325)
                             ("BRAILLE PATTERN DOTS-2357" . 10326)
                             ("BRAILLE PATTERN DOTS-12357" . 10327)
                             ("BRAILLE PATTERN DOTS-457" . 10328)
                             ("BRAILLE PATTERN DOTS-1457" . 10329)
                             ("BRAILLE PATTERN DOTS-2457" . 10330)
                             ("BRAILLE PATTERN DOTS-12457" . 10331)
                             ("BRAILLE PATTERN DOTS-3457" . 10332)
                             ("BRAILLE PATTERN DOTS-13457" . 10333)
                             ("BRAILLE PATTERN DOTS-23457" . 10334)
                             ("BRAILLE PATTERN DOTS-123457" . 10335)
                             ("BRAILLE PATTERN DOTS-67" . 10336)
                             ("BRAILLE PATTERN DOTS-167" . 10337)
                             ("BRAILLE PATTERN DOTS-267" . 10338)
                             ("BRAILLE PATTERN DOTS-1267" . 10339)
                             ("BRAILLE PATTERN DOTS-367" . 10340)
                             ("BRAILLE PATTERN DOTS-1367" . 10341)
                             ("BRAILLE PATTERN DOTS-2367" . 10342)
                             ("BRAILLE PATTERN DOTS-12367" . 10343)
                             ("BRAILLE PATTERN DOTS-467" . 10344)
                             ("BRAILLE PATTERN DOTS-1467" . 10345)
                             ("BRAILLE PATTERN DOTS-2467" . 10346)
                             ("BRAILLE PATTERN DOTS-12467" . 10347)
                             ("BRAILLE PATTERN DOTS-3467" . 10348)
                             ("BRAILLE PATTERN DOTS-13467" . 10349)
                             ("BRAILLE PATTERN DOTS-23467" . 10350)
                             ("BRAILLE PATTERN DOTS-123467" . 10351)
                             ("BRAILLE PATTERN DOTS-567" . 10352)
                             ("BRAILLE PATTERN DOTS-1567" . 10353)
                             ("BRAILLE PATTERN DOTS-2567" . 10354)
                             ("BRAILLE PATTERN DOTS-12567" . 10355)
                             ("BRAILLE PATTERN DOTS-3567" . 10356)
                             ("BRAILLE PATTERN DOTS-13567" . 10357)
                             ("BRAILLE PATTERN DOTS-23567" . 10358)
                             ("BRAILLE PATTERN DOTS-123567" . 10359)
                             ("BRAILLE PATTERN DOTS-4567" . 10360)
                             ("BRAILLE PATTERN DOTS-14567" . 10361)
                             ("BRAILLE PATTERN DOTS-24567" . 10362)
                             ("BRAILLE PATTERN DOTS-124567" . 10363)
                             ("BRAILLE PATTERN DOTS-34567" . 10364)
                             ("BRAILLE PATTERN DOTS-134567" . 10365)
                             ("BRAILLE PATTERN DOTS-234567" . 10366)
                             ("BRAILLE PATTERN DOTS-1234567" . 10367)
                             ("BRAILLE PATTERN DOTS-8" . 10368)
                             ("BRAILLE PATTERN DOTS-18" . 10369)
                             ("BRAILLE PATTERN DOTS-28" . 10370)
                             ("BRAILLE PATTERN DOTS-128" . 10371)
                             ("BRAILLE PATTERN DOTS-38" . 10372)
                             ("BRAILLE PATTERN DOTS-138" . 10373)
                             ("BRAILLE PATTERN DOTS-238" . 10374)
                             ("BRAILLE PATTERN DOTS-1238" . 10375)
                             ("BRAILLE PATTERN DOTS-48" . 10376)
                             ("BRAILLE PATTERN DOTS-148" . 10377)
                             ("BRAILLE PATTERN DOTS-248" . 10378)
                             ("BRAILLE PATTERN DOTS-1248" . 10379)
                             ("BRAILLE PATTERN DOTS-348" . 10380)
                             ("BRAILLE PATTERN DOTS-1348" . 10381)
                             ("BRAILLE PATTERN DOTS-2348" . 10382)
                             ("BRAILLE PATTERN DOTS-12348" . 10383)
                             ("BRAILLE PATTERN DOTS-58" . 10384)
                             ("BRAILLE PATTERN DOTS-158" . 10385)
                             ("BRAILLE PATTERN DOTS-258" . 10386)
                             ("BRAILLE PATTERN DOTS-1258" . 10387)
                             ("BRAILLE PATTERN DOTS-358" . 10388)
                             ("BRAILLE PATTERN DOTS-1358" . 10389)
                             ("BRAILLE PATTERN DOTS-2358" . 10390)
                             ("BRAILLE PATTERN DOTS-12358" . 10391)
                             ("BRAILLE PATTERN DOTS-458" . 10392)
                             ("BRAILLE PATTERN DOTS-1458" . 10393)
                             ("BRAILLE PATTERN DOTS-2458" . 10394)
                             ("BRAILLE PATTERN DOTS-12458" . 10395)
                             ("BRAILLE PATTERN DOTS-3458" . 10396)
                             ("BRAILLE PATTERN DOTS-13458" . 10397)
                             ("BRAILLE PATTERN DOTS-23458" . 10398)
                             ("BRAILLE PATTERN DOTS-123458" . 10399)
                             ("BRAILLE PATTERN DOTS-68" . 10400)
                             ("BRAILLE PATTERN DOTS-168" . 10401)
                             ("BRAILLE PATTERN DOTS-268" . 10402)
                             ("BRAILLE PATTERN DOTS-1268" . 10403)
                             ("BRAILLE PATTERN DOTS-368" . 10404)
                             ("BRAILLE PATTERN DOTS-1368" . 10405)
                             ("BRAILLE PATTERN DOTS-2368" . 10406)
                             ("BRAILLE PATTERN DOTS-12368" . 10407)
                             ("BRAILLE PATTERN DOTS-468" . 10408)
                             ("BRAILLE PATTERN DOTS-1468" . 10409)
                             ("BRAILLE PATTERN DOTS-2468" . 10410)
                             ("BRAILLE PATTERN DOTS-12468" . 10411)
                             ("BRAILLE PATTERN DOTS-3468" . 10412)
                             ("BRAILLE PATTERN DOTS-13468" . 10413)
                             ("BRAILLE PATTERN DOTS-23468" . 10414)
                             ("BRAILLE PATTERN DOTS-123468" . 10415)
                             ("BRAILLE PATTERN DOTS-568" . 10416)
                             ("BRAILLE PATTERN DOTS-1568" . 10417)
                             ("BRAILLE PATTERN DOTS-2568" . 10418)
                             ("BRAILLE PATTERN DOTS-12568" . 10419)
                             ("BRAILLE PATTERN DOTS-3568" . 10420)
                             ("BRAILLE PATTERN DOTS-13568" . 10421)
                             ("BRAILLE PATTERN DOTS-23568" . 10422)
                             ("BRAILLE PATTERN DOTS-123568" . 10423)
                             ("BRAILLE PATTERN DOTS-4568" . 10424)
                             ("BRAILLE PATTERN DOTS-14568" . 10425)
                             ("BRAILLE PATTERN DOTS-24568" . 10426)
                             ("BRAILLE PATTERN DOTS-124568" . 10427)
                             ("BRAILLE PATTERN DOTS-34568" . 10428)
                             ("BRAILLE PATTERN DOTS-134568" . 10429)
                             ("BRAILLE PATTERN DOTS-234568" . 10430)
                             ("BRAILLE PATTERN DOTS-1234568" . 10431)
                             ("BRAILLE PATTERN DOTS-78" . 10432)
                             ("BRAILLE PATTERN DOTS-178" . 10433)
                             ("BRAILLE PATTERN DOTS-278" . 10434)
                             ("BRAILLE PATTERN DOTS-1278" . 10435)
                             ("BRAILLE PATTERN DOTS-378" . 10436)
                             ("BRAILLE PATTERN DOTS-1378" . 10437)
                             ("BRAILLE PATTERN DOTS-2378" . 10438)
                             ("BRAILLE PATTERN DOTS-12378" . 10439)
                             ("BRAILLE PATTERN DOTS-478" . 10440)
                             ("BRAILLE PATTERN DOTS-1478" . 10441)
                             ("BRAILLE PATTERN DOTS-2478" . 10442)
                             ("BRAILLE PATTERN DOTS-12478" . 10443)
                             ("BRAILLE PATTERN DOTS-3478" . 10444)
                             ("BRAILLE PATTERN DOTS-13478" . 10445)
                             ("BRAILLE PATTERN DOTS-23478" . 10446)
                             ("BRAILLE PATTERN DOTS-123478" . 10447)
                             ("BRAILLE PATTERN DOTS-578" . 10448)
                             ("BRAILLE PATTERN DOTS-1578" . 10449)
                             ("BRAILLE PATTERN DOTS-2578" . 10450)
                             ("BRAILLE PATTERN DOTS-12578" . 10451)
                             ("BRAILLE PATTERN DOTS-3578" . 10452)
                             ("BRAILLE PATTERN DOTS-13578" . 10453)
                             ("BRAILLE PATTERN DOTS-23578" . 10454)
                             ("BRAILLE PATTERN DOTS-123578" . 10455)
                             ("BRAILLE PATTERN DOTS-4578" . 10456)
                             ("BRAILLE PATTERN DOTS-14578" . 10457)
                             ("BRAILLE PATTERN DOTS-24578" . 10458)
                             ("BRAILLE PATTERN DOTS-124578" . 10459)
                             ("BRAILLE PATTERN DOTS-34578" . 10460)
                             ("BRAILLE PATTERN DOTS-134578" . 10461)
                             ("BRAILLE PATTERN DOTS-234578" . 10462)
                             ("BRAILLE PATTERN DOTS-1234578" . 10463)
                             ("BRAILLE PATTERN DOTS-678" . 10464)
                             ("BRAILLE PATTERN DOTS-1678" . 10465)
                             ("BRAILLE PATTERN DOTS-2678" . 10466)
                             ("BRAILLE PATTERN DOTS-12678" . 10467)
                             ("BRAILLE PATTERN DOTS-3678" . 10468)
                             ("BRAILLE PATTERN DOTS-13678" . 10469)
                             ("BRAILLE PATTERN DOTS-23678" . 10470)
                             ("BRAILLE PATTERN DOTS-123678" . 10471)
                             ("BRAILLE PATTERN DOTS-4678" . 10472)
                             ("BRAILLE PATTERN DOTS-14678" . 10473)
                             ("BRAILLE PATTERN DOTS-24678" . 10474)
                             ("BRAILLE PATTERN DOTS-124678" . 10475)
                             ("BRAILLE PATTERN DOTS-34678" . 10476)
                             ("BRAILLE PATTERN DOTS-134678" . 10477)
                             ("BRAILLE PATTERN DOTS-234678" . 10478)
                             ("BRAILLE PATTERN DOTS-1234678" . 10479)
                             ("BRAILLE PATTERN DOTS-5678" . 10480)
                             ("BRAILLE PATTERN DOTS-15678" . 10481)
                             ("BRAILLE PATTERN DOTS-25678" . 10482)
                             ("BRAILLE PATTERN DOTS-125678" . 10483)
                             ("BRAILLE PATTERN DOTS-35678" . 10484)
                             ("BRAILLE PATTERN DOTS-135678" . 10485)
                             ("BRAILLE PATTERN DOTS-235678" . 10486)
                             ("BRAILLE PATTERN DOTS-1235678" . 10487)
                             ("BRAILLE PATTERN DOTS-45678" . 10488)
                             ("BRAILLE PATTERN DOTS-145678" . 10489)
                             ("BRAILLE PATTERN DOTS-245678" . 10490)
                             ("BRAILLE PATTERN DOTS-1245678" . 10491)
                             ("BRAILLE PATTERN DOTS-345678" . 10492)
                             ("BRAILLE PATTERN DOTS-1345678" . 10493)
                             ("BRAILLE PATTERN DOTS-2345678" . 10494)
                             ("BRAILLE PATTERN DOTS-12345678" . 10495)
                             ("RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE" . 10496)
                             ("RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE" . 10497)
                             ("LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE" . 10498)
                             ("RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE" . 10499)
                             ("LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE" . 10500)
                             ("RIGHTWARDS TWO-HEADED ARROW FROM BAR" . 10501)
                             ("LEFTWARDS DOUBLE ARROW FROM BAR" . 10502)
                             ("RIGHTWARDS DOUBLE ARROW FROM BAR" . 10503)
                             ("DOWNWARDS ARROW WITH HORIZONTAL STROKE" . 10504)
                             ("UPWARDS ARROW WITH HORIZONTAL STROKE" . 10505)
                             ("UPWARDS TRIPLE ARROW" . 10506)
                             ("DOWNWARDS TRIPLE ARROW" . 10507)
                             ("LEFTWARDS DOUBLE DASH ARROW" . 10508)
                             ("RIGHTWARDS DOUBLE DASH ARROW" . 10509)
                             ("LEFTWARDS TRIPLE DASH ARROW" . 10510)
                             ("RIGHTWARDS TRIPLE DASH ARROW" . 10511)
                             ("RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW" . 10512)
                             ("RIGHTWARDS ARROW WITH DOTTED STEM" . 10513)
                             ("UPWARDS ARROW TO BAR" . 10514)
                             ("DOWNWARDS ARROW TO BAR" . 10515)
                             ("RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE" . 10516)
                             ("RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" . 10517)
                             ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL" . 10518)
                             ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE" . 10519)
                             ("RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE" . 10520)
                             ("LEFTWARDS ARROW-TAIL" . 10521)
                             ("RIGHTWARDS ARROW-TAIL" . 10522)
                             ("LEFTWARDS DOUBLE ARROW-TAIL" . 10523)
                             ("RIGHTWARDS DOUBLE ARROW-TAIL" . 10524)
                             ("LEFTWARDS ARROW TO BLACK DIAMOND" . 10525)
                             ("RIGHTWARDS ARROW TO BLACK DIAMOND" . 10526)
                             ("LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND" . 10527)
                             ("RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND" . 10528)
                             ("NORTH WEST AND SOUTH EAST ARROW" . 10529)
                             ("NORTH EAST AND SOUTH WEST ARROW" . 10530)
                             ("NORTH WEST ARROW WITH HOOK" . 10531)
                             ("NORTH EAST ARROW WITH HOOK" . 10532)
                             ("SOUTH EAST ARROW WITH HOOK" . 10533)
                             ("SOUTH WEST ARROW WITH HOOK" . 10534)
                             ("NORTH WEST ARROW AND NORTH EAST ARROW" . 10535)
                             ("NORTH EAST ARROW AND SOUTH EAST ARROW" . 10536)
                             ("SOUTH EAST ARROW AND SOUTH WEST ARROW" . 10537)
                             ("SOUTH WEST ARROW AND NORTH WEST ARROW" . 10538)
                             ("RISING DIAGONAL CROSSING FALLING DIAGONAL" . 10539)
                             ("FALLING DIAGONAL CROSSING RISING DIAGONAL" . 10540)
                             ("SOUTH EAST ARROW CROSSING NORTH EAST ARROW" . 10541)
                             ("NORTH EAST ARROW CROSSING SOUTH EAST ARROW" . 10542)
                             ("FALLING DIAGONAL CROSSING NORTH EAST ARROW" . 10543)
                             ("RISING DIAGONAL CROSSING SOUTH EAST ARROW" . 10544)
                             ("NORTH EAST ARROW CROSSING NORTH WEST ARROW" . 10545)
                             ("NORTH WEST ARROW CROSSING NORTH EAST ARROW" . 10546)
                             ("WAVE ARROW POINTING DIRECTLY RIGHT" . 10547)
                             ("ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS" . 10548)
                             ("ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS" . 10549)
                             ("ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS" . 10550)
                             ("ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS" . 10551)
                             ("RIGHT-SIDE ARC CLOCKWISE ARROW" . 10552)
                             ("LEFT-SIDE ARC ANTICLOCKWISE ARROW" . 10553)
                             ("TOP ARC ANTICLOCKWISE ARROW" . 10554)
                             ("BOTTOM ARC ANTICLOCKWISE ARROW" . 10555)
                             ("TOP ARC CLOCKWISE ARROW WITH MINUS" . 10556)
                             ("TOP ARC ANTICLOCKWISE ARROW WITH PLUS" . 10557)
                             ("LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW" . 10558)
                             ("LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW" . 10559)
                             ("ANTICLOCKWISE CLOSED CIRCLE ARROW" . 10560)
                             ("CLOCKWISE CLOSED CIRCLE ARROW" . 10561)
                             ("RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW" . 10562)
                             ("LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW" . 10563)
                             ("SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW" . 10564)
                             ("RIGHTWARDS ARROW WITH PLUS BELOW" . 10565)
                             ("LEFTWARDS ARROW WITH PLUS BELOW" . 10566)
                             ("RIGHTWARDS ARROW THROUGH X" . 10567)
                             ("LEFT RIGHT ARROW THROUGH SMALL CIRCLE" . 10568)
                             ("UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE" . 10569)
                             ("LEFT BARB UP RIGHT BARB DOWN HARPOON" . 10570)
                             ("LEFT BARB DOWN RIGHT BARB UP HARPOON" . 10571)
                             ("UP BARB RIGHT DOWN BARB LEFT HARPOON" . 10572)
                             ("UP BARB LEFT DOWN BARB RIGHT HARPOON" . 10573)
                             ("LEFT BARB UP RIGHT BARB UP HARPOON" . 10574)
                             ("UP BARB RIGHT DOWN BARB RIGHT HARPOON" . 10575)
                             ("LEFT BARB DOWN RIGHT BARB DOWN HARPOON" . 10576)
                             ("UP BARB LEFT DOWN BARB LEFT HARPOON" . 10577)
                             ("LEFTWARDS HARPOON WITH BARB UP TO BAR" . 10578)
                             ("RIGHTWARDS HARPOON WITH BARB UP TO BAR" . 10579)
                             ("UPWARDS HARPOON WITH BARB RIGHT TO BAR" . 10580)
                             ("DOWNWARDS HARPOON WITH BARB RIGHT TO BAR" . 10581)
                             ("LEFTWARDS HARPOON WITH BARB DOWN TO BAR" . 10582)
                             ("RIGHTWARDS HARPOON WITH BARB DOWN TO BAR" . 10583)
                             ("UPWARDS HARPOON WITH BARB LEFT TO BAR" . 10584)
                             ("DOWNWARDS HARPOON WITH BARB LEFT TO BAR" . 10585)
                             ("LEFTWARDS HARPOON WITH BARB UP FROM BAR" . 10586)
                             ("RIGHTWARDS HARPOON WITH BARB UP FROM BAR" . 10587)
                             ("UPWARDS HARPOON WITH BARB RIGHT FROM BAR" . 10588)
                             ("DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR" . 10589)
                             ("LEFTWARDS HARPOON WITH BARB DOWN FROM BAR" . 10590)
                             ("RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR" . 10591)
                             ("UPWARDS HARPOON WITH BARB LEFT FROM BAR" . 10592)
                             ("DOWNWARDS HARPOON WITH BARB LEFT FROM BAR" . 10593)
                             ("LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN" . 10594)
                             ("UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" . 10595)
                             ("RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" . 10596)
                             ("DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" . 10597)
                             ("LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP" . 10598)
                             ("LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN" . 10599)
                             ("RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP" . 10600)
                             ("RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN" . 10601)
                             ("LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" . 10602)
                             ("LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" . 10603)
                             ("RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" . 10604)
                             ("RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" . 10605)
                             ("UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT" . 10606)
                             ("DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" . 10607)
                             ("RIGHT DOUBLE ARROW WITH ROUNDED HEAD" . 10608)
                             ("EQUALS SIGN ABOVE RIGHTWARDS ARROW" . 10609)
                             ("TILDE OPERATOR ABOVE RIGHTWARDS ARROW" . 10610)
                             ("LEFTWARDS ARROW ABOVE TILDE OPERATOR" . 10611)
                             ("RIGHTWARDS ARROW ABOVE TILDE OPERATOR" . 10612)
                             ("RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO" . 10613)
                             ("LESS-THAN ABOVE LEFTWARDS ARROW" . 10614)
                             ("LEFTWARDS ARROW THROUGH LESS-THAN" . 10615)
                             ("GREATER-THAN ABOVE RIGHTWARDS ARROW" . 10616)
                             ("SUBSET ABOVE RIGHTWARDS ARROW" . 10617)
                             ("LEFTWARDS ARROW THROUGH SUBSET" . 10618)
                             ("SUPERSET ABOVE LEFTWARDS ARROW" . 10619)
                             ("LEFT FISH TAIL" . 10620)
                             ("RIGHT FISH TAIL" . 10621)
                             ("UP FISH TAIL" . 10622)
                             ("DOWN FISH TAIL" . 10623)
                             ("TRIPLE VERTICAL BAR DELIMITER" . 10624)
                             ("Z NOTATION SPOT" . 10625)
                             ("Z NOTATION TYPE COLON" . 10626)
                             ("LEFT WHITE CURLY BRACKET" . 10627)
                             ("RIGHT WHITE CURLY BRACKET" . 10628)
                             ("LEFT WHITE PARENTHESIS" . 10629)
                             ("RIGHT WHITE PARENTHESIS" . 10630)
                             ("Z NOTATION LEFT IMAGE BRACKET" . 10631)
                             ("Z NOTATION RIGHT IMAGE BRACKET" . 10632)
                             ("Z NOTATION LEFT BINDING BRACKET" . 10633)
                             ("Z NOTATION RIGHT BINDING BRACKET" . 10634)
                             ("LEFT SQUARE BRACKET WITH UNDERBAR" . 10635)
                             ("RIGHT SQUARE BRACKET WITH UNDERBAR" . 10636)
                             ("LEFT SQUARE BRACKET WITH TICK IN TOP CORNER" . 10637)
                             ("RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" . 10638)
                             ("LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER" . 10639)
                             ("RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER" . 10640)
                             ("LEFT ANGLE BRACKET WITH DOT" . 10641)
                             ("RIGHT ANGLE BRACKET WITH DOT" . 10642)
                             ("LEFT ARC LESS-THAN BRACKET" . 10643)
                             ("RIGHT ARC GREATER-THAN BRACKET" . 10644)
                             ("DOUBLE LEFT ARC GREATER-THAN BRACKET" . 10645)
                             ("DOUBLE RIGHT ARC LESS-THAN BRACKET" . 10646)
                             ("LEFT BLACK TORTOISE SHELL BRACKET" . 10647)
                             ("RIGHT BLACK TORTOISE SHELL BRACKET" . 10648)
                             ("DOTTED FENCE" . 10649)
                             ("VERTICAL ZIGZAG LINE" . 10650)
                             ("MEASURED ANGLE OPENING LEFT" . 10651)
                             ("RIGHT ANGLE VARIANT WITH SQUARE" . 10652)
                             ("MEASURED RIGHT ANGLE WITH DOT" . 10653)
                             ("ANGLE WITH S INSIDE" . 10654)
                             ("ACUTE ANGLE" . 10655)
                             ("SPHERICAL ANGLE OPENING LEFT" . 10656)
                             ("SPHERICAL ANGLE OPENING UP" . 10657)
                             ("TURNED ANGLE" . 10658)
                             ("REVERSED ANGLE" . 10659)
                             ("ANGLE WITH UNDERBAR" . 10660)
                             ("REVERSED ANGLE WITH UNDERBAR" . 10661)
                             ("OBLIQUE ANGLE OPENING UP" . 10662)
                             ("OBLIQUE ANGLE OPENING DOWN" . 10663)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT" . 10664)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT" . 10665)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT" . 10666)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT" . 10667)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP" . 10668)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP" . 10669)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN" . 10670)
                             ("MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN" . 10671)
                             ("REVERSED EMPTY SET" . 10672)
                             ("EMPTY SET WITH OVERBAR" . 10673)
                             ("EMPTY SET WITH SMALL CIRCLE ABOVE" . 10674)
                             ("EMPTY SET WITH RIGHT ARROW ABOVE" . 10675)
                             ("EMPTY SET WITH LEFT ARROW ABOVE" . 10676)
                             ("CIRCLE WITH HORIZONTAL BAR" . 10677)
                             ("CIRCLED VERTICAL BAR" . 10678)
                             ("CIRCLED PARALLEL" . 10679)
                             ("CIRCLED REVERSE SOLIDUS" . 10680)
                             ("CIRCLED PERPENDICULAR" . 10681)
                             ("CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR" . 10682)
                             ("CIRCLE WITH SUPERIMPOSED X" . 10683)
                             ("CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN" . 10684)
                             ("UP ARROW THROUGH CIRCLE" . 10685)
                             ("CIRCLED WHITE BULLET" . 10686)
                             ("CIRCLED BULLET" . 10687)
                             ("CIRCLED LESS-THAN" . 10688)
                             ("CIRCLED GREATER-THAN" . 10689)
                             ("CIRCLE WITH SMALL CIRCLE TO THE RIGHT" . 10690)
                             ("CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT" . 10691)
                             ("SQUARED RISING DIAGONAL SLASH" . 10692)
                             ("SQUARED FALLING DIAGONAL SLASH" . 10693)
                             ("SQUARED ASTERISK" . 10694)
                             ("SQUARED SMALL CIRCLE" . 10695)
                             ("SQUARED SQUARE" . 10696)
                             ("TWO JOINED SQUARES" . 10697)
                             ("TRIANGLE WITH DOT ABOVE" . 10698)
                             ("TRIANGLE WITH UNDERBAR" . 10699)
                             ("S IN TRIANGLE" . 10700)
                             ("TRIANGLE WITH SERIFS AT BOTTOM" . 10701)
                             ("RIGHT TRIANGLE ABOVE LEFT TRIANGLE" . 10702)
                             ("LEFT TRIANGLE BESIDE VERTICAL BAR" . 10703)
                             ("VERTICAL BAR BESIDE RIGHT TRIANGLE" . 10704)
                             ("BOWTIE WITH LEFT HALF BLACK" . 10705)
                             ("BOWTIE WITH RIGHT HALF BLACK" . 10706)
                             ("BLACK BOWTIE" . 10707)
                             ("TIMES WITH LEFT HALF BLACK" . 10708)
                             ("TIMES WITH RIGHT HALF BLACK" . 10709)
                             ("WHITE HOURGLASS" . 10710)
                             ("BLACK HOURGLASS" . 10711)
                             ("LEFT WIGGLY FENCE" . 10712)
                             ("RIGHT WIGGLY FENCE" . 10713)
                             ("LEFT DOUBLE WIGGLY FENCE" . 10714)
                             ("RIGHT DOUBLE WIGGLY FENCE" . 10715)
                             ("INCOMPLETE INFINITY" . 10716)
                             ("TIE OVER INFINITY" . 10717)
                             ("INFINITY NEGATED WITH VERTICAL BAR" . 10718)
                             ("DOUBLE-ENDED MULTIMAP" . 10719)
                             ("SQUARE WITH CONTOURED OUTLINE" . 10720)
                             ("INCREASES AS" . 10721)
                             ("SHUFFLE PRODUCT" . 10722)
                             ("EQUALS SIGN AND SLANTED PARALLEL" . 10723)
                             ("EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE" . 10724)
                             ("IDENTICAL TO AND SLANTED PARALLEL" . 10725)
                             ("GLEICH STARK" . 10726)
                             ("THERMODYNAMIC" . 10727)
                             ("DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK" . 10728)
                             ("DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK" . 10729)
                             ("BLACK DIAMOND WITH DOWN ARROW" . 10730)
                             ("BLACK LOZENGE" . 10731)
                             ("WHITE CIRCLE WITH DOWN ARROW" . 10732)
                             ("BLACK CIRCLE WITH DOWN ARROW" . 10733)
                             ("ERROR-BARRED WHITE SQUARE" . 10734)
                             ("ERROR-BARRED BLACK SQUARE" . 10735)
                             ("ERROR-BARRED WHITE DIAMOND" . 10736)
                             ("ERROR-BARRED BLACK DIAMOND" . 10737)
                             ("ERROR-BARRED WHITE CIRCLE" . 10738)
                             ("ERROR-BARRED BLACK CIRCLE" . 10739)
                             ("RULE-DELAYED" . 10740)
                             ("REVERSE SOLIDUS OPERATOR" . 10741)
                             ("SOLIDUS WITH OVERBAR" . 10742)
                             ("REVERSE SOLIDUS WITH HORIZONTAL STROKE" . 10743)
                             ("BIG SOLIDUS" . 10744)
                             ("BIG REVERSE SOLIDUS" . 10745)
                             ("DOUBLE PLUS" . 10746)
                             ("TRIPLE PLUS" . 10747)
                             ("LEFT-POINTING CURVED ANGLE BRACKET" . 10748)
                             ("RIGHT-POINTING CURVED ANGLE BRACKET" . 10749)
                             ("TINY" . 10750)
                             ("MINY" . 10751)
                             ("N-ARY CIRCLED DOT OPERATOR" . 10752)
                             ("N-ARY CIRCLED PLUS OPERATOR" . 10753)
                             ("N-ARY CIRCLED TIMES OPERATOR" . 10754)
                             ("N-ARY UNION OPERATOR WITH DOT" . 10755)
                             ("N-ARY UNION OPERATOR WITH PLUS" . 10756)
                             ("N-ARY SQUARE INTERSECTION OPERATOR" . 10757)
                             ("N-ARY SQUARE UNION OPERATOR" . 10758)
                             ("TWO LOGICAL AND OPERATOR" . 10759)
                             ("TWO LOGICAL OR OPERATOR" . 10760)
                             ("N-ARY TIMES OPERATOR" . 10761)
                             ("MODULO TWO SUM" . 10762)
                             ("SUMMATION WITH INTEGRAL" . 10763)
                             ("QUADRUPLE INTEGRAL OPERATOR" . 10764)
                             ("FINITE PART INTEGRAL" . 10765)
                             ("INTEGRAL WITH DOUBLE STROKE" . 10766)
                             ("INTEGRAL AVERAGE WITH SLASH" . 10767)
                             ("CIRCULATION FUNCTION" . 10768)
                             ("ANTICLOCKWISE INTEGRATION" . 10769)
                             ("LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE" . 10770)
                             ("LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE" . 10771)
                             ("LINE INTEGRATION NOT INCLUDING THE POLE" . 10772)
                             ("INTEGRAL AROUND A POINT OPERATOR" . 10773)
                             ("QUATERNION INTEGRAL OPERATOR" . 10774)
                             ("INTEGRAL WITH LEFTWARDS ARROW WITH HOOK" . 10775)
                             ("INTEGRAL WITH TIMES SIGN" . 10776)
                             ("INTEGRAL WITH INTERSECTION" . 10777)
                             ("INTEGRAL WITH UNION" . 10778)
                             ("INTEGRAL WITH OVERBAR" . 10779)
                             ("INTEGRAL WITH UNDERBAR" . 10780)
                             ("JOIN" . 10781)
                             ("LARGE LEFT TRIANGLE OPERATOR" . 10782)
                             ("Z NOTATION SCHEMA COMPOSITION" . 10783)
                             ("Z NOTATION SCHEMA PIPING" . 10784)
                             ("Z NOTATION SCHEMA PROJECTION" . 10785)
                             ("PLUS SIGN WITH SMALL CIRCLE ABOVE" . 10786)
                             ("PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE" . 10787)
                             ("PLUS SIGN WITH TILDE ABOVE" . 10788)
                             ("PLUS SIGN WITH DOT BELOW" . 10789)
                             ("PLUS SIGN WITH TILDE BELOW" . 10790)
                             ("PLUS SIGN WITH SUBSCRIPT TWO" . 10791)
                             ("PLUS SIGN WITH BLACK TRIANGLE" . 10792)
                             ("MINUS SIGN WITH COMMA ABOVE" . 10793)
                             ("MINUS SIGN WITH DOT BELOW" . 10794)
                             ("MINUS SIGN WITH FALLING DOTS" . 10795)
                             ("MINUS SIGN WITH RISING DOTS" . 10796)
                             ("PLUS SIGN IN LEFT HALF CIRCLE" . 10797)
                             ("PLUS SIGN IN RIGHT HALF CIRCLE" . 10798)
                             ("VECTOR OR CROSS PRODUCT" . 10799)
                             ("MULTIPLICATION SIGN WITH DOT ABOVE" . 10800)
                             ("MULTIPLICATION SIGN WITH UNDERBAR" . 10801)
                             ("SEMIDIRECT PRODUCT WITH BOTTOM CLOSED" . 10802)
                             ("SMASH PRODUCT" . 10803)
                             ("MULTIPLICATION SIGN IN LEFT HALF CIRCLE" . 10804)
                             ("MULTIPLICATION SIGN IN RIGHT HALF CIRCLE" . 10805)
                             ("CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT" . 10806)
                             ("MULTIPLICATION SIGN IN DOUBLE CIRCLE" . 10807)
                             ("CIRCLED DIVISION SIGN" . 10808)
                             ("PLUS SIGN IN TRIANGLE" . 10809)
                             ("MINUS SIGN IN TRIANGLE" . 10810)
                             ("MULTIPLICATION SIGN IN TRIANGLE" . 10811)
                             ("INTERIOR PRODUCT" . 10812)
                             ("RIGHTHAND INTERIOR PRODUCT" . 10813)
                             ("Z NOTATION RELATIONAL COMPOSITION" . 10814)
                             ("AMALGAMATION OR COPRODUCT" . 10815)
                             ("INTERSECTION WITH DOT" . 10816)
                             ("UNION WITH MINUS SIGN" . 10817)
                             ("UNION WITH OVERBAR" . 10818)
                             ("INTERSECTION WITH OVERBAR" . 10819)
                             ("INTERSECTION WITH LOGICAL AND" . 10820)
                             ("UNION WITH LOGICAL OR" . 10821)
                             ("UNION ABOVE INTERSECTION" . 10822)
                             ("INTERSECTION ABOVE UNION" . 10823)
                             ("UNION ABOVE BAR ABOVE INTERSECTION" . 10824)
                             ("INTERSECTION ABOVE BAR ABOVE UNION" . 10825)
                             ("UNION BESIDE AND JOINED WITH UNION" . 10826)
                             ("INTERSECTION BESIDE AND JOINED WITH INTERSECTION" . 10827)
                             ("CLOSED UNION WITH SERIFS" . 10828)
                             ("CLOSED INTERSECTION WITH SERIFS" . 10829)
                             ("DOUBLE SQUARE INTERSECTION" . 10830)
                             ("DOUBLE SQUARE UNION" . 10831)
                             ("CLOSED UNION WITH SERIFS AND SMASH PRODUCT" . 10832)
                             ("LOGICAL AND WITH DOT ABOVE" . 10833)
                             ("LOGICAL OR WITH DOT ABOVE" . 10834)
                             ("DOUBLE LOGICAL AND" . 10835)
                             ("DOUBLE LOGICAL OR" . 10836)
                             ("TWO INTERSECTING LOGICAL AND" . 10837)
                             ("TWO INTERSECTING LOGICAL OR" . 10838)
                             ("SLOPING LARGE OR" . 10839)
                             ("SLOPING LARGE AND" . 10840)
                             ("LOGICAL OR OVERLAPPING LOGICAL AND" . 10841)
                             ("LOGICAL AND WITH MIDDLE STEM" . 10842)
                             ("LOGICAL OR WITH MIDDLE STEM" . 10843)
                             ("LOGICAL AND WITH HORIZONTAL DASH" . 10844)
                             ("LOGICAL OR WITH HORIZONTAL DASH" . 10845)
                             ("LOGICAL AND WITH DOUBLE OVERBAR" . 10846)
                             ("LOGICAL AND WITH UNDERBAR" . 10847)
                             ("LOGICAL AND WITH DOUBLE UNDERBAR" . 10848)
                             ("SMALL VEE WITH UNDERBAR" . 10849)
                             ("LOGICAL OR WITH DOUBLE OVERBAR" . 10850)
                             ("LOGICAL OR WITH DOUBLE UNDERBAR" . 10851)
                             ("Z NOTATION DOMAIN ANTIRESTRICTION" . 10852)
                             ("Z NOTATION RANGE ANTIRESTRICTION" . 10853)
                             ("EQUALS SIGN WITH DOT BELOW" . 10854)
                             ("IDENTICAL WITH DOT ABOVE" . 10855)
                             ("TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE" . 10856)
                             ("TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE" . 10857)
                             ("TILDE OPERATOR WITH DOT ABOVE" . 10858)
                             ("TILDE OPERATOR WITH RISING DOTS" . 10859)
                             ("SIMILAR MINUS SIMILAR" . 10860)
                             ("CONGRUENT WITH DOT ABOVE" . 10861)
                             ("EQUALS WITH ASTERISK" . 10862)
                             ("ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT" . 10863)
                             ("APPROXIMATELY EQUAL OR EQUAL TO" . 10864)
                             ("EQUALS SIGN ABOVE PLUS SIGN" . 10865)
                             ("PLUS SIGN ABOVE EQUALS SIGN" . 10866)
                             ("EQUALS SIGN ABOVE TILDE OPERATOR" . 10867)
                             ("DOUBLE COLON EQUAL" . 10868)
                             ("TWO CONSECUTIVE EQUALS SIGNS" . 10869)
                             ("THREE CONSECUTIVE EQUALS SIGNS" . 10870)
                             ("EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW" . 10871)
                             ("EQUIVALENT WITH FOUR DOTS ABOVE" . 10872)
                             ("LESS-THAN WITH CIRCLE INSIDE" . 10873)
                             ("GREATER-THAN WITH CIRCLE INSIDE" . 10874)
                             ("LESS-THAN WITH QUESTION MARK ABOVE" . 10875)
                             ("GREATER-THAN WITH QUESTION MARK ABOVE" . 10876)
                             ("LESS-THAN OR SLANTED EQUAL TO" . 10877)
                             ("GREATER-THAN OR SLANTED EQUAL TO" . 10878)
                             ("LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" . 10879)
                             ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE" . 10880)
                             ("LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" . 10881)
                             ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE" . 10882)
                             ("LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT" . 10883)
                             ("GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT" . 10884)
                             ("LESS-THAN OR APPROXIMATE" . 10885)
                             ("GREATER-THAN OR APPROXIMATE" . 10886)
                             ("LESS-THAN AND SINGLE-LINE NOT EQUAL TO" . 10887)
                             ("GREATER-THAN AND SINGLE-LINE NOT EQUAL TO" . 10888)
                             ("LESS-THAN AND NOT APPROXIMATE" . 10889)
                             ("GREATER-THAN AND NOT APPROXIMATE" . 10890)
                             ("LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN" . 10891)
                             ("GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN" . 10892)
                             ("LESS-THAN ABOVE SIMILAR OR EQUAL" . 10893)
                             ("GREATER-THAN ABOVE SIMILAR OR EQUAL" . 10894)
                             ("LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN" . 10895)
                             ("GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN" . 10896)
                             ("LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL" . 10897)
                             ("GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL" . 10898)
                             ("LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL" . 10899)
                             ("GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL" . 10900)
                             ("SLANTED EQUAL TO OR LESS-THAN" . 10901)
                             ("SLANTED EQUAL TO OR GREATER-THAN" . 10902)
                             ("SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE" . 10903)
                             ("SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE" . 10904)
                             ("DOUBLE-LINE EQUAL TO OR LESS-THAN" . 10905)
                             ("DOUBLE-LINE EQUAL TO OR GREATER-THAN" . 10906)
                             ("DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN" . 10907)
                             ("DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN" . 10908)
                             ("SIMILAR OR LESS-THAN" . 10909)
                             ("SIMILAR OR GREATER-THAN" . 10910)
                             ("SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN" . 10911)
                             ("SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN" . 10912)
                             ("DOUBLE NESTED LESS-THAN" . 10913)
                             ("DOUBLE NESTED GREATER-THAN" . 10914)
                             ("DOUBLE NESTED LESS-THAN WITH UNDERBAR" . 10915)
                             ("GREATER-THAN OVERLAPPING LESS-THAN" . 10916)
                             ("GREATER-THAN BESIDE LESS-THAN" . 10917)
                             ("LESS-THAN CLOSED BY CURVE" . 10918)
                             ("GREATER-THAN CLOSED BY CURVE" . 10919)
                             ("LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" . 10920)
                             ("GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL" . 10921)
                             ("SMALLER THAN" . 10922)
                             ("LARGER THAN" . 10923)
                             ("SMALLER THAN OR EQUAL TO" . 10924)
                             ("LARGER THAN OR EQUAL TO" . 10925)
                             ("EQUALS SIGN WITH BUMPY ABOVE" . 10926)
                             ("PRECEDES ABOVE SINGLE-LINE EQUALS SIGN" . 10927)
                             ("SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN" . 10928)
                             ("PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO" . 10929)
                             ("SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO" . 10930)
                             ("PRECEDES ABOVE EQUALS SIGN" . 10931)
                             ("SUCCEEDS ABOVE EQUALS SIGN" . 10932)
                             ("PRECEDES ABOVE NOT EQUAL TO" . 10933)
                             ("SUCCEEDS ABOVE NOT EQUAL TO" . 10934)
                             ("PRECEDES ABOVE ALMOST EQUAL TO" . 10935)
                             ("SUCCEEDS ABOVE ALMOST EQUAL TO" . 10936)
                             ("PRECEDES ABOVE NOT ALMOST EQUAL TO" . 10937)
                             ("SUCCEEDS ABOVE NOT ALMOST EQUAL TO" . 10938)
                             ("DOUBLE PRECEDES" . 10939)
                             ("DOUBLE SUCCEEDS" . 10940)
                             ("SUBSET WITH DOT" . 10941)
                             ("SUPERSET WITH DOT" . 10942)
                             ("SUBSET WITH PLUS SIGN BELOW" . 10943)
                             ("SUPERSET WITH PLUS SIGN BELOW" . 10944)
                             ("SUBSET WITH MULTIPLICATION SIGN BELOW" . 10945)
                             ("SUPERSET WITH MULTIPLICATION SIGN BELOW" . 10946)
                             ("SUBSET OF OR EQUAL TO WITH DOT ABOVE" . 10947)
                             ("SUPERSET OF OR EQUAL TO WITH DOT ABOVE" . 10948)
                             ("SUBSET OF ABOVE EQUALS SIGN" . 10949)
                             ("SUPERSET OF ABOVE EQUALS SIGN" . 10950)
                             ("SUBSET OF ABOVE TILDE OPERATOR" . 10951)
                             ("SUPERSET OF ABOVE TILDE OPERATOR" . 10952)
                             ("SUBSET OF ABOVE ALMOST EQUAL TO" . 10953)
                             ("SUPERSET OF ABOVE ALMOST EQUAL TO" . 10954)
                             ("SUBSET OF ABOVE NOT EQUAL TO" . 10955)
                             ("SUPERSET OF ABOVE NOT EQUAL TO" . 10956)
                             ("SQUARE LEFT OPEN BOX OPERATOR" . 10957)
                             ("SQUARE RIGHT OPEN BOX OPERATOR" . 10958)
                             ("CLOSED SUBSET" . 10959)
                             ("CLOSED SUPERSET" . 10960)
                             ("CLOSED SUBSET OR EQUAL TO" . 10961)
                             ("CLOSED SUPERSET OR EQUAL TO" . 10962)
                             ("SUBSET ABOVE SUPERSET" . 10963)
                             ("SUPERSET ABOVE SUBSET" . 10964)
                             ("SUBSET ABOVE SUBSET" . 10965)
                             ("SUPERSET ABOVE SUPERSET" . 10966)
                             ("SUPERSET BESIDE SUBSET" . 10967)
                             ("SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET" . 10968)
                             ("ELEMENT OF OPENING DOWNWARDS" . 10969)
                             ("PITCHFORK WITH TEE TOP" . 10970)
                             ("TRANSVERSAL INTERSECTION" . 10971)
                             ("FORKING" . 10972)
                             ("NONFORKING" . 10973)
                             ("SHORT LEFT TACK" . 10974)
                             ("SHORT DOWN TACK" . 10975)
                             ("SHORT UP TACK" . 10976)
                             ("PERPENDICULAR WITH S" . 10977)
                             ("VERTICAL BAR TRIPLE RIGHT TURNSTILE" . 10978)
                             ("DOUBLE VERTICAL BAR LEFT TURNSTILE" . 10979)
                             ("VERTICAL BAR DOUBLE LEFT TURNSTILE" . 10980)
                             ("DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE" . 10981)
                             ("LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL" . 10982)
                             ("SHORT DOWN TACK WITH OVERBAR" . 10983)
                             ("SHORT UP TACK WITH UNDERBAR" . 10984)
                             ("SHORT UP TACK ABOVE SHORT DOWN TACK" . 10985)
                             ("DOUBLE DOWN TACK" . 10986)
                             ("DOUBLE UP TACK" . 10987)
                             ("DOUBLE STROKE NOT SIGN" . 10988)
                             ("REVERSED DOUBLE STROKE NOT SIGN" . 10989)
                             ("DOES NOT DIVIDE WITH REVERSED NEGATION SLASH" . 10990)
                             ("VERTICAL LINE WITH CIRCLE ABOVE" . 10991)
                             ("VERTICAL LINE WITH CIRCLE BELOW" . 10992)
                             ("DOWN TACK WITH CIRCLE BELOW" . 10993)
                             ("PARALLEL WITH HORIZONTAL STROKE" . 10994)
                             ("PARALLEL WITH TILDE OPERATOR" . 10995)
                             ("TRIPLE VERTICAL BAR BINARY RELATION" . 10996)
                             ("TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE" . 10997)
                             ("TRIPLE COLON OPERATOR" . 10998)
                             ("TRIPLE NESTED LESS-THAN" . 10999)
                             ("TRIPLE NESTED GREATER-THAN" . 11000)
                             ("DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO" . 11001)
                             ("DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO" . 11002)
                             ("TRIPLE SOLIDUS BINARY RELATION" . 11003)
                             ("LARGE TRIPLE VERTICAL BAR OPERATOR" . 11004)
                             ("DOUBLE SOLIDUS OPERATOR" . 11005)
                             ("WHITE VERTICAL BAR" . 11006)
                             ("N-ARY WHITE VERTICAL BAR" . 11007)
                             ("CJK RADICAL REPEAT" . 11904)
                             ("CJK RADICAL CLIFF" . 11905)
                             ("CJK RADICAL SECOND ONE" . 11906)
                             ("CJK RADICAL SECOND TWO" . 11907)
                             ("CJK RADICAL SECOND THREE" . 11908)
                             ("CJK RADICAL PERSON" . 11909)
                             ("CJK RADICAL BOX" . 11910)
                             ("CJK RADICAL TABLE" . 11911)
                             ("CJK RADICAL KNIFE ONE" . 11912)
                             ("CJK RADICAL KNIFE TWO" . 11913)
                             ("CJK RADICAL DIVINATION" . 11914)
                             ("CJK RADICAL SEAL" . 11915)
                             ("CJK RADICAL SMALL ONE" . 11916)
                             ("CJK RADICAL SMALL TWO" . 11917)
                             ("CJK RADICAL LAME ONE" . 11918)
                             ("CJK RADICAL LAME TWO" . 11919)
                             ("CJK RADICAL LAME THREE" . 11920)
                             ("CJK RADICAL LAME FOUR" . 11921)
                             ("CJK RADICAL SNAKE" . 11922)
                             ("CJK RADICAL THREAD" . 11923)
                             ("CJK RADICAL SNOUT ONE" . 11924)
                             ("CJK RADICAL SNOUT TWO" . 11925)
                             ("CJK RADICAL HEART ONE" . 11926)
                             ("CJK RADICAL HEART TWO" . 11927)
                             ("CJK RADICAL HAND" . 11928)
                             ("CJK RADICAL RAP" . 11929)
                             ("CJK RADICAL CHOKE" . 11931)
                             ("CJK RADICAL SUN" . 11932)
                             ("CJK RADICAL MOON" . 11933)
                             ("CJK RADICAL DEATH" . 11934)
                             ("CJK RADICAL MOTHER" . 11935)
                             ("CJK RADICAL CIVILIAN" . 11936)
                             ("CJK RADICAL WATER ONE" . 11937)
                             ("CJK RADICAL WATER TWO" . 11938)
                             ("CJK RADICAL FIRE" . 11939)
                             ("CJK RADICAL PAW ONE" . 11940)
                             ("CJK RADICAL PAW TWO" . 11941)
                             ("CJK RADICAL SIMPLIFIED HALF TREE TRUNK" . 11942)
                             ("CJK RADICAL COW" . 11943)
                             ("CJK RADICAL DOG" . 11944)
                             ("CJK RADICAL JADE" . 11945)
                             ("CJK RADICAL BOLT OF CLOTH" . 11946)
                             ("CJK RADICAL EYE" . 11947)
                             ("CJK RADICAL SPIRIT ONE" . 11948)
                             ("CJK RADICAL SPIRIT TWO" . 11949)
                             ("CJK RADICAL BAMBOO" . 11950)
                             ("CJK RADICAL SILK" . 11951)
                             ("CJK RADICAL C-SIMPLIFIED SILK" . 11952)
                             ("CJK RADICAL NET ONE" . 11953)
                             ("CJK RADICAL NET TWO" . 11954)
                             ("CJK RADICAL NET THREE" . 11955)
                             ("CJK RADICAL NET FOUR" . 11956)
                             ("CJK RADICAL MESH" . 11957)
                             ("CJK RADICAL SHEEP" . 11958)
                             ("CJK RADICAL RAM" . 11959)
                             ("CJK RADICAL EWE" . 11960)
                             ("CJK RADICAL OLD" . 11961)
                             ("CJK RADICAL BRUSH ONE" . 11962)
                             ("CJK RADICAL BRUSH TWO" . 11963)
                             ("CJK RADICAL MEAT" . 11964)
                             ("CJK RADICAL MORTAR" . 11965)
                             ("CJK RADICAL GRASS ONE" . 11966)
                             ("CJK RADICAL GRASS TWO" . 11967)
                             ("CJK RADICAL GRASS THREE" . 11968)
                             ("CJK RADICAL TIGER" . 11969)
                             ("CJK RADICAL CLOTHES" . 11970)
                             ("CJK RADICAL WEST ONE" . 11971)
                             ("CJK RADICAL WEST TWO" . 11972)
                             ("CJK RADICAL C-SIMPLIFIED SEE" . 11973)
                             ("CJK RADICAL SIMPLIFIED HORN" . 11974)
                             ("CJK RADICAL HORN" . 11975)
                             ("CJK RADICAL C-SIMPLIFIED SPEECH" . 11976)
                             ("CJK RADICAL C-SIMPLIFIED SHELL" . 11977)
                             ("CJK RADICAL FOOT" . 11978)
                             ("CJK RADICAL C-SIMPLIFIED CART" . 11979)
                             ("CJK RADICAL SIMPLIFIED WALK" . 11980)
                             ("CJK RADICAL WALK ONE" . 11981)
                             ("CJK RADICAL WALK TWO" . 11982)
                             ("CJK RADICAL CITY" . 11983)
                             ("CJK RADICAL C-SIMPLIFIED GOLD" . 11984)
                             ("CJK RADICAL LONG ONE" . 11985)
                             ("CJK RADICAL LONG TWO" . 11986)
                             ("CJK RADICAL C-SIMPLIFIED LONG" . 11987)
                             ("CJK RADICAL C-SIMPLIFIED GATE" . 11988)
                             ("CJK RADICAL MOUND ONE" . 11989)
                             ("CJK RADICAL MOUND TWO" . 11990)
                             ("CJK RADICAL RAIN" . 11991)
                             ("CJK RADICAL BLUE" . 11992)
                             ("CJK RADICAL C-SIMPLIFIED TANNED LEATHER" . 11993)
                             ("CJK RADICAL C-SIMPLIFIED LEAF" . 11994)
                             ("CJK RADICAL C-SIMPLIFIED WIND" . 11995)
                             ("CJK RADICAL C-SIMPLIFIED FLY" . 11996)
                             ("CJK RADICAL EAT ONE" . 11997)
                             ("CJK RADICAL EAT TWO" . 11998)
                             ("CJK RADICAL EAT THREE" . 11999)
                             ("CJK RADICAL C-SIMPLIFIED EAT" . 12000)
                             ("CJK RADICAL HEAD" . 12001)
                             ("CJK RADICAL C-SIMPLIFIED HORSE" . 12002)
                             ("CJK RADICAL BONE" . 12003)
                             ("CJK RADICAL GHOST" . 12004)
                             ("CJK RADICAL C-SIMPLIFIED FISH" . 12005)
                             ("CJK RADICAL C-SIMPLIFIED BIRD" . 12006)
                             ("CJK RADICAL C-SIMPLIFIED SALT" . 12007)
                             ("CJK RADICAL SIMPLIFIED WHEAT" . 12008)
                             ("CJK RADICAL SIMPLIFIED YELLOW" . 12009)
                             ("CJK RADICAL C-SIMPLIFIED FROG" . 12010)
                             ("CJK RADICAL J-SIMPLIFIED EVEN" . 12011)
                             ("CJK RADICAL C-SIMPLIFIED EVEN" . 12012)
                             ("CJK RADICAL J-SIMPLIFIED TOOTH" . 12013)
                             ("CJK RADICAL C-SIMPLIFIED TOOTH" . 12014)
                             ("CJK RADICAL J-SIMPLIFIED DRAGON" . 12015)
                             ("CJK RADICAL C-SIMPLIFIED DRAGON" . 12016)
                             ("CJK RADICAL TURTLE" . 12017)
                             ("CJK RADICAL J-SIMPLIFIED TURTLE" . 12018)
                             ("CJK RADICAL C-SIMPLIFIED TURTLE" . 12019)
                             ("KANGXI RADICAL ONE" . 12032)
                             ("KANGXI RADICAL LINE" . 12033)
                             ("KANGXI RADICAL DOT" . 12034)
                             ("KANGXI RADICAL SLASH" . 12035)
                             ("KANGXI RADICAL SECOND" . 12036)
                             ("KANGXI RADICAL HOOK" . 12037)
                             ("KANGXI RADICAL TWO" . 12038)
                             ("KANGXI RADICAL LID" . 12039)
                             ("KANGXI RADICAL MAN" . 12040)
                             ("KANGXI RADICAL LEGS" . 12041)
                             ("KANGXI RADICAL ENTER" . 12042)
                             ("KANGXI RADICAL EIGHT" . 12043)
                             ("KANGXI RADICAL DOWN BOX" . 12044)
                             ("KANGXI RADICAL COVER" . 12045)
                             ("KANGXI RADICAL ICE" . 12046)
                             ("KANGXI RADICAL TABLE" . 12047)
                             ("KANGXI RADICAL OPEN BOX" . 12048)
                             ("KANGXI RADICAL KNIFE" . 12049)
                             ("KANGXI RADICAL POWER" . 12050)
                             ("KANGXI RADICAL WRAP" . 12051)
                             ("KANGXI RADICAL SPOON" . 12052)
                             ("KANGXI RADICAL RIGHT OPEN BOX" . 12053)
                             ("KANGXI RADICAL HIDING ENCLOSURE" . 12054)
                             ("KANGXI RADICAL TEN" . 12055)
                             ("KANGXI RADICAL DIVINATION" . 12056)
                             ("KANGXI RADICAL SEAL" . 12057)
                             ("KANGXI RADICAL CLIFF" . 12058)
                             ("KANGXI RADICAL PRIVATE" . 12059)
                             ("KANGXI RADICAL AGAIN" . 12060)
                             ("KANGXI RADICAL MOUTH" . 12061)
                             ("KANGXI RADICAL ENCLOSURE" . 12062)
                             ("KANGXI RADICAL EARTH" . 12063)
                             ("KANGXI RADICAL SCHOLAR" . 12064)
                             ("KANGXI RADICAL GO" . 12065)
                             ("KANGXI RADICAL GO SLOWLY" . 12066)
                             ("KANGXI RADICAL EVENING" . 12067)
                             ("KANGXI RADICAL BIG" . 12068)
                             ("KANGXI RADICAL WOMAN" . 12069)
                             ("KANGXI RADICAL CHILD" . 12070)
                             ("KANGXI RADICAL ROOF" . 12071)
                             ("KANGXI RADICAL INCH" . 12072)
                             ("KANGXI RADICAL SMALL" . 12073)
                             ("KANGXI RADICAL LAME" . 12074)
                             ("KANGXI RADICAL CORPSE" . 12075)
                             ("KANGXI RADICAL SPROUT" . 12076)
                             ("KANGXI RADICAL MOUNTAIN" . 12077)
                             ("KANGXI RADICAL RIVER" . 12078)
                             ("KANGXI RADICAL WORK" . 12079)
                             ("KANGXI RADICAL ONESELF" . 12080)
                             ("KANGXI RADICAL TURBAN" . 12081)
                             ("KANGXI RADICAL DRY" . 12082)
                             ("KANGXI RADICAL SHORT THREAD" . 12083)
                             ("KANGXI RADICAL DOTTED CLIFF" . 12084)
                             ("KANGXI RADICAL LONG STRIDE" . 12085)
                             ("KANGXI RADICAL TWO HANDS" . 12086)
                             ("KANGXI RADICAL SHOOT" . 12087)
                             ("KANGXI RADICAL BOW" . 12088)
                             ("KANGXI RADICAL SNOUT" . 12089)
                             ("KANGXI RADICAL BRISTLE" . 12090)
                             ("KANGXI RADICAL STEP" . 12091)
                             ("KANGXI RADICAL HEART" . 12092)
                             ("KANGXI RADICAL HALBERD" . 12093)
                             ("KANGXI RADICAL DOOR" . 12094)
                             ("KANGXI RADICAL HAND" . 12095)
                             ("KANGXI RADICAL BRANCH" . 12096)
                             ("KANGXI RADICAL RAP" . 12097)
                             ("KANGXI RADICAL SCRIPT" . 12098)
                             ("KANGXI RADICAL DIPPER" . 12099)
                             ("KANGXI RADICAL AXE" . 12100)
                             ("KANGXI RADICAL SQUARE" . 12101)
                             ("KANGXI RADICAL NOT" . 12102)
                             ("KANGXI RADICAL SUN" . 12103)
                             ("KANGXI RADICAL SAY" . 12104)
                             ("KANGXI RADICAL MOON" . 12105)
                             ("KANGXI RADICAL TREE" . 12106)
                             ("KANGXI RADICAL LACK" . 12107)
                             ("KANGXI RADICAL STOP" . 12108)
                             ("KANGXI RADICAL DEATH" . 12109)
                             ("KANGXI RADICAL WEAPON" . 12110)
                             ("KANGXI RADICAL DO NOT" . 12111)
                             ("KANGXI RADICAL COMPARE" . 12112)
                             ("KANGXI RADICAL FUR" . 12113)
                             ("KANGXI RADICAL CLAN" . 12114)
                             ("KANGXI RADICAL STEAM" . 12115)
                             ("KANGXI RADICAL WATER" . 12116)
                             ("KANGXI RADICAL FIRE" . 12117)
                             ("KANGXI RADICAL CLAW" . 12118)
                             ("KANGXI RADICAL FATHER" . 12119)
                             ("KANGXI RADICAL DOUBLE X" . 12120)
                             ("KANGXI RADICAL HALF TREE TRUNK" . 12121)
                             ("KANGXI RADICAL SLICE" . 12122)
                             ("KANGXI RADICAL FANG" . 12123)
                             ("KANGXI RADICAL COW" . 12124)
                             ("KANGXI RADICAL DOG" . 12125)
                             ("KANGXI RADICAL PROFOUND" . 12126)
                             ("KANGXI RADICAL JADE" . 12127)
                             ("KANGXI RADICAL MELON" . 12128)
                             ("KANGXI RADICAL TILE" . 12129)
                             ("KANGXI RADICAL SWEET" . 12130)
                             ("KANGXI RADICAL LIFE" . 12131)
                             ("KANGXI RADICAL USE" . 12132)
                             ("KANGXI RADICAL FIELD" . 12133)
                             ("KANGXI RADICAL BOLT OF CLOTH" . 12134)
                             ("KANGXI RADICAL SICKNESS" . 12135)
                             ("KANGXI RADICAL DOTTED TENT" . 12136)
                             ("KANGXI RADICAL WHITE" . 12137)
                             ("KANGXI RADICAL SKIN" . 12138)
                             ("KANGXI RADICAL DISH" . 12139)
                             ("KANGXI RADICAL EYE" . 12140)
                             ("KANGXI RADICAL SPEAR" . 12141)
                             ("KANGXI RADICAL ARROW" . 12142)
                             ("KANGXI RADICAL STONE" . 12143)
                             ("KANGXI RADICAL SPIRIT" . 12144)
                             ("KANGXI RADICAL TRACK" . 12145)
                             ("KANGXI RADICAL GRAIN" . 12146)
                             ("KANGXI RADICAL CAVE" . 12147)
                             ("KANGXI RADICAL STAND" . 12148)
                             ("KANGXI RADICAL BAMBOO" . 12149)
                             ("KANGXI RADICAL RICE" . 12150)
                             ("KANGXI RADICAL SILK" . 12151)
                             ("KANGXI RADICAL JAR" . 12152)
                             ("KANGXI RADICAL NET" . 12153)
                             ("KANGXI RADICAL SHEEP" . 12154)
                             ("KANGXI RADICAL FEATHER" . 12155)
                             ("KANGXI RADICAL OLD" . 12156)
                             ("KANGXI RADICAL AND" . 12157)
                             ("KANGXI RADICAL PLOW" . 12158)
                             ("KANGXI RADICAL EAR" . 12159)
                             ("KANGXI RADICAL BRUSH" . 12160)
                             ("KANGXI RADICAL MEAT" . 12161)
                             ("KANGXI RADICAL MINISTER" . 12162)
                             ("KANGXI RADICAL SELF" . 12163)
                             ("KANGXI RADICAL ARRIVE" . 12164)
                             ("KANGXI RADICAL MORTAR" . 12165)
                             ("KANGXI RADICAL TONGUE" . 12166)
                             ("KANGXI RADICAL OPPOSE" . 12167)
                             ("KANGXI RADICAL BOAT" . 12168)
                             ("KANGXI RADICAL STOPPING" . 12169)
                             ("KANGXI RADICAL COLOR" . 12170)
                             ("KANGXI RADICAL GRASS" . 12171)
                             ("KANGXI RADICAL TIGER" . 12172)
                             ("KANGXI RADICAL INSECT" . 12173)
                             ("KANGXI RADICAL BLOOD" . 12174)
                             ("KANGXI RADICAL WALK ENCLOSURE" . 12175)
                             ("KANGXI RADICAL CLOTHES" . 12176)
                             ("KANGXI RADICAL WEST" . 12177)
                             ("KANGXI RADICAL SEE" . 12178)
                             ("KANGXI RADICAL HORN" . 12179)
                             ("KANGXI RADICAL SPEECH" . 12180)
                             ("KANGXI RADICAL VALLEY" . 12181)
                             ("KANGXI RADICAL BEAN" . 12182)
                             ("KANGXI RADICAL PIG" . 12183)
                             ("KANGXI RADICAL BADGER" . 12184)
                             ("KANGXI RADICAL SHELL" . 12185)
                             ("KANGXI RADICAL RED" . 12186)
                             ("KANGXI RADICAL RUN" . 12187)
                             ("KANGXI RADICAL FOOT" . 12188)
                             ("KANGXI RADICAL BODY" . 12189)
                             ("KANGXI RADICAL CART" . 12190)
                             ("KANGXI RADICAL BITTER" . 12191)
                             ("KANGXI RADICAL MORNING" . 12192)
                             ("KANGXI RADICAL WALK" . 12193)
                             ("KANGXI RADICAL CITY" . 12194)
                             ("KANGXI RADICAL WINE" . 12195)
                             ("KANGXI RADICAL DISTINGUISH" . 12196)
                             ("KANGXI RADICAL VILLAGE" . 12197)
                             ("KANGXI RADICAL GOLD" . 12198)
                             ("KANGXI RADICAL LONG" . 12199)
                             ("KANGXI RADICAL GATE" . 12200)
                             ("KANGXI RADICAL MOUND" . 12201)
                             ("KANGXI RADICAL SLAVE" . 12202)
                             ("KANGXI RADICAL SHORT TAILED BIRD" . 12203)
                             ("KANGXI RADICAL RAIN" . 12204)
                             ("KANGXI RADICAL BLUE" . 12205)
                             ("KANGXI RADICAL WRONG" . 12206)
                             ("KANGXI RADICAL FACE" . 12207)
                             ("KANGXI RADICAL LEATHER" . 12208)
                             ("KANGXI RADICAL TANNED LEATHER" . 12209)
                             ("KANGXI RADICAL LEEK" . 12210)
                             ("KANGXI RADICAL SOUND" . 12211)
                             ("KANGXI RADICAL LEAF" . 12212)
                             ("KANGXI RADICAL WIND" . 12213)
                             ("KANGXI RADICAL FLY" . 12214)
                             ("KANGXI RADICAL EAT" . 12215)
                             ("KANGXI RADICAL HEAD" . 12216)
                             ("KANGXI RADICAL FRAGRANT" . 12217)
                             ("KANGXI RADICAL HORSE" . 12218)
                             ("KANGXI RADICAL BONE" . 12219)
                             ("KANGXI RADICAL TALL" . 12220)
                             ("KANGXI RADICAL HAIR" . 12221)
                             ("KANGXI RADICAL FIGHT" . 12222)
                             ("KANGXI RADICAL SACRIFICIAL WINE" . 12223)
                             ("KANGXI RADICAL CAULDRON" . 12224)
                             ("KANGXI RADICAL GHOST" . 12225)
                             ("KANGXI RADICAL FISH" . 12226)
                             ("KANGXI RADICAL BIRD" . 12227)
                             ("KANGXI RADICAL SALT" . 12228)
                             ("KANGXI RADICAL DEER" . 12229)
                             ("KANGXI RADICAL WHEAT" . 12230)
                             ("KANGXI RADICAL HEMP" . 12231)
                             ("KANGXI RADICAL YELLOW" . 12232)
                             ("KANGXI RADICAL MILLET" . 12233)
                             ("KANGXI RADICAL BLACK" . 12234)
                             ("KANGXI RADICAL EMBROIDERY" . 12235)
                             ("KANGXI RADICAL FROG" . 12236)
                             ("KANGXI RADICAL TRIPOD" . 12237)
                             ("KANGXI RADICAL DRUM" . 12238)
                             ("KANGXI RADICAL RAT" . 12239)
                             ("KANGXI RADICAL NOSE" . 12240)
                             ("KANGXI RADICAL EVEN" . 12241)
                             ("KANGXI RADICAL TOOTH" . 12242)
                             ("KANGXI RADICAL DRAGON" . 12243)
                             ("KANGXI RADICAL TURTLE" . 12244)
                             ("KANGXI RADICAL FLUTE" . 12245)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT" . 12272)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW" . 12273)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT" . 12274)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW" . 12275)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND" . 12276)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE" . 12277)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW" . 12278)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT" . 12279)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT" . 12280)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT" . 12281)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT" . 12282)
                             ("IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID" . 12283)
                             ("IDEOGRAPHIC SPACE" . 12288)
                             ("IDEOGRAPHIC COMMA" . 12289)
                             ("IDEOGRAPHIC FULL STOP" . 12290)
                             ("DITTO MARK" . 12291)
                             ("JAPANESE INDUSTRIAL STANDARD SYMBOL" . 12292)
                             ("IDEOGRAPHIC ITERATION MARK" . 12293)
                             ("IDEOGRAPHIC CLOSING MARK" . 12294)
                             ("IDEOGRAPHIC NUMBER ZERO" . 12295)
                             ("LEFT ANGLE BRACKET" . 12296)
                             ("RIGHT ANGLE BRACKET" . 12297)
                             ("LEFT DOUBLE ANGLE BRACKET" . 12298)
                             ("RIGHT DOUBLE ANGLE BRACKET" . 12299)
                             ("LEFT CORNER BRACKET" . 12300)
                             ("RIGHT CORNER BRACKET" . 12301)
                             ("LEFT WHITE CORNER BRACKET" . 12302)
                             ("RIGHT WHITE CORNER BRACKET" . 12303)
                             ("LEFT BLACK LENTICULAR BRACKET" . 12304)
                             ("RIGHT BLACK LENTICULAR BRACKET" . 12305)
                             ("POSTAL MARK" . 12306)
                             ("GETA MARK" . 12307)
                             ("LEFT TORTOISE SHELL BRACKET" . 12308)
                             ("RIGHT TORTOISE SHELL BRACKET" . 12309)
                             ("LEFT WHITE LENTICULAR BRACKET" . 12310)
                             ("RIGHT WHITE LENTICULAR BRACKET" . 12311)
                             ("LEFT WHITE TORTOISE SHELL BRACKET" . 12312)
                             ("RIGHT WHITE TORTOISE SHELL BRACKET" . 12313)
                             ("LEFT WHITE SQUARE BRACKET" . 12314)
                             ("RIGHT WHITE SQUARE BRACKET" . 12315)
                             ("WAVE DASH" . 12316)
                             ("REVERSED DOUBLE PRIME QUOTATION MARK" . 12317)
                             ("DOUBLE PRIME QUOTATION MARK" . 12318)
                             ("LOW DOUBLE PRIME QUOTATION MARK" . 12319)
                             ("POSTAL MARK FACE" . 12320)
                             ("HANGZHOU NUMERAL ONE" . 12321)
                             ("HANGZHOU NUMERAL TWO" . 12322)
                             ("HANGZHOU NUMERAL THREE" . 12323)
                             ("HANGZHOU NUMERAL FOUR" . 12324)
                             ("HANGZHOU NUMERAL FIVE" . 12325)
                             ("HANGZHOU NUMERAL SIX" . 12326)
                             ("HANGZHOU NUMERAL SEVEN" . 12327)
                             ("HANGZHOU NUMERAL EIGHT" . 12328)
                             ("HANGZHOU NUMERAL NINE" . 12329)
                             ("IDEOGRAPHIC LEVEL TONE MARK" . 12330)
                             ("IDEOGRAPHIC RISING TONE MARK" . 12331)
                             ("IDEOGRAPHIC DEPARTING TONE MARK" . 12332)
                             ("IDEOGRAPHIC ENTERING TONE MARK" . 12333)
                             ("HANGUL SINGLE DOT TONE MARK" . 12334)
                             ("HANGUL DOUBLE DOT TONE MARK" . 12335)
                             ("WAVY DASH" . 12336)
                             ("VERTICAL KANA REPEAT MARK" . 12337)
                             ("VERTICAL KANA REPEAT WITH VOICED SOUND MARK" . 12338)
                             ("VERTICAL KANA REPEAT MARK UPPER HALF" . 12339)
                             ("VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF" . 12340)
                             ("VERTICAL KANA REPEAT MARK LOWER HALF" . 12341)
                             ("CIRCLED POSTAL MARK" . 12342)
                             ("IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL" . 12343)
                             ("HANGZHOU NUMERAL TEN" . 12344)
                             ("HANGZHOU NUMERAL TWENTY" . 12345)
                             ("HANGZHOU NUMERAL THIRTY" . 12346)
                             ("VERTICAL IDEOGRAPHIC ITERATION MARK" . 12347)
                             ("MASU MARK" . 12348)
                             ("PART ALTERNATION MARK" . 12349)
                             ("IDEOGRAPHIC VARIATION INDICATOR" . 12350)
                             ("IDEOGRAPHIC HALF FILL SPACE" . 12351)
                             ("HIRAGANA LETTER SMALL A" . 12353)
                             ("HIRAGANA LETTER A" . 12354)
                             ("HIRAGANA LETTER SMALL I" . 12355)
                             ("HIRAGANA LETTER I" . 12356)
                             ("HIRAGANA LETTER SMALL U" . 12357)
                             ("HIRAGANA LETTER U" . 12358)
                             ("HIRAGANA LETTER SMALL E" . 12359)
                             ("HIRAGANA LETTER E" . 12360)
                             ("HIRAGANA LETTER SMALL O" . 12361)
                             ("HIRAGANA LETTER O" . 12362)
                             ("HIRAGANA LETTER KA" . 12363)
                             ("HIRAGANA LETTER GA" . 12364)
                             ("HIRAGANA LETTER KI" . 12365)
                             ("HIRAGANA LETTER GI" . 12366)
                             ("HIRAGANA LETTER KU" . 12367)
                             ("HIRAGANA LETTER GU" . 12368)
                             ("HIRAGANA LETTER KE" . 12369)
                             ("HIRAGANA LETTER GE" . 12370)
                             ("HIRAGANA LETTER KO" . 12371)
                             ("HIRAGANA LETTER GO" . 12372)
                             ("HIRAGANA LETTER SA" . 12373)
                             ("HIRAGANA LETTER ZA" . 12374)
                             ("HIRAGANA LETTER SI" . 12375)
                             ("HIRAGANA LETTER ZI" . 12376)
                             ("HIRAGANA LETTER SU" . 12377)
                             ("HIRAGANA LETTER ZU" . 12378)
                             ("HIRAGANA LETTER SE" . 12379)
                             ("HIRAGANA LETTER ZE" . 12380)
                             ("HIRAGANA LETTER SO" . 12381)
                             ("HIRAGANA LETTER ZO" . 12382)
                             ("HIRAGANA LETTER TA" . 12383)
                             ("HIRAGANA LETTER DA" . 12384)
                             ("HIRAGANA LETTER TI" . 12385)
                             ("HIRAGANA LETTER DI" . 12386)
                             ("HIRAGANA LETTER SMALL TU" . 12387)
                             ("HIRAGANA LETTER TU" . 12388)
                             ("HIRAGANA LETTER DU" . 12389)
                             ("HIRAGANA LETTER TE" . 12390)
                             ("HIRAGANA LETTER DE" . 12391)
                             ("HIRAGANA LETTER TO" . 12392)
                             ("HIRAGANA LETTER DO" . 12393)
                             ("HIRAGANA LETTER NA" . 12394)
                             ("HIRAGANA LETTER NI" . 12395)
                             ("HIRAGANA LETTER NU" . 12396)
                             ("HIRAGANA LETTER NE" . 12397)
                             ("HIRAGANA LETTER NO" . 12398)
                             ("HIRAGANA LETTER HA" . 12399)
                             ("HIRAGANA LETTER BA" . 12400)
                             ("HIRAGANA LETTER PA" . 12401)
                             ("HIRAGANA LETTER HI" . 12402)
                             ("HIRAGANA LETTER BI" . 12403)
                             ("HIRAGANA LETTER PI" . 12404)
                             ("HIRAGANA LETTER HU" . 12405)
                             ("HIRAGANA LETTER BU" . 12406)
                             ("HIRAGANA LETTER PU" . 12407)
                             ("HIRAGANA LETTER HE" . 12408)
                             ("HIRAGANA LETTER BE" . 12409)
                             ("HIRAGANA LETTER PE" . 12410)
                             ("HIRAGANA LETTER HO" . 12411)
                             ("HIRAGANA LETTER BO" . 12412)
                             ("HIRAGANA LETTER PO" . 12413)
                             ("HIRAGANA LETTER MA" . 12414)
                             ("HIRAGANA LETTER MI" . 12415)
                             ("HIRAGANA LETTER MU" . 12416)
                             ("HIRAGANA LETTER ME" . 12417)
                             ("HIRAGANA LETTER MO" . 12418)
                             ("HIRAGANA LETTER SMALL YA" . 12419)
                             ("HIRAGANA LETTER YA" . 12420)
                             ("HIRAGANA LETTER SMALL YU" . 12421)
                             ("HIRAGANA LETTER YU" . 12422)
                             ("HIRAGANA LETTER SMALL YO" . 12423)
                             ("HIRAGANA LETTER YO" . 12424)
                             ("HIRAGANA LETTER RA" . 12425)
                             ("HIRAGANA LETTER RI" . 12426)
                             ("HIRAGANA LETTER RU" . 12427)
                             ("HIRAGANA LETTER RE" . 12428)
                             ("HIRAGANA LETTER RO" . 12429)
                             ("HIRAGANA LETTER SMALL WA" . 12430)
                             ("HIRAGANA LETTER WA" . 12431)
                             ("HIRAGANA LETTER WI" . 12432)
                             ("HIRAGANA LETTER WE" . 12433)
                             ("HIRAGANA LETTER WO" . 12434)
                             ("HIRAGANA LETTER N" . 12435)
                             ("HIRAGANA LETTER VU" . 12436)
                             ("HIRAGANA LETTER SMALL KA" . 12437)
                             ("HIRAGANA LETTER SMALL KE" . 12438)
                             ("COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK" . 12441)
                             ("COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" . 12442)
                             ("KATAKANA-HIRAGANA VOICED SOUND MARK" . 12443)
                             ("KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK" . 12444)
                             ("HIRAGANA ITERATION MARK" . 12445)
                             ("HIRAGANA VOICED ITERATION MARK" . 12446)
                             ("HIRAGANA DIGRAPH YORI" . 12447)
                             ("KATAKANA-HIRAGANA DOUBLE HYPHEN" . 12448)
                             ("KATAKANA LETTER SMALL A" . 12449)
                             ("KATAKANA LETTER A" . 12450)
                             ("KATAKANA LETTER SMALL I" . 12451)
                             ("KATAKANA LETTER I" . 12452)
                             ("KATAKANA LETTER SMALL U" . 12453)
                             ("KATAKANA LETTER U" . 12454)
                             ("KATAKANA LETTER SMALL E" . 12455)
                             ("KATAKANA LETTER E" . 12456)
                             ("KATAKANA LETTER SMALL O" . 12457)
                             ("KATAKANA LETTER O" . 12458)
                             ("KATAKANA LETTER KA" . 12459)
                             ("KATAKANA LETTER GA" . 12460)
                             ("KATAKANA LETTER KI" . 12461)
                             ("KATAKANA LETTER GI" . 12462)
                             ("KATAKANA LETTER KU" . 12463)
                             ("KATAKANA LETTER GU" . 12464)
                             ("KATAKANA LETTER KE" . 12465)
                             ("KATAKANA LETTER GE" . 12466)
                             ("KATAKANA LETTER KO" . 12467)
                             ("KATAKANA LETTER GO" . 12468)
                             ("KATAKANA LETTER SA" . 12469)
                             ("KATAKANA LETTER ZA" . 12470)
                             ("KATAKANA LETTER SI" . 12471)
                             ("KATAKANA LETTER ZI" . 12472)
                             ("KATAKANA LETTER SU" . 12473)
                             ("KATAKANA LETTER ZU" . 12474)
                             ("KATAKANA LETTER SE" . 12475)
                             ("KATAKANA LETTER ZE" . 12476)
                             ("KATAKANA LETTER SO" . 12477)
                             ("KATAKANA LETTER ZO" . 12478)
                             ("KATAKANA LETTER TA" . 12479)
                             ("KATAKANA LETTER DA" . 12480)
                             ("KATAKANA LETTER TI" . 12481)
                             ("KATAKANA LETTER DI" . 12482)
                             ("KATAKANA LETTER SMALL TU" . 12483)
                             ("KATAKANA LETTER TU" . 12484)
                             ("KATAKANA LETTER DU" . 12485)
                             ("KATAKANA LETTER TE" . 12486)
                             ("KATAKANA LETTER DE" . 12487)
                             ("KATAKANA LETTER TO" . 12488)
                             ("KATAKANA LETTER DO" . 12489)
                             ("KATAKANA LETTER NA" . 12490)
                             ("KATAKANA LETTER NI" . 12491)
                             ("KATAKANA LETTER NU" . 12492)
                             ("KATAKANA LETTER NE" . 12493)
                             ("KATAKANA LETTER NO" . 12494)
                             ("KATAKANA LETTER HA" . 12495)
                             ("KATAKANA LETTER BA" . 12496)
                             ("KATAKANA LETTER PA" . 12497)
                             ("KATAKANA LETTER HI" . 12498)
                             ("KATAKANA LETTER BI" . 12499)
                             ("KATAKANA LETTER PI" . 12500)
                             ("KATAKANA LETTER HU" . 12501)
                             ("KATAKANA LETTER BU" . 12502)
                             ("KATAKANA LETTER PU" . 12503)
                             ("KATAKANA LETTER HE" . 12504)
                             ("KATAKANA LETTER BE" . 12505)
                             ("KATAKANA LETTER PE" . 12506)
                             ("KATAKANA LETTER HO" . 12507)
                             ("KATAKANA LETTER BO" . 12508)
                             ("KATAKANA LETTER PO" . 12509)
                             ("KATAKANA LETTER MA" . 12510)
                             ("KATAKANA LETTER MI" . 12511)
                             ("KATAKANA LETTER MU" . 12512)
                             ("KATAKANA LETTER ME" . 12513)
                             ("KATAKANA LETTER MO" . 12514)
                             ("KATAKANA LETTER SMALL YA" . 12515)
                             ("KATAKANA LETTER YA" . 12516)
                             ("KATAKANA LETTER SMALL YU" . 12517)
                             ("KATAKANA LETTER YU" . 12518)
                             ("KATAKANA LETTER SMALL YO" . 12519)
                             ("KATAKANA LETTER YO" . 12520)
                             ("KATAKANA LETTER RA" . 12521)
                             ("KATAKANA LETTER RI" . 12522)
                             ("KATAKANA LETTER RU" . 12523)
                             ("KATAKANA LETTER RE" . 12524)
                             ("KATAKANA LETTER RO" . 12525)
                             ("KATAKANA LETTER SMALL WA" . 12526)
                             ("KATAKANA LETTER WA" . 12527)
                             ("KATAKANA LETTER WI" . 12528)
                             ("KATAKANA LETTER WE" . 12529)
                             ("KATAKANA LETTER WO" . 12530)
                             ("KATAKANA LETTER N" . 12531)
                             ("KATAKANA LETTER VU" . 12532)
                             ("KATAKANA LETTER SMALL KA" . 12533)
                             ("KATAKANA LETTER SMALL KE" . 12534)
                             ("KATAKANA LETTER VA" . 12535)
                             ("KATAKANA LETTER VI" . 12536)
                             ("KATAKANA LETTER VE" . 12537)
                             ("KATAKANA LETTER VO" . 12538)
                             ("KATAKANA MIDDLE DOT" . 12539)
                             ("KATAKANA-HIRAGANA PROLONGED SOUND MARK" . 12540)
                             ("KATAKANA ITERATION MARK" . 12541)
                             ("KATAKANA VOICED ITERATION MARK" . 12542)
                             ("KATAKANA DIGRAPH KOTO" . 12543)
                             ("BOPOMOFO LETTER B" . 12549)
                             ("BOPOMOFO LETTER P" . 12550)
                             ("BOPOMOFO LETTER M" . 12551)
                             ("BOPOMOFO LETTER F" . 12552)
                             ("BOPOMOFO LETTER D" . 12553)
                             ("BOPOMOFO LETTER T" . 12554)
                             ("BOPOMOFO LETTER N" . 12555)
                             ("BOPOMOFO LETTER L" . 12556)
                             ("BOPOMOFO LETTER G" . 12557)
                             ("BOPOMOFO LETTER K" . 12558)
                             ("BOPOMOFO LETTER H" . 12559)
                             ("BOPOMOFO LETTER J" . 12560)
                             ("BOPOMOFO LETTER Q" . 12561)
                             ("BOPOMOFO LETTER X" . 12562)
                             ("BOPOMOFO LETTER ZH" . 12563)
                             ("BOPOMOFO LETTER CH" . 12564)
                             ("BOPOMOFO LETTER SH" . 12565)
                             ("BOPOMOFO LETTER R" . 12566)
                             ("BOPOMOFO LETTER Z" . 12567)
                             ("BOPOMOFO LETTER C" . 12568)
                             ("BOPOMOFO LETTER S" . 12569)
                             ("BOPOMOFO LETTER A" . 12570)
                             ("BOPOMOFO LETTER O" . 12571)
                             ("BOPOMOFO LETTER E" . 12572)
                             ("BOPOMOFO LETTER EH" . 12573)
                             ("BOPOMOFO LETTER AI" . 12574)
                             ("BOPOMOFO LETTER EI" . 12575)
                             ("BOPOMOFO LETTER AU" . 12576)
                             ("BOPOMOFO LETTER OU" . 12577)
                             ("BOPOMOFO LETTER AN" . 12578)
                             ("BOPOMOFO LETTER EN" . 12579)
                             ("BOPOMOFO LETTER ANG" . 12580)
                             ("BOPOMOFO LETTER ENG" . 12581)
                             ("BOPOMOFO LETTER ER" . 12582)
                             ("BOPOMOFO LETTER I" . 12583)
                             ("BOPOMOFO LETTER U" . 12584)
                             ("BOPOMOFO LETTER IU" . 12585)
                             ("BOPOMOFO LETTER V" . 12586)
                             ("BOPOMOFO LETTER NG" . 12587)
                             ("BOPOMOFO LETTER GN" . 12588)
                             ("HANGUL LETTER KIYEOK" . 12593)
                             ("HANGUL LETTER SSANGKIYEOK" . 12594)
                             ("HANGUL LETTER KIYEOK-SIOS" . 12595)
                             ("HANGUL LETTER NIEUN" . 12596)
                             ("HANGUL LETTER NIEUN-CIEUC" . 12597)
                             ("HANGUL LETTER NIEUN-HIEUH" . 12598)
                             ("HANGUL LETTER TIKEUT" . 12599)
                             ("HANGUL LETTER SSANGTIKEUT" . 12600)
                             ("HANGUL LETTER RIEUL" . 12601)
                             ("HANGUL LETTER RIEUL-KIYEOK" . 12602)
                             ("HANGUL LETTER RIEUL-MIEUM" . 12603)
                             ("HANGUL LETTER RIEUL-PIEUP" . 12604)
                             ("HANGUL LETTER RIEUL-SIOS" . 12605)
                             ("HANGUL LETTER RIEUL-THIEUTH" . 12606)
                             ("HANGUL LETTER RIEUL-PHIEUPH" . 12607)
                             ("HANGUL LETTER RIEUL-HIEUH" . 12608)
                             ("HANGUL LETTER MIEUM" . 12609)
                             ("HANGUL LETTER PIEUP" . 12610)
                             ("HANGUL LETTER SSANGPIEUP" . 12611)
                             ("HANGUL LETTER PIEUP-SIOS" . 12612)
                             ("HANGUL LETTER SIOS" . 12613)
                             ("HANGUL LETTER SSANGSIOS" . 12614)
                             ("HANGUL LETTER IEUNG" . 12615)
                             ("HANGUL LETTER CIEUC" . 12616)
                             ("HANGUL LETTER SSANGCIEUC" . 12617)
                             ("HANGUL LETTER CHIEUCH" . 12618)
                             ("HANGUL LETTER KHIEUKH" . 12619)
                             ("HANGUL LETTER THIEUTH" . 12620)
                             ("HANGUL LETTER PHIEUPH" . 12621)
                             ("HANGUL LETTER HIEUH" . 12622)
                             ("HANGUL LETTER A" . 12623)
                             ("HANGUL LETTER AE" . 12624)
                             ("HANGUL LETTER YA" . 12625)
                             ("HANGUL LETTER YAE" . 12626)
                             ("HANGUL LETTER EO" . 12627)
                             ("HANGUL LETTER E" . 12628)
                             ("HANGUL LETTER YEO" . 12629)
                             ("HANGUL LETTER YE" . 12630)
                             ("HANGUL LETTER O" . 12631)
                             ("HANGUL LETTER WA" . 12632)
                             ("HANGUL LETTER WAE" . 12633)
                             ("HANGUL LETTER OE" . 12634)
                             ("HANGUL LETTER YO" . 12635)
                             ("HANGUL LETTER U" . 12636)
                             ("HANGUL LETTER WEO" . 12637)
                             ("HANGUL LETTER WE" . 12638)
                             ("HANGUL LETTER WI" . 12639)
                             ("HANGUL LETTER YU" . 12640)
                             ("HANGUL LETTER EU" . 12641)
                             ("HANGUL LETTER YI" . 12642)
                             ("HANGUL LETTER I" . 12643)
                             ("HANGUL FILLER" . 12644)
                             ("HANGUL LETTER SSANGNIEUN" . 12645)
                             ("HANGUL LETTER NIEUN-TIKEUT" . 12646)
                             ("HANGUL LETTER NIEUN-SIOS" . 12647)
                             ("HANGUL LETTER NIEUN-PANSIOS" . 12648)
                             ("HANGUL LETTER RIEUL-KIYEOK-SIOS" . 12649)
                             ("HANGUL LETTER RIEUL-TIKEUT" . 12650)
                             ("HANGUL LETTER RIEUL-PIEUP-SIOS" . 12651)
                             ("HANGUL LETTER RIEUL-PANSIOS" . 12652)
                             ("HANGUL LETTER RIEUL-YEORINHIEUH" . 12653)
                             ("HANGUL LETTER MIEUM-PIEUP" . 12654)
                             ("HANGUL LETTER MIEUM-SIOS" . 12655)
                             ("HANGUL LETTER MIEUM-PANSIOS" . 12656)
                             ("HANGUL LETTER KAPYEOUNMIEUM" . 12657)
                             ("HANGUL LETTER PIEUP-KIYEOK" . 12658)
                             ("HANGUL LETTER PIEUP-TIKEUT" . 12659)
                             ("HANGUL LETTER PIEUP-SIOS-KIYEOK" . 12660)
                             ("HANGUL LETTER PIEUP-SIOS-TIKEUT" . 12661)
                             ("HANGUL LETTER PIEUP-CIEUC" . 12662)
                             ("HANGUL LETTER PIEUP-THIEUTH" . 12663)
                             ("HANGUL LETTER KAPYEOUNPIEUP" . 12664)
                             ("HANGUL LETTER KAPYEOUNSSANGPIEUP" . 12665)
                             ("HANGUL LETTER SIOS-KIYEOK" . 12666)
                             ("HANGUL LETTER SIOS-NIEUN" . 12667)
                             ("HANGUL LETTER SIOS-TIKEUT" . 12668)
                             ("HANGUL LETTER SIOS-PIEUP" . 12669)
                             ("HANGUL LETTER SIOS-CIEUC" . 12670)
                             ("HANGUL LETTER PANSIOS" . 12671)
                             ("HANGUL LETTER SSANGIEUNG" . 12672)
                             ("HANGUL LETTER YESIEUNG" . 12673)
                             ("HANGUL LETTER YESIEUNG-SIOS" . 12674)
                             ("HANGUL LETTER YESIEUNG-PANSIOS" . 12675)
                             ("HANGUL LETTER KAPYEOUNPHIEUPH" . 12676)
                             ("HANGUL LETTER SSANGHIEUH" . 12677)
                             ("HANGUL LETTER YEORINHIEUH" . 12678)
                             ("HANGUL LETTER YO-YA" . 12679)
                             ("HANGUL LETTER YO-YAE" . 12680)
                             ("HANGUL LETTER YO-I" . 12681)
                             ("HANGUL LETTER YU-YEO" . 12682)
                             ("HANGUL LETTER YU-YE" . 12683)
                             ("HANGUL LETTER YU-I" . 12684)
                             ("HANGUL LETTER ARAEA" . 12685)
                             ("HANGUL LETTER ARAEAE" . 12686)
                             ("IDEOGRAPHIC ANNOTATION LINKING MARK" . 12688)
                             ("IDEOGRAPHIC ANNOTATION REVERSE MARK" . 12689)
                             ("IDEOGRAPHIC ANNOTATION ONE MARK" . 12690)
                             ("IDEOGRAPHIC ANNOTATION TWO MARK" . 12691)
                             ("IDEOGRAPHIC ANNOTATION THREE MARK" . 12692)
                             ("IDEOGRAPHIC ANNOTATION FOUR MARK" . 12693)
                             ("IDEOGRAPHIC ANNOTATION TOP MARK" . 12694)
                             ("IDEOGRAPHIC ANNOTATION MIDDLE MARK" . 12695)
                             ("IDEOGRAPHIC ANNOTATION BOTTOM MARK" . 12696)
                             ("IDEOGRAPHIC ANNOTATION FIRST MARK" . 12697)
                             ("IDEOGRAPHIC ANNOTATION SECOND MARK" . 12698)
                             ("IDEOGRAPHIC ANNOTATION THIRD MARK" . 12699)
                             ("IDEOGRAPHIC ANNOTATION FOURTH MARK" . 12700)
                             ("IDEOGRAPHIC ANNOTATION HEAVEN MARK" . 12701)
                             ("IDEOGRAPHIC ANNOTATION EARTH MARK" . 12702)
                             ("IDEOGRAPHIC ANNOTATION MAN MARK" . 12703)
                             ("BOPOMOFO LETTER BU" . 12704)
                             ("BOPOMOFO LETTER ZI" . 12705)
                             ("BOPOMOFO LETTER JI" . 12706)
                             ("BOPOMOFO LETTER GU" . 12707)
                             ("BOPOMOFO LETTER EE" . 12708)
                             ("BOPOMOFO LETTER ENN" . 12709)
                             ("BOPOMOFO LETTER OO" . 12710)
                             ("BOPOMOFO LETTER ONN" . 12711)
                             ("BOPOMOFO LETTER IR" . 12712)
                             ("BOPOMOFO LETTER ANN" . 12713)
                             ("BOPOMOFO LETTER INN" . 12714)
                             ("BOPOMOFO LETTER UNN" . 12715)
                             ("BOPOMOFO LETTER IM" . 12716)
                             ("BOPOMOFO LETTER NGG" . 12717)
                             ("BOPOMOFO LETTER AINN" . 12718)
                             ("BOPOMOFO LETTER AUNN" . 12719)
                             ("BOPOMOFO LETTER AM" . 12720)
                             ("BOPOMOFO LETTER OM" . 12721)
                             ("BOPOMOFO LETTER ONG" . 12722)
                             ("BOPOMOFO LETTER INNN" . 12723)
                             ("BOPOMOFO FINAL LETTER P" . 12724)
                             ("BOPOMOFO FINAL LETTER T" . 12725)
                             ("BOPOMOFO FINAL LETTER K" . 12726)
                             ("BOPOMOFO FINAL LETTER H" . 12727)
                             ("KATAKANA LETTER SMALL KU" . 12784)
                             ("KATAKANA LETTER SMALL SI" . 12785)
                             ("KATAKANA LETTER SMALL SU" . 12786)
                             ("KATAKANA LETTER SMALL TO" . 12787)
                             ("KATAKANA LETTER SMALL NU" . 12788)
                             ("KATAKANA LETTER SMALL HA" . 12789)
                             ("KATAKANA LETTER SMALL HI" . 12790)
                             ("KATAKANA LETTER SMALL HU" . 12791)
                             ("KATAKANA LETTER SMALL HE" . 12792)
                             ("KATAKANA LETTER SMALL HO" . 12793)
                             ("KATAKANA LETTER SMALL MU" . 12794)
                             ("KATAKANA LETTER SMALL RA" . 12795)
                             ("KATAKANA LETTER SMALL RI" . 12796)
                             ("KATAKANA LETTER SMALL RU" . 12797)
                             ("KATAKANA LETTER SMALL RE" . 12798)
                             ("KATAKANA LETTER SMALL RO" . 12799)
                             ("PARENTHESIZED HANGUL KIYEOK" . 12800)
                             ("PARENTHESIZED HANGUL NIEUN" . 12801)
                             ("PARENTHESIZED HANGUL TIKEUT" . 12802)
                             ("PARENTHESIZED HANGUL RIEUL" . 12803)
                             ("PARENTHESIZED HANGUL MIEUM" . 12804)
                             ("PARENTHESIZED HANGUL PIEUP" . 12805)
                             ("PARENTHESIZED HANGUL SIOS" . 12806)
                             ("PARENTHESIZED HANGUL IEUNG" . 12807)
                             ("PARENTHESIZED HANGUL CIEUC" . 12808)
                             ("PARENTHESIZED HANGUL CHIEUCH" . 12809)
                             ("PARENTHESIZED HANGUL KHIEUKH" . 12810)
                             ("PARENTHESIZED HANGUL THIEUTH" . 12811)
                             ("PARENTHESIZED HANGUL PHIEUPH" . 12812)
                             ("PARENTHESIZED HANGUL HIEUH" . 12813)
                             ("PARENTHESIZED HANGUL KIYEOK A" . 12814)
                             ("PARENTHESIZED HANGUL NIEUN A" . 12815)
                             ("PARENTHESIZED HANGUL TIKEUT A" . 12816)
                             ("PARENTHESIZED HANGUL RIEUL A" . 12817)
                             ("PARENTHESIZED HANGUL MIEUM A" . 12818)
                             ("PARENTHESIZED HANGUL PIEUP A" . 12819)
                             ("PARENTHESIZED HANGUL SIOS A" . 12820)
                             ("PARENTHESIZED HANGUL IEUNG A" . 12821)
                             ("PARENTHESIZED HANGUL CIEUC A" . 12822)
                             ("PARENTHESIZED HANGUL CHIEUCH A" . 12823)
                             ("PARENTHESIZED HANGUL KHIEUKH A" . 12824)
                             ("PARENTHESIZED HANGUL THIEUTH A" . 12825)
                             ("PARENTHESIZED HANGUL PHIEUPH A" . 12826)
                             ("PARENTHESIZED HANGUL HIEUH A" . 12827)
                             ("PARENTHESIZED HANGUL CIEUC U" . 12828)
                             ("PARENTHESIZED IDEOGRAPH ONE" . 12832)
                             ("PARENTHESIZED IDEOGRAPH TWO" . 12833)
                             ("PARENTHESIZED IDEOGRAPH THREE" . 12834)
                             ("PARENTHESIZED IDEOGRAPH FOUR" . 12835)
                             ("PARENTHESIZED IDEOGRAPH FIVE" . 12836)
                             ("PARENTHESIZED IDEOGRAPH SIX" . 12837)
                             ("PARENTHESIZED IDEOGRAPH SEVEN" . 12838)
                             ("PARENTHESIZED IDEOGRAPH EIGHT" . 12839)
                             ("PARENTHESIZED IDEOGRAPH NINE" . 12840)
                             ("PARENTHESIZED IDEOGRAPH TEN" . 12841)
                             ("PARENTHESIZED IDEOGRAPH MOON" . 12842)
                             ("PARENTHESIZED IDEOGRAPH FIRE" . 12843)
                             ("PARENTHESIZED IDEOGRAPH WATER" . 12844)
                             ("PARENTHESIZED IDEOGRAPH WOOD" . 12845)
                             ("PARENTHESIZED IDEOGRAPH METAL" . 12846)
                             ("PARENTHESIZED IDEOGRAPH EARTH" . 12847)
                             ("PARENTHESIZED IDEOGRAPH SUN" . 12848)
                             ("PARENTHESIZED IDEOGRAPH STOCK" . 12849)
                             ("PARENTHESIZED IDEOGRAPH HAVE" . 12850)
                             ("PARENTHESIZED IDEOGRAPH SOCIETY" . 12851)
                             ("PARENTHESIZED IDEOGRAPH NAME" . 12852)
                             ("PARENTHESIZED IDEOGRAPH SPECIAL" . 12853)
                             ("PARENTHESIZED IDEOGRAPH FINANCIAL" . 12854)
                             ("PARENTHESIZED IDEOGRAPH CONGRATULATION" . 12855)
                             ("PARENTHESIZED IDEOGRAPH LABOR" . 12856)
                             ("PARENTHESIZED IDEOGRAPH REPRESENT" . 12857)
                             ("PARENTHESIZED IDEOGRAPH CALL" . 12858)
                             ("PARENTHESIZED IDEOGRAPH STUDY" . 12859)
                             ("PARENTHESIZED IDEOGRAPH SUPERVISE" . 12860)
                             ("PARENTHESIZED IDEOGRAPH ENTERPRISE" . 12861)
                             ("PARENTHESIZED IDEOGRAPH RESOURCE" . 12862)
                             ("PARENTHESIZED IDEOGRAPH ALLIANCE" . 12863)
                             ("PARENTHESIZED IDEOGRAPH FESTIVAL" . 12864)
                             ("PARENTHESIZED IDEOGRAPH REST" . 12865)
                             ("PARENTHESIZED IDEOGRAPH SELF" . 12866)
                             ("PARENTHESIZED IDEOGRAPH REACH" . 12867)
                             ("CIRCLED NUMBER TWENTY ONE" . 12881)
                             ("CIRCLED NUMBER TWENTY TWO" . 12882)
                             ("CIRCLED NUMBER TWENTY THREE" . 12883)
                             ("CIRCLED NUMBER TWENTY FOUR" . 12884)
                             ("CIRCLED NUMBER TWENTY FIVE" . 12885)
                             ("CIRCLED NUMBER TWENTY SIX" . 12886)
                             ("CIRCLED NUMBER TWENTY SEVEN" . 12887)
                             ("CIRCLED NUMBER TWENTY EIGHT" . 12888)
                             ("CIRCLED NUMBER TWENTY NINE" . 12889)
                             ("CIRCLED NUMBER THIRTY" . 12890)
                             ("CIRCLED NUMBER THIRTY ONE" . 12891)
                             ("CIRCLED NUMBER THIRTY TWO" . 12892)
                             ("CIRCLED NUMBER THIRTY THREE" . 12893)
                             ("CIRCLED NUMBER THIRTY FOUR" . 12894)
                             ("CIRCLED NUMBER THIRTY FIVE" . 12895)
                             ("CIRCLED HANGUL KIYEOK" . 12896)
                             ("CIRCLED HANGUL NIEUN" . 12897)
                             ("CIRCLED HANGUL TIKEUT" . 12898)
                             ("CIRCLED HANGUL RIEUL" . 12899)
                             ("CIRCLED HANGUL MIEUM" . 12900)
                             ("CIRCLED HANGUL PIEUP" . 12901)
                             ("CIRCLED HANGUL SIOS" . 12902)
                             ("CIRCLED HANGUL IEUNG" . 12903)
                             ("CIRCLED HANGUL CIEUC" . 12904)
                             ("CIRCLED HANGUL CHIEUCH" . 12905)
                             ("CIRCLED HANGUL KHIEUKH" . 12906)
                             ("CIRCLED HANGUL THIEUTH" . 12907)
                             ("CIRCLED HANGUL PHIEUPH" . 12908)
                             ("CIRCLED HANGUL HIEUH" . 12909)
                             ("CIRCLED HANGUL KIYEOK A" . 12910)
                             ("CIRCLED HANGUL NIEUN A" . 12911)
                             ("CIRCLED HANGUL TIKEUT A" . 12912)
                             ("CIRCLED HANGUL RIEUL A" . 12913)
                             ("CIRCLED HANGUL MIEUM A" . 12914)
                             ("CIRCLED HANGUL PIEUP A" . 12915)
                             ("CIRCLED HANGUL SIOS A" . 12916)
                             ("CIRCLED HANGUL IEUNG A" . 12917)
                             ("CIRCLED HANGUL CIEUC A" . 12918)
                             ("CIRCLED HANGUL CHIEUCH A" . 12919)
                             ("CIRCLED HANGUL KHIEUKH A" . 12920)
                             ("CIRCLED HANGUL THIEUTH A" . 12921)
                             ("CIRCLED HANGUL PHIEUPH A" . 12922)
                             ("CIRCLED HANGUL HIEUH A" . 12923)
                             ("KOREAN STANDARD SYMBOL" . 12927)
                             ("CIRCLED IDEOGRAPH ONE" . 12928)
                             ("CIRCLED IDEOGRAPH TWO" . 12929)
                             ("CIRCLED IDEOGRAPH THREE" . 12930)
                             ("CIRCLED IDEOGRAPH FOUR" . 12931)
                             ("CIRCLED IDEOGRAPH FIVE" . 12932)
                             ("CIRCLED IDEOGRAPH SIX" . 12933)
                             ("CIRCLED IDEOGRAPH SEVEN" . 12934)
                             ("CIRCLED IDEOGRAPH EIGHT" . 12935)
                             ("CIRCLED IDEOGRAPH NINE" . 12936)
                             ("CIRCLED IDEOGRAPH TEN" . 12937)
                             ("CIRCLED IDEOGRAPH MOON" . 12938)
                             ("CIRCLED IDEOGRAPH FIRE" . 12939)
                             ("CIRCLED IDEOGRAPH WATER" . 12940)
                             ("CIRCLED IDEOGRAPH WOOD" . 12941)
                             ("CIRCLED IDEOGRAPH METAL" . 12942)
                             ("CIRCLED IDEOGRAPH EARTH" . 12943)
                             ("CIRCLED IDEOGRAPH SUN" . 12944)
                             ("CIRCLED IDEOGRAPH STOCK" . 12945)
                             ("CIRCLED IDEOGRAPH HAVE" . 12946)
                             ("CIRCLED IDEOGRAPH SOCIETY" . 12947)
                             ("CIRCLED IDEOGRAPH NAME" . 12948)
                             ("CIRCLED IDEOGRAPH SPECIAL" . 12949)
                             ("CIRCLED IDEOGRAPH FINANCIAL" . 12950)
                             ("CIRCLED IDEOGRAPH CONGRATULATION" . 12951)
                             ("CIRCLED IDEOGRAPH LABOR" . 12952)
                             ("CIRCLED IDEOGRAPH SECRET" . 12953)
                             ("CIRCLED IDEOGRAPH MALE" . 12954)
                             ("CIRCLED IDEOGRAPH FEMALE" . 12955)
                             ("CIRCLED IDEOGRAPH SUITABLE" . 12956)
                             ("CIRCLED IDEOGRAPH EXCELLENT" . 12957)
                             ("CIRCLED IDEOGRAPH PRINT" . 12958)
                             ("CIRCLED IDEOGRAPH ATTENTION" . 12959)
                             ("CIRCLED IDEOGRAPH ITEM" . 12960)
                             ("CIRCLED IDEOGRAPH REST" . 12961)
                             ("CIRCLED IDEOGRAPH COPY" . 12962)
                             ("CIRCLED IDEOGRAPH CORRECT" . 12963)
                             ("CIRCLED IDEOGRAPH HIGH" . 12964)
                             ("CIRCLED IDEOGRAPH CENTRE" . 12965)
                             ("CIRCLED IDEOGRAPH LOW" . 12966)
                             ("CIRCLED IDEOGRAPH LEFT" . 12967)
                             ("CIRCLED IDEOGRAPH RIGHT" . 12968)
                             ("CIRCLED IDEOGRAPH MEDICINE" . 12969)
                             ("CIRCLED IDEOGRAPH RELIGION" . 12970)
                             ("CIRCLED IDEOGRAPH STUDY" . 12971)
                             ("CIRCLED IDEOGRAPH SUPERVISE" . 12972)
                             ("CIRCLED IDEOGRAPH ENTERPRISE" . 12973)
                             ("CIRCLED IDEOGRAPH RESOURCE" . 12974)
                             ("CIRCLED IDEOGRAPH ALLIANCE" . 12975)
                             ("CIRCLED IDEOGRAPH NIGHT" . 12976)
                             ("CIRCLED NUMBER THIRTY SIX" . 12977)
                             ("CIRCLED NUMBER THIRTY SEVEN" . 12978)
                             ("CIRCLED NUMBER THIRTY EIGHT" . 12979)
                             ("CIRCLED NUMBER THIRTY NINE" . 12980)
                             ("CIRCLED NUMBER FORTY" . 12981)
                             ("CIRCLED NUMBER FORTY ONE" . 12982)
                             ("CIRCLED NUMBER FORTY TWO" . 12983)
                             ("CIRCLED NUMBER FORTY THREE" . 12984)
                             ("CIRCLED NUMBER FORTY FOUR" . 12985)
                             ("CIRCLED NUMBER FORTY FIVE" . 12986)
                             ("CIRCLED NUMBER FORTY SIX" . 12987)
                             ("CIRCLED NUMBER FORTY SEVEN" . 12988)
                             ("CIRCLED NUMBER FORTY EIGHT" . 12989)
                             ("CIRCLED NUMBER FORTY NINE" . 12990)
                             ("CIRCLED NUMBER FIFTY" . 12991)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY" . 12992)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY" . 12993)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH" . 12994)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL" . 12995)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY" . 12996)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE" . 12997)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY" . 12998)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST" . 12999)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER" . 13000)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER" . 13001)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER" . 13002)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER" . 13003)
                             ("CIRCLED KATAKANA A" . 13008)
                             ("CIRCLED KATAKANA I" . 13009)
                             ("CIRCLED KATAKANA U" . 13010)
                             ("CIRCLED KATAKANA E" . 13011)
                             ("CIRCLED KATAKANA O" . 13012)
                             ("CIRCLED KATAKANA KA" . 13013)
                             ("CIRCLED KATAKANA KI" . 13014)
                             ("CIRCLED KATAKANA KU" . 13015)
                             ("CIRCLED KATAKANA KE" . 13016)
                             ("CIRCLED KATAKANA KO" . 13017)
                             ("CIRCLED KATAKANA SA" . 13018)
                             ("CIRCLED KATAKANA SI" . 13019)
                             ("CIRCLED KATAKANA SU" . 13020)
                             ("CIRCLED KATAKANA SE" . 13021)
                             ("CIRCLED KATAKANA SO" . 13022)
                             ("CIRCLED KATAKANA TA" . 13023)
                             ("CIRCLED KATAKANA TI" . 13024)
                             ("CIRCLED KATAKANA TU" . 13025)
                             ("CIRCLED KATAKANA TE" . 13026)
                             ("CIRCLED KATAKANA TO" . 13027)
                             ("CIRCLED KATAKANA NA" . 13028)
                             ("CIRCLED KATAKANA NI" . 13029)
                             ("CIRCLED KATAKANA NU" . 13030)
                             ("CIRCLED KATAKANA NE" . 13031)
                             ("CIRCLED KATAKANA NO" . 13032)
                             ("CIRCLED KATAKANA HA" . 13033)
                             ("CIRCLED KATAKANA HI" . 13034)
                             ("CIRCLED KATAKANA HU" . 13035)
                             ("CIRCLED KATAKANA HE" . 13036)
                             ("CIRCLED KATAKANA HO" . 13037)
                             ("CIRCLED KATAKANA MA" . 13038)
                             ("CIRCLED KATAKANA MI" . 13039)
                             ("CIRCLED KATAKANA MU" . 13040)
                             ("CIRCLED KATAKANA ME" . 13041)
                             ("CIRCLED KATAKANA MO" . 13042)
                             ("CIRCLED KATAKANA YA" . 13043)
                             ("CIRCLED KATAKANA YU" . 13044)
                             ("CIRCLED KATAKANA YO" . 13045)
                             ("CIRCLED KATAKANA RA" . 13046)
                             ("CIRCLED KATAKANA RI" . 13047)
                             ("CIRCLED KATAKANA RU" . 13048)
                             ("CIRCLED KATAKANA RE" . 13049)
                             ("CIRCLED KATAKANA RO" . 13050)
                             ("CIRCLED KATAKANA WA" . 13051)
                             ("CIRCLED KATAKANA WI" . 13052)
                             ("CIRCLED KATAKANA WE" . 13053)
                             ("CIRCLED KATAKANA WO" . 13054)
                             ("SQUARE APAATO" . 13056)
                             ("SQUARE ARUHUA" . 13057)
                             ("SQUARE ANPEA" . 13058)
                             ("SQUARE AARU" . 13059)
                             ("SQUARE ININGU" . 13060)
                             ("SQUARE INTI" . 13061)
                             ("SQUARE UON" . 13062)
                             ("SQUARE ESUKUUDO" . 13063)
                             ("SQUARE EEKAA" . 13064)
                             ("SQUARE ONSU" . 13065)
                             ("SQUARE OOMU" . 13066)
                             ("SQUARE KAIRI" . 13067)
                             ("SQUARE KARATTO" . 13068)
                             ("SQUARE KARORII" . 13069)
                             ("SQUARE GARON" . 13070)
                             ("SQUARE GANMA" . 13071)
                             ("SQUARE GIGA" . 13072)
                             ("SQUARE GINII" . 13073)
                             ("SQUARE KYURII" . 13074)
                             ("SQUARE GIRUDAA" . 13075)
                             ("SQUARE KIRO" . 13076)
                             ("SQUARE KIROGURAMU" . 13077)
                             ("SQUARE KIROMEETORU" . 13078)
                             ("SQUARE KIROWATTO" . 13079)
                             ("SQUARE GURAMU" . 13080)
                             ("SQUARE GURAMUTON" . 13081)
                             ("SQUARE KURUZEIRO" . 13082)
                             ("SQUARE KUROONE" . 13083)
                             ("SQUARE KEESU" . 13084)
                             ("SQUARE KORUNA" . 13085)
                             ("SQUARE KOOPO" . 13086)
                             ("SQUARE SAIKURU" . 13087)
                             ("SQUARE SANTIIMU" . 13088)
                             ("SQUARE SIRINGU" . 13089)
                             ("SQUARE SENTI" . 13090)
                             ("SQUARE SENTO" . 13091)
                             ("SQUARE DAASU" . 13092)
                             ("SQUARE DESI" . 13093)
                             ("SQUARE DORU" . 13094)
                             ("SQUARE TON" . 13095)
                             ("SQUARE NANO" . 13096)
                             ("SQUARE NOTTO" . 13097)
                             ("SQUARE HAITU" . 13098)
                             ("SQUARE PAASENTO" . 13099)
                             ("SQUARE PAATU" . 13100)
                             ("SQUARE BAARERU" . 13101)
                             ("SQUARE PIASUTORU" . 13102)
                             ("SQUARE PIKURU" . 13103)
                             ("SQUARE PIKO" . 13104)
                             ("SQUARE BIRU" . 13105)
                             ("SQUARE HUARADDO" . 13106)
                             ("SQUARE HUIITO" . 13107)
                             ("SQUARE BUSSYERU" . 13108)
                             ("SQUARE HURAN" . 13109)
                             ("SQUARE HEKUTAARU" . 13110)
                             ("SQUARE PESO" . 13111)
                             ("SQUARE PENIHI" . 13112)
                             ("SQUARE HERUTU" . 13113)
                             ("SQUARE PENSU" . 13114)
                             ("SQUARE PEEZI" . 13115)
                             ("SQUARE BEETA" . 13116)
                             ("SQUARE POINTO" . 13117)
                             ("SQUARE BORUTO" . 13118)
                             ("SQUARE HON" . 13119)
                             ("SQUARE PONDO" . 13120)
                             ("SQUARE HOORU" . 13121)
                             ("SQUARE HOON" . 13122)
                             ("SQUARE MAIKURO" . 13123)
                             ("SQUARE MAIRU" . 13124)
                             ("SQUARE MAHHA" . 13125)
                             ("SQUARE MARUKU" . 13126)
                             ("SQUARE MANSYON" . 13127)
                             ("SQUARE MIKURON" . 13128)
                             ("SQUARE MIRI" . 13129)
                             ("SQUARE MIRIBAARU" . 13130)
                             ("SQUARE MEGA" . 13131)
                             ("SQUARE MEGATON" . 13132)
                             ("SQUARE MEETORU" . 13133)
                             ("SQUARE YAADO" . 13134)
                             ("SQUARE YAARU" . 13135)
                             ("SQUARE YUAN" . 13136)
                             ("SQUARE RITTORU" . 13137)
                             ("SQUARE RIRA" . 13138)
                             ("SQUARE RUPII" . 13139)
                             ("SQUARE RUUBURU" . 13140)
                             ("SQUARE REMU" . 13141)
                             ("SQUARE RENTOGEN" . 13142)
                             ("SQUARE WATTO" . 13143)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO" . 13144)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE" . 13145)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO" . 13146)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE" . 13147)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR" . 13148)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE" . 13149)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX" . 13150)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN" . 13151)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT" . 13152)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE" . 13153)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN" . 13154)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN" . 13155)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE" . 13156)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN" . 13157)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN" . 13158)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN" . 13159)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN" . 13160)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN" . 13161)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN" . 13162)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN" . 13163)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY" . 13164)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE" . 13165)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO" . 13166)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE" . 13167)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR" . 13168)
                             ("SQUARE HPA" . 13169)
                             ("SQUARE DA" . 13170)
                             ("SQUARE AU" . 13171)
                             ("SQUARE BAR" . 13172)
                             ("SQUARE OV" . 13173)
                             ("SQUARE PC" . 13174)
                             ("SQUARE ERA NAME HEISEI" . 13179)
                             ("SQUARE ERA NAME SYOUWA" . 13180)
                             ("SQUARE ERA NAME TAISYOU" . 13181)
                             ("SQUARE ERA NAME MEIZI" . 13182)
                             ("SQUARE CORPORATION" . 13183)
                             ("SQUARE PA AMPS" . 13184)
                             ("SQUARE NA" . 13185)
                             ("SQUARE MU A" . 13186)
                             ("SQUARE MA" . 13187)
                             ("SQUARE KA" . 13188)
                             ("SQUARE KB" . 13189)
                             ("SQUARE MB" . 13190)
                             ("SQUARE GB" . 13191)
                             ("SQUARE CAL" . 13192)
                             ("SQUARE KCAL" . 13193)
                             ("SQUARE PF" . 13194)
                             ("SQUARE NF" . 13195)
                             ("SQUARE MU F" . 13196)
                             ("SQUARE MU G" . 13197)
                             ("SQUARE MG" . 13198)
                             ("SQUARE KG" . 13199)
                             ("SQUARE HZ" . 13200)
                             ("SQUARE KHZ" . 13201)
                             ("SQUARE MHZ" . 13202)
                             ("SQUARE GHZ" . 13203)
                             ("SQUARE THZ" . 13204)
                             ("SQUARE MU L" . 13205)
                             ("SQUARE ML" . 13206)
                             ("SQUARE DL" . 13207)
                             ("SQUARE KL" . 13208)
                             ("SQUARE FM" . 13209)
                             ("SQUARE NM" . 13210)
                             ("SQUARE MU M" . 13211)
                             ("SQUARE MM" . 13212)
                             ("SQUARE CM" . 13213)
                             ("SQUARE KM" . 13214)
                             ("SQUARE MM SQUARED" . 13215)
                             ("SQUARE CM SQUARED" . 13216)
                             ("SQUARE M SQUARED" . 13217)
                             ("SQUARE KM SQUARED" . 13218)
                             ("SQUARE MM CUBED" . 13219)
                             ("SQUARE CM CUBED" . 13220)
                             ("SQUARE M CUBED" . 13221)
                             ("SQUARE KM CUBED" . 13222)
                             ("SQUARE M OVER S" . 13223)
                             ("SQUARE M OVER S SQUARED" . 13224)
                             ("SQUARE PA" . 13225)
                             ("SQUARE KPA" . 13226)
                             ("SQUARE MPA" . 13227)
                             ("SQUARE GPA" . 13228)
                             ("SQUARE RAD" . 13229)
                             ("SQUARE RAD OVER S" . 13230)
                             ("SQUARE RAD OVER S SQUARED" . 13231)
                             ("SQUARE PS" . 13232)
                             ("SQUARE NS" . 13233)
                             ("SQUARE MU S" . 13234)
                             ("SQUARE MS" . 13235)
                             ("SQUARE PV" . 13236)
                             ("SQUARE NV" . 13237)
                             ("SQUARE MU V" . 13238)
                             ("SQUARE MV" . 13239)
                             ("SQUARE KV" . 13240)
                             ("SQUARE MV MEGA" . 13241)
                             ("SQUARE PW" . 13242)
                             ("SQUARE NW" . 13243)
                             ("SQUARE MU W" . 13244)
                             ("SQUARE MW" . 13245)
                             ("SQUARE KW" . 13246)
                             ("SQUARE MW MEGA" . 13247)
                             ("SQUARE K OHM" . 13248)
                             ("SQUARE M OHM" . 13249)
                             ("SQUARE AM" . 13250)
                             ("SQUARE BQ" . 13251)
                             ("SQUARE CC" . 13252)
                             ("SQUARE CD" . 13253)
                             ("SQUARE C OVER KG" . 13254)
                             ("SQUARE CO" . 13255)
                             ("SQUARE DB" . 13256)
                             ("SQUARE GY" . 13257)
                             ("SQUARE HA" . 13258)
                             ("SQUARE HP" . 13259)
                             ("SQUARE IN" . 13260)
                             ("SQUARE KK" . 13261)
                             ("SQUARE KM CAPITAL" . 13262)
                             ("SQUARE KT" . 13263)
                             ("SQUARE LM" . 13264)
                             ("SQUARE LN" . 13265)
                             ("SQUARE LOG" . 13266)
                             ("SQUARE LX" . 13267)
                             ("SQUARE MB SMALL" . 13268)
                             ("SQUARE MIL" . 13269)
                             ("SQUARE MOL" . 13270)
                             ("SQUARE PH" . 13271)
                             ("SQUARE PM" . 13272)
                             ("SQUARE PPM" . 13273)
                             ("SQUARE PR" . 13274)
                             ("SQUARE SR" . 13275)
                             ("SQUARE SV" . 13276)
                             ("SQUARE WB" . 13277)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE" . 13280)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO" . 13281)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE" . 13282)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR" . 13283)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE" . 13284)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX" . 13285)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN" . 13286)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT" . 13287)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE" . 13288)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN" . 13289)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN" . 13290)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE" . 13291)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN" . 13292)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN" . 13293)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN" . 13294)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN" . 13295)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN" . 13296)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN" . 13297)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN" . 13298)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY" . 13299)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE" . 13300)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO" . 13301)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE" . 13302)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR" . 13303)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE" . 13304)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX" . 13305)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN" . 13306)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT" . 13307)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE" . 13308)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY" . 13309)
                             ("IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE" . 13310)
                             ("YI SYLLABLE IT" . 40960)
                             ("YI SYLLABLE IX" . 40961)
                             ("YI SYLLABLE I" . 40962)
                             ("YI SYLLABLE IP" . 40963)
                             ("YI SYLLABLE IET" . 40964)
                             ("YI SYLLABLE IEX" . 40965)
                             ("YI SYLLABLE IE" . 40966)
                             ("YI SYLLABLE IEP" . 40967)
                             ("YI SYLLABLE AT" . 40968)
                             ("YI SYLLABLE AX" . 40969)
                             ("YI SYLLABLE A" . 40970)
                             ("YI SYLLABLE AP" . 40971)
                             ("YI SYLLABLE UOX" . 40972)
                             ("YI SYLLABLE UO" . 40973)
                             ("YI SYLLABLE UOP" . 40974)
                             ("YI SYLLABLE OT" . 40975)
                             ("YI SYLLABLE OX" . 40976)
                             ("YI SYLLABLE O" . 40977)
                             ("YI SYLLABLE OP" . 40978)
                             ("YI SYLLABLE EX" . 40979)
                             ("YI SYLLABLE E" . 40980)
                             ("YI SYLLABLE WU" . 40981)
                             ("YI SYLLABLE BIT" . 40982)
                             ("YI SYLLABLE BIX" . 40983)
                             ("YI SYLLABLE BI" . 40984)
                             ("YI SYLLABLE BIP" . 40985)
                             ("YI SYLLABLE BIET" . 40986)
                             ("YI SYLLABLE BIEX" . 40987)
                             ("YI SYLLABLE BIE" . 40988)
                             ("YI SYLLABLE BIEP" . 40989)
                             ("YI SYLLABLE BAT" . 40990)
                             ("YI SYLLABLE BAX" . 40991)
                             ("YI SYLLABLE BA" . 40992)
                             ("YI SYLLABLE BAP" . 40993)
                             ("YI SYLLABLE BUOX" . 40994)
                             ("YI SYLLABLE BUO" . 40995)
                             ("YI SYLLABLE BUOP" . 40996)
                             ("YI SYLLABLE BOT" . 40997)
                             ("YI SYLLABLE BOX" . 40998)
                             ("YI SYLLABLE BO" . 40999)
                             ("YI SYLLABLE BOP" . 41000)
                             ("YI SYLLABLE BEX" . 41001)
                             ("YI SYLLABLE BE" . 41002)
                             ("YI SYLLABLE BEP" . 41003)
                             ("YI SYLLABLE BUT" . 41004)
                             ("YI SYLLABLE BUX" . 41005)
                             ("YI SYLLABLE BU" . 41006)
                             ("YI SYLLABLE BUP" . 41007)
                             ("YI SYLLABLE BURX" . 41008)
                             ("YI SYLLABLE BUR" . 41009)
                             ("YI SYLLABLE BYT" . 41010)
                             ("YI SYLLABLE BYX" . 41011)
                             ("YI SYLLABLE BY" . 41012)
                             ("YI SYLLABLE BYP" . 41013)
                             ("YI SYLLABLE BYRX" . 41014)
                             ("YI SYLLABLE BYR" . 41015)
                             ("YI SYLLABLE PIT" . 41016)
                             ("YI SYLLABLE PIX" . 41017)
                             ("YI SYLLABLE PI" . 41018)
                             ("YI SYLLABLE PIP" . 41019)
                             ("YI SYLLABLE PIEX" . 41020)
                             ("YI SYLLABLE PIE" . 41021)
                             ("YI SYLLABLE PIEP" . 41022)
                             ("YI SYLLABLE PAT" . 41023)
                             ("YI SYLLABLE PAX" . 41024)
                             ("YI SYLLABLE PA" . 41025)
                             ("YI SYLLABLE PAP" . 41026)
                             ("YI SYLLABLE PUOX" . 41027)
                             ("YI SYLLABLE PUO" . 41028)
                             ("YI SYLLABLE PUOP" . 41029)
                             ("YI SYLLABLE POT" . 41030)
                             ("YI SYLLABLE POX" . 41031)
                             ("YI SYLLABLE PO" . 41032)
                             ("YI SYLLABLE POP" . 41033)
                             ("YI SYLLABLE PUT" . 41034)
                             ("YI SYLLABLE PUX" . 41035)
                             ("YI SYLLABLE PU" . 41036)
                             ("YI SYLLABLE PUP" . 41037)
                             ("YI SYLLABLE PURX" . 41038)
                             ("YI SYLLABLE PUR" . 41039)
                             ("YI SYLLABLE PYT" . 41040)
                             ("YI SYLLABLE PYX" . 41041)
                             ("YI SYLLABLE PY" . 41042)
                             ("YI SYLLABLE PYP" . 41043)
                             ("YI SYLLABLE PYRX" . 41044)
                             ("YI SYLLABLE PYR" . 41045)
                             ("YI SYLLABLE BBIT" . 41046)
                             ("YI SYLLABLE BBIX" . 41047)
                             ("YI SYLLABLE BBI" . 41048)
                             ("YI SYLLABLE BBIP" . 41049)
                             ("YI SYLLABLE BBIET" . 41050)
                             ("YI SYLLABLE BBIEX" . 41051)
                             ("YI SYLLABLE BBIE" . 41052)
                             ("YI SYLLABLE BBIEP" . 41053)
                             ("YI SYLLABLE BBAT" . 41054)
                             ("YI SYLLABLE BBAX" . 41055)
                             ("YI SYLLABLE BBA" . 41056)
                             ("YI SYLLABLE BBAP" . 41057)
                             ("YI SYLLABLE BBUOX" . 41058)
                             ("YI SYLLABLE BBUO" . 41059)
                             ("YI SYLLABLE BBUOP" . 41060)
                             ("YI SYLLABLE BBOT" . 41061)
                             ("YI SYLLABLE BBOX" . 41062)
                             ("YI SYLLABLE BBO" . 41063)
                             ("YI SYLLABLE BBOP" . 41064)
                             ("YI SYLLABLE BBEX" . 41065)
                             ("YI SYLLABLE BBE" . 41066)
                             ("YI SYLLABLE BBEP" . 41067)
                             ("YI SYLLABLE BBUT" . 41068)
                             ("YI SYLLABLE BBUX" . 41069)
                             ("YI SYLLABLE BBU" . 41070)
                             ("YI SYLLABLE BBUP" . 41071)
                             ("YI SYLLABLE BBURX" . 41072)
                             ("YI SYLLABLE BBUR" . 41073)
                             ("YI SYLLABLE BBYT" . 41074)
                             ("YI SYLLABLE BBYX" . 41075)
                             ("YI SYLLABLE BBY" . 41076)
                             ("YI SYLLABLE BBYP" . 41077)
                             ("YI SYLLABLE NBIT" . 41078)
                             ("YI SYLLABLE NBIX" . 41079)
                             ("YI SYLLABLE NBI" . 41080)
                             ("YI SYLLABLE NBIP" . 41081)
                             ("YI SYLLABLE NBIEX" . 41082)
                             ("YI SYLLABLE NBIE" . 41083)
                             ("YI SYLLABLE NBIEP" . 41084)
                             ("YI SYLLABLE NBAT" . 41085)
                             ("YI SYLLABLE NBAX" . 41086)
                             ("YI SYLLABLE NBA" . 41087)
                             ("YI SYLLABLE NBAP" . 41088)
                             ("YI SYLLABLE NBOT" . 41089)
                             ("YI SYLLABLE NBOX" . 41090)
                             ("YI SYLLABLE NBO" . 41091)
                             ("YI SYLLABLE NBOP" . 41092)
                             ("YI SYLLABLE NBUT" . 41093)
                             ("YI SYLLABLE NBUX" . 41094)
                             ("YI SYLLABLE NBU" . 41095)
                             ("YI SYLLABLE NBUP" . 41096)
                             ("YI SYLLABLE NBURX" . 41097)
                             ("YI SYLLABLE NBUR" . 41098)
                             ("YI SYLLABLE NBYT" . 41099)
                             ("YI SYLLABLE NBYX" . 41100)
                             ("YI SYLLABLE NBY" . 41101)
                             ("YI SYLLABLE NBYP" . 41102)
                             ("YI SYLLABLE NBYRX" . 41103)
                             ("YI SYLLABLE NBYR" . 41104)
                             ("YI SYLLABLE HMIT" . 41105)
                             ("YI SYLLABLE HMIX" . 41106)
                             ("YI SYLLABLE HMI" . 41107)
                             ("YI SYLLABLE HMIP" . 41108)
                             ("YI SYLLABLE HMIEX" . 41109)
                             ("YI SYLLABLE HMIE" . 41110)
                             ("YI SYLLABLE HMIEP" . 41111)
                             ("YI SYLLABLE HMAT" . 41112)
                             ("YI SYLLABLE HMAX" . 41113)
                             ("YI SYLLABLE HMA" . 41114)
                             ("YI SYLLABLE HMAP" . 41115)
                             ("YI SYLLABLE HMUOX" . 41116)
                             ("YI SYLLABLE HMUO" . 41117)
                             ("YI SYLLABLE HMUOP" . 41118)
                             ("YI SYLLABLE HMOT" . 41119)
                             ("YI SYLLABLE HMOX" . 41120)
                             ("YI SYLLABLE HMO" . 41121)
                             ("YI SYLLABLE HMOP" . 41122)
                             ("YI SYLLABLE HMUT" . 41123)
                             ("YI SYLLABLE HMUX" . 41124)
                             ("YI SYLLABLE HMU" . 41125)
                             ("YI SYLLABLE HMUP" . 41126)
                             ("YI SYLLABLE HMURX" . 41127)
                             ("YI SYLLABLE HMUR" . 41128)
                             ("YI SYLLABLE HMYX" . 41129)
                             ("YI SYLLABLE HMY" . 41130)
                             ("YI SYLLABLE HMYP" . 41131)
                             ("YI SYLLABLE HMYRX" . 41132)
                             ("YI SYLLABLE HMYR" . 41133)
                             ("YI SYLLABLE MIT" . 41134)
                             ("YI SYLLABLE MIX" . 41135)
                             ("YI SYLLABLE MI" . 41136)
                             ("YI SYLLABLE MIP" . 41137)
                             ("YI SYLLABLE MIEX" . 41138)
                             ("YI SYLLABLE MIE" . 41139)
                             ("YI SYLLABLE MIEP" . 41140)
                             ("YI SYLLABLE MAT" . 41141)
                             ("YI SYLLABLE MAX" . 41142)
                             ("YI SYLLABLE MA" . 41143)
                             ("YI SYLLABLE MAP" . 41144)
                             ("YI SYLLABLE MUOT" . 41145)
                             ("YI SYLLABLE MUOX" . 41146)
                             ("YI SYLLABLE MUO" . 41147)
                             ("YI SYLLABLE MUOP" . 41148)
                             ("YI SYLLABLE MOT" . 41149)
                             ("YI SYLLABLE MOX" . 41150)
                             ("YI SYLLABLE MO" . 41151)
                             ("YI SYLLABLE MOP" . 41152)
                             ("YI SYLLABLE MEX" . 41153)
                             ("YI SYLLABLE ME" . 41154)
                             ("YI SYLLABLE MUT" . 41155)
                             ("YI SYLLABLE MUX" . 41156)
                             ("YI SYLLABLE MU" . 41157)
                             ("YI SYLLABLE MUP" . 41158)
                             ("YI SYLLABLE MURX" . 41159)
                             ("YI SYLLABLE MUR" . 41160)
                             ("YI SYLLABLE MYT" . 41161)
                             ("YI SYLLABLE MYX" . 41162)
                             ("YI SYLLABLE MY" . 41163)
                             ("YI SYLLABLE MYP" . 41164)
                             ("YI SYLLABLE FIT" . 41165)
                             ("YI SYLLABLE FIX" . 41166)
                             ("YI SYLLABLE FI" . 41167)
                             ("YI SYLLABLE FIP" . 41168)
                             ("YI SYLLABLE FAT" . 41169)
                             ("YI SYLLABLE FAX" . 41170)
                             ("YI SYLLABLE FA" . 41171)
                             ("YI SYLLABLE FAP" . 41172)
                             ("YI SYLLABLE FOX" . 41173)
                             ("YI SYLLABLE FO" . 41174)
                             ("YI SYLLABLE FOP" . 41175)
                             ("YI SYLLABLE FUT" . 41176)
                             ("YI SYLLABLE FUX" . 41177)
                             ("YI SYLLABLE FU" . 41178)
                             ("YI SYLLABLE FUP" . 41179)
                             ("YI SYLLABLE FURX" . 41180)
                             ("YI SYLLABLE FUR" . 41181)
                             ("YI SYLLABLE FYT" . 41182)
                             ("YI SYLLABLE FYX" . 41183)
                             ("YI SYLLABLE FY" . 41184)
                             ("YI SYLLABLE FYP" . 41185)
                             ("YI SYLLABLE VIT" . 41186)
                             ("YI SYLLABLE VIX" . 41187)
                             ("YI SYLLABLE VI" . 41188)
                             ("YI SYLLABLE VIP" . 41189)
                             ("YI SYLLABLE VIET" . 41190)
                             ("YI SYLLABLE VIEX" . 41191)
                             ("YI SYLLABLE VIE" . 41192)
                             ("YI SYLLABLE VIEP" . 41193)
                             ("YI SYLLABLE VAT" . 41194)
                             ("YI SYLLABLE VAX" . 41195)
                             ("YI SYLLABLE VA" . 41196)
                             ("YI SYLLABLE VAP" . 41197)
                             ("YI SYLLABLE VOT" . 41198)
                             ("YI SYLLABLE VOX" . 41199)
                             ("YI SYLLABLE VO" . 41200)
                             ("YI SYLLABLE VOP" . 41201)
                             ("YI SYLLABLE VEX" . 41202)
                             ("YI SYLLABLE VEP" . 41203)
                             ("YI SYLLABLE VUT" . 41204)
                             ("YI SYLLABLE VUX" . 41205)
                             ("YI SYLLABLE VU" . 41206)
                             ("YI SYLLABLE VUP" . 41207)
                             ("YI SYLLABLE VURX" . 41208)
                             ("YI SYLLABLE VUR" . 41209)
                             ("YI SYLLABLE VYT" . 41210)
                             ("YI SYLLABLE VYX" . 41211)
                             ("YI SYLLABLE VY" . 41212)
                             ("YI SYLLABLE VYP" . 41213)
                             ("YI SYLLABLE VYRX" . 41214)
                             ("YI SYLLABLE VYR" . 41215)
                             ("YI SYLLABLE DIT" . 41216)
                             ("YI SYLLABLE DIX" . 41217)
                             ("YI SYLLABLE DI" . 41218)
                             ("YI SYLLABLE DIP" . 41219)
                             ("YI SYLLABLE DIEX" . 41220)
                             ("YI SYLLABLE DIE" . 41221)
                             ("YI SYLLABLE DIEP" . 41222)
                             ("YI SYLLABLE DAT" . 41223)
                             ("YI SYLLABLE DAX" . 41224)
                             ("YI SYLLABLE DA" . 41225)
                             ("YI SYLLABLE DAP" . 41226)
                             ("YI SYLLABLE DUOX" . 41227)
                             ("YI SYLLABLE DUO" . 41228)
                             ("YI SYLLABLE DOT" . 41229)
                             ("YI SYLLABLE DOX" . 41230)
                             ("YI SYLLABLE DO" . 41231)
                             ("YI SYLLABLE DOP" . 41232)
                             ("YI SYLLABLE DEX" . 41233)
                             ("YI SYLLABLE DE" . 41234)
                             ("YI SYLLABLE DEP" . 41235)
                             ("YI SYLLABLE DUT" . 41236)
                             ("YI SYLLABLE DUX" . 41237)
                             ("YI SYLLABLE DU" . 41238)
                             ("YI SYLLABLE DUP" . 41239)
                             ("YI SYLLABLE DURX" . 41240)
                             ("YI SYLLABLE DUR" . 41241)
                             ("YI SYLLABLE TIT" . 41242)
                             ("YI SYLLABLE TIX" . 41243)
                             ("YI SYLLABLE TI" . 41244)
                             ("YI SYLLABLE TIP" . 41245)
                             ("YI SYLLABLE TIEX" . 41246)
                             ("YI SYLLABLE TIE" . 41247)
                             ("YI SYLLABLE TIEP" . 41248)
                             ("YI SYLLABLE TAT" . 41249)
                             ("YI SYLLABLE TAX" . 41250)
                             ("YI SYLLABLE TA" . 41251)
                             ("YI SYLLABLE TAP" . 41252)
                             ("YI SYLLABLE TUOT" . 41253)
                             ("YI SYLLABLE TUOX" . 41254)
                             ("YI SYLLABLE TUO" . 41255)
                             ("YI SYLLABLE TUOP" . 41256)
                             ("YI SYLLABLE TOT" . 41257)
                             ("YI SYLLABLE TOX" . 41258)
                             ("YI SYLLABLE TO" . 41259)
                             ("YI SYLLABLE TOP" . 41260)
                             ("YI SYLLABLE TEX" . 41261)
                             ("YI SYLLABLE TE" . 41262)
                             ("YI SYLLABLE TEP" . 41263)
                             ("YI SYLLABLE TUT" . 41264)
                             ("YI SYLLABLE TUX" . 41265)
                             ("YI SYLLABLE TU" . 41266)
                             ("YI SYLLABLE TUP" . 41267)
                             ("YI SYLLABLE TURX" . 41268)
                             ("YI SYLLABLE TUR" . 41269)
                             ("YI SYLLABLE DDIT" . 41270)
                             ("YI SYLLABLE DDIX" . 41271)
                             ("YI SYLLABLE DDI" . 41272)
                             ("YI SYLLABLE DDIP" . 41273)
                             ("YI SYLLABLE DDIEX" . 41274)
                             ("YI SYLLABLE DDIE" . 41275)
                             ("YI SYLLABLE DDIEP" . 41276)
                             ("YI SYLLABLE DDAT" . 41277)
                             ("YI SYLLABLE DDAX" . 41278)
                             ("YI SYLLABLE DDA" . 41279)
                             ("YI SYLLABLE DDAP" . 41280)
                             ("YI SYLLABLE DDUOX" . 41281)
                             ("YI SYLLABLE DDUO" . 41282)
                             ("YI SYLLABLE DDUOP" . 41283)
                             ("YI SYLLABLE DDOT" . 41284)
                             ("YI SYLLABLE DDOX" . 41285)
                             ("YI SYLLABLE DDO" . 41286)
                             ("YI SYLLABLE DDOP" . 41287)
                             ("YI SYLLABLE DDEX" . 41288)
                             ("YI SYLLABLE DDE" . 41289)
                             ("YI SYLLABLE DDEP" . 41290)
                             ("YI SYLLABLE DDUT" . 41291)
                             ("YI SYLLABLE DDUX" . 41292)
                             ("YI SYLLABLE DDU" . 41293)
                             ("YI SYLLABLE DDUP" . 41294)
                             ("YI SYLLABLE DDURX" . 41295)
                             ("YI SYLLABLE DDUR" . 41296)
                             ("YI SYLLABLE NDIT" . 41297)
                             ("YI SYLLABLE NDIX" . 41298)
                             ("YI SYLLABLE NDI" . 41299)
                             ("YI SYLLABLE NDIP" . 41300)
                             ("YI SYLLABLE NDIEX" . 41301)
                             ("YI SYLLABLE NDIE" . 41302)
                             ("YI SYLLABLE NDAT" . 41303)
                             ("YI SYLLABLE NDAX" . 41304)
                             ("YI SYLLABLE NDA" . 41305)
                             ("YI SYLLABLE NDAP" . 41306)
                             ("YI SYLLABLE NDOT" . 41307)
                             ("YI SYLLABLE NDOX" . 41308)
                             ("YI SYLLABLE NDO" . 41309)
                             ("YI SYLLABLE NDOP" . 41310)
                             ("YI SYLLABLE NDEX" . 41311)
                             ("YI SYLLABLE NDE" . 41312)
                             ("YI SYLLABLE NDEP" . 41313)
                             ("YI SYLLABLE NDUT" . 41314)
                             ("YI SYLLABLE NDUX" . 41315)
                             ("YI SYLLABLE NDU" . 41316)
                             ("YI SYLLABLE NDUP" . 41317)
                             ("YI SYLLABLE NDURX" . 41318)
                             ("YI SYLLABLE NDUR" . 41319)
                             ("YI SYLLABLE HNIT" . 41320)
                             ("YI SYLLABLE HNIX" . 41321)
                             ("YI SYLLABLE HNI" . 41322)
                             ("YI SYLLABLE HNIP" . 41323)
                             ("YI SYLLABLE HNIET" . 41324)
                             ("YI SYLLABLE HNIEX" . 41325)
                             ("YI SYLLABLE HNIE" . 41326)
                             ("YI SYLLABLE HNIEP" . 41327)
                             ("YI SYLLABLE HNAT" . 41328)
                             ("YI SYLLABLE HNAX" . 41329)
                             ("YI SYLLABLE HNA" . 41330)
                             ("YI SYLLABLE HNAP" . 41331)
                             ("YI SYLLABLE HNUOX" . 41332)
                             ("YI SYLLABLE HNUO" . 41333)
                             ("YI SYLLABLE HNOT" . 41334)
                             ("YI SYLLABLE HNOX" . 41335)
                             ("YI SYLLABLE HNOP" . 41336)
                             ("YI SYLLABLE HNEX" . 41337)
                             ("YI SYLLABLE HNE" . 41338)
                             ("YI SYLLABLE HNEP" . 41339)
                             ("YI SYLLABLE HNUT" . 41340)
                             ("YI SYLLABLE NIT" . 41341)
                             ("YI SYLLABLE NIX" . 41342)
                             ("YI SYLLABLE NI" . 41343)
                             ("YI SYLLABLE NIP" . 41344)
                             ("YI SYLLABLE NIEX" . 41345)
                             ("YI SYLLABLE NIE" . 41346)
                             ("YI SYLLABLE NIEP" . 41347)
                             ("YI SYLLABLE NAX" . 41348)
                             ("YI SYLLABLE NA" . 41349)
                             ("YI SYLLABLE NAP" . 41350)
                             ("YI SYLLABLE NUOX" . 41351)
                             ("YI SYLLABLE NUO" . 41352)
                             ("YI SYLLABLE NUOP" . 41353)
                             ("YI SYLLABLE NOT" . 41354)
                             ("YI SYLLABLE NOX" . 41355)
                             ("YI SYLLABLE NO" . 41356)
                             ("YI SYLLABLE NOP" . 41357)
                             ("YI SYLLABLE NEX" . 41358)
                             ("YI SYLLABLE NE" . 41359)
                             ("YI SYLLABLE NEP" . 41360)
                             ("YI SYLLABLE NUT" . 41361)
                             ("YI SYLLABLE NUX" . 41362)
                             ("YI SYLLABLE NU" . 41363)
                             ("YI SYLLABLE NUP" . 41364)
                             ("YI SYLLABLE NURX" . 41365)
                             ("YI SYLLABLE NUR" . 41366)
                             ("YI SYLLABLE HLIT" . 41367)
                             ("YI SYLLABLE HLIX" . 41368)
                             ("YI SYLLABLE HLI" . 41369)
                             ("YI SYLLABLE HLIP" . 41370)
                             ("YI SYLLABLE HLIEX" . 41371)
                             ("YI SYLLABLE HLIE" . 41372)
                             ("YI SYLLABLE HLIEP" . 41373)
                             ("YI SYLLABLE HLAT" . 41374)
                             ("YI SYLLABLE HLAX" . 41375)
                             ("YI SYLLABLE HLA" . 41376)
                             ("YI SYLLABLE HLAP" . 41377)
                             ("YI SYLLABLE HLUOX" . 41378)
                             ("YI SYLLABLE HLUO" . 41379)
                             ("YI SYLLABLE HLUOP" . 41380)
                             ("YI SYLLABLE HLOX" . 41381)
                             ("YI SYLLABLE HLO" . 41382)
                             ("YI SYLLABLE HLOP" . 41383)
                             ("YI SYLLABLE HLEX" . 41384)
                             ("YI SYLLABLE HLE" . 41385)
                             ("YI SYLLABLE HLEP" . 41386)
                             ("YI SYLLABLE HLUT" . 41387)
                             ("YI SYLLABLE HLUX" . 41388)
                             ("YI SYLLABLE HLU" . 41389)
                             ("YI SYLLABLE HLUP" . 41390)
                             ("YI SYLLABLE HLURX" . 41391)
                             ("YI SYLLABLE HLUR" . 41392)
                             ("YI SYLLABLE HLYT" . 41393)
                             ("YI SYLLABLE HLYX" . 41394)
                             ("YI SYLLABLE HLY" . 41395)
                             ("YI SYLLABLE HLYP" . 41396)
                             ("YI SYLLABLE HLYRX" . 41397)
                             ("YI SYLLABLE HLYR" . 41398)
                             ("YI SYLLABLE LIT" . 41399)
                             ("YI SYLLABLE LIX" . 41400)
                             ("YI SYLLABLE LI" . 41401)
                             ("YI SYLLABLE LIP" . 41402)
                             ("YI SYLLABLE LIET" . 41403)
                             ("YI SYLLABLE LIEX" . 41404)
                             ("YI SYLLABLE LIE" . 41405)
                             ("YI SYLLABLE LIEP" . 41406)
                             ("YI SYLLABLE LAT" . 41407)
                             ("YI SYLLABLE LAX" . 41408)
                             ("YI SYLLABLE LA" . 41409)
                             ("YI SYLLABLE LAP" . 41410)
                             ("YI SYLLABLE LUOT" . 41411)
                             ("YI SYLLABLE LUOX" . 41412)
                             ("YI SYLLABLE LUO" . 41413)
                             ("YI SYLLABLE LUOP" . 41414)
                             ("YI SYLLABLE LOT" . 41415)
                             ("YI SYLLABLE LOX" . 41416)
                             ("YI SYLLABLE LO" . 41417)
                             ("YI SYLLABLE LOP" . 41418)
                             ("YI SYLLABLE LEX" . 41419)
                             ("YI SYLLABLE LE" . 41420)
                             ("YI SYLLABLE LEP" . 41421)
                             ("YI SYLLABLE LUT" . 41422)
                             ("YI SYLLABLE LUX" . 41423)
                             ("YI SYLLABLE LU" . 41424)
                             ("YI SYLLABLE LUP" . 41425)
                             ("YI SYLLABLE LURX" . 41426)
                             ("YI SYLLABLE LUR" . 41427)
                             ("YI SYLLABLE LYT" . 41428)
                             ("YI SYLLABLE LYX" . 41429)
                             ("YI SYLLABLE LY" . 41430)
                             ("YI SYLLABLE LYP" . 41431)
                             ("YI SYLLABLE LYRX" . 41432)
                             ("YI SYLLABLE LYR" . 41433)
                             ("YI SYLLABLE GIT" . 41434)
                             ("YI SYLLABLE GIX" . 41435)
                             ("YI SYLLABLE GI" . 41436)
                             ("YI SYLLABLE GIP" . 41437)
                             ("YI SYLLABLE GIET" . 41438)
                             ("YI SYLLABLE GIEX" . 41439)
                             ("YI SYLLABLE GIE" . 41440)
                             ("YI SYLLABLE GIEP" . 41441)
                             ("YI SYLLABLE GAT" . 41442)
                             ("YI SYLLABLE GAX" . 41443)
                             ("YI SYLLABLE GA" . 41444)
                             ("YI SYLLABLE GAP" . 41445)
                             ("YI SYLLABLE GUOT" . 41446)
                             ("YI SYLLABLE GUOX" . 41447)
                             ("YI SYLLABLE GUO" . 41448)
                             ("YI SYLLABLE GUOP" . 41449)
                             ("YI SYLLABLE GOT" . 41450)
                             ("YI SYLLABLE GOX" . 41451)
                             ("YI SYLLABLE GO" . 41452)
                             ("YI SYLLABLE GOP" . 41453)
                             ("YI SYLLABLE GET" . 41454)
                             ("YI SYLLABLE GEX" . 41455)
                             ("YI SYLLABLE GE" . 41456)
                             ("YI SYLLABLE GEP" . 41457)
                             ("YI SYLLABLE GUT" . 41458)
                             ("YI SYLLABLE GUX" . 41459)
                             ("YI SYLLABLE GU" . 41460)
                             ("YI SYLLABLE GUP" . 41461)
                             ("YI SYLLABLE GURX" . 41462)
                             ("YI SYLLABLE GUR" . 41463)
                             ("YI SYLLABLE KIT" . 41464)
                             ("YI SYLLABLE KIX" . 41465)
                             ("YI SYLLABLE KI" . 41466)
                             ("YI SYLLABLE KIP" . 41467)
                             ("YI SYLLABLE KIEX" . 41468)
                             ("YI SYLLABLE KIE" . 41469)
                             ("YI SYLLABLE KIEP" . 41470)
                             ("YI SYLLABLE KAT" . 41471)
                             ("YI SYLLABLE KAX" . 41472)
                             ("YI SYLLABLE KA" . 41473)
                             ("YI SYLLABLE KAP" . 41474)
                             ("YI SYLLABLE KUOX" . 41475)
                             ("YI SYLLABLE KUO" . 41476)
                             ("YI SYLLABLE KUOP" . 41477)
                             ("YI SYLLABLE KOT" . 41478)
                             ("YI SYLLABLE KOX" . 41479)
                             ("YI SYLLABLE KO" . 41480)
                             ("YI SYLLABLE KOP" . 41481)
                             ("YI SYLLABLE KET" . 41482)
                             ("YI SYLLABLE KEX" . 41483)
                             ("YI SYLLABLE KE" . 41484)
                             ("YI SYLLABLE KEP" . 41485)
                             ("YI SYLLABLE KUT" . 41486)
                             ("YI SYLLABLE KUX" . 41487)
                             ("YI SYLLABLE KU" . 41488)
                             ("YI SYLLABLE KUP" . 41489)
                             ("YI SYLLABLE KURX" . 41490)
                             ("YI SYLLABLE KUR" . 41491)
                             ("YI SYLLABLE GGIT" . 41492)
                             ("YI SYLLABLE GGIX" . 41493)
                             ("YI SYLLABLE GGI" . 41494)
                             ("YI SYLLABLE GGIEX" . 41495)
                             ("YI SYLLABLE GGIE" . 41496)
                             ("YI SYLLABLE GGIEP" . 41497)
                             ("YI SYLLABLE GGAT" . 41498)
                             ("YI SYLLABLE GGAX" . 41499)
                             ("YI SYLLABLE GGA" . 41500)
                             ("YI SYLLABLE GGAP" . 41501)
                             ("YI SYLLABLE GGUOT" . 41502)
                             ("YI SYLLABLE GGUOX" . 41503)
                             ("YI SYLLABLE GGUO" . 41504)
                             ("YI SYLLABLE GGUOP" . 41505)
                             ("YI SYLLABLE GGOT" . 41506)
                             ("YI SYLLABLE GGOX" . 41507)
                             ("YI SYLLABLE GGO" . 41508)
                             ("YI SYLLABLE GGOP" . 41509)
                             ("YI SYLLABLE GGET" . 41510)
                             ("YI SYLLABLE GGEX" . 41511)
                             ("YI SYLLABLE GGE" . 41512)
                             ("YI SYLLABLE GGEP" . 41513)
                             ("YI SYLLABLE GGUT" . 41514)
                             ("YI SYLLABLE GGUX" . 41515)
                             ("YI SYLLABLE GGU" . 41516)
                             ("YI SYLLABLE GGUP" . 41517)
                             ("YI SYLLABLE GGURX" . 41518)
                             ("YI SYLLABLE GGUR" . 41519)
                             ("YI SYLLABLE MGIEX" . 41520)
                             ("YI SYLLABLE MGIE" . 41521)
                             ("YI SYLLABLE MGAT" . 41522)
                             ("YI SYLLABLE MGAX" . 41523)
                             ("YI SYLLABLE MGA" . 41524)
                             ("YI SYLLABLE MGAP" . 41525)
                             ("YI SYLLABLE MGUOX" . 41526)
                             ("YI SYLLABLE MGUO" . 41527)
                             ("YI SYLLABLE MGUOP" . 41528)
                             ("YI SYLLABLE MGOT" . 41529)
                             ("YI SYLLABLE MGOX" . 41530)
                             ("YI SYLLABLE MGO" . 41531)
                             ("YI SYLLABLE MGOP" . 41532)
                             ("YI SYLLABLE MGEX" . 41533)
                             ("YI SYLLABLE MGE" . 41534)
                             ("YI SYLLABLE MGEP" . 41535)
                             ("YI SYLLABLE MGUT" . 41536)
                             ("YI SYLLABLE MGUX" . 41537)
                             ("YI SYLLABLE MGU" . 41538)
                             ("YI SYLLABLE MGUP" . 41539)
                             ("YI SYLLABLE MGURX" . 41540)
                             ("YI SYLLABLE MGUR" . 41541)
                             ("YI SYLLABLE HXIT" . 41542)
                             ("YI SYLLABLE HXIX" . 41543)
                             ("YI SYLLABLE HXI" . 41544)
                             ("YI SYLLABLE HXIP" . 41545)
                             ("YI SYLLABLE HXIET" . 41546)
                             ("YI SYLLABLE HXIEX" . 41547)
                             ("YI SYLLABLE HXIE" . 41548)
                             ("YI SYLLABLE HXIEP" . 41549)
                             ("YI SYLLABLE HXAT" . 41550)
                             ("YI SYLLABLE HXAX" . 41551)
                             ("YI SYLLABLE HXA" . 41552)
                             ("YI SYLLABLE HXAP" . 41553)
                             ("YI SYLLABLE HXUOT" . 41554)
                             ("YI SYLLABLE HXUOX" . 41555)
                             ("YI SYLLABLE HXUO" . 41556)
                             ("YI SYLLABLE HXUOP" . 41557)
                             ("YI SYLLABLE HXOT" . 41558)
                             ("YI SYLLABLE HXOX" . 41559)
                             ("YI SYLLABLE HXO" . 41560)
                             ("YI SYLLABLE HXOP" . 41561)
                             ("YI SYLLABLE HXEX" . 41562)
                             ("YI SYLLABLE HXE" . 41563)
                             ("YI SYLLABLE HXEP" . 41564)
                             ("YI SYLLABLE NGIEX" . 41565)
                             ("YI SYLLABLE NGIE" . 41566)
                             ("YI SYLLABLE NGIEP" . 41567)
                             ("YI SYLLABLE NGAT" . 41568)
                             ("YI SYLLABLE NGAX" . 41569)
                             ("YI SYLLABLE NGA" . 41570)
                             ("YI SYLLABLE NGAP" . 41571)
                             ("YI SYLLABLE NGUOT" . 41572)
                             ("YI SYLLABLE NGUOX" . 41573)
                             ("YI SYLLABLE NGUO" . 41574)
                             ("YI SYLLABLE NGOT" . 41575)
                             ("YI SYLLABLE NGOX" . 41576)
                             ("YI SYLLABLE NGO" . 41577)
                             ("YI SYLLABLE NGOP" . 41578)
                             ("YI SYLLABLE NGEX" . 41579)
                             ("YI SYLLABLE NGE" . 41580)
                             ("YI SYLLABLE NGEP" . 41581)
                             ("YI SYLLABLE HIT" . 41582)
                             ("YI SYLLABLE HIEX" . 41583)
                             ("YI SYLLABLE HIE" . 41584)
                             ("YI SYLLABLE HAT" . 41585)
                             ("YI SYLLABLE HAX" . 41586)
                             ("YI SYLLABLE HA" . 41587)
                             ("YI SYLLABLE HAP" . 41588)
                             ("YI SYLLABLE HUOT" . 41589)
                             ("YI SYLLABLE HUOX" . 41590)
                             ("YI SYLLABLE HUO" . 41591)
                             ("YI SYLLABLE HUOP" . 41592)
                             ("YI SYLLABLE HOT" . 41593)
                             ("YI SYLLABLE HOX" . 41594)
                             ("YI SYLLABLE HO" . 41595)
                             ("YI SYLLABLE HOP" . 41596)
                             ("YI SYLLABLE HEX" . 41597)
                             ("YI SYLLABLE HE" . 41598)
                             ("YI SYLLABLE HEP" . 41599)
                             ("YI SYLLABLE WAT" . 41600)
                             ("YI SYLLABLE WAX" . 41601)
                             ("YI SYLLABLE WA" . 41602)
                             ("YI SYLLABLE WAP" . 41603)
                             ("YI SYLLABLE WUOX" . 41604)
                             ("YI SYLLABLE WUO" . 41605)
                             ("YI SYLLABLE WUOP" . 41606)
                             ("YI SYLLABLE WOX" . 41607)
                             ("YI SYLLABLE WO" . 41608)
                             ("YI SYLLABLE WOP" . 41609)
                             ("YI SYLLABLE WEX" . 41610)
                             ("YI SYLLABLE WE" . 41611)
                             ("YI SYLLABLE WEP" . 41612)
                             ("YI SYLLABLE ZIT" . 41613)
                             ("YI SYLLABLE ZIX" . 41614)
                             ("YI SYLLABLE ZI" . 41615)
                             ("YI SYLLABLE ZIP" . 41616)
                             ("YI SYLLABLE ZIEX" . 41617)
                             ("YI SYLLABLE ZIE" . 41618)
                             ("YI SYLLABLE ZIEP" . 41619)
                             ("YI SYLLABLE ZAT" . 41620)
                             ("YI SYLLABLE ZAX" . 41621)
                             ("YI SYLLABLE ZA" . 41622)
                             ("YI SYLLABLE ZAP" . 41623)
                             ("YI SYLLABLE ZUOX" . 41624)
                             ("YI SYLLABLE ZUO" . 41625)
                             ("YI SYLLABLE ZUOP" . 41626)
                             ("YI SYLLABLE ZOT" . 41627)
                             ("YI SYLLABLE ZOX" . 41628)
                             ("YI SYLLABLE ZO" . 41629)
                             ("YI SYLLABLE ZOP" . 41630)
                             ("YI SYLLABLE ZEX" . 41631)
                             ("YI SYLLABLE ZE" . 41632)
                             ("YI SYLLABLE ZEP" . 41633)
                             ("YI SYLLABLE ZUT" . 41634)
                             ("YI SYLLABLE ZUX" . 41635)
                             ("YI SYLLABLE ZU" . 41636)
                             ("YI SYLLABLE ZUP" . 41637)
                             ("YI SYLLABLE ZURX" . 41638)
                             ("YI SYLLABLE ZUR" . 41639)
                             ("YI SYLLABLE ZYT" . 41640)
                             ("YI SYLLABLE ZYX" . 41641)
                             ("YI SYLLABLE ZY" . 41642)
                             ("YI SYLLABLE ZYP" . 41643)
                             ("YI SYLLABLE ZYRX" . 41644)
                             ("YI SYLLABLE ZYR" . 41645)
                             ("YI SYLLABLE CIT" . 41646)
                             ("YI SYLLABLE CIX" . 41647)
                             ("YI SYLLABLE CI" . 41648)
                             ("YI SYLLABLE CIP" . 41649)
                             ("YI SYLLABLE CIET" . 41650)
                             ("YI SYLLABLE CIEX" . 41651)
                             ("YI SYLLABLE CIE" . 41652)
                             ("YI SYLLABLE CIEP" . 41653)
                             ("YI SYLLABLE CAT" . 41654)
                             ("YI SYLLABLE CAX" . 41655)
                             ("YI SYLLABLE CA" . 41656)
                             ("YI SYLLABLE CAP" . 41657)
                             ("YI SYLLABLE CUOX" . 41658)
                             ("YI SYLLABLE CUO" . 41659)
                             ("YI SYLLABLE CUOP" . 41660)
                             ("YI SYLLABLE COT" . 41661)
                             ("YI SYLLABLE COX" . 41662)
                             ("YI SYLLABLE CO" . 41663)
                             ("YI SYLLABLE COP" . 41664)
                             ("YI SYLLABLE CEX" . 41665)
                             ("YI SYLLABLE CE" . 41666)
                             ("YI SYLLABLE CEP" . 41667)
                             ("YI SYLLABLE CUT" . 41668)
                             ("YI SYLLABLE CUX" . 41669)
                             ("YI SYLLABLE CU" . 41670)
                             ("YI SYLLABLE CUP" . 41671)
                             ("YI SYLLABLE CURX" . 41672)
                             ("YI SYLLABLE CUR" . 41673)
                             ("YI SYLLABLE CYT" . 41674)
                             ("YI SYLLABLE CYX" . 41675)
                             ("YI SYLLABLE CY" . 41676)
                             ("YI SYLLABLE CYP" . 41677)
                             ("YI SYLLABLE CYRX" . 41678)
                             ("YI SYLLABLE CYR" . 41679)
                             ("YI SYLLABLE ZZIT" . 41680)
                             ("YI SYLLABLE ZZIX" . 41681)
                             ("YI SYLLABLE ZZI" . 41682)
                             ("YI SYLLABLE ZZIP" . 41683)
                             ("YI SYLLABLE ZZIET" . 41684)
                             ("YI SYLLABLE ZZIEX" . 41685)
                             ("YI SYLLABLE ZZIE" . 41686)
                             ("YI SYLLABLE ZZIEP" . 41687)
                             ("YI SYLLABLE ZZAT" . 41688)
                             ("YI SYLLABLE ZZAX" . 41689)
                             ("YI SYLLABLE ZZA" . 41690)
                             ("YI SYLLABLE ZZAP" . 41691)
                             ("YI SYLLABLE ZZOX" . 41692)
                             ("YI SYLLABLE ZZO" . 41693)
                             ("YI SYLLABLE ZZOP" . 41694)
                             ("YI SYLLABLE ZZEX" . 41695)
                             ("YI SYLLABLE ZZE" . 41696)
                             ("YI SYLLABLE ZZEP" . 41697)
                             ("YI SYLLABLE ZZUX" . 41698)
                             ("YI SYLLABLE ZZU" . 41699)
                             ("YI SYLLABLE ZZUP" . 41700)
                             ("YI SYLLABLE ZZURX" . 41701)
                             ("YI SYLLABLE ZZUR" . 41702)
                             ("YI SYLLABLE ZZYT" . 41703)
                             ("YI SYLLABLE ZZYX" . 41704)
                             ("YI SYLLABLE ZZY" . 41705)
                             ("YI SYLLABLE ZZYP" . 41706)
                             ("YI SYLLABLE ZZYRX" . 41707)
                             ("YI SYLLABLE ZZYR" . 41708)
                             ("YI SYLLABLE NZIT" . 41709)
                             ("YI SYLLABLE NZIX" . 41710)
                             ("YI SYLLABLE NZI" . 41711)
                             ("YI SYLLABLE NZIP" . 41712)
                             ("YI SYLLABLE NZIEX" . 41713)
                             ("YI SYLLABLE NZIE" . 41714)
                             ("YI SYLLABLE NZIEP" . 41715)
                             ("YI SYLLABLE NZAT" . 41716)
                             ("YI SYLLABLE NZAX" . 41717)
                             ("YI SYLLABLE NZA" . 41718)
                             ("YI SYLLABLE NZAP" . 41719)
                             ("YI SYLLABLE NZUOX" . 41720)
                             ("YI SYLLABLE NZUO" . 41721)
                             ("YI SYLLABLE NZOX" . 41722)
                             ("YI SYLLABLE NZOP" . 41723)
                             ("YI SYLLABLE NZEX" . 41724)
                             ("YI SYLLABLE NZE" . 41725)
                             ("YI SYLLABLE NZUX" . 41726)
                             ("YI SYLLABLE NZU" . 41727)
                             ("YI SYLLABLE NZUP" . 41728)
                             ("YI SYLLABLE NZURX" . 41729)
                             ("YI SYLLABLE NZUR" . 41730)
                             ("YI SYLLABLE NZYT" . 41731)
                             ("YI SYLLABLE NZYX" . 41732)
                             ("YI SYLLABLE NZY" . 41733)
                             ("YI SYLLABLE NZYP" . 41734)
                             ("YI SYLLABLE NZYRX" . 41735)
                             ("YI SYLLABLE NZYR" . 41736)
                             ("YI SYLLABLE SIT" . 41737)
                             ("YI SYLLABLE SIX" . 41738)
                             ("YI SYLLABLE SI" . 41739)
                             ("YI SYLLABLE SIP" . 41740)
                             ("YI SYLLABLE SIEX" . 41741)
                             ("YI SYLLABLE SIE" . 41742)
                             ("YI SYLLABLE SIEP" . 41743)
                             ("YI SYLLABLE SAT" . 41744)
                             ("YI SYLLABLE SAX" . 41745)
                             ("YI SYLLABLE SA" . 41746)
                             ("YI SYLLABLE SAP" . 41747)
                             ("YI SYLLABLE SUOX" . 41748)
                             ("YI SYLLABLE SUO" . 41749)
                             ("YI SYLLABLE SUOP" . 41750)
                             ("YI SYLLABLE SOT" . 41751)
                             ("YI SYLLABLE SOX" . 41752)
                             ("YI SYLLABLE SO" . 41753)
                             ("YI SYLLABLE SOP" . 41754)
                             ("YI SYLLABLE SEX" . 41755)
                             ("YI SYLLABLE SE" . 41756)
                             ("YI SYLLABLE SEP" . 41757)
                             ("YI SYLLABLE SUT" . 41758)
                             ("YI SYLLABLE SUX" . 41759)
                             ("YI SYLLABLE SU" . 41760)
                             ("YI SYLLABLE SUP" . 41761)
                             ("YI SYLLABLE SURX" . 41762)
                             ("YI SYLLABLE SUR" . 41763)
                             ("YI SYLLABLE SYT" . 41764)
                             ("YI SYLLABLE SYX" . 41765)
                             ("YI SYLLABLE SY" . 41766)
                             ("YI SYLLABLE SYP" . 41767)
                             ("YI SYLLABLE SYRX" . 41768)
                             ("YI SYLLABLE SYR" . 41769)
                             ("YI SYLLABLE SSIT" . 41770)
                             ("YI SYLLABLE SSIX" . 41771)
                             ("YI SYLLABLE SSI" . 41772)
                             ("YI SYLLABLE SSIP" . 41773)
                             ("YI SYLLABLE SSIEX" . 41774)
                             ("YI SYLLABLE SSIE" . 41775)
                             ("YI SYLLABLE SSIEP" . 41776)
                             ("YI SYLLABLE SSAT" . 41777)
                             ("YI SYLLABLE SSAX" . 41778)
                             ("YI SYLLABLE SSA" . 41779)
                             ("YI SYLLABLE SSAP" . 41780)
                             ("YI SYLLABLE SSOT" . 41781)
                             ("YI SYLLABLE SSOX" . 41782)
                             ("YI SYLLABLE SSO" . 41783)
                             ("YI SYLLABLE SSOP" . 41784)
                             ("YI SYLLABLE SSEX" . 41785)
                             ("YI SYLLABLE SSE" . 41786)
                             ("YI SYLLABLE SSEP" . 41787)
                             ("YI SYLLABLE SSUT" . 41788)
                             ("YI SYLLABLE SSUX" . 41789)
                             ("YI SYLLABLE SSU" . 41790)
                             ("YI SYLLABLE SSUP" . 41791)
                             ("YI SYLLABLE SSYT" . 41792)
                             ("YI SYLLABLE SSYX" . 41793)
                             ("YI SYLLABLE SSY" . 41794)
                             ("YI SYLLABLE SSYP" . 41795)
                             ("YI SYLLABLE SSYRX" . 41796)
                             ("YI SYLLABLE SSYR" . 41797)
                             ("YI SYLLABLE ZHAT" . 41798)
                             ("YI SYLLABLE ZHAX" . 41799)
                             ("YI SYLLABLE ZHA" . 41800)
                             ("YI SYLLABLE ZHAP" . 41801)
                             ("YI SYLLABLE ZHUOX" . 41802)
                             ("YI SYLLABLE ZHUO" . 41803)
                             ("YI SYLLABLE ZHUOP" . 41804)
                             ("YI SYLLABLE ZHOT" . 41805)
                             ("YI SYLLABLE ZHOX" . 41806)
                             ("YI SYLLABLE ZHO" . 41807)
                             ("YI SYLLABLE ZHOP" . 41808)
                             ("YI SYLLABLE ZHET" . 41809)
                             ("YI SYLLABLE ZHEX" . 41810)
                             ("YI SYLLABLE ZHE" . 41811)
                             ("YI SYLLABLE ZHEP" . 41812)
                             ("YI SYLLABLE ZHUT" . 41813)
                             ("YI SYLLABLE ZHUX" . 41814)
                             ("YI SYLLABLE ZHU" . 41815)
                             ("YI SYLLABLE ZHUP" . 41816)
                             ("YI SYLLABLE ZHURX" . 41817)
                             ("YI SYLLABLE ZHUR" . 41818)
                             ("YI SYLLABLE ZHYT" . 41819)
                             ("YI SYLLABLE ZHYX" . 41820)
                             ("YI SYLLABLE ZHY" . 41821)
                             ("YI SYLLABLE ZHYP" . 41822)
                             ("YI SYLLABLE ZHYRX" . 41823)
                             ("YI SYLLABLE ZHYR" . 41824)
                             ("YI SYLLABLE CHAT" . 41825)
                             ("YI SYLLABLE CHAX" . 41826)
                             ("YI SYLLABLE CHA" . 41827)
                             ("YI SYLLABLE CHAP" . 41828)
                             ("YI SYLLABLE CHUOT" . 41829)
                             ("YI SYLLABLE CHUOX" . 41830)
                             ("YI SYLLABLE CHUO" . 41831)
                             ("YI SYLLABLE CHUOP" . 41832)
                             ("YI SYLLABLE CHOT" . 41833)
                             ("YI SYLLABLE CHOX" . 41834)
                             ("YI SYLLABLE CHO" . 41835)
                             ("YI SYLLABLE CHOP" . 41836)
                             ("YI SYLLABLE CHET" . 41837)
                             ("YI SYLLABLE CHEX" . 41838)
                             ("YI SYLLABLE CHE" . 41839)
                             ("YI SYLLABLE CHEP" . 41840)
                             ("YI SYLLABLE CHUX" . 41841)
                             ("YI SYLLABLE CHU" . 41842)
                             ("YI SYLLABLE CHUP" . 41843)
                             ("YI SYLLABLE CHURX" . 41844)
                             ("YI SYLLABLE CHUR" . 41845)
                             ("YI SYLLABLE CHYT" . 41846)
                             ("YI SYLLABLE CHYX" . 41847)
                             ("YI SYLLABLE CHY" . 41848)
                             ("YI SYLLABLE CHYP" . 41849)
                             ("YI SYLLABLE CHYRX" . 41850)
                             ("YI SYLLABLE CHYR" . 41851)
                             ("YI SYLLABLE RRAX" . 41852)
                             ("YI SYLLABLE RRA" . 41853)
                             ("YI SYLLABLE RRUOX" . 41854)
                             ("YI SYLLABLE RRUO" . 41855)
                             ("YI SYLLABLE RROT" . 41856)
                             ("YI SYLLABLE RROX" . 41857)
                             ("YI SYLLABLE RRO" . 41858)
                             ("YI SYLLABLE RROP" . 41859)
                             ("YI SYLLABLE RRET" . 41860)
                             ("YI SYLLABLE RREX" . 41861)
                             ("YI SYLLABLE RRE" . 41862)
                             ("YI SYLLABLE RREP" . 41863)
                             ("YI SYLLABLE RRUT" . 41864)
                             ("YI SYLLABLE RRUX" . 41865)
                             ("YI SYLLABLE RRU" . 41866)
                             ("YI SYLLABLE RRUP" . 41867)
                             ("YI SYLLABLE RRURX" . 41868)
                             ("YI SYLLABLE RRUR" . 41869)
                             ("YI SYLLABLE RRYT" . 41870)
                             ("YI SYLLABLE RRYX" . 41871)
                             ("YI SYLLABLE RRY" . 41872)
                             ("YI SYLLABLE RRYP" . 41873)
                             ("YI SYLLABLE RRYRX" . 41874)
                             ("YI SYLLABLE RRYR" . 41875)
                             ("YI SYLLABLE NRAT" . 41876)
                             ("YI SYLLABLE NRAX" . 41877)
                             ("YI SYLLABLE NRA" . 41878)
                             ("YI SYLLABLE NRAP" . 41879)
                             ("YI SYLLABLE NROX" . 41880)
                             ("YI SYLLABLE NRO" . 41881)
                             ("YI SYLLABLE NROP" . 41882)
                             ("YI SYLLABLE NRET" . 41883)
                             ("YI SYLLABLE NREX" . 41884)
                             ("YI SYLLABLE NRE" . 41885)
                             ("YI SYLLABLE NREP" . 41886)
                             ("YI SYLLABLE NRUT" . 41887)
                             ("YI SYLLABLE NRUX" . 41888)
                             ("YI SYLLABLE NRU" . 41889)
                             ("YI SYLLABLE NRUP" . 41890)
                             ("YI SYLLABLE NRURX" . 41891)
                             ("YI SYLLABLE NRUR" . 41892)
                             ("YI SYLLABLE NRYT" . 41893)
                             ("YI SYLLABLE NRYX" . 41894)
                             ("YI SYLLABLE NRY" . 41895)
                             ("YI SYLLABLE NRYP" . 41896)
                             ("YI SYLLABLE NRYRX" . 41897)
                             ("YI SYLLABLE NRYR" . 41898)
                             ("YI SYLLABLE SHAT" . 41899)
                             ("YI SYLLABLE SHAX" . 41900)
                             ("YI SYLLABLE SHA" . 41901)
                             ("YI SYLLABLE SHAP" . 41902)
                             ("YI SYLLABLE SHUOX" . 41903)
                             ("YI SYLLABLE SHUO" . 41904)
                             ("YI SYLLABLE SHUOP" . 41905)
                             ("YI SYLLABLE SHOT" . 41906)
                             ("YI SYLLABLE SHOX" . 41907)
                             ("YI SYLLABLE SHO" . 41908)
                             ("YI SYLLABLE SHOP" . 41909)
                             ("YI SYLLABLE SHET" . 41910)
                             ("YI SYLLABLE SHEX" . 41911)
                             ("YI SYLLABLE SHE" . 41912)
                             ("YI SYLLABLE SHEP" . 41913)
                             ("YI SYLLABLE SHUT" . 41914)
                             ("YI SYLLABLE SHUX" . 41915)
                             ("YI SYLLABLE SHU" . 41916)
                             ("YI SYLLABLE SHUP" . 41917)
                             ("YI SYLLABLE SHURX" . 41918)
                             ("YI SYLLABLE SHUR" . 41919)
                             ("YI SYLLABLE SHYT" . 41920)
                             ("YI SYLLABLE SHYX" . 41921)
                             ("YI SYLLABLE SHY" . 41922)
                             ("YI SYLLABLE SHYP" . 41923)
                             ("YI SYLLABLE SHYRX" . 41924)
                             ("YI SYLLABLE SHYR" . 41925)
                             ("YI SYLLABLE RAT" . 41926)
                             ("YI SYLLABLE RAX" . 41927)
                             ("YI SYLLABLE RA" . 41928)
                             ("YI SYLLABLE RAP" . 41929)
                             ("YI SYLLABLE RUOX" . 41930)
                             ("YI SYLLABLE RUO" . 41931)
                             ("YI SYLLABLE RUOP" . 41932)
                             ("YI SYLLABLE ROT" . 41933)
                             ("YI SYLLABLE ROX" . 41934)
                             ("YI SYLLABLE RO" . 41935)
                             ("YI SYLLABLE ROP" . 41936)
                             ("YI SYLLABLE REX" . 41937)
                             ("YI SYLLABLE RE" . 41938)
                             ("YI SYLLABLE REP" . 41939)
                             ("YI SYLLABLE RUT" . 41940)
                             ("YI SYLLABLE RUX" . 41941)
                             ("YI SYLLABLE RU" . 41942)
                             ("YI SYLLABLE RUP" . 41943)
                             ("YI SYLLABLE RURX" . 41944)
                             ("YI SYLLABLE RUR" . 41945)
                             ("YI SYLLABLE RYT" . 41946)
                             ("YI SYLLABLE RYX" . 41947)
                             ("YI SYLLABLE RY" . 41948)
                             ("YI SYLLABLE RYP" . 41949)
                             ("YI SYLLABLE RYRX" . 41950)
                             ("YI SYLLABLE RYR" . 41951)
                             ("YI SYLLABLE JIT" . 41952)
                             ("YI SYLLABLE JIX" . 41953)
                             ("YI SYLLABLE JI" . 41954)
                             ("YI SYLLABLE JIP" . 41955)
                             ("YI SYLLABLE JIET" . 41956)
                             ("YI SYLLABLE JIEX" . 41957)
                             ("YI SYLLABLE JIE" . 41958)
                             ("YI SYLLABLE JIEP" . 41959)
                             ("YI SYLLABLE JUOT" . 41960)
                             ("YI SYLLABLE JUOX" . 41961)
                             ("YI SYLLABLE JUO" . 41962)
                             ("YI SYLLABLE JUOP" . 41963)
                             ("YI SYLLABLE JOT" . 41964)
                             ("YI SYLLABLE JOX" . 41965)
                             ("YI SYLLABLE JO" . 41966)
                             ("YI SYLLABLE JOP" . 41967)
                             ("YI SYLLABLE JUT" . 41968)
                             ("YI SYLLABLE JUX" . 41969)
                             ("YI SYLLABLE JU" . 41970)
                             ("YI SYLLABLE JUP" . 41971)
                             ("YI SYLLABLE JURX" . 41972)
                             ("YI SYLLABLE JUR" . 41973)
                             ("YI SYLLABLE JYT" . 41974)
                             ("YI SYLLABLE JYX" . 41975)
                             ("YI SYLLABLE JY" . 41976)
                             ("YI SYLLABLE JYP" . 41977)
                             ("YI SYLLABLE JYRX" . 41978)
                             ("YI SYLLABLE JYR" . 41979)
                             ("YI SYLLABLE QIT" . 41980)
                             ("YI SYLLABLE QIX" . 41981)
                             ("YI SYLLABLE QI" . 41982)
                             ("YI SYLLABLE QIP" . 41983)
                             ("YI SYLLABLE QIET" . 41984)
                             ("YI SYLLABLE QIEX" . 41985)
                             ("YI SYLLABLE QIE" . 41986)
                             ("YI SYLLABLE QIEP" . 41987)
                             ("YI SYLLABLE QUOT" . 41988)
                             ("YI SYLLABLE QUOX" . 41989)
                             ("YI SYLLABLE QUO" . 41990)
                             ("YI SYLLABLE QUOP" . 41991)
                             ("YI SYLLABLE QOT" . 41992)
                             ("YI SYLLABLE QOX" . 41993)
                             ("YI SYLLABLE QO" . 41994)
                             ("YI SYLLABLE QOP" . 41995)
                             ("YI SYLLABLE QUT" . 41996)
                             ("YI SYLLABLE QUX" . 41997)
                             ("YI SYLLABLE QU" . 41998)
                             ("YI SYLLABLE QUP" . 41999)
                             ("YI SYLLABLE QURX" . 42000)
                             ("YI SYLLABLE QUR" . 42001)
                             ("YI SYLLABLE QYT" . 42002)
                             ("YI SYLLABLE QYX" . 42003)
                             ("YI SYLLABLE QY" . 42004)
                             ("YI SYLLABLE QYP" . 42005)
                             ("YI SYLLABLE QYRX" . 42006)
                             ("YI SYLLABLE QYR" . 42007)
                             ("YI SYLLABLE JJIT" . 42008)
                             ("YI SYLLABLE JJIX" . 42009)
                             ("YI SYLLABLE JJI" . 42010)
                             ("YI SYLLABLE JJIP" . 42011)
                             ("YI SYLLABLE JJIET" . 42012)
                             ("YI SYLLABLE JJIEX" . 42013)
                             ("YI SYLLABLE JJIE" . 42014)
                             ("YI SYLLABLE JJIEP" . 42015)
                             ("YI SYLLABLE JJUOX" . 42016)
                             ("YI SYLLABLE JJUO" . 42017)
                             ("YI SYLLABLE JJUOP" . 42018)
                             ("YI SYLLABLE JJOT" . 42019)
                             ("YI SYLLABLE JJOX" . 42020)
                             ("YI SYLLABLE JJO" . 42021)
                             ("YI SYLLABLE JJOP" . 42022)
                             ("YI SYLLABLE JJUT" . 42023)
                             ("YI SYLLABLE JJUX" . 42024)
                             ("YI SYLLABLE JJU" . 42025)
                             ("YI SYLLABLE JJUP" . 42026)
                             ("YI SYLLABLE JJURX" . 42027)
                             ("YI SYLLABLE JJUR" . 42028)
                             ("YI SYLLABLE JJYT" . 42029)
                             ("YI SYLLABLE JJYX" . 42030)
                             ("YI SYLLABLE JJY" . 42031)
                             ("YI SYLLABLE JJYP" . 42032)
                             ("YI SYLLABLE NJIT" . 42033)
                             ("YI SYLLABLE NJIX" . 42034)
                             ("YI SYLLABLE NJI" . 42035)
                             ("YI SYLLABLE NJIP" . 42036)
                             ("YI SYLLABLE NJIET" . 42037)
                             ("YI SYLLABLE NJIEX" . 42038)
                             ("YI SYLLABLE NJIE" . 42039)
                             ("YI SYLLABLE NJIEP" . 42040)
                             ("YI SYLLABLE NJUOX" . 42041)
                             ("YI SYLLABLE NJUO" . 42042)
                             ("YI SYLLABLE NJOT" . 42043)
                             ("YI SYLLABLE NJOX" . 42044)
                             ("YI SYLLABLE NJO" . 42045)
                             ("YI SYLLABLE NJOP" . 42046)
                             ("YI SYLLABLE NJUX" . 42047)
                             ("YI SYLLABLE NJU" . 42048)
                             ("YI SYLLABLE NJUP" . 42049)
                             ("YI SYLLABLE NJURX" . 42050)
                             ("YI SYLLABLE NJUR" . 42051)
                             ("YI SYLLABLE NJYT" . 42052)
                             ("YI SYLLABLE NJYX" . 42053)
                             ("YI SYLLABLE NJY" . 42054)
                             ("YI SYLLABLE NJYP" . 42055)
                             ("YI SYLLABLE NJYRX" . 42056)
                             ("YI SYLLABLE NJYR" . 42057)
                             ("YI SYLLABLE NYIT" . 42058)
                             ("YI SYLLABLE NYIX" . 42059)
                             ("YI SYLLABLE NYI" . 42060)
                             ("YI SYLLABLE NYIP" . 42061)
                             ("YI SYLLABLE NYIET" . 42062)
                             ("YI SYLLABLE NYIEX" . 42063)
                             ("YI SYLLABLE NYIE" . 42064)
                             ("YI SYLLABLE NYIEP" . 42065)
                             ("YI SYLLABLE NYUOX" . 42066)
                             ("YI SYLLABLE NYUO" . 42067)
                             ("YI SYLLABLE NYUOP" . 42068)
                             ("YI SYLLABLE NYOT" . 42069)
                             ("YI SYLLABLE NYOX" . 42070)
                             ("YI SYLLABLE NYO" . 42071)
                             ("YI SYLLABLE NYOP" . 42072)
                             ("YI SYLLABLE NYUT" . 42073)
                             ("YI SYLLABLE NYUX" . 42074)
                             ("YI SYLLABLE NYU" . 42075)
                             ("YI SYLLABLE NYUP" . 42076)
                             ("YI SYLLABLE XIT" . 42077)
                             ("YI SYLLABLE XIX" . 42078)
                             ("YI SYLLABLE XI" . 42079)
                             ("YI SYLLABLE XIP" . 42080)
                             ("YI SYLLABLE XIET" . 42081)
                             ("YI SYLLABLE XIEX" . 42082)
                             ("YI SYLLABLE XIE" . 42083)
                             ("YI SYLLABLE XIEP" . 42084)
                             ("YI SYLLABLE XUOX" . 42085)
                             ("YI SYLLABLE XUO" . 42086)
                             ("YI SYLLABLE XOT" . 42087)
                             ("YI SYLLABLE XOX" . 42088)
                             ("YI SYLLABLE XO" . 42089)
                             ("YI SYLLABLE XOP" . 42090)
                             ("YI SYLLABLE XYT" . 42091)
                             ("YI SYLLABLE XYX" . 42092)
                             ("YI SYLLABLE XY" . 42093)
                             ("YI SYLLABLE XYP" . 42094)
                             ("YI SYLLABLE XYRX" . 42095)
                             ("YI SYLLABLE XYR" . 42096)
                             ("YI SYLLABLE YIT" . 42097)
                             ("YI SYLLABLE YIX" . 42098)
                             ("YI SYLLABLE YI" . 42099)
                             ("YI SYLLABLE YIP" . 42100)
                             ("YI SYLLABLE YIET" . 42101)
                             ("YI SYLLABLE YIEX" . 42102)
                             ("YI SYLLABLE YIE" . 42103)
                             ("YI SYLLABLE YIEP" . 42104)
                             ("YI SYLLABLE YUOT" . 42105)
                             ("YI SYLLABLE YUOX" . 42106)
                             ("YI SYLLABLE YUO" . 42107)
                             ("YI SYLLABLE YUOP" . 42108)
                             ("YI SYLLABLE YOT" . 42109)
                             ("YI SYLLABLE YOX" . 42110)
                             ("YI SYLLABLE YO" . 42111)
                             ("YI SYLLABLE YOP" . 42112)
                             ("YI SYLLABLE YUT" . 42113)
                             ("YI SYLLABLE YUX" . 42114)
                             ("YI SYLLABLE YU" . 42115)
                             ("YI SYLLABLE YUP" . 42116)
                             ("YI SYLLABLE YURX" . 42117)
                             ("YI SYLLABLE YUR" . 42118)
                             ("YI SYLLABLE YYT" . 42119)
                             ("YI SYLLABLE YYX" . 42120)
                             ("YI SYLLABLE YY" . 42121)
                             ("YI SYLLABLE YYP" . 42122)
                             ("YI SYLLABLE YYRX" . 42123)
                             ("YI SYLLABLE YYR" . 42124)
                             ("YI RADICAL QOT" . 42128)
                             ("YI RADICAL LI" . 42129)
                             ("YI RADICAL KIT" . 42130)
                             ("YI RADICAL NYIP" . 42131)
                             ("YI RADICAL CYP" . 42132)
                             ("YI RADICAL SSI" . 42133)
                             ("YI RADICAL GGOP" . 42134)
                             ("YI RADICAL GEP" . 42135)
                             ("YI RADICAL MI" . 42136)
                             ("YI RADICAL HXIT" . 42137)
                             ("YI RADICAL LYR" . 42138)
                             ("YI RADICAL BBUT" . 42139)
                             ("YI RADICAL MOP" . 42140)
                             ("YI RADICAL YO" . 42141)
                             ("YI RADICAL PUT" . 42142)
                             ("YI RADICAL HXUO" . 42143)
                             ("YI RADICAL TAT" . 42144)
                             ("YI RADICAL GA" . 42145)
                             ("YI RADICAL ZUP" . 42146)
                             ("YI RADICAL CYT" . 42147)
                             ("YI RADICAL DDUR" . 42148)
                             ("YI RADICAL BUR" . 42149)
                             ("YI RADICAL GGUO" . 42150)
                             ("YI RADICAL NYOP" . 42151)
                             ("YI RADICAL TU" . 42152)
                             ("YI RADICAL OP" . 42153)
                             ("YI RADICAL JJUT" . 42154)
                             ("YI RADICAL ZOT" . 42155)
                             ("YI RADICAL PYT" . 42156)
                             ("YI RADICAL HMO" . 42157)
                             ("YI RADICAL YIT" . 42158)
                             ("YI RADICAL VUR" . 42159)
                             ("YI RADICAL SHY" . 42160)
                             ("YI RADICAL VEP" . 42161)
                             ("YI RADICAL ZA" . 42162)
                             ("YI RADICAL JO" . 42163)
                             ("YI RADICAL NZUP" . 42164)
                             ("YI RADICAL JJY" . 42165)
                             ("YI RADICAL GOT" . 42166)
                             ("YI RADICAL JJIE" . 42167)
                             ("YI RADICAL WO" . 42168)
                             ("YI RADICAL DU" . 42169)
                             ("YI RADICAL SHUR" . 42170)
                             ("YI RADICAL LIE" . 42171)
                             ("YI RADICAL CY" . 42172)
                             ("YI RADICAL CUOP" . 42173)
                             ("YI RADICAL CIP" . 42174)
                             ("YI RADICAL HXOP" . 42175)
                             ("YI RADICAL SHAT" . 42176)
                             ("YI RADICAL ZUR" . 42177)
                             ("YI RADICAL SHOP" . 42178)
                             ("YI RADICAL CHE" . 42179)
                             ("YI RADICAL ZZIET" . 42180)
                             ("YI RADICAL NBIE" . 42181)
                             ("YI RADICAL KE" . 42182)
                             ("CJK COMPATIBILITY IDEOGRAPH-F900" . 63744)
                             ("CJK COMPATIBILITY IDEOGRAPH-F901" . 63745)
                             ("CJK COMPATIBILITY IDEOGRAPH-F902" . 63746)
                             ("CJK COMPATIBILITY IDEOGRAPH-F903" . 63747)
                             ("CJK COMPATIBILITY IDEOGRAPH-F904" . 63748)
                             ("CJK COMPATIBILITY IDEOGRAPH-F905" . 63749)
                             ("CJK COMPATIBILITY IDEOGRAPH-F906" . 63750)
                             ("CJK COMPATIBILITY IDEOGRAPH-F907" . 63751)
                             ("CJK COMPATIBILITY IDEOGRAPH-F908" . 63752)
                             ("CJK COMPATIBILITY IDEOGRAPH-F909" . 63753)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90A" . 63754)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90B" . 63755)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90C" . 63756)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90D" . 63757)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90E" . 63758)
                             ("CJK COMPATIBILITY IDEOGRAPH-F90F" . 63759)
                             ("CJK COMPATIBILITY IDEOGRAPH-F910" . 63760)
                             ("CJK COMPATIBILITY IDEOGRAPH-F911" . 63761)
                             ("CJK COMPATIBILITY IDEOGRAPH-F912" . 63762)
                             ("CJK COMPATIBILITY IDEOGRAPH-F913" . 63763)
                             ("CJK COMPATIBILITY IDEOGRAPH-F914" . 63764)
                             ("CJK COMPATIBILITY IDEOGRAPH-F915" . 63765)
                             ("CJK COMPATIBILITY IDEOGRAPH-F916" . 63766)
                             ("CJK COMPATIBILITY IDEOGRAPH-F917" . 63767)
                             ("CJK COMPATIBILITY IDEOGRAPH-F918" . 63768)
                             ("CJK COMPATIBILITY IDEOGRAPH-F919" . 63769)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91A" . 63770)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91B" . 63771)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91C" . 63772)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91D" . 63773)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91E" . 63774)
                             ("CJK COMPATIBILITY IDEOGRAPH-F91F" . 63775)
                             ("CJK COMPATIBILITY IDEOGRAPH-F920" . 63776)
                             ("CJK COMPATIBILITY IDEOGRAPH-F921" . 63777)
                             ("CJK COMPATIBILITY IDEOGRAPH-F922" . 63778)
                             ("CJK COMPATIBILITY IDEOGRAPH-F923" . 63779)
                             ("CJK COMPATIBILITY IDEOGRAPH-F924" . 63780)
                             ("CJK COMPATIBILITY IDEOGRAPH-F925" . 63781)
                             ("CJK COMPATIBILITY IDEOGRAPH-F926" . 63782)
                             ("CJK COMPATIBILITY IDEOGRAPH-F927" . 63783)
                             ("CJK COMPATIBILITY IDEOGRAPH-F928" . 63784)
                             ("CJK COMPATIBILITY IDEOGRAPH-F929" . 63785)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92A" . 63786)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92B" . 63787)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92C" . 63788)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92D" . 63789)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92E" . 63790)
                             ("CJK COMPATIBILITY IDEOGRAPH-F92F" . 63791)
                             ("CJK COMPATIBILITY IDEOGRAPH-F930" . 63792)
                             ("CJK COMPATIBILITY IDEOGRAPH-F931" . 63793)
                             ("CJK COMPATIBILITY IDEOGRAPH-F932" . 63794)
                             ("CJK COMPATIBILITY IDEOGRAPH-F933" . 63795)
                             ("CJK COMPATIBILITY IDEOGRAPH-F934" . 63796)
                             ("CJK COMPATIBILITY IDEOGRAPH-F935" . 63797)
                             ("CJK COMPATIBILITY IDEOGRAPH-F936" . 63798)
                             ("CJK COMPATIBILITY IDEOGRAPH-F937" . 63799)
                             ("CJK COMPATIBILITY IDEOGRAPH-F938" . 63800)
                             ("CJK COMPATIBILITY IDEOGRAPH-F939" . 63801)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93A" . 63802)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93B" . 63803)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93C" . 63804)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93D" . 63805)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93E" . 63806)
                             ("CJK COMPATIBILITY IDEOGRAPH-F93F" . 63807)
                             ("CJK COMPATIBILITY IDEOGRAPH-F940" . 63808)
                             ("CJK COMPATIBILITY IDEOGRAPH-F941" . 63809)
                             ("CJK COMPATIBILITY IDEOGRAPH-F942" . 63810)
                             ("CJK COMPATIBILITY IDEOGRAPH-F943" . 63811)
                             ("CJK COMPATIBILITY IDEOGRAPH-F944" . 63812)
                             ("CJK COMPATIBILITY IDEOGRAPH-F945" . 63813)
                             ("CJK COMPATIBILITY IDEOGRAPH-F946" . 63814)
                             ("CJK COMPATIBILITY IDEOGRAPH-F947" . 63815)
                             ("CJK COMPATIBILITY IDEOGRAPH-F948" . 63816)
                             ("CJK COMPATIBILITY IDEOGRAPH-F949" . 63817)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94A" . 63818)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94B" . 63819)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94C" . 63820)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94D" . 63821)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94E" . 63822)
                             ("CJK COMPATIBILITY IDEOGRAPH-F94F" . 63823)
                             ("CJK COMPATIBILITY IDEOGRAPH-F950" . 63824)
                             ("CJK COMPATIBILITY IDEOGRAPH-F951" . 63825)
                             ("CJK COMPATIBILITY IDEOGRAPH-F952" . 63826)
                             ("CJK COMPATIBILITY IDEOGRAPH-F953" . 63827)
                             ("CJK COMPATIBILITY IDEOGRAPH-F954" . 63828)
                             ("CJK COMPATIBILITY IDEOGRAPH-F955" . 63829)
                             ("CJK COMPATIBILITY IDEOGRAPH-F956" . 63830)
                             ("CJK COMPATIBILITY IDEOGRAPH-F957" . 63831)
                             ("CJK COMPATIBILITY IDEOGRAPH-F958" . 63832)
                             ("CJK COMPATIBILITY IDEOGRAPH-F959" . 63833)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95A" . 63834)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95B" . 63835)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95C" . 63836)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95D" . 63837)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95E" . 63838)
                             ("CJK COMPATIBILITY IDEOGRAPH-F95F" . 63839)
                             ("CJK COMPATIBILITY IDEOGRAPH-F960" . 63840)
                             ("CJK COMPATIBILITY IDEOGRAPH-F961" . 63841)
                             ("CJK COMPATIBILITY IDEOGRAPH-F962" . 63842)
                             ("CJK COMPATIBILITY IDEOGRAPH-F963" . 63843)
                             ("CJK COMPATIBILITY IDEOGRAPH-F964" . 63844)
                             ("CJK COMPATIBILITY IDEOGRAPH-F965" . 63845)
                             ("CJK COMPATIBILITY IDEOGRAPH-F966" . 63846)
                             ("CJK COMPATIBILITY IDEOGRAPH-F967" . 63847)
                             ("CJK COMPATIBILITY IDEOGRAPH-F968" . 63848)
                             ("CJK COMPATIBILITY IDEOGRAPH-F969" . 63849)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96A" . 63850)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96B" . 63851)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96C" . 63852)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96D" . 63853)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96E" . 63854)
                             ("CJK COMPATIBILITY IDEOGRAPH-F96F" . 63855)
                             ("CJK COMPATIBILITY IDEOGRAPH-F970" . 63856)
                             ("CJK COMPATIBILITY IDEOGRAPH-F971" . 63857)
                             ("CJK COMPATIBILITY IDEOGRAPH-F972" . 63858)
                             ("CJK COMPATIBILITY IDEOGRAPH-F973" . 63859)
                             ("CJK COMPATIBILITY IDEOGRAPH-F974" . 63860)
                             ("CJK COMPATIBILITY IDEOGRAPH-F975" . 63861)
                             ("CJK COMPATIBILITY IDEOGRAPH-F976" . 63862)
                             ("CJK COMPATIBILITY IDEOGRAPH-F977" . 63863)
                             ("CJK COMPATIBILITY IDEOGRAPH-F978" . 63864)
                             ("CJK COMPATIBILITY IDEOGRAPH-F979" . 63865)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97A" . 63866)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97B" . 63867)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97C" . 63868)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97D" . 63869)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97E" . 63870)
                             ("CJK COMPATIBILITY IDEOGRAPH-F97F" . 63871)
                             ("CJK COMPATIBILITY IDEOGRAPH-F980" . 63872)
                             ("CJK COMPATIBILITY IDEOGRAPH-F981" . 63873)
                             ("CJK COMPATIBILITY IDEOGRAPH-F982" . 63874)
                             ("CJK COMPATIBILITY IDEOGRAPH-F983" . 63875)
                             ("CJK COMPATIBILITY IDEOGRAPH-F984" . 63876)
                             ("CJK COMPATIBILITY IDEOGRAPH-F985" . 63877)
                             ("CJK COMPATIBILITY IDEOGRAPH-F986" . 63878)
                             ("CJK COMPATIBILITY IDEOGRAPH-F987" . 63879)
                             ("CJK COMPATIBILITY IDEOGRAPH-F988" . 63880)
                             ("CJK COMPATIBILITY IDEOGRAPH-F989" . 63881)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98A" . 63882)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98B" . 63883)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98C" . 63884)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98D" . 63885)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98E" . 63886)
                             ("CJK COMPATIBILITY IDEOGRAPH-F98F" . 63887)
                             ("CJK COMPATIBILITY IDEOGRAPH-F990" . 63888)
                             ("CJK COMPATIBILITY IDEOGRAPH-F991" . 63889)
                             ("CJK COMPATIBILITY IDEOGRAPH-F992" . 63890)
                             ("CJK COMPATIBILITY IDEOGRAPH-F993" . 63891)
                             ("CJK COMPATIBILITY IDEOGRAPH-F994" . 63892)
                             ("CJK COMPATIBILITY IDEOGRAPH-F995" . 63893)
                             ("CJK COMPATIBILITY IDEOGRAPH-F996" . 63894)
                             ("CJK COMPATIBILITY IDEOGRAPH-F997" . 63895)
                             ("CJK COMPATIBILITY IDEOGRAPH-F998" . 63896)
                             ("CJK COMPATIBILITY IDEOGRAPH-F999" . 63897)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99A" . 63898)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99B" . 63899)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99C" . 63900)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99D" . 63901)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99E" . 63902)
                             ("CJK COMPATIBILITY IDEOGRAPH-F99F" . 63903)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A0" . 63904)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A1" . 63905)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A2" . 63906)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A3" . 63907)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A4" . 63908)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A5" . 63909)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A6" . 63910)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A7" . 63911)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A8" . 63912)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9A9" . 63913)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AA" . 63914)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AB" . 63915)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AC" . 63916)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AD" . 63917)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AE" . 63918)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9AF" . 63919)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B0" . 63920)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B1" . 63921)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B2" . 63922)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B3" . 63923)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B4" . 63924)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B5" . 63925)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B6" . 63926)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B7" . 63927)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B8" . 63928)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9B9" . 63929)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BA" . 63930)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BB" . 63931)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BC" . 63932)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BD" . 63933)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BE" . 63934)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9BF" . 63935)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C0" . 63936)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C1" . 63937)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C2" . 63938)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C3" . 63939)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C4" . 63940)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C5" . 63941)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C6" . 63942)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C7" . 63943)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C8" . 63944)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9C9" . 63945)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CA" . 63946)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CB" . 63947)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CC" . 63948)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CD" . 63949)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CE" . 63950)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9CF" . 63951)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D0" . 63952)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D1" . 63953)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D2" . 63954)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D3" . 63955)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D4" . 63956)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D5" . 63957)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D6" . 63958)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D7" . 63959)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D8" . 63960)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9D9" . 63961)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DA" . 63962)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DB" . 63963)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DC" . 63964)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DD" . 63965)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DE" . 63966)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9DF" . 63967)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E0" . 63968)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E1" . 63969)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E2" . 63970)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E3" . 63971)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E4" . 63972)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E5" . 63973)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E6" . 63974)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E7" . 63975)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E8" . 63976)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9E9" . 63977)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9EA" . 63978)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9EB" . 63979)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9EC" . 63980)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9ED" . 63981)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9EE" . 63982)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9EF" . 63983)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F0" . 63984)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F1" . 63985)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F2" . 63986)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F3" . 63987)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F4" . 63988)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F5" . 63989)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F6" . 63990)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F7" . 63991)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F8" . 63992)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9F9" . 63993)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FA" . 63994)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FB" . 63995)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FC" . 63996)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FD" . 63997)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FE" . 63998)
                             ("CJK COMPATIBILITY IDEOGRAPH-F9FF" . 63999)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA00" . 64000)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA01" . 64001)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA02" . 64002)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA03" . 64003)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA04" . 64004)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA05" . 64005)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA06" . 64006)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA07" . 64007)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA08" . 64008)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA09" . 64009)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0A" . 64010)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0B" . 64011)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0C" . 64012)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0D" . 64013)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0E" . 64014)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA0F" . 64015)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA10" . 64016)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA11" . 64017)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA12" . 64018)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA13" . 64019)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA14" . 64020)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA15" . 64021)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA16" . 64022)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA17" . 64023)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA18" . 64024)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA19" . 64025)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1A" . 64026)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1B" . 64027)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1C" . 64028)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1D" . 64029)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1E" . 64030)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA1F" . 64031)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA20" . 64032)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA21" . 64033)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA22" . 64034)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA23" . 64035)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA24" . 64036)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA25" . 64037)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA26" . 64038)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA27" . 64039)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA28" . 64040)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA29" . 64041)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA2A" . 64042)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA2B" . 64043)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA2C" . 64044)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA2D" . 64045)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA30" . 64048)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA31" . 64049)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA32" . 64050)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA33" . 64051)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA34" . 64052)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA35" . 64053)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA36" . 64054)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA37" . 64055)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA38" . 64056)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA39" . 64057)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3A" . 64058)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3B" . 64059)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3C" . 64060)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3D" . 64061)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3E" . 64062)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA3F" . 64063)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA40" . 64064)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA41" . 64065)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA42" . 64066)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA43" . 64067)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA44" . 64068)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA45" . 64069)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA46" . 64070)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA47" . 64071)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA48" . 64072)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA49" . 64073)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4A" . 64074)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4B" . 64075)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4C" . 64076)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4D" . 64077)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4E" . 64078)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA4F" . 64079)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA50" . 64080)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA51" . 64081)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA52" . 64082)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA53" . 64083)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA54" . 64084)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA55" . 64085)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA56" . 64086)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA57" . 64087)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA58" . 64088)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA59" . 64089)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5A" . 64090)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5B" . 64091)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5C" . 64092)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5D" . 64093)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5E" . 64094)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA5F" . 64095)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA60" . 64096)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA61" . 64097)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA62" . 64098)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA63" . 64099)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA64" . 64100)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA65" . 64101)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA66" . 64102)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA67" . 64103)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA68" . 64104)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA69" . 64105)
                             ("CJK COMPATIBILITY IDEOGRAPH-FA6A" . 64106)
                             ("LATIN SMALL LIGATURE FF" . 64256)
                             ("LATIN SMALL LIGATURE FI" . 64257)
                             ("LATIN SMALL LIGATURE FL" . 64258)
                             ("LATIN SMALL LIGATURE FFI" . 64259)
                             ("LATIN SMALL LIGATURE FFL" . 64260)
                             ("LATIN SMALL LIGATURE LONG S T" . 64261)
                             ("LATIN SMALL LIGATURE ST" . 64262)
                             ("ARMENIAN SMALL LIGATURE MEN NOW" . 64275)
                             ("ARMENIAN SMALL LIGATURE MEN ECH" . 64276)
                             ("ARMENIAN SMALL LIGATURE MEN INI" . 64277)
                             ("ARMENIAN SMALL LIGATURE VEW NOW" . 64278)
                             ("ARMENIAN SMALL LIGATURE MEN XEH" . 64279)
                             ("HEBREW LETTER YOD WITH HIRIQ" . 64285)
                             ("HEBREW POINT JUDEO-SPANISH VARIKA" . 64286)
                             ("HEBREW LIGATURE YIDDISH YOD YOD PATAH" . 64287)
                             ("HEBREW LETTER ALTERNATIVE AYIN" . 64288)
                             ("HEBREW LETTER WIDE ALEF" . 64289)
                             ("HEBREW LETTER WIDE DALET" . 64290)
                             ("HEBREW LETTER WIDE HE" . 64291)
                             ("HEBREW LETTER WIDE KAF" . 64292)
                             ("HEBREW LETTER WIDE LAMED" . 64293)
                             ("HEBREW LETTER WIDE FINAL MEM" . 64294)
                             ("HEBREW LETTER WIDE RESH" . 64295)
                             ("HEBREW LETTER WIDE TAV" . 64296)
                             ("HEBREW LETTER ALTERNATIVE PLUS SIGN" . 64297)
                             ("HEBREW LETTER SHIN WITH SHIN DOT" . 64298)
                             ("HEBREW LETTER SHIN WITH SIN DOT" . 64299)
                             ("HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT" . 64300)
                             ("HEBREW LETTER SHIN WITH DAGESH AND SIN DOT" . 64301)
                             ("HEBREW LETTER ALEF WITH PATAH" . 64302)
                             ("HEBREW LETTER ALEF WITH QAMATS" . 64303)
                             ("HEBREW LETTER ALEF WITH MAPIQ" . 64304)
                             ("HEBREW LETTER BET WITH DAGESH" . 64305)
                             ("HEBREW LETTER GIMEL WITH DAGESH" . 64306)
                             ("HEBREW LETTER DALET WITH DAGESH" . 64307)
                             ("HEBREW LETTER HE WITH MAPIQ" . 64308)
                             ("HEBREW LETTER VAV WITH DAGESH" . 64309)
                             ("HEBREW LETTER ZAYIN WITH DAGESH" . 64310)
                             ("HEBREW LETTER TET WITH DAGESH" . 64312)
                             ("HEBREW LETTER YOD WITH DAGESH" . 64313)
                             ("HEBREW LETTER FINAL KAF WITH DAGESH" . 64314)
                             ("HEBREW LETTER KAF WITH DAGESH" . 64315)
                             ("HEBREW LETTER LAMED WITH DAGESH" . 64316)
                             ("HEBREW LETTER MEM WITH DAGESH" . 64318)
                             ("HEBREW LETTER NUN WITH DAGESH" . 64320)
                             ("HEBREW LETTER SAMEKH WITH DAGESH" . 64321)
                             ("HEBREW LETTER FINAL PE WITH DAGESH" . 64323)
                             ("HEBREW LETTER PE WITH DAGESH" . 64324)
                             ("HEBREW LETTER TSADI WITH DAGESH" . 64326)
                             ("HEBREW LETTER QOF WITH DAGESH" . 64327)
                             ("HEBREW LETTER RESH WITH DAGESH" . 64328)
                             ("HEBREW LETTER SHIN WITH DAGESH" . 64329)
                             ("HEBREW LETTER TAV WITH DAGESH" . 64330)
                             ("HEBREW LETTER VAV WITH HOLAM" . 64331)
                             ("HEBREW LETTER BET WITH RAFE" . 64332)
                             ("HEBREW LETTER KAF WITH RAFE" . 64333)
                             ("HEBREW LETTER PE WITH RAFE" . 64334)
                             ("HEBREW LIGATURE ALEF LAMED" . 64335)
                             ("ARABIC LETTER ALEF WASLA ISOLATED FORM" . 64336)
                             ("ARABIC LETTER ALEF WASLA FINAL FORM" . 64337)
                             ("ARABIC LETTER BEEH ISOLATED FORM" . 64338)
                             ("ARABIC LETTER BEEH FINAL FORM" . 64339)
                             ("ARABIC LETTER BEEH INITIAL FORM" . 64340)
                             ("ARABIC LETTER BEEH MEDIAL FORM" . 64341)
                             ("ARABIC LETTER PEH ISOLATED FORM" . 64342)
                             ("ARABIC LETTER PEH FINAL FORM" . 64343)
                             ("ARABIC LETTER PEH INITIAL FORM" . 64344)
                             ("ARABIC LETTER PEH MEDIAL FORM" . 64345)
                             ("ARABIC LETTER BEHEH ISOLATED FORM" . 64346)
                             ("ARABIC LETTER BEHEH FINAL FORM" . 64347)
                             ("ARABIC LETTER BEHEH INITIAL FORM" . 64348)
                             ("ARABIC LETTER BEHEH MEDIAL FORM" . 64349)
                             ("ARABIC LETTER TTEHEH ISOLATED FORM" . 64350)
                             ("ARABIC LETTER TTEHEH FINAL FORM" . 64351)
                             ("ARABIC LETTER TTEHEH INITIAL FORM" . 64352)
                             ("ARABIC LETTER TTEHEH MEDIAL FORM" . 64353)
                             ("ARABIC LETTER TEHEH ISOLATED FORM" . 64354)
                             ("ARABIC LETTER TEHEH FINAL FORM" . 64355)
                             ("ARABIC LETTER TEHEH INITIAL FORM" . 64356)
                             ("ARABIC LETTER TEHEH MEDIAL FORM" . 64357)
                             ("ARABIC LETTER TTEH ISOLATED FORM" . 64358)
                             ("ARABIC LETTER TTEH FINAL FORM" . 64359)
                             ("ARABIC LETTER TTEH INITIAL FORM" . 64360)
                             ("ARABIC LETTER TTEH MEDIAL FORM" . 64361)
                             ("ARABIC LETTER VEH ISOLATED FORM" . 64362)
                             ("ARABIC LETTER VEH FINAL FORM" . 64363)
                             ("ARABIC LETTER VEH INITIAL FORM" . 64364)
                             ("ARABIC LETTER VEH MEDIAL FORM" . 64365)
                             ("ARABIC LETTER PEHEH ISOLATED FORM" . 64366)
                             ("ARABIC LETTER PEHEH FINAL FORM" . 64367)
                             ("ARABIC LETTER PEHEH INITIAL FORM" . 64368)
                             ("ARABIC LETTER PEHEH MEDIAL FORM" . 64369)
                             ("ARABIC LETTER DYEH ISOLATED FORM" . 64370)
                             ("ARABIC LETTER DYEH FINAL FORM" . 64371)
                             ("ARABIC LETTER DYEH INITIAL FORM" . 64372)
                             ("ARABIC LETTER DYEH MEDIAL FORM" . 64373)
                             ("ARABIC LETTER NYEH ISOLATED FORM" . 64374)
                             ("ARABIC LETTER NYEH FINAL FORM" . 64375)
                             ("ARABIC LETTER NYEH INITIAL FORM" . 64376)
                             ("ARABIC LETTER NYEH MEDIAL FORM" . 64377)
                             ("ARABIC LETTER TCHEH ISOLATED FORM" . 64378)
                             ("ARABIC LETTER TCHEH FINAL FORM" . 64379)
                             ("ARABIC LETTER TCHEH INITIAL FORM" . 64380)
                             ("ARABIC LETTER TCHEH MEDIAL FORM" . 64381)
                             ("ARABIC LETTER TCHEHEH ISOLATED FORM" . 64382)
                             ("ARABIC LETTER TCHEHEH FINAL FORM" . 64383)
                             ("ARABIC LETTER TCHEHEH INITIAL FORM" . 64384)
                             ("ARABIC LETTER TCHEHEH MEDIAL FORM" . 64385)
                             ("ARABIC LETTER DDAHAL ISOLATED FORM" . 64386)
                             ("ARABIC LETTER DDAHAL FINAL FORM" . 64387)
                             ("ARABIC LETTER DAHAL ISOLATED FORM" . 64388)
                             ("ARABIC LETTER DAHAL FINAL FORM" . 64389)
                             ("ARABIC LETTER DUL ISOLATED FORM" . 64390)
                             ("ARABIC LETTER DUL FINAL FORM" . 64391)
                             ("ARABIC LETTER DDAL ISOLATED FORM" . 64392)
                             ("ARABIC LETTER DDAL FINAL FORM" . 64393)
                             ("ARABIC LETTER JEH ISOLATED FORM" . 64394)
                             ("ARABIC LETTER JEH FINAL FORM" . 64395)
                             ("ARABIC LETTER RREH ISOLATED FORM" . 64396)
                             ("ARABIC LETTER RREH FINAL FORM" . 64397)
                             ("ARABIC LETTER KEHEH ISOLATED FORM" . 64398)
                             ("ARABIC LETTER KEHEH FINAL FORM" . 64399)
                             ("ARABIC LETTER KEHEH INITIAL FORM" . 64400)
                             ("ARABIC LETTER KEHEH MEDIAL FORM" . 64401)
                             ("ARABIC LETTER GAF ISOLATED FORM" . 64402)
                             ("ARABIC LETTER GAF FINAL FORM" . 64403)
                             ("ARABIC LETTER GAF INITIAL FORM" . 64404)
                             ("ARABIC LETTER GAF MEDIAL FORM" . 64405)
                             ("ARABIC LETTER GUEH ISOLATED FORM" . 64406)
                             ("ARABIC LETTER GUEH FINAL FORM" . 64407)
                             ("ARABIC LETTER GUEH INITIAL FORM" . 64408)
                             ("ARABIC LETTER GUEH MEDIAL FORM" . 64409)
                             ("ARABIC LETTER NGOEH ISOLATED FORM" . 64410)
                             ("ARABIC LETTER NGOEH FINAL FORM" . 64411)
                             ("ARABIC LETTER NGOEH INITIAL FORM" . 64412)
                             ("ARABIC LETTER NGOEH MEDIAL FORM" . 64413)
                             ("ARABIC LETTER NOON GHUNNA ISOLATED FORM" . 64414)
                             ("ARABIC LETTER NOON GHUNNA FINAL FORM" . 64415)
                             ("ARABIC LETTER RNOON ISOLATED FORM" . 64416)
                             ("ARABIC LETTER RNOON FINAL FORM" . 64417)
                             ("ARABIC LETTER RNOON INITIAL FORM" . 64418)
                             ("ARABIC LETTER RNOON MEDIAL FORM" . 64419)
                             ("ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM" . 64420)
                             ("ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM" . 64421)
                             ("ARABIC LETTER HEH GOAL ISOLATED FORM" . 64422)
                             ("ARABIC LETTER HEH GOAL FINAL FORM" . 64423)
                             ("ARABIC LETTER HEH GOAL INITIAL FORM" . 64424)
                             ("ARABIC LETTER HEH GOAL MEDIAL FORM" . 64425)
                             ("ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM" . 64426)
                             ("ARABIC LETTER HEH DOACHASHMEE FINAL FORM" . 64427)
                             ("ARABIC LETTER HEH DOACHASHMEE INITIAL FORM" . 64428)
                             ("ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM" . 64429)
                             ("ARABIC LETTER YEH BARREE ISOLATED FORM" . 64430)
                             ("ARABIC LETTER YEH BARREE FINAL FORM" . 64431)
                             ("ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM" . 64432)
                             ("ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM" . 64433)
                             ("ARABIC LETTER NG ISOLATED FORM" . 64467)
                             ("ARABIC LETTER NG FINAL FORM" . 64468)
                             ("ARABIC LETTER NG INITIAL FORM" . 64469)
                             ("ARABIC LETTER NG MEDIAL FORM" . 64470)
                             ("ARABIC LETTER U ISOLATED FORM" . 64471)
                             ("ARABIC LETTER U FINAL FORM" . 64472)
                             ("ARABIC LETTER OE ISOLATED FORM" . 64473)
                             ("ARABIC LETTER OE FINAL FORM" . 64474)
                             ("ARABIC LETTER YU ISOLATED FORM" . 64475)
                             ("ARABIC LETTER YU FINAL FORM" . 64476)
                             ("ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM" . 64477)
                             ("ARABIC LETTER VE ISOLATED FORM" . 64478)
                             ("ARABIC LETTER VE FINAL FORM" . 64479)
                             ("ARABIC LETTER KIRGHIZ OE ISOLATED FORM" . 64480)
                             ("ARABIC LETTER KIRGHIZ OE FINAL FORM" . 64481)
                             ("ARABIC LETTER KIRGHIZ YU ISOLATED FORM" . 64482)
                             ("ARABIC LETTER KIRGHIZ YU FINAL FORM" . 64483)
                             ("ARABIC LETTER E ISOLATED FORM" . 64484)
                             ("ARABIC LETTER E FINAL FORM" . 64485)
                             ("ARABIC LETTER E INITIAL FORM" . 64486)
                             ("ARABIC LETTER E MEDIAL FORM" . 64487)
                             ("ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM" . 64488)
                             ("ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM" . 64489)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM" . 64490)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM" . 64491)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM" . 64492)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM" . 64493)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM" . 64494)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM" . 64495)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM" . 64496)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM" . 64497)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM" . 64498)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM" . 64499)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM" . 64500)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM" . 64501)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM" . 64502)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM" . 64503)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM" . 64504)
                             ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM" . 64505)
                             ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM" . 64506)
                             ("ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM" . 64507)
                             ("ARABIC LETTER FARSI YEH ISOLATED FORM" . 64508)
                             ("ARABIC LETTER FARSI YEH FINAL FORM" . 64509)
                             ("ARABIC LETTER FARSI YEH INITIAL FORM" . 64510)
                             ("ARABIC LETTER FARSI YEH MEDIAL FORM" . 64511)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM" . 64512)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM" . 64513)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM" . 64514)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM" . 64515)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM" . 64516)
                             ("ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM" . 64517)
                             ("ARABIC LIGATURE BEH WITH HAH ISOLATED FORM" . 64518)
                             ("ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM" . 64519)
                             ("ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM" . 64520)
                             ("ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM" . 64521)
                             ("ARABIC LIGATURE BEH WITH YEH ISOLATED FORM" . 64522)
                             ("ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM" . 64523)
                             ("ARABIC LIGATURE TEH WITH HAH ISOLATED FORM" . 64524)
                             ("ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM" . 64525)
                             ("ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM" . 64526)
                             ("ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM" . 64527)
                             ("ARABIC LIGATURE TEH WITH YEH ISOLATED FORM" . 64528)
                             ("ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM" . 64529)
                             ("ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM" . 64530)
                             ("ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM" . 64531)
                             ("ARABIC LIGATURE THEH WITH YEH ISOLATED FORM" . 64532)
                             ("ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM" . 64533)
                             ("ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM" . 64534)
                             ("ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM" . 64535)
                             ("ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM" . 64536)
                             ("ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM" . 64537)
                             ("ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM" . 64538)
                             ("ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM" . 64539)
                             ("ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM" . 64540)
                             ("ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM" . 64541)
                             ("ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM" . 64542)
                             ("ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM" . 64543)
                             ("ARABIC LIGATURE SAD WITH HAH ISOLATED FORM" . 64544)
                             ("ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM" . 64545)
                             ("ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM" . 64546)
                             ("ARABIC LIGATURE DAD WITH HAH ISOLATED FORM" . 64547)
                             ("ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM" . 64548)
                             ("ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM" . 64549)
                             ("ARABIC LIGATURE TAH WITH HAH ISOLATED FORM" . 64550)
                             ("ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM" . 64551)
                             ("ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM" . 64552)
                             ("ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM" . 64553)
                             ("ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM" . 64554)
                             ("ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM" . 64555)
                             ("ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM" . 64556)
                             ("ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM" . 64557)
                             ("ARABIC LIGATURE FEH WITH HAH ISOLATED FORM" . 64558)
                             ("ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM" . 64559)
                             ("ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM" . 64560)
                             ("ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM" . 64561)
                             ("ARABIC LIGATURE FEH WITH YEH ISOLATED FORM" . 64562)
                             ("ARABIC LIGATURE QAF WITH HAH ISOLATED FORM" . 64563)
                             ("ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM" . 64564)
                             ("ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM" . 64565)
                             ("ARABIC LIGATURE QAF WITH YEH ISOLATED FORM" . 64566)
                             ("ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM" . 64567)
                             ("ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM" . 64568)
                             ("ARABIC LIGATURE KAF WITH HAH ISOLATED FORM" . 64569)
                             ("ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM" . 64570)
                             ("ARABIC LIGATURE KAF WITH LAM ISOLATED FORM" . 64571)
                             ("ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM" . 64572)
                             ("ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM" . 64573)
                             ("ARABIC LIGATURE KAF WITH YEH ISOLATED FORM" . 64574)
                             ("ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM" . 64575)
                             ("ARABIC LIGATURE LAM WITH HAH ISOLATED FORM" . 64576)
                             ("ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM" . 64577)
                             ("ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM" . 64578)
                             ("ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM" . 64579)
                             ("ARABIC LIGATURE LAM WITH YEH ISOLATED FORM" . 64580)
                             ("ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM" . 64581)
                             ("ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM" . 64582)
                             ("ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM" . 64583)
                             ("ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM" . 64584)
                             ("ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM" . 64585)
                             ("ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM" . 64586)
                             ("ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM" . 64587)
                             ("ARABIC LIGATURE NOON WITH HAH ISOLATED FORM" . 64588)
                             ("ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM" . 64589)
                             ("ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM" . 64590)
                             ("ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM" . 64591)
                             ("ARABIC LIGATURE NOON WITH YEH ISOLATED FORM" . 64592)
                             ("ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM" . 64593)
                             ("ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM" . 64594)
                             ("ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM" . 64595)
                             ("ARABIC LIGATURE HEH WITH YEH ISOLATED FORM" . 64596)
                             ("ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM" . 64597)
                             ("ARABIC LIGATURE YEH WITH HAH ISOLATED FORM" . 64598)
                             ("ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM" . 64599)
                             ("ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM" . 64600)
                             ("ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM" . 64601)
                             ("ARABIC LIGATURE YEH WITH YEH ISOLATED FORM" . 64602)
                             ("ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM" . 64603)
                             ("ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM" . 64604)
                             ("ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM" . 64605)
                             ("ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM" . 64606)
                             ("ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM" . 64607)
                             ("ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM" . 64608)
                             ("ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM" . 64609)
                             ("ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM" . 64610)
                             ("ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM" . 64611)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM" . 64612)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM" . 64613)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM" . 64614)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM" . 64615)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM" . 64616)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM" . 64617)
                             ("ARABIC LIGATURE BEH WITH REH FINAL FORM" . 64618)
                             ("ARABIC LIGATURE BEH WITH ZAIN FINAL FORM" . 64619)
                             ("ARABIC LIGATURE BEH WITH MEEM FINAL FORM" . 64620)
                             ("ARABIC LIGATURE BEH WITH NOON FINAL FORM" . 64621)
                             ("ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM" . 64622)
                             ("ARABIC LIGATURE BEH WITH YEH FINAL FORM" . 64623)
                             ("ARABIC LIGATURE TEH WITH REH FINAL FORM" . 64624)
                             ("ARABIC LIGATURE TEH WITH ZAIN FINAL FORM" . 64625)
                             ("ARABIC LIGATURE TEH WITH MEEM FINAL FORM" . 64626)
                             ("ARABIC LIGATURE TEH WITH NOON FINAL FORM" . 64627)
                             ("ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM" . 64628)
                             ("ARABIC LIGATURE TEH WITH YEH FINAL FORM" . 64629)
                             ("ARABIC LIGATURE THEH WITH REH FINAL FORM" . 64630)
                             ("ARABIC LIGATURE THEH WITH ZAIN FINAL FORM" . 64631)
                             ("ARABIC LIGATURE THEH WITH MEEM FINAL FORM" . 64632)
                             ("ARABIC LIGATURE THEH WITH NOON FINAL FORM" . 64633)
                             ("ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM" . 64634)
                             ("ARABIC LIGATURE THEH WITH YEH FINAL FORM" . 64635)
                             ("ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM" . 64636)
                             ("ARABIC LIGATURE FEH WITH YEH FINAL FORM" . 64637)
                             ("ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM" . 64638)
                             ("ARABIC LIGATURE QAF WITH YEH FINAL FORM" . 64639)
                             ("ARABIC LIGATURE KAF WITH ALEF FINAL FORM" . 64640)
                             ("ARABIC LIGATURE KAF WITH LAM FINAL FORM" . 64641)
                             ("ARABIC LIGATURE KAF WITH MEEM FINAL FORM" . 64642)
                             ("ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM" . 64643)
                             ("ARABIC LIGATURE KAF WITH YEH FINAL FORM" . 64644)
                             ("ARABIC LIGATURE LAM WITH MEEM FINAL FORM" . 64645)
                             ("ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM" . 64646)
                             ("ARABIC LIGATURE LAM WITH YEH FINAL FORM" . 64647)
                             ("ARABIC LIGATURE MEEM WITH ALEF FINAL FORM" . 64648)
                             ("ARABIC LIGATURE MEEM WITH MEEM FINAL FORM" . 64649)
                             ("ARABIC LIGATURE NOON WITH REH FINAL FORM" . 64650)
                             ("ARABIC LIGATURE NOON WITH ZAIN FINAL FORM" . 64651)
                             ("ARABIC LIGATURE NOON WITH MEEM FINAL FORM" . 64652)
                             ("ARABIC LIGATURE NOON WITH NOON FINAL FORM" . 64653)
                             ("ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM" . 64654)
                             ("ARABIC LIGATURE NOON WITH YEH FINAL FORM" . 64655)
                             ("ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM" . 64656)
                             ("ARABIC LIGATURE YEH WITH REH FINAL FORM" . 64657)
                             ("ARABIC LIGATURE YEH WITH ZAIN FINAL FORM" . 64658)
                             ("ARABIC LIGATURE YEH WITH MEEM FINAL FORM" . 64659)
                             ("ARABIC LIGATURE YEH WITH NOON FINAL FORM" . 64660)
                             ("ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM" . 64661)
                             ("ARABIC LIGATURE YEH WITH YEH FINAL FORM" . 64662)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM" . 64663)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM" . 64664)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM" . 64665)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM" . 64666)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM" . 64667)
                             ("ARABIC LIGATURE BEH WITH JEEM INITIAL FORM" . 64668)
                             ("ARABIC LIGATURE BEH WITH HAH INITIAL FORM" . 64669)
                             ("ARABIC LIGATURE BEH WITH KHAH INITIAL FORM" . 64670)
                             ("ARABIC LIGATURE BEH WITH MEEM INITIAL FORM" . 64671)
                             ("ARABIC LIGATURE BEH WITH HEH INITIAL FORM" . 64672)
                             ("ARABIC LIGATURE TEH WITH JEEM INITIAL FORM" . 64673)
                             ("ARABIC LIGATURE TEH WITH HAH INITIAL FORM" . 64674)
                             ("ARABIC LIGATURE TEH WITH KHAH INITIAL FORM" . 64675)
                             ("ARABIC LIGATURE TEH WITH MEEM INITIAL FORM" . 64676)
                             ("ARABIC LIGATURE TEH WITH HEH INITIAL FORM" . 64677)
                             ("ARABIC LIGATURE THEH WITH MEEM INITIAL FORM" . 64678)
                             ("ARABIC LIGATURE JEEM WITH HAH INITIAL FORM" . 64679)
                             ("ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM" . 64680)
                             ("ARABIC LIGATURE HAH WITH JEEM INITIAL FORM" . 64681)
                             ("ARABIC LIGATURE HAH WITH MEEM INITIAL FORM" . 64682)
                             ("ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM" . 64683)
                             ("ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM" . 64684)
                             ("ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM" . 64685)
                             ("ARABIC LIGATURE SEEN WITH HAH INITIAL FORM" . 64686)
                             ("ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM" . 64687)
                             ("ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM" . 64688)
                             ("ARABIC LIGATURE SAD WITH HAH INITIAL FORM" . 64689)
                             ("ARABIC LIGATURE SAD WITH KHAH INITIAL FORM" . 64690)
                             ("ARABIC LIGATURE SAD WITH MEEM INITIAL FORM" . 64691)
                             ("ARABIC LIGATURE DAD WITH JEEM INITIAL FORM" . 64692)
                             ("ARABIC LIGATURE DAD WITH HAH INITIAL FORM" . 64693)
                             ("ARABIC LIGATURE DAD WITH KHAH INITIAL FORM" . 64694)
                             ("ARABIC LIGATURE DAD WITH MEEM INITIAL FORM" . 64695)
                             ("ARABIC LIGATURE TAH WITH HAH INITIAL FORM" . 64696)
                             ("ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM" . 64697)
                             ("ARABIC LIGATURE AIN WITH JEEM INITIAL FORM" . 64698)
                             ("ARABIC LIGATURE AIN WITH MEEM INITIAL FORM" . 64699)
                             ("ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM" . 64700)
                             ("ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM" . 64701)
                             ("ARABIC LIGATURE FEH WITH JEEM INITIAL FORM" . 64702)
                             ("ARABIC LIGATURE FEH WITH HAH INITIAL FORM" . 64703)
                             ("ARABIC LIGATURE FEH WITH KHAH INITIAL FORM" . 64704)
                             ("ARABIC LIGATURE FEH WITH MEEM INITIAL FORM" . 64705)
                             ("ARABIC LIGATURE QAF WITH HAH INITIAL FORM" . 64706)
                             ("ARABIC LIGATURE QAF WITH MEEM INITIAL FORM" . 64707)
                             ("ARABIC LIGATURE KAF WITH JEEM INITIAL FORM" . 64708)
                             ("ARABIC LIGATURE KAF WITH HAH INITIAL FORM" . 64709)
                             ("ARABIC LIGATURE KAF WITH KHAH INITIAL FORM" . 64710)
                             ("ARABIC LIGATURE KAF WITH LAM INITIAL FORM" . 64711)
                             ("ARABIC LIGATURE KAF WITH MEEM INITIAL FORM" . 64712)
                             ("ARABIC LIGATURE LAM WITH JEEM INITIAL FORM" . 64713)
                             ("ARABIC LIGATURE LAM WITH HAH INITIAL FORM" . 64714)
                             ("ARABIC LIGATURE LAM WITH KHAH INITIAL FORM" . 64715)
                             ("ARABIC LIGATURE LAM WITH MEEM INITIAL FORM" . 64716)
                             ("ARABIC LIGATURE LAM WITH HEH INITIAL FORM" . 64717)
                             ("ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM" . 64718)
                             ("ARABIC LIGATURE MEEM WITH HAH INITIAL FORM" . 64719)
                             ("ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM" . 64720)
                             ("ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM" . 64721)
                             ("ARABIC LIGATURE NOON WITH JEEM INITIAL FORM" . 64722)
                             ("ARABIC LIGATURE NOON WITH HAH INITIAL FORM" . 64723)
                             ("ARABIC LIGATURE NOON WITH KHAH INITIAL FORM" . 64724)
                             ("ARABIC LIGATURE NOON WITH MEEM INITIAL FORM" . 64725)
                             ("ARABIC LIGATURE NOON WITH HEH INITIAL FORM" . 64726)
                             ("ARABIC LIGATURE HEH WITH JEEM INITIAL FORM" . 64727)
                             ("ARABIC LIGATURE HEH WITH MEEM INITIAL FORM" . 64728)
                             ("ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM" . 64729)
                             ("ARABIC LIGATURE YEH WITH JEEM INITIAL FORM" . 64730)
                             ("ARABIC LIGATURE YEH WITH HAH INITIAL FORM" . 64731)
                             ("ARABIC LIGATURE YEH WITH KHAH INITIAL FORM" . 64732)
                             ("ARABIC LIGATURE YEH WITH MEEM INITIAL FORM" . 64733)
                             ("ARABIC LIGATURE YEH WITH HEH INITIAL FORM" . 64734)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM" . 64735)
                             ("ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM" . 64736)
                             ("ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM" . 64737)
                             ("ARABIC LIGATURE BEH WITH HEH MEDIAL FORM" . 64738)
                             ("ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM" . 64739)
                             ("ARABIC LIGATURE TEH WITH HEH MEDIAL FORM" . 64740)
                             ("ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM" . 64741)
                             ("ARABIC LIGATURE THEH WITH HEH MEDIAL FORM" . 64742)
                             ("ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM" . 64743)
                             ("ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM" . 64744)
                             ("ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM" . 64745)
                             ("ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM" . 64746)
                             ("ARABIC LIGATURE KAF WITH LAM MEDIAL FORM" . 64747)
                             ("ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM" . 64748)
                             ("ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM" . 64749)
                             ("ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM" . 64750)
                             ("ARABIC LIGATURE NOON WITH HEH MEDIAL FORM" . 64751)
                             ("ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM" . 64752)
                             ("ARABIC LIGATURE YEH WITH HEH MEDIAL FORM" . 64753)
                             ("ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM" . 64754)
                             ("ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM" . 64755)
                             ("ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM" . 64756)
                             ("ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM" . 64757)
                             ("ARABIC LIGATURE TAH WITH YEH ISOLATED FORM" . 64758)
                             ("ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM" . 64759)
                             ("ARABIC LIGATURE AIN WITH YEH ISOLATED FORM" . 64760)
                             ("ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM" . 64761)
                             ("ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM" . 64762)
                             ("ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM" . 64763)
                             ("ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM" . 64764)
                             ("ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM" . 64765)
                             ("ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM" . 64766)
                             ("ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM" . 64767)
                             ("ARABIC LIGATURE HAH WITH YEH ISOLATED FORM" . 64768)
                             ("ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM" . 64769)
                             ("ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM" . 64770)
                             ("ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM" . 64771)
                             ("ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM" . 64772)
                             ("ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM" . 64773)
                             ("ARABIC LIGATURE SAD WITH YEH ISOLATED FORM" . 64774)
                             ("ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM" . 64775)
                             ("ARABIC LIGATURE DAD WITH YEH ISOLATED FORM" . 64776)
                             ("ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM" . 64777)
                             ("ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM" . 64778)
                             ("ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM" . 64779)
                             ("ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM" . 64780)
                             ("ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM" . 64781)
                             ("ARABIC LIGATURE SEEN WITH REH ISOLATED FORM" . 64782)
                             ("ARABIC LIGATURE SAD WITH REH ISOLATED FORM" . 64783)
                             ("ARABIC LIGATURE DAD WITH REH ISOLATED FORM" . 64784)
                             ("ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM" . 64785)
                             ("ARABIC LIGATURE TAH WITH YEH FINAL FORM" . 64786)
                             ("ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM" . 64787)
                             ("ARABIC LIGATURE AIN WITH YEH FINAL FORM" . 64788)
                             ("ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM" . 64789)
                             ("ARABIC LIGATURE GHAIN WITH YEH FINAL FORM" . 64790)
                             ("ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM" . 64791)
                             ("ARABIC LIGATURE SEEN WITH YEH FINAL FORM" . 64792)
                             ("ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM" . 64793)
                             ("ARABIC LIGATURE SHEEN WITH YEH FINAL FORM" . 64794)
                             ("ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM" . 64795)
                             ("ARABIC LIGATURE HAH WITH YEH FINAL FORM" . 64796)
                             ("ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM" . 64797)
                             ("ARABIC LIGATURE JEEM WITH YEH FINAL FORM" . 64798)
                             ("ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM" . 64799)
                             ("ARABIC LIGATURE KHAH WITH YEH FINAL FORM" . 64800)
                             ("ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM" . 64801)
                             ("ARABIC LIGATURE SAD WITH YEH FINAL FORM" . 64802)
                             ("ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM" . 64803)
                             ("ARABIC LIGATURE DAD WITH YEH FINAL FORM" . 64804)
                             ("ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM" . 64805)
                             ("ARABIC LIGATURE SHEEN WITH HAH FINAL FORM" . 64806)
                             ("ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM" . 64807)
                             ("ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM" . 64808)
                             ("ARABIC LIGATURE SHEEN WITH REH FINAL FORM" . 64809)
                             ("ARABIC LIGATURE SEEN WITH REH FINAL FORM" . 64810)
                             ("ARABIC LIGATURE SAD WITH REH FINAL FORM" . 64811)
                             ("ARABIC LIGATURE DAD WITH REH FINAL FORM" . 64812)
                             ("ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM" . 64813)
                             ("ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM" . 64814)
                             ("ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM" . 64815)
                             ("ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM" . 64816)
                             ("ARABIC LIGATURE SEEN WITH HEH INITIAL FORM" . 64817)
                             ("ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM" . 64818)
                             ("ARABIC LIGATURE TAH WITH MEEM INITIAL FORM" . 64819)
                             ("ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM" . 64820)
                             ("ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM" . 64821)
                             ("ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM" . 64822)
                             ("ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM" . 64823)
                             ("ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM" . 64824)
                             ("ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM" . 64825)
                             ("ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM" . 64826)
                             ("ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM" . 64827)
                             ("ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM" . 64828)
                             ("ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM" . 64829)
                             ("ORNATE LEFT PARENTHESIS" . 64830)
                             ("ORNATE RIGHT PARENTHESIS" . 64831)
                             ("ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM" . 64848)
                             ("ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM" . 64849)
                             ("ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM" . 64850)
                             ("ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM" . 64851)
                             ("ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM" . 64852)
                             ("ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM" . 64853)
                             ("ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM" . 64854)
                             ("ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM" . 64855)
                             ("ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM" . 64856)
                             ("ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM" . 64857)
                             ("ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM" . 64858)
                             ("ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64859)
                             ("ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM" . 64860)
                             ("ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM" . 64861)
                             ("ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM" . 64862)
                             ("ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM" . 64863)
                             ("ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM" . 64864)
                             ("ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM" . 64865)
                             ("ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM" . 64866)
                             ("ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM" . 64867)
                             ("ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM" . 64868)
                             ("ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM" . 64869)
                             ("ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM" . 64870)
                             ("ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM" . 64871)
                             ("ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM" . 64872)
                             ("ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM" . 64873)
                             ("ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM" . 64874)
                             ("ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM" . 64875)
                             ("ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM" . 64876)
                             ("ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM" . 64877)
                             ("ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM" . 64878)
                             ("ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM" . 64879)
                             ("ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM" . 64880)
                             ("ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM" . 64881)
                             ("ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM" . 64882)
                             ("ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM" . 64883)
                             ("ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM" . 64884)
                             ("ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM" . 64885)
                             ("ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM" . 64886)
                             ("ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM" . 64887)
                             ("ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64888)
                             ("ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM" . 64889)
                             ("ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM" . 64890)
                             ("ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64891)
                             ("ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM" . 64892)
                             ("ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM" . 64893)
                             ("ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM" . 64894)
                             ("ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM" . 64895)
                             ("ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM" . 64896)
                             ("ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM" . 64897)
                             ("ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM" . 64898)
                             ("ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM" . 64899)
                             ("ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM" . 64900)
                             ("ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM" . 64901)
                             ("ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM" . 64902)
                             ("ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM" . 64903)
                             ("ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM" . 64904)
                             ("ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM" . 64905)
                             ("ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM" . 64906)
                             ("ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM" . 64907)
                             ("ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM" . 64908)
                             ("ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM" . 64909)
                             ("ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM" . 64910)
                             ("ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM" . 64911)
                             ("ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM" . 64914)
                             ("ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM" . 64915)
                             ("ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM" . 64916)
                             ("ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM" . 64917)
                             ("ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM" . 64918)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM" . 64919)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM" . 64920)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM" . 64921)
                             ("ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM" . 64922)
                             ("ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64923)
                             ("ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM" . 64924)
                             ("ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM" . 64925)
                             ("ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM" . 64926)
                             ("ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM" . 64927)
                             ("ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM" . 64928)
                             ("ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM" . 64929)
                             ("ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM" . 64930)
                             ("ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM" . 64931)
                             ("ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64932)
                             ("ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM" . 64933)
                             ("ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM" . 64934)
                             ("ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM" . 64935)
                             ("ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM" . 64936)
                             ("ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM" . 64937)
                             ("ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM" . 64938)
                             ("ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM" . 64939)
                             ("ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM" . 64940)
                             ("ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM" . 64941)
                             ("ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM" . 64942)
                             ("ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM" . 64943)
                             ("ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM" . 64944)
                             ("ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM" . 64945)
                             ("ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM" . 64946)
                             ("ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM" . 64947)
                             ("ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM" . 64948)
                             ("ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM" . 64949)
                             ("ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM" . 64950)
                             ("ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM" . 64951)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM" . 64952)
                             ("ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM" . 64953)
                             ("ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM" . 64954)
                             ("ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM" . 64955)
                             ("ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM" . 64956)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM" . 64957)
                             ("ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM" . 64958)
                             ("ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM" . 64959)
                             ("ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM" . 64960)
                             ("ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM" . 64961)
                             ("ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM" . 64962)
                             ("ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM" . 64963)
                             ("ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM" . 64964)
                             ("ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM" . 64965)
                             ("ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM" . 64966)
                             ("ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM" . 64967)
                             ("ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM" . 65008)
                             ("ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM" . 65009)
                             ("ARABIC LIGATURE ALLAH ISOLATED FORM" . 65010)
                             ("ARABIC LIGATURE AKBAR ISOLATED FORM" . 65011)
                             ("ARABIC LIGATURE MOHAMMAD ISOLATED FORM" . 65012)
                             ("ARABIC LIGATURE SALAM ISOLATED FORM" . 65013)
                             ("ARABIC LIGATURE RASOUL ISOLATED FORM" . 65014)
                             ("ARABIC LIGATURE ALAYHE ISOLATED FORM" . 65015)
                             ("ARABIC LIGATURE WASALLAM ISOLATED FORM" . 65016)
                             ("ARABIC LIGATURE SALLA ISOLATED FORM" . 65017)
                             ("ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM" . 65018)
                             ("ARABIC LIGATURE JALLAJALALOUHOU" . 65019)
                             ("RIAL SIGN" . 65020)
                             ("VARIATION SELECTOR-1" . 65024)
                             ("VARIATION SELECTOR-2" . 65025)
                             ("VARIATION SELECTOR-3" . 65026)
                             ("VARIATION SELECTOR-4" . 65027)
                             ("VARIATION SELECTOR-5" . 65028)
                             ("VARIATION SELECTOR-6" . 65029)
                             ("VARIATION SELECTOR-7" . 65030)
                             ("VARIATION SELECTOR-8" . 65031)
                             ("VARIATION SELECTOR-9" . 65032)
                             ("VARIATION SELECTOR-10" . 65033)
                             ("VARIATION SELECTOR-11" . 65034)
                             ("VARIATION SELECTOR-12" . 65035)
                             ("VARIATION SELECTOR-13" . 65036)
                             ("VARIATION SELECTOR-14" . 65037)
                             ("VARIATION SELECTOR-15" . 65038)
                             ("VARIATION SELECTOR-16" . 65039)
                             ("COMBINING LIGATURE LEFT HALF" . 65056)
                             ("COMBINING LIGATURE RIGHT HALF" . 65057)
                             ("COMBINING DOUBLE TILDE LEFT HALF" . 65058)
                             ("COMBINING DOUBLE TILDE RIGHT HALF" . 65059)
                             ("PRESENTATION FORM FOR VERTICAL TWO DOT LEADER" . 65072)
                             ("PRESENTATION FORM FOR VERTICAL EM DASH" . 65073)
                             ("PRESENTATION FORM FOR VERTICAL EN DASH" . 65074)
                             ("PRESENTATION FORM FOR VERTICAL LOW LINE" . 65075)
                             ("PRESENTATION FORM FOR VERTICAL WAVY LOW LINE" . 65076)
                             ("PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS" . 65077)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS" . 65078)
                             ("PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET" . 65079)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET" . 65080)
                             ("PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET" . 65081)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET" . 65082)
                             ("PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET" . 65083)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET" . 65084)
                             ("PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET" . 65085)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET" . 65086)
                             ("PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET" . 65087)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET" . 65088)
                             ("PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET" . 65089)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET" . 65090)
                             ("PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET" . 65091)
                             ("PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET" . 65092)
                             ("SESAME DOT" . 65093)
                             ("WHITE SESAME DOT" . 65094)
                             ("DASHED OVERLINE" . 65097)
                             ("CENTRELINE OVERLINE" . 65098)
                             ("WAVY OVERLINE" . 65099)
                             ("DOUBLE WAVY OVERLINE" . 65100)
                             ("DASHED LOW LINE" . 65101)
                             ("CENTRELINE LOW LINE" . 65102)
                             ("WAVY LOW LINE" . 65103)
                             ("SMALL COMMA" . 65104)
                             ("SMALL IDEOGRAPHIC COMMA" . 65105)
                             ("SMALL FULL STOP" . 65106)
                             ("SMALL SEMICOLON" . 65108)
                             ("SMALL COLON" . 65109)
                             ("SMALL QUESTION MARK" . 65110)
                             ("SMALL EXCLAMATION MARK" . 65111)
                             ("SMALL EM DASH" . 65112)
                             ("SMALL LEFT PARENTHESIS" . 65113)
                             ("SMALL RIGHT PARENTHESIS" . 65114)
                             ("SMALL LEFT CURLY BRACKET" . 65115)
                             ("SMALL RIGHT CURLY BRACKET" . 65116)
                             ("SMALL LEFT TORTOISE SHELL BRACKET" . 65117)
                             ("SMALL RIGHT TORTOISE SHELL BRACKET" . 65118)
                             ("SMALL NUMBER SIGN" . 65119)
                             ("SMALL AMPERSAND" . 65120)
                             ("SMALL ASTERISK" . 65121)
                             ("SMALL PLUS SIGN" . 65122)
                             ("SMALL HYPHEN-MINUS" . 65123)
                             ("SMALL LESS-THAN SIGN" . 65124)
                             ("SMALL GREATER-THAN SIGN" . 65125)
                             ("SMALL EQUALS SIGN" . 65126)
                             ("SMALL REVERSE SOLIDUS" . 65128)
                             ("SMALL DOLLAR SIGN" . 65129)
                             ("SMALL PERCENT SIGN" . 65130)
                             ("SMALL COMMERCIAL AT" . 65131)
                             ("ARABIC FATHATAN ISOLATED FORM" . 65136)
                             ("ARABIC TATWEEL WITH FATHATAN ABOVE" . 65137)
                             ("ARABIC DAMMATAN ISOLATED FORM" . 65138)
                             ("ARABIC TAIL FRAGMENT" . 65139)
                             ("ARABIC KASRATAN ISOLATED FORM" . 65140)
                             ("ARABIC FATHA ISOLATED FORM" . 65142)
                             ("ARABIC FATHA MEDIAL FORM" . 65143)
                             ("ARABIC DAMMA ISOLATED FORM" . 65144)
                             ("ARABIC DAMMA MEDIAL FORM" . 65145)
                             ("ARABIC KASRA ISOLATED FORM" . 65146)
                             ("ARABIC KASRA MEDIAL FORM" . 65147)
                             ("ARABIC SHADDA ISOLATED FORM" . 65148)
                             ("ARABIC SHADDA MEDIAL FORM" . 65149)
                             ("ARABIC SUKUN ISOLATED FORM" . 65150)
                             ("ARABIC SUKUN MEDIAL FORM" . 65151)
                             ("ARABIC LETTER HAMZA ISOLATED FORM" . 65152)
                             ("ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM" . 65153)
                             ("ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM" . 65154)
                             ("ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM" . 65155)
                             ("ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM" . 65156)
                             ("ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM" . 65157)
                             ("ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM" . 65158)
                             ("ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM" . 65159)
                             ("ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM" . 65160)
                             ("ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM" . 65161)
                             ("ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM" . 65162)
                             ("ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM" . 65163)
                             ("ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM" . 65164)
                             ("ARABIC LETTER ALEF ISOLATED FORM" . 65165)
                             ("ARABIC LETTER ALEF FINAL FORM" . 65166)
                             ("ARABIC LETTER BEH ISOLATED FORM" . 65167)
                             ("ARABIC LETTER BEH FINAL FORM" . 65168)
                             ("ARABIC LETTER BEH INITIAL FORM" . 65169)
                             ("ARABIC LETTER BEH MEDIAL FORM" . 65170)
                             ("ARABIC LETTER TEH MARBUTA ISOLATED FORM" . 65171)
                             ("ARABIC LETTER TEH MARBUTA FINAL FORM" . 65172)
                             ("ARABIC LETTER TEH ISOLATED FORM" . 65173)
                             ("ARABIC LETTER TEH FINAL FORM" . 65174)
                             ("ARABIC LETTER TEH INITIAL FORM" . 65175)
                             ("ARABIC LETTER TEH MEDIAL FORM" . 65176)
                             ("ARABIC LETTER THEH ISOLATED FORM" . 65177)
                             ("ARABIC LETTER THEH FINAL FORM" . 65178)
                             ("ARABIC LETTER THEH INITIAL FORM" . 65179)
                             ("ARABIC LETTER THEH MEDIAL FORM" . 65180)
                             ("ARABIC LETTER JEEM ISOLATED FORM" . 65181)
                             ("ARABIC LETTER JEEM FINAL FORM" . 65182)
                             ("ARABIC LETTER JEEM INITIAL FORM" . 65183)
                             ("ARABIC LETTER JEEM MEDIAL FORM" . 65184)
                             ("ARABIC LETTER HAH ISOLATED FORM" . 65185)
                             ("ARABIC LETTER HAH FINAL FORM" . 65186)
                             ("ARABIC LETTER HAH INITIAL FORM" . 65187)
                             ("ARABIC LETTER HAH MEDIAL FORM" . 65188)
                             ("ARABIC LETTER KHAH ISOLATED FORM" . 65189)
                             ("ARABIC LETTER KHAH FINAL FORM" . 65190)
                             ("ARABIC LETTER KHAH INITIAL FORM" . 65191)
                             ("ARABIC LETTER KHAH MEDIAL FORM" . 65192)
                             ("ARABIC LETTER DAL ISOLATED FORM" . 65193)
                             ("ARABIC LETTER DAL FINAL FORM" . 65194)
                             ("ARABIC LETTER THAL ISOLATED FORM" . 65195)
                             ("ARABIC LETTER THAL FINAL FORM" . 65196)
                             ("ARABIC LETTER REH ISOLATED FORM" . 65197)
                             ("ARABIC LETTER REH FINAL FORM" . 65198)
                             ("ARABIC LETTER ZAIN ISOLATED FORM" . 65199)
                             ("ARABIC LETTER ZAIN FINAL FORM" . 65200)
                             ("ARABIC LETTER SEEN ISOLATED FORM" . 65201)
                             ("ARABIC LETTER SEEN FINAL FORM" . 65202)
                             ("ARABIC LETTER SEEN INITIAL FORM" . 65203)
                             ("ARABIC LETTER SEEN MEDIAL FORM" . 65204)
                             ("ARABIC LETTER SHEEN ISOLATED FORM" . 65205)
                             ("ARABIC LETTER SHEEN FINAL FORM" . 65206)
                             ("ARABIC LETTER SHEEN INITIAL FORM" . 65207)
                             ("ARABIC LETTER SHEEN MEDIAL FORM" . 65208)
                             ("ARABIC LETTER SAD ISOLATED FORM" . 65209)
                             ("ARABIC LETTER SAD FINAL FORM" . 65210)
                             ("ARABIC LETTER SAD INITIAL FORM" . 65211)
                             ("ARABIC LETTER SAD MEDIAL FORM" . 65212)
                             ("ARABIC LETTER DAD ISOLATED FORM" . 65213)
                             ("ARABIC LETTER DAD FINAL FORM" . 65214)
                             ("ARABIC LETTER DAD INITIAL FORM" . 65215)
                             ("ARABIC LETTER DAD MEDIAL FORM" . 65216)
                             ("ARABIC LETTER TAH ISOLATED FORM" . 65217)
                             ("ARABIC LETTER TAH FINAL FORM" . 65218)
                             ("ARABIC LETTER TAH INITIAL FORM" . 65219)
                             ("ARABIC LETTER TAH MEDIAL FORM" . 65220)
                             ("ARABIC LETTER ZAH ISOLATED FORM" . 65221)
                             ("ARABIC LETTER ZAH FINAL FORM" . 65222)
                             ("ARABIC LETTER ZAH INITIAL FORM" . 65223)
                             ("ARABIC LETTER ZAH MEDIAL FORM" . 65224)
                             ("ARABIC LETTER AIN ISOLATED FORM" . 65225)
                             ("ARABIC LETTER AIN FINAL FORM" . 65226)
                             ("ARABIC LETTER AIN INITIAL FORM" . 65227)
                             ("ARABIC LETTER AIN MEDIAL FORM" . 65228)
                             ("ARABIC LETTER GHAIN ISOLATED FORM" . 65229)
                             ("ARABIC LETTER GHAIN FINAL FORM" . 65230)
                             ("ARABIC LETTER GHAIN INITIAL FORM" . 65231)
                             ("ARABIC LETTER GHAIN MEDIAL FORM" . 65232)
                             ("ARABIC LETTER FEH ISOLATED FORM" . 65233)
                             ("ARABIC LETTER FEH FINAL FORM" . 65234)
                             ("ARABIC LETTER FEH INITIAL FORM" . 65235)
                             ("ARABIC LETTER FEH MEDIAL FORM" . 65236)
                             ("ARABIC LETTER QAF ISOLATED FORM" . 65237)
                             ("ARABIC LETTER QAF FINAL FORM" . 65238)
                             ("ARABIC LETTER QAF INITIAL FORM" . 65239)
                             ("ARABIC LETTER QAF MEDIAL FORM" . 65240)
                             ("ARABIC LETTER KAF ISOLATED FORM" . 65241)
                             ("ARABIC LETTER KAF FINAL FORM" . 65242)
                             ("ARABIC LETTER KAF INITIAL FORM" . 65243)
                             ("ARABIC LETTER KAF MEDIAL FORM" . 65244)
                             ("ARABIC LETTER LAM ISOLATED FORM" . 65245)
                             ("ARABIC LETTER LAM FINAL FORM" . 65246)
                             ("ARABIC LETTER LAM INITIAL FORM" . 65247)
                             ("ARABIC LETTER LAM MEDIAL FORM" . 65248)
                             ("ARABIC LETTER MEEM ISOLATED FORM" . 65249)
                             ("ARABIC LETTER MEEM FINAL FORM" . 65250)
                             ("ARABIC LETTER MEEM INITIAL FORM" . 65251)
                             ("ARABIC LETTER MEEM MEDIAL FORM" . 65252)
                             ("ARABIC LETTER NOON ISOLATED FORM" . 65253)
                             ("ARABIC LETTER NOON FINAL FORM" . 65254)
                             ("ARABIC LETTER NOON INITIAL FORM" . 65255)
                             ("ARABIC LETTER NOON MEDIAL FORM" . 65256)
                             ("ARABIC LETTER HEH ISOLATED FORM" . 65257)
                             ("ARABIC LETTER HEH FINAL FORM" . 65258)
                             ("ARABIC LETTER HEH INITIAL FORM" . 65259)
                             ("ARABIC LETTER HEH MEDIAL FORM" . 65260)
                             ("ARABIC LETTER WAW ISOLATED FORM" . 65261)
                             ("ARABIC LETTER WAW FINAL FORM" . 65262)
                             ("ARABIC LETTER ALEF MAKSURA ISOLATED FORM" . 65263)
                             ("ARABIC LETTER ALEF MAKSURA FINAL FORM" . 65264)
                             ("ARABIC LETTER YEH ISOLATED FORM" . 65265)
                             ("ARABIC LETTER YEH FINAL FORM" . 65266)
                             ("ARABIC LETTER YEH INITIAL FORM" . 65267)
                             ("ARABIC LETTER YEH MEDIAL FORM" . 65268)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM" . 65269)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM" . 65270)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM" . 65271)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM" . 65272)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM" . 65273)
                             ("ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM" . 65274)
                             ("ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM" . 65275)
                             ("ARABIC LIGATURE LAM WITH ALEF FINAL FORM" . 65276)
                             ("ZERO WIDTH NO-BREAK SPACE" . 65279)
                             ("FULLWIDTH EXCLAMATION MARK" . 65281)
                             ("FULLWIDTH QUOTATION MARK" . 65282)
                             ("FULLWIDTH NUMBER SIGN" . 65283)
                             ("FULLWIDTH DOLLAR SIGN" . 65284)
                             ("FULLWIDTH PERCENT SIGN" . 65285)
                             ("FULLWIDTH AMPERSAND" . 65286)
                             ("FULLWIDTH APOSTROPHE" . 65287)
                             ("FULLWIDTH LEFT PARENTHESIS" . 65288)
                             ("FULLWIDTH RIGHT PARENTHESIS" . 65289)
                             ("FULLWIDTH ASTERISK" . 65290)
                             ("FULLWIDTH PLUS SIGN" . 65291)
                             ("FULLWIDTH COMMA" . 65292)
                             ("FULLWIDTH HYPHEN-MINUS" . 65293)
                             ("FULLWIDTH FULL STOP" . 65294)
                             ("FULLWIDTH SOLIDUS" . 65295)
                             ("FULLWIDTH DIGIT ZERO" . 65296)
                             ("FULLWIDTH DIGIT ONE" . 65297)
                             ("FULLWIDTH DIGIT TWO" . 65298)
                             ("FULLWIDTH DIGIT THREE" . 65299)
                             ("FULLWIDTH DIGIT FOUR" . 65300)
                             ("FULLWIDTH DIGIT FIVE" . 65301)
                             ("FULLWIDTH DIGIT SIX" . 65302)
                             ("FULLWIDTH DIGIT SEVEN" . 65303)
                             ("FULLWIDTH DIGIT EIGHT" . 65304)
                             ("FULLWIDTH DIGIT NINE" . 65305)
                             ("FULLWIDTH COLON" . 65306)
                             ("FULLWIDTH SEMICOLON" . 65307)
                             ("FULLWIDTH LESS-THAN SIGN" . 65308)
                             ("FULLWIDTH EQUALS SIGN" . 65309)
                             ("FULLWIDTH GREATER-THAN SIGN" . 65310)
                             ("FULLWIDTH QUESTION MARK" . 65311)
                             ("FULLWIDTH COMMERCIAL AT" . 65312)
                             ("FULLWIDTH LATIN CAPITAL LETTER A" . 65313)
                             ("FULLWIDTH LATIN CAPITAL LETTER B" . 65314)
                             ("FULLWIDTH LATIN CAPITAL LETTER C" . 65315)
                             ("FULLWIDTH LATIN CAPITAL LETTER D" . 65316)
                             ("FULLWIDTH LATIN CAPITAL LETTER E" . 65317)
                             ("FULLWIDTH LATIN CAPITAL LETTER F" . 65318)
                             ("FULLWIDTH LATIN CAPITAL LETTER G" . 65319)
                             ("FULLWIDTH LATIN CAPITAL LETTER H" . 65320)
                             ("FULLWIDTH LATIN CAPITAL LETTER I" . 65321)
                             ("FULLWIDTH LATIN CAPITAL LETTER J" . 65322)
                             ("FULLWIDTH LATIN CAPITAL LETTER K" . 65323)
                             ("FULLWIDTH LATIN CAPITAL LETTER L" . 65324)
                             ("FULLWIDTH LATIN CAPITAL LETTER M" . 65325)
                             ("FULLWIDTH LATIN CAPITAL LETTER N" . 65326)
                             ("FULLWIDTH LATIN CAPITAL LETTER O" . 65327)
                             ("FULLWIDTH LATIN CAPITAL LETTER P" . 65328)
                             ("FULLWIDTH LATIN CAPITAL LETTER Q" . 65329)
                             ("FULLWIDTH LATIN CAPITAL LETTER R" . 65330)
                             ("FULLWIDTH LATIN CAPITAL LETTER S" . 65331)
                             ("FULLWIDTH LATIN CAPITAL LETTER T" . 65332)
                             ("FULLWIDTH LATIN CAPITAL LETTER U" . 65333)
                             ("FULLWIDTH LATIN CAPITAL LETTER V" . 65334)
                             ("FULLWIDTH LATIN CAPITAL LETTER W" . 65335)
                             ("FULLWIDTH LATIN CAPITAL LETTER X" . 65336)
                             ("FULLWIDTH LATIN CAPITAL LETTER Y" . 65337)
                             ("FULLWIDTH LATIN CAPITAL LETTER Z" . 65338)
                             ("FULLWIDTH LEFT SQUARE BRACKET" . 65339)
                             ("FULLWIDTH REVERSE SOLIDUS" . 65340)
                             ("FULLWIDTH RIGHT SQUARE BRACKET" . 65341)
                             ("FULLWIDTH CIRCUMFLEX ACCENT" . 65342)
                             ("FULLWIDTH LOW LINE" . 65343)
                             ("FULLWIDTH GRAVE ACCENT" . 65344)
                             ("FULLWIDTH LATIN SMALL LETTER A" . 65345)
                             ("FULLWIDTH LATIN SMALL LETTER B" . 65346)
                             ("FULLWIDTH LATIN SMALL LETTER C" . 65347)
                             ("FULLWIDTH LATIN SMALL LETTER D" . 65348)
                             ("FULLWIDTH LATIN SMALL LETTER E" . 65349)
                             ("FULLWIDTH LATIN SMALL LETTER F" . 65350)
                             ("FULLWIDTH LATIN SMALL LETTER G" . 65351)
                             ("FULLWIDTH LATIN SMALL LETTER H" . 65352)
                             ("FULLWIDTH LATIN SMALL LETTER I" . 65353)
                             ("FULLWIDTH LATIN SMALL LETTER J" . 65354)
                             ("FULLWIDTH LATIN SMALL LETTER K" . 65355)
                             ("FULLWIDTH LATIN SMALL LETTER L" . 65356)
                             ("FULLWIDTH LATIN SMALL LETTER M" . 65357)
                             ("FULLWIDTH LATIN SMALL LETTER N" . 65358)
                             ("FULLWIDTH LATIN SMALL LETTER O" . 65359)
                             ("FULLWIDTH LATIN SMALL LETTER P" . 65360)
                             ("FULLWIDTH LATIN SMALL LETTER Q" . 65361)
                             ("FULLWIDTH LATIN SMALL LETTER R" . 65362)
                             ("FULLWIDTH LATIN SMALL LETTER S" . 65363)
                             ("FULLWIDTH LATIN SMALL LETTER T" . 65364)
                             ("FULLWIDTH LATIN SMALL LETTER U" . 65365)
                             ("FULLWIDTH LATIN SMALL LETTER V" . 65366)
                             ("FULLWIDTH LATIN SMALL LETTER W" . 65367)
                             ("FULLWIDTH LATIN SMALL LETTER X" . 65368)
                             ("FULLWIDTH LATIN SMALL LETTER Y" . 65369)
                             ("FULLWIDTH LATIN SMALL LETTER Z" . 65370)
                             ("FULLWIDTH LEFT CURLY BRACKET" . 65371)
                             ("FULLWIDTH VERTICAL LINE" . 65372)
                             ("FULLWIDTH RIGHT CURLY BRACKET" . 65373)
                             ("FULLWIDTH TILDE" . 65374)
                             ("FULLWIDTH LEFT WHITE PARENTHESIS" . 65375)
                             ("FULLWIDTH RIGHT WHITE PARENTHESIS" . 65376)
                             ("HALFWIDTH IDEOGRAPHIC FULL STOP" . 65377)
                             ("HALFWIDTH LEFT CORNER BRACKET" . 65378)
                             ("HALFWIDTH RIGHT CORNER BRACKET" . 65379)
                             ("HALFWIDTH IDEOGRAPHIC COMMA" . 65380)
                             ("HALFWIDTH KATAKANA MIDDLE DOT" . 65381)
                             ("HALFWIDTH KATAKANA LETTER WO" . 65382)
                             ("HALFWIDTH KATAKANA LETTER SMALL A" . 65383)
                             ("HALFWIDTH KATAKANA LETTER SMALL I" . 65384)
                             ("HALFWIDTH KATAKANA LETTER SMALL U" . 65385)
                             ("HALFWIDTH KATAKANA LETTER SMALL E" . 65386)
                             ("HALFWIDTH KATAKANA LETTER SMALL O" . 65387)
                             ("HALFWIDTH KATAKANA LETTER SMALL YA" . 65388)
                             ("HALFWIDTH KATAKANA LETTER SMALL YU" . 65389)
                             ("HALFWIDTH KATAKANA LETTER SMALL YO" . 65390)
                             ("HALFWIDTH KATAKANA LETTER SMALL TU" . 65391)
                             ("HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK" . 65392)
                             ("HALFWIDTH KATAKANA LETTER A" . 65393)
                             ("HALFWIDTH KATAKANA LETTER I" . 65394)
                             ("HALFWIDTH KATAKANA LETTER U" . 65395)
                             ("HALFWIDTH KATAKANA LETTER E" . 65396)
                             ("HALFWIDTH KATAKANA LETTER O" . 65397)
                             ("HALFWIDTH KATAKANA LETTER KA" . 65398)
                             ("HALFWIDTH KATAKANA LETTER KI" . 65399)
                             ("HALFWIDTH KATAKANA LETTER KU" . 65400)
                             ("HALFWIDTH KATAKANA LETTER KE" . 65401)
                             ("HALFWIDTH KATAKANA LETTER KO" . 65402)
                             ("HALFWIDTH KATAKANA LETTER SA" . 65403)
                             ("HALFWIDTH KATAKANA LETTER SI" . 65404)
                             ("HALFWIDTH KATAKANA LETTER SU" . 65405)
                             ("HALFWIDTH KATAKANA LETTER SE" . 65406)
                             ("HALFWIDTH KATAKANA LETTER SO" . 65407)
                             ("HALFWIDTH KATAKANA LETTER TA" . 65408)
                             ("HALFWIDTH KATAKANA LETTER TI" . 65409)
                             ("HALFWIDTH KATAKANA LETTER TU" . 65410)
                             ("HALFWIDTH KATAKANA LETTER TE" . 65411)
                             ("HALFWIDTH KATAKANA LETTER TO" . 65412)
                             ("HALFWIDTH KATAKANA LETTER NA" . 65413)
                             ("HALFWIDTH KATAKANA LETTER NI" . 65414)
                             ("HALFWIDTH KATAKANA LETTER NU" . 65415)
                             ("HALFWIDTH KATAKANA LETTER NE" . 65416)
                             ("HALFWIDTH KATAKANA LETTER NO" . 65417)
                             ("HALFWIDTH KATAKANA LETTER HA" . 65418)
                             ("HALFWIDTH KATAKANA LETTER HI" . 65419)
                             ("HALFWIDTH KATAKANA LETTER HU" . 65420)
                             ("HALFWIDTH KATAKANA LETTER HE" . 65421)
                             ("HALFWIDTH KATAKANA LETTER HO" . 65422)
                             ("HALFWIDTH KATAKANA LETTER MA" . 65423)
                             ("HALFWIDTH KATAKANA LETTER MI" . 65424)
                             ("HALFWIDTH KATAKANA LETTER MU" . 65425)
                             ("HALFWIDTH KATAKANA LETTER ME" . 65426)
                             ("HALFWIDTH KATAKANA LETTER MO" . 65427)
                             ("HALFWIDTH KATAKANA LETTER YA" . 65428)
                             ("HALFWIDTH KATAKANA LETTER YU" . 65429)
                             ("HALFWIDTH KATAKANA LETTER YO" . 65430)
                             ("HALFWIDTH KATAKANA LETTER RA" . 65431)
                             ("HALFWIDTH KATAKANA LETTER RI" . 65432)
                             ("HALFWIDTH KATAKANA LETTER RU" . 65433)
                             ("HALFWIDTH KATAKANA LETTER RE" . 65434)
                             ("HALFWIDTH KATAKANA LETTER RO" . 65435)
                             ("HALFWIDTH KATAKANA LETTER WA" . 65436)
                             ("HALFWIDTH KATAKANA LETTER N" . 65437)
                             ("HALFWIDTH KATAKANA VOICED SOUND MARK" . 65438)
                             ("HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK" . 65439)
                             ("HALFWIDTH HANGUL FILLER" . 65440)
                             ("HALFWIDTH HANGUL LETTER KIYEOK" . 65441)
                             ("HALFWIDTH HANGUL LETTER SSANGKIYEOK" . 65442)
                             ("HALFWIDTH HANGUL LETTER KIYEOK-SIOS" . 65443)
                             ("HALFWIDTH HANGUL LETTER NIEUN" . 65444)
                             ("HALFWIDTH HANGUL LETTER NIEUN-CIEUC" . 65445)
                             ("HALFWIDTH HANGUL LETTER NIEUN-HIEUH" . 65446)
                             ("HALFWIDTH HANGUL LETTER TIKEUT" . 65447)
                             ("HALFWIDTH HANGUL LETTER SSANGTIKEUT" . 65448)
                             ("HALFWIDTH HANGUL LETTER RIEUL" . 65449)
                             ("HALFWIDTH HANGUL LETTER RIEUL-KIYEOK" . 65450)
                             ("HALFWIDTH HANGUL LETTER RIEUL-MIEUM" . 65451)
                             ("HALFWIDTH HANGUL LETTER RIEUL-PIEUP" . 65452)
                             ("HALFWIDTH HANGUL LETTER RIEUL-SIOS" . 65453)
                             ("HALFWIDTH HANGUL LETTER RIEUL-THIEUTH" . 65454)
                             ("HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH" . 65455)
                             ("HALFWIDTH HANGUL LETTER RIEUL-HIEUH" . 65456)
                             ("HALFWIDTH HANGUL LETTER MIEUM" . 65457)
                             ("HALFWIDTH HANGUL LETTER PIEUP" . 65458)
                             ("HALFWIDTH HANGUL LETTER SSANGPIEUP" . 65459)
                             ("HALFWIDTH HANGUL LETTER PIEUP-SIOS" . 65460)
                             ("HALFWIDTH HANGUL LETTER SIOS" . 65461)
                             ("HALFWIDTH HANGUL LETTER SSANGSIOS" . 65462)
                             ("HALFWIDTH HANGUL LETTER IEUNG" . 65463)
                             ("HALFWIDTH HANGUL LETTER CIEUC" . 65464)
                             ("HALFWIDTH HANGUL LETTER SSANGCIEUC" . 65465)
                             ("HALFWIDTH HANGUL LETTER CHIEUCH" . 65466)
                             ("HALFWIDTH HANGUL LETTER KHIEUKH" . 65467)
                             ("HALFWIDTH HANGUL LETTER THIEUTH" . 65468)
                             ("HALFWIDTH HANGUL LETTER PHIEUPH" . 65469)
                             ("HALFWIDTH HANGUL LETTER HIEUH" . 65470)
                             ("HALFWIDTH HANGUL LETTER A" . 65474)
                             ("HALFWIDTH HANGUL LETTER AE" . 65475)
                             ("HALFWIDTH HANGUL LETTER YA" . 65476)
                             ("HALFWIDTH HANGUL LETTER YAE" . 65477)
                             ("HALFWIDTH HANGUL LETTER EO" . 65478)
                             ("HALFWIDTH HANGUL LETTER E" . 65479)
                             ("HALFWIDTH HANGUL LETTER YEO" . 65482)
                             ("HALFWIDTH HANGUL LETTER YE" . 65483)
                             ("HALFWIDTH HANGUL LETTER O" . 65484)
                             ("HALFWIDTH HANGUL LETTER WA" . 65485)
                             ("HALFWIDTH HANGUL LETTER WAE" . 65486)
                             ("HALFWIDTH HANGUL LETTER OE" . 65487)
                             ("HALFWIDTH HANGUL LETTER YO" . 65490)
                             ("HALFWIDTH HANGUL LETTER U" . 65491)
                             ("HALFWIDTH HANGUL LETTER WEO" . 65492)
                             ("HALFWIDTH HANGUL LETTER WE" . 65493)
                             ("HALFWIDTH HANGUL LETTER WI" . 65494)
                             ("HALFWIDTH HANGUL LETTER YU" . 65495)
                             ("HALFWIDTH HANGUL LETTER EU" . 65498)
                             ("HALFWIDTH HANGUL LETTER YI" . 65499)
                             ("HALFWIDTH HANGUL LETTER I" . 65500)
                             ("FULLWIDTH CENT SIGN" . 65504)
                             ("FULLWIDTH POUND SIGN" . 65505)
                             ("FULLWIDTH NOT SIGN" . 65506)
                             ("FULLWIDTH MACRON" . 65507)
                             ("FULLWIDTH BROKEN BAR" . 65508)
                             ("FULLWIDTH YEN SIGN" . 65509)
                             ("FULLWIDTH WON SIGN" . 65510)
                             ("HALFWIDTH FORMS LIGHT VERTICAL" . 65512)
                             ("HALFWIDTH LEFTWARDS ARROW" . 65513)
                             ("HALFWIDTH UPWARDS ARROW" . 65514)
                             ("HALFWIDTH RIGHTWARDS ARROW" . 65515)
                             ("HALFWIDTH DOWNWARDS ARROW" . 65516)
                             ("HALFWIDTH BLACK SQUARE" . 65517)
                             ("HALFWIDTH WHITE CIRCLE" . 65518)
                             ("INTERLINEAR ANNOTATION ANCHOR" . 65529)
                             ("INTERLINEAR ANNOTATION SEPARATOR" . 65530)
                             ("INTERLINEAR ANNOTATION TERMINATOR" . 65531)
                             ("OBJECT REPLACEMENT CHARACTER" . 65532)
                             ("REPLACEMENT CHARACTER" . 65533)
                             ("OLD ITALIC LETTER A" . 66304)
                             ("OLD ITALIC LETTER BE" . 66305)
                             ("OLD ITALIC LETTER KE" . 66306)
                             ("OLD ITALIC LETTER DE" . 66307)
                             ("OLD ITALIC LETTER E" . 66308)
                             ("OLD ITALIC LETTER VE" . 66309)
                             ("OLD ITALIC LETTER ZE" . 66310)
                             ("OLD ITALIC LETTER HE" . 66311)
                             ("OLD ITALIC LETTER THE" . 66312)
                             ("OLD ITALIC LETTER I" . 66313)
                             ("OLD ITALIC LETTER KA" . 66314)
                             ("OLD ITALIC LETTER EL" . 66315)
                             ("OLD ITALIC LETTER EM" . 66316)
                             ("OLD ITALIC LETTER EN" . 66317)
                             ("OLD ITALIC LETTER ESH" . 66318)
                             ("OLD ITALIC LETTER O" . 66319)
                             ("OLD ITALIC LETTER PE" . 66320)
                             ("OLD ITALIC LETTER SHE" . 66321)
                             ("OLD ITALIC LETTER KU" . 66322)
                             ("OLD ITALIC LETTER ER" . 66323)
                             ("OLD ITALIC LETTER ES" . 66324)
                             ("OLD ITALIC LETTER TE" . 66325)
                             ("OLD ITALIC LETTER U" . 66326)
                             ("OLD ITALIC LETTER EKS" . 66327)
                             ("OLD ITALIC LETTER PHE" . 66328)
                             ("OLD ITALIC LETTER KHE" . 66329)
                             ("OLD ITALIC LETTER EF" . 66330)
                             ("OLD ITALIC LETTER ERS" . 66331)
                             ("OLD ITALIC LETTER CHE" . 66332)
                             ("OLD ITALIC LETTER II" . 66333)
                             ("OLD ITALIC LETTER UU" . 66334)
                             ("OLD ITALIC NUMERAL ONE" . 66336)
                             ("OLD ITALIC NUMERAL FIVE" . 66337)
                             ("OLD ITALIC NUMERAL TEN" . 66338)
                             ("OLD ITALIC NUMERAL FIFTY" . 66339)
                             ("GOTHIC LETTER AHSA" . 66352)
                             ("GOTHIC LETTER BAIRKAN" . 66353)
                             ("GOTHIC LETTER GIBA" . 66354)
                             ("GOTHIC LETTER DAGS" . 66355)
                             ("GOTHIC LETTER AIHVUS" . 66356)
                             ("GOTHIC LETTER QAIRTHRA" . 66357)
                             ("GOTHIC LETTER IUJA" . 66358)
                             ("GOTHIC LETTER HAGL" . 66359)
                             ("GOTHIC LETTER THIUTH" . 66360)
                             ("GOTHIC LETTER EIS" . 66361)
                             ("GOTHIC LETTER KUSMA" . 66362)
                             ("GOTHIC LETTER LAGUS" . 66363)
                             ("GOTHIC LETTER MANNA" . 66364)
                             ("GOTHIC LETTER NAUTHS" . 66365)
                             ("GOTHIC LETTER JER" . 66366)
                             ("GOTHIC LETTER URUS" . 66367)
                             ("GOTHIC LETTER PAIRTHRA" . 66368)
                             ("GOTHIC LETTER NINETY" . 66369)
                             ("GOTHIC LETTER RAIDA" . 66370)
                             ("GOTHIC LETTER SAUIL" . 66371)
                             ("GOTHIC LETTER TEIWS" . 66372)
                             ("GOTHIC LETTER WINJA" . 66373)
                             ("GOTHIC LETTER FAIHU" . 66374)
                             ("GOTHIC LETTER IGGWS" . 66375)
                             ("GOTHIC LETTER HWAIR" . 66376)
                             ("GOTHIC LETTER OTHAL" . 66377)
                             ("GOTHIC LETTER NINE HUNDRED" . 66378)
                             ("DESERET CAPITAL LETTER LONG I" . 66560)
                             ("DESERET CAPITAL LETTER LONG E" . 66561)
                             ("DESERET CAPITAL LETTER LONG A" . 66562)
                             ("DESERET CAPITAL LETTER LONG AH" . 66563)
                             ("DESERET CAPITAL LETTER LONG O" . 66564)
                             ("DESERET CAPITAL LETTER LONG OO" . 66565)
                             ("DESERET CAPITAL LETTER SHORT I" . 66566)
                             ("DESERET CAPITAL LETTER SHORT E" . 66567)
                             ("DESERET CAPITAL LETTER SHORT A" . 66568)
                             ("DESERET CAPITAL LETTER SHORT AH" . 66569)
                             ("DESERET CAPITAL LETTER SHORT O" . 66570)
                             ("DESERET CAPITAL LETTER SHORT OO" . 66571)
                             ("DESERET CAPITAL LETTER AY" . 66572)
                             ("DESERET CAPITAL LETTER OW" . 66573)
                             ("DESERET CAPITAL LETTER WU" . 66574)
                             ("DESERET CAPITAL LETTER YEE" . 66575)
                             ("DESERET CAPITAL LETTER H" . 66576)
                             ("DESERET CAPITAL LETTER PEE" . 66577)
                             ("DESERET CAPITAL LETTER BEE" . 66578)
                             ("DESERET CAPITAL LETTER TEE" . 66579)
                             ("DESERET CAPITAL LETTER DEE" . 66580)
                             ("DESERET CAPITAL LETTER CHEE" . 66581)
                             ("DESERET CAPITAL LETTER JEE" . 66582)
                             ("DESERET CAPITAL LETTER KAY" . 66583)
                             ("DESERET CAPITAL LETTER GAY" . 66584)
                             ("DESERET CAPITAL LETTER EF" . 66585)
                             ("DESERET CAPITAL LETTER VEE" . 66586)
                             ("DESERET CAPITAL LETTER ETH" . 66587)
                             ("DESERET CAPITAL LETTER THEE" . 66588)
                             ("DESERET CAPITAL LETTER ES" . 66589)
                             ("DESERET CAPITAL LETTER ZEE" . 66590)
                             ("DESERET CAPITAL LETTER ESH" . 66591)
                             ("DESERET CAPITAL LETTER ZHEE" . 66592)
                             ("DESERET CAPITAL LETTER ER" . 66593)
                             ("DESERET CAPITAL LETTER EL" . 66594)
                             ("DESERET CAPITAL LETTER EM" . 66595)
                             ("DESERET CAPITAL LETTER EN" . 66596)
                             ("DESERET CAPITAL LETTER ENG" . 66597)
                             ("DESERET SMALL LETTER LONG I" . 66600)
                             ("DESERET SMALL LETTER LONG E" . 66601)
                             ("DESERET SMALL LETTER LONG A" . 66602)
                             ("DESERET SMALL LETTER LONG AH" . 66603)
                             ("DESERET SMALL LETTER LONG O" . 66604)
                             ("DESERET SMALL LETTER LONG OO" . 66605)
                             ("DESERET SMALL LETTER SHORT I" . 66606)
                             ("DESERET SMALL LETTER SHORT E" . 66607)
                             ("DESERET SMALL LETTER SHORT A" . 66608)
                             ("DESERET SMALL LETTER SHORT AH" . 66609)
                             ("DESERET SMALL LETTER SHORT O" . 66610)
                             ("DESERET SMALL LETTER SHORT OO" . 66611)
                             ("DESERET SMALL LETTER AY" . 66612)
                             ("DESERET SMALL LETTER OW" . 66613)
                             ("DESERET SMALL LETTER WU" . 66614)
                             ("DESERET SMALL LETTER YEE" . 66615)
                             ("DESERET SMALL LETTER H" . 66616)
                             ("DESERET SMALL LETTER PEE" . 66617)
                             ("DESERET SMALL LETTER BEE" . 66618)
                             ("DESERET SMALL LETTER TEE" . 66619)
                             ("DESERET SMALL LETTER DEE" . 66620)
                             ("DESERET SMALL LETTER CHEE" . 66621)
                             ("DESERET SMALL LETTER JEE" . 66622)
                             ("DESERET SMALL LETTER KAY" . 66623)
                             ("DESERET SMALL LETTER GAY" . 66624)
                             ("DESERET SMALL LETTER EF" . 66625)
                             ("DESERET SMALL LETTER VEE" . 66626)
                             ("DESERET SMALL LETTER ETH" . 66627)
                             ("DESERET SMALL LETTER THEE" . 66628)
                             ("DESERET SMALL LETTER ES" . 66629)
                             ("DESERET SMALL LETTER ZEE" . 66630)
                             ("DESERET SMALL LETTER ESH" . 66631)
                             ("DESERET SMALL LETTER ZHEE" . 66632)
                             ("DESERET SMALL LETTER ER" . 66633)
                             ("DESERET SMALL LETTER EL" . 66634)
                             ("DESERET SMALL LETTER EM" . 66635)
                             ("DESERET SMALL LETTER EN" . 66636)
                             ("DESERET SMALL LETTER ENG" . 66637)
                             ("BYZANTINE MUSICAL SYMBOL PSILI" . 118784)
                             ("BYZANTINE MUSICAL SYMBOL DASEIA" . 118785)
                             ("BYZANTINE MUSICAL SYMBOL PERISPOMENI" . 118786)
                             ("BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON" . 118787)
                             ("BYZANTINE MUSICAL SYMBOL OXEIA DIPLI" . 118788)
                             ("BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON" . 118789)
                             ("BYZANTINE MUSICAL SYMBOL VAREIA DIPLI" . 118790)
                             ("BYZANTINE MUSICAL SYMBOL KATHISTI" . 118791)
                             ("BYZANTINE MUSICAL SYMBOL SYRMATIKI" . 118792)
                             ("BYZANTINE MUSICAL SYMBOL PARAKLITIKI" . 118793)
                             ("BYZANTINE MUSICAL SYMBOL YPOKRISIS" . 118794)
                             ("BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI" . 118795)
                             ("BYZANTINE MUSICAL SYMBOL KREMASTI" . 118796)
                             ("BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON" . 118797)
                             ("BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON" . 118798)
                             ("BYZANTINE MUSICAL SYMBOL TELEIA" . 118799)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMATA" . 118800)
                             ("BYZANTINE MUSICAL SYMBOL APOSTROFOS" . 118801)
                             ("BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI" . 118802)
                             ("BYZANTINE MUSICAL SYMBOL SYNEVMA" . 118803)
                             ("BYZANTINE MUSICAL SYMBOL THITA" . 118804)
                             ("BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION" . 118805)
                             ("BYZANTINE MUSICAL SYMBOL GORGON ARCHAION" . 118806)
                             ("BYZANTINE MUSICAL SYMBOL PSILON" . 118807)
                             ("BYZANTINE MUSICAL SYMBOL CHAMILON" . 118808)
                             ("BYZANTINE MUSICAL SYMBOL VATHY" . 118809)
                             ("BYZANTINE MUSICAL SYMBOL ISON ARCHAION" . 118810)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION" . 118811)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION" . 118812)
                             ("BYZANTINE MUSICAL SYMBOL SAXIMATA" . 118813)
                             ("BYZANTINE MUSICAL SYMBOL PARICHON" . 118814)
                             ("BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA" . 118815)
                             ("BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION" . 118816)
                             ("BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION" . 118817)
                             ("BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION" . 118818)
                             ("BYZANTINE MUSICAL SYMBOL APOTHEMA" . 118819)
                             ("BYZANTINE MUSICAL SYMBOL KLASMA" . 118820)
                             ("BYZANTINE MUSICAL SYMBOL REVMA" . 118821)
                             ("BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION" . 118822)
                             ("BYZANTINE MUSICAL SYMBOL TINAGMA" . 118823)
                             ("BYZANTINE MUSICAL SYMBOL ANATRICHISMA" . 118824)
                             ("BYZANTINE MUSICAL SYMBOL SEISMA" . 118825)
                             ("BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION" . 118826)
                             ("BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU" . 118827)
                             ("BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION" . 118828)
                             ("BYZANTINE MUSICAL SYMBOL THEMA" . 118829)
                             ("BYZANTINE MUSICAL SYMBOL LEMOI" . 118830)
                             ("BYZANTINE MUSICAL SYMBOL DYO" . 118831)
                             ("BYZANTINE MUSICAL SYMBOL TRIA" . 118832)
                             ("BYZANTINE MUSICAL SYMBOL TESSERA" . 118833)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMATA" . 118834)
                             ("BYZANTINE MUSICAL SYMBOL APESO EXO NEO" . 118835)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION" . 118836)
                             ("BYZANTINE MUSICAL SYMBOL IMIFTHORA" . 118837)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION" . 118838)
                             ("BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON" . 118839)
                             ("BYZANTINE MUSICAL SYMBOL PELASTON" . 118840)
                             ("BYZANTINE MUSICAL SYMBOL PSIFISTON" . 118841)
                             ("BYZANTINE MUSICAL SYMBOL KONTEVMA" . 118842)
                             ("BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION" . 118843)
                             ("BYZANTINE MUSICAL SYMBOL RAPISMA" . 118844)
                             ("BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION" . 118845)
                             ("BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION" . 118846)
                             ("BYZANTINE MUSICAL SYMBOL ICHADIN" . 118847)
                             ("BYZANTINE MUSICAL SYMBOL NANA" . 118848)
                             ("BYZANTINE MUSICAL SYMBOL PETASMA" . 118849)
                             ("BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO" . 118850)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKON ALLO" . 118851)
                             ("BYZANTINE MUSICAL SYMBOL STRAGGISMATA" . 118852)
                             ("BYZANTINE MUSICAL SYMBOL GRONTHISMATA" . 118853)
                             ("BYZANTINE MUSICAL SYMBOL ISON NEO" . 118854)
                             ("BYZANTINE MUSICAL SYMBOL OLIGON NEO" . 118855)
                             ("BYZANTINE MUSICAL SYMBOL OXEIA NEO" . 118856)
                             ("BYZANTINE MUSICAL SYMBOL PETASTI" . 118857)
                             ("BYZANTINE MUSICAL SYMBOL KOUFISMA" . 118858)
                             ("BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA" . 118859)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA" . 118860)
                             ("BYZANTINE MUSICAL SYMBOL PELASTON NEO" . 118861)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO" . 118862)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO" . 118863)
                             ("BYZANTINE MUSICAL SYMBOL YPSILI" . 118864)
                             ("BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO" . 118865)
                             ("BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO" . 118866)
                             ("BYZANTINE MUSICAL SYMBOL YPORROI" . 118867)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON" . 118868)
                             ("BYZANTINE MUSICAL SYMBOL ELAFRON" . 118869)
                             ("BYZANTINE MUSICAL SYMBOL CHAMILI" . 118870)
                             ("BYZANTINE MUSICAL SYMBOL MIKRON ISON" . 118871)
                             ("BYZANTINE MUSICAL SYMBOL VAREIA NEO" . 118872)
                             ("BYZANTINE MUSICAL SYMBOL PIASMA NEO" . 118873)
                             ("BYZANTINE MUSICAL SYMBOL PSIFISTON NEO" . 118874)
                             ("BYZANTINE MUSICAL SYMBOL OMALON" . 118875)
                             ("BYZANTINE MUSICAL SYMBOL ANTIKENOMA" . 118876)
                             ("BYZANTINE MUSICAL SYMBOL LYGISMA" . 118877)
                             ("BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO" . 118878)
                             ("BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO" . 118879)
                             ("BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA" . 118880)
                             ("BYZANTINE MUSICAL SYMBOL KYLISMA" . 118881)
                             ("BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA" . 118882)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKON NEO" . 118883)
                             ("BYZANTINE MUSICAL SYMBOL EKSTREPTON" . 118884)
                             ("BYZANTINE MUSICAL SYMBOL SYNAGMA NEO" . 118885)
                             ("BYZANTINE MUSICAL SYMBOL SYRMA" . 118886)
                             ("BYZANTINE MUSICAL SYMBOL CHOREVMA NEO" . 118887)
                             ("BYZANTINE MUSICAL SYMBOL EPEGERMA" . 118888)
                             ("BYZANTINE MUSICAL SYMBOL SEISMA NEO" . 118889)
                             ("BYZANTINE MUSICAL SYMBOL XIRON KLASMA" . 118890)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON" . 118891)
                             ("BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA" . 118892)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA" . 118893)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA" . 118894)
                             ("BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA" . 118895)
                             ("BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA" . 118896)
                             ("BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA" . 118897)
                             ("BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON" . 118898)
                             ("BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON" . 118899)
                             ("BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON" . 118900)
                             ("BYZANTINE MUSICAL SYMBOL OYRANISMA NEO" . 118901)
                             ("BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO" . 118902)
                             ("BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO" . 118903)
                             ("BYZANTINE MUSICAL SYMBOL THEMA APLOUN" . 118904)
                             ("BYZANTINE MUSICAL SYMBOL THES KAI APOTHES" . 118905)
                             ("BYZANTINE MUSICAL SYMBOL KATAVASMA" . 118906)
                             ("BYZANTINE MUSICAL SYMBOL ENDOFONON" . 118907)
                             ("BYZANTINE MUSICAL SYMBOL YFEN KATO" . 118908)
                             ("BYZANTINE MUSICAL SYMBOL YFEN ANO" . 118909)
                             ("BYZANTINE MUSICAL SYMBOL STAVROS" . 118910)
                             ("BYZANTINE MUSICAL SYMBOL KLASMA ANO" . 118911)
                             ("BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION" . 118912)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION" . 118913)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMA ALLO" . 118914)
                             ("BYZANTINE MUSICAL SYMBOL KRATIMA NEO" . 118915)
                             ("BYZANTINE MUSICAL SYMBOL APODERMA NEO" . 118916)
                             ("BYZANTINE MUSICAL SYMBOL APLI" . 118917)
                             ("BYZANTINE MUSICAL SYMBOL DIPLI" . 118918)
                             ("BYZANTINE MUSICAL SYMBOL TRIPLI" . 118919)
                             ("BYZANTINE MUSICAL SYMBOL TETRAPLI" . 118920)
                             ("BYZANTINE MUSICAL SYMBOL KORONIS" . 118921)
                             ("BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU" . 118922)
                             ("BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON" . 118923)
                             ("BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON" . 118924)
                             ("BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON" . 118925)
                             ("BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU" . 118926)
                             ("BYZANTINE MUSICAL SYMBOL GORGON NEO ANO" . 118927)
                             ("BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA" . 118928)
                             ("BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA" . 118929)
                             ("BYZANTINE MUSICAL SYMBOL DIGORGON" . 118930)
                             ("BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO" . 118931)
                             ("BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO" . 118932)
                             ("BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA" . 118933)
                             ("BYZANTINE MUSICAL SYMBOL TRIGORGON" . 118934)
                             ("BYZANTINE MUSICAL SYMBOL ARGON" . 118935)
                             ("BYZANTINE MUSICAL SYMBOL IMIDIARGON" . 118936)
                             ("BYZANTINE MUSICAL SYMBOL DIARGON" . 118937)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI" . 118938)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI" . 118939)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI ARGI" . 118940)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI METRIA" . 118941)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI MESI" . 118942)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI GORGI" . 118943)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI" . 118944)
                             ("BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI" . 118945)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS" . 118946)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS" . 118947)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS" . 118948)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS" . 118949)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS" . 118950)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS" . 118951)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS" . 118952)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS" . 118953)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS" . 118954)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS" . 118955)
                             ("BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS" . 118956)
                             ("BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS" . 118957)
                             ("BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS" . 118958)
                             ("BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS" . 118959)
                             ("BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS" . 118960)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS" . 118961)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS" . 118962)
                             ("BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS" . 118963)
                             ("BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN" . 118964)
                             ("BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN" . 118965)
                             ("BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU" . 118966)
                             ("BYZANTINE MUSICAL SYMBOL IMIFONON" . 118967)
                             ("BYZANTINE MUSICAL SYMBOL IMIFTHORON" . 118968)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU" . 118969)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA" . 118970)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA" . 118971)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS" . 118972)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI" . 118973)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI" . 118974)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE" . 118975)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO" . 118976)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO" . 118977)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO" . 118978)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS" . 118979)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS" . 118980)
                             ("BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS" . 118981)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI" . 118982)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA NENANO" . 118983)
                             ("BYZANTINE MUSICAL SYMBOL CHROA ZYGOS" . 118984)
                             ("BYZANTINE MUSICAL SYMBOL CHROA KLITON" . 118985)
                             ("BYZANTINE MUSICAL SYMBOL CHROA SPATHI" . 118986)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION" . 118987)
                             ("BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA" . 118988)
                             ("BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION" . 118989)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION" . 118990)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION" . 118991)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA" . 118992)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA" . 118993)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA" . 118994)
                             ("BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA" . 118995)
                             ("BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA" . 118996)
                             ("BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA" . 118997)
                             ("BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA" . 118998)
                             ("BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA" . 118999)
                             ("BYZANTINE MUSICAL SYMBOL GENIKI DIESIS" . 119000)
                             ("BYZANTINE MUSICAL SYMBOL GENIKI YFESIS" . 119001)
                             ("BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI" . 119002)
                             ("BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI" . 119003)
                             ("BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI" . 119004)
                             ("BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS" . 119005)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS" . 119006)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU" . 119007)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU" . 119008)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU" . 119009)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS" . 119010)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU" . 119011)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU" . 119012)
                             ("BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU" . 119013)
                             ("BYZANTINE MUSICAL SYMBOL DIGRAMMA GG" . 119014)
                             ("BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU" . 119015)
                             ("BYZANTINE MUSICAL SYMBOL STIGMA" . 119016)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO PA" . 119017)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO VOU" . 119018)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO GA" . 119019)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO DI" . 119020)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO KE" . 119021)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO ZO" . 119022)
                             ("BYZANTINE MUSICAL SYMBOL ARKTIKO NI" . 119023)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO" . 119024)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO" . 119025)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO" . 119026)
                             ("BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO" . 119027)
                             ("BYZANTINE MUSICAL SYMBOL KLASMA KATO" . 119028)
                             ("BYZANTINE MUSICAL SYMBOL GORGON NEO KATO" . 119029)
                             ("MUSICAL SYMBOL SINGLE BARLINE" . 119040)
                             ("MUSICAL SYMBOL DOUBLE BARLINE" . 119041)
                             ("MUSICAL SYMBOL FINAL BARLINE" . 119042)
                             ("MUSICAL SYMBOL REVERSE FINAL BARLINE" . 119043)
                             ("MUSICAL SYMBOL DASHED BARLINE" . 119044)
                             ("MUSICAL SYMBOL SHORT BARLINE" . 119045)
                             ("MUSICAL SYMBOL LEFT REPEAT SIGN" . 119046)
                             ("MUSICAL SYMBOL RIGHT REPEAT SIGN" . 119047)
                             ("MUSICAL SYMBOL REPEAT DOTS" . 119048)
                             ("MUSICAL SYMBOL DAL SEGNO" . 119049)
                             ("MUSICAL SYMBOL DA CAPO" . 119050)
                             ("MUSICAL SYMBOL SEGNO" . 119051)
                             ("MUSICAL SYMBOL CODA" . 119052)
                             ("MUSICAL SYMBOL REPEATED FIGURE-1" . 119053)
                             ("MUSICAL SYMBOL REPEATED FIGURE-2" . 119054)
                             ("MUSICAL SYMBOL REPEATED FIGURE-3" . 119055)
                             ("MUSICAL SYMBOL FERMATA" . 119056)
                             ("MUSICAL SYMBOL FERMATA BELOW" . 119057)
                             ("MUSICAL SYMBOL BREATH MARK" . 119058)
                             ("MUSICAL SYMBOL CAESURA" . 119059)
                             ("MUSICAL SYMBOL BRACE" . 119060)
                             ("MUSICAL SYMBOL BRACKET" . 119061)
                             ("MUSICAL SYMBOL ONE-LINE STAFF" . 119062)
                             ("MUSICAL SYMBOL TWO-LINE STAFF" . 119063)
                             ("MUSICAL SYMBOL THREE-LINE STAFF" . 119064)
                             ("MUSICAL SYMBOL FOUR-LINE STAFF" . 119065)
                             ("MUSICAL SYMBOL FIVE-LINE STAFF" . 119066)
                             ("MUSICAL SYMBOL SIX-LINE STAFF" . 119067)
                             ("MUSICAL SYMBOL SIX-STRING FRETBOARD" . 119068)
                             ("MUSICAL SYMBOL FOUR-STRING FRETBOARD" . 119069)
                             ("MUSICAL SYMBOL G CLEF" . 119070)
                             ("MUSICAL SYMBOL G CLEF OTTAVA ALTA" . 119071)
                             ("MUSICAL SYMBOL G CLEF OTTAVA BASSA" . 119072)
                             ("MUSICAL SYMBOL C CLEF" . 119073)
                             ("MUSICAL SYMBOL F CLEF" . 119074)
                             ("MUSICAL SYMBOL F CLEF OTTAVA ALTA" . 119075)
                             ("MUSICAL SYMBOL F CLEF OTTAVA BASSA" . 119076)
                             ("MUSICAL SYMBOL DRUM CLEF-1" . 119077)
                             ("MUSICAL SYMBOL DRUM CLEF-2" . 119078)
                             ("MUSICAL SYMBOL DOUBLE SHARP" . 119082)
                             ("MUSICAL SYMBOL DOUBLE FLAT" . 119083)
                             ("MUSICAL SYMBOL FLAT UP" . 119084)
                             ("MUSICAL SYMBOL FLAT DOWN" . 119085)
                             ("MUSICAL SYMBOL NATURAL UP" . 119086)
                             ("MUSICAL SYMBOL NATURAL DOWN" . 119087)
                             ("MUSICAL SYMBOL SHARP UP" . 119088)
                             ("MUSICAL SYMBOL SHARP DOWN" . 119089)
                             ("MUSICAL SYMBOL QUARTER TONE SHARP" . 119090)
                             ("MUSICAL SYMBOL QUARTER TONE FLAT" . 119091)
                             ("MUSICAL SYMBOL COMMON TIME" . 119092)
                             ("MUSICAL SYMBOL CUT TIME" . 119093)
                             ("MUSICAL SYMBOL OTTAVA ALTA" . 119094)
                             ("MUSICAL SYMBOL OTTAVA BASSA" . 119095)
                             ("MUSICAL SYMBOL QUINDICESIMA ALTA" . 119096)
                             ("MUSICAL SYMBOL QUINDICESIMA BASSA" . 119097)
                             ("MUSICAL SYMBOL MULTI REST" . 119098)
                             ("MUSICAL SYMBOL WHOLE REST" . 119099)
                             ("MUSICAL SYMBOL HALF REST" . 119100)
                             ("MUSICAL SYMBOL QUARTER REST" . 119101)
                             ("MUSICAL SYMBOL EIGHTH REST" . 119102)
                             ("MUSICAL SYMBOL SIXTEENTH REST" . 119103)
                             ("MUSICAL SYMBOL THIRTY-SECOND REST" . 119104)
                             ("MUSICAL SYMBOL SIXTY-FOURTH REST" . 119105)
                             ("MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST" . 119106)
                             ("MUSICAL SYMBOL X NOTEHEAD" . 119107)
                             ("MUSICAL SYMBOL PLUS NOTEHEAD" . 119108)
                             ("MUSICAL SYMBOL CIRCLE X NOTEHEAD" . 119109)
                             ("MUSICAL SYMBOL SQUARE NOTEHEAD WHITE" . 119110)
                             ("MUSICAL SYMBOL SQUARE NOTEHEAD BLACK" . 119111)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD UP WHITE" . 119112)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACK" . 119113)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITE" . 119114)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACK" . 119115)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITE" . 119116)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BLACK" . 119117)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITE" . 119118)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACK" . 119119)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITE" . 119120)
                             ("MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACK" . 119121)
                             ("MUSICAL SYMBOL MOON NOTEHEAD WHITE" . 119122)
                             ("MUSICAL SYMBOL MOON NOTEHEAD BLACK" . 119123)
                             ("MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITE" . 119124)
                             ("MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACK" . 119125)
                             ("MUSICAL SYMBOL PARENTHESIS NOTEHEAD" . 119126)
                             ("MUSICAL SYMBOL VOID NOTEHEAD" . 119127)
                             ("MUSICAL SYMBOL NOTEHEAD BLACK" . 119128)
                             ("MUSICAL SYMBOL NULL NOTEHEAD" . 119129)
                             ("MUSICAL SYMBOL CLUSTER NOTEHEAD WHITE" . 119130)
                             ("MUSICAL SYMBOL CLUSTER NOTEHEAD BLACK" . 119131)
                             ("MUSICAL SYMBOL BREVE" . 119132)
                             ("MUSICAL SYMBOL WHOLE NOTE" . 119133)
                             ("MUSICAL SYMBOL HALF NOTE" . 119134)
                             ("MUSICAL SYMBOL QUARTER NOTE" . 119135)
                             ("MUSICAL SYMBOL EIGHTH NOTE" . 119136)
                             ("MUSICAL SYMBOL SIXTEENTH NOTE" . 119137)
                             ("MUSICAL SYMBOL THIRTY-SECOND NOTE" . 119138)
                             ("MUSICAL SYMBOL SIXTY-FOURTH NOTE" . 119139)
                             ("MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE" . 119140)
                             ("MUSICAL SYMBOL COMBINING STEM" . 119141)
                             ("MUSICAL SYMBOL COMBINING SPRECHGESANG STEM" . 119142)
                             ("MUSICAL SYMBOL COMBINING TREMOLO-1" . 119143)
                             ("MUSICAL SYMBOL COMBINING TREMOLO-2" . 119144)
                             ("MUSICAL SYMBOL COMBINING TREMOLO-3" . 119145)
                             ("MUSICAL SYMBOL FINGERED TREMOLO-1" . 119146)
                             ("MUSICAL SYMBOL FINGERED TREMOLO-2" . 119147)
                             ("MUSICAL SYMBOL FINGERED TREMOLO-3" . 119148)
                             ("MUSICAL SYMBOL COMBINING AUGMENTATION DOT" . 119149)
                             ("MUSICAL SYMBOL COMBINING FLAG-1" . 119150)
                             ("MUSICAL SYMBOL COMBINING FLAG-2" . 119151)
                             ("MUSICAL SYMBOL COMBINING FLAG-3" . 119152)
                             ("MUSICAL SYMBOL COMBINING FLAG-4" . 119153)
                             ("MUSICAL SYMBOL COMBINING FLAG-5" . 119154)
                             ("MUSICAL SYMBOL BEGIN BEAM" . 119155)
                             ("MUSICAL SYMBOL END BEAM" . 119156)
                             ("MUSICAL SYMBOL BEGIN TIE" . 119157)
                             ("MUSICAL SYMBOL END TIE" . 119158)
                             ("MUSICAL SYMBOL BEGIN SLUR" . 119159)
                             ("MUSICAL SYMBOL END SLUR" . 119160)
                             ("MUSICAL SYMBOL BEGIN PHRASE" . 119161)
                             ("MUSICAL SYMBOL END PHRASE" . 119162)
                             ("MUSICAL SYMBOL COMBINING ACCENT" . 119163)
                             ("MUSICAL SYMBOL COMBINING STACCATO" . 119164)
                             ("MUSICAL SYMBOL COMBINING TENUTO" . 119165)
                             ("MUSICAL SYMBOL COMBINING STACCATISSIMO" . 119166)
                             ("MUSICAL SYMBOL COMBINING MARCATO" . 119167)
                             ("MUSICAL SYMBOL COMBINING MARCATO-STACCATO" . 119168)
                             ("MUSICAL SYMBOL COMBINING ACCENT-STACCATO" . 119169)
                             ("MUSICAL SYMBOL COMBINING LOURE" . 119170)
                             ("MUSICAL SYMBOL ARPEGGIATO UP" . 119171)
                             ("MUSICAL SYMBOL ARPEGGIATO DOWN" . 119172)
                             ("MUSICAL SYMBOL COMBINING DOIT" . 119173)
                             ("MUSICAL SYMBOL COMBINING RIP" . 119174)
                             ("MUSICAL SYMBOL COMBINING FLIP" . 119175)
                             ("MUSICAL SYMBOL COMBINING SMEAR" . 119176)
                             ("MUSICAL SYMBOL COMBINING BEND" . 119177)
                             ("MUSICAL SYMBOL COMBINING DOUBLE TONGUE" . 119178)
                             ("MUSICAL SYMBOL COMBINING TRIPLE TONGUE" . 119179)
                             ("MUSICAL SYMBOL RINFORZANDO" . 119180)
                             ("MUSICAL SYMBOL SUBITO" . 119181)
                             ("MUSICAL SYMBOL Z" . 119182)
                             ("MUSICAL SYMBOL PIANO" . 119183)
                             ("MUSICAL SYMBOL MEZZO" . 119184)
                             ("MUSICAL SYMBOL FORTE" . 119185)
                             ("MUSICAL SYMBOL CRESCENDO" . 119186)
                             ("MUSICAL SYMBOL DECRESCENDO" . 119187)
                             ("MUSICAL SYMBOL GRACE NOTE SLASH" . 119188)
                             ("MUSICAL SYMBOL GRACE NOTE NO SLASH" . 119189)
                             ("MUSICAL SYMBOL TR" . 119190)
                             ("MUSICAL SYMBOL TURN" . 119191)
                             ("MUSICAL SYMBOL INVERTED TURN" . 119192)
                             ("MUSICAL SYMBOL TURN SLASH" . 119193)
                             ("MUSICAL SYMBOL TURN UP" . 119194)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-1" . 119195)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-2" . 119196)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-3" . 119197)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-4" . 119198)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-5" . 119199)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-6" . 119200)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-7" . 119201)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-8" . 119202)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-9" . 119203)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-10" . 119204)
                             ("MUSICAL SYMBOL ORNAMENT STROKE-11" . 119205)
                             ("MUSICAL SYMBOL HAUPTSTIMME" . 119206)
                             ("MUSICAL SYMBOL NEBENSTIMME" . 119207)
                             ("MUSICAL SYMBOL END OF STIMME" . 119208)
                             ("MUSICAL SYMBOL DEGREE SLASH" . 119209)
                             ("MUSICAL SYMBOL COMBINING DOWN BOW" . 119210)
                             ("MUSICAL SYMBOL COMBINING UP BOW" . 119211)
                             ("MUSICAL SYMBOL COMBINING HARMONIC" . 119212)
                             ("MUSICAL SYMBOL COMBINING SNAP PIZZICATO" . 119213)
                             ("MUSICAL SYMBOL PEDAL MARK" . 119214)
                             ("MUSICAL SYMBOL PEDAL UP MARK" . 119215)
                             ("MUSICAL SYMBOL HALF PEDAL MARK" . 119216)
                             ("MUSICAL SYMBOL GLISSANDO UP" . 119217)
                             ("MUSICAL SYMBOL GLISSANDO DOWN" . 119218)
                             ("MUSICAL SYMBOL WITH FINGERNAILS" . 119219)
                             ("MUSICAL SYMBOL DAMP" . 119220)
                             ("MUSICAL SYMBOL DAMP ALL" . 119221)
                             ("MUSICAL SYMBOL MAXIMA" . 119222)
                             ("MUSICAL SYMBOL LONGA" . 119223)
                             ("MUSICAL SYMBOL BREVIS" . 119224)
                             ("MUSICAL SYMBOL SEMIBREVIS WHITE" . 119225)
                             ("MUSICAL SYMBOL SEMIBREVIS BLACK" . 119226)
                             ("MUSICAL SYMBOL MINIMA" . 119227)
                             ("MUSICAL SYMBOL MINIMA BLACK" . 119228)
                             ("MUSICAL SYMBOL SEMIMINIMA WHITE" . 119229)
                             ("MUSICAL SYMBOL SEMIMINIMA BLACK" . 119230)
                             ("MUSICAL SYMBOL FUSA WHITE" . 119231)
                             ("MUSICAL SYMBOL FUSA BLACK" . 119232)
                             ("MUSICAL SYMBOL LONGA PERFECTA REST" . 119233)
                             ("MUSICAL SYMBOL LONGA IMPERFECTA REST" . 119234)
                             ("MUSICAL SYMBOL BREVIS REST" . 119235)
                             ("MUSICAL SYMBOL SEMIBREVIS REST" . 119236)
                             ("MUSICAL SYMBOL MINIMA REST" . 119237)
                             ("MUSICAL SYMBOL SEMIMINIMA REST" . 119238)
                             ("MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA" . 119239)
                             ("MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTA" . 119240)
                             ("MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIMINUTION-1" . 119241)
                             ("MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTA" . 119242)
                             ("MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA" . 119243)
                             ("MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1" . 119244)
                             ("MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2" . 119245)
                             ("MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3" . 119246)
                             ("MUSICAL SYMBOL CROIX" . 119247)
                             ("MUSICAL SYMBOL GREGORIAN C CLEF" . 119248)
                             ("MUSICAL SYMBOL GREGORIAN F CLEF" . 119249)
                             ("MUSICAL SYMBOL SQUARE B" . 119250)
                             ("MUSICAL SYMBOL VIRGA" . 119251)
                             ("MUSICAL SYMBOL PODATUS" . 119252)
                             ("MUSICAL SYMBOL CLIVIS" . 119253)
                             ("MUSICAL SYMBOL SCANDICUS" . 119254)
                             ("MUSICAL SYMBOL CLIMACUS" . 119255)
                             ("MUSICAL SYMBOL TORCULUS" . 119256)
                             ("MUSICAL SYMBOL PORRECTUS" . 119257)
                             ("MUSICAL SYMBOL PORRECTUS FLEXUS" . 119258)
                             ("MUSICAL SYMBOL SCANDICUS FLEXUS" . 119259)
                             ("MUSICAL SYMBOL TORCULUS RESUPINUS" . 119260)
                             ("MUSICAL SYMBOL PES SUBPUNCTIS" . 119261)
                             ("MATHEMATICAL BOLD CAPITAL A" . 119808)
                             ("MATHEMATICAL BOLD CAPITAL B" . 119809)
                             ("MATHEMATICAL BOLD CAPITAL C" . 119810)
                             ("MATHEMATICAL BOLD CAPITAL D" . 119811)
                             ("MATHEMATICAL BOLD CAPITAL E" . 119812)
                             ("MATHEMATICAL BOLD CAPITAL F" . 119813)
                             ("MATHEMATICAL BOLD CAPITAL G" . 119814)
                             ("MATHEMATICAL BOLD CAPITAL H" . 119815)
                             ("MATHEMATICAL BOLD CAPITAL I" . 119816)
                             ("MATHEMATICAL BOLD CAPITAL J" . 119817)
                             ("MATHEMATICAL BOLD CAPITAL K" . 119818)
                             ("MATHEMATICAL BOLD CAPITAL L" . 119819)
                             ("MATHEMATICAL BOLD CAPITAL M" . 119820)
                             ("MATHEMATICAL BOLD CAPITAL N" . 119821)
                             ("MATHEMATICAL BOLD CAPITAL O" . 119822)
                             ("MATHEMATICAL BOLD CAPITAL P" . 119823)
                             ("MATHEMATICAL BOLD CAPITAL Q" . 119824)
                             ("MATHEMATICAL BOLD CAPITAL R" . 119825)
                             ("MATHEMATICAL BOLD CAPITAL S" . 119826)
                             ("MATHEMATICAL BOLD CAPITAL T" . 119827)
                             ("MATHEMATICAL BOLD CAPITAL U" . 119828)
                             ("MATHEMATICAL BOLD CAPITAL V" . 119829)
                             ("MATHEMATICAL BOLD CAPITAL W" . 119830)
                             ("MATHEMATICAL BOLD CAPITAL X" . 119831)
                             ("MATHEMATICAL BOLD CAPITAL Y" . 119832)
                             ("MATHEMATICAL BOLD CAPITAL Z" . 119833)
                             ("MATHEMATICAL BOLD SMALL A" . 119834)
                             ("MATHEMATICAL BOLD SMALL B" . 119835)
                             ("MATHEMATICAL BOLD SMALL C" . 119836)
                             ("MATHEMATICAL BOLD SMALL D" . 119837)
                             ("MATHEMATICAL BOLD SMALL E" . 119838)
                             ("MATHEMATICAL BOLD SMALL F" . 119839)
                             ("MATHEMATICAL BOLD SMALL G" . 119840)
                             ("MATHEMATICAL BOLD SMALL H" . 119841)
                             ("MATHEMATICAL BOLD SMALL I" . 119842)
                             ("MATHEMATICAL BOLD SMALL J" . 119843)
                             ("MATHEMATICAL BOLD SMALL K" . 119844)
                             ("MATHEMATICAL BOLD SMALL L" . 119845)
                             ("MATHEMATICAL BOLD SMALL M" . 119846)
                             ("MATHEMATICAL BOLD SMALL N" . 119847)
                             ("MATHEMATICAL BOLD SMALL O" . 119848)
                             ("MATHEMATICAL BOLD SMALL P" . 119849)
                             ("MATHEMATICAL BOLD SMALL Q" . 119850)
                             ("MATHEMATICAL BOLD SMALL R" . 119851)
                             ("MATHEMATICAL BOLD SMALL S" . 119852)
                             ("MATHEMATICAL BOLD SMALL T" . 119853)
                             ("MATHEMATICAL BOLD SMALL U" . 119854)
                             ("MATHEMATICAL BOLD SMALL V" . 119855)
                             ("MATHEMATICAL BOLD SMALL W" . 119856)
                             ("MATHEMATICAL BOLD SMALL X" . 119857)
                             ("MATHEMATICAL BOLD SMALL Y" . 119858)
                             ("MATHEMATICAL BOLD SMALL Z" . 119859)
                             ("MATHEMATICAL ITALIC CAPITAL A" . 119860)
                             ("MATHEMATICAL ITALIC CAPITAL B" . 119861)
                             ("MATHEMATICAL ITALIC CAPITAL C" . 119862)
                             ("MATHEMATICAL ITALIC CAPITAL D" . 119863)
                             ("MATHEMATICAL ITALIC CAPITAL E" . 119864)
                             ("MATHEMATICAL ITALIC CAPITAL F" . 119865)
                             ("MATHEMATICAL ITALIC CAPITAL G" . 119866)
                             ("MATHEMATICAL ITALIC CAPITAL H" . 119867)
                             ("MATHEMATICAL ITALIC CAPITAL I" . 119868)
                             ("MATHEMATICAL ITALIC CAPITAL J" . 119869)
                             ("MATHEMATICAL ITALIC CAPITAL K" . 119870)
                             ("MATHEMATICAL ITALIC CAPITAL L" . 119871)
                             ("MATHEMATICAL ITALIC CAPITAL M" . 119872)
                             ("MATHEMATICAL ITALIC CAPITAL N" . 119873)
                             ("MATHEMATICAL ITALIC CAPITAL O" . 119874)
                             ("MATHEMATICAL ITALIC CAPITAL P" . 119875)
                             ("MATHEMATICAL ITALIC CAPITAL Q" . 119876)
                             ("MATHEMATICAL ITALIC CAPITAL R" . 119877)
                             ("MATHEMATICAL ITALIC CAPITAL S" . 119878)
                             ("MATHEMATICAL ITALIC CAPITAL T" . 119879)
                             ("MATHEMATICAL ITALIC CAPITAL U" . 119880)
                             ("MATHEMATICAL ITALIC CAPITAL V" . 119881)
                             ("MATHEMATICAL ITALIC CAPITAL W" . 119882)
                             ("MATHEMATICAL ITALIC CAPITAL X" . 119883)
                             ("MATHEMATICAL ITALIC CAPITAL Y" . 119884)
                             ("MATHEMATICAL ITALIC CAPITAL Z" . 119885)
                             ("MATHEMATICAL ITALIC SMALL A" . 119886)
                             ("MATHEMATICAL ITALIC SMALL B" . 119887)
                             ("MATHEMATICAL ITALIC SMALL C" . 119888)
                             ("MATHEMATICAL ITALIC SMALL D" . 119889)
                             ("MATHEMATICAL ITALIC SMALL E" . 119890)
                             ("MATHEMATICAL ITALIC SMALL F" . 119891)
                             ("MATHEMATICAL ITALIC SMALL G" . 119892)
                             ("MATHEMATICAL ITALIC SMALL I" . 119894)
                             ("MATHEMATICAL ITALIC SMALL J" . 119895)
                             ("MATHEMATICAL ITALIC SMALL K" . 119896)
                             ("MATHEMATICAL ITALIC SMALL L" . 119897)
                             ("MATHEMATICAL ITALIC SMALL M" . 119898)
                             ("MATHEMATICAL ITALIC SMALL N" . 119899)
                             ("MATHEMATICAL ITALIC SMALL O" . 119900)
                             ("MATHEMATICAL ITALIC SMALL P" . 119901)
                             ("MATHEMATICAL ITALIC SMALL Q" . 119902)
                             ("MATHEMATICAL ITALIC SMALL R" . 119903)
                             ("MATHEMATICAL ITALIC SMALL S" . 119904)
                             ("MATHEMATICAL ITALIC SMALL T" . 119905)
                             ("MATHEMATICAL ITALIC SMALL U" . 119906)
                             ("MATHEMATICAL ITALIC SMALL V" . 119907)
                             ("MATHEMATICAL ITALIC SMALL W" . 119908)
                             ("MATHEMATICAL ITALIC SMALL X" . 119909)
                             ("MATHEMATICAL ITALIC SMALL Y" . 119910)
                             ("MATHEMATICAL ITALIC SMALL Z" . 119911)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL A" . 119912)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL B" . 119913)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL C" . 119914)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL D" . 119915)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL E" . 119916)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL F" . 119917)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL G" . 119918)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL H" . 119919)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL I" . 119920)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL J" . 119921)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL K" . 119922)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL L" . 119923)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL M" . 119924)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL N" . 119925)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL O" . 119926)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL P" . 119927)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL Q" . 119928)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL R" . 119929)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL S" . 119930)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL T" . 119931)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL U" . 119932)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL V" . 119933)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL W" . 119934)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL X" . 119935)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL Y" . 119936)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL Z" . 119937)
                             ("MATHEMATICAL BOLD ITALIC SMALL A" . 119938)
                             ("MATHEMATICAL BOLD ITALIC SMALL B" . 119939)
                             ("MATHEMATICAL BOLD ITALIC SMALL C" . 119940)
                             ("MATHEMATICAL BOLD ITALIC SMALL D" . 119941)
                             ("MATHEMATICAL BOLD ITALIC SMALL E" . 119942)
                             ("MATHEMATICAL BOLD ITALIC SMALL F" . 119943)
                             ("MATHEMATICAL BOLD ITALIC SMALL G" . 119944)
                             ("MATHEMATICAL BOLD ITALIC SMALL H" . 119945)
                             ("MATHEMATICAL BOLD ITALIC SMALL I" . 119946)
                             ("MATHEMATICAL BOLD ITALIC SMALL J" . 119947)
                             ("MATHEMATICAL BOLD ITALIC SMALL K" . 119948)
                             ("MATHEMATICAL BOLD ITALIC SMALL L" . 119949)
                             ("MATHEMATICAL BOLD ITALIC SMALL M" . 119950)
                             ("MATHEMATICAL BOLD ITALIC SMALL N" . 119951)
                             ("MATHEMATICAL BOLD ITALIC SMALL O" . 119952)
                             ("MATHEMATICAL BOLD ITALIC SMALL P" . 119953)
                             ("MATHEMATICAL BOLD ITALIC SMALL Q" . 119954)
                             ("MATHEMATICAL BOLD ITALIC SMALL R" . 119955)
                             ("MATHEMATICAL BOLD ITALIC SMALL S" . 119956)
                             ("MATHEMATICAL BOLD ITALIC SMALL T" . 119957)
                             ("MATHEMATICAL BOLD ITALIC SMALL U" . 119958)
                             ("MATHEMATICAL BOLD ITALIC SMALL V" . 119959)
                             ("MATHEMATICAL BOLD ITALIC SMALL W" . 119960)
                             ("MATHEMATICAL BOLD ITALIC SMALL X" . 119961)
                             ("MATHEMATICAL BOLD ITALIC SMALL Y" . 119962)
                             ("MATHEMATICAL BOLD ITALIC SMALL Z" . 119963)
                             ("MATHEMATICAL SCRIPT CAPITAL A" . 119964)
                             ("MATHEMATICAL SCRIPT CAPITAL C" . 119966)
                             ("MATHEMATICAL SCRIPT CAPITAL D" . 119967)
                             ("MATHEMATICAL SCRIPT CAPITAL G" . 119970)
                             ("MATHEMATICAL SCRIPT CAPITAL J" . 119973)
                             ("MATHEMATICAL SCRIPT CAPITAL K" . 119974)
                             ("MATHEMATICAL SCRIPT CAPITAL N" . 119977)
                             ("MATHEMATICAL SCRIPT CAPITAL O" . 119978)
                             ("MATHEMATICAL SCRIPT CAPITAL P" . 119979)
                             ("MATHEMATICAL SCRIPT CAPITAL Q" . 119980)
                             ("MATHEMATICAL SCRIPT CAPITAL S" . 119982)
                             ("MATHEMATICAL SCRIPT CAPITAL T" . 119983)
                             ("MATHEMATICAL SCRIPT CAPITAL U" . 119984)
                             ("MATHEMATICAL SCRIPT CAPITAL V" . 119985)
                             ("MATHEMATICAL SCRIPT CAPITAL W" . 119986)
                             ("MATHEMATICAL SCRIPT CAPITAL X" . 119987)
                             ("MATHEMATICAL SCRIPT CAPITAL Y" . 119988)
                             ("MATHEMATICAL SCRIPT CAPITAL Z" . 119989)
                             ("MATHEMATICAL SCRIPT SMALL A" . 119990)
                             ("MATHEMATICAL SCRIPT SMALL B" . 119991)
                             ("MATHEMATICAL SCRIPT SMALL C" . 119992)
                             ("MATHEMATICAL SCRIPT SMALL D" . 119993)
                             ("MATHEMATICAL SCRIPT SMALL F" . 119995)
                             ("MATHEMATICAL SCRIPT SMALL H" . 119997)
                             ("MATHEMATICAL SCRIPT SMALL I" . 119998)
                             ("MATHEMATICAL SCRIPT SMALL J" . 119999)
                             ("MATHEMATICAL SCRIPT SMALL K" . 120000)
                             ("MATHEMATICAL SCRIPT SMALL M" . 120002)
                             ("MATHEMATICAL SCRIPT SMALL N" . 120003)
                             ("MATHEMATICAL SCRIPT SMALL P" . 120005)
                             ("MATHEMATICAL SCRIPT SMALL Q" . 120006)
                             ("MATHEMATICAL SCRIPT SMALL R" . 120007)
                             ("MATHEMATICAL SCRIPT SMALL S" . 120008)
                             ("MATHEMATICAL SCRIPT SMALL T" . 120009)
                             ("MATHEMATICAL SCRIPT SMALL U" . 120010)
                             ("MATHEMATICAL SCRIPT SMALL V" . 120011)
                             ("MATHEMATICAL SCRIPT SMALL W" . 120012)
                             ("MATHEMATICAL SCRIPT SMALL X" . 120013)
                             ("MATHEMATICAL SCRIPT SMALL Y" . 120014)
                             ("MATHEMATICAL SCRIPT SMALL Z" . 120015)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL A" . 120016)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL B" . 120017)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL C" . 120018)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL D" . 120019)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL E" . 120020)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL F" . 120021)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL G" . 120022)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL H" . 120023)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL I" . 120024)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL J" . 120025)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL K" . 120026)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL L" . 120027)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL M" . 120028)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL N" . 120029)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL O" . 120030)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL P" . 120031)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL Q" . 120032)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL R" . 120033)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL S" . 120034)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL T" . 120035)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL U" . 120036)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL V" . 120037)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL W" . 120038)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL X" . 120039)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL Y" . 120040)
                             ("MATHEMATICAL BOLD SCRIPT CAPITAL Z" . 120041)
                             ("MATHEMATICAL BOLD SCRIPT SMALL A" . 120042)
                             ("MATHEMATICAL BOLD SCRIPT SMALL B" . 120043)
                             ("MATHEMATICAL BOLD SCRIPT SMALL C" . 120044)
                             ("MATHEMATICAL BOLD SCRIPT SMALL D" . 120045)
                             ("MATHEMATICAL BOLD SCRIPT SMALL E" . 120046)
                             ("MATHEMATICAL BOLD SCRIPT SMALL F" . 120047)
                             ("MATHEMATICAL BOLD SCRIPT SMALL G" . 120048)
                             ("MATHEMATICAL BOLD SCRIPT SMALL H" . 120049)
                             ("MATHEMATICAL BOLD SCRIPT SMALL I" . 120050)
                             ("MATHEMATICAL BOLD SCRIPT SMALL J" . 120051)
                             ("MATHEMATICAL BOLD SCRIPT SMALL K" . 120052)
                             ("MATHEMATICAL BOLD SCRIPT SMALL L" . 120053)
                             ("MATHEMATICAL BOLD SCRIPT SMALL M" . 120054)
                             ("MATHEMATICAL BOLD SCRIPT SMALL N" . 120055)
                             ("MATHEMATICAL BOLD SCRIPT SMALL O" . 120056)
                             ("MATHEMATICAL BOLD SCRIPT SMALL P" . 120057)
                             ("MATHEMATICAL BOLD SCRIPT SMALL Q" . 120058)
                             ("MATHEMATICAL BOLD SCRIPT SMALL R" . 120059)
                             ("MATHEMATICAL BOLD SCRIPT SMALL S" . 120060)
                             ("MATHEMATICAL BOLD SCRIPT SMALL T" . 120061)
                             ("MATHEMATICAL BOLD SCRIPT SMALL U" . 120062)
                             ("MATHEMATICAL BOLD SCRIPT SMALL V" . 120063)
                             ("MATHEMATICAL BOLD SCRIPT SMALL W" . 120064)
                             ("MATHEMATICAL BOLD SCRIPT SMALL X" . 120065)
                             ("MATHEMATICAL BOLD SCRIPT SMALL Y" . 120066)
                             ("MATHEMATICAL BOLD SCRIPT SMALL Z" . 120067)
                             ("MATHEMATICAL FRAKTUR CAPITAL A" . 120068)
                             ("MATHEMATICAL FRAKTUR CAPITAL B" . 120069)
                             ("MATHEMATICAL FRAKTUR CAPITAL D" . 120071)
                             ("MATHEMATICAL FRAKTUR CAPITAL E" . 120072)
                             ("MATHEMATICAL FRAKTUR CAPITAL F" . 120073)
                             ("MATHEMATICAL FRAKTUR CAPITAL G" . 120074)
                             ("MATHEMATICAL FRAKTUR CAPITAL J" . 120077)
                             ("MATHEMATICAL FRAKTUR CAPITAL K" . 120078)
                             ("MATHEMATICAL FRAKTUR CAPITAL L" . 120079)
                             ("MATHEMATICAL FRAKTUR CAPITAL M" . 120080)
                             ("MATHEMATICAL FRAKTUR CAPITAL N" . 120081)
                             ("MATHEMATICAL FRAKTUR CAPITAL O" . 120082)
                             ("MATHEMATICAL FRAKTUR CAPITAL P" . 120083)
                             ("MATHEMATICAL FRAKTUR CAPITAL Q" . 120084)
                             ("MATHEMATICAL FRAKTUR CAPITAL S" . 120086)
                             ("MATHEMATICAL FRAKTUR CAPITAL T" . 120087)
                             ("MATHEMATICAL FRAKTUR CAPITAL U" . 120088)
                             ("MATHEMATICAL FRAKTUR CAPITAL V" . 120089)
                             ("MATHEMATICAL FRAKTUR CAPITAL W" . 120090)
                             ("MATHEMATICAL FRAKTUR CAPITAL X" . 120091)
                             ("MATHEMATICAL FRAKTUR CAPITAL Y" . 120092)
                             ("MATHEMATICAL FRAKTUR SMALL A" . 120094)
                             ("MATHEMATICAL FRAKTUR SMALL B" . 120095)
                             ("MATHEMATICAL FRAKTUR SMALL C" . 120096)
                             ("MATHEMATICAL FRAKTUR SMALL D" . 120097)
                             ("MATHEMATICAL FRAKTUR SMALL E" . 120098)
                             ("MATHEMATICAL FRAKTUR SMALL F" . 120099)
                             ("MATHEMATICAL FRAKTUR SMALL G" . 120100)
                             ("MATHEMATICAL FRAKTUR SMALL H" . 120101)
                             ("MATHEMATICAL FRAKTUR SMALL I" . 120102)
                             ("MATHEMATICAL FRAKTUR SMALL J" . 120103)
                             ("MATHEMATICAL FRAKTUR SMALL K" . 120104)
                             ("MATHEMATICAL FRAKTUR SMALL L" . 120105)
                             ("MATHEMATICAL FRAKTUR SMALL M" . 120106)
                             ("MATHEMATICAL FRAKTUR SMALL N" . 120107)
                             ("MATHEMATICAL FRAKTUR SMALL O" . 120108)
                             ("MATHEMATICAL FRAKTUR SMALL P" . 120109)
                             ("MATHEMATICAL FRAKTUR SMALL Q" . 120110)
                             ("MATHEMATICAL FRAKTUR SMALL R" . 120111)
                             ("MATHEMATICAL FRAKTUR SMALL S" . 120112)
                             ("MATHEMATICAL FRAKTUR SMALL T" . 120113)
                             ("MATHEMATICAL FRAKTUR SMALL U" . 120114)
                             ("MATHEMATICAL FRAKTUR SMALL V" . 120115)
                             ("MATHEMATICAL FRAKTUR SMALL W" . 120116)
                             ("MATHEMATICAL FRAKTUR SMALL X" . 120117)
                             ("MATHEMATICAL FRAKTUR SMALL Y" . 120118)
                             ("MATHEMATICAL FRAKTUR SMALL Z" . 120119)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL A" . 120120)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL B" . 120121)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL D" . 120123)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL E" . 120124)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL F" . 120125)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL G" . 120126)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL I" . 120128)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL J" . 120129)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL K" . 120130)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL L" . 120131)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL M" . 120132)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL O" . 120134)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL S" . 120138)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL T" . 120139)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL U" . 120140)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL V" . 120141)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL W" . 120142)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL X" . 120143)
                             ("MATHEMATICAL DOUBLE-STRUCK CAPITAL Y" . 120144)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL A" . 120146)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL B" . 120147)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL C" . 120148)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL D" . 120149)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL E" . 120150)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL F" . 120151)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL G" . 120152)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL H" . 120153)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL I" . 120154)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL J" . 120155)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL K" . 120156)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL L" . 120157)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL M" . 120158)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL N" . 120159)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL O" . 120160)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL P" . 120161)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL Q" . 120162)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL R" . 120163)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL S" . 120164)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL T" . 120165)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL U" . 120166)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL V" . 120167)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL W" . 120168)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL X" . 120169)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL Y" . 120170)
                             ("MATHEMATICAL DOUBLE-STRUCK SMALL Z" . 120171)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL A" . 120172)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL B" . 120173)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL C" . 120174)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL D" . 120175)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL E" . 120176)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL F" . 120177)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL G" . 120178)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL H" . 120179)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL I" . 120180)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL J" . 120181)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL K" . 120182)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL L" . 120183)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL M" . 120184)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL N" . 120185)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL O" . 120186)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL P" . 120187)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL Q" . 120188)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL R" . 120189)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL S" . 120190)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL T" . 120191)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL U" . 120192)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL V" . 120193)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL W" . 120194)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL X" . 120195)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL Y" . 120196)
                             ("MATHEMATICAL BOLD FRAKTUR CAPITAL Z" . 120197)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL A" . 120198)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL B" . 120199)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL C" . 120200)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL D" . 120201)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL E" . 120202)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL F" . 120203)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL G" . 120204)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL H" . 120205)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL I" . 120206)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL J" . 120207)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL K" . 120208)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL L" . 120209)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL M" . 120210)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL N" . 120211)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL O" . 120212)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL P" . 120213)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL Q" . 120214)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL R" . 120215)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL S" . 120216)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL T" . 120217)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL U" . 120218)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL V" . 120219)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL W" . 120220)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL X" . 120221)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL Y" . 120222)
                             ("MATHEMATICAL BOLD FRAKTUR SMALL Z" . 120223)
                             ("MATHEMATICAL SANS-SERIF CAPITAL A" . 120224)
                             ("MATHEMATICAL SANS-SERIF CAPITAL B" . 120225)
                             ("MATHEMATICAL SANS-SERIF CAPITAL C" . 120226)
                             ("MATHEMATICAL SANS-SERIF CAPITAL D" . 120227)
                             ("MATHEMATICAL SANS-SERIF CAPITAL E" . 120228)
                             ("MATHEMATICAL SANS-SERIF CAPITAL F" . 120229)
                             ("MATHEMATICAL SANS-SERIF CAPITAL G" . 120230)
                             ("MATHEMATICAL SANS-SERIF CAPITAL H" . 120231)
                             ("MATHEMATICAL SANS-SERIF CAPITAL I" . 120232)
                             ("MATHEMATICAL SANS-SERIF CAPITAL J" . 120233)
                             ("MATHEMATICAL SANS-SERIF CAPITAL K" . 120234)
                             ("MATHEMATICAL SANS-SERIF CAPITAL L" . 120235)
                             ("MATHEMATICAL SANS-SERIF CAPITAL M" . 120236)
                             ("MATHEMATICAL SANS-SERIF CAPITAL N" . 120237)
                             ("MATHEMATICAL SANS-SERIF CAPITAL O" . 120238)
                             ("MATHEMATICAL SANS-SERIF CAPITAL P" . 120239)
                             ("MATHEMATICAL SANS-SERIF CAPITAL Q" . 120240)
                             ("MATHEMATICAL SANS-SERIF CAPITAL R" . 120241)
                             ("MATHEMATICAL SANS-SERIF CAPITAL S" . 120242)
                             ("MATHEMATICAL SANS-SERIF CAPITAL T" . 120243)
                             ("MATHEMATICAL SANS-SERIF CAPITAL U" . 120244)
                             ("MATHEMATICAL SANS-SERIF CAPITAL V" . 120245)
                             ("MATHEMATICAL SANS-SERIF CAPITAL W" . 120246)
                             ("MATHEMATICAL SANS-SERIF CAPITAL X" . 120247)
                             ("MATHEMATICAL SANS-SERIF CAPITAL Y" . 120248)
                             ("MATHEMATICAL SANS-SERIF CAPITAL Z" . 120249)
                             ("MATHEMATICAL SANS-SERIF SMALL A" . 120250)
                             ("MATHEMATICAL SANS-SERIF SMALL B" . 120251)
                             ("MATHEMATICAL SANS-SERIF SMALL C" . 120252)
                             ("MATHEMATICAL SANS-SERIF SMALL D" . 120253)
                             ("MATHEMATICAL SANS-SERIF SMALL E" . 120254)
                             ("MATHEMATICAL SANS-SERIF SMALL F" . 120255)
                             ("MATHEMATICAL SANS-SERIF SMALL G" . 120256)
                             ("MATHEMATICAL SANS-SERIF SMALL H" . 120257)
                             ("MATHEMATICAL SANS-SERIF SMALL I" . 120258)
                             ("MATHEMATICAL SANS-SERIF SMALL J" . 120259)
                             ("MATHEMATICAL SANS-SERIF SMALL K" . 120260)
                             ("MATHEMATICAL SANS-SERIF SMALL L" . 120261)
                             ("MATHEMATICAL SANS-SERIF SMALL M" . 120262)
                             ("MATHEMATICAL SANS-SERIF SMALL N" . 120263)
                             ("MATHEMATICAL SANS-SERIF SMALL O" . 120264)
                             ("MATHEMATICAL SANS-SERIF SMALL P" . 120265)
                             ("MATHEMATICAL SANS-SERIF SMALL Q" . 120266)
                             ("MATHEMATICAL SANS-SERIF SMALL R" . 120267)
                             ("MATHEMATICAL SANS-SERIF SMALL S" . 120268)
                             ("MATHEMATICAL SANS-SERIF SMALL T" . 120269)
                             ("MATHEMATICAL SANS-SERIF SMALL U" . 120270)
                             ("MATHEMATICAL SANS-SERIF SMALL V" . 120271)
                             ("MATHEMATICAL SANS-SERIF SMALL W" . 120272)
                             ("MATHEMATICAL SANS-SERIF SMALL X" . 120273)
                             ("MATHEMATICAL SANS-SERIF SMALL Y" . 120274)
                             ("MATHEMATICAL SANS-SERIF SMALL Z" . 120275)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL A" . 120276)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL B" . 120277)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL C" . 120278)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL D" . 120279)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL E" . 120280)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL F" . 120281)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL G" . 120282)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL H" . 120283)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL I" . 120284)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL J" . 120285)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL K" . 120286)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL L" . 120287)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL M" . 120288)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL N" . 120289)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL O" . 120290)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL P" . 120291)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Q" . 120292)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL R" . 120293)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL S" . 120294)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL T" . 120295)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL U" . 120296)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL V" . 120297)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL W" . 120298)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL X" . 120299)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Y" . 120300)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL Z" . 120301)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL A" . 120302)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL B" . 120303)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL C" . 120304)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL D" . 120305)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL E" . 120306)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL F" . 120307)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL G" . 120308)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL H" . 120309)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL I" . 120310)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL J" . 120311)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL K" . 120312)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL L" . 120313)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL M" . 120314)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL N" . 120315)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL O" . 120316)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL P" . 120317)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL Q" . 120318)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL R" . 120319)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL S" . 120320)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL T" . 120321)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL U" . 120322)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL V" . 120323)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL W" . 120324)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL X" . 120325)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL Y" . 120326)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL Z" . 120327)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL A" . 120328)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL B" . 120329)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL C" . 120330)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL D" . 120331)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL E" . 120332)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL F" . 120333)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL G" . 120334)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL H" . 120335)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL I" . 120336)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL J" . 120337)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL K" . 120338)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL L" . 120339)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL M" . 120340)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL N" . 120341)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL O" . 120342)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL P" . 120343)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q" . 120344)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL R" . 120345)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL S" . 120346)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL T" . 120347)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL U" . 120348)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL V" . 120349)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL W" . 120350)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL X" . 120351)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y" . 120352)
                             ("MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z" . 120353)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL A" . 120354)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL B" . 120355)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL C" . 120356)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL D" . 120357)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL E" . 120358)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL F" . 120359)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL G" . 120360)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL H" . 120361)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL I" . 120362)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL J" . 120363)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL K" . 120364)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL L" . 120365)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL M" . 120366)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL N" . 120367)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL O" . 120368)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL P" . 120369)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL Q" . 120370)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL R" . 120371)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL S" . 120372)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL T" . 120373)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL U" . 120374)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL V" . 120375)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL W" . 120376)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL X" . 120377)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL Y" . 120378)
                             ("MATHEMATICAL SANS-SERIF ITALIC SMALL Z" . 120379)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A" . 120380)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B" . 120381)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C" . 120382)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D" . 120383)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E" . 120384)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F" . 120385)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G" . 120386)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H" . 120387)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I" . 120388)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J" . 120389)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K" . 120390)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L" . 120391)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M" . 120392)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N" . 120393)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O" . 120394)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P" . 120395)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q" . 120396)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R" . 120397)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S" . 120398)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T" . 120399)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U" . 120400)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V" . 120401)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W" . 120402)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X" . 120403)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y" . 120404)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z" . 120405)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A" . 120406)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B" . 120407)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C" . 120408)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D" . 120409)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E" . 120410)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F" . 120411)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G" . 120412)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H" . 120413)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I" . 120414)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J" . 120415)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K" . 120416)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L" . 120417)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M" . 120418)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N" . 120419)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O" . 120420)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P" . 120421)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q" . 120422)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R" . 120423)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S" . 120424)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T" . 120425)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U" . 120426)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V" . 120427)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W" . 120428)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X" . 120429)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y" . 120430)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z" . 120431)
                             ("MATHEMATICAL MONOSPACE CAPITAL A" . 120432)
                             ("MATHEMATICAL MONOSPACE CAPITAL B" . 120433)
                             ("MATHEMATICAL MONOSPACE CAPITAL C" . 120434)
                             ("MATHEMATICAL MONOSPACE CAPITAL D" . 120435)
                             ("MATHEMATICAL MONOSPACE CAPITAL E" . 120436)
                             ("MATHEMATICAL MONOSPACE CAPITAL F" . 120437)
                             ("MATHEMATICAL MONOSPACE CAPITAL G" . 120438)
                             ("MATHEMATICAL MONOSPACE CAPITAL H" . 120439)
                             ("MATHEMATICAL MONOSPACE CAPITAL I" . 120440)
                             ("MATHEMATICAL MONOSPACE CAPITAL J" . 120441)
                             ("MATHEMATICAL MONOSPACE CAPITAL K" . 120442)
                             ("MATHEMATICAL MONOSPACE CAPITAL L" . 120443)
                             ("MATHEMATICAL MONOSPACE CAPITAL M" . 120444)
                             ("MATHEMATICAL MONOSPACE CAPITAL N" . 120445)
                             ("MATHEMATICAL MONOSPACE CAPITAL O" . 120446)
                             ("MATHEMATICAL MONOSPACE CAPITAL P" . 120447)
                             ("MATHEMATICAL MONOSPACE CAPITAL Q" . 120448)
                             ("MATHEMATICAL MONOSPACE CAPITAL R" . 120449)
                             ("MATHEMATICAL MONOSPACE CAPITAL S" . 120450)
                             ("MATHEMATICAL MONOSPACE CAPITAL T" . 120451)
                             ("MATHEMATICAL MONOSPACE CAPITAL U" . 120452)
                             ("MATHEMATICAL MONOSPACE CAPITAL V" . 120453)
                             ("MATHEMATICAL MONOSPACE CAPITAL W" . 120454)
                             ("MATHEMATICAL MONOSPACE CAPITAL X" . 120455)
                             ("MATHEMATICAL MONOSPACE CAPITAL Y" . 120456)
                             ("MATHEMATICAL MONOSPACE CAPITAL Z" . 120457)
                             ("MATHEMATICAL MONOSPACE SMALL A" . 120458)
                             ("MATHEMATICAL MONOSPACE SMALL B" . 120459)
                             ("MATHEMATICAL MONOSPACE SMALL C" . 120460)
                             ("MATHEMATICAL MONOSPACE SMALL D" . 120461)
                             ("MATHEMATICAL MONOSPACE SMALL E" . 120462)
                             ("MATHEMATICAL MONOSPACE SMALL F" . 120463)
                             ("MATHEMATICAL MONOSPACE SMALL G" . 120464)
                             ("MATHEMATICAL MONOSPACE SMALL H" . 120465)
                             ("MATHEMATICAL MONOSPACE SMALL I" . 120466)
                             ("MATHEMATICAL MONOSPACE SMALL J" . 120467)
                             ("MATHEMATICAL MONOSPACE SMALL K" . 120468)
                             ("MATHEMATICAL MONOSPACE SMALL L" . 120469)
                             ("MATHEMATICAL MONOSPACE SMALL M" . 120470)
                             ("MATHEMATICAL MONOSPACE SMALL N" . 120471)
                             ("MATHEMATICAL MONOSPACE SMALL O" . 120472)
                             ("MATHEMATICAL MONOSPACE SMALL P" . 120473)
                             ("MATHEMATICAL MONOSPACE SMALL Q" . 120474)
                             ("MATHEMATICAL MONOSPACE SMALL R" . 120475)
                             ("MATHEMATICAL MONOSPACE SMALL S" . 120476)
                             ("MATHEMATICAL MONOSPACE SMALL T" . 120477)
                             ("MATHEMATICAL MONOSPACE SMALL U" . 120478)
                             ("MATHEMATICAL MONOSPACE SMALL V" . 120479)
                             ("MATHEMATICAL MONOSPACE SMALL W" . 120480)
                             ("MATHEMATICAL MONOSPACE SMALL X" . 120481)
                             ("MATHEMATICAL MONOSPACE SMALL Y" . 120482)
                             ("MATHEMATICAL MONOSPACE SMALL Z" . 120483)
                             ("MATHEMATICAL BOLD CAPITAL ALPHA" . 120488)
                             ("MATHEMATICAL BOLD CAPITAL BETA" . 120489)
                             ("MATHEMATICAL BOLD CAPITAL GAMMA" . 120490)
                             ("MATHEMATICAL BOLD CAPITAL DELTA" . 120491)
                             ("MATHEMATICAL BOLD CAPITAL EPSILON" . 120492)
                             ("MATHEMATICAL BOLD CAPITAL ZETA" . 120493)
                             ("MATHEMATICAL BOLD CAPITAL ETA" . 120494)
                             ("MATHEMATICAL BOLD CAPITAL THETA" . 120495)
                             ("MATHEMATICAL BOLD CAPITAL IOTA" . 120496)
                             ("MATHEMATICAL BOLD CAPITAL KAPPA" . 120497)
                             ("MATHEMATICAL BOLD CAPITAL LAMDA" . 120498)
                             ("MATHEMATICAL BOLD CAPITAL MU" . 120499)
                             ("MATHEMATICAL BOLD CAPITAL NU" . 120500)
                             ("MATHEMATICAL BOLD CAPITAL XI" . 120501)
                             ("MATHEMATICAL BOLD CAPITAL OMICRON" . 120502)
                             ("MATHEMATICAL BOLD CAPITAL PI" . 120503)
                             ("MATHEMATICAL BOLD CAPITAL RHO" . 120504)
                             ("MATHEMATICAL BOLD CAPITAL THETA SYMBOL" . 120505)
                             ("MATHEMATICAL BOLD CAPITAL SIGMA" . 120506)
                             ("MATHEMATICAL BOLD CAPITAL TAU" . 120507)
                             ("MATHEMATICAL BOLD CAPITAL UPSILON" . 120508)
                             ("MATHEMATICAL BOLD CAPITAL PHI" . 120509)
                             ("MATHEMATICAL BOLD CAPITAL CHI" . 120510)
                             ("MATHEMATICAL BOLD CAPITAL PSI" . 120511)
                             ("MATHEMATICAL BOLD CAPITAL OMEGA" . 120512)
                             ("MATHEMATICAL BOLD NABLA" . 120513)
                             ("MATHEMATICAL BOLD SMALL ALPHA" . 120514)
                             ("MATHEMATICAL BOLD SMALL BETA" . 120515)
                             ("MATHEMATICAL BOLD SMALL GAMMA" . 120516)
                             ("MATHEMATICAL BOLD SMALL DELTA" . 120517)
                             ("MATHEMATICAL BOLD SMALL EPSILON" . 120518)
                             ("MATHEMATICAL BOLD SMALL ZETA" . 120519)
                             ("MATHEMATICAL BOLD SMALL ETA" . 120520)
                             ("MATHEMATICAL BOLD SMALL THETA" . 120521)
                             ("MATHEMATICAL BOLD SMALL IOTA" . 120522)
                             ("MATHEMATICAL BOLD SMALL KAPPA" . 120523)
                             ("MATHEMATICAL BOLD SMALL LAMDA" . 120524)
                             ("MATHEMATICAL BOLD SMALL MU" . 120525)
                             ("MATHEMATICAL BOLD SMALL NU" . 120526)
                             ("MATHEMATICAL BOLD SMALL XI" . 120527)
                             ("MATHEMATICAL BOLD SMALL OMICRON" . 120528)
                             ("MATHEMATICAL BOLD SMALL PI" . 120529)
                             ("MATHEMATICAL BOLD SMALL RHO" . 120530)
                             ("MATHEMATICAL BOLD SMALL FINAL SIGMA" . 120531)
                             ("MATHEMATICAL BOLD SMALL SIGMA" . 120532)
                             ("MATHEMATICAL BOLD SMALL TAU" . 120533)
                             ("MATHEMATICAL BOLD SMALL UPSILON" . 120534)
                             ("MATHEMATICAL BOLD SMALL PHI" . 120535)
                             ("MATHEMATICAL BOLD SMALL CHI" . 120536)
                             ("MATHEMATICAL BOLD SMALL PSI" . 120537)
                             ("MATHEMATICAL BOLD SMALL OMEGA" . 120538)
                             ("MATHEMATICAL BOLD PARTIAL DIFFERENTIAL" . 120539)
                             ("MATHEMATICAL BOLD EPSILON SYMBOL" . 120540)
                             ("MATHEMATICAL BOLD THETA SYMBOL" . 120541)
                             ("MATHEMATICAL BOLD KAPPA SYMBOL" . 120542)
                             ("MATHEMATICAL BOLD PHI SYMBOL" . 120543)
                             ("MATHEMATICAL BOLD RHO SYMBOL" . 120544)
                             ("MATHEMATICAL BOLD PI SYMBOL" . 120545)
                             ("MATHEMATICAL ITALIC CAPITAL ALPHA" . 120546)
                             ("MATHEMATICAL ITALIC CAPITAL BETA" . 120547)
                             ("MATHEMATICAL ITALIC CAPITAL GAMMA" . 120548)
                             ("MATHEMATICAL ITALIC CAPITAL DELTA" . 120549)
                             ("MATHEMATICAL ITALIC CAPITAL EPSILON" . 120550)
                             ("MATHEMATICAL ITALIC CAPITAL ZETA" . 120551)
                             ("MATHEMATICAL ITALIC CAPITAL ETA" . 120552)
                             ("MATHEMATICAL ITALIC CAPITAL THETA" . 120553)
                             ("MATHEMATICAL ITALIC CAPITAL IOTA" . 120554)
                             ("MATHEMATICAL ITALIC CAPITAL KAPPA" . 120555)
                             ("MATHEMATICAL ITALIC CAPITAL LAMDA" . 120556)
                             ("MATHEMATICAL ITALIC CAPITAL MU" . 120557)
                             ("MATHEMATICAL ITALIC CAPITAL NU" . 120558)
                             ("MATHEMATICAL ITALIC CAPITAL XI" . 120559)
                             ("MATHEMATICAL ITALIC CAPITAL OMICRON" . 120560)
                             ("MATHEMATICAL ITALIC CAPITAL PI" . 120561)
                             ("MATHEMATICAL ITALIC CAPITAL RHO" . 120562)
                             ("MATHEMATICAL ITALIC CAPITAL THETA SYMBOL" . 120563)
                             ("MATHEMATICAL ITALIC CAPITAL SIGMA" . 120564)
                             ("MATHEMATICAL ITALIC CAPITAL TAU" . 120565)
                             ("MATHEMATICAL ITALIC CAPITAL UPSILON" . 120566)
                             ("MATHEMATICAL ITALIC CAPITAL PHI" . 120567)
                             ("MATHEMATICAL ITALIC CAPITAL CHI" . 120568)
                             ("MATHEMATICAL ITALIC CAPITAL PSI" . 120569)
                             ("MATHEMATICAL ITALIC CAPITAL OMEGA" . 120570)
                             ("MATHEMATICAL ITALIC NABLA" . 120571)
                             ("MATHEMATICAL ITALIC SMALL ALPHA" . 120572)
                             ("MATHEMATICAL ITALIC SMALL BETA" . 120573)
                             ("MATHEMATICAL ITALIC SMALL GAMMA" . 120574)
                             ("MATHEMATICAL ITALIC SMALL DELTA" . 120575)
                             ("MATHEMATICAL ITALIC SMALL EPSILON" . 120576)
                             ("MATHEMATICAL ITALIC SMALL ZETA" . 120577)
                             ("MATHEMATICAL ITALIC SMALL ETA" . 120578)
                             ("MATHEMATICAL ITALIC SMALL THETA" . 120579)
                             ("MATHEMATICAL ITALIC SMALL IOTA" . 120580)
                             ("MATHEMATICAL ITALIC SMALL KAPPA" . 120581)
                             ("MATHEMATICAL ITALIC SMALL LAMDA" . 120582)
                             ("MATHEMATICAL ITALIC SMALL MU" . 120583)
                             ("MATHEMATICAL ITALIC SMALL NU" . 120584)
                             ("MATHEMATICAL ITALIC SMALL XI" . 120585)
                             ("MATHEMATICAL ITALIC SMALL OMICRON" . 120586)
                             ("MATHEMATICAL ITALIC SMALL PI" . 120587)
                             ("MATHEMATICAL ITALIC SMALL RHO" . 120588)
                             ("MATHEMATICAL ITALIC SMALL FINAL SIGMA" . 120589)
                             ("MATHEMATICAL ITALIC SMALL SIGMA" . 120590)
                             ("MATHEMATICAL ITALIC SMALL TAU" . 120591)
                             ("MATHEMATICAL ITALIC SMALL UPSILON" . 120592)
                             ("MATHEMATICAL ITALIC SMALL PHI" . 120593)
                             ("MATHEMATICAL ITALIC SMALL CHI" . 120594)
                             ("MATHEMATICAL ITALIC SMALL PSI" . 120595)
                             ("MATHEMATICAL ITALIC SMALL OMEGA" . 120596)
                             ("MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL" . 120597)
                             ("MATHEMATICAL ITALIC EPSILON SYMBOL" . 120598)
                             ("MATHEMATICAL ITALIC THETA SYMBOL" . 120599)
                             ("MATHEMATICAL ITALIC KAPPA SYMBOL" . 120600)
                             ("MATHEMATICAL ITALIC PHI SYMBOL" . 120601)
                             ("MATHEMATICAL ITALIC RHO SYMBOL" . 120602)
                             ("MATHEMATICAL ITALIC PI SYMBOL" . 120603)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL ALPHA" . 120604)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL BETA" . 120605)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL GAMMA" . 120606)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL DELTA" . 120607)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL EPSILON" . 120608)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL ZETA" . 120609)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL ETA" . 120610)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL THETA" . 120611)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL IOTA" . 120612)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL KAPPA" . 120613)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL LAMDA" . 120614)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL MU" . 120615)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL NU" . 120616)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL XI" . 120617)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL OMICRON" . 120618)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL PI" . 120619)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL RHO" . 120620)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL" . 120621)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL SIGMA" . 120622)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL TAU" . 120623)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL UPSILON" . 120624)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL PHI" . 120625)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL CHI" . 120626)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL PSI" . 120627)
                             ("MATHEMATICAL BOLD ITALIC CAPITAL OMEGA" . 120628)
                             ("MATHEMATICAL BOLD ITALIC NABLA" . 120629)
                             ("MATHEMATICAL BOLD ITALIC SMALL ALPHA" . 120630)
                             ("MATHEMATICAL BOLD ITALIC SMALL BETA" . 120631)
                             ("MATHEMATICAL BOLD ITALIC SMALL GAMMA" . 120632)
                             ("MATHEMATICAL BOLD ITALIC SMALL DELTA" . 120633)
                             ("MATHEMATICAL BOLD ITALIC SMALL EPSILON" . 120634)
                             ("MATHEMATICAL BOLD ITALIC SMALL ZETA" . 120635)
                             ("MATHEMATICAL BOLD ITALIC SMALL ETA" . 120636)
                             ("MATHEMATICAL BOLD ITALIC SMALL THETA" . 120637)
                             ("MATHEMATICAL BOLD ITALIC SMALL IOTA" . 120638)
                             ("MATHEMATICAL BOLD ITALIC SMALL KAPPA" . 120639)
                             ("MATHEMATICAL BOLD ITALIC SMALL LAMDA" . 120640)
                             ("MATHEMATICAL BOLD ITALIC SMALL MU" . 120641)
                             ("MATHEMATICAL BOLD ITALIC SMALL NU" . 120642)
                             ("MATHEMATICAL BOLD ITALIC SMALL XI" . 120643)
                             ("MATHEMATICAL BOLD ITALIC SMALL OMICRON" . 120644)
                             ("MATHEMATICAL BOLD ITALIC SMALL PI" . 120645)
                             ("MATHEMATICAL BOLD ITALIC SMALL RHO" . 120646)
                             ("MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA" . 120647)
                             ("MATHEMATICAL BOLD ITALIC SMALL SIGMA" . 120648)
                             ("MATHEMATICAL BOLD ITALIC SMALL TAU" . 120649)
                             ("MATHEMATICAL BOLD ITALIC SMALL UPSILON" . 120650)
                             ("MATHEMATICAL BOLD ITALIC SMALL PHI" . 120651)
                             ("MATHEMATICAL BOLD ITALIC SMALL CHI" . 120652)
                             ("MATHEMATICAL BOLD ITALIC SMALL PSI" . 120653)
                             ("MATHEMATICAL BOLD ITALIC SMALL OMEGA" . 120654)
                             ("MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL" . 120655)
                             ("MATHEMATICAL BOLD ITALIC EPSILON SYMBOL" . 120656)
                             ("MATHEMATICAL BOLD ITALIC THETA SYMBOL" . 120657)
                             ("MATHEMATICAL BOLD ITALIC KAPPA SYMBOL" . 120658)
                             ("MATHEMATICAL BOLD ITALIC PHI SYMBOL" . 120659)
                             ("MATHEMATICAL BOLD ITALIC RHO SYMBOL" . 120660)
                             ("MATHEMATICAL BOLD ITALIC PI SYMBOL" . 120661)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA" . 120662)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA" . 120663)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA" . 120664)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA" . 120665)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON" . 120666)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA" . 120667)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA" . 120668)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA" . 120669)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA" . 120670)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA" . 120671)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA" . 120672)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL MU" . 120673)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL NU" . 120674)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL XI" . 120675)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON" . 120676)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PI" . 120677)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO" . 120678)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL" . 120679)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA" . 120680)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU" . 120681)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON" . 120682)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI" . 120683)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI" . 120684)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI" . 120685)
                             ("MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA" . 120686)
                             ("MATHEMATICAL SANS-SERIF BOLD NABLA" . 120687)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA" . 120688)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL BETA" . 120689)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA" . 120690)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL DELTA" . 120691)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON" . 120692)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL ZETA" . 120693)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL ETA" . 120694)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL THETA" . 120695)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL IOTA" . 120696)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA" . 120697)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA" . 120698)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL MU" . 120699)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL NU" . 120700)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL XI" . 120701)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON" . 120702)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL PI" . 120703)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL RHO" . 120704)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA" . 120705)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA" . 120706)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL TAU" . 120707)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON" . 120708)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL PHI" . 120709)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL CHI" . 120710)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL PSI" . 120711)
                             ("MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA" . 120712)
                             ("MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL" . 120713)
                             ("MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL" . 120714)
                             ("MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL" . 120715)
                             ("MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL" . 120716)
                             ("MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL" . 120717)
                             ("MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL" . 120718)
                             ("MATHEMATICAL SANS-SERIF BOLD PI SYMBOL" . 120719)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA" . 120720)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA" . 120721)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA" . 120722)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA" . 120723)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON" . 120724)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA" . 120725)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA" . 120726)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA" . 120727)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA" . 120728)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA" . 120729)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA" . 120730)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU" . 120731)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU" . 120732)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI" . 120733)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON" . 120734)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI" . 120735)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO" . 120736)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL" . 120737)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA" . 120738)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU" . 120739)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON" . 120740)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI" . 120741)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI" . 120742)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI" . 120743)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA" . 120744)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA" . 120745)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA" . 120746)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA" . 120747)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA" . 120748)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA" . 120749)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON" . 120750)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA" . 120751)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA" . 120752)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA" . 120753)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA" . 120754)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA" . 120755)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA" . 120756)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU" . 120757)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU" . 120758)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI" . 120759)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON" . 120760)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI" . 120761)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO" . 120762)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA" . 120763)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA" . 120764)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU" . 120765)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON" . 120766)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI" . 120767)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI" . 120768)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI" . 120769)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA" . 120770)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL" . 120771)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL" . 120772)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL" . 120773)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL" . 120774)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL" . 120775)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL" . 120776)
                             ("MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL" . 120777)
                             ("MATHEMATICAL BOLD DIGIT ZERO" . 120782)
                             ("MATHEMATICAL BOLD DIGIT ONE" . 120783)
                             ("MATHEMATICAL BOLD DIGIT TWO" . 120784)
                             ("MATHEMATICAL BOLD DIGIT THREE" . 120785)
                             ("MATHEMATICAL BOLD DIGIT FOUR" . 120786)
                             ("MATHEMATICAL BOLD DIGIT FIVE" . 120787)
                             ("MATHEMATICAL BOLD DIGIT SIX" . 120788)
                             ("MATHEMATICAL BOLD DIGIT SEVEN" . 120789)
                             ("MATHEMATICAL BOLD DIGIT EIGHT" . 120790)
                             ("MATHEMATICAL BOLD DIGIT NINE" . 120791)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO" . 120792)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT ONE" . 120793)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT TWO" . 120794)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT THREE" . 120795)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR" . 120796)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE" . 120797)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT SIX" . 120798)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN" . 120799)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT" . 120800)
                             ("MATHEMATICAL DOUBLE-STRUCK DIGIT NINE" . 120801)
                             ("MATHEMATICAL SANS-SERIF DIGIT ZERO" . 120802)
                             ("MATHEMATICAL SANS-SERIF DIGIT ONE" . 120803)
                             ("MATHEMATICAL SANS-SERIF DIGIT TWO" . 120804)
                             ("MATHEMATICAL SANS-SERIF DIGIT THREE" . 120805)
                             ("MATHEMATICAL SANS-SERIF DIGIT FOUR" . 120806)
                             ("MATHEMATICAL SANS-SERIF DIGIT FIVE" . 120807)
                             ("MATHEMATICAL SANS-SERIF DIGIT SIX" . 120808)
                             ("MATHEMATICAL SANS-SERIF DIGIT SEVEN" . 120809)
                             ("MATHEMATICAL SANS-SERIF DIGIT EIGHT" . 120810)
                             ("MATHEMATICAL SANS-SERIF DIGIT NINE" . 120811)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO" . 120812)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT ONE" . 120813)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT TWO" . 120814)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT THREE" . 120815)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR" . 120816)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE" . 120817)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT SIX" . 120818)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN" . 120819)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT" . 120820)
                             ("MATHEMATICAL SANS-SERIF BOLD DIGIT NINE" . 120821)
                             ("MATHEMATICAL MONOSPACE DIGIT ZERO" . 120822)
                             ("MATHEMATICAL MONOSPACE DIGIT ONE" . 120823)
                             ("MATHEMATICAL MONOSPACE DIGIT TWO" . 120824)
                             ("MATHEMATICAL MONOSPACE DIGIT THREE" . 120825)
                             ("MATHEMATICAL MONOSPACE DIGIT FOUR" . 120826)
                             ("MATHEMATICAL MONOSPACE DIGIT FIVE" . 120827)
                             ("MATHEMATICAL MONOSPACE DIGIT SIX" . 120828)
                             ("MATHEMATICAL MONOSPACE DIGIT SEVEN" . 120829)
                             ("MATHEMATICAL MONOSPACE DIGIT EIGHT" . 120830)
                             ("MATHEMATICAL MONOSPACE DIGIT NINE" . 120831)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F800" . 194560)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F801" . 194561)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F802" . 194562)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F803" . 194563)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F804" . 194564)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F805" . 194565)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F806" . 194566)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F807" . 194567)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F808" . 194568)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F809" . 194569)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80A" . 194570)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80B" . 194571)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80C" . 194572)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80D" . 194573)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80E" . 194574)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F80F" . 194575)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F810" . 194576)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F811" . 194577)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F812" . 194578)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F813" . 194579)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F814" . 194580)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F815" . 194581)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F816" . 194582)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F817" . 194583)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F818" . 194584)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F819" . 194585)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81A" . 194586)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81B" . 194587)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81C" . 194588)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81D" . 194589)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81E" . 194590)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F81F" . 194591)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F820" . 194592)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F821" . 194593)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F822" . 194594)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F823" . 194595)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F824" . 194596)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F825" . 194597)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F826" . 194598)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F827" . 194599)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F828" . 194600)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F829" . 194601)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82A" . 194602)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82B" . 194603)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82C" . 194604)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82D" . 194605)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82E" . 194606)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F82F" . 194607)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F830" . 194608)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F831" . 194609)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F832" . 194610)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F833" . 194611)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F834" . 194612)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F835" . 194613)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F836" . 194614)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F837" . 194615)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F838" . 194616)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F839" . 194617)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83A" . 194618)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83B" . 194619)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83C" . 194620)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83D" . 194621)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83E" . 194622)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F83F" . 194623)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F840" . 194624)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F841" . 194625)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F842" . 194626)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F843" . 194627)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F844" . 194628)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F845" . 194629)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F846" . 194630)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F847" . 194631)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F848" . 194632)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F849" . 194633)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84A" . 194634)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84B" . 194635)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84C" . 194636)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84D" . 194637)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84E" . 194638)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F84F" . 194639)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F850" . 194640)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F851" . 194641)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F852" . 194642)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F853" . 194643)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F854" . 194644)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F855" . 194645)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F856" . 194646)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F857" . 194647)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F858" . 194648)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F859" . 194649)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85A" . 194650)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85B" . 194651)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85C" . 194652)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85D" . 194653)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85E" . 194654)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F85F" . 194655)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F860" . 194656)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F861" . 194657)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F862" . 194658)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F863" . 194659)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F864" . 194660)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F865" . 194661)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F866" . 194662)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F867" . 194663)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F868" . 194664)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F869" . 194665)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86A" . 194666)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86B" . 194667)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86C" . 194668)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86D" . 194669)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86E" . 194670)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F86F" . 194671)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F870" . 194672)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F871" . 194673)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F872" . 194674)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F873" . 194675)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F874" . 194676)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F875" . 194677)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F876" . 194678)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F877" . 194679)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F878" . 194680)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F879" . 194681)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87A" . 194682)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87B" . 194683)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87C" . 194684)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87D" . 194685)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87E" . 194686)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F87F" . 194687)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F880" . 194688)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F881" . 194689)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F882" . 194690)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F883" . 194691)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F884" . 194692)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F885" . 194693)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F886" . 194694)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F887" . 194695)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F888" . 194696)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F889" . 194697)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88A" . 194698)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88B" . 194699)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88C" . 194700)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88D" . 194701)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88E" . 194702)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F88F" . 194703)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F890" . 194704)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F891" . 194705)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F892" . 194706)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F893" . 194707)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F894" . 194708)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F895" . 194709)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F896" . 194710)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F897" . 194711)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F898" . 194712)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F899" . 194713)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89A" . 194714)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89B" . 194715)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89C" . 194716)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89D" . 194717)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89E" . 194718)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F89F" . 194719)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A0" . 194720)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A1" . 194721)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A2" . 194722)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A3" . 194723)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A4" . 194724)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A5" . 194725)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A6" . 194726)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A7" . 194727)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A8" . 194728)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8A9" . 194729)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AA" . 194730)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AB" . 194731)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AC" . 194732)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AD" . 194733)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AE" . 194734)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8AF" . 194735)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B0" . 194736)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B1" . 194737)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B2" . 194738)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B3" . 194739)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B4" . 194740)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B5" . 194741)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B6" . 194742)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B7" . 194743)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B8" . 194744)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8B9" . 194745)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BA" . 194746)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BB" . 194747)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BC" . 194748)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BD" . 194749)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BE" . 194750)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8BF" . 194751)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C0" . 194752)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C1" . 194753)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C2" . 194754)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C3" . 194755)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C4" . 194756)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C5" . 194757)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C6" . 194758)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C7" . 194759)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C8" . 194760)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8C9" . 194761)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CA" . 194762)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CB" . 194763)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CC" . 194764)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CD" . 194765)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CE" . 194766)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8CF" . 194767)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D0" . 194768)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D1" . 194769)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D2" . 194770)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D3" . 194771)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D4" . 194772)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D5" . 194773)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D6" . 194774)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D7" . 194775)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D8" . 194776)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8D9" . 194777)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DA" . 194778)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DB" . 194779)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DC" . 194780)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DD" . 194781)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DE" . 194782)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8DF" . 194783)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E0" . 194784)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E1" . 194785)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E2" . 194786)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E3" . 194787)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E4" . 194788)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E5" . 194789)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E6" . 194790)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E7" . 194791)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E8" . 194792)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8E9" . 194793)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8EA" . 194794)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8EB" . 194795)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8EC" . 194796)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8ED" . 194797)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8EE" . 194798)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8EF" . 194799)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F0" . 194800)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F1" . 194801)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F2" . 194802)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F3" . 194803)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F4" . 194804)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F5" . 194805)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F6" . 194806)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F7" . 194807)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F8" . 194808)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8F9" . 194809)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FA" . 194810)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FB" . 194811)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FC" . 194812)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FD" . 194813)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FE" . 194814)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F8FF" . 194815)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F900" . 194816)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F901" . 194817)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F902" . 194818)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F903" . 194819)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F904" . 194820)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F905" . 194821)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F906" . 194822)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F907" . 194823)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F908" . 194824)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F909" . 194825)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90A" . 194826)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90B" . 194827)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90C" . 194828)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90D" . 194829)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90E" . 194830)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F90F" . 194831)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F910" . 194832)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F911" . 194833)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F912" . 194834)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F913" . 194835)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F914" . 194836)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F915" . 194837)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F916" . 194838)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F917" . 194839)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F918" . 194840)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F919" . 194841)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91A" . 194842)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91B" . 194843)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91C" . 194844)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91D" . 194845)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91E" . 194846)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F91F" . 194847)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F920" . 194848)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F921" . 194849)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F922" . 194850)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F923" . 194851)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F924" . 194852)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F925" . 194853)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F926" . 194854)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F927" . 194855)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F928" . 194856)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F929" . 194857)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92A" . 194858)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92B" . 194859)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92C" . 194860)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92D" . 194861)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92E" . 194862)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F92F" . 194863)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F930" . 194864)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F931" . 194865)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F932" . 194866)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F933" . 194867)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F934" . 194868)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F935" . 194869)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F936" . 194870)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F937" . 194871)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F938" . 194872)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F939" . 194873)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93A" . 194874)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93B" . 194875)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93C" . 194876)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93D" . 194877)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93E" . 194878)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F93F" . 194879)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F940" . 194880)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F941" . 194881)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F942" . 194882)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F943" . 194883)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F944" . 194884)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F945" . 194885)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F946" . 194886)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F947" . 194887)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F948" . 194888)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F949" . 194889)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94A" . 194890)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94B" . 194891)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94C" . 194892)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94D" . 194893)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94E" . 194894)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F94F" . 194895)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F950" . 194896)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F951" . 194897)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F952" . 194898)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F953" . 194899)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F954" . 194900)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F955" . 194901)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F956" . 194902)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F957" . 194903)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F958" . 194904)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F959" . 194905)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95A" . 194906)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95B" . 194907)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95C" . 194908)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95D" . 194909)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95E" . 194910)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F95F" . 194911)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F960" . 194912)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F961" . 194913)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F962" . 194914)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F963" . 194915)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F964" . 194916)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F965" . 194917)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F966" . 194918)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F967" . 194919)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F968" . 194920)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F969" . 194921)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96A" . 194922)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96B" . 194923)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96C" . 194924)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96D" . 194925)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96E" . 194926)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F96F" . 194927)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F970" . 194928)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F971" . 194929)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F972" . 194930)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F973" . 194931)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F974" . 194932)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F975" . 194933)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F976" . 194934)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F977" . 194935)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F978" . 194936)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F979" . 194937)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97A" . 194938)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97B" . 194939)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97C" . 194940)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97D" . 194941)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97E" . 194942)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F97F" . 194943)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F980" . 194944)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F981" . 194945)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F982" . 194946)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F983" . 194947)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F984" . 194948)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F985" . 194949)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F986" . 194950)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F987" . 194951)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F988" . 194952)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F989" . 194953)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98A" . 194954)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98B" . 194955)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98C" . 194956)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98D" . 194957)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98E" . 194958)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F98F" . 194959)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F990" . 194960)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F991" . 194961)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F992" . 194962)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F993" . 194963)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F994" . 194964)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F995" . 194965)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F996" . 194966)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F997" . 194967)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F998" . 194968)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F999" . 194969)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99A" . 194970)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99B" . 194971)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99C" . 194972)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99D" . 194973)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99E" . 194974)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F99F" . 194975)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A0" . 194976)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A1" . 194977)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A2" . 194978)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A3" . 194979)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A4" . 194980)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A5" . 194981)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A6" . 194982)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A7" . 194983)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A8" . 194984)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9A9" . 194985)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AA" . 194986)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AB" . 194987)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AC" . 194988)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AD" . 194989)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AE" . 194990)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9AF" . 194991)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B0" . 194992)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B1" . 194993)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B2" . 194994)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B3" . 194995)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B4" . 194996)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B5" . 194997)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B6" . 194998)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B7" . 194999)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B8" . 195000)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9B9" . 195001)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BA" . 195002)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BB" . 195003)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BC" . 195004)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BD" . 195005)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BE" . 195006)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9BF" . 195007)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C0" . 195008)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C1" . 195009)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C2" . 195010)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C3" . 195011)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C4" . 195012)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C5" . 195013)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C6" . 195014)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C7" . 195015)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C8" . 195016)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9C9" . 195017)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CA" . 195018)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CB" . 195019)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CC" . 195020)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CD" . 195021)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CE" . 195022)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9CF" . 195023)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D0" . 195024)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D1" . 195025)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D2" . 195026)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D3" . 195027)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D4" . 195028)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D5" . 195029)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D6" . 195030)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D7" . 195031)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D8" . 195032)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9D9" . 195033)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DA" . 195034)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DB" . 195035)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DC" . 195036)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DD" . 195037)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DE" . 195038)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9DF" . 195039)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E0" . 195040)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E1" . 195041)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E2" . 195042)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E3" . 195043)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E4" . 195044)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E5" . 195045)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E6" . 195046)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E7" . 195047)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E8" . 195048)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9E9" . 195049)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9EA" . 195050)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9EB" . 195051)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9EC" . 195052)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9ED" . 195053)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9EE" . 195054)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9EF" . 195055)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F0" . 195056)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F1" . 195057)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F2" . 195058)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F3" . 195059)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F4" . 195060)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F5" . 195061)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F6" . 195062)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F7" . 195063)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F8" . 195064)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9F9" . 195065)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FA" . 195066)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FB" . 195067)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FC" . 195068)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FD" . 195069)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FE" . 195070)
                             ("CJK COMPATIBILITY IDEOGRAPH-2F9FF" . 195071)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA00" . 195072)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA01" . 195073)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA02" . 195074)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA03" . 195075)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA04" . 195076)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA05" . 195077)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA06" . 195078)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA07" . 195079)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA08" . 195080)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA09" . 195081)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0A" . 195082)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0B" . 195083)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0C" . 195084)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0D" . 195085)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0E" . 195086)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA0F" . 195087)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA10" . 195088)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA11" . 195089)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA12" . 195090)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA13" . 195091)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA14" . 195092)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA15" . 195093)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA16" . 195094)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA17" . 195095)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA18" . 195096)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA19" . 195097)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA1A" . 195098)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA1B" . 195099)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA1C" . 195100)
                             ("CJK COMPATIBILITY IDEOGRAPH-2FA1D" . 195101)
                             ("LANGUAGE TAG" . 917505)
                             ("TAG SPACE" . 917536)
                             ("TAG EXCLAMATION MARK" . 917537)
                             ("TAG QUOTATION MARK" . 917538)
                             ("TAG NUMBER SIGN" . 917539)
                             ("TAG DOLLAR SIGN" . 917540)
                             ("TAG PERCENT SIGN" . 917541)
                             ("TAG AMPERSAND" . 917542)
                             ("TAG APOSTROPHE" . 917543)
                             ("TAG LEFT PARENTHESIS" . 917544)
                             ("TAG RIGHT PARENTHESIS" . 917545)
                             ("TAG ASTERISK" . 917546)
                             ("TAG PLUS SIGN" . 917547)
                             ("TAG COMMA" . 917548)
                             ("TAG HYPHEN-MINUS" . 917549)
                             ("TAG FULL STOP" . 917550)
                             ("TAG SOLIDUS" . 917551)
                             ("TAG DIGIT ZERO" . 917552)
                             ("TAG DIGIT ONE" . 917553)
                             ("TAG DIGIT TWO" . 917554)
                             ("TAG DIGIT THREE" . 917555)
                             ("TAG DIGIT FOUR" . 917556)
                             ("TAG DIGIT FIVE" . 917557)
                             ("TAG DIGIT SIX" . 917558)
                             ("TAG DIGIT SEVEN" . 917559)
                             ("TAG DIGIT EIGHT" . 917560)
                             ("TAG DIGIT NINE" . 917561)
                             ("TAG COLON" . 917562)
                             ("TAG SEMICOLON" . 917563)
                             ("TAG LESS-THAN SIGN" . 917564)
                             ("TAG EQUALS SIGN" . 917565)
                             ("TAG GREATER-THAN SIGN" . 917566)
                             ("TAG QUESTION MARK" . 917567)
                             ("TAG COMMERCIAL AT" . 917568)
                             ("TAG LATIN CAPITAL LETTER A" . 917569)
                             ("TAG LATIN CAPITAL LETTER B" . 917570)
                             ("TAG LATIN CAPITAL LETTER C" . 917571)
                             ("TAG LATIN CAPITAL LETTER D" . 917572)
                             ("TAG LATIN CAPITAL LETTER E" . 917573)
                             ("TAG LATIN CAPITAL LETTER F" . 917574)
                             ("TAG LATIN CAPITAL LETTER G" . 917575)
                             ("TAG LATIN CAPITAL LETTER H" . 917576)
                             ("TAG LATIN CAPITAL LETTER I" . 917577)
                             ("TAG LATIN CAPITAL LETTER J" . 917578)
                             ("TAG LATIN CAPITAL LETTER K" . 917579)
                             ("TAG LATIN CAPITAL LETTER L" . 917580)
                             ("TAG LATIN CAPITAL LETTER M" . 917581)
                             ("TAG LATIN CAPITAL LETTER N" . 917582)
                             ("TAG LATIN CAPITAL LETTER O" . 917583)
                             ("TAG LATIN CAPITAL LETTER P" . 917584)
                             ("TAG LATIN CAPITAL LETTER Q" . 917585)
                             ("TAG LATIN CAPITAL LETTER R" . 917586)
                             ("TAG LATIN CAPITAL LETTER S" . 917587)
                             ("TAG LATIN CAPITAL LETTER T" . 917588)
                             ("TAG LATIN CAPITAL LETTER U" . 917589)
                             ("TAG LATIN CAPITAL LETTER V" . 917590)
                             ("TAG LATIN CAPITAL LETTER W" . 917591)
                             ("TAG LATIN CAPITAL LETTER X" . 917592)
                             ("TAG LATIN CAPITAL LETTER Y" . 917593)
                             ("TAG LATIN CAPITAL LETTER Z" . 917594)
                             ("TAG LEFT SQUARE BRACKET" . 917595)
                             ("TAG REVERSE SOLIDUS" . 917596)
                             ("TAG RIGHT SQUARE BRACKET" . 917597)
                             ("TAG CIRCUMFLEX ACCENT" . 917598)
                             ("TAG LOW LINE" . 917599)
                             ("TAG GRAVE ACCENT" . 917600)
                             ("TAG LATIN SMALL LETTER A" . 917601)
                             ("TAG LATIN SMALL LETTER B" . 917602)
                             ("TAG LATIN SMALL LETTER C" . 917603)
                             ("TAG LATIN SMALL LETTER D" . 917604)
                             ("TAG LATIN SMALL LETTER E" . 917605)
                             ("TAG LATIN SMALL LETTER F" . 917606)
                             ("TAG LATIN SMALL LETTER G" . 917607)
                             ("TAG LATIN SMALL LETTER H" . 917608)
                             ("TAG LATIN SMALL LETTER I" . 917609)
                             ("TAG LATIN SMALL LETTER J" . 917610)
                             ("TAG LATIN SMALL LETTER K" . 917611)
                             ("TAG LATIN SMALL LETTER L" . 917612)
                             ("TAG LATIN SMALL LETTER M" . 917613)
                             ("TAG LATIN SMALL LETTER N" . 917614)
                             ("TAG LATIN SMALL LETTER O" . 917615)
                             ("TAG LATIN SMALL LETTER P" . 917616)
                             ("TAG LATIN SMALL LETTER Q" . 917617)
                             ("TAG LATIN SMALL LETTER R" . 917618)
                             ("TAG LATIN SMALL LETTER S" . 917619)
                             ("TAG LATIN SMALL LETTER T" . 917620)
                             ("TAG LATIN SMALL LETTER U" . 917621)
                             ("TAG LATIN SMALL LETTER V" . 917622)
                             ("TAG LATIN SMALL LETTER W" . 917623)
                             ("TAG LATIN SMALL LETTER X" . 917624)
                             ("TAG LATIN SMALL LETTER Y" . 917625)
                             ("TAG LATIN SMALL LETTER Z" . 917626)
                             ("TAG LEFT CURLY BRACKET" . 917627)
                             ("TAG VERTICAL LINE" . 917628)
                             ("TAG RIGHT CURLY BRACKET" . 917629)
                             ("TAG TILDE" . 917630)
                             ("CANCEL TAG" . 917631))
      ;; only include characters which are supported by this Lisp
      while (< code char-code-limit)
      when (code-char code)
      do (setf (gethash name *unicode-names*) (code-char code)))

;;; define some aliases
(loop for (alias . name) in '(("LINE FEED" . "LINE FEED (LF)")
                              ("FORM FEED" . "FORM FEED (LF)")
                              ("CARRIAGE RETURN" . "CARRIAGE RETURN (CR)")
                              ("NEXT LINE" . "NEXT LINE (NEL)")
                              ("LF" . "LINE FEED")
                              ("FF" . "FORM FEED")
                              ("CR" . "CARRIAGE RETURN")
                              ("NEL" . "NEXT LINE")
                              ("ZWNJ" . "ZERO WIDTH NON-JOINER")
                              ("ZWJ" . "ZERO WIDTH JOINER")
                              ("BYTE ORDER MARK" . "ZERO WIDTH NO-BREAK SPACE")
                              ("BOM" . "BYTE ORDER MARK")
                              ("HORIZONTAL TABULATION" . "CHARACTER TABULATION")
                              ("VERTICAL TABULATION" . "LINE TABULATION")
                              ("FILE SEPARATOR" . "INFORMATION SEPARATOR FOUR")
                              ("GROUP SEPARATOR" . "INFORMATION SEPARATOR THREE")
                              ("RECORD SEPARATOR" . "INFORMATION SEPARATOR TWO")
                              ("UNIT SEPARATOR" . "INFORMATION SEPARATOR ONE")
                              ("PARTIAL LINE DOWN" . "PARTIAL LINE FORWARD")
                              ("PARTIAL LINE UP" . "PARTIAL LINE BACKWARD"))
      for existing-char = (gethash name *unicode-names*)
      when existing-char
      do (setf (gethash alias *unicode-names*) existing-char))
