(in-package :cl-user)
(eval-when (:compile-toplevel :load-toplevel)
  (require :gl))

(defpackage :glspin-glut
  (:use :cl :gl)
  (:export :main))
(in-package :glspin-glut)

(defvar Xrot nil)
(defvar Xstep nil)
(defvar Yrot nil)
(defvar Ystep nil)
(defvar Zrot nil)
(defvar Zstep nil)
(defvar Step 0.5)
(defvar Scale 1.0)
(defvar Object nil)
(defvar animate? nil)
(defvar debug nil)
(defvar window)

(defun make-object ()
 (let ((list (glgenlists 1)))
  (glnewlist list GL_COMPILE)
  ;;
  (glBegin GL_LINE_LOOP)
  (glVertex3f 1.0 0.5 -0.4)
  (glVertex3f 1.0 -0.5 -0.4)
  (glVertex3f -1.0 -0.5 -0.4)
  (glVertex3f -1.0 0.5 -0.4)
  (glEnd)
  ;;
  (glBegin GL_LINE_LOOP)
  (glVertex3f 1.0 0.5 0.4)
  (glVertex3f 1.0 -0.5 0.4)
  (glVertex3f -1.0 -0.5 0.4)
  (glVertex3f -1.0 0.5 0.4)
  (glEnd)
  ;;
  (glBegin GL_LINES)
  (glVertex3f 1.0 0.5 -0.4)   (glVertex3f 1.0 0.5 0.4)
  (glVertex3f 1.0 -0.5 -0.4)  (glVertex3f 1.0 -0.5 0.4)
  (glVertex3f -1.0 -0.5 -0.4) (glVertex3f -1.0 -0.5 0.4)
  (glVertex3f -1.0 0.5 -0.4)  (glVertex3f -1.0 0.5 0.4)
  (glEnd)
  ;;
  (glEndList)
  ;;
  list))

(defun reshape-callback (width height)
  (when debug (format t "RESHAPE. width:~a, height:~a~%" width height))
  (glViewport 0 0 width height)
  (glMatrixMode GL_PROJECTION)
  (glLoadIdentity)
  (glFrustum -1d0 1d0 -1d0 1d0 5d0 15d0)
  (glMatrixMode GL_MODELVIEW)
  (glLoadIdentity))

(defun draw-callback ()
  (when debug (format t "DRAW.~%"))
  (glClear GL_COLOR_BUFFER_BIT)
  (glPushMatrix)
  (glTranslatef 0.0 0.0 -10.0)
  (glScalef Scale Scale Scale)
  (cond
   ((> xstep 0)
    (glrotatef (coerce xrot 'single-float) 1.0 0.0 0.0))
   ((> ystep 0)
    (glrotatef (coerce yrot 'single-float) 0.0 1.0 0.0))
   ((> zstep 0)
    (glrotatef (coerce zrot 'single-float) 0.0 0.0 1.0)))
  ;;
  (glcalllist object)
  ;;
  (glpopmatrix)
  ;;
  (glutSwapBuffers))

(defun idle-callback ()
  ;;
  (when debug (format t "IDLE.~%"))
  (setf xrot (+ xrot xstep))
  (setf yrot (+ yrot ystep))
  (setf zrot (+ zrot zstep))
  ;;
  (cond
   ((>= xrot 360.0)
    (setf xrot 0)
    (setf xstep 0)
    (setf ystep step))
   ((>= yrot 360.0)
    (setf yrot 0)
    (setf ystep 0)
    (setf zstep step))
   ((>= zrot 360.0)
    (setf zrot 0)
    (setf zstep 0)
    (setf xstep step)))
  (glutPostRedisplay))

(defun visible-callback (vis)
  (when debug (format t "VISIBLE. vis:~a~%" vis))
  (cond ((= vis GLUT_VISIBLE)
	 (glutIdleFunc #'idle-callback))
	(t
	 (glutIdleFunc (constantly nil)))))

(defun key-callback (k x y)
  (when debug (format t "KEY. k:~s, x:~s, y:~s~%" k x y))
  (case (code-char k)
    (#\Return
     (setf animate? (not animate?))
     (if animate?
       (glutIdleFunc #'idle-callback)
       (glutIdleFunc nil)))
    (#\Escape
     (glutDestroyWindow window)
     (throw :exit-glut nil))))

(defun main ()
  (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
  (glutInitWindowPosition 0 0)
  (glutInitWindowSize 300 300)
  (setq window (glutCreateWindow "spin"))
  
  ;; used by draw routine.
  (setf object (make-object))
  ;;
  (glcullface GL_BACK)
  (glenable GL_CULL_FACE)
  (gldisable GL_DITHER)
  (glshademodel GL_FLAT)
  (glcolor3f 1.0 1.0 1.0)
  ;;
  ;; Initial state of animation.
  (setf xrot 0)  (setf yrot 0)  (setf zrot 0)
  (setf xstep step)  (setf ystep 0)  (setf zstep 0)
  (setf animate? t)
  ;;
  (glutDisplayFunc #'draw-callback)
  (glutReshapeFunc #'reshape-callback)
  (glutIdleFunc #'idle-callback)
  (glutKeyboardFunc #'key-callback)
  (glutVisibilityFunc #'visible-callback)
  
  (catch :exit-glut
    (glutMainLoop)))
