;;;
;;; FFI to access for Xlib and Xutil from Lisp/Scheme
;;;
;;; Problems (ignored for now)
;;;
;;; 1. Strings vs (pointer char).  Problem when pass pointer to string and
;;; allocate or modify it (eg., ; XGetErrorDatabaseText).  Also problem
;;; dealing with lists of strings (eg., XListFonts).
;;;
;;; 2. Functions and macros not all translated.
;;;
;;; Richard Mann
;;;   31 October 1996
;;;   18 May 1998
;;; Knut Arild Erstad (CMUCL version)
;;;   30 January 2001
;;;
;;; Copyright 1996 and 1997 University of Toronto. All rights reserved.
;;; Copyright 1998 NEC Research Institute, Inc. All rights reserved.

(in-package :cl-user)

;; CMUCL may already have an xlib package; if so, get rid of it
(eval-when (:compile-toplevel :load-toplevel :execute)
  (when (and (find-package :xlib)
	     (not (find-symbol "MAKE-XEXTDATA" :xlib)))
    (delete-package :xlib)))

;; Define XLIB package, avoiding redefinitions
(eval-when (:compile-toplevel :load-toplevel :execute)
  (unless (find-package :xlib)
    (defpackage :xlib (:use :cl :cmucl-interface))))

(in-package :xlib)

;;; FUNCTIONS from X11 and Xutil.

(foreign-function xloadqueryfont ((POINTER STRUCT) STRING) (POINTER STRUCT) "XLoadQueryFont")
(foreign-function xqueryfont ((POINTER STRUCT) UNSIGNED-LONG) (POINTER STRUCT) "XQueryFont")
(foreign-function xgetmotionevents ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG (POINTER INT)) (POINTER STRUCT) "XGetMotionEvents")
(foreign-function xdeletemodifiermapentry ((POINTER STRUCT) UNSIGNED-INT INT) (POINTER STRUCT) "XDeleteModifiermapEntry")
(foreign-function xgetmodifiermapping ((POINTER STRUCT)) (POINTER STRUCT) "XGetModifierMapping")
(foreign-function xinsertmodifiermapentry ((POINTER STRUCT) UNSIGNED-INT INT) (POINTER STRUCT) "XInsertModifiermapEntry")
(foreign-function xnewmodifiermap (INT) (POINTER STRUCT) "XNewModifiermap")
(foreign-function xcreateimage ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-INT INT INT (POINTER CHAR) UNSIGNED-INT UNSIGNED-INT INT INT) (POINTER STRUCT) "XCreateImage")
(foreign-function xgetimage ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG INT) (POINTER STRUCT) "XGetImage")
(foreign-function xgetsubimage ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG INT (POINTER STRUCT) INT INT) (POINTER STRUCT) "XGetSubImage")
(foreign-function xopendisplay (STRING) (POINTER STRUCT) "XOpenDisplay")
(foreign-function xrminitialize () VOID "XrmInitialize")
(foreign-function xfetchbytes ((POINTER STRUCT) (POINTER INT)) (POINTER CHAR) "XFetchBytes")
(foreign-function xfetchbuffer ((POINTER STRUCT) (POINTER INT) INT) (POINTER CHAR) "XFetchBuffer")
(foreign-function xgetatomname ((POINTER STRUCT) UNSIGNED-LONG) STRING "XGetAtomName")
(foreign-function xgetdefault ((POINTER STRUCT) STRING STRING) STRING "XGetDefault")
(foreign-function xdisplayname (STRING) STRING "XDisplayName")
(foreign-function xkeysymtostring (UNSIGNED-LONG) STRING "XKeysymToString")
(foreign-function xsynchronize ((POINTER STRUCT) INT) (POINTER FUNCTION) "XSynchronize")
(foreign-function xsetafterfunction ((POINTER STRUCT) (POINTER FUNCTION)) (POINTER FUNCTION) "XSetAfterFunction")
(foreign-function xinternatom ((POINTER STRUCT) STRING INT) UNSIGNED-LONG "XInternAtom")
(foreign-function xcopycolormapandfree ((POINTER STRUCT) UNSIGNED-LONG) UNSIGNED-LONG "XCopyColormapAndFree")
(foreign-function xcreatecolormap ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT) UNSIGNED-LONG "XCreateColormap")
(foreign-function xcreatepixmapcursor ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) UNSIGNED-INT UNSIGNED-INT) UNSIGNED-LONG "XCreatePixmapCursor")
(foreign-function xcreateglyphcursor ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT (POINTER STRUCT) (POINTER STRUCT)) UNSIGNED-LONG "XCreateGlyphCursor")
(foreign-function xcreatefontcursor ((POINTER STRUCT) UNSIGNED-INT) UNSIGNED-LONG "XCreateFontCursor")
(foreign-function xloadfont ((POINTER STRUCT) STRING) UNSIGNED-LONG "XLoadFont")
(foreign-function xcreategc ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG (POINTER STRUCT)) (POINTER STRUCT) "XCreateGC")
(foreign-function xgcontextfromgc ((POINTER STRUCT)) UNSIGNED-LONG "XGContextFromGC")
(foreign-function xflushgc ((POINTER STRUCT) (POINTER STRUCT)) VOID "XFlushGC")
(foreign-function xcreatepixmap ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT) UNSIGNED-LONG "XCreatePixmap")
(foreign-function xcreatebitmapfromdata ((POINTER STRUCT) UNSIGNED-LONG (POINTER CHAR) UNSIGNED-INT UNSIGNED-INT) UNSIGNED-LONG "XCreateBitmapFromData")
(foreign-function xcreatepixmapfrombitmapdata ((POINTER STRUCT) UNSIGNED-LONG (POINTER CHAR) UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-INT) UNSIGNED-LONG "XCreatePixmapFromBitmapData")
(foreign-function xcreatesimplewindow ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG UNSIGNED-LONG) UNSIGNED-LONG "XCreateSimpleWindow")
(foreign-function xgetselectionowner ((POINTER STRUCT) UNSIGNED-LONG) UNSIGNED-LONG "XGetSelectionOwner")
(foreign-function xcreatewindow ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT INT UNSIGNED-INT (POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) UNSIGNED-LONG "XCreateWindow")
(foreign-function xlistinstalledcolormaps ((POINTER STRUCT) UNSIGNED-LONG (POINTER INT)) (POINTER UNSIGNED-LONG) "XListInstalledColormaps")
(foreign-function xlistfonts ((POINTER STRUCT) STRING INT (POINTER INT)) (POINTER (POINTER CHAR)) "XListFonts")
(foreign-function xlistfontswithinfo ((POINTER STRUCT) STRING INT (POINTER INT) (POINTER (POINTER STRUCT))) (POINTER (POINTER CHAR)) "XListFontsWithInfo")
(foreign-function xgetfontpath ((POINTER STRUCT) (POINTER INT)) (POINTER (POINTER CHAR)) "XGetFontPath")
(foreign-function xlistextensions ((POINTER STRUCT) (POINTER INT)) (POINTER (POINTER CHAR)) "XListExtensions")
(foreign-function xlistproperties ((POINTER STRUCT) UNSIGNED-LONG (POINTER INT)) (POINTER UNSIGNED-LONG) "XListProperties")
(foreign-function xlisthosts ((POINTER STRUCT) (POINTER INT) (POINTER INT)) (POINTER STRUCT) "XListHosts")
(foreign-function xkeycodetokeysym ((POINTER STRUCT) UNSIGNED-INT INT) UNSIGNED-LONG "XKeycodeToKeysym")
(foreign-function xlookupkeysym ((POINTER STRUCT) INT) UNSIGNED-LONG "XLookupKeysym")
(foreign-function xgetkeyboardmapping ((POINTER STRUCT) UNSIGNED-INT INT (POINTER INT)) (POINTER UNSIGNED-LONG) "XGetKeyboardMapping")
(foreign-function xstringtokeysym (STRING) UNSIGNED-LONG "XStringToKeysym")
(foreign-function xmaxrequestsize ((POINTER STRUCT)) INT "XMaxRequestSize")
(foreign-function xresourcemanagerstring ((POINTER STRUCT)) STRING "XResourceManagerString")
(foreign-function xscreenresourcestring ((POINTER STRUCT)) STRING "XScreenResourceString")
(foreign-function xdisplaymotionbuffersize ((POINTER STRUCT)) UNSIGNED-LONG "XDisplayMotionBufferSize")
(foreign-function xvisualidfromvisual ((POINTER STRUCT)) UNSIGNED-LONG "XVisualIDFromVisual")
(foreign-function xinitextension ((POINTER STRUCT) STRING) (POINTER STRUCT) "XInitExtension")
(foreign-function xaddextension ((POINTER STRUCT)) (POINTER STRUCT) "XAddExtension")
(foreign-function xfindonextensionlist ((POINTER (POINTER STRUCT)) INT) (POINTER STRUCT) "XFindOnExtensionList")
;(foreign-function xeheadofextensionlist (***INVALID***) (POINTER (POINTER STRUCT)) "XEHeadOfExtensionList")
(foreign-function xrootwindow ((POINTER STRUCT) INT) UNSIGNED-LONG "XRootWindow")
(foreign-function xdefaultrootwindow ((POINTER STRUCT)) UNSIGNED-LONG "XDefaultRootWindow")
(foreign-function xrootwindowofscreen ((POINTER STRUCT)) UNSIGNED-LONG "XRootWindowOfScreen")
(foreign-function xdefaultvisual ((POINTER STRUCT) INT) (POINTER STRUCT) "XDefaultVisual")
(foreign-function xdefaultvisualofscreen ((POINTER STRUCT)) (POINTER STRUCT) "XDefaultVisualOfScreen")
(foreign-function xdefaultgc ((POINTER STRUCT) INT) (POINTER STRUCT) "XDefaultGC")
(foreign-function xdefaultgcofscreen ((POINTER STRUCT)) (POINTER STRUCT) "XDefaultGCOfScreen")
(foreign-function xblackpixel ((POINTER STRUCT) INT) UNSIGNED-LONG "XBlackPixel")
(foreign-function xwhitepixel ((POINTER STRUCT) INT) UNSIGNED-LONG "XWhitePixel")
(foreign-function xallplanes () UNSIGNED-LONG "XAllPlanes")
(foreign-function xblackpixelofscreen ((POINTER STRUCT)) UNSIGNED-LONG "XBlackPixelOfScreen")
(foreign-function xwhitepixelofscreen ((POINTER STRUCT)) UNSIGNED-LONG "XWhitePixelOfScreen")
(foreign-function xnextrequest ((POINTER STRUCT)) UNSIGNED-LONG "XNextRequest")
(foreign-function xlastknownrequestprocessed ((POINTER STRUCT)) UNSIGNED-LONG "XLastKnownRequestProcessed")
(foreign-function xservervendor ((POINTER STRUCT)) STRING "XServerVendor")
(foreign-function xdisplaystring ((POINTER STRUCT)) STRING "XDisplayString")
(foreign-function xdefaultcolormap ((POINTER STRUCT) INT) UNSIGNED-LONG "XDefaultColormap")
(foreign-function xdefaultcolormapofscreen ((POINTER STRUCT)) UNSIGNED-LONG "XDefaultColormapOfScreen")
(foreign-function xdisplayofscreen ((POINTER STRUCT)) (POINTER STRUCT) "XDisplayOfScreen")
(foreign-function xscreenofdisplay ((POINTER STRUCT) INT) (POINTER STRUCT) "XScreenOfDisplay")
(foreign-function xdefaultscreenofdisplay ((POINTER STRUCT)) (POINTER STRUCT) "XDefaultScreenOfDisplay")
(foreign-function xeventmaskofscreen ((POINTER STRUCT)) INT "XEventMaskOfScreen")
(foreign-function xscreennumberofscreen ((POINTER STRUCT)) INT "XScreenNumberOfScreen")
(foreign-function xseterrorhandler ((POINTER FUNCTION)) (POINTER FUNCTION) "XSetErrorHandler")
(foreign-function xsetioerrorhandler ((POINTER FUNCTION)) (POINTER FUNCTION) "XSetIOErrorHandler")
(foreign-function xlistpixmapformats ((POINTER STRUCT) (POINTER INT)) (POINTER STRUCT) "XListPixmapFormats")
(foreign-function xlistdepths ((POINTER STRUCT) INT (POINTER INT)) (POINTER INT) "XListDepths")
(foreign-function xreconfigurewmwindow ((POINTER STRUCT) UNSIGNED-LONG INT UNSIGNED-INT (POINTER STRUCT)) INT "XReconfigureWMWindow")
(foreign-function xgetwmprotocols ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER UNSIGNED-LONG)) (POINTER INT)) INT "XGetWMProtocols")
(foreign-function xsetwmprotocols ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) INT) INT "XSetWMProtocols")
(foreign-function xiconifywindow ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XIconifyWindow")
(foreign-function xwithdrawwindow ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XWithdrawWindow")
(foreign-function xgetcommand ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER (POINTER CHAR))) (POINTER INT)) INT "XGetCommand")
(foreign-function xgetwmcolormapwindows ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER UNSIGNED-LONG)) (POINTER INT)) INT "XGetWMColormapWindows")
(foreign-function xsetwmcolormapwindows ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) INT) INT "XSetWMColormapWindows")
(foreign-function xfreestringlist ((POINTER (POINTER CHAR))) VOID "XFreeStringList")
(foreign-function xsettransientforhint ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetTransientForHint")
(foreign-function xactivatescreensaver ((POINTER STRUCT)) INT "XActivateScreenSaver")
(foreign-function xaddhost ((POINTER STRUCT) (POINTER STRUCT)) INT "XAddHost")
(foreign-function xaddhosts ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XAddHosts")
(foreign-function xaddtoextensionlist ((POINTER (POINTER STRUCT)) (POINTER STRUCT)) INT "XAddToExtensionList")
(foreign-function xaddtosaveset ((POINTER STRUCT) UNSIGNED-LONG) INT "XAddToSaveSet")
(foreign-function xalloccolor ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XAllocColor")
(foreign-function xalloccolorcells ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER UNSIGNED-LONG) UNSIGNED-INT (POINTER UNSIGNED-LONG) UNSIGNED-INT) INT "XAllocColorCells")
(foreign-function xalloccolorplanes ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER UNSIGNED-LONG) INT INT INT INT (POINTER UNSIGNED-LONG) (POINTER UNSIGNED-LONG) (POINTER UNSIGNED-LONG)) INT "XAllocColorPlanes")
(foreign-function xallocnamedcolor ((POINTER STRUCT) UNSIGNED-LONG STRING (POINTER STRUCT) (POINTER STRUCT)) INT "XAllocNamedColor")
(foreign-function xallowevents ((POINTER STRUCT) INT UNSIGNED-LONG) INT "XAllowEvents")
(foreign-function xautorepeatoff ((POINTER STRUCT)) INT "XAutoRepeatOff")
(foreign-function xautorepeaton ((POINTER STRUCT)) INT "XAutoRepeatOn")
(foreign-function xbell ((POINTER STRUCT) INT) INT "XBell")
(foreign-function xbitmapbitorder ((POINTER STRUCT)) INT "XBitmapBitOrder")
(foreign-function xbitmappad ((POINTER STRUCT)) INT "XBitmapPad")
(foreign-function xbitmapunit ((POINTER STRUCT)) INT "XBitmapUnit")
(foreign-function xcellsofscreen ((POINTER STRUCT)) INT "XCellsOfScreen")
(foreign-function xchangeactivepointergrab ((POINTER STRUCT) UNSIGNED-INT UNSIGNED-LONG UNSIGNED-LONG) INT "XChangeActivePointerGrab")
(foreign-function xchangegc ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XChangeGC")
(foreign-function xchangekeyboardcontrol ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XChangeKeyboardControl")
(foreign-function xchangekeyboardmapping ((POINTER STRUCT) INT INT (POINTER UNSIGNED-LONG) INT) INT "XChangeKeyboardMapping")
(foreign-function xchangepointercontrol ((POINTER STRUCT) INT INT INT INT INT) INT "XChangePointerControl")
(foreign-function xchangeproperty ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG INT INT (POINTER UNSIGNED-CHAR) INT) INT "XChangeProperty")
(foreign-function xchangesaveset ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XChangeSaveSet")
(foreign-function xchangewindowattributes ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG (POINTER STRUCT)) INT "XChangeWindowAttributes")
(foreign-function xcheckifevent ((POINTER STRUCT) (POINTER UNION) (POINTER FUNCTION) (POINTER CHAR)) INT "XCheckIfEvent")
(foreign-function xcheckmaskevent ((POINTER STRUCT) INT (POINTER UNION)) INT "XCheckMaskEvent")
(foreign-function xchecktypedevent ((POINTER STRUCT) INT (POINTER UNION)) INT "XCheckTypedEvent")
(foreign-function xchecktypedwindowevent ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER UNION)) INT "XCheckTypedWindowEvent")
(foreign-function xcheckwindowevent ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER UNION)) INT "XCheckWindowEvent")
(foreign-function xcirculatesubwindows ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XCirculateSubwindows")
(foreign-function xcirculatesubwindowsdown ((POINTER STRUCT) UNSIGNED-LONG) INT "XCirculateSubwindowsDown")
(foreign-function xcirculatesubwindowsup ((POINTER STRUCT) UNSIGNED-LONG) INT "XCirculateSubwindowsUp")
(foreign-function xcleararea ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT INT) INT "XClearArea")
(foreign-function xclearwindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XClearWindow")
(foreign-function xclosedisplay ((POINTER STRUCT)) INT "XCloseDisplay")
(foreign-function xconfigurewindow ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT (POINTER STRUCT)) INT "XConfigureWindow")
(foreign-function xconnectionnumber ((POINTER STRUCT)) INT "XConnectionNumber")
(foreign-function xconvertselection ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG) INT "XConvertSelection")
(foreign-function xcopyarea ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT INT INT) INT "XCopyArea")
(foreign-function xcopygc ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XCopyGC")
(foreign-function xcopyplane ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT INT INT UNSIGNED-LONG) INT "XCopyPlane")
(foreign-function xdefaultdepth ((POINTER STRUCT) INT) INT "XDefaultDepth")
(foreign-function xdefaultdepthofscreen ((POINTER STRUCT)) INT "XDefaultDepthOfScreen")
(foreign-function xdefaultscreen ((POINTER STRUCT)) INT "XDefaultScreen")
(foreign-function xdefinecursor ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XDefineCursor")
(foreign-function xdeleteproperty ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XDeleteProperty")
(foreign-function xdestroywindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XDestroyWindow")
(foreign-function xdestroysubwindows ((POINTER STRUCT) UNSIGNED-LONG) INT "XDestroySubwindows")
(foreign-function xdoesbackingstore ((POINTER STRUCT)) INT "XDoesBackingStore")
(foreign-function xdoessaveunders ((POINTER STRUCT)) INT "XDoesSaveUnders")
(foreign-function xdisableaccesscontrol ((POINTER STRUCT)) INT "XDisableAccessControl")
(foreign-function xdisplaycells ((POINTER STRUCT) INT) INT "XDisplayCells")
(foreign-function xdisplayheight ((POINTER STRUCT) INT) INT "XDisplayHeight")
(foreign-function xdisplayheightmm ((POINTER STRUCT) INT) INT "XDisplayHeightMM")
(foreign-function xdisplaykeycodes ((POINTER STRUCT) (POINTER INT) (POINTER INT)) INT "XDisplayKeycodes")
(foreign-function xdisplayplanes ((POINTER STRUCT) INT) INT "XDisplayPlanes")
(foreign-function xdisplaywidth ((POINTER STRUCT) INT) INT "XDisplayWidth")
(foreign-function xdisplaywidthmm ((POINTER STRUCT) INT) INT "XDisplayWidthMM")
(foreign-function xdrawarc ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT INT INT) INT "XDrawArc")
(foreign-function xdrawarcs ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT) INT "XDrawArcs")
(foreign-function xdrawimagestring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT STRING INT) INT "XDrawImageString")
(foreign-function xdrawimagestring16 ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) INT "XDrawImageString16")
(foreign-function xdrawline ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT INT INT) INT "XDrawLine")
(foreign-function xdrawlines ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT) INT "XDrawLines")
(foreign-function xdrawpoint ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT) INT "XDrawPoint")
(foreign-function xdrawpoints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT) INT "XDrawPoints")
(foreign-function xdrawrectangle ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT) INT "XDrawRectangle")
(foreign-function xdrawrectangles ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT) INT "XDrawRectangles")
(foreign-function xdrawsegments ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT) INT "XDrawSegments")
(foreign-function xdrawstring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT STRING INT) INT "XDrawString")
(foreign-function xdrawstring16 ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) INT "XDrawString16")
(foreign-function xdrawtext ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) INT "XDrawText")
(foreign-function xdrawtext16 ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) INT "XDrawText16")
(foreign-function xenableaccesscontrol ((POINTER STRUCT)) INT "XEnableAccessControl")
(foreign-function xeventsqueued ((POINTER STRUCT) INT) INT "XEventsQueued")
(foreign-function xfetchname ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER CHAR))) INT "XFetchName")
(foreign-function xfillarc ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT INT INT) INT "XFillArc")
(foreign-function xfillarcs ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT) INT "XFillArcs")
(foreign-function xfillpolygon ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT INT) INT "XFillPolygon")
(foreign-function xfillrectangle ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT) INT "XFillRectangle")
(foreign-function xfillrectangles ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT) INT "XFillRectangles")
(foreign-function xflush ((POINTER STRUCT)) INT "XFlush")
(foreign-function xforcescreensaver ((POINTER STRUCT) INT) INT "XForceScreenSaver")
(foreign-function xfree ((POINTER VOID)) INT "XFree")
(foreign-function xfreecolormap ((POINTER STRUCT) UNSIGNED-LONG) INT "XFreeColormap")
(foreign-function xfreecolors ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) INT UNSIGNED-LONG) INT "XFreeColors")
(foreign-function xfreecursor ((POINTER STRUCT) UNSIGNED-LONG) INT "XFreeCursor")
(foreign-function xfreeextensionlist ((POINTER (POINTER CHAR))) INT "XFreeExtensionList")
(foreign-function xfreefont ((POINTER STRUCT) (POINTER STRUCT)) INT "XFreeFont")
(foreign-function xfreefontinfo ((POINTER (POINTER CHAR)) (POINTER STRUCT) INT) INT "XFreeFontInfo")
(foreign-function xfreefontnames ((POINTER (POINTER CHAR))) INT "XFreeFontNames")
(foreign-function xfreefontpath ((POINTER (POINTER CHAR))) INT "XFreeFontPath")
(foreign-function xfreegc ((POINTER STRUCT) (POINTER STRUCT)) INT "XFreeGC")
(foreign-function xfreemodifiermap ((POINTER STRUCT)) INT "XFreeModifiermap")
(foreign-function xfreepixmap ((POINTER STRUCT) UNSIGNED-LONG) INT "XFreePixmap")
(foreign-function xgeometry ((POINTER STRUCT) INT STRING STRING UNSIGNED-INT UNSIGNED-INT UNSIGNED-INT INT INT (POINTER INT) (POINTER INT) (POINTER INT) (POINTER INT)) INT "XGeometry")
(foreign-function xgeterrordatabasetext ((POINTER STRUCT) STRING STRING STRING (POINTER CHAR) INT) INT "XGetErrorDatabaseText")
(foreign-function xgeterrortext ((POINTER STRUCT) INT (POINTER CHAR) INT) INT "XGetErrorText")
(foreign-function xgetfontproperty ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG)) INT "XGetFontProperty")
(foreign-function xgetgcvalues ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetGCValues")
(foreign-function xgetgeometry ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) (POINTER INT) (POINTER INT) (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XGetGeometry")
(foreign-function xgeticonname ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER CHAR))) INT "XGetIconName")
(foreign-function xgetinputfocus ((POINTER STRUCT) (POINTER UNSIGNED-LONG) (POINTER INT)) INT "XGetInputFocus")
(foreign-function xgetkeyboardcontrol ((POINTER STRUCT) (POINTER STRUCT)) INT "XGetKeyboardControl")
(foreign-function xgetpointercontrol ((POINTER STRUCT) (POINTER INT) (POINTER INT) (POINTER INT)) INT "XGetPointerControl")
(foreign-function xgetpointermapping ((POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT) INT "XGetPointerMapping")
(foreign-function xgetscreensaver ((POINTER STRUCT) (POINTER INT) (POINTER INT) (POINTER INT) (POINTER INT)) INT "XGetScreenSaver")
(foreign-function xgettransientforhint ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG)) INT "XGetTransientForHint")
(foreign-function xgetwindowproperty ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG INT INT INT UNSIGNED-LONG (POINTER UNSIGNED-LONG) (POINTER INT) (POINTER UNSIGNED-LONG) (POINTER UNSIGNED-LONG) (POINTER (POINTER UNSIGNED-CHAR))) INT "XGetWindowProperty")
(foreign-function xgetwindowattributes ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetWindowAttributes")
(foreign-function xgrabbutton ((POINTER STRUCT) UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG INT UNSIGNED-INT INT INT UNSIGNED-LONG UNSIGNED-LONG) INT "XGrabButton")
(foreign-function xgrabkey ((POINTER STRUCT) INT UNSIGNED-INT UNSIGNED-LONG INT INT INT) INT "XGrabKey")
(foreign-function xgrabkeyboard ((POINTER STRUCT) UNSIGNED-LONG INT INT INT UNSIGNED-LONG) INT "XGrabKeyboard")
(foreign-function xgrabpointer ((POINTER STRUCT) UNSIGNED-LONG INT UNSIGNED-INT INT INT UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG) INT "XGrabPointer")
(foreign-function xgrabserver ((POINTER STRUCT)) INT "XGrabServer")
(foreign-function xheightmmofscreen ((POINTER STRUCT)) INT "XHeightMMOfScreen")
(foreign-function xheightofscreen ((POINTER STRUCT)) INT "XHeightOfScreen")
(foreign-function xifevent ((POINTER STRUCT) (POINTER UNION) (POINTER FUNCTION) (POINTER CHAR)) INT "XIfEvent")
(foreign-function ximagebyteorder ((POINTER STRUCT)) INT "XImageByteOrder")
(foreign-function xinstallcolormap ((POINTER STRUCT) UNSIGNED-LONG) INT "XInstallColormap")
(foreign-function xkeysymtokeycode ((POINTER STRUCT) UNSIGNED-LONG) UNSIGNED-CHAR "XKeysymToKeycode")
(foreign-function xkillclient ((POINTER STRUCT) UNSIGNED-LONG) INT "XKillClient")
(foreign-function xlookupcolor ((POINTER STRUCT) UNSIGNED-LONG STRING (POINTER STRUCT) (POINTER STRUCT)) INT "XLookupColor")
(foreign-function xlowerwindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XLowerWindow")
(foreign-function xmapraised ((POINTER STRUCT) UNSIGNED-LONG) INT "XMapRaised")
(foreign-function xmapsubwindows ((POINTER STRUCT) UNSIGNED-LONG) INT "XMapSubwindows")
(foreign-function xmapwindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XMapWindow")
(foreign-function xmaskevent ((POINTER STRUCT) INT (POINTER UNION)) INT "XMaskEvent")
(foreign-function xmaxcmapsofscreen ((POINTER STRUCT)) INT "XMaxCmapsOfScreen")
(foreign-function xmincmapsofscreen ((POINTER STRUCT)) INT "XMinCmapsOfScreen")
(foreign-function xmoveresizewindow ((POINTER STRUCT) UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT) INT "XMoveResizeWindow")
(foreign-function xmovewindow ((POINTER STRUCT) UNSIGNED-LONG INT INT) INT "XMoveWindow")
(foreign-function xnextevent ((POINTER STRUCT) (POINTER UNION)) INT "XNextEvent")
(foreign-function xnoop ((POINTER STRUCT)) INT "XNoOp")
(foreign-function xparsecolor ((POINTER STRUCT) UNSIGNED-LONG STRING (POINTER STRUCT)) INT "XParseColor")
(foreign-function xparsegeometry (STRING (POINTER INT) (POINTER INT) (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XParseGeometry")
(foreign-function xpeekevent ((POINTER STRUCT) (POINTER UNION)) INT "XPeekEvent")
(foreign-function xpeekifevent ((POINTER STRUCT) (POINTER UNION) (POINTER FUNCTION) (POINTER CHAR)) INT "XPeekIfEvent")
(foreign-function xpending ((POINTER STRUCT)) INT "XPending")
(foreign-function xplanesofscreen ((POINTER STRUCT)) INT "XPlanesOfScreen")
(foreign-function xprotocolrevision ((POINTER STRUCT)) INT "XProtocolRevision")
(foreign-function xprotocolversion ((POINTER STRUCT)) INT "XProtocolVersion")
(foreign-function xputbackevent ((POINTER STRUCT) (POINTER UNION)) INT "XPutBackEvent")
(foreign-function xputimage ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT INT INT UNSIGNED-INT UNSIGNED-INT) INT "XPutImage")
(foreign-function xqlength ((POINTER STRUCT)) INT "XQLength")
(foreign-function xquerybestcursor ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XQueryBestCursor")
(foreign-function xquerybestsize ((POINTER STRUCT) INT UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XQueryBestSize")
(foreign-function xquerybeststipple ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XQueryBestStipple")
(foreign-function xquerybesttile ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT)) INT "XQueryBestTile")
(foreign-function xquerycolor ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XQueryColor")
(foreign-function xquerycolors ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT) INT "XQueryColors")
(foreign-function xqueryextension ((POINTER STRUCT) STRING (POINTER INT) (POINTER INT) (POINTER INT)) INT "XQueryExtension")
(foreign-function xquerykeymap ((POINTER STRUCT) (POINTER CHAR)) INT "XQueryKeymap")
(foreign-function xquerypointer ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) (POINTER UNSIGNED-LONG) (POINTER INT) (POINTER INT) (POINTER INT) (POINTER INT) (POINTER UNSIGNED-INT)) INT "XQueryPointer")
(foreign-function xquerytextextents ((POINTER STRUCT) UNSIGNED-LONG STRING INT (POINTER INT) (POINTER INT) (POINTER INT) (POINTER STRUCT)) INT "XQueryTextExtents")
(foreign-function xquerytextextents16 ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT (POINTER INT) (POINTER INT) (POINTER INT) (POINTER STRUCT)) INT "XQueryTextExtents16")
(foreign-function xquerytree ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) (POINTER UNSIGNED-LONG) (POINTER (POINTER UNSIGNED-LONG)) (POINTER UNSIGNED-INT)) INT "XQueryTree")
(foreign-function xraisewindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XRaiseWindow")
(foreign-function xreadbitmapfile ((POINTER STRUCT) UNSIGNED-LONG STRING (POINTER UNSIGNED-INT) (POINTER UNSIGNED-INT) (POINTER UNSIGNED-LONG) (POINTER INT) (POINTER INT)) INT "XReadBitmapFile")
(foreign-function xrebindkeysym ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) INT (POINTER UNSIGNED-CHAR) INT) INT "XRebindKeysym")
(foreign-function xrecolorcursor ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT)) INT "XRecolorCursor")
(foreign-function xrefreshkeyboardmapping ((POINTER STRUCT)) INT "XRefreshKeyboardMapping")
(foreign-function xremovefromsaveset ((POINTER STRUCT) UNSIGNED-LONG) INT "XRemoveFromSaveSet")
(foreign-function xremovehost ((POINTER STRUCT) (POINTER STRUCT)) INT "XRemoveHost")
(foreign-function xremovehosts ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XRemoveHosts")
(foreign-function xreparentwindow ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG INT INT) INT "XReparentWindow")
(foreign-function xresetscreensaver ((POINTER STRUCT)) INT "XResetScreenSaver")
(foreign-function xresizewindow ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT) INT "XResizeWindow")
(foreign-function xrestackwindows ((POINTER STRUCT) (POINTER UNSIGNED-LONG) INT) INT "XRestackWindows")
(foreign-function xrotatebuffers ((POINTER STRUCT) INT) INT "XRotateBuffers")
(foreign-function xrotatewindowproperties ((POINTER STRUCT) UNSIGNED-LONG (POINTER UNSIGNED-LONG) INT INT) INT "XRotateWindowProperties")
(foreign-function xscreencount ((POINTER STRUCT)) INT "XScreenCount")
(foreign-function xselectinput ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XSelectInput")
(foreign-function xsendevent ((POINTER STRUCT) UNSIGNED-LONG INT INT (POINTER UNION)) INT "XSendEvent")
(foreign-function xsetaccesscontrol ((POINTER STRUCT) INT) INT "XSetAccessControl")
(foreign-function xsetarcmode ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetArcMode")
(foreign-function xsetbackground ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetBackground")
(foreign-function xsetclipmask ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetClipMask")
(foreign-function xsetcliporigin ((POINTER STRUCT) (POINTER STRUCT) INT INT) INT "XSetClipOrigin")
(foreign-function xsetcliprectangles ((POINTER STRUCT) (POINTER STRUCT) INT INT (POINTER STRUCT) INT INT) INT "XSetClipRectangles")
(foreign-function xsetclosedownmode ((POINTER STRUCT) INT) INT "XSetCloseDownMode")
(foreign-function xsetcommand ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER CHAR)) INT) INT "XSetCommand")
(foreign-function xsetdashes ((POINTER STRUCT) (POINTER STRUCT) INT (POINTER CHAR) INT) INT "XSetDashes")
(foreign-function xsetfillrule ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetFillRule")
(foreign-function xsetfillstyle ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetFillStyle")
(foreign-function xsetfont ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetFont")
(foreign-function xsetfontpath ((POINTER STRUCT) (POINTER (POINTER CHAR)) INT) INT "XSetFontPath")
(foreign-function xsetforeground ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetForeground")
(foreign-function xsetfunction ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetFunction")
(foreign-function xsetgraphicsexposures ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetGraphicsExposures")
(foreign-function xseticonname ((POINTER STRUCT) UNSIGNED-LONG STRING) INT "XSetIconName")
(foreign-function xsetinputfocus ((POINTER STRUCT) UNSIGNED-LONG INT UNSIGNED-LONG) INT "XSetInputFocus")
(foreign-function xsetlineattributes ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-INT INT INT INT) INT "XSetLineAttributes")
(foreign-function xsetmodifiermapping ((POINTER STRUCT) (POINTER STRUCT)) INT "XSetModifierMapping")
(foreign-function xsetplanemask ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetPlaneMask")
(foreign-function xsetpointermapping ((POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT) INT "XSetPointerMapping")
(foreign-function xsetscreensaver ((POINTER STRUCT) INT INT INT INT) INT "XSetScreenSaver")
(foreign-function xsetselectionowner ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG UNSIGNED-LONG) INT "XSetSelectionOwner")
(foreign-function xsetstate ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG INT UNSIGNED-LONG) INT "XSetState")
(foreign-function xsetstipple ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetStipple")
(foreign-function xsetsubwindowmode ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XSetSubwindowMode")
(foreign-function xsettsorigin ((POINTER STRUCT) (POINTER STRUCT) INT INT) INT "XSetTSOrigin")
(foreign-function xsettile ((POINTER STRUCT) (POINTER STRUCT) UNSIGNED-LONG) INT "XSetTile")
(foreign-function xsetwindowbackground ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetWindowBackground")
(foreign-function xsetwindowbackgroundpixmap ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetWindowBackgroundPixmap")
(foreign-function xsetwindowborder ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetWindowBorder")
(foreign-function xsetwindowborderpixmap ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetWindowBorderPixmap")
(foreign-function xsetwindowborderwidth ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-INT) INT "XSetWindowBorderWidth")
(foreign-function xsetwindowcolormap ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG) INT "XSetWindowColormap")
(foreign-function xstorebuffer ((POINTER STRUCT) (POINTER CHAR) INT INT) INT "XStoreBuffer")
(foreign-function xstorebytes ((POINTER STRUCT) (POINTER CHAR) INT) INT "XStoreBytes")
(foreign-function xstorecolor ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XStoreColor")
(foreign-function xstorecolors ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT) INT "XStoreColors")
(foreign-function xstorename ((POINTER STRUCT) UNSIGNED-LONG STRING) INT "XStoreName")
(foreign-function xstorenamedcolor ((POINTER STRUCT) UNSIGNED-LONG STRING UNSIGNED-LONG INT) INT "XStoreNamedColor")
(foreign-function xsync ((POINTER STRUCT) INT) INT "XSync")
(foreign-function xtextextents ((POINTER STRUCT) STRING INT (POINTER INT) (POINTER INT) (POINTER INT) (POINTER STRUCT)) INT "XTextExtents")
(foreign-function xtextextents16 ((POINTER STRUCT) (POINTER STRUCT) INT (POINTER INT) (POINTER INT) (POINTER INT) (POINTER STRUCT)) INT "XTextExtents16")
(foreign-function xtextwidth ((POINTER STRUCT) STRING INT) INT "XTextWidth")
(foreign-function xtextwidth16 ((POINTER STRUCT) (POINTER STRUCT) INT) INT "XTextWidth16")
(foreign-function xtranslatecoordinates ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG INT INT (POINTER INT) (POINTER INT) (POINTER UNSIGNED-LONG)) INT "XTranslateCoordinates")
(foreign-function xundefinecursor ((POINTER STRUCT) UNSIGNED-LONG) INT "XUndefineCursor")
(foreign-function xungrabbutton ((POINTER STRUCT) UNSIGNED-INT UNSIGNED-INT UNSIGNED-LONG) INT "XUngrabButton")
(foreign-function xungrabkey ((POINTER STRUCT) INT UNSIGNED-INT UNSIGNED-LONG) INT "XUngrabKey")
(foreign-function xungrabkeyboard ((POINTER STRUCT) UNSIGNED-LONG) INT "XUngrabKeyboard")
(foreign-function xungrabpointer ((POINTER STRUCT) UNSIGNED-LONG) INT "XUngrabPointer")
(foreign-function xungrabserver ((POINTER STRUCT)) INT "XUngrabServer")
(foreign-function xuninstallcolormap ((POINTER STRUCT) UNSIGNED-LONG) INT "XUninstallColormap")
(foreign-function xunloadfont ((POINTER STRUCT) UNSIGNED-LONG) INT "XUnloadFont")
(foreign-function xunmapsubwindows ((POINTER STRUCT) UNSIGNED-LONG) INT "XUnmapSubwindows")
(foreign-function xunmapwindow ((POINTER STRUCT) UNSIGNED-LONG) INT "XUnmapWindow")
(foreign-function xvendorrelease ((POINTER STRUCT)) INT "XVendorRelease")
(foreign-function xwarppointer ((POINTER STRUCT) UNSIGNED-LONG UNSIGNED-LONG INT INT UNSIGNED-INT UNSIGNED-INT INT INT) INT "XWarpPointer")
(foreign-function xwidthmmofscreen ((POINTER STRUCT)) INT "XWidthMMOfScreen")
(foreign-function xwidthofscreen ((POINTER STRUCT)) INT "XWidthOfScreen")
(foreign-function xwindowevent ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER UNION)) INT "XWindowEvent")
(foreign-function xwritebitmapfile ((POINTER STRUCT) STRING UNSIGNED-LONG UNSIGNED-INT UNSIGNED-INT INT INT) INT "XWriteBitmapFile")
(foreign-function xsupportslocale () INT "XSupportsLocale")
(foreign-function xsetlocalemodifiers (STRING) STRING "XSetLocaleModifiers")
(foreign-function xcreatefontset ((POINTER STRUCT) STRING (POINTER (POINTER (POINTER CHAR))) (POINTER INT) (POINTER (POINTER CHAR))) (POINTER STRUCT) "XCreateFontSet")
(foreign-function xfreefontset ((POINTER STRUCT) (POINTER STRUCT)) VOID "XFreeFontSet")
(foreign-function xfontsoffontset ((POINTER STRUCT) (POINTER (POINTER (POINTER STRUCT))) (POINTER (POINTER (POINTER CHAR)))) INT "XFontsOfFontSet")
(foreign-function xbasefontnamelistoffontset ((POINTER STRUCT)) (POINTER CHAR) "XBaseFontNameListOfFontSet")
(foreign-function xlocaleoffontset ((POINTER STRUCT)) (POINTER CHAR) "XLocaleOfFontSet")
(foreign-function xcontextdependentdrawing ((POINTER STRUCT)) INT "XContextDependentDrawing")
(foreign-function xextentsoffontset ((POINTER STRUCT)) (POINTER STRUCT) "XExtentsOfFontSet")
(foreign-function xmbtextescapement ((POINTER STRUCT) STRING INT) INT "XmbTextEscapement")
(foreign-function xwctextescapement ((POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT) INT "XwcTextEscapement")
(foreign-function xmbtextextents ((POINTER STRUCT) STRING INT (POINTER STRUCT) (POINTER STRUCT)) INT "XmbTextExtents")
(foreign-function xwctextextents ((POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT (POINTER STRUCT) (POINTER STRUCT)) INT "XwcTextExtents")
(foreign-function xmbtextpercharextents ((POINTER STRUCT) STRING INT (POINTER STRUCT) (POINTER STRUCT) INT (POINTER INT) (POINTER STRUCT) (POINTER STRUCT)) INT "XmbTextPerCharExtents")
(foreign-function xwctextpercharextents ((POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT (POINTER STRUCT) (POINTER STRUCT) INT (POINTER INT) (POINTER STRUCT) (POINTER STRUCT)) INT "XwcTextPerCharExtents")
(foreign-function xmbdrawtext ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) VOID "XmbDrawText")
(foreign-function xwcdrawtext ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT INT (POINTER STRUCT) INT) VOID "XwcDrawText")
(foreign-function xmbdrawstring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT STRING INT) VOID "XmbDrawString")
(foreign-function xwcdrawstring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT (POINTER UNSIGNED-CHAR) INT) VOID "XwcDrawString")
(foreign-function xmbdrawimagestring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT STRING INT) VOID "XmbDrawImageString")
(foreign-function xwcdrawimagestring ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) INT INT (POINTER UNSIGNED-CHAR) INT) VOID "XwcDrawImageString")
(foreign-function xopenim ((POINTER STRUCT) (POINTER STRUCT) (POINTER CHAR) (POINTER CHAR)) (POINTER STRUCT) "XOpenIM")
(foreign-function xcloseim ((POINTER STRUCT)) INT "XCloseIM")
; XGetIMValues
(foreign-function xdisplayofim ((POINTER STRUCT)) (POINTER STRUCT) "XDisplayOfIM")
(foreign-function xlocaleofim ((POINTER STRUCT)) (POINTER CHAR) "XLocaleOfIM")
; XCreateIC
(foreign-function xdestroyic ((POINTER STRUCT)) VOID "XDestroyIC")
(foreign-function xseticfocus ((POINTER STRUCT)) VOID "XSetICFocus")
(foreign-function xunseticfocus ((POINTER STRUCT)) VOID "XUnsetICFocus")
(foreign-function xwcresetic ((POINTER STRUCT)) (POINTER UNSIGNED-CHAR) "XwcResetIC")
(foreign-function xmbresetic ((POINTER STRUCT)) (POINTER CHAR) "XmbResetIC")
; XSetICValues
; XGetICValues
(foreign-function ximofic ((POINTER STRUCT)) (POINTER STRUCT) "XIMOfIC")
(foreign-function xfilterevent ((POINTER UNION) UNSIGNED-LONG) INT "XFilterEvent")
(foreign-function xmblookupstring ((POINTER STRUCT) (POINTER STRUCT) STRING INT (POINTER UNSIGNED-LONG) (POINTER INT)) INT "XmbLookupString")
(foreign-function xwclookupstring ((POINTER STRUCT) (POINTER STRUCT) (POINTER UNSIGNED-CHAR) INT (POINTER UNSIGNED-LONG) (POINTER INT)) INT "XwcLookupString")
; XVaCreateNestedList
(foreign-function xallocclasshint () (POINTER STRUCT) "XAllocClassHint")
(foreign-function xallociconsize () (POINTER STRUCT) "XAllocIconSize")
(foreign-function xallocsizehints () (POINTER STRUCT) "XAllocSizeHints")
(foreign-function xallocstandardcolormap () (POINTER STRUCT) "XAllocStandardColormap")
(foreign-function xallocwmhints () (POINTER STRUCT) "XAllocWMHints")
(foreign-function xclipbox ((POINTER STRUCT) (POINTER STRUCT)) INT "XClipBox")
(foreign-function xcreateregion () (POINTER STRUCT) "XCreateRegion")
(foreign-function xdefaultstring () STRING "XDefaultString")
(foreign-function xdeletecontext ((POINTER STRUCT) UNSIGNED-LONG INT) INT "XDeleteContext")
(foreign-function xdestroyregion ((POINTER STRUCT)) INT "XDestroyRegion")
(foreign-function xemptyregion ((POINTER STRUCT)) INT "XEmptyRegion")
(foreign-function xequalregion ((POINTER STRUCT) (POINTER STRUCT)) INT "XEqualRegion")
(foreign-function xfindcontext ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER (POINTER CHAR))) INT "XFindContext")
(foreign-function xgetclasshint ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetClassHint")
(foreign-function xgeticonsizes ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER STRUCT)) (POINTER INT)) INT "XGetIconSizes")
(foreign-function xgetnormalhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetNormalHints")
(foreign-function xgetrgbcolormaps ((POINTER STRUCT) UNSIGNED-LONG (POINTER (POINTER STRUCT)) (POINTER INT) UNSIGNED-LONG) INT "XGetRGBColormaps")
(foreign-function xgetsizehints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) INT "XGetSizeHints")
(foreign-function xgetstandardcolormap ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) INT "XGetStandardColormap")
(foreign-function xgettextproperty ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) INT "XGetTextProperty")
(foreign-function xgetvisualinfo ((POINTER STRUCT) INT (POINTER STRUCT) (POINTER INT)) (POINTER STRUCT) "XGetVisualInfo")
(foreign-function xgetwmclientmachine ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetWMClientMachine")
(foreign-function xgetwmhints ((POINTER STRUCT) UNSIGNED-LONG) (POINTER STRUCT) "XGetWMHints")
(foreign-function xgetwmiconname ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetWMIconName")
(foreign-function xgetwmname ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetWMName")
(foreign-function xgetwmnormalhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER INT)) INT "XGetWMNormalHints")
(foreign-function xgetwmsizehints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER INT) UNSIGNED-LONG) INT "XGetWMSizeHints")
(foreign-function xgetzoomhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XGetZoomHints")
(foreign-function xintersectregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XIntersectRegion")
(foreign-function xlookupstring ((POINTER STRUCT) STRING INT (POINTER UNSIGNED-LONG) (POINTER STRUCT)) INT "XLookupString")
(foreign-function xmatchvisualinfo ((POINTER STRUCT) INT INT INT (POINTER STRUCT)) INT "XMatchVisualInfo")
(foreign-function xoffsetregion ((POINTER STRUCT) INT INT) INT "XOffsetRegion")
(foreign-function xpointinregion ((POINTER STRUCT) INT INT) INT "XPointInRegion")
(foreign-function xpolygonregion ((POINTER STRUCT) INT INT) (POINTER STRUCT) "XPolygonRegion")
(foreign-function xrectinregion ((POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT) INT "XRectInRegion")
(foreign-function xsavecontext ((POINTER STRUCT) UNSIGNED-LONG INT (POINTER CHAR)) INT "XSaveContext")
(foreign-function xsetclasshint ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XSetClassHint")
(foreign-function xseticonsizes ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT) INT "XSetIconSizes")
(foreign-function xsetnormalhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XSetNormalHints")
(foreign-function xsetrgbcolormaps ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) INT UNSIGNED-LONG) VOID "XSetRGBColormaps")
(foreign-function xsetsizehints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) INT "XSetSizeHints")
(foreign-function xsetstandardproperties ((POINTER STRUCT) UNSIGNED-LONG (POINTER CHAR) (POINTER CHAR) UNSIGNED-LONG (POINTER (POINTER CHAR)) INT (POINTER STRUCT)) INT "XSetStandardProperties")
(foreign-function xsettextproperty ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) VOID "XSetTextProperty")
(foreign-function xsetwmclientmachine ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) VOID "XSetWMClientMachine")
(foreign-function xsetwmhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XSetWMHints")
(foreign-function xsetwmiconname ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) VOID "XSetWMIconName")
(foreign-function xsetwmname ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) VOID "XSetWMName")
(foreign-function xsetwmnormalhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) VOID "XSetWMNormalHints")
(foreign-function xsetwmproperties ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) (POINTER STRUCT) (POINTER (POINTER CHAR)) INT (POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) VOID "XSetWMProperties")
(foreign-function xmbsetwmproperties ((POINTER STRUCT) UNSIGNED-LONG (POINTER CHAR) (POINTER CHAR) (POINTER (POINTER CHAR)) INT (POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) VOID "XmbSetWMProperties")
(foreign-function xsetwmsizehints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) VOID "XSetWMSizeHints")
(foreign-function xsetregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XSetRegion")
(foreign-function xsetstandardcolormap ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT) UNSIGNED-LONG) VOID "XSetStandardColormap")
(foreign-function xsetzoomhints ((POINTER STRUCT) UNSIGNED-LONG (POINTER STRUCT)) INT "XSetZoomHints")
(foreign-function xshrinkregion ((POINTER STRUCT) INT INT) INT "XShrinkRegion")
(foreign-function xstringlisttotextproperty ((POINTER (POINTER CHAR)) INT (POINTER STRUCT)) INT "XStringListToTextProperty")
(foreign-function xsubtractregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XSubtractRegion")
(foreign-function xmbtextlisttotextproperty ((POINTER STRUCT) (POINTER (POINTER CHAR)) INT INT (POINTER STRUCT)) INT "XmbTextListToTextProperty")
(foreign-function xwctextlisttotextproperty ((POINTER STRUCT) (POINTER (POINTER UNSIGNED-CHAR)) INT INT (POINTER STRUCT)) INT "XwcTextListToTextProperty")
(foreign-function xwcfreestringlist ((POINTER (POINTER UNSIGNED-CHAR))) VOID "XwcFreeStringList")
(foreign-function xtextpropertytostringlist ((POINTER STRUCT) (POINTER (POINTER (POINTER CHAR))) (POINTER INT)) INT "XTextPropertyToStringList")
(foreign-function xmbtextpropertytotextlist ((POINTER STRUCT) (POINTER STRUCT) (POINTER (POINTER (POINTER CHAR))) (POINTER INT)) INT "XmbTextPropertyToTextList")
(foreign-function xwctextpropertytotextlist ((POINTER STRUCT) (POINTER STRUCT) (POINTER (POINTER (POINTER UNSIGNED-CHAR))) (POINTER INT)) INT "XwcTextPropertyToTextList")
(foreign-function xunionrectwithregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XUnionRectWithRegion")
(foreign-function xunionregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XUnionRegion")
(foreign-function xwmgeometry ((POINTER STRUCT) INT STRING STRING UNSIGNED-INT (POINTER STRUCT) (POINTER INT) (POINTER INT) (POINTER INT) (POINTER INT) (POINTER INT)) INT "XWMGeometry")
(foreign-function xxorregion ((POINTER STRUCT) (POINTER STRUCT) (POINTER STRUCT)) INT "XXorRegion")

;;; CONSTANTS.  From Scheme->C distribution

(foreign-define X_PROTOCOL 11)
(foreign-define X_PROTOCOL_REVISION 0)
(foreign-define NONE 0)
(foreign-define PARENTRELATIVE 1)
(foreign-define COPYFROMPARENT 0)
(foreign-define POINTERWINDOW 0)
(foreign-define INPUTFOCUS 1)
(foreign-define POINTERROOT 1)
(foreign-define ANYPROPERTYTYPE 0)
(foreign-define ANYKEY 0)
(foreign-define ANYBUTTON 0)
(foreign-define ALLTEMPORARY 0)
(foreign-define CURRENTTIME 0)
(foreign-define NOSYMBOL 0)
(foreign-define NOEVENTMASK 0)
(foreign-define KEYPRESSMASK 1)
(foreign-define KEYRELEASEMASK 2)
(foreign-define BUTTONPRESSMASK 4)
(foreign-define BUTTONRELEASEMASK 8)
(foreign-define ENTERWINDOWMASK 16)
(foreign-define LEAVEWINDOWMASK 32)
(foreign-define POINTERMOTIONMASK 64)
(foreign-define POINTERMOTIONHINTMASK 128)
(foreign-define BUTTON1MOTIONMASK 256)
(foreign-define BUTTON2MOTIONMASK 512)
(foreign-define BUTTON3MOTIONMASK 1024)
(foreign-define BUTTON4MOTIONMASK 2048)
(foreign-define BUTTON5MOTIONMASK 4096)
(foreign-define BUTTONMOTIONMASK 8192)
(foreign-define KEYMAPSTATEMASK 16384)
(foreign-define EXPOSUREMASK 32768)
(foreign-define VISIBILITYCHANGEMASK 65536)
(foreign-define STRUCTURENOTIFYMASK 131072)
(foreign-define RESIZEREDIRECTMASK 262144)
(foreign-define SUBSTRUCTURENOTIFYMASK 524288)
(foreign-define SUBSTRUCTUREREDIRECTMASK 1048576)
(foreign-define FOCUSCHANGEMASK 2097152)
(foreign-define PROPERTYCHANGEMASK 4194304)
(foreign-define COLORMAPCHANGEMASK 8388608)
(foreign-define OWNERGRABBUTTONMASK 16777216)
(foreign-define KEYPRESS 2)
(foreign-define KEYRELEASE 3)
(foreign-define BUTTONPRESS 4)
(foreign-define BUTTONRELEASE 5)
(foreign-define MOTIONNOTIFY 6)
(foreign-define ENTERNOTIFY 7)
(foreign-define LEAVENOTIFY 8)
(foreign-define FOCUSIN 9)
(foreign-define FOCUSOUT 10)
(foreign-define KEYMAPNOTIFY 11)
(foreign-define EXPOSE 12)
(foreign-define GRAPHICSEXPOSE 13)
(foreign-define NOEXPOSE 14)
(foreign-define VISIBILITYNOTIFY 15)
(foreign-define CREATENOTIFY 16)
(foreign-define DESTROYNOTIFY 17)
(foreign-define UNMAPNOTIFY 18)
(foreign-define MAPNOTIFY 19)
(foreign-define MAPREQUEST 20)
(foreign-define REPARENTNOTIFY 21)
(foreign-define CONFIGURENOTIFY 22)
(foreign-define CONFIGUREREQUEST 23)
(foreign-define GRAVITYNOTIFY 24)
(foreign-define RESIZEREQUEST 25)
(foreign-define CIRCULATENOTIFY 26)
(foreign-define CIRCULATEREQUEST 27)
(foreign-define PROPERTYNOTIFY 28)
(foreign-define SELECTIONCLEAR 29)
(foreign-define SELECTIONREQUEST 30)
(foreign-define SELECTIONNOTIFY 31)
(foreign-define COLORMAPNOTIFY 32)
(foreign-define CLIENTMESSAGE 33)
(foreign-define MAPPINGNOTIFY 34)
(foreign-define LASTEVENT 35)
(foreign-define SHIFTMASK 1)
(foreign-define LOCKMASK 2)
(foreign-define CONTROLMASK 4)
(foreign-define MOD1MASK 8)
(foreign-define MOD2MASK 16)
(foreign-define MOD3MASK 32)
(foreign-define MOD4MASK 64)
(foreign-define MOD5MASK 128)
(foreign-define SHIFTMAPINDEX 0)
(foreign-define LOCKMAPINDEX 1)
(foreign-define CONTROLMAPINDEX 2)
(foreign-define MOD1MAPINDEX 3)
(foreign-define MOD2MAPINDEX 4)
(foreign-define MOD3MAPINDEX 5)
(foreign-define MOD4MAPINDEX 6)
(foreign-define MOD5MAPINDEX 7)
(foreign-define BUTTON1MASK 256)
(foreign-define BUTTON2MASK 512)
(foreign-define BUTTON3MASK 1024)
(foreign-define BUTTON4MASK 2048)
(foreign-define BUTTON5MASK 4096)
(foreign-define ANYMODIFIER 32768)
(foreign-define BUTTON1 1)
(foreign-define BUTTON2 2)
(foreign-define BUTTON3 3)
(foreign-define BUTTON4 4)
(foreign-define BUTTON5 5)
(foreign-define NOTIFYNORMAL 0)
(foreign-define NOTIFYGRAB 1)
(foreign-define NOTIFYUNGRAB 2)
(foreign-define NOTIFYWHILEGRABBED 3)
(foreign-define NOTIFYHINT 1)
(foreign-define NOTIFYANCESTOR 0)
(foreign-define NOTIFYVIRTUAL 1)
(foreign-define NOTIFYINFERIOR 2)
(foreign-define NOTIFYNONLINEAR 3)
(foreign-define NOTIFYNONLINEARVIRTUAL 4)
(foreign-define NOTIFYPOINTER 5)
(foreign-define NOTIFYPOINTERROOT 6)
(foreign-define NOTIFYDETAILNONE 7)
(foreign-define VISIBILITYUNOBSCURED 0)
(foreign-define VISIBILITYPARTIALLYOBSCURED 1)
(foreign-define VISIBILITYFULLYOBSCURED 2)
(foreign-define PLACEONTOP 0)
(foreign-define PLACEONBOTTOM 1)
(foreign-define FAMILYINTERNET 0)
(foreign-define FAMILYDECNET 1)
(foreign-define FAMILYCHAOS 2)
(foreign-define PROPERTYNEWVALUE 0)
(foreign-define PROPERTYDELETE 1)
(foreign-define COLORMAPUNINSTALLED 0)
(foreign-define COLORMAPINSTALLED 1)
(foreign-define GRABMODESYNC 0)
(foreign-define GRABMODEASYNC 1)
(foreign-define GRABSUCCESS 0)
(foreign-define ALREADYGRABBED 1)
(foreign-define GRABINVALIDTIME 2)
(foreign-define GRABNOTVIEWABLE 3)
(foreign-define GRABFROZEN 4)
(foreign-define ASYNCPOINTER 0)
(foreign-define SYNCPOINTER 1)
(foreign-define REPLAYPOINTER 2)
(foreign-define ASYNCKEYBOARD 3)
(foreign-define SYNCKEYBOARD 4)
(foreign-define REPLAYKEYBOARD 5)
(foreign-define ASYNCBOTH 6)
(foreign-define SYNCBOTH 7)
(foreign-define REVERTTONONE 0)
(foreign-define REVERTTOPOINTERROOT 1)
(foreign-define REVERTTOPARENT 2)
(foreign-define SUCCESS 0)
(foreign-define BADREQUEST 1)
(foreign-define BADVALUE 2)
(foreign-define BADWINDOW 3)
(foreign-define BADPIXMAP 4)
(foreign-define BADATOM 5)
(foreign-define BADCURSOR 6)
(foreign-define BADFONT 7)
(foreign-define BADMATCH 8)
(foreign-define BADDRAWABLE 9)
(foreign-define BADACCESS 10)
(foreign-define BADALLOC 11)
(foreign-define BADCOLOR 12)
(foreign-define BADGC 13)
(foreign-define BADIDCHOICE 14)
(foreign-define BADNAME 15)
(foreign-define BADLENGTH 16)
(foreign-define BADIMPLEMENTATION 17)
(foreign-define FIRSTEXTENSIONERROR 128)
(foreign-define LASTEXTENSIONERROR 255)
(foreign-define INPUTOUTPUT 1)
(foreign-define INPUTONLY 2)
(foreign-define CWBACKPIXMAP 1)
(foreign-define CWBACKPIXEL 2)
(foreign-define CWBORDERPIXMAP 4)
(foreign-define CWBORDERPIXEL 8)
(foreign-define CWBITGRAVITY 16)
(foreign-define CWWINGRAVITY 32)
(foreign-define CWBACKINGSTORE 64)
(foreign-define CWBACKINGPLANES 128)
(foreign-define CWBACKINGPIXEL 256)
(foreign-define CWOVERRIDEREDIRECT 512)
(foreign-define CWSAVEUNDER 1024)
(foreign-define CWEVENTMASK 2048)
(foreign-define CWDONTPROPAGATE 4096)
(foreign-define CWCOLORMAP 8192)
(foreign-define CWCURSOR 16384)
(foreign-define CWX 1)
(foreign-define CWY 2)
(foreign-define CWWIDTH 4)
(foreign-define CWHEIGHT 8)
(foreign-define CWBORDERWIDTH 16)
(foreign-define CWSIBLING 32)
(foreign-define CWSTACKMODE 64)
(foreign-define FORGETGRAVITY 0)
(foreign-define NORTHWESTGRAVITY 1)
(foreign-define NORTHGRAVITY 2)
(foreign-define NORTHEASTGRAVITY 3)
(foreign-define WESTGRAVITY 4)
(foreign-define CENTERGRAVITY 5)
(foreign-define EASTGRAVITY 6)
(foreign-define SOUTHWESTGRAVITY 7)
(foreign-define SOUTHGRAVITY 8)
(foreign-define SOUTHEASTGRAVITY 9)
(foreign-define STATICGRAVITY 10)
(foreign-define UNMAPGRAVITY 0)
(foreign-define NOTUSEFUL 0)
(foreign-define WHENMAPPED 1)
(foreign-define ALWAYS 2)
(foreign-define ISUNMAPPED 0)
(foreign-define ISUNVIEWABLE 1)
(foreign-define ISVIEWABLE 2)
(foreign-define SETMODEINSERT 0)
(foreign-define SETMODEDELETE 1)
(foreign-define DESTROYALL 0)
(foreign-define RETAINPERMANENT 1)
(foreign-define RETAINTEMPORARY 2)
(foreign-define ABOVE 0)
(foreign-define BELOW 1)
(foreign-define TOPIF 2)
(foreign-define BOTTOMIF 3)
(foreign-define OPPOSITE 4)
(foreign-define RAISELOWEST 0)
(foreign-define LOWERHIGHEST 1)
(foreign-define PROPMODEREPLACE 0)
(foreign-define PROPMODEPREPEND 1)
(foreign-define PROPMODEAPPEND 2)
(foreign-define GXCLEAR 0)
(foreign-define GXAND 1)
(foreign-define GXANDREVERSE 2)
(foreign-define GXCOPY 3)
(foreign-define GXANDINVERTED 4)
(foreign-define GXNOOP 5)
(foreign-define GXXOR 6)
(foreign-define GXOR 7)
(foreign-define GXNOR 8)
(foreign-define GXEQUIV 9)
(foreign-define GXINVERT 10)
(foreign-define GXORREVERSE 11)
(foreign-define GXCOPYINVERTED 12)
(foreign-define GXORINVERTED 13)
(foreign-define GXNAND 14)
(foreign-define GXSET 15)
(foreign-define LINESOLID 0)
(foreign-define LINEONOFFDASH 1)
(foreign-define LINEDOUBLEDASH 2)
(foreign-define CAPNOTLAST 0)
(foreign-define CAPBUTT 1)
(foreign-define CAPROUND 2)
(foreign-define CAPPROJECTING 3)
(foreign-define JOINMITER 0)
(foreign-define JOINROUND 1)
(foreign-define JOINBEVEL 2)
(foreign-define FILLSOLID 0)
(foreign-define FILLTILED 1)
(foreign-define FILLSTIPPLED 2)
(foreign-define FILLOPAQUESTIPPLED 3)
(foreign-define EVENODDRULE 0)
(foreign-define WINDINGRULE 1)
(foreign-define CLIPBYCHILDREN 0)
(foreign-define INCLUDEINFERIORS 1)
(foreign-define UNSORTED 0)
(foreign-define YSORTED 1)
(foreign-define YXSORTED 2)
(foreign-define YXBANDED 3)
(foreign-define COORDMODEORIGIN 0)
(foreign-define COORDMODEPREVIOUS 1)
(foreign-define COMPLEX 0)
(foreign-define NONCONVEX 1)
(foreign-define CONVEX 2)
(foreign-define ARCCHORD 0)
(foreign-define ARCPIESLICE 1)
(foreign-define GCFUNCTION 1)
(foreign-define GCPLANEMASK 2)
(foreign-define GCFOREGROUND 4)
(foreign-define GCBACKGROUND 8)
(foreign-define GCLINEWIDTH 16)
(foreign-define GCLINESTYLE 32)
(foreign-define GCCAPSTYLE 64)
(foreign-define GCJOINSTYLE 128)
(foreign-define GCFILLSTYLE 256)
(foreign-define GCFILLRULE 512)
(foreign-define GCTILE 1024)
(foreign-define GCSTIPPLE 2048)
(foreign-define GCTILESTIPXORIGIN 4096)
(foreign-define GCTILESTIPYORIGIN 8192)
(foreign-define GCFONT 16384)
(foreign-define GCSUBWINDOWMODE 32768)
(foreign-define GCGRAPHICSEXPOSURES 65536)
(foreign-define GCCLIPXORIGIN 131072)
(foreign-define GCCLIPYORIGIN 262144)
(foreign-define GCCLIPMASK 524288)
(foreign-define GCDASHOFFSET 1048576)
(foreign-define GCDASHLIST 2097152)
(foreign-define GCARCMODE 4194304)
(foreign-define GCLASTBIT 22)
(foreign-define FONTLEFTTORIGHT 0)
(foreign-define FONTRIGHTTOLEFT 1)
(foreign-define FONTCHANGE 255)
(foreign-define XYBITMAP 0)
(foreign-define XYPIXMAP 1)
(foreign-define ZPIXMAP 2)
(foreign-define ALLOCNONE 0)
(foreign-define ALLOCALL 1)
(foreign-define DORED 1)
(foreign-define DOGREEN 2)
(foreign-define DOBLUE 4)
(foreign-define CURSORSHAPE 0)
(foreign-define TILESHAPE 1)
(foreign-define STIPPLESHAPE 2)
(foreign-define AUTOREPEATMODEOFF 0)
(foreign-define AUTOREPEATMODEON 1)
(foreign-define AUTOREPEATMODEDEFAULT 2)
(foreign-define LEDMODEOFF 0)
(foreign-define LEDMODEON 1)
(foreign-define KBKEYCLICKPERCENT 1)
(foreign-define KBBELLPERCENT 2)
(foreign-define KBBELLPITCH 4)
(foreign-define KBBELLDURATION 8)
(foreign-define KBLED 16)
(foreign-define KBLEDMODE 32)
(foreign-define KBKEY 64)
(foreign-define KBAUTOREPEATMODE 128)
(foreign-define MAPPINGSUCCESS 0)
(foreign-define MAPPINGBUSY 1)
(foreign-define MAPPINGFAILED 2)
(foreign-define MAPPINGMODIFIER 0)
(foreign-define MAPPINGKEYBOARD 1)
(foreign-define MAPPINGPOINTER 2)
(foreign-define DONTPREFERBLANKING 0)
(foreign-define PREFERBLANKING 1)
(foreign-define DEFAULTBLANKING 2)
(foreign-define DISABLESCREENSAVER 0)
(foreign-define DISABLESCREENINTERVAL 0)
(foreign-define DONTALLOWEXPOSURES 0)
(foreign-define ALLOWEXPOSURES 1)
(foreign-define DEFAULTEXPOSURES 2)
(foreign-define SCREENSAVERRESET 0)
(foreign-define SCREENSAVERACTIVE 1)
(foreign-define HOSTINSERT 0)
(foreign-define HOSTDELETE 1)
(foreign-define ENABLEACCESS 1)
(foreign-define DISABLEACCESS 0)
(foreign-define STATICGRAY 0)
(foreign-define GRAYSCALE 1)
(foreign-define STATICCOLOR 2)
(foreign-define PSEUDOCOLOR 3)
(foreign-define TRUECOLOR 4)
(foreign-define DIRECTCOLOR 5)
(foreign-define LSBFIRST 0)
(foreign-define MSBFIRST 1)
(foreign-define QUEUEDALREADY 0)
(foreign-define QUEUEDAFTERREADING 1)
(foreign-define QUEUEDAFTERFLUSH 2)
(foreign-define ALLPLANES -1)
(foreign-define NULL 0)
(foreign-define NULLQUARK 0)
(foreign-define NULLSTRING 0)
(foreign-define XRMBINDTIGHTLY 0)
(foreign-define XRMBINDLOOSELY 1)
(foreign-define XRMOPTIONNOARG 0)
(foreign-define XRMOPTIONISARG 1)
(foreign-define XRMOPTIONSTICKYARG 2)
(foreign-define XRMOPTIONSEPARG 3)
(foreign-define XRMOPTIONRESARG 4)
(foreign-define XRMOPTIONSKIPARG 5)
(foreign-define XRMOPTIONSKIPLINE 6)
(foreign-define NOVALUE 0)
(foreign-define XVALUE 1)
(foreign-define YVALUE 2)
(foreign-define WIDTHVALUE 4)
(foreign-define HEIGHTVALUE 8)
(foreign-define ALLVALUES 15)
(foreign-define XNEGATIVE 16)
(foreign-define YNEGATIVE 32)
(foreign-define USPOSITION 1)
(foreign-define USSIZE 2)
(foreign-define PPOSITION 4)
(foreign-define PSIZE 8)
(foreign-define PMINSIZE 16)
(foreign-define PMAXSIZE 32)
(foreign-define PRESIZEINC 64)
(foreign-define PASPECT 128)
(foreign-define PALLHINTS 252)
(foreign-define INPUTHINT 1)
(foreign-define STATEHINT 2)
(foreign-define ICONPIXMAPHINT 4)
(foreign-define ICONWINDOWHINT 8)
(foreign-define ICONPOSITIONHINT 16)
(foreign-define ICONMASKHINT 32)
(foreign-define WINDOWGROUPHINT 64)
(foreign-define ALLHINTS 127)
(foreign-define DONTCARESTATE 0)
(foreign-define NORMALSTATE 1)
(foreign-define ZOOMSTATE 2)
(foreign-define ICONICSTATE 3)
(foreign-define INACTIVESTATE 4)
(foreign-define RECTANGLEOUT 0)
(foreign-define RECTANGLEIN 1)
(foreign-define RECTANGLEPART 2)
(foreign-define VISUALNOMASK 0)
(foreign-define VISUALIDMASK 1)
(foreign-define VISUALSCREENMASK 2)
(foreign-define VISUALDEPTHMASK 4)
(foreign-define VISUALCLASSMASK 8)
(foreign-define VISUALREDMASKMASK 16)
(foreign-define VISUALGREENMASKMASK 32)
(foreign-define VISUALBLUEMASKMASK 64)
(foreign-define VISUALCOLORMAPSIZEMASK 128)
(foreign-define VISUALBITSPERRGBMASK 256)
(foreign-define VISUALALLMASK 511)
(foreign-define BITMAPSUCCESS 0)
(foreign-define BITMAPOPENFAILED 1)
(foreign-define BITMAPFILEINVALID 2)
(foreign-define BITMAPNOMEMORY 3)
(foreign-define XCSUCCESS 0)
(foreign-define XCNOMEM 1)
(foreign-define XCNOENT 2)

;;; These are macros in Xutil.h, but also appear to be in libX11.so anyway?

(foreign-function xputpixel ((POINTER STRUCT) INT INT UNSIGNED-LONG) INT "XPutPixel")
(foreign-function xgetpixel ((POINTER STRUCT) INT INT) UNSIGNED-LONG "XGetPixel")
(foreign-function xsubimage ((POINTER STRUCT) INT INT UNSIGNED-INT UNSIGNED-INT) (POINTER STRUCT) "XSubImage")
(foreign-function xdestroyimage ((POINTER STRUCT)) INT "XDestroyImage")
(foreign-function xaddpixel ((POINTER STRUCT) LONG) INT "XAddPixel")

;;; MACROS. To be translated as needed... (and added to xlib-c.c)

; IsPFKey(keysym) (((unsigned)(keysym)>=XK_KP_F1)&&((unsigned)(keysym)<=XK_KP_F4))
; IsCursorKey(keysym) (((unsigned)(keysym)>=XK_Home)&&((unsigned)(keysym)<XK_Select))
; IsKeypadKey(keysym) (((unsigned)(keysym)>=XK_KP_Space)&&((unsigned)(keysym)<=XK_KP_Equal))
; IsMiscFunctionKey(keysym) (((unsigned)(keysym)>=XK_Select)&&((unsigned)(keysym)<=XK_Break))
; IsFunctionKey(keysym) (((unsigned)(keysym)>=XK_F1)&&((unsigned)(keysym)<=XK_F35))
; IsModifierKey(keysym) ((((unsigned)(keysym)>=XK_Shift_L)&&((unsigned)(keysym)<=XK_Hyper_R))||((unsigned)(keysym)==XK_Mode_switch)||((unsigned)(keysym)==XK_Num_Lock))

; BitmapUnit(dpy) ((dpy)->bitmap_unit)
; NODEV (dev_t)(-1)
; AllPlanes ((unsignedlong)~0L)
; NOPID (pid_t)(-1)
; ConnectionNumber(dpy) ((dpy)->fd)
; ReleaseByFreeingColormap ((XID)1L)
; BitmapBitOrder(dpy) ((dpy)->bitmap_bit_order)
; PlanesOfScreen(s) ((s)->root_depth)
; XStringToContext(string) ((XContext)XrmStringToQuark(string))
; BlackPixelOfScreen(s) ((s)->black_pixel)
; ImageByteOrder(dpy) ((dpy)->byte_order)
; BitmapPad(dpy) ((dpy)->bitmap_pad)
; FD_ISSET(n,p) ((p)->fds_bits[(n)/NFDBITS]&((unsigned)1<<((n)%NFDBITS)))
; DisplayWidthMM(dpy,scr) (((dpy)->screens[(scr)]).mwidth)
; PAllHints (PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect)
; HeightOfScreen(s) ((s)->height)
; ScreenOfDisplay(dpy,scr) (&((dpy)->screens[(scr)]))
; DisplayOfScreen(s) ((s)->display)
; ScreenCount(dpy) ((dpy)->nscreens)
; ServerVendor(dpy) ((dpy)->vendor)
; DefaultGCOfScreen(s) ((s)->default_gc)
; timercmp(tvp,uvp,cmp) ((tvp)->tv_seccmp(uvp)->tv_sec||((tvp)->tv_sec==(uvp)->tv_sec&&(tvp)->tv_useccmp(uvp)->tv_usec))
; DefaultRootWindow(dpy) (((dpy)->screens[(dpy)->default_screen]).root)
; BlackPixel(dpy,scr) (((dpy)->screens[(scr)]).black_pixel)
; offsetof(ty,mem) ((size_t)((char*)&((ty*)0)->mem-(char*)0))
; DisplayWidth(dpy,scr) (((dpy)->screens[(scr)]).width)
; FD_SET(n,p) ((p)->fds_bits[(n)/NFDBITS]|=((unsigned)1<<((n)%NFDBITS)))
; XAllocID(dpy) ((*(dpy)->resource_alloc)((dpy)))
; DefaultGC(dpy,scr) (((dpy)->screens[(scr)]).default_gc)
; DefaultDepthOfScreen(s) ((s)->root_depth)
; DefaultVisualOfScreen(s) ((s)->root_visual)
; DisplayString(dpy) ((dpy)->display_name)
; RevertToNone (int)None
; FD_CLR(n,p) ((p)->fds_bits[(n)/NFDBITS]&=~((unsigned)1<<((n)%NFDBITS)))
; timerisset(tvp) ((tvp)->tv_sec||(tvp)->tv_usec)
; DisplayHeightMM(dpy,scr) (((dpy)->screens[(scr)]).mheight)
; DisplayCells(dpy,scr) (DefaultVisual((dpy),(scr))->map_entries)
; DoesBackingStore(s) ((s)->backing_store)
; RevertToPointerRoot (int)PointerRoot
; DefaultDepth(dpy,scr) (((dpy)->screens[(scr)]).root_depth)
; DefaultVisual(dpy,scr) (((dpy)->screens[(scr)]).root_visual)
; DisplayPlanes(dpy,scr) (((dpy)->screens[(scr)]).root_depth)
; ProtocolVersion(dpy) ((dpy)->proto_major_version)
; XUniqueContext() ((XContext)XrmUniqueQuark())
; QLength(dpy) ((dpy)->qlen)
; P_MYPID ((pid_t)0)
; LastKnownRequestProcessed(dpy) ((dpy)->last_request_read)
; RootWindowOfScreen(s) ((s)->root)
; DefaultScreenOfDisplay(dpy) (&((dpy)->screens[(dpy)->default_screen]))
; DisplayHeight(dpy,scr) (((dpy)->screens[(scr)]).height)
; VendorRelease(dpy) ((dpy)->release)
; WidthMMOfScreen(s) ((s)->mwidth)
; MaxCmapsOfScreen(s) ((s)->max_maps)
; MinCmapsOfScreen(s) ((s)->min_maps)
; FD_ZERO(p) memset((char*)(p),0,sizeof(*(p)))
; timerclear(tvp) (tvp)->tv_sec=(tvp)->tv_usec=0
; DefaultScreen(dpy) ((dpy)->default_screen)
; EventMaskOfScreen(s) ((s)->root_input_mask)
; ProtocolRevision(dpy) ((dpy)->proto_minor_version)
; P_MYHOSTID ((hostid_t)-1)
; AllHints (InputHint|StateHint|IconPixmapHint|IconWindowHint|IconPositionHint|IconMaskHint|WindowGroupHint)
; RootWindow(dpy,scr) (((dpy)->screens[(scr)]).root)
; WhitePixelOfScreen(s) ((s)->white_pixel)
; DefaultColormapOfScreen(s) ((s)->cmap)
; WidthOfScreen(s) ((s)->width)
; DoesSaveUnders(s) ((s)->save_unders)
; NFDBITS (sizeof(fd_mask)*NBBY)
; NextRequest(dpy) ((dpy)->request+1)
; HeightMMOfScreen(s) ((s)->mheight)
; CellsOfScreen(s) (DefaultVisualOfScreen((s))->map_entries)
; howmany(x,y) (((x)+((y)-1))/(y))
; WhitePixel(dpy,scr) (((dpy)->screens[(scr)]).white_pixel)
; DefaultColormap(dpy,scr) (((dpy)->screens[(scr)]).cmap)

;;; Xatom.h

(foreign-define XA_PRIMARY 1)
(foreign-define XA_SECONDARY 2)
(foreign-define XA_ARC 3)
(foreign-define XA_ATOM 4)
(foreign-define XA_BITMAP 5)
(foreign-define XA_CARDINAL 6)
(foreign-define XA_COLORMAP 7)
(foreign-define XA_CURSOR 8)
(foreign-define XA_CUT_BUFFER0 9)
(foreign-define XA_CUT_BUFFER1 10)
(foreign-define XA_CUT_BUFFER2 11)
(foreign-define XA_CUT_BUFFER3 12)
(foreign-define XA_CUT_BUFFER4 13)
(foreign-define XA_CUT_BUFFER5 14)
(foreign-define XA_CUT_BUFFER6 15)
(foreign-define XA_CUT_BUFFER7 16)
(foreign-define XA_DRAWABLE 17)
(foreign-define XA_FONT 18)
(foreign-define XA_INTEGER 19)
(foreign-define XA_PIXMAP 20)
(foreign-define XA_POINT 21)
(foreign-define XA_RECTANGLE 22)
(foreign-define XA_RESOURCE_MANAGER 23)
(foreign-define XA_RGB_COLOR_MAP 24)
(foreign-define XA_RGB_BEST_MAP 25)
(foreign-define XA_RGB_BLUE_MAP 26)
(foreign-define XA_RGB_DEFAULT_MAP 27)
(foreign-define XA_RGB_GRAY_MAP 28)
(foreign-define XA_RGB_GREEN_MAP 29)
(foreign-define XA_RGB_RED_MAP 30)
(foreign-define XA_STRING 31)
(foreign-define XA_VISUALID 32)
(foreign-define XA_WINDOW 33)
(foreign-define XA_WM_COMMAND 34)
(foreign-define XA_WM_HINTS 35)
(foreign-define XA_WM_CLIENT_MACHINE 36)
(foreign-define XA_WM_ICON_NAME 37)
(foreign-define XA_WM_ICON_SIZE 38)
(foreign-define XA_WM_NAME 39)
(foreign-define XA_WM_NORMAL_HINTS 40)
(foreign-define XA_WM_SIZE_HINTS 41)
(foreign-define XA_WM_ZOOM_HINTS 42)
(foreign-define XA_MIN_SPACE 43)
(foreign-define XA_NORM_SPACE 44)
(foreign-define XA_MAX_SPACE 45)
(foreign-define XA_END_SPACE 46)
(foreign-define XA_SUPERSCRIPT_X 47)
(foreign-define XA_SUPERSCRIPT_Y 48)
(foreign-define XA_SUBSCRIPT_X 49)
(foreign-define XA_SUBSCRIPT_Y 50)
(foreign-define XA_UNDERLINE_POSITION 51)
(foreign-define XA_UNDERLINE_THICKNESS 52)
(foreign-define XA_STRIKEOUT_ASCENT 53)
(foreign-define XA_STRIKEOUT_DESCENT 54)
(foreign-define XA_ITALIC_ANGLE 55)
(foreign-define XA_X_HEIGHT 56)
(foreign-define XA_QUAD_WIDTH 57)
(foreign-define XA_WEIGHT 58)
(foreign-define XA_POINT_SIZE 59)
(foreign-define XA_RESOLUTION 60)
(foreign-define XA_COPYRIGHT 61)
(foreign-define XA_NOTICE 62)
(foreign-define XA_FONT_NAME 63)
(foreign-define XA_FAMILY_NAME 64)
(foreign-define XA_FULL_NAME 65)
(foreign-define XA_CAP_HEIGHT 66)
(foreign-define XA_WM_CLASS 67)
(foreign-define XA_WM_TRANSIENT_FOR 68)
(foreign-define XA_LAST_PREDEFINED 68)

;;; keysym/keysymdef.h (From Scheme->C. Note LC precedes lowercase chars.)

(foreign-define XK_BACKSPACE 65288)
(foreign-define XK_TAB 65289)
(foreign-define XK_LINEFEED 65290)
(foreign-define XK_CLEAR 65291)
(foreign-define XK_RETURN 65293)
(foreign-define XK_PAUSE 65299)
(foreign-define XK_ESCAPE 65307)
(foreign-define XK_DELETE 65535)
(foreign-define XK_MULTI_KEY 65312)
(foreign-define XK_KANJI 65313)
(foreign-define XK_HOME 65360)
(foreign-define XK_LEFT 65361)
(foreign-define XK_UP 65362)
(foreign-define XK_RIGHT 65363)
(foreign-define XK_DOWN 65364)
(foreign-define XK_PRIOR 65365)
(foreign-define XK_NEXT 65366)
(foreign-define XK_END 65367)
(foreign-define XK_BEGIN 65368)
(foreign-define XK_SELECT 65376)
(foreign-define XK_PRINT 65377)
(foreign-define XK_EXECUTE 65378)
(foreign-define XK_INSERT 65379)
(foreign-define XK_UNDO 65381)
(foreign-define XK_REDO 65382)
(foreign-define XK_MENU 65383)
(foreign-define XK_FIND 65384)
(foreign-define XK_CANCEL 65385)
(foreign-define XK_HELP 65386)
(foreign-define XK_BREAK 65387)
(foreign-define XK_MODE_SWITCH 65406)
(foreign-define XK_SCRIPT_SWITCH 65406)
(foreign-define XK_NUM_LOCK 65407)
(foreign-define XK_KP_SPACE 65408)
(foreign-define XK_KP_TAB 65417)
(foreign-define XK_KP_ENTER 65421)
(foreign-define XK_KP_F1 65425)
(foreign-define XK_KP_F2 65426)
(foreign-define XK_KP_F3 65427)
(foreign-define XK_KP_F4 65428)
(foreign-define XK_KP_EQUAL 65469)
(foreign-define XK_KP_MULTIPLY 65450)
(foreign-define XK_KP_ADD 65451)
(foreign-define XK_KP_SEPARATOR 65452)
(foreign-define XK_KP_SUBTRACT 65453)
(foreign-define XK_KP_DECIMAL 65454)
(foreign-define XK_KP_DIVIDE 65455)
(foreign-define XK_KP_0 65456)
(foreign-define XK_KP_1 65457)
(foreign-define XK_KP_2 65458)
(foreign-define XK_KP_3 65459)
(foreign-define XK_KP_4 65460)
(foreign-define XK_KP_5 65461)
(foreign-define XK_KP_6 65462)
(foreign-define XK_KP_7 65463)
(foreign-define XK_KP_8 65464)
(foreign-define XK_KP_9 65465)
(foreign-define XK_F1 65470)
(foreign-define XK_F2 65471)
(foreign-define XK_F3 65472)
(foreign-define XK_F4 65473)
(foreign-define XK_F5 65474)
(foreign-define XK_F6 65475)
(foreign-define XK_F7 65476)
(foreign-define XK_F8 65477)
(foreign-define XK_F9 65478)
(foreign-define XK_F10 65479)
(foreign-define XK_F11 65480)
(foreign-define XK_L1 65480)
(foreign-define XK_F12 65481)
(foreign-define XK_L2 65481)
(foreign-define XK_F13 65482)
(foreign-define XK_L3 65482)
(foreign-define XK_F14 65483)
(foreign-define XK_L4 65483)
(foreign-define XK_F15 65484)
(foreign-define XK_L5 65484)
(foreign-define XK_F16 65485)
(foreign-define XK_L6 65485)
(foreign-define XK_F17 65486)
(foreign-define XK_L7 65486)
(foreign-define XK_F18 65487)
(foreign-define XK_L8 65487)
(foreign-define XK_F19 65488)
(foreign-define XK_L9 65488)
(foreign-define XK_F20 65489)
(foreign-define XK_L10 65489)
(foreign-define XK_F21 65490)
(foreign-define XK_R1 65490)
(foreign-define XK_F22 65491)
(foreign-define XK_R2 65491)
(foreign-define XK_F23 65492)
(foreign-define XK_R3 65492)
(foreign-define XK_F24 65493)
(foreign-define XK_R4 65493)
(foreign-define XK_F25 65494)
(foreign-define XK_R5 65494)
(foreign-define XK_F26 65495)
(foreign-define XK_R6 65495)
(foreign-define XK_F27 65496)
(foreign-define XK_R7 65496)
(foreign-define XK_F28 65497)
(foreign-define XK_R8 65497)
(foreign-define XK_F29 65498)
(foreign-define XK_R9 65498)
(foreign-define XK_F30 65499)
(foreign-define XK_R10 65499)
(foreign-define XK_F31 65500)
(foreign-define XK_R11 65500)
(foreign-define XK_F32 65501)
(foreign-define XK_R12 65501)
(foreign-define XK_R13 65502)
(foreign-define XK_F33 65502)
(foreign-define XK_F34 65503)
(foreign-define XK_R14 65503)
(foreign-define XK_F35 65504)
(foreign-define XK_R15 65504)
(foreign-define XK_SHIFT_L 65505)
(foreign-define XK_SHIFT_R 65506)
(foreign-define XK_CONTROL_L 65507)
(foreign-define XK_CONTROL_R 65508)
(foreign-define XK_CAPS_LOCK 65509)
(foreign-define XK_SHIFT_LOCK 65510)
(foreign-define XK_META_L 65511)
(foreign-define XK_META_R 65512)
(foreign-define XK_ALT_L 65513)
(foreign-define XK_ALT_R 65514)
(foreign-define XK_SUPER_L 65515)
(foreign-define XK_SUPER_R 65516)
(foreign-define XK_HYPER_L 65517)
(foreign-define XK_HYPER_R 65518)
(foreign-define XK_SPACE 32)
(foreign-define XK_EXCLAM 33)
(foreign-define XK_QUOTEDBL 34)
(foreign-define XK_NUMBERSIGN 35)
(foreign-define XK_DOLLAR 36)
(foreign-define XK_PERCENT 37)
(foreign-define XK_AMPERSAND 38)
(foreign-define XK_QUOTERIGHT 39)
(foreign-define XK_PARENLEFT 40)
(foreign-define XK_PARENRIGHT 41)
(foreign-define XK_ASTERISK 42)
(foreign-define XK_PLUS 43)
(foreign-define XK_COMMA 44)
(foreign-define XK_MINUS 45)
(foreign-define XK_PERIOD 46)
(foreign-define XK_SLASH 47)
(foreign-define XK_0 48)
(foreign-define XK_1 49)
(foreign-define XK_2 50)
(foreign-define XK_3 51)
(foreign-define XK_4 52)
(foreign-define XK_5 53)
(foreign-define XK_6 54)
(foreign-define XK_7 55)
(foreign-define XK_8 56)
(foreign-define XK_9 57)
(foreign-define XK_COLON 58)
(foreign-define XK_SEMICOLON 59)
(foreign-define XK_LESS 60)
(foreign-define XK_EQUAL 61)
(foreign-define XK_GREATER 62)
(foreign-define XK_QUESTION 63)
(foreign-define XK_AT 64)
(foreign-define XK_A 65)
(foreign-define XK_B 66)
(foreign-define XK_C 67)
(foreign-define XK_D 68)
(foreign-define XK_E 69)
(foreign-define XK_F 70)
(foreign-define XK_G 71)
(foreign-define XK_H 72)
(foreign-define XK_I 73)
(foreign-define XK_J 74)
(foreign-define XK_K 75)
(foreign-define XK_L 76)
(foreign-define XK_M 77)
(foreign-define XK_N 78)
(foreign-define XK_O 79)
(foreign-define XK_P 80)
(foreign-define XK_Q 81)
(foreign-define XK_R 82)
(foreign-define XK_S 83)
(foreign-define XK_T 84)
(foreign-define XK_U 85)
(foreign-define XK_V 86)
(foreign-define XK_W 87)
(foreign-define XK_X 88)
(foreign-define XK_Y 89)
(foreign-define XK_Z 90)
(foreign-define XK_BRACKETLEFT 91)
(foreign-define XK_BACKSLASH 92)
(foreign-define XK_BRACKETRIGHT 93)
(foreign-define XK_ASCIICIRCUM 94)
(foreign-define XK_UNDERSCORE 95)
(foreign-define XK_QUOTELEFT 96)
(foreign-define XK_LCA 97)
(foreign-define XK_LCB 98)
(foreign-define XK_LCC 99)
(foreign-define XK_LCD 100)
(foreign-define XK_LCE 101)
(foreign-define XK_LCF 102)
(foreign-define XK_LCG 103)
(foreign-define XK_LCH 104)
(foreign-define XK_LCI 105)
(foreign-define XK_LCJ 106)
(foreign-define XK_LCK 107)
(foreign-define XK_LCL 108)
(foreign-define XK_LCM 109)
(foreign-define XK_LCN 110)
(foreign-define XK_LCO 111)
(foreign-define XK_LCP 112)
(foreign-define XK_LCQ 113)
(foreign-define XK_LCR 114)
(foreign-define XK_LCS 115)
(foreign-define XK_LCT 116)
(foreign-define XK_LCU 117)
(foreign-define XK_LCV 118)
(foreign-define XK_LCW 119)
(foreign-define XK_LCX 120)
(foreign-define XK_LCY 121)
(foreign-define XK_LCZ 122)
(foreign-define XK_BRACELEFT 123)
(foreign-define XK_BAR 124)
(foreign-define XK_BRACERIGHT 125)
(foreign-define XK_ASCIITILDE 126)
(foreign-define XK_NOBREAKSPACE 160)
(foreign-define XK_EXCLAMDOWN 161)
(foreign-define XK_CENT 162)
(foreign-define XK_STERLING 163)
(foreign-define XK_CURRENCY 164)
(foreign-define XK_YEN 165)
(foreign-define XK_BROKENBAR 166)
(foreign-define XK_SECTION 167)
(foreign-define XK_DIAERESIS 168)
(foreign-define XK_COPYRIGHT 169)
(foreign-define XK_ORDFEMININE 170)
(foreign-define XK_GUILLEMOTLEFT 171)
(foreign-define XK_NOTSIGN 172)
(foreign-define XK_HYPHEN 173)
(foreign-define XK_REGISTERED 174)
(foreign-define XK_MACRON 175)
(foreign-define XK_DEGREE 176)
(foreign-define XK_PLUSMINUS 177)
(foreign-define XK_TWOSUPERIOR 178)
(foreign-define XK_THREESUPERIOR 179)
(foreign-define XK_ACUTE 180)
(foreign-define XK_MU 181)
(foreign-define XK_PARAGRAPH 182)
(foreign-define XK_PERIODCENTERED 183)
(foreign-define XK_CEDILLA 184)
(foreign-define XK_ONESUPERIOR 185)
(foreign-define XK_MASCULINE 186)
(foreign-define XK_GUILLEMOTRIGHT 187)
(foreign-define XK_ONEQUARTER 188)
(foreign-define XK_ONEHALF 189)
(foreign-define XK_THREEQUARTERS 190)
(foreign-define XK_QUESTIONDOWN 191)
(foreign-define XK_AGRAVE 192)
(foreign-define XK_AACUTE 193)
(foreign-define XK_ACIRCUMFLEX 194)
(foreign-define XK_ATILDE 195)
(foreign-define XK_ADIAERESIS 196)
(foreign-define XK_ARING 197)
(foreign-define XK_AE 198)
(foreign-define XK_CCEDILLA 199)
(foreign-define XK_EGRAVE 200)
(foreign-define XK_EACUTE 201)
(foreign-define XK_ECIRCUMFLEX 202)
(foreign-define XK_EDIAERESIS 203)
(foreign-define XK_IGRAVE 204)
(foreign-define XK_IACUTE 205)
(foreign-define XK_ICIRCUMFLEX 206)
(foreign-define XK_IDIAERESIS 207)
(foreign-define XK_ETH 208)
(foreign-define XK_NTILDE 209)
(foreign-define XK_OGRAVE 210)
(foreign-define XK_OACUTE 211)
(foreign-define XK_OCIRCUMFLEX 212)
(foreign-define XK_OTILDE 213)
(foreign-define XK_ODIAERESIS 214)
(foreign-define XK_MULTIPLY 215)
(foreign-define XK_OOBLIQUE 216)
(foreign-define XK_UGRAVE 217)
(foreign-define XK_UACUTE 218)
(foreign-define XK_UCIRCUMFLEX 219)
(foreign-define XK_UDIAERESIS 220)
(foreign-define XK_YACUTE 221)
(foreign-define XK_THORN 222)
(foreign-define XK_SSHARP 223)
(foreign-define XK_LCAGRAVE 224)
(foreign-define XK_LCAACUTE 225)
(foreign-define XK_LCACIRCUMFLEX 226)
(foreign-define XK_LCATILDE 227)
(foreign-define XK_LCADIAERESIS 228)
(foreign-define XK_LCARING 229)
(foreign-define XK_LCAE 230)
(foreign-define XK_LCCCEDILLA 231)
(foreign-define XK_LCEGRAVE 232)
(foreign-define XK_LCEACUTE 233)
(foreign-define XK_LCECIRCUMFLEX 234)
(foreign-define XK_LCEDIAERESIS 235)
(foreign-define XK_LCIGRAVE 236)
(foreign-define XK_LCIACUTE 237)
(foreign-define XK_LCICIRCUMFLEX 238)
(foreign-define XK_LCIDIAERESIS 239)
(foreign-define XK_LCETH 240)
(foreign-define XK_LCNTILDE 241)
(foreign-define XK_LCOGRAVE 242)
(foreign-define XK_LCOACUTE 243)
(foreign-define XK_LCOCIRCUMFLEX 244)
(foreign-define XK_LCOTILDE 245)
(foreign-define XK_LCODIAERESIS 246)
(foreign-define XK_DIVISION 247)
(foreign-define XK_OSLASH 248)
(foreign-define XK_LCUGRAVE 249)
(foreign-define XK_LCUACUTE 250)
(foreign-define XK_LCUCIRCUMFLEX 251)
(foreign-define XK_LCUDIAERESIS 252)
(foreign-define XK_LCYACUTE 253)
(foreign-define XK_LCTHORN 254)
(foreign-define XK_YDIAERESIS 255)
(foreign-define DXK_RING_ACCENT 268500656)
(foreign-define DXK_CIRCUMFLEX_ACCENT 268500574)
(foreign-define DXK_CEDILLA_ACCENT 268500524)
(foreign-define DXK_ACUTE_ACCENT 268500519)
(foreign-define DXK_GRAVE_ACCENT 268500576)
(foreign-define DXK_TILDE 268500606)
(foreign-define DXK_DIAERESIS 268500514)
(foreign-define DXK_REMOVE 268500736)

;;; cursorfont.h (from Scheme->C distribution)

(foreign-define XC_NUM_GLYPHS 154)
(foreign-define XC_X_CURSOR 0)
(foreign-define XC_ARROW 2)
(foreign-define XC_BASED_ARROW_DOWN 4)
(foreign-define XC_BASED_ARROW_UP 6)
(foreign-define XC_BOAT 8)
(foreign-define XC_BOGOSITY 10)
(foreign-define XC_BOTTOM_LEFT_CORNER 12)
(foreign-define XC_BOTTOM_RIGHT_CORNER 14)
(foreign-define XC_BOTTOM_SIDE 16)
(foreign-define XC_BOTTOM_TEE 18)
(foreign-define XC_BOX_SPIRAL 20)
(foreign-define XC_CENTER_PTR 22)
(foreign-define XC_CIRCLE 24)
(foreign-define XC_CLOCK 26)
(foreign-define XC_COFFEE_MUG 28)
(foreign-define XC_CROSS 30)
(foreign-define XC_CROSS_REVERSE 32)
(foreign-define XC_CROSSHAIR 34)
(foreign-define XC_DIAMOND_CROSS 36)
(foreign-define XC_DOT 38)
(foreign-define XC_DOTBOX 40)
(foreign-define XC_DOUBLE_ARROW 42)
(foreign-define XC_DRAFT_LARGE 44)
(foreign-define XC_DRAFT_SMALL 46)
(foreign-define XC_DRAPED_BOX 48)
(foreign-define XC_EXCHANGE 50)
(foreign-define XC_FLEUR 52)
(foreign-define XC_GOBBLER 54)
(foreign-define XC_GUMBY 56)
(foreign-define XC_HAND1 58)
(foreign-define XC_HAND2 60)
(foreign-define XC_HEART 62)
(foreign-define XC_ICON 64)
(foreign-define XC_IRON_CROSS 66)
(foreign-define XC_LEFT_PTR 68)
(foreign-define XC_LEFT_SIDE 70)
(foreign-define XC_LEFT_TEE 72)
(foreign-define XC_LEFTBUTTON 74)
(foreign-define XC_LL_ANGLE 76)
(foreign-define XC_LR_ANGLE 78)
(foreign-define XC_MAN 80)
(foreign-define XC_MIDDLEBUTTON 82)
(foreign-define XC_MOUSE 84)
(foreign-define XC_PENCIL 86)
(foreign-define XC_PIRATE 88)
(foreign-define XC_PLUS 90)
(foreign-define XC_QUESTION_ARROW 92)
(foreign-define XC_RIGHT_PTR 94)
(foreign-define XC_RIGHT_SIDE 96)
(foreign-define XC_RIGHT_TEE 98)
(foreign-define XC_RIGHTBUTTON 100)
(foreign-define XC_RTL_LOGO 102)
(foreign-define XC_SAILBOAT 104)
(foreign-define XC_SB_DOWN_ARROW 106)
(foreign-define XC_SB_H_DOUBLE_ARROW 108)
(foreign-define XC_SB_LEFT_ARROW 110)
(foreign-define XC_SB_RIGHT_ARROW 112)
(foreign-define XC_SB_UP_ARROW 114)
(foreign-define XC_SB_V_DOUBLE_ARROW 116)
(foreign-define XC_SHUTTLE 118)
(foreign-define XC_SIZING 120)
(foreign-define XC_SPIDER 122)
(foreign-define XC_SPRAYCAN 124)
(foreign-define XC_STAR 126)
(foreign-define XC_TARGET 128)
(foreign-define XC_TCROSS 130)
(foreign-define XC_TOP_LEFT_ARROW 132)
(foreign-define XC_TOP_LEFT_CORNER 134)
(foreign-define XC_TOP_RIGHT_CORNER 136)
(foreign-define XC_TOP_SIDE 138)
(foreign-define XC_TOP_TEE 140)
(foreign-define XC_TREK 142)
(foreign-define XC_UL_ANGLE 144)
(foreign-define XC_UMBRELLA 146)
(foreign-define XC_UR_ANGLE 148)
(foreign-define XC_WATCH 150)
(foreign-define XC_XTERM 152)

;;; Accessors for STRUCTS

;;; STRUCT:XExtData
(foreign-function make-xextdata () (POINTER STRUCT) "alloc_XExtData")
(foreign-function free-xextdata ((POINTER STRUCT)) VOID "free_XExtData")
(foreign-function xextdata-number ((POINTER STRUCT)) INT "get_XExtData_number")
(foreign-function set-xextdata-number! ((POINTER STRUCT) INT) VOID "set_XExtData_number")
(foreign-function xextdata-next ((POINTER STRUCT)) (POINTER STRUCT) "get_XExtData_next")
(foreign-function set-xextdata-next! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XExtData_next")
(foreign-function xextdata-free_private ((POINTER STRUCT)) (POINTER FUNCTION) "get_XExtData_free_private")
(foreign-function set-xextdata-free_private! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XExtData_free_private")
(foreign-function xextdata-private_data ((POINTER STRUCT)) (POINTER CHAR) "get_XExtData_private_data")
(foreign-function set-xextdata-private_data! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XExtData_private_data")
;;; STRUCT:XExtCodes
(foreign-function make-xextcodes () (POINTER STRUCT) "alloc_XExtCodes")
(foreign-function free-xextcodes ((POINTER STRUCT)) VOID "free_XExtCodes")
(foreign-function xextcodes-extension ((POINTER STRUCT)) INT "get_XExtCodes_extension")
(foreign-function set-xextcodes-extension! ((POINTER STRUCT) INT) VOID "set_XExtCodes_extension")
(foreign-function xextcodes-major_opcode ((POINTER STRUCT)) INT "get_XExtCodes_major_opcode")
(foreign-function set-xextcodes-major_opcode! ((POINTER STRUCT) INT) VOID "set_XExtCodes_major_opcode")
(foreign-function xextcodes-first_event ((POINTER STRUCT)) INT "get_XExtCodes_first_event")
(foreign-function set-xextcodes-first_event! ((POINTER STRUCT) INT) VOID "set_XExtCodes_first_event")
(foreign-function xextcodes-first_error ((POINTER STRUCT)) INT "get_XExtCodes_first_error")
(foreign-function set-xextcodes-first_error! ((POINTER STRUCT) INT) VOID "set_XExtCodes_first_error")
;;; STRUCT:XPixmapFormatValues
(foreign-function make-xpixmapformatvalues () (POINTER STRUCT) "alloc_XPixmapFormatValues")
(foreign-function free-xpixmapformatvalues ((POINTER STRUCT)) VOID "free_XPixmapFormatValues")
(foreign-function xpixmapformatvalues-depth ((POINTER STRUCT)) INT "get_XPixmapFormatValues_depth")
(foreign-function set-xpixmapformatvalues-depth! ((POINTER STRUCT) INT) VOID "set_XPixmapFormatValues_depth")
(foreign-function xpixmapformatvalues-bits_per_pixel ((POINTER STRUCT)) INT "get_XPixmapFormatValues_bits_per_pixel")
(foreign-function set-xpixmapformatvalues-bits_per_pixel! ((POINTER STRUCT) INT) VOID "set_XPixmapFormatValues_bits_per_pixel")
(foreign-function xpixmapformatvalues-scanline_pad ((POINTER STRUCT)) INT "get_XPixmapFormatValues_scanline_pad")
(foreign-function set-xpixmapformatvalues-scanline_pad! ((POINTER STRUCT) INT) VOID "set_XPixmapFormatValues_scanline_pad")
;;; STRUCT:XGCValues
(foreign-function make-xgcvalues () (POINTER STRUCT) "alloc_XGCValues")
(foreign-function free-xgcvalues ((POINTER STRUCT)) VOID "free_XGCValues")
(foreign-function xgcvalues-function ((POINTER STRUCT)) INT "get_XGCValues_function")
(foreign-function set-xgcvalues-function! ((POINTER STRUCT) INT) VOID "set_XGCValues_function")
(foreign-function xgcvalues-plane_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_plane_mask")
(foreign-function set-xgcvalues-plane_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_plane_mask")
(foreign-function xgcvalues-foreground ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_foreground")
(foreign-function set-xgcvalues-foreground! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_foreground")
(foreign-function xgcvalues-background ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_background")
(foreign-function set-xgcvalues-background! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_background")
(foreign-function xgcvalues-line_width ((POINTER STRUCT)) INT "get_XGCValues_line_width")
(foreign-function set-xgcvalues-line_width! ((POINTER STRUCT) INT) VOID "set_XGCValues_line_width")
(foreign-function xgcvalues-line_style ((POINTER STRUCT)) INT "get_XGCValues_line_style")
(foreign-function set-xgcvalues-line_style! ((POINTER STRUCT) INT) VOID "set_XGCValues_line_style")
(foreign-function xgcvalues-cap_style ((POINTER STRUCT)) INT "get_XGCValues_cap_style")
(foreign-function set-xgcvalues-cap_style! ((POINTER STRUCT) INT) VOID "set_XGCValues_cap_style")
(foreign-function xgcvalues-join_style ((POINTER STRUCT)) INT "get_XGCValues_join_style")
(foreign-function set-xgcvalues-join_style! ((POINTER STRUCT) INT) VOID "set_XGCValues_join_style")
(foreign-function xgcvalues-fill_style ((POINTER STRUCT)) INT "get_XGCValues_fill_style")
(foreign-function set-xgcvalues-fill_style! ((POINTER STRUCT) INT) VOID "set_XGCValues_fill_style")
(foreign-function xgcvalues-fill_rule ((POINTER STRUCT)) INT "get_XGCValues_fill_rule")
(foreign-function set-xgcvalues-fill_rule! ((POINTER STRUCT) INT) VOID "set_XGCValues_fill_rule")
(foreign-function xgcvalues-arc_mode ((POINTER STRUCT)) INT "get_XGCValues_arc_mode")
(foreign-function set-xgcvalues-arc_mode! ((POINTER STRUCT) INT) VOID "set_XGCValues_arc_mode")
(foreign-function xgcvalues-tile ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_tile")
(foreign-function set-xgcvalues-tile! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_tile")
(foreign-function xgcvalues-stipple ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_stipple")
(foreign-function set-xgcvalues-stipple! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_stipple")
(foreign-function xgcvalues-ts_x_origin ((POINTER STRUCT)) INT "get_XGCValues_ts_x_origin")
(foreign-function set-xgcvalues-ts_x_origin! ((POINTER STRUCT) INT) VOID "set_XGCValues_ts_x_origin")
(foreign-function xgcvalues-ts_y_origin ((POINTER STRUCT)) INT "get_XGCValues_ts_y_origin")
(foreign-function set-xgcvalues-ts_y_origin! ((POINTER STRUCT) INT) VOID "set_XGCValues_ts_y_origin")
(foreign-function xgcvalues-font ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_font")
(foreign-function set-xgcvalues-font! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_font")
(foreign-function xgcvalues-subwindow_mode ((POINTER STRUCT)) INT "get_XGCValues_subwindow_mode")
(foreign-function set-xgcvalues-subwindow_mode! ((POINTER STRUCT) INT) VOID "set_XGCValues_subwindow_mode")
(foreign-function xgcvalues-graphics_exposures ((POINTER STRUCT)) INT "get_XGCValues_graphics_exposures")
(foreign-function set-xgcvalues-graphics_exposures! ((POINTER STRUCT) INT) VOID "set_XGCValues_graphics_exposures")
(foreign-function xgcvalues-clip_x_origin ((POINTER STRUCT)) INT "get_XGCValues_clip_x_origin")
(foreign-function set-xgcvalues-clip_x_origin! ((POINTER STRUCT) INT) VOID "set_XGCValues_clip_x_origin")
(foreign-function xgcvalues-clip_y_origin ((POINTER STRUCT)) INT "get_XGCValues_clip_y_origin")
(foreign-function set-xgcvalues-clip_y_origin! ((POINTER STRUCT) INT) VOID "set_XGCValues_clip_y_origin")
(foreign-function xgcvalues-clip_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XGCValues_clip_mask")
(foreign-function set-xgcvalues-clip_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGCValues_clip_mask")
(foreign-function xgcvalues-dash_offset ((POINTER STRUCT)) INT "get_XGCValues_dash_offset")
(foreign-function set-xgcvalues-dash_offset! ((POINTER STRUCT) INT) VOID "set_XGCValues_dash_offset")
(foreign-function xgcvalues-dashes ((POINTER STRUCT)) CHAR "get_XGCValues_dashes")
(foreign-function set-xgcvalues-dashes! ((POINTER STRUCT) CHAR) VOID "set_XGCValues_dashes")
;;; STRUCT:Visual
(foreign-function make-visual () (POINTER STRUCT) "alloc_Visual")
(foreign-function free-visual ((POINTER STRUCT)) VOID "free_Visual")
(foreign-function visual-ext_data ((POINTER STRUCT)) (POINTER STRUCT) "get_Visual_ext_data")
(foreign-function set-visual-ext_data! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Visual_ext_data")
(foreign-function visual-visualid ((POINTER STRUCT)) UNSIGNED-LONG "get_Visual_visualid")
(foreign-function set-visual-visualid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Visual_visualid")
(foreign-function visual-class ((POINTER STRUCT)) INT "get_Visual_class")
(foreign-function set-visual-class! ((POINTER STRUCT) INT) VOID "set_Visual_class")
(foreign-function visual-red_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_Visual_red_mask")
(foreign-function set-visual-red_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Visual_red_mask")
(foreign-function visual-green_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_Visual_green_mask")
(foreign-function set-visual-green_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Visual_green_mask")
(foreign-function visual-blue_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_Visual_blue_mask")
(foreign-function set-visual-blue_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Visual_blue_mask")
(foreign-function visual-bits_per_rgb ((POINTER STRUCT)) INT "get_Visual_bits_per_rgb")
(foreign-function set-visual-bits_per_rgb! ((POINTER STRUCT) INT) VOID "set_Visual_bits_per_rgb")
(foreign-function visual-map_entries ((POINTER STRUCT)) INT "get_Visual_map_entries")
(foreign-function set-visual-map_entries! ((POINTER STRUCT) INT) VOID "set_Visual_map_entries")
;;; STRUCT:Depth
(foreign-function make-depth () (POINTER STRUCT) "alloc_Depth")
(foreign-function free-depth ((POINTER STRUCT)) VOID "free_Depth")
(foreign-function depth-depth ((POINTER STRUCT)) INT "get_Depth_depth")
(foreign-function set-depth-depth! ((POINTER STRUCT) INT) VOID "set_Depth_depth")
(foreign-function depth-nvisuals ((POINTER STRUCT)) INT "get_Depth_nvisuals")
(foreign-function set-depth-nvisuals! ((POINTER STRUCT) INT) VOID "set_Depth_nvisuals")
(foreign-function depth-visuals ((POINTER STRUCT)) (POINTER STRUCT) "get_Depth_visuals")
(foreign-function set-depth-visuals! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Depth_visuals")
;;; STRUCT:Screen
(foreign-function make-screen () (POINTER STRUCT) "alloc_Screen")
(foreign-function free-screen ((POINTER STRUCT)) VOID "free_Screen")
(foreign-function screen-ext_data ((POINTER STRUCT)) (POINTER STRUCT) "get_Screen_ext_data")
(foreign-function set-screen-ext_data! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Screen_ext_data")
(foreign-function screen-display ((POINTER STRUCT)) (POINTER STRUCT) "get_Screen_display")
(foreign-function set-screen-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Screen_display")
(foreign-function screen-root ((POINTER STRUCT)) UNSIGNED-LONG "get_Screen_root")
(foreign-function set-screen-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Screen_root")
(foreign-function screen-width ((POINTER STRUCT)) INT "get_Screen_width")
(foreign-function set-screen-width! ((POINTER STRUCT) INT) VOID "set_Screen_width")
(foreign-function screen-height ((POINTER STRUCT)) INT "get_Screen_height")
(foreign-function set-screen-height! ((POINTER STRUCT) INT) VOID "set_Screen_height")
(foreign-function screen-mwidth ((POINTER STRUCT)) INT "get_Screen_mwidth")
(foreign-function set-screen-mwidth! ((POINTER STRUCT) INT) VOID "set_Screen_mwidth")
(foreign-function screen-mheight ((POINTER STRUCT)) INT "get_Screen_mheight")
(foreign-function set-screen-mheight! ((POINTER STRUCT) INT) VOID "set_Screen_mheight")
(foreign-function screen-ndepths ((POINTER STRUCT)) INT "get_Screen_ndepths")
(foreign-function set-screen-ndepths! ((POINTER STRUCT) INT) VOID "set_Screen_ndepths")
(foreign-function screen-depths ((POINTER STRUCT)) (POINTER STRUCT) "get_Screen_depths")
(foreign-function set-screen-depths! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Screen_depths")
(foreign-function screen-root_depth ((POINTER STRUCT)) INT "get_Screen_root_depth")
(foreign-function set-screen-root_depth! ((POINTER STRUCT) INT) VOID "set_Screen_root_depth")
(foreign-function screen-root_visual ((POINTER STRUCT)) (POINTER STRUCT) "get_Screen_root_visual")
(foreign-function set-screen-root_visual! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Screen_root_visual")
(foreign-function screen-default_gc ((POINTER STRUCT)) (POINTER STRUCT) "get_Screen_default_gc")
(foreign-function set-screen-default_gc! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_Screen_default_gc")
(foreign-function screen-cmap ((POINTER STRUCT)) UNSIGNED-LONG "get_Screen_cmap")
(foreign-function set-screen-cmap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Screen_cmap")
(foreign-function screen-white_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_Screen_white_pixel")
(foreign-function set-screen-white_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Screen_white_pixel")
(foreign-function screen-black_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_Screen_black_pixel")
(foreign-function set-screen-black_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_Screen_black_pixel")
(foreign-function screen-max_maps ((POINTER STRUCT)) INT "get_Screen_max_maps")
(foreign-function set-screen-max_maps! ((POINTER STRUCT) INT) VOID "set_Screen_max_maps")
(foreign-function screen-min_maps ((POINTER STRUCT)) INT "get_Screen_min_maps")
(foreign-function set-screen-min_maps! ((POINTER STRUCT) INT) VOID "set_Screen_min_maps")
(foreign-function screen-backing_store ((POINTER STRUCT)) INT "get_Screen_backing_store")
(foreign-function set-screen-backing_store! ((POINTER STRUCT) INT) VOID "set_Screen_backing_store")
(foreign-function screen-save_unders ((POINTER STRUCT)) INT "get_Screen_save_unders")
(foreign-function set-screen-save_unders! ((POINTER STRUCT) INT) VOID "set_Screen_save_unders")
(foreign-function screen-root_input_mask ((POINTER STRUCT)) INT "get_Screen_root_input_mask")
(foreign-function set-screen-root_input_mask! ((POINTER STRUCT) INT) VOID "set_Screen_root_input_mask")
;;; STRUCT:Display (Remove accessors because this is "opaque")
;;; STRUCT:ScreenFormat
(foreign-function make-screenformat () (POINTER STRUCT) "alloc_ScreenFormat")
(foreign-function free-screenformat ((POINTER STRUCT)) VOID "free_ScreenFormat")
(foreign-function screenformat-ext_data ((POINTER STRUCT)) (POINTER STRUCT) "get_ScreenFormat_ext_data")
(foreign-function set-screenformat-ext_data! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_ScreenFormat_ext_data")
(foreign-function screenformat-depth ((POINTER STRUCT)) INT "get_ScreenFormat_depth")
(foreign-function set-screenformat-depth! ((POINTER STRUCT) INT) VOID "set_ScreenFormat_depth")
(foreign-function screenformat-bits_per_pixel ((POINTER STRUCT)) INT "get_ScreenFormat_bits_per_pixel")
(foreign-function set-screenformat-bits_per_pixel! ((POINTER STRUCT) INT) VOID "set_ScreenFormat_bits_per_pixel")
(foreign-function screenformat-scanline_pad ((POINTER STRUCT)) INT "get_ScreenFormat_scanline_pad")
(foreign-function set-screenformat-scanline_pad! ((POINTER STRUCT) INT) VOID "set_ScreenFormat_scanline_pad")
;;; STRUCT:XSetWindowAttributes
(foreign-function make-xsetwindowattributes () (POINTER STRUCT) "alloc_XSetWindowAttributes")
(foreign-function free-xsetwindowattributes ((POINTER STRUCT)) VOID "free_XSetWindowAttributes")
(foreign-function xsetwindowattributes-background_pixmap ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_background_pixmap")
(foreign-function set-xsetwindowattributes-background_pixmap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_background_pixmap")
(foreign-function xsetwindowattributes-background_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_background_pixel")
(foreign-function set-xsetwindowattributes-background_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_background_pixel")
(foreign-function xsetwindowattributes-border_pixmap ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_border_pixmap")
(foreign-function set-xsetwindowattributes-border_pixmap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_border_pixmap")
(foreign-function xsetwindowattributes-border_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_border_pixel")
(foreign-function set-xsetwindowattributes-border_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_border_pixel")
(foreign-function xsetwindowattributes-bit_gravity ((POINTER STRUCT)) INT "get_XSetWindowAttributes_bit_gravity")
(foreign-function set-xsetwindowattributes-bit_gravity! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_bit_gravity")
(foreign-function xsetwindowattributes-win_gravity ((POINTER STRUCT)) INT "get_XSetWindowAttributes_win_gravity")
(foreign-function set-xsetwindowattributes-win_gravity! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_win_gravity")
(foreign-function xsetwindowattributes-backing_store ((POINTER STRUCT)) INT "get_XSetWindowAttributes_backing_store")
(foreign-function set-xsetwindowattributes-backing_store! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_backing_store")
(foreign-function xsetwindowattributes-backing_planes ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_backing_planes")
(foreign-function set-xsetwindowattributes-backing_planes! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_backing_planes")
(foreign-function xsetwindowattributes-backing_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_backing_pixel")
(foreign-function set-xsetwindowattributes-backing_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_backing_pixel")
(foreign-function xsetwindowattributes-save_under ((POINTER STRUCT)) INT "get_XSetWindowAttributes_save_under")
(foreign-function set-xsetwindowattributes-save_under! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_save_under")
(foreign-function xsetwindowattributes-event_mask ((POINTER STRUCT)) INT "get_XSetWindowAttributes_event_mask")
(foreign-function set-xsetwindowattributes-event_mask! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_event_mask")
(foreign-function xsetwindowattributes-do_not_propagate_mask ((POINTER STRUCT)) INT "get_XSetWindowAttributes_do_not_propagate_mask")
(foreign-function set-xsetwindowattributes-do_not_propagate_mask! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_do_not_propagate_mask")
(foreign-function xsetwindowattributes-override_redirect ((POINTER STRUCT)) INT "get_XSetWindowAttributes_override_redirect")
(foreign-function set-xsetwindowattributes-override_redirect! ((POINTER STRUCT) INT) VOID "set_XSetWindowAttributes_override_redirect")
(foreign-function xsetwindowattributes-colormap ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_colormap")
(foreign-function set-xsetwindowattributes-colormap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_colormap")
(foreign-function xsetwindowattributes-cursor ((POINTER STRUCT)) UNSIGNED-LONG "get_XSetWindowAttributes_cursor")
(foreign-function set-xsetwindowattributes-cursor! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSetWindowAttributes_cursor")
;;; STRUCT:XWindowAttributes
(foreign-function make-xwindowattributes () (POINTER STRUCT) "alloc_XWindowAttributes")
(foreign-function free-xwindowattributes ((POINTER STRUCT)) VOID "free_XWindowAttributes")
(foreign-function xwindowattributes-x ((POINTER STRUCT)) INT "get_XWindowAttributes_x")
(foreign-function set-xwindowattributes-x! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_x")
(foreign-function xwindowattributes-y ((POINTER STRUCT)) INT "get_XWindowAttributes_y")
(foreign-function set-xwindowattributes-y! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_y")
(foreign-function xwindowattributes-width ((POINTER STRUCT)) INT "get_XWindowAttributes_width")
(foreign-function set-xwindowattributes-width! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_width")
(foreign-function xwindowattributes-height ((POINTER STRUCT)) INT "get_XWindowAttributes_height")
(foreign-function set-xwindowattributes-height! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_height")
(foreign-function xwindowattributes-border_width ((POINTER STRUCT)) INT "get_XWindowAttributes_border_width")
(foreign-function set-xwindowattributes-border_width! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_border_width")
(foreign-function xwindowattributes-depth ((POINTER STRUCT)) INT "get_XWindowAttributes_depth")
(foreign-function set-xwindowattributes-depth! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_depth")
(foreign-function xwindowattributes-visual ((POINTER STRUCT)) (POINTER STRUCT) "get_XWindowAttributes_visual")
(foreign-function set-xwindowattributes-visual! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XWindowAttributes_visual")
(foreign-function xwindowattributes-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XWindowAttributes_root")
(foreign-function set-xwindowattributes-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWindowAttributes_root")
(foreign-function xwindowattributes-class ((POINTER STRUCT)) INT "get_XWindowAttributes_class")
(foreign-function set-xwindowattributes-class! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_class")
(foreign-function xwindowattributes-bit_gravity ((POINTER STRUCT)) INT "get_XWindowAttributes_bit_gravity")
(foreign-function set-xwindowattributes-bit_gravity! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_bit_gravity")
(foreign-function xwindowattributes-win_gravity ((POINTER STRUCT)) INT "get_XWindowAttributes_win_gravity")
(foreign-function set-xwindowattributes-win_gravity! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_win_gravity")
(foreign-function xwindowattributes-backing_store ((POINTER STRUCT)) INT "get_XWindowAttributes_backing_store")
(foreign-function set-xwindowattributes-backing_store! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_backing_store")
(foreign-function xwindowattributes-backing_planes ((POINTER STRUCT)) UNSIGNED-LONG "get_XWindowAttributes_backing_planes")
(foreign-function set-xwindowattributes-backing_planes! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWindowAttributes_backing_planes")
(foreign-function xwindowattributes-backing_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XWindowAttributes_backing_pixel")
(foreign-function set-xwindowattributes-backing_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWindowAttributes_backing_pixel")
(foreign-function xwindowattributes-save_under ((POINTER STRUCT)) INT "get_XWindowAttributes_save_under")
(foreign-function set-xwindowattributes-save_under! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_save_under")
(foreign-function xwindowattributes-colormap ((POINTER STRUCT)) UNSIGNED-LONG "get_XWindowAttributes_colormap")
(foreign-function set-xwindowattributes-colormap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWindowAttributes_colormap")
(foreign-function xwindowattributes-map_installed ((POINTER STRUCT)) INT "get_XWindowAttributes_map_installed")
(foreign-function set-xwindowattributes-map_installed! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_map_installed")
(foreign-function xwindowattributes-map_state ((POINTER STRUCT)) INT "get_XWindowAttributes_map_state")
(foreign-function set-xwindowattributes-map_state! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_map_state")
(foreign-function xwindowattributes-all_event_masks ((POINTER STRUCT)) INT "get_XWindowAttributes_all_event_masks")
(foreign-function set-xwindowattributes-all_event_masks! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_all_event_masks")
(foreign-function xwindowattributes-your_event_mask ((POINTER STRUCT)) INT "get_XWindowAttributes_your_event_mask")
(foreign-function set-xwindowattributes-your_event_mask! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_your_event_mask")
(foreign-function xwindowattributes-do_not_propagate_mask ((POINTER STRUCT)) INT "get_XWindowAttributes_do_not_propagate_mask")
(foreign-function set-xwindowattributes-do_not_propagate_mask! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_do_not_propagate_mask")
(foreign-function xwindowattributes-override_redirect ((POINTER STRUCT)) INT "get_XWindowAttributes_override_redirect")
(foreign-function set-xwindowattributes-override_redirect! ((POINTER STRUCT) INT) VOID "set_XWindowAttributes_override_redirect")
(foreign-function xwindowattributes-screen ((POINTER STRUCT)) (POINTER STRUCT) "get_XWindowAttributes_screen")
(foreign-function set-xwindowattributes-screen! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XWindowAttributes_screen")
;;; STRUCT:XHostAddress
(foreign-function make-xhostaddress () (POINTER STRUCT) "alloc_XHostAddress")
(foreign-function free-xhostaddress ((POINTER STRUCT)) VOID "free_XHostAddress")
(foreign-function xhostaddress-family ((POINTER STRUCT)) INT "get_XHostAddress_family")
(foreign-function set-xhostaddress-family! ((POINTER STRUCT) INT) VOID "set_XHostAddress_family")
(foreign-function xhostaddress-length ((POINTER STRUCT)) INT "get_XHostAddress_length")
(foreign-function set-xhostaddress-length! ((POINTER STRUCT) INT) VOID "set_XHostAddress_length")
(foreign-function xhostaddress-address ((POINTER STRUCT)) (POINTER CHAR) "get_XHostAddress_address")
(foreign-function set-xhostaddress-address! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XHostAddress_address")
;;; STRUCT:XImage
(foreign-function make-ximage () (POINTER STRUCT) "alloc_XImage")
(foreign-function free-ximage ((POINTER STRUCT)) VOID "free_XImage")
(foreign-function ximage-width ((POINTER STRUCT)) INT "get_XImage_width")
(foreign-function set-ximage-width! ((POINTER STRUCT) INT) VOID "set_XImage_width")
(foreign-function ximage-height ((POINTER STRUCT)) INT "get_XImage_height")
(foreign-function set-ximage-height! ((POINTER STRUCT) INT) VOID "set_XImage_height")
(foreign-function ximage-xoffset ((POINTER STRUCT)) INT "get_XImage_xoffset")
(foreign-function set-ximage-xoffset! ((POINTER STRUCT) INT) VOID "set_XImage_xoffset")
(foreign-function ximage-format ((POINTER STRUCT)) INT "get_XImage_format")
(foreign-function set-ximage-format! ((POINTER STRUCT) INT) VOID "set_XImage_format")
(foreign-function ximage-data ((POINTER STRUCT)) (POINTER CHAR) "get_XImage_data")
(foreign-function set-ximage-data! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XImage_data")
(foreign-function ximage-byte_order ((POINTER STRUCT)) INT "get_XImage_byte_order")
(foreign-function set-ximage-byte_order! ((POINTER STRUCT) INT) VOID "set_XImage_byte_order")
(foreign-function ximage-bitmap_unit ((POINTER STRUCT)) INT "get_XImage_bitmap_unit")
(foreign-function set-ximage-bitmap_unit! ((POINTER STRUCT) INT) VOID "set_XImage_bitmap_unit")
(foreign-function ximage-bitmap_bit_order ((POINTER STRUCT)) INT "get_XImage_bitmap_bit_order")
(foreign-function set-ximage-bitmap_bit_order! ((POINTER STRUCT) INT) VOID "set_XImage_bitmap_bit_order")
(foreign-function ximage-bitmap_pad ((POINTER STRUCT)) INT "get_XImage_bitmap_pad")
(foreign-function set-ximage-bitmap_pad! ((POINTER STRUCT) INT) VOID "set_XImage_bitmap_pad")
(foreign-function ximage-depth ((POINTER STRUCT)) INT "get_XImage_depth")
(foreign-function set-ximage-depth! ((POINTER STRUCT) INT) VOID "set_XImage_depth")
(foreign-function ximage-bytes_per_line ((POINTER STRUCT)) INT "get_XImage_bytes_per_line")
(foreign-function set-ximage-bytes_per_line! ((POINTER STRUCT) INT) VOID "set_XImage_bytes_per_line")
(foreign-function ximage-bits_per_pixel ((POINTER STRUCT)) INT "get_XImage_bits_per_pixel")
(foreign-function set-ximage-bits_per_pixel! ((POINTER STRUCT) INT) VOID "set_XImage_bits_per_pixel")
(foreign-function ximage-red_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XImage_red_mask")
(foreign-function set-ximage-red_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XImage_red_mask")
(foreign-function ximage-green_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XImage_green_mask")
(foreign-function set-ximage-green_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XImage_green_mask")
(foreign-function ximage-blue_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XImage_blue_mask")
(foreign-function set-ximage-blue_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XImage_blue_mask")
(foreign-function ximage-obdata ((POINTER STRUCT)) (POINTER CHAR) "get_XImage_obdata")
(foreign-function set-ximage-obdata! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XImage_obdata")
(foreign-function ximage-f-create_image ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_create_image")
(foreign-function set-ximage-f-create_image! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_create_image")
(foreign-function ximage-f-destroy_image ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_destroy_image")
(foreign-function set-ximage-f-destroy_image! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_destroy_image")
(foreign-function ximage-f-get_pixel ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_get_pixel")
(foreign-function set-ximage-f-get_pixel! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_get_pixel")
(foreign-function ximage-f-put_pixel ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_put_pixel")
(foreign-function set-ximage-f-put_pixel! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_put_pixel")
(foreign-function ximage-f-sub_image ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_sub_image")
(foreign-function set-ximage-f-sub_image! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_sub_image")
(foreign-function ximage-f-add_pixel ((POINTER STRUCT)) (POINTER FUNCTION) "get_XImage_f_add_pixel")
(foreign-function set-ximage-f-add_pixel! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XImage_f_add_pixel")
;;; STRUCT:XWindowChanges
(foreign-function make-xwindowchanges () (POINTER STRUCT) "alloc_XWindowChanges")
(foreign-function free-xwindowchanges ((POINTER STRUCT)) VOID "free_XWindowChanges")
(foreign-function xwindowchanges-x ((POINTER STRUCT)) INT "get_XWindowChanges_x")
(foreign-function set-xwindowchanges-x! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_x")
(foreign-function xwindowchanges-y ((POINTER STRUCT)) INT "get_XWindowChanges_y")
(foreign-function set-xwindowchanges-y! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_y")
(foreign-function xwindowchanges-width ((POINTER STRUCT)) INT "get_XWindowChanges_width")
(foreign-function set-xwindowchanges-width! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_width")
(foreign-function xwindowchanges-height ((POINTER STRUCT)) INT "get_XWindowChanges_height")
(foreign-function set-xwindowchanges-height! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_height")
(foreign-function xwindowchanges-border_width ((POINTER STRUCT)) INT "get_XWindowChanges_border_width")
(foreign-function set-xwindowchanges-border_width! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_border_width")
(foreign-function xwindowchanges-sibling ((POINTER STRUCT)) UNSIGNED-LONG "get_XWindowChanges_sibling")
(foreign-function set-xwindowchanges-sibling! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWindowChanges_sibling")
(foreign-function xwindowchanges-stack_mode ((POINTER STRUCT)) INT "get_XWindowChanges_stack_mode")
(foreign-function set-xwindowchanges-stack_mode! ((POINTER STRUCT) INT) VOID "set_XWindowChanges_stack_mode")
;;; STRUCT:XColor
(foreign-function make-xcolor () (POINTER STRUCT) "alloc_XColor")
(foreign-function free-xcolor ((POINTER STRUCT)) VOID "free_XColor")
(foreign-function xcolor-pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XColor_pixel")
(foreign-function set-xcolor-pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XColor_pixel")
(foreign-function xcolor-red ((POINTER STRUCT)) UNSIGNED-SHORT "get_XColor_red")
(foreign-function set-xcolor-red! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XColor_red")
(foreign-function xcolor-green ((POINTER STRUCT)) UNSIGNED-SHORT "get_XColor_green")
(foreign-function set-xcolor-green! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XColor_green")
(foreign-function xcolor-blue ((POINTER STRUCT)) UNSIGNED-SHORT "get_XColor_blue")
(foreign-function set-xcolor-blue! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XColor_blue")
(foreign-function xcolor-flags ((POINTER STRUCT)) CHAR "get_XColor_flags")
(foreign-function set-xcolor-flags! ((POINTER STRUCT) CHAR) VOID "set_XColor_flags")
(foreign-function xcolor-pad ((POINTER STRUCT)) CHAR "get_XColor_pad")
(foreign-function set-xcolor-pad! ((POINTER STRUCT) CHAR) VOID "set_XColor_pad")
;;; STRUCT:XSegment
(foreign-function make-xsegment () (POINTER STRUCT) "alloc_XSegment")
(foreign-function free-xsegment ((POINTER STRUCT)) VOID "free_XSegment")
(foreign-function xsegment-x1 ((POINTER STRUCT)) SHORT "get_XSegment_x1")
(foreign-function set-xsegment-x1! ((POINTER STRUCT) SHORT) VOID "set_XSegment_x1")
(foreign-function xsegment-y1 ((POINTER STRUCT)) SHORT "get_XSegment_y1")
(foreign-function set-xsegment-y1! ((POINTER STRUCT) SHORT) VOID "set_XSegment_y1")
(foreign-function xsegment-x2 ((POINTER STRUCT)) SHORT "get_XSegment_x2")
(foreign-function set-xsegment-x2! ((POINTER STRUCT) SHORT) VOID "set_XSegment_x2")
(foreign-function xsegment-y2 ((POINTER STRUCT)) SHORT "get_XSegment_y2")
(foreign-function set-xsegment-y2! ((POINTER STRUCT) SHORT) VOID "set_XSegment_y2")
;;; STRUCT:XPoint
(foreign-function make-xpoint () (POINTER STRUCT) "alloc_XPoint")
(foreign-function free-xpoint ((POINTER STRUCT)) VOID "free_XPoint")
(foreign-function xpoint-x ((POINTER STRUCT)) SHORT "get_XPoint_x")
(foreign-function set-xpoint-x! ((POINTER STRUCT) SHORT) VOID "set_XPoint_x")
(foreign-function xpoint-y ((POINTER STRUCT)) SHORT "get_XPoint_y")
(foreign-function set-xpoint-y! ((POINTER STRUCT) SHORT) VOID "set_XPoint_y")
;;; STRUCT:XRectangle
(foreign-function make-xrectangle () (POINTER STRUCT) "alloc_XRectangle")
(foreign-function free-xrectangle ((POINTER STRUCT)) VOID "free_XRectangle")
(foreign-function xrectangle-x ((POINTER STRUCT)) SHORT "get_XRectangle_x")
(foreign-function set-xrectangle-x! ((POINTER STRUCT) SHORT) VOID "set_XRectangle_x")
(foreign-function xrectangle-y ((POINTER STRUCT)) SHORT "get_XRectangle_y")
(foreign-function set-xrectangle-y! ((POINTER STRUCT) SHORT) VOID "set_XRectangle_y")
(foreign-function xrectangle-width ((POINTER STRUCT)) UNSIGNED-SHORT "get_XRectangle_width")
(foreign-function set-xrectangle-width! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XRectangle_width")
(foreign-function xrectangle-height ((POINTER STRUCT)) UNSIGNED-SHORT "get_XRectangle_height")
(foreign-function set-xrectangle-height! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XRectangle_height")
;;; STRUCT:XArc
(foreign-function make-xarc () (POINTER STRUCT) "alloc_XArc")
(foreign-function free-xarc ((POINTER STRUCT)) VOID "free_XArc")
(foreign-function xarc-x ((POINTER STRUCT)) SHORT "get_XArc_x")
(foreign-function set-xarc-x! ((POINTER STRUCT) SHORT) VOID "set_XArc_x")
(foreign-function xarc-y ((POINTER STRUCT)) SHORT "get_XArc_y")
(foreign-function set-xarc-y! ((POINTER STRUCT) SHORT) VOID "set_XArc_y")
(foreign-function xarc-width ((POINTER STRUCT)) UNSIGNED-SHORT "get_XArc_width")
(foreign-function set-xarc-width! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XArc_width")
(foreign-function xarc-height ((POINTER STRUCT)) UNSIGNED-SHORT "get_XArc_height")
(foreign-function set-xarc-height! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XArc_height")
(foreign-function xarc-angle1 ((POINTER STRUCT)) SHORT "get_XArc_angle1")
(foreign-function set-xarc-angle1! ((POINTER STRUCT) SHORT) VOID "set_XArc_angle1")
(foreign-function xarc-angle2 ((POINTER STRUCT)) SHORT "get_XArc_angle2")
(foreign-function set-xarc-angle2! ((POINTER STRUCT) SHORT) VOID "set_XArc_angle2")
;;; STRUCT:XKeyboardControl
(foreign-function make-xkeyboardcontrol () (POINTER STRUCT) "alloc_XKeyboardControl")
(foreign-function free-xkeyboardcontrol ((POINTER STRUCT)) VOID "free_XKeyboardControl")
(foreign-function xkeyboardcontrol-key_click_percent ((POINTER STRUCT)) INT "get_XKeyboardControl_key_click_percent")
(foreign-function set-xkeyboardcontrol-key_click_percent! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_key_click_percent")
(foreign-function xkeyboardcontrol-bell_percent ((POINTER STRUCT)) INT "get_XKeyboardControl_bell_percent")
(foreign-function set-xkeyboardcontrol-bell_percent! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_bell_percent")
(foreign-function xkeyboardcontrol-bell_pitch ((POINTER STRUCT)) INT "get_XKeyboardControl_bell_pitch")
(foreign-function set-xkeyboardcontrol-bell_pitch! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_bell_pitch")
(foreign-function xkeyboardcontrol-bell_duration ((POINTER STRUCT)) INT "get_XKeyboardControl_bell_duration")
(foreign-function set-xkeyboardcontrol-bell_duration! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_bell_duration")
(foreign-function xkeyboardcontrol-led ((POINTER STRUCT)) INT "get_XKeyboardControl_led")
(foreign-function set-xkeyboardcontrol-led! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_led")
(foreign-function xkeyboardcontrol-led_mode ((POINTER STRUCT)) INT "get_XKeyboardControl_led_mode")
(foreign-function set-xkeyboardcontrol-led_mode! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_led_mode")
(foreign-function xkeyboardcontrol-key ((POINTER STRUCT)) INT "get_XKeyboardControl_key")
(foreign-function set-xkeyboardcontrol-key! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_key")
(foreign-function xkeyboardcontrol-auto_repeat_mode ((POINTER STRUCT)) INT "get_XKeyboardControl_auto_repeat_mode")
(foreign-function set-xkeyboardcontrol-auto_repeat_mode! ((POINTER STRUCT) INT) VOID "set_XKeyboardControl_auto_repeat_mode")
;;; STRUCT:XKeyboardState
(foreign-function make-xkeyboardstate () (POINTER STRUCT) "alloc_XKeyboardState")
(foreign-function free-xkeyboardstate ((POINTER STRUCT)) VOID "free_XKeyboardState")
(foreign-function xkeyboardstate-key_click_percent ((POINTER STRUCT)) INT "get_XKeyboardState_key_click_percent")
(foreign-function set-xkeyboardstate-key_click_percent! ((POINTER STRUCT) INT) VOID "set_XKeyboardState_key_click_percent")
(foreign-function xkeyboardstate-bell_percent ((POINTER STRUCT)) INT "get_XKeyboardState_bell_percent")
(foreign-function set-xkeyboardstate-bell_percent! ((POINTER STRUCT) INT) VOID "set_XKeyboardState_bell_percent")
(foreign-function xkeyboardstate-bell_pitch ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyboardState_bell_pitch")
(foreign-function set-xkeyboardstate-bell_pitch! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyboardState_bell_pitch")
(foreign-function xkeyboardstate-bell_duration ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyboardState_bell_duration")
(foreign-function set-xkeyboardstate-bell_duration! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyboardState_bell_duration")
(foreign-function xkeyboardstate-led_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyboardState_led_mask")
(foreign-function set-xkeyboardstate-led_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyboardState_led_mask")
(foreign-function xkeyboardstate-global_auto_repeat ((POINTER STRUCT)) INT "get_XKeyboardState_global_auto_repeat")
(foreign-function set-xkeyboardstate-global_auto_repeat! ((POINTER STRUCT) INT) VOID "set_XKeyboardState_global_auto_repeat")
(foreign-function xkeyboardstate-auto_repeats ((POINTER STRUCT)) POINTER "get_XKeyboardState_auto_repeats")
;;; STRUCT:XTimeCoord
(foreign-function make-xtimecoord () (POINTER STRUCT) "alloc_XTimeCoord")
(foreign-function free-xtimecoord ((POINTER STRUCT)) VOID "free_XTimeCoord")
(foreign-function xtimecoord-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XTimeCoord_time")
(foreign-function set-xtimecoord-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XTimeCoord_time")
(foreign-function xtimecoord-x ((POINTER STRUCT)) SHORT "get_XTimeCoord_x")
(foreign-function set-xtimecoord-x! ((POINTER STRUCT) SHORT) VOID "set_XTimeCoord_x")
(foreign-function xtimecoord-y ((POINTER STRUCT)) SHORT "get_XTimeCoord_y")
(foreign-function set-xtimecoord-y! ((POINTER STRUCT) SHORT) VOID "set_XTimeCoord_y")
;;; STRUCT:XModifierKeymap
(foreign-function make-xmodifierkeymap () (POINTER STRUCT) "alloc_XModifierKeymap")
(foreign-function free-xmodifierkeymap ((POINTER STRUCT)) VOID "free_XModifierKeymap")
(foreign-function xmodifierkeymap-max_keypermod ((POINTER STRUCT)) INT "get_XModifierKeymap_max_keypermod")
(foreign-function set-xmodifierkeymap-max_keypermod! ((POINTER STRUCT) INT) VOID "set_XModifierKeymap_max_keypermod")
(foreign-function xmodifierkeymap-modifiermap ((POINTER STRUCT)) (POINTER UNSIGNED-CHAR) "get_XModifierKeymap_modifiermap")
(foreign-function set-xmodifierkeymap-modifiermap! ((POINTER STRUCT) (POINTER UNSIGNED-CHAR)) VOID "set_XModifierKeymap_modifiermap")
;;; STRUCT:XKeyReleasedEvent
(foreign-function make-xkeyreleasedevent () (POINTER STRUCT) "alloc_XKeyReleasedEvent")
(foreign-function free-xkeyreleasedevent ((POINTER STRUCT)) VOID "free_XKeyReleasedEvent")
(foreign-function xkeyreleasedevent-type ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_type")
(foreign-function set-xkeyreleasedevent-type! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_type")
(foreign-function xkeyreleasedevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyReleasedEvent_serial")
(foreign-function set-xkeyreleasedevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyReleasedEvent_serial")
(foreign-function xkeyreleasedevent-send_event ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_send_event")
(foreign-function set-xkeyreleasedevent-send_event! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_send_event")
(foreign-function xkeyreleasedevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XKeyReleasedEvent_display")
(foreign-function set-xkeyreleasedevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XKeyReleasedEvent_display")
(foreign-function xkeyreleasedevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyReleasedEvent_window")
(foreign-function set-xkeyreleasedevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyReleasedEvent_window")
(foreign-function xkeyreleasedevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyReleasedEvent_root")
(foreign-function set-xkeyreleasedevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyReleasedEvent_root")
(foreign-function xkeyreleasedevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyReleasedEvent_subwindow")
(foreign-function set-xkeyreleasedevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyReleasedEvent_subwindow")
(foreign-function xkeyreleasedevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyReleasedEvent_time")
(foreign-function set-xkeyreleasedevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyReleasedEvent_time")
(foreign-function xkeyreleasedevent-x ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_x")
(foreign-function set-xkeyreleasedevent-x! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_x")
(foreign-function xkeyreleasedevent-y ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_y")
(foreign-function set-xkeyreleasedevent-y! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_y")
(foreign-function xkeyreleasedevent-x_root ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_x_root")
(foreign-function set-xkeyreleasedevent-x_root! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_x_root")
(foreign-function xkeyreleasedevent-y_root ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_y_root")
(foreign-function set-xkeyreleasedevent-y_root! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_y_root")
(foreign-function xkeyreleasedevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyReleasedEvent_state")
(foreign-function set-xkeyreleasedevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyReleasedEvent_state")
(foreign-function xkeyreleasedevent-keycode ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyReleasedEvent_keycode")
(foreign-function set-xkeyreleasedevent-keycode! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyReleasedEvent_keycode")
(foreign-function xkeyreleasedevent-same_screen ((POINTER STRUCT)) INT "get_XKeyReleasedEvent_same_screen")
(foreign-function set-xkeyreleasedevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XKeyReleasedEvent_same_screen")
;;; STRUCT:XKeyPressedEvent
(foreign-function make-xkeypressedevent () (POINTER STRUCT) "alloc_XKeyPressedEvent")
(foreign-function free-xkeypressedevent ((POINTER STRUCT)) VOID "free_XKeyPressedEvent")
(foreign-function xkeypressedevent-type ((POINTER STRUCT)) INT "get_XKeyPressedEvent_type")
(foreign-function set-xkeypressedevent-type! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_type")
(foreign-function xkeypressedevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyPressedEvent_serial")
(foreign-function set-xkeypressedevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyPressedEvent_serial")
(foreign-function xkeypressedevent-send_event ((POINTER STRUCT)) INT "get_XKeyPressedEvent_send_event")
(foreign-function set-xkeypressedevent-send_event! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_send_event")
(foreign-function xkeypressedevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XKeyPressedEvent_display")
(foreign-function set-xkeypressedevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XKeyPressedEvent_display")
(foreign-function xkeypressedevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyPressedEvent_window")
(foreign-function set-xkeypressedevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyPressedEvent_window")
(foreign-function xkeypressedevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyPressedEvent_root")
(foreign-function set-xkeypressedevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyPressedEvent_root")
(foreign-function xkeypressedevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyPressedEvent_subwindow")
(foreign-function set-xkeypressedevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyPressedEvent_subwindow")
(foreign-function xkeypressedevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyPressedEvent_time")
(foreign-function set-xkeypressedevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyPressedEvent_time")
(foreign-function xkeypressedevent-x ((POINTER STRUCT)) INT "get_XKeyPressedEvent_x")
(foreign-function set-xkeypressedevent-x! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_x")
(foreign-function xkeypressedevent-y ((POINTER STRUCT)) INT "get_XKeyPressedEvent_y")
(foreign-function set-xkeypressedevent-y! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_y")
(foreign-function xkeypressedevent-x_root ((POINTER STRUCT)) INT "get_XKeyPressedEvent_x_root")
(foreign-function set-xkeypressedevent-x_root! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_x_root")
(foreign-function xkeypressedevent-y_root ((POINTER STRUCT)) INT "get_XKeyPressedEvent_y_root")
(foreign-function set-xkeypressedevent-y_root! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_y_root")
(foreign-function xkeypressedevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyPressedEvent_state")
(foreign-function set-xkeypressedevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyPressedEvent_state")
(foreign-function xkeypressedevent-keycode ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyPressedEvent_keycode")
(foreign-function set-xkeypressedevent-keycode! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyPressedEvent_keycode")
(foreign-function xkeypressedevent-same_screen ((POINTER STRUCT)) INT "get_XKeyPressedEvent_same_screen")
(foreign-function set-xkeypressedevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XKeyPressedEvent_same_screen")
;;; STRUCT:XKeyEvent
(foreign-function make-xkeyevent () (POINTER STRUCT) "alloc_XKeyEvent")
(foreign-function free-xkeyevent ((POINTER STRUCT)) VOID "free_XKeyEvent")
(foreign-function xkeyevent-type ((POINTER STRUCT)) INT "get_XKeyEvent_type")
(foreign-function set-xkeyevent-type! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_type")
(foreign-function xkeyevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyEvent_serial")
(foreign-function set-xkeyevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyEvent_serial")
(foreign-function xkeyevent-send_event ((POINTER STRUCT)) INT "get_XKeyEvent_send_event")
(foreign-function set-xkeyevent-send_event! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_send_event")
(foreign-function xkeyevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XKeyEvent_display")
(foreign-function set-xkeyevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XKeyEvent_display")
(foreign-function xkeyevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyEvent_window")
(foreign-function set-xkeyevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyEvent_window")
(foreign-function xkeyevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyEvent_root")
(foreign-function set-xkeyevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyEvent_root")
(foreign-function xkeyevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyEvent_subwindow")
(foreign-function set-xkeyevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyEvent_subwindow")
(foreign-function xkeyevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeyEvent_time")
(foreign-function set-xkeyevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeyEvent_time")
(foreign-function xkeyevent-x ((POINTER STRUCT)) INT "get_XKeyEvent_x")
(foreign-function set-xkeyevent-x! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_x")
(foreign-function xkeyevent-y ((POINTER STRUCT)) INT "get_XKeyEvent_y")
(foreign-function set-xkeyevent-y! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_y")
(foreign-function xkeyevent-x_root ((POINTER STRUCT)) INT "get_XKeyEvent_x_root")
(foreign-function set-xkeyevent-x_root! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_x_root")
(foreign-function xkeyevent-y_root ((POINTER STRUCT)) INT "get_XKeyEvent_y_root")
(foreign-function set-xkeyevent-y_root! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_y_root")
(foreign-function xkeyevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyEvent_state")
(foreign-function set-xkeyevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyEvent_state")
(foreign-function xkeyevent-keycode ((POINTER STRUCT)) UNSIGNED-INT "get_XKeyEvent_keycode")
(foreign-function set-xkeyevent-keycode! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XKeyEvent_keycode")
(foreign-function xkeyevent-same_screen ((POINTER STRUCT)) INT "get_XKeyEvent_same_screen")
(foreign-function set-xkeyevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XKeyEvent_same_screen")
;;; STRUCT:XButtonReleasedEvent
(foreign-function make-xbuttonreleasedevent () (POINTER STRUCT) "alloc_XButtonReleasedEvent")
(foreign-function free-xbuttonreleasedevent ((POINTER STRUCT)) VOID "free_XButtonReleasedEvent")
(foreign-function xbuttonreleasedevent-type ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_type")
(foreign-function set-xbuttonreleasedevent-type! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_type")
(foreign-function xbuttonreleasedevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonReleasedEvent_serial")
(foreign-function set-xbuttonreleasedevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonReleasedEvent_serial")
(foreign-function xbuttonreleasedevent-send_event ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_send_event")
(foreign-function set-xbuttonreleasedevent-send_event! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_send_event")
(foreign-function xbuttonreleasedevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XButtonReleasedEvent_display")
(foreign-function set-xbuttonreleasedevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XButtonReleasedEvent_display")
(foreign-function xbuttonreleasedevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonReleasedEvent_window")
(foreign-function set-xbuttonreleasedevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonReleasedEvent_window")
(foreign-function xbuttonreleasedevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonReleasedEvent_root")
(foreign-function set-xbuttonreleasedevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonReleasedEvent_root")
(foreign-function xbuttonreleasedevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonReleasedEvent_subwindow")
(foreign-function set-xbuttonreleasedevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonReleasedEvent_subwindow")
(foreign-function xbuttonreleasedevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonReleasedEvent_time")
(foreign-function set-xbuttonreleasedevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonReleasedEvent_time")
(foreign-function xbuttonreleasedevent-x ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_x")
(foreign-function set-xbuttonreleasedevent-x! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_x")
(foreign-function xbuttonreleasedevent-y ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_y")
(foreign-function set-xbuttonreleasedevent-y! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_y")
(foreign-function xbuttonreleasedevent-x_root ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_x_root")
(foreign-function set-xbuttonreleasedevent-x_root! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_x_root")
(foreign-function xbuttonreleasedevent-y_root ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_y_root")
(foreign-function set-xbuttonreleasedevent-y_root! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_y_root")
(foreign-function xbuttonreleasedevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonReleasedEvent_state")
(foreign-function set-xbuttonreleasedevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonReleasedEvent_state")
(foreign-function xbuttonreleasedevent-button ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonReleasedEvent_button")
(foreign-function set-xbuttonreleasedevent-button! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonReleasedEvent_button")
(foreign-function xbuttonreleasedevent-same_screen ((POINTER STRUCT)) INT "get_XButtonReleasedEvent_same_screen")
(foreign-function set-xbuttonreleasedevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XButtonReleasedEvent_same_screen")
;;; STRUCT:XButtonPressedEvent
(foreign-function make-xbuttonpressedevent () (POINTER STRUCT) "alloc_XButtonPressedEvent")
(foreign-function free-xbuttonpressedevent ((POINTER STRUCT)) VOID "free_XButtonPressedEvent")
(foreign-function xbuttonpressedevent-type ((POINTER STRUCT)) INT "get_XButtonPressedEvent_type")
(foreign-function set-xbuttonpressedevent-type! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_type")
(foreign-function xbuttonpressedevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonPressedEvent_serial")
(foreign-function set-xbuttonpressedevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonPressedEvent_serial")
(foreign-function xbuttonpressedevent-send_event ((POINTER STRUCT)) INT "get_XButtonPressedEvent_send_event")
(foreign-function set-xbuttonpressedevent-send_event! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_send_event")
(foreign-function xbuttonpressedevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XButtonPressedEvent_display")
(foreign-function set-xbuttonpressedevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XButtonPressedEvent_display")
(foreign-function xbuttonpressedevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonPressedEvent_window")
(foreign-function set-xbuttonpressedevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonPressedEvent_window")
(foreign-function xbuttonpressedevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonPressedEvent_root")
(foreign-function set-xbuttonpressedevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonPressedEvent_root")
(foreign-function xbuttonpressedevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonPressedEvent_subwindow")
(foreign-function set-xbuttonpressedevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonPressedEvent_subwindow")
(foreign-function xbuttonpressedevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonPressedEvent_time")
(foreign-function set-xbuttonpressedevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonPressedEvent_time")
(foreign-function xbuttonpressedevent-x ((POINTER STRUCT)) INT "get_XButtonPressedEvent_x")
(foreign-function set-xbuttonpressedevent-x! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_x")
(foreign-function xbuttonpressedevent-y ((POINTER STRUCT)) INT "get_XButtonPressedEvent_y")
(foreign-function set-xbuttonpressedevent-y! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_y")
(foreign-function xbuttonpressedevent-x_root ((POINTER STRUCT)) INT "get_XButtonPressedEvent_x_root")
(foreign-function set-xbuttonpressedevent-x_root! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_x_root")
(foreign-function xbuttonpressedevent-y_root ((POINTER STRUCT)) INT "get_XButtonPressedEvent_y_root")
(foreign-function set-xbuttonpressedevent-y_root! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_y_root")
(foreign-function xbuttonpressedevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonPressedEvent_state")
(foreign-function set-xbuttonpressedevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonPressedEvent_state")
(foreign-function xbuttonpressedevent-button ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonPressedEvent_button")
(foreign-function set-xbuttonpressedevent-button! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonPressedEvent_button")
(foreign-function xbuttonpressedevent-same_screen ((POINTER STRUCT)) INT "get_XButtonPressedEvent_same_screen")
(foreign-function set-xbuttonpressedevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XButtonPressedEvent_same_screen")
;;; STRUCT:XButtonEvent
(foreign-function make-xbuttonevent () (POINTER STRUCT) "alloc_XButtonEvent")
(foreign-function free-xbuttonevent ((POINTER STRUCT)) VOID "free_XButtonEvent")
(foreign-function xbuttonevent-type ((POINTER STRUCT)) INT "get_XButtonEvent_type")
(foreign-function set-xbuttonevent-type! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_type")
(foreign-function xbuttonevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonEvent_serial")
(foreign-function set-xbuttonevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonEvent_serial")
(foreign-function xbuttonevent-send_event ((POINTER STRUCT)) INT "get_XButtonEvent_send_event")
(foreign-function set-xbuttonevent-send_event! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_send_event")
(foreign-function xbuttonevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XButtonEvent_display")
(foreign-function set-xbuttonevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XButtonEvent_display")
(foreign-function xbuttonevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonEvent_window")
(foreign-function set-xbuttonevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonEvent_window")
(foreign-function xbuttonevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonEvent_root")
(foreign-function set-xbuttonevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonEvent_root")
(foreign-function xbuttonevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonEvent_subwindow")
(foreign-function set-xbuttonevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonEvent_subwindow")
(foreign-function xbuttonevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XButtonEvent_time")
(foreign-function set-xbuttonevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XButtonEvent_time")
(foreign-function xbuttonevent-x ((POINTER STRUCT)) INT "get_XButtonEvent_x")
(foreign-function set-xbuttonevent-x! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_x")
(foreign-function xbuttonevent-y ((POINTER STRUCT)) INT "get_XButtonEvent_y")
(foreign-function set-xbuttonevent-y! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_y")
(foreign-function xbuttonevent-x_root ((POINTER STRUCT)) INT "get_XButtonEvent_x_root")
(foreign-function set-xbuttonevent-x_root! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_x_root")
(foreign-function xbuttonevent-y_root ((POINTER STRUCT)) INT "get_XButtonEvent_y_root")
(foreign-function set-xbuttonevent-y_root! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_y_root")
(foreign-function xbuttonevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonEvent_state")
(foreign-function set-xbuttonevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonEvent_state")
(foreign-function xbuttonevent-button ((POINTER STRUCT)) UNSIGNED-INT "get_XButtonEvent_button")
(foreign-function set-xbuttonevent-button! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XButtonEvent_button")
(foreign-function xbuttonevent-same_screen ((POINTER STRUCT)) INT "get_XButtonEvent_same_screen")
(foreign-function set-xbuttonevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XButtonEvent_same_screen")
;;; STRUCT:XPointerMovedEvent
(foreign-function make-xpointermovedevent () (POINTER STRUCT) "alloc_XPointerMovedEvent")
(foreign-function free-xpointermovedevent ((POINTER STRUCT)) VOID "free_XPointerMovedEvent")
(foreign-function xpointermovedevent-type ((POINTER STRUCT)) INT "get_XPointerMovedEvent_type")
(foreign-function set-xpointermovedevent-type! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_type")
(foreign-function xpointermovedevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XPointerMovedEvent_serial")
(foreign-function set-xpointermovedevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPointerMovedEvent_serial")
(foreign-function xpointermovedevent-send_event ((POINTER STRUCT)) INT "get_XPointerMovedEvent_send_event")
(foreign-function set-xpointermovedevent-send_event! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_send_event")
(foreign-function xpointermovedevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XPointerMovedEvent_display")
(foreign-function set-xpointermovedevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XPointerMovedEvent_display")
(foreign-function xpointermovedevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XPointerMovedEvent_window")
(foreign-function set-xpointermovedevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPointerMovedEvent_window")
(foreign-function xpointermovedevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XPointerMovedEvent_root")
(foreign-function set-xpointermovedevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPointerMovedEvent_root")
(foreign-function xpointermovedevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XPointerMovedEvent_subwindow")
(foreign-function set-xpointermovedevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPointerMovedEvent_subwindow")
(foreign-function xpointermovedevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XPointerMovedEvent_time")
(foreign-function set-xpointermovedevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPointerMovedEvent_time")
(foreign-function xpointermovedevent-x ((POINTER STRUCT)) INT "get_XPointerMovedEvent_x")
(foreign-function set-xpointermovedevent-x! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_x")
(foreign-function xpointermovedevent-y ((POINTER STRUCT)) INT "get_XPointerMovedEvent_y")
(foreign-function set-xpointermovedevent-y! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_y")
(foreign-function xpointermovedevent-x_root ((POINTER STRUCT)) INT "get_XPointerMovedEvent_x_root")
(foreign-function set-xpointermovedevent-x_root! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_x_root")
(foreign-function xpointermovedevent-y_root ((POINTER STRUCT)) INT "get_XPointerMovedEvent_y_root")
(foreign-function set-xpointermovedevent-y_root! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_y_root")
(foreign-function xpointermovedevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XPointerMovedEvent_state")
(foreign-function set-xpointermovedevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XPointerMovedEvent_state")
(foreign-function xpointermovedevent-is_hint ((POINTER STRUCT)) CHAR "get_XPointerMovedEvent_is_hint")
(foreign-function set-xpointermovedevent-is_hint! ((POINTER STRUCT) CHAR) VOID "set_XPointerMovedEvent_is_hint")
(foreign-function xpointermovedevent-same_screen ((POINTER STRUCT)) INT "get_XPointerMovedEvent_same_screen")
(foreign-function set-xpointermovedevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XPointerMovedEvent_same_screen")
;;; STRUCT:XMotionEvent
(foreign-function make-xmotionevent () (POINTER STRUCT) "alloc_XMotionEvent")
(foreign-function free-xmotionevent ((POINTER STRUCT)) VOID "free_XMotionEvent")
(foreign-function xmotionevent-type ((POINTER STRUCT)) INT "get_XMotionEvent_type")
(foreign-function set-xmotionevent-type! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_type")
(foreign-function xmotionevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XMotionEvent_serial")
(foreign-function set-xmotionevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMotionEvent_serial")
(foreign-function xmotionevent-send_event ((POINTER STRUCT)) INT "get_XMotionEvent_send_event")
(foreign-function set-xmotionevent-send_event! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_send_event")
(foreign-function xmotionevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XMotionEvent_display")
(foreign-function set-xmotionevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XMotionEvent_display")
(foreign-function xmotionevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XMotionEvent_window")
(foreign-function set-xmotionevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMotionEvent_window")
(foreign-function xmotionevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XMotionEvent_root")
(foreign-function set-xmotionevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMotionEvent_root")
(foreign-function xmotionevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XMotionEvent_subwindow")
(foreign-function set-xmotionevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMotionEvent_subwindow")
(foreign-function xmotionevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XMotionEvent_time")
(foreign-function set-xmotionevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMotionEvent_time")
(foreign-function xmotionevent-x ((POINTER STRUCT)) INT "get_XMotionEvent_x")
(foreign-function set-xmotionevent-x! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_x")
(foreign-function xmotionevent-y ((POINTER STRUCT)) INT "get_XMotionEvent_y")
(foreign-function set-xmotionevent-y! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_y")
(foreign-function xmotionevent-x_root ((POINTER STRUCT)) INT "get_XMotionEvent_x_root")
(foreign-function set-xmotionevent-x_root! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_x_root")
(foreign-function xmotionevent-y_root ((POINTER STRUCT)) INT "get_XMotionEvent_y_root")
(foreign-function set-xmotionevent-y_root! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_y_root")
(foreign-function xmotionevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XMotionEvent_state")
(foreign-function set-xmotionevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XMotionEvent_state")
(foreign-function xmotionevent-is_hint ((POINTER STRUCT)) CHAR "get_XMotionEvent_is_hint")
(foreign-function set-xmotionevent-is_hint! ((POINTER STRUCT) CHAR) VOID "set_XMotionEvent_is_hint")
(foreign-function xmotionevent-same_screen ((POINTER STRUCT)) INT "get_XMotionEvent_same_screen")
(foreign-function set-xmotionevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XMotionEvent_same_screen")
;;; STRUCT:XLeaveWindowEvent
(foreign-function make-xleavewindowevent () (POINTER STRUCT) "alloc_XLeaveWindowEvent")
(foreign-function free-xleavewindowevent ((POINTER STRUCT)) VOID "free_XLeaveWindowEvent")
(foreign-function xleavewindowevent-type ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_type")
(foreign-function set-xleavewindowevent-type! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_type")
(foreign-function xleavewindowevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XLeaveWindowEvent_serial")
(foreign-function set-xleavewindowevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XLeaveWindowEvent_serial")
(foreign-function xleavewindowevent-send_event ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_send_event")
(foreign-function set-xleavewindowevent-send_event! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_send_event")
(foreign-function xleavewindowevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XLeaveWindowEvent_display")
(foreign-function set-xleavewindowevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XLeaveWindowEvent_display")
(foreign-function xleavewindowevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XLeaveWindowEvent_window")
(foreign-function set-xleavewindowevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XLeaveWindowEvent_window")
(foreign-function xleavewindowevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XLeaveWindowEvent_root")
(foreign-function set-xleavewindowevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XLeaveWindowEvent_root")
(foreign-function xleavewindowevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XLeaveWindowEvent_subwindow")
(foreign-function set-xleavewindowevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XLeaveWindowEvent_subwindow")
(foreign-function xleavewindowevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XLeaveWindowEvent_time")
(foreign-function set-xleavewindowevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XLeaveWindowEvent_time")
(foreign-function xleavewindowevent-x ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_x")
(foreign-function set-xleavewindowevent-x! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_x")
(foreign-function xleavewindowevent-y ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_y")
(foreign-function set-xleavewindowevent-y! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_y")
(foreign-function xleavewindowevent-x_root ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_x_root")
(foreign-function set-xleavewindowevent-x_root! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_x_root")
(foreign-function xleavewindowevent-y_root ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_y_root")
(foreign-function set-xleavewindowevent-y_root! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_y_root")
(foreign-function xleavewindowevent-mode ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_mode")
(foreign-function set-xleavewindowevent-mode! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_mode")
(foreign-function xleavewindowevent-detail ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_detail")
(foreign-function set-xleavewindowevent-detail! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_detail")
(foreign-function xleavewindowevent-same_screen ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_same_screen")
(foreign-function set-xleavewindowevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_same_screen")
(foreign-function xleavewindowevent-focus ((POINTER STRUCT)) INT "get_XLeaveWindowEvent_focus")
(foreign-function set-xleavewindowevent-focus! ((POINTER STRUCT) INT) VOID "set_XLeaveWindowEvent_focus")
(foreign-function xleavewindowevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XLeaveWindowEvent_state")
(foreign-function set-xleavewindowevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XLeaveWindowEvent_state")
;;; STRUCT:XEnterWindowEvent
(foreign-function make-xenterwindowevent () (POINTER STRUCT) "alloc_XEnterWindowEvent")
(foreign-function free-xenterwindowevent ((POINTER STRUCT)) VOID "free_XEnterWindowEvent")
(foreign-function xenterwindowevent-type ((POINTER STRUCT)) INT "get_XEnterWindowEvent_type")
(foreign-function set-xenterwindowevent-type! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_type")
(foreign-function xenterwindowevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEnterWindowEvent_serial")
(foreign-function set-xenterwindowevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEnterWindowEvent_serial")
(foreign-function xenterwindowevent-send_event ((POINTER STRUCT)) INT "get_XEnterWindowEvent_send_event")
(foreign-function set-xenterwindowevent-send_event! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_send_event")
(foreign-function xenterwindowevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEnterWindowEvent_display")
(foreign-function set-xenterwindowevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEnterWindowEvent_display")
(foreign-function xenterwindowevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEnterWindowEvent_window")
(foreign-function set-xenterwindowevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEnterWindowEvent_window")
(foreign-function xenterwindowevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XEnterWindowEvent_root")
(foreign-function set-xenterwindowevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEnterWindowEvent_root")
(foreign-function xenterwindowevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XEnterWindowEvent_subwindow")
(foreign-function set-xenterwindowevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEnterWindowEvent_subwindow")
(foreign-function xenterwindowevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEnterWindowEvent_time")
(foreign-function set-xenterwindowevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEnterWindowEvent_time")
(foreign-function xenterwindowevent-x ((POINTER STRUCT)) INT "get_XEnterWindowEvent_x")
(foreign-function set-xenterwindowevent-x! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_x")
(foreign-function xenterwindowevent-y ((POINTER STRUCT)) INT "get_XEnterWindowEvent_y")
(foreign-function set-xenterwindowevent-y! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_y")
(foreign-function xenterwindowevent-x_root ((POINTER STRUCT)) INT "get_XEnterWindowEvent_x_root")
(foreign-function set-xenterwindowevent-x_root! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_x_root")
(foreign-function xenterwindowevent-y_root ((POINTER STRUCT)) INT "get_XEnterWindowEvent_y_root")
(foreign-function set-xenterwindowevent-y_root! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_y_root")
(foreign-function xenterwindowevent-mode ((POINTER STRUCT)) INT "get_XEnterWindowEvent_mode")
(foreign-function set-xenterwindowevent-mode! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_mode")
(foreign-function xenterwindowevent-detail ((POINTER STRUCT)) INT "get_XEnterWindowEvent_detail")
(foreign-function set-xenterwindowevent-detail! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_detail")
(foreign-function xenterwindowevent-same_screen ((POINTER STRUCT)) INT "get_XEnterWindowEvent_same_screen")
(foreign-function set-xenterwindowevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_same_screen")
(foreign-function xenterwindowevent-focus ((POINTER STRUCT)) INT "get_XEnterWindowEvent_focus")
(foreign-function set-xenterwindowevent-focus! ((POINTER STRUCT) INT) VOID "set_XEnterWindowEvent_focus")
(foreign-function xenterwindowevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XEnterWindowEvent_state")
(foreign-function set-xenterwindowevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEnterWindowEvent_state")
;;; STRUCT:XCrossingEvent
(foreign-function make-xcrossingevent () (POINTER STRUCT) "alloc_XCrossingEvent")
(foreign-function free-xcrossingevent ((POINTER STRUCT)) VOID "free_XCrossingEvent")
(foreign-function xcrossingevent-type ((POINTER STRUCT)) INT "get_XCrossingEvent_type")
(foreign-function set-xcrossingevent-type! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_type")
(foreign-function xcrossingevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XCrossingEvent_serial")
(foreign-function set-xcrossingevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCrossingEvent_serial")
(foreign-function xcrossingevent-send_event ((POINTER STRUCT)) INT "get_XCrossingEvent_send_event")
(foreign-function set-xcrossingevent-send_event! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_send_event")
(foreign-function xcrossingevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XCrossingEvent_display")
(foreign-function set-xcrossingevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XCrossingEvent_display")
(foreign-function xcrossingevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XCrossingEvent_window")
(foreign-function set-xcrossingevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCrossingEvent_window")
(foreign-function xcrossingevent-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XCrossingEvent_root")
(foreign-function set-xcrossingevent-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCrossingEvent_root")
(foreign-function xcrossingevent-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XCrossingEvent_subwindow")
(foreign-function set-xcrossingevent-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCrossingEvent_subwindow")
(foreign-function xcrossingevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XCrossingEvent_time")
(foreign-function set-xcrossingevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCrossingEvent_time")
(foreign-function xcrossingevent-x ((POINTER STRUCT)) INT "get_XCrossingEvent_x")
(foreign-function set-xcrossingevent-x! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_x")
(foreign-function xcrossingevent-y ((POINTER STRUCT)) INT "get_XCrossingEvent_y")
(foreign-function set-xcrossingevent-y! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_y")
(foreign-function xcrossingevent-x_root ((POINTER STRUCT)) INT "get_XCrossingEvent_x_root")
(foreign-function set-xcrossingevent-x_root! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_x_root")
(foreign-function xcrossingevent-y_root ((POINTER STRUCT)) INT "get_XCrossingEvent_y_root")
(foreign-function set-xcrossingevent-y_root! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_y_root")
(foreign-function xcrossingevent-mode ((POINTER STRUCT)) INT "get_XCrossingEvent_mode")
(foreign-function set-xcrossingevent-mode! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_mode")
(foreign-function xcrossingevent-detail ((POINTER STRUCT)) INT "get_XCrossingEvent_detail")
(foreign-function set-xcrossingevent-detail! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_detail")
(foreign-function xcrossingevent-same_screen ((POINTER STRUCT)) INT "get_XCrossingEvent_same_screen")
(foreign-function set-xcrossingevent-same_screen! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_same_screen")
(foreign-function xcrossingevent-focus ((POINTER STRUCT)) INT "get_XCrossingEvent_focus")
(foreign-function set-xcrossingevent-focus! ((POINTER STRUCT) INT) VOID "set_XCrossingEvent_focus")
(foreign-function xcrossingevent-state ((POINTER STRUCT)) UNSIGNED-INT "get_XCrossingEvent_state")
(foreign-function set-xcrossingevent-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XCrossingEvent_state")
;;; STRUCT:XFocusOutEvent
(foreign-function make-xfocusoutevent () (POINTER STRUCT) "alloc_XFocusOutEvent")
(foreign-function free-xfocusoutevent ((POINTER STRUCT)) VOID "free_XFocusOutEvent")
(foreign-function xfocusoutevent-type ((POINTER STRUCT)) INT "get_XFocusOutEvent_type")
(foreign-function set-xfocusoutevent-type! ((POINTER STRUCT) INT) VOID "set_XFocusOutEvent_type")
(foreign-function xfocusoutevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusOutEvent_serial")
(foreign-function set-xfocusoutevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusOutEvent_serial")
(foreign-function xfocusoutevent-send_event ((POINTER STRUCT)) INT "get_XFocusOutEvent_send_event")
(foreign-function set-xfocusoutevent-send_event! ((POINTER STRUCT) INT) VOID "set_XFocusOutEvent_send_event")
(foreign-function xfocusoutevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XFocusOutEvent_display")
(foreign-function set-xfocusoutevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFocusOutEvent_display")
(foreign-function xfocusoutevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusOutEvent_window")
(foreign-function set-xfocusoutevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusOutEvent_window")
(foreign-function xfocusoutevent-mode ((POINTER STRUCT)) INT "get_XFocusOutEvent_mode")
(foreign-function set-xfocusoutevent-mode! ((POINTER STRUCT) INT) VOID "set_XFocusOutEvent_mode")
(foreign-function xfocusoutevent-detail ((POINTER STRUCT)) INT "get_XFocusOutEvent_detail")
(foreign-function set-xfocusoutevent-detail! ((POINTER STRUCT) INT) VOID "set_XFocusOutEvent_detail")
;;; STRUCT:XFocusInEvent
(foreign-function make-xfocusinevent () (POINTER STRUCT) "alloc_XFocusInEvent")
(foreign-function free-xfocusinevent ((POINTER STRUCT)) VOID "free_XFocusInEvent")
(foreign-function xfocusinevent-type ((POINTER STRUCT)) INT "get_XFocusInEvent_type")
(foreign-function set-xfocusinevent-type! ((POINTER STRUCT) INT) VOID "set_XFocusInEvent_type")
(foreign-function xfocusinevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusInEvent_serial")
(foreign-function set-xfocusinevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusInEvent_serial")
(foreign-function xfocusinevent-send_event ((POINTER STRUCT)) INT "get_XFocusInEvent_send_event")
(foreign-function set-xfocusinevent-send_event! ((POINTER STRUCT) INT) VOID "set_XFocusInEvent_send_event")
(foreign-function xfocusinevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XFocusInEvent_display")
(foreign-function set-xfocusinevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFocusInEvent_display")
(foreign-function xfocusinevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusInEvent_window")
(foreign-function set-xfocusinevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusInEvent_window")
(foreign-function xfocusinevent-mode ((POINTER STRUCT)) INT "get_XFocusInEvent_mode")
(foreign-function set-xfocusinevent-mode! ((POINTER STRUCT) INT) VOID "set_XFocusInEvent_mode")
(foreign-function xfocusinevent-detail ((POINTER STRUCT)) INT "get_XFocusInEvent_detail")
(foreign-function set-xfocusinevent-detail! ((POINTER STRUCT) INT) VOID "set_XFocusInEvent_detail")
;;; STRUCT:XFocusChangeEvent
(foreign-function make-xfocuschangeevent () (POINTER STRUCT) "alloc_XFocusChangeEvent")
(foreign-function free-xfocuschangeevent ((POINTER STRUCT)) VOID "free_XFocusChangeEvent")
(foreign-function xfocuschangeevent-type ((POINTER STRUCT)) INT "get_XFocusChangeEvent_type")
(foreign-function set-xfocuschangeevent-type! ((POINTER STRUCT) INT) VOID "set_XFocusChangeEvent_type")
(foreign-function xfocuschangeevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusChangeEvent_serial")
(foreign-function set-xfocuschangeevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusChangeEvent_serial")
(foreign-function xfocuschangeevent-send_event ((POINTER STRUCT)) INT "get_XFocusChangeEvent_send_event")
(foreign-function set-xfocuschangeevent-send_event! ((POINTER STRUCT) INT) VOID "set_XFocusChangeEvent_send_event")
(foreign-function xfocuschangeevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XFocusChangeEvent_display")
(foreign-function set-xfocuschangeevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFocusChangeEvent_display")
(foreign-function xfocuschangeevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XFocusChangeEvent_window")
(foreign-function set-xfocuschangeevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFocusChangeEvent_window")
(foreign-function xfocuschangeevent-mode ((POINTER STRUCT)) INT "get_XFocusChangeEvent_mode")
(foreign-function set-xfocuschangeevent-mode! ((POINTER STRUCT) INT) VOID "set_XFocusChangeEvent_mode")
(foreign-function xfocuschangeevent-detail ((POINTER STRUCT)) INT "get_XFocusChangeEvent_detail")
(foreign-function set-xfocuschangeevent-detail! ((POINTER STRUCT) INT) VOID "set_XFocusChangeEvent_detail")
;;; STRUCT:XKeymapEvent
(foreign-function make-xkeymapevent () (POINTER STRUCT) "alloc_XKeymapEvent")
(foreign-function free-xkeymapevent ((POINTER STRUCT)) VOID "free_XKeymapEvent")
(foreign-function xkeymapevent-type ((POINTER STRUCT)) INT "get_XKeymapEvent_type")
(foreign-function set-xkeymapevent-type! ((POINTER STRUCT) INT) VOID "set_XKeymapEvent_type")
(foreign-function xkeymapevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeymapEvent_serial")
(foreign-function set-xkeymapevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeymapEvent_serial")
(foreign-function xkeymapevent-send_event ((POINTER STRUCT)) INT "get_XKeymapEvent_send_event")
(foreign-function set-xkeymapevent-send_event! ((POINTER STRUCT) INT) VOID "set_XKeymapEvent_send_event")
(foreign-function xkeymapevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XKeymapEvent_display")
(foreign-function set-xkeymapevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XKeymapEvent_display")
(foreign-function xkeymapevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XKeymapEvent_window")
(foreign-function set-xkeymapevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XKeymapEvent_window")
(foreign-function xkeymapevent-key_vector ((POINTER STRUCT)) POINTER "get_XKeymapEvent_key_vector")
;;; STRUCT:XExposeEvent
(foreign-function make-xexposeevent () (POINTER STRUCT) "alloc_XExposeEvent")
(foreign-function free-xexposeevent ((POINTER STRUCT)) VOID "free_XExposeEvent")
(foreign-function xexposeevent-type ((POINTER STRUCT)) INT "get_XExposeEvent_type")
(foreign-function set-xexposeevent-type! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_type")
(foreign-function xexposeevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XExposeEvent_serial")
(foreign-function set-xexposeevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XExposeEvent_serial")
(foreign-function xexposeevent-send_event ((POINTER STRUCT)) INT "get_XExposeEvent_send_event")
(foreign-function set-xexposeevent-send_event! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_send_event")
(foreign-function xexposeevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XExposeEvent_display")
(foreign-function set-xexposeevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XExposeEvent_display")
(foreign-function xexposeevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XExposeEvent_window")
(foreign-function set-xexposeevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XExposeEvent_window")
(foreign-function xexposeevent-x ((POINTER STRUCT)) INT "get_XExposeEvent_x")
(foreign-function set-xexposeevent-x! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_x")
(foreign-function xexposeevent-y ((POINTER STRUCT)) INT "get_XExposeEvent_y")
(foreign-function set-xexposeevent-y! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_y")
(foreign-function xexposeevent-width ((POINTER STRUCT)) INT "get_XExposeEvent_width")
(foreign-function set-xexposeevent-width! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_width")
(foreign-function xexposeevent-height ((POINTER STRUCT)) INT "get_XExposeEvent_height")
(foreign-function set-xexposeevent-height! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_height")
(foreign-function xexposeevent-count ((POINTER STRUCT)) INT "get_XExposeEvent_count")
(foreign-function set-xexposeevent-count! ((POINTER STRUCT) INT) VOID "set_XExposeEvent_count")
;;; STRUCT:XGraphicsExposeEvent
(foreign-function make-xgraphicsexposeevent () (POINTER STRUCT) "alloc_XGraphicsExposeEvent")
(foreign-function free-xgraphicsexposeevent ((POINTER STRUCT)) VOID "free_XGraphicsExposeEvent")
(foreign-function xgraphicsexposeevent-type ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_type")
(foreign-function set-xgraphicsexposeevent-type! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_type")
(foreign-function xgraphicsexposeevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XGraphicsExposeEvent_serial")
(foreign-function set-xgraphicsexposeevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGraphicsExposeEvent_serial")
(foreign-function xgraphicsexposeevent-send_event ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_send_event")
(foreign-function set-xgraphicsexposeevent-send_event! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_send_event")
(foreign-function xgraphicsexposeevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XGraphicsExposeEvent_display")
(foreign-function set-xgraphicsexposeevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XGraphicsExposeEvent_display")
(foreign-function xgraphicsexposeevent-drawable ((POINTER STRUCT)) UNSIGNED-LONG "get_XGraphicsExposeEvent_drawable")
(foreign-function set-xgraphicsexposeevent-drawable! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGraphicsExposeEvent_drawable")
(foreign-function xgraphicsexposeevent-x ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_x")
(foreign-function set-xgraphicsexposeevent-x! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_x")
(foreign-function xgraphicsexposeevent-y ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_y")
(foreign-function set-xgraphicsexposeevent-y! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_y")
(foreign-function xgraphicsexposeevent-width ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_width")
(foreign-function set-xgraphicsexposeevent-width! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_width")
(foreign-function xgraphicsexposeevent-height ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_height")
(foreign-function set-xgraphicsexposeevent-height! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_height")
(foreign-function xgraphicsexposeevent-count ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_count")
(foreign-function set-xgraphicsexposeevent-count! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_count")
(foreign-function xgraphicsexposeevent-major_code ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_major_code")
(foreign-function set-xgraphicsexposeevent-major_code! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_major_code")
(foreign-function xgraphicsexposeevent-minor_code ((POINTER STRUCT)) INT "get_XGraphicsExposeEvent_minor_code")
(foreign-function set-xgraphicsexposeevent-minor_code! ((POINTER STRUCT) INT) VOID "set_XGraphicsExposeEvent_minor_code")
;;; STRUCT:XNoExposeEvent
(foreign-function make-xnoexposeevent () (POINTER STRUCT) "alloc_XNoExposeEvent")
(foreign-function free-xnoexposeevent ((POINTER STRUCT)) VOID "free_XNoExposeEvent")
(foreign-function xnoexposeevent-type ((POINTER STRUCT)) INT "get_XNoExposeEvent_type")
(foreign-function set-xnoexposeevent-type! ((POINTER STRUCT) INT) VOID "set_XNoExposeEvent_type")
(foreign-function xnoexposeevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XNoExposeEvent_serial")
(foreign-function set-xnoexposeevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XNoExposeEvent_serial")
(foreign-function xnoexposeevent-send_event ((POINTER STRUCT)) INT "get_XNoExposeEvent_send_event")
(foreign-function set-xnoexposeevent-send_event! ((POINTER STRUCT) INT) VOID "set_XNoExposeEvent_send_event")
(foreign-function xnoexposeevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XNoExposeEvent_display")
(foreign-function set-xnoexposeevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XNoExposeEvent_display")
(foreign-function xnoexposeevent-drawable ((POINTER STRUCT)) UNSIGNED-LONG "get_XNoExposeEvent_drawable")
(foreign-function set-xnoexposeevent-drawable! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XNoExposeEvent_drawable")
(foreign-function xnoexposeevent-major_code ((POINTER STRUCT)) INT "get_XNoExposeEvent_major_code")
(foreign-function set-xnoexposeevent-major_code! ((POINTER STRUCT) INT) VOID "set_XNoExposeEvent_major_code")
(foreign-function xnoexposeevent-minor_code ((POINTER STRUCT)) INT "get_XNoExposeEvent_minor_code")
(foreign-function set-xnoexposeevent-minor_code! ((POINTER STRUCT) INT) VOID "set_XNoExposeEvent_minor_code")
;;; STRUCT:XVisibilityEvent
(foreign-function make-xvisibilityevent () (POINTER STRUCT) "alloc_XVisibilityEvent")
(foreign-function free-xvisibilityevent ((POINTER STRUCT)) VOID "free_XVisibilityEvent")
(foreign-function xvisibilityevent-type ((POINTER STRUCT)) INT "get_XVisibilityEvent_type")
(foreign-function set-xvisibilityevent-type! ((POINTER STRUCT) INT) VOID "set_XVisibilityEvent_type")
(foreign-function xvisibilityevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisibilityEvent_serial")
(foreign-function set-xvisibilityevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisibilityEvent_serial")
(foreign-function xvisibilityevent-send_event ((POINTER STRUCT)) INT "get_XVisibilityEvent_send_event")
(foreign-function set-xvisibilityevent-send_event! ((POINTER STRUCT) INT) VOID "set_XVisibilityEvent_send_event")
(foreign-function xvisibilityevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XVisibilityEvent_display")
(foreign-function set-xvisibilityevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XVisibilityEvent_display")
(foreign-function xvisibilityevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisibilityEvent_window")
(foreign-function set-xvisibilityevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisibilityEvent_window")
(foreign-function xvisibilityevent-state ((POINTER STRUCT)) INT "get_XVisibilityEvent_state")
(foreign-function set-xvisibilityevent-state! ((POINTER STRUCT) INT) VOID "set_XVisibilityEvent_state")
;;; STRUCT:XCreateWindowEvent
(foreign-function make-xcreatewindowevent () (POINTER STRUCT) "alloc_XCreateWindowEvent")
(foreign-function free-xcreatewindowevent ((POINTER STRUCT)) VOID "free_XCreateWindowEvent")
(foreign-function xcreatewindowevent-type ((POINTER STRUCT)) INT "get_XCreateWindowEvent_type")
(foreign-function set-xcreatewindowevent-type! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_type")
(foreign-function xcreatewindowevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XCreateWindowEvent_serial")
(foreign-function set-xcreatewindowevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCreateWindowEvent_serial")
(foreign-function xcreatewindowevent-send_event ((POINTER STRUCT)) INT "get_XCreateWindowEvent_send_event")
(foreign-function set-xcreatewindowevent-send_event! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_send_event")
(foreign-function xcreatewindowevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XCreateWindowEvent_display")
(foreign-function set-xcreatewindowevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XCreateWindowEvent_display")
(foreign-function xcreatewindowevent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XCreateWindowEvent_parent")
(foreign-function set-xcreatewindowevent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCreateWindowEvent_parent")
(foreign-function xcreatewindowevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XCreateWindowEvent_window")
(foreign-function set-xcreatewindowevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCreateWindowEvent_window")
(foreign-function xcreatewindowevent-x ((POINTER STRUCT)) INT "get_XCreateWindowEvent_x")
(foreign-function set-xcreatewindowevent-x! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_x")
(foreign-function xcreatewindowevent-y ((POINTER STRUCT)) INT "get_XCreateWindowEvent_y")
(foreign-function set-xcreatewindowevent-y! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_y")
(foreign-function xcreatewindowevent-width ((POINTER STRUCT)) INT "get_XCreateWindowEvent_width")
(foreign-function set-xcreatewindowevent-width! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_width")
(foreign-function xcreatewindowevent-height ((POINTER STRUCT)) INT "get_XCreateWindowEvent_height")
(foreign-function set-xcreatewindowevent-height! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_height")
(foreign-function xcreatewindowevent-border_width ((POINTER STRUCT)) INT "get_XCreateWindowEvent_border_width")
(foreign-function set-xcreatewindowevent-border_width! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_border_width")
(foreign-function xcreatewindowevent-override_redirect ((POINTER STRUCT)) INT "get_XCreateWindowEvent_override_redirect")
(foreign-function set-xcreatewindowevent-override_redirect! ((POINTER STRUCT) INT) VOID "set_XCreateWindowEvent_override_redirect")
;;; STRUCT:XDestroyWindowEvent
(foreign-function make-xdestroywindowevent () (POINTER STRUCT) "alloc_XDestroyWindowEvent")
(foreign-function free-xdestroywindowevent ((POINTER STRUCT)) VOID "free_XDestroyWindowEvent")
(foreign-function xdestroywindowevent-type ((POINTER STRUCT)) INT "get_XDestroyWindowEvent_type")
(foreign-function set-xdestroywindowevent-type! ((POINTER STRUCT) INT) VOID "set_XDestroyWindowEvent_type")
(foreign-function xdestroywindowevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XDestroyWindowEvent_serial")
(foreign-function set-xdestroywindowevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XDestroyWindowEvent_serial")
(foreign-function xdestroywindowevent-send_event ((POINTER STRUCT)) INT "get_XDestroyWindowEvent_send_event")
(foreign-function set-xdestroywindowevent-send_event! ((POINTER STRUCT) INT) VOID "set_XDestroyWindowEvent_send_event")
(foreign-function xdestroywindowevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XDestroyWindowEvent_display")
(foreign-function set-xdestroywindowevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XDestroyWindowEvent_display")
(foreign-function xdestroywindowevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XDestroyWindowEvent_event")
(foreign-function set-xdestroywindowevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XDestroyWindowEvent_event")
(foreign-function xdestroywindowevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XDestroyWindowEvent_window")
(foreign-function set-xdestroywindowevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XDestroyWindowEvent_window")
;;; STRUCT:XUnmapEvent
(foreign-function make-xunmapevent () (POINTER STRUCT) "alloc_XUnmapEvent")
(foreign-function free-xunmapevent ((POINTER STRUCT)) VOID "free_XUnmapEvent")
(foreign-function xunmapevent-type ((POINTER STRUCT)) INT "get_XUnmapEvent_type")
(foreign-function set-xunmapevent-type! ((POINTER STRUCT) INT) VOID "set_XUnmapEvent_type")
(foreign-function xunmapevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XUnmapEvent_serial")
(foreign-function set-xunmapevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XUnmapEvent_serial")
(foreign-function xunmapevent-send_event ((POINTER STRUCT)) INT "get_XUnmapEvent_send_event")
(foreign-function set-xunmapevent-send_event! ((POINTER STRUCT) INT) VOID "set_XUnmapEvent_send_event")
(foreign-function xunmapevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XUnmapEvent_display")
(foreign-function set-xunmapevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XUnmapEvent_display")
(foreign-function xunmapevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XUnmapEvent_event")
(foreign-function set-xunmapevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XUnmapEvent_event")
(foreign-function xunmapevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XUnmapEvent_window")
(foreign-function set-xunmapevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XUnmapEvent_window")
(foreign-function xunmapevent-from_configure ((POINTER STRUCT)) INT "get_XUnmapEvent_from_configure")
(foreign-function set-xunmapevent-from_configure! ((POINTER STRUCT) INT) VOID "set_XUnmapEvent_from_configure")
;;; STRUCT:XMapEvent
(foreign-function make-xmapevent () (POINTER STRUCT) "alloc_XMapEvent")
(foreign-function free-xmapevent ((POINTER STRUCT)) VOID "free_XMapEvent")
(foreign-function xmapevent-type ((POINTER STRUCT)) INT "get_XMapEvent_type")
(foreign-function set-xmapevent-type! ((POINTER STRUCT) INT) VOID "set_XMapEvent_type")
(foreign-function xmapevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapEvent_serial")
(foreign-function set-xmapevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapEvent_serial")
(foreign-function xmapevent-send_event ((POINTER STRUCT)) INT "get_XMapEvent_send_event")
(foreign-function set-xmapevent-send_event! ((POINTER STRUCT) INT) VOID "set_XMapEvent_send_event")
(foreign-function xmapevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XMapEvent_display")
(foreign-function set-xmapevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XMapEvent_display")
(foreign-function xmapevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapEvent_event")
(foreign-function set-xmapevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapEvent_event")
(foreign-function xmapevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapEvent_window")
(foreign-function set-xmapevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapEvent_window")
(foreign-function xmapevent-override_redirect ((POINTER STRUCT)) INT "get_XMapEvent_override_redirect")
(foreign-function set-xmapevent-override_redirect! ((POINTER STRUCT) INT) VOID "set_XMapEvent_override_redirect")
;;; STRUCT:XMapRequestEvent
(foreign-function make-xmaprequestevent () (POINTER STRUCT) "alloc_XMapRequestEvent")
(foreign-function free-xmaprequestevent ((POINTER STRUCT)) VOID "free_XMapRequestEvent")
(foreign-function xmaprequestevent-type ((POINTER STRUCT)) INT "get_XMapRequestEvent_type")
(foreign-function set-xmaprequestevent-type! ((POINTER STRUCT) INT) VOID "set_XMapRequestEvent_type")
(foreign-function xmaprequestevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapRequestEvent_serial")
(foreign-function set-xmaprequestevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapRequestEvent_serial")
(foreign-function xmaprequestevent-send_event ((POINTER STRUCT)) INT "get_XMapRequestEvent_send_event")
(foreign-function set-xmaprequestevent-send_event! ((POINTER STRUCT) INT) VOID "set_XMapRequestEvent_send_event")
(foreign-function xmaprequestevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XMapRequestEvent_display")
(foreign-function set-xmaprequestevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XMapRequestEvent_display")
(foreign-function xmaprequestevent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapRequestEvent_parent")
(foreign-function set-xmaprequestevent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapRequestEvent_parent")
(foreign-function xmaprequestevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XMapRequestEvent_window")
(foreign-function set-xmaprequestevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMapRequestEvent_window")
;;; STRUCT:XReparentEvent
(foreign-function make-xreparentevent () (POINTER STRUCT) "alloc_XReparentEvent")
(foreign-function free-xreparentevent ((POINTER STRUCT)) VOID "free_XReparentEvent")
(foreign-function xreparentevent-type ((POINTER STRUCT)) INT "get_XReparentEvent_type")
(foreign-function set-xreparentevent-type! ((POINTER STRUCT) INT) VOID "set_XReparentEvent_type")
(foreign-function xreparentevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XReparentEvent_serial")
(foreign-function set-xreparentevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XReparentEvent_serial")
(foreign-function xreparentevent-send_event ((POINTER STRUCT)) INT "get_XReparentEvent_send_event")
(foreign-function set-xreparentevent-send_event! ((POINTER STRUCT) INT) VOID "set_XReparentEvent_send_event")
(foreign-function xreparentevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XReparentEvent_display")
(foreign-function set-xreparentevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XReparentEvent_display")
(foreign-function xreparentevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XReparentEvent_event")
(foreign-function set-xreparentevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XReparentEvent_event")
(foreign-function xreparentevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XReparentEvent_window")
(foreign-function set-xreparentevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XReparentEvent_window")
(foreign-function xreparentevent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XReparentEvent_parent")
(foreign-function set-xreparentevent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XReparentEvent_parent")
(foreign-function xreparentevent-x ((POINTER STRUCT)) INT "get_XReparentEvent_x")
(foreign-function set-xreparentevent-x! ((POINTER STRUCT) INT) VOID "set_XReparentEvent_x")
(foreign-function xreparentevent-y ((POINTER STRUCT)) INT "get_XReparentEvent_y")
(foreign-function set-xreparentevent-y! ((POINTER STRUCT) INT) VOID "set_XReparentEvent_y")
(foreign-function xreparentevent-override_redirect ((POINTER STRUCT)) INT "get_XReparentEvent_override_redirect")
(foreign-function set-xreparentevent-override_redirect! ((POINTER STRUCT) INT) VOID "set_XReparentEvent_override_redirect")
;;; STRUCT:XConfigureEvent
(foreign-function make-xconfigureevent () (POINTER STRUCT) "alloc_XConfigureEvent")
(foreign-function free-xconfigureevent ((POINTER STRUCT)) VOID "free_XConfigureEvent")
(foreign-function xconfigureevent-type ((POINTER STRUCT)) INT "get_XConfigureEvent_type")
(foreign-function set-xconfigureevent-type! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_type")
(foreign-function xconfigureevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureEvent_serial")
(foreign-function set-xconfigureevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureEvent_serial")
(foreign-function xconfigureevent-send_event ((POINTER STRUCT)) INT "get_XConfigureEvent_send_event")
(foreign-function set-xconfigureevent-send_event! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_send_event")
(foreign-function xconfigureevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XConfigureEvent_display")
(foreign-function set-xconfigureevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XConfigureEvent_display")
(foreign-function xconfigureevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureEvent_event")
(foreign-function set-xconfigureevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureEvent_event")
(foreign-function xconfigureevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureEvent_window")
(foreign-function set-xconfigureevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureEvent_window")
(foreign-function xconfigureevent-x ((POINTER STRUCT)) INT "get_XConfigureEvent_x")
(foreign-function set-xconfigureevent-x! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_x")
(foreign-function xconfigureevent-y ((POINTER STRUCT)) INT "get_XConfigureEvent_y")
(foreign-function set-xconfigureevent-y! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_y")
(foreign-function xconfigureevent-width ((POINTER STRUCT)) INT "get_XConfigureEvent_width")
(foreign-function set-xconfigureevent-width! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_width")
(foreign-function xconfigureevent-height ((POINTER STRUCT)) INT "get_XConfigureEvent_height")
(foreign-function set-xconfigureevent-height! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_height")
(foreign-function xconfigureevent-border_width ((POINTER STRUCT)) INT "get_XConfigureEvent_border_width")
(foreign-function set-xconfigureevent-border_width! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_border_width")
(foreign-function xconfigureevent-above ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureEvent_above")
(foreign-function set-xconfigureevent-above! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureEvent_above")
(foreign-function xconfigureevent-override_redirect ((POINTER STRUCT)) INT "get_XConfigureEvent_override_redirect")
(foreign-function set-xconfigureevent-override_redirect! ((POINTER STRUCT) INT) VOID "set_XConfigureEvent_override_redirect")
;;; STRUCT:XGravityEvent
(foreign-function make-xgravityevent () (POINTER STRUCT) "alloc_XGravityEvent")
(foreign-function free-xgravityevent ((POINTER STRUCT)) VOID "free_XGravityEvent")
(foreign-function xgravityevent-type ((POINTER STRUCT)) INT "get_XGravityEvent_type")
(foreign-function set-xgravityevent-type! ((POINTER STRUCT) INT) VOID "set_XGravityEvent_type")
(foreign-function xgravityevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XGravityEvent_serial")
(foreign-function set-xgravityevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGravityEvent_serial")
(foreign-function xgravityevent-send_event ((POINTER STRUCT)) INT "get_XGravityEvent_send_event")
(foreign-function set-xgravityevent-send_event! ((POINTER STRUCT) INT) VOID "set_XGravityEvent_send_event")
(foreign-function xgravityevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XGravityEvent_display")
(foreign-function set-xgravityevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XGravityEvent_display")
(foreign-function xgravityevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XGravityEvent_event")
(foreign-function set-xgravityevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGravityEvent_event")
(foreign-function xgravityevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XGravityEvent_window")
(foreign-function set-xgravityevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XGravityEvent_window")
(foreign-function xgravityevent-x ((POINTER STRUCT)) INT "get_XGravityEvent_x")
(foreign-function set-xgravityevent-x! ((POINTER STRUCT) INT) VOID "set_XGravityEvent_x")
(foreign-function xgravityevent-y ((POINTER STRUCT)) INT "get_XGravityEvent_y")
(foreign-function set-xgravityevent-y! ((POINTER STRUCT) INT) VOID "set_XGravityEvent_y")
;;; STRUCT:XResizeRequestEvent
(foreign-function make-xresizerequestevent () (POINTER STRUCT) "alloc_XResizeRequestEvent")
(foreign-function free-xresizerequestevent ((POINTER STRUCT)) VOID "free_XResizeRequestEvent")
(foreign-function xresizerequestevent-type ((POINTER STRUCT)) INT "get_XResizeRequestEvent_type")
(foreign-function set-xresizerequestevent-type! ((POINTER STRUCT) INT) VOID "set_XResizeRequestEvent_type")
(foreign-function xresizerequestevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XResizeRequestEvent_serial")
(foreign-function set-xresizerequestevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XResizeRequestEvent_serial")
(foreign-function xresizerequestevent-send_event ((POINTER STRUCT)) INT "get_XResizeRequestEvent_send_event")
(foreign-function set-xresizerequestevent-send_event! ((POINTER STRUCT) INT) VOID "set_XResizeRequestEvent_send_event")
(foreign-function xresizerequestevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XResizeRequestEvent_display")
(foreign-function set-xresizerequestevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XResizeRequestEvent_display")
(foreign-function xresizerequestevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XResizeRequestEvent_window")
(foreign-function set-xresizerequestevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XResizeRequestEvent_window")
(foreign-function xresizerequestevent-width ((POINTER STRUCT)) INT "get_XResizeRequestEvent_width")
(foreign-function set-xresizerequestevent-width! ((POINTER STRUCT) INT) VOID "set_XResizeRequestEvent_width")
(foreign-function xresizerequestevent-height ((POINTER STRUCT)) INT "get_XResizeRequestEvent_height")
(foreign-function set-xresizerequestevent-height! ((POINTER STRUCT) INT) VOID "set_XResizeRequestEvent_height")
;;; STRUCT:XConfigureRequestEvent
(foreign-function make-xconfigurerequestevent () (POINTER STRUCT) "alloc_XConfigureRequestEvent")
(foreign-function free-xconfigurerequestevent ((POINTER STRUCT)) VOID "free_XConfigureRequestEvent")
(foreign-function xconfigurerequestevent-type ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_type")
(foreign-function set-xconfigurerequestevent-type! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_type")
(foreign-function xconfigurerequestevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureRequestEvent_serial")
(foreign-function set-xconfigurerequestevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureRequestEvent_serial")
(foreign-function xconfigurerequestevent-send_event ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_send_event")
(foreign-function set-xconfigurerequestevent-send_event! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_send_event")
(foreign-function xconfigurerequestevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XConfigureRequestEvent_display")
(foreign-function set-xconfigurerequestevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XConfigureRequestEvent_display")
(foreign-function xconfigurerequestevent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureRequestEvent_parent")
(foreign-function set-xconfigurerequestevent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureRequestEvent_parent")
(foreign-function xconfigurerequestevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureRequestEvent_window")
(foreign-function set-xconfigurerequestevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureRequestEvent_window")
(foreign-function xconfigurerequestevent-x ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_x")
(foreign-function set-xconfigurerequestevent-x! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_x")
(foreign-function xconfigurerequestevent-y ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_y")
(foreign-function set-xconfigurerequestevent-y! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_y")
(foreign-function xconfigurerequestevent-width ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_width")
(foreign-function set-xconfigurerequestevent-width! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_width")
(foreign-function xconfigurerequestevent-height ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_height")
(foreign-function set-xconfigurerequestevent-height! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_height")
(foreign-function xconfigurerequestevent-border_width ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_border_width")
(foreign-function set-xconfigurerequestevent-border_width! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_border_width")
(foreign-function xconfigurerequestevent-above ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureRequestEvent_above")
(foreign-function set-xconfigurerequestevent-above! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureRequestEvent_above")
(foreign-function xconfigurerequestevent-detail ((POINTER STRUCT)) INT "get_XConfigureRequestEvent_detail")
(foreign-function set-xconfigurerequestevent-detail! ((POINTER STRUCT) INT) VOID "set_XConfigureRequestEvent_detail")
(foreign-function xconfigurerequestevent-value_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XConfigureRequestEvent_value_mask")
(foreign-function set-xconfigurerequestevent-value_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XConfigureRequestEvent_value_mask")
;;; STRUCT:XCirculateEvent
(foreign-function make-xcirculateevent () (POINTER STRUCT) "alloc_XCirculateEvent")
(foreign-function free-xcirculateevent ((POINTER STRUCT)) VOID "free_XCirculateEvent")
(foreign-function xcirculateevent-type ((POINTER STRUCT)) INT "get_XCirculateEvent_type")
(foreign-function set-xcirculateevent-type! ((POINTER STRUCT) INT) VOID "set_XCirculateEvent_type")
(foreign-function xcirculateevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateEvent_serial")
(foreign-function set-xcirculateevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateEvent_serial")
(foreign-function xcirculateevent-send_event ((POINTER STRUCT)) INT "get_XCirculateEvent_send_event")
(foreign-function set-xcirculateevent-send_event! ((POINTER STRUCT) INT) VOID "set_XCirculateEvent_send_event")
(foreign-function xcirculateevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XCirculateEvent_display")
(foreign-function set-xcirculateevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XCirculateEvent_display")
(foreign-function xcirculateevent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateEvent_event")
(foreign-function set-xcirculateevent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateEvent_event")
(foreign-function xcirculateevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateEvent_window")
(foreign-function set-xcirculateevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateEvent_window")
(foreign-function xcirculateevent-place ((POINTER STRUCT)) INT "get_XCirculateEvent_place")
(foreign-function set-xcirculateevent-place! ((POINTER STRUCT) INT) VOID "set_XCirculateEvent_place")
;;; STRUCT:XCirculateRequestEvent
(foreign-function make-xcirculaterequestevent () (POINTER STRUCT) "alloc_XCirculateRequestEvent")
(foreign-function free-xcirculaterequestevent ((POINTER STRUCT)) VOID "free_XCirculateRequestEvent")
(foreign-function xcirculaterequestevent-type ((POINTER STRUCT)) INT "get_XCirculateRequestEvent_type")
(foreign-function set-xcirculaterequestevent-type! ((POINTER STRUCT) INT) VOID "set_XCirculateRequestEvent_type")
(foreign-function xcirculaterequestevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateRequestEvent_serial")
(foreign-function set-xcirculaterequestevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateRequestEvent_serial")
(foreign-function xcirculaterequestevent-send_event ((POINTER STRUCT)) INT "get_XCirculateRequestEvent_send_event")
(foreign-function set-xcirculaterequestevent-send_event! ((POINTER STRUCT) INT) VOID "set_XCirculateRequestEvent_send_event")
(foreign-function xcirculaterequestevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XCirculateRequestEvent_display")
(foreign-function set-xcirculaterequestevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XCirculateRequestEvent_display")
(foreign-function xcirculaterequestevent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateRequestEvent_parent")
(foreign-function set-xcirculaterequestevent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateRequestEvent_parent")
(foreign-function xcirculaterequestevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XCirculateRequestEvent_window")
(foreign-function set-xcirculaterequestevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XCirculateRequestEvent_window")
(foreign-function xcirculaterequestevent-place ((POINTER STRUCT)) INT "get_XCirculateRequestEvent_place")
(foreign-function set-xcirculaterequestevent-place! ((POINTER STRUCT) INT) VOID "set_XCirculateRequestEvent_place")
;;; STRUCT:XPropertyEvent
(foreign-function make-xpropertyevent () (POINTER STRUCT) "alloc_XPropertyEvent")
(foreign-function free-xpropertyevent ((POINTER STRUCT)) VOID "free_XPropertyEvent")
(foreign-function xpropertyevent-type ((POINTER STRUCT)) INT "get_XPropertyEvent_type")
(foreign-function set-xpropertyevent-type! ((POINTER STRUCT) INT) VOID "set_XPropertyEvent_type")
(foreign-function xpropertyevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XPropertyEvent_serial")
(foreign-function set-xpropertyevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPropertyEvent_serial")
(foreign-function xpropertyevent-send_event ((POINTER STRUCT)) INT "get_XPropertyEvent_send_event")
(foreign-function set-xpropertyevent-send_event! ((POINTER STRUCT) INT) VOID "set_XPropertyEvent_send_event")
(foreign-function xpropertyevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XPropertyEvent_display")
(foreign-function set-xpropertyevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XPropertyEvent_display")
(foreign-function xpropertyevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XPropertyEvent_window")
(foreign-function set-xpropertyevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPropertyEvent_window")
(foreign-function xpropertyevent-atom ((POINTER STRUCT)) UNSIGNED-LONG "get_XPropertyEvent_atom")
(foreign-function set-xpropertyevent-atom! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPropertyEvent_atom")
(foreign-function xpropertyevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XPropertyEvent_time")
(foreign-function set-xpropertyevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XPropertyEvent_time")
(foreign-function xpropertyevent-state ((POINTER STRUCT)) INT "get_XPropertyEvent_state")
(foreign-function set-xpropertyevent-state! ((POINTER STRUCT) INT) VOID "set_XPropertyEvent_state")
;;; STRUCT:XSelectionClearEvent
(foreign-function make-xselectionclearevent () (POINTER STRUCT) "alloc_XSelectionClearEvent")
(foreign-function free-xselectionclearevent ((POINTER STRUCT)) VOID "free_XSelectionClearEvent")
(foreign-function xselectionclearevent-type ((POINTER STRUCT)) INT "get_XSelectionClearEvent_type")
(foreign-function set-xselectionclearevent-type! ((POINTER STRUCT) INT) VOID "set_XSelectionClearEvent_type")
(foreign-function xselectionclearevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionClearEvent_serial")
(foreign-function set-xselectionclearevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionClearEvent_serial")
(foreign-function xselectionclearevent-send_event ((POINTER STRUCT)) INT "get_XSelectionClearEvent_send_event")
(foreign-function set-xselectionclearevent-send_event! ((POINTER STRUCT) INT) VOID "set_XSelectionClearEvent_send_event")
(foreign-function xselectionclearevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XSelectionClearEvent_display")
(foreign-function set-xselectionclearevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XSelectionClearEvent_display")
(foreign-function xselectionclearevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionClearEvent_window")
(foreign-function set-xselectionclearevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionClearEvent_window")
(foreign-function xselectionclearevent-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionClearEvent_selection")
(foreign-function set-xselectionclearevent-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionClearEvent_selection")
(foreign-function xselectionclearevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionClearEvent_time")
(foreign-function set-xselectionclearevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionClearEvent_time")
;;; STRUCT:XSelectionRequestEvent
(foreign-function make-xselectionrequestevent () (POINTER STRUCT) "alloc_XSelectionRequestEvent")
(foreign-function free-xselectionrequestevent ((POINTER STRUCT)) VOID "free_XSelectionRequestEvent")
(foreign-function xselectionrequestevent-type ((POINTER STRUCT)) INT "get_XSelectionRequestEvent_type")
(foreign-function set-xselectionrequestevent-type! ((POINTER STRUCT) INT) VOID "set_XSelectionRequestEvent_type")
(foreign-function xselectionrequestevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_serial")
(foreign-function set-xselectionrequestevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_serial")
(foreign-function xselectionrequestevent-send_event ((POINTER STRUCT)) INT "get_XSelectionRequestEvent_send_event")
(foreign-function set-xselectionrequestevent-send_event! ((POINTER STRUCT) INT) VOID "set_XSelectionRequestEvent_send_event")
(foreign-function xselectionrequestevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XSelectionRequestEvent_display")
(foreign-function set-xselectionrequestevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XSelectionRequestEvent_display")
(foreign-function xselectionrequestevent-owner ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_owner")
(foreign-function set-xselectionrequestevent-owner! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_owner")
(foreign-function xselectionrequestevent-requestor ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_requestor")
(foreign-function set-xselectionrequestevent-requestor! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_requestor")
(foreign-function xselectionrequestevent-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_selection")
(foreign-function set-xselectionrequestevent-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_selection")
(foreign-function xselectionrequestevent-target ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_target")
(foreign-function set-xselectionrequestevent-target! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_target")
(foreign-function xselectionrequestevent-property ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_property")
(foreign-function set-xselectionrequestevent-property! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_property")
(foreign-function xselectionrequestevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionRequestEvent_time")
(foreign-function set-xselectionrequestevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionRequestEvent_time")
;;; STRUCT:XSelectionEvent
(foreign-function make-xselectionevent () (POINTER STRUCT) "alloc_XSelectionEvent")
(foreign-function free-xselectionevent ((POINTER STRUCT)) VOID "free_XSelectionEvent")
(foreign-function xselectionevent-type ((POINTER STRUCT)) INT "get_XSelectionEvent_type")
(foreign-function set-xselectionevent-type! ((POINTER STRUCT) INT) VOID "set_XSelectionEvent_type")
(foreign-function xselectionevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_serial")
(foreign-function set-xselectionevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_serial")
(foreign-function xselectionevent-send_event ((POINTER STRUCT)) INT "get_XSelectionEvent_send_event")
(foreign-function set-xselectionevent-send_event! ((POINTER STRUCT) INT) VOID "set_XSelectionEvent_send_event")
(foreign-function xselectionevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XSelectionEvent_display")
(foreign-function set-xselectionevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XSelectionEvent_display")
(foreign-function xselectionevent-requestor ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_requestor")
(foreign-function set-xselectionevent-requestor! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_requestor")
(foreign-function xselectionevent-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_selection")
(foreign-function set-xselectionevent-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_selection")
(foreign-function xselectionevent-target ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_target")
(foreign-function set-xselectionevent-target! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_target")
(foreign-function xselectionevent-property ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_property")
(foreign-function set-xselectionevent-property! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_property")
(foreign-function xselectionevent-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XSelectionEvent_time")
(foreign-function set-xselectionevent-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XSelectionEvent_time")
;;; STRUCT:XColormapEvent
(foreign-function make-xcolormapevent () (POINTER STRUCT) "alloc_XColormapEvent")
(foreign-function free-xcolormapevent ((POINTER STRUCT)) VOID "free_XColormapEvent")
(foreign-function xcolormapevent-type ((POINTER STRUCT)) INT "get_XColormapEvent_type")
(foreign-function set-xcolormapevent-type! ((POINTER STRUCT) INT) VOID "set_XColormapEvent_type")
(foreign-function xcolormapevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XColormapEvent_serial")
(foreign-function set-xcolormapevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XColormapEvent_serial")
(foreign-function xcolormapevent-send_event ((POINTER STRUCT)) INT "get_XColormapEvent_send_event")
(foreign-function set-xcolormapevent-send_event! ((POINTER STRUCT) INT) VOID "set_XColormapEvent_send_event")
(foreign-function xcolormapevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XColormapEvent_display")
(foreign-function set-xcolormapevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XColormapEvent_display")
(foreign-function xcolormapevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XColormapEvent_window")
(foreign-function set-xcolormapevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XColormapEvent_window")
(foreign-function xcolormapevent-colormap ((POINTER STRUCT)) UNSIGNED-LONG "get_XColormapEvent_colormap")
(foreign-function set-xcolormapevent-colormap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XColormapEvent_colormap")
(foreign-function xcolormapevent-new ((POINTER STRUCT)) INT "get_XColormapEvent_new")
(foreign-function set-xcolormapevent-new! ((POINTER STRUCT) INT) VOID "set_XColormapEvent_new")
(foreign-function xcolormapevent-state ((POINTER STRUCT)) INT "get_XColormapEvent_state")
(foreign-function set-xcolormapevent-state! ((POINTER STRUCT) INT) VOID "set_XColormapEvent_state")
;;; STRUCT:XClientMessageEvent
(foreign-function make-xclientmessageevent () (POINTER STRUCT) "alloc_XClientMessageEvent")
(foreign-function free-xclientmessageevent ((POINTER STRUCT)) VOID "free_XClientMessageEvent")
(foreign-function xclientmessageevent-type ((POINTER STRUCT)) INT "get_XClientMessageEvent_type")
(foreign-function set-xclientmessageevent-type! ((POINTER STRUCT) INT) VOID "set_XClientMessageEvent_type")
(foreign-function xclientmessageevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XClientMessageEvent_serial")
(foreign-function set-xclientmessageevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XClientMessageEvent_serial")
(foreign-function xclientmessageevent-send_event ((POINTER STRUCT)) INT "get_XClientMessageEvent_send_event")
(foreign-function set-xclientmessageevent-send_event! ((POINTER STRUCT) INT) VOID "set_XClientMessageEvent_send_event")
(foreign-function xclientmessageevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XClientMessageEvent_display")
(foreign-function set-xclientmessageevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XClientMessageEvent_display")
(foreign-function xclientmessageevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XClientMessageEvent_window")
(foreign-function set-xclientmessageevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XClientMessageEvent_window")
(foreign-function xclientmessageevent-message_type ((POINTER STRUCT)) UNSIGNED-LONG "get_XClientMessageEvent_message_type")
(foreign-function set-xclientmessageevent-message_type! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XClientMessageEvent_message_type")
(foreign-function xclientmessageevent-format ((POINTER STRUCT)) INT "get_XClientMessageEvent_format")
(foreign-function set-xclientmessageevent-format! ((POINTER STRUCT) INT) VOID "set_XClientMessageEvent_format")
(foreign-function xclientmessageevent-data-b ((POINTER UNION)) POINTER "get_XClientMessageEvent_data_b")
(foreign-function xclientmessageevent-data-s ((POINTER UNION)) POINTER "get_XClientMessageEvent_data_s")
(foreign-function xclientmessageevent-data-l ((POINTER UNION)) POINTER "get_XClientMessageEvent_data_l")
;;; STRUCT:XMappingEvent
(foreign-function make-xmappingevent () (POINTER STRUCT) "alloc_XMappingEvent")
(foreign-function free-xmappingevent ((POINTER STRUCT)) VOID "free_XMappingEvent")
(foreign-function xmappingevent-type ((POINTER STRUCT)) INT "get_XMappingEvent_type")
(foreign-function set-xmappingevent-type! ((POINTER STRUCT) INT) VOID "set_XMappingEvent_type")
(foreign-function xmappingevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XMappingEvent_serial")
(foreign-function set-xmappingevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMappingEvent_serial")
(foreign-function xmappingevent-send_event ((POINTER STRUCT)) INT "get_XMappingEvent_send_event")
(foreign-function set-xmappingevent-send_event! ((POINTER STRUCT) INT) VOID "set_XMappingEvent_send_event")
(foreign-function xmappingevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XMappingEvent_display")
(foreign-function set-xmappingevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XMappingEvent_display")
(foreign-function xmappingevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XMappingEvent_window")
(foreign-function set-xmappingevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XMappingEvent_window")
(foreign-function xmappingevent-request ((POINTER STRUCT)) INT "get_XMappingEvent_request")
(foreign-function set-xmappingevent-request! ((POINTER STRUCT) INT) VOID "set_XMappingEvent_request")
(foreign-function xmappingevent-first_keycode ((POINTER STRUCT)) INT "get_XMappingEvent_first_keycode")
(foreign-function set-xmappingevent-first_keycode! ((POINTER STRUCT) INT) VOID "set_XMappingEvent_first_keycode")
(foreign-function xmappingevent-count ((POINTER STRUCT)) INT "get_XMappingEvent_count")
(foreign-function set-xmappingevent-count! ((POINTER STRUCT) INT) VOID "set_XMappingEvent_count")
;;; STRUCT:XErrorEvent
(foreign-function make-xerrorevent () (POINTER STRUCT) "alloc_XErrorEvent")
(foreign-function free-xerrorevent ((POINTER STRUCT)) VOID "free_XErrorEvent")
(foreign-function xerrorevent-type ((POINTER STRUCT)) INT "get_XErrorEvent_type")
(foreign-function set-xerrorevent-type! ((POINTER STRUCT) INT) VOID "set_XErrorEvent_type")
(foreign-function xerrorevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XErrorEvent_display")
(foreign-function set-xerrorevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XErrorEvent_display")
(foreign-function xerrorevent-resourceid ((POINTER STRUCT)) UNSIGNED-LONG "get_XErrorEvent_resourceid")
(foreign-function set-xerrorevent-resourceid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XErrorEvent_resourceid")
(foreign-function xerrorevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XErrorEvent_serial")
(foreign-function set-xerrorevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XErrorEvent_serial")
(foreign-function xerrorevent-error_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XErrorEvent_error_code")
(foreign-function set-xerrorevent-error_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XErrorEvent_error_code")
(foreign-function xerrorevent-request_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XErrorEvent_request_code")
(foreign-function set-xerrorevent-request_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XErrorEvent_request_code")
(foreign-function xerrorevent-minor_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XErrorEvent_minor_code")
(foreign-function set-xerrorevent-minor_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XErrorEvent_minor_code")
;;; STRUCT:XAnyEvent
(foreign-function make-xanyevent () (POINTER STRUCT) "alloc_XAnyEvent")
(foreign-function free-xanyevent ((POINTER STRUCT)) VOID "free_XAnyEvent")
(foreign-function xanyevent-type ((POINTER STRUCT)) INT "get_XAnyEvent_type")
(foreign-function set-xanyevent-type! ((POINTER STRUCT) INT) VOID "set_XAnyEvent_type")
(foreign-function xanyevent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XAnyEvent_serial")
(foreign-function set-xanyevent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XAnyEvent_serial")
(foreign-function xanyevent-send_event ((POINTER STRUCT)) INT "get_XAnyEvent_send_event")
(foreign-function set-xanyevent-send_event! ((POINTER STRUCT) INT) VOID "set_XAnyEvent_send_event")
(foreign-function xanyevent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XAnyEvent_display")
(foreign-function set-xanyevent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XAnyEvent_display")
(foreign-function xanyevent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XAnyEvent_window")
(foreign-function set-xanyevent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XAnyEvent_window")
;;; STRUCT:XCharStruct
(foreign-function make-xcharstruct () (POINTER STRUCT) "alloc_XCharStruct")
(foreign-function free-xcharstruct ((POINTER STRUCT)) VOID "free_XCharStruct")
(foreign-function xcharstruct-lbearing ((POINTER STRUCT)) SHORT "get_XCharStruct_lbearing")
(foreign-function set-xcharstruct-lbearing! ((POINTER STRUCT) SHORT) VOID "set_XCharStruct_lbearing")
(foreign-function xcharstruct-rbearing ((POINTER STRUCT)) SHORT "get_XCharStruct_rbearing")
(foreign-function set-xcharstruct-rbearing! ((POINTER STRUCT) SHORT) VOID "set_XCharStruct_rbearing")
(foreign-function xcharstruct-width ((POINTER STRUCT)) SHORT "get_XCharStruct_width")
(foreign-function set-xcharstruct-width! ((POINTER STRUCT) SHORT) VOID "set_XCharStruct_width")
(foreign-function xcharstruct-ascent ((POINTER STRUCT)) SHORT "get_XCharStruct_ascent")
(foreign-function set-xcharstruct-ascent! ((POINTER STRUCT) SHORT) VOID "set_XCharStruct_ascent")
(foreign-function xcharstruct-descent ((POINTER STRUCT)) SHORT "get_XCharStruct_descent")
(foreign-function set-xcharstruct-descent! ((POINTER STRUCT) SHORT) VOID "set_XCharStruct_descent")
(foreign-function xcharstruct-attributes ((POINTER STRUCT)) UNSIGNED-SHORT "get_XCharStruct_attributes")
(foreign-function set-xcharstruct-attributes! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XCharStruct_attributes")
;;; STRUCT:XFontProp
(foreign-function make-xfontprop () (POINTER STRUCT) "alloc_XFontProp")
(foreign-function free-xfontprop ((POINTER STRUCT)) VOID "free_XFontProp")
(foreign-function xfontprop-name ((POINTER STRUCT)) UNSIGNED-LONG "get_XFontProp_name")
(foreign-function set-xfontprop-name! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFontProp_name")
(foreign-function xfontprop-card32 ((POINTER STRUCT)) UNSIGNED-LONG "get_XFontProp_card32")
(foreign-function set-xfontprop-card32! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFontProp_card32")
;;; STRUCT:XFontStruct
(foreign-function make-xfontstruct () (POINTER STRUCT) "alloc_XFontStruct")
(foreign-function free-xfontstruct ((POINTER STRUCT)) VOID "free_XFontStruct")
(foreign-function xfontstruct-ext_data ((POINTER STRUCT)) (POINTER STRUCT) "get_XFontStruct_ext_data")
(foreign-function set-xfontstruct-ext_data! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFontStruct_ext_data")
(foreign-function xfontstruct-fid ((POINTER STRUCT)) UNSIGNED-LONG "get_XFontStruct_fid")
(foreign-function set-xfontstruct-fid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XFontStruct_fid")
(foreign-function xfontstruct-direction ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_direction")
(foreign-function set-xfontstruct-direction! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_direction")
(foreign-function xfontstruct-min_char_or_byte2 ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_min_char_or_byte2")
(foreign-function set-xfontstruct-min_char_or_byte2! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_min_char_or_byte2")
(foreign-function xfontstruct-max_char_or_byte2 ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_max_char_or_byte2")
(foreign-function set-xfontstruct-max_char_or_byte2! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_max_char_or_byte2")
(foreign-function xfontstruct-min_byte1 ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_min_byte1")
(foreign-function set-xfontstruct-min_byte1! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_min_byte1")
(foreign-function xfontstruct-max_byte1 ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_max_byte1")
(foreign-function set-xfontstruct-max_byte1! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_max_byte1")
(foreign-function xfontstruct-all_chars_exist ((POINTER STRUCT)) INT "get_XFontStruct_all_chars_exist")
(foreign-function set-xfontstruct-all_chars_exist! ((POINTER STRUCT) INT) VOID "set_XFontStruct_all_chars_exist")
(foreign-function xfontstruct-default_char ((POINTER STRUCT)) UNSIGNED-INT "get_XFontStruct_default_char")
(foreign-function set-xfontstruct-default_char! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XFontStruct_default_char")
(foreign-function xfontstruct-n_properties ((POINTER STRUCT)) INT "get_XFontStruct_n_properties")
(foreign-function set-xfontstruct-n_properties! ((POINTER STRUCT) INT) VOID "set_XFontStruct_n_properties")
(foreign-function xfontstruct-properties ((POINTER STRUCT)) (POINTER STRUCT) "get_XFontStruct_properties")
(foreign-function set-xfontstruct-properties! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFontStruct_properties")
(foreign-function xfontstruct-min_bounds-lbearing ((POINTER STRUCT)) SHORT "get_XFontStruct_min_bounds_lbearing")
(foreign-function set-xfontstruct-min_bounds-lbearing! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_min_bounds_lbearing")
(foreign-function xfontstruct-min_bounds-rbearing ((POINTER STRUCT)) SHORT "get_XFontStruct_min_bounds_rbearing")
(foreign-function set-xfontstruct-min_bounds-rbearing! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_min_bounds_rbearing")
(foreign-function xfontstruct-min_bounds-width ((POINTER STRUCT)) SHORT "get_XFontStruct_min_bounds_width")
(foreign-function set-xfontstruct-min_bounds-width! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_min_bounds_width")
(foreign-function xfontstruct-min_bounds-ascent ((POINTER STRUCT)) SHORT "get_XFontStruct_min_bounds_ascent")
(foreign-function set-xfontstruct-min_bounds-ascent! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_min_bounds_ascent")
(foreign-function xfontstruct-min_bounds-descent ((POINTER STRUCT)) SHORT "get_XFontStruct_min_bounds_descent")
(foreign-function set-xfontstruct-min_bounds-descent! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_min_bounds_descent")
(foreign-function xfontstruct-min_bounds-attributes ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontStruct_min_bounds_attributes")
(foreign-function set-xfontstruct-min_bounds-attributes! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontStruct_min_bounds_attributes")
(foreign-function xfontstruct-max_bounds-lbearing ((POINTER STRUCT)) SHORT "get_XFontStruct_max_bounds_lbearing")
(foreign-function set-xfontstruct-max_bounds-lbearing! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_max_bounds_lbearing")
(foreign-function xfontstruct-max_bounds-rbearing ((POINTER STRUCT)) SHORT "get_XFontStruct_max_bounds_rbearing")
(foreign-function set-xfontstruct-max_bounds-rbearing! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_max_bounds_rbearing")
(foreign-function xfontstruct-max_bounds-width ((POINTER STRUCT)) SHORT "get_XFontStruct_max_bounds_width")
(foreign-function set-xfontstruct-max_bounds-width! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_max_bounds_width")
(foreign-function xfontstruct-max_bounds-ascent ((POINTER STRUCT)) SHORT "get_XFontStruct_max_bounds_ascent")
(foreign-function set-xfontstruct-max_bounds-ascent! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_max_bounds_ascent")
(foreign-function xfontstruct-max_bounds-descent ((POINTER STRUCT)) SHORT "get_XFontStruct_max_bounds_descent")
(foreign-function set-xfontstruct-max_bounds-descent! ((POINTER STRUCT) SHORT) VOID "set_XFontStruct_max_bounds_descent")
(foreign-function xfontstruct-max_bounds-attributes ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontStruct_max_bounds_attributes")
(foreign-function set-xfontstruct-max_bounds-attributes! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontStruct_max_bounds_attributes")
(foreign-function xfontstruct-per_char ((POINTER STRUCT)) (POINTER STRUCT) "get_XFontStruct_per_char")
(foreign-function set-xfontstruct-per_char! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XFontStruct_per_char")
(foreign-function xfontstruct-ascent ((POINTER STRUCT)) INT "get_XFontStruct_ascent")
(foreign-function set-xfontstruct-ascent! ((POINTER STRUCT) INT) VOID "set_XFontStruct_ascent")
(foreign-function xfontstruct-descent ((POINTER STRUCT)) INT "get_XFontStruct_descent")
(foreign-function set-xfontstruct-descent! ((POINTER STRUCT) INT) VOID "set_XFontStruct_descent")
;;; STRUCT:XTextItem
(foreign-function make-xtextitem () (POINTER STRUCT) "alloc_XTextItem")
(foreign-function free-xtextitem ((POINTER STRUCT)) VOID "free_XTextItem")
(foreign-function xtextitem-chars ((POINTER STRUCT)) (POINTER CHAR) "get_XTextItem_chars")
(foreign-function set-xtextitem-chars! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XTextItem_chars")
(foreign-function xtextitem-nchars ((POINTER STRUCT)) INT "get_XTextItem_nchars")
(foreign-function set-xtextitem-nchars! ((POINTER STRUCT) INT) VOID "set_XTextItem_nchars")
(foreign-function xtextitem-delta ((POINTER STRUCT)) INT "get_XTextItem_delta")
(foreign-function set-xtextitem-delta! ((POINTER STRUCT) INT) VOID "set_XTextItem_delta")
(foreign-function xtextitem-font ((POINTER STRUCT)) UNSIGNED-LONG "get_XTextItem_font")
(foreign-function set-xtextitem-font! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XTextItem_font")
;;; STRUCT:XChar2b
(foreign-function make-xchar2b () (POINTER STRUCT) "alloc_XChar2b")
(foreign-function free-xchar2b ((POINTER STRUCT)) VOID "free_XChar2b")
(foreign-function xchar2b-byte1 ((POINTER STRUCT)) UNSIGNED-CHAR "get_XChar2b_byte1")
(foreign-function set-xchar2b-byte1! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XChar2b_byte1")
(foreign-function xchar2b-byte2 ((POINTER STRUCT)) UNSIGNED-CHAR "get_XChar2b_byte2")
(foreign-function set-xchar2b-byte2! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XChar2b_byte2")
;;; STRUCT:XTextItem16
(foreign-function make-xtextitem16 () (POINTER STRUCT) "alloc_XTextItem16")
(foreign-function free-xtextitem16 ((POINTER STRUCT)) VOID "free_XTextItem16")
(foreign-function xtextitem16-chars ((POINTER STRUCT)) (POINTER STRUCT) "get_XTextItem16_chars")
(foreign-function set-xtextitem16-chars! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XTextItem16_chars")
(foreign-function xtextitem16-nchars ((POINTER STRUCT)) INT "get_XTextItem16_nchars")
(foreign-function set-xtextitem16-nchars! ((POINTER STRUCT) INT) VOID "set_XTextItem16_nchars")
(foreign-function xtextitem16-delta ((POINTER STRUCT)) INT "get_XTextItem16_delta")
(foreign-function set-xtextitem16-delta! ((POINTER STRUCT) INT) VOID "set_XTextItem16_delta")
(foreign-function xtextitem16-font ((POINTER STRUCT)) UNSIGNED-LONG "get_XTextItem16_font")
(foreign-function set-xtextitem16-font! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XTextItem16_font")
;;; STRUCT:XFontSetExtents
(foreign-function make-xfontsetextents () (POINTER STRUCT) "alloc_XFontSetExtents")
(foreign-function free-xfontsetextents ((POINTER STRUCT)) VOID "free_XFontSetExtents")
(foreign-function xfontsetextents-max_ink_extent-x ((POINTER STRUCT)) SHORT "get_XFontSetExtents_max_ink_extent_x")
(foreign-function set-xfontsetextents-max_ink_extent-x! ((POINTER STRUCT) SHORT) VOID "set_XFontSetExtents_max_ink_extent_x")
(foreign-function xfontsetextents-max_ink_extent-y ((POINTER STRUCT)) SHORT "get_XFontSetExtents_max_ink_extent_y")
(foreign-function set-xfontsetextents-max_ink_extent-y! ((POINTER STRUCT) SHORT) VOID "set_XFontSetExtents_max_ink_extent_y")
(foreign-function xfontsetextents-max_ink_extent-width ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontSetExtents_max_ink_extent_width")
(foreign-function set-xfontsetextents-max_ink_extent-width! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontSetExtents_max_ink_extent_width")
(foreign-function xfontsetextents-max_ink_extent-height ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontSetExtents_max_ink_extent_height")
(foreign-function set-xfontsetextents-max_ink_extent-height! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontSetExtents_max_ink_extent_height")
(foreign-function xfontsetextents-max_logical_extent-x ((POINTER STRUCT)) SHORT "get_XFontSetExtents_max_logical_extent_x")
(foreign-function set-xfontsetextents-max_logical_extent-x! ((POINTER STRUCT) SHORT) VOID "set_XFontSetExtents_max_logical_extent_x")
(foreign-function xfontsetextents-max_logical_extent-y ((POINTER STRUCT)) SHORT "get_XFontSetExtents_max_logical_extent_y")
(foreign-function set-xfontsetextents-max_logical_extent-y! ((POINTER STRUCT) SHORT) VOID "set_XFontSetExtents_max_logical_extent_y")
(foreign-function xfontsetextents-max_logical_extent-width ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontSetExtents_max_logical_extent_width")
(foreign-function set-xfontsetextents-max_logical_extent-width! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontSetExtents_max_logical_extent_width")
(foreign-function xfontsetextents-max_logical_extent-height ((POINTER STRUCT)) UNSIGNED-SHORT "get_XFontSetExtents_max_logical_extent_height")
(foreign-function set-xfontsetextents-max_logical_extent-height! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XFontSetExtents_max_logical_extent_height")
;;; STRUCT:XmbTextItem
(foreign-function make-xmbtextitem () (POINTER STRUCT) "alloc_XmbTextItem")
(foreign-function free-xmbtextitem ((POINTER STRUCT)) VOID "free_XmbTextItem")
(foreign-function xmbtextitem-chars ((POINTER STRUCT)) (POINTER CHAR) "get_XmbTextItem_chars")
(foreign-function set-xmbtextitem-chars! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XmbTextItem_chars")
(foreign-function xmbtextitem-nchars ((POINTER STRUCT)) INT "get_XmbTextItem_nchars")
(foreign-function set-xmbtextitem-nchars! ((POINTER STRUCT) INT) VOID "set_XmbTextItem_nchars")
(foreign-function xmbtextitem-delta ((POINTER STRUCT)) INT "get_XmbTextItem_delta")
(foreign-function set-xmbtextitem-delta! ((POINTER STRUCT) INT) VOID "set_XmbTextItem_delta")
(foreign-function xmbtextitem-font_set ((POINTER STRUCT)) (POINTER STRUCT) "get_XmbTextItem_font_set")
(foreign-function set-xmbtextitem-font_set! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XmbTextItem_font_set")
;;; STRUCT:XwcTextItem
(foreign-function make-xwctextitem () (POINTER STRUCT) "alloc_XwcTextItem")
(foreign-function free-xwctextitem ((POINTER STRUCT)) VOID "free_XwcTextItem")
(foreign-function xwctextitem-chars ((POINTER STRUCT)) (POINTER UNSIGNED-CHAR) "get_XwcTextItem_chars")
(foreign-function set-xwctextitem-chars! ((POINTER STRUCT) (POINTER UNSIGNED-CHAR)) VOID "set_XwcTextItem_chars")
(foreign-function xwctextitem-nchars ((POINTER STRUCT)) INT "get_XwcTextItem_nchars")
(foreign-function set-xwctextitem-nchars! ((POINTER STRUCT) INT) VOID "set_XwcTextItem_nchars")
(foreign-function xwctextitem-delta ((POINTER STRUCT)) INT "get_XwcTextItem_delta")
(foreign-function set-xwctextitem-delta! ((POINTER STRUCT) INT) VOID "set_XwcTextItem_delta")
(foreign-function xwctextitem-font_set ((POINTER STRUCT)) (POINTER STRUCT) "get_XwcTextItem_font_set")
(foreign-function set-xwctextitem-font_set! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XwcTextItem_font_set")
;;; STRUCT:XIMStyles
(foreign-function make-ximstyles () (POINTER STRUCT) "alloc_XIMStyles")
(foreign-function free-ximstyles ((POINTER STRUCT)) VOID "free_XIMStyles")
(foreign-function ximstyles-count_styles ((POINTER STRUCT)) UNSIGNED-SHORT "get_XIMStyles_count_styles")
(foreign-function set-ximstyles-count_styles! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XIMStyles_count_styles")
(foreign-function ximstyles-supported_styles ((POINTER STRUCT)) (POINTER UNSIGNED-LONG) "get_XIMStyles_supported_styles")
(foreign-function set-ximstyles-supported_styles! ((POINTER STRUCT) (POINTER UNSIGNED-LONG)) VOID "set_XIMStyles_supported_styles")
;;; STRUCT:XIMCallback
(foreign-function make-ximcallback () (POINTER STRUCT) "alloc_XIMCallback")
(foreign-function free-ximcallback ((POINTER STRUCT)) VOID "free_XIMCallback")
(foreign-function ximcallback-client_data ((POINTER STRUCT)) (POINTER CHAR) "get_XIMCallback_client_data")
(foreign-function set-ximcallback-client_data! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XIMCallback_client_data")
(foreign-function ximcallback-callback ((POINTER STRUCT)) (POINTER FUNCTION) "get_XIMCallback_callback")
(foreign-function set-ximcallback-callback! ((POINTER STRUCT) (POINTER FUNCTION)) VOID "set_XIMCallback_callback")
;;; STRUCT:XIMText
(foreign-function make-ximtext () (POINTER STRUCT) "alloc_XIMText")
(foreign-function free-ximtext ((POINTER STRUCT)) VOID "free_XIMText")
(foreign-function ximtext-length ((POINTER STRUCT)) UNSIGNED-SHORT "get_XIMText_length")
(foreign-function set-ximtext-length! ((POINTER STRUCT) UNSIGNED-SHORT) VOID "set_XIMText_length")
(foreign-function ximtext-feedback ((POINTER STRUCT)) (POINTER UNSIGNED-LONG) "get_XIMText_feedback")
(foreign-function set-ximtext-feedback! ((POINTER STRUCT) (POINTER UNSIGNED-LONG)) VOID "set_XIMText_feedback")
(foreign-function ximtext-encoding_is_wchar ((POINTER STRUCT)) INT "get_XIMText_encoding_is_wchar")
(foreign-function set-ximtext-encoding_is_wchar! ((POINTER STRUCT) INT) VOID "set_XIMText_encoding_is_wchar")
(foreign-function ximtext-string-multi_byte ((POINTER UNION)) (POINTER CHAR) "get_XIMText_string_multi_byte")
(foreign-function set-ximtext-string-multi_byte! ((POINTER UNION) (POINTER CHAR)) VOID "set_XIMText_string_multi_byte")
(foreign-function ximtext-string-wide_char ((POINTER UNION)) (POINTER UNSIGNED-CHAR) "get_XIMText_string_wide_char")
(foreign-function set-ximtext-string-wide_char! ((POINTER UNION) (POINTER UNSIGNED-CHAR)) VOID "set_XIMText_string_wide_char")
;;; STRUCT:XIMPreeditDrawCallbackStruct
(foreign-function make-ximpreeditdrawcallbackstruct () (POINTER STRUCT) "alloc_XIMPreeditDrawCallbackStruct")
(foreign-function free-ximpreeditdrawcallbackstruct ((POINTER STRUCT)) VOID "free_XIMPreeditDrawCallbackStruct")
(foreign-function ximpreeditdrawcallbackstruct-caret ((POINTER STRUCT)) INT "get_XIMPreeditDrawCallbackStruct_caret")
(foreign-function set-ximpreeditdrawcallbackstruct-caret! ((POINTER STRUCT) INT) VOID "set_XIMPreeditDrawCallbackStruct_caret")
(foreign-function ximpreeditdrawcallbackstruct-chg_first ((POINTER STRUCT)) INT "get_XIMPreeditDrawCallbackStruct_chg_first")
(foreign-function set-ximpreeditdrawcallbackstruct-chg_first! ((POINTER STRUCT) INT) VOID "set_XIMPreeditDrawCallbackStruct_chg_first")
(foreign-function ximpreeditdrawcallbackstruct-chg_length ((POINTER STRUCT)) INT "get_XIMPreeditDrawCallbackStruct_chg_length")
(foreign-function set-ximpreeditdrawcallbackstruct-chg_length! ((POINTER STRUCT) INT) VOID "set_XIMPreeditDrawCallbackStruct_chg_length")
(foreign-function ximpreeditdrawcallbackstruct-text ((POINTER STRUCT)) (POINTER STRUCT) "get_XIMPreeditDrawCallbackStruct_text")
(foreign-function set-ximpreeditdrawcallbackstruct-text! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XIMPreeditDrawCallbackStruct_text")
;;; STRUCT:XIMPreeditCaretCallbackStruct
(foreign-function make-ximpreeditcaretcallbackstruct () (POINTER STRUCT) "alloc_XIMPreeditCaretCallbackStruct")
(foreign-function free-ximpreeditcaretcallbackstruct ((POINTER STRUCT)) VOID "free_XIMPreeditCaretCallbackStruct")
(foreign-function ximpreeditcaretcallbackstruct-position ((POINTER STRUCT)) INT "get_XIMPreeditCaretCallbackStruct_position")
(foreign-function set-ximpreeditcaretcallbackstruct-position! ((POINTER STRUCT) INT) VOID "set_XIMPreeditCaretCallbackStruct_position")
(foreign-function ximpreeditcaretcallbackstruct-direction ((POINTER STRUCT)) INT "get_XIMPreeditCaretCallbackStruct_direction")
(foreign-function set-ximpreeditcaretcallbackstruct-direction! ((POINTER STRUCT) INT) VOID "set_XIMPreeditCaretCallbackStruct_direction")
(foreign-function ximpreeditcaretcallbackstruct-style ((POINTER STRUCT)) INT "get_XIMPreeditCaretCallbackStruct_style")
(foreign-function set-ximpreeditcaretcallbackstruct-style! ((POINTER STRUCT) INT) VOID "set_XIMPreeditCaretCallbackStruct_style")
;;; STRUCT:XIMStatusDrawCallbackStruct
(foreign-function make-ximstatusdrawcallbackstruct () (POINTER STRUCT) "alloc_XIMStatusDrawCallbackStruct")
(foreign-function free-ximstatusdrawcallbackstruct ((POINTER STRUCT)) VOID "free_XIMStatusDrawCallbackStruct")
(foreign-function ximstatusdrawcallbackstruct-type ((POINTER STRUCT)) INT "get_XIMStatusDrawCallbackStruct_type")
(foreign-function set-ximstatusdrawcallbackstruct-type! ((POINTER STRUCT) INT) VOID "set_XIMStatusDrawCallbackStruct_type")
(foreign-function ximstatusdrawcallbackstruct-data-text ((POINTER UNION)) (POINTER STRUCT) "get_XIMStatusDrawCallbackStruct_data_text")
(foreign-function set-ximstatusdrawcallbackstruct-data-text! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XIMStatusDrawCallbackStruct_data_text")
(foreign-function ximstatusdrawcallbackstruct-data-bitmap ((POINTER UNION)) UNSIGNED-LONG "get_XIMStatusDrawCallbackStruct_data_bitmap")
(foreign-function set-ximstatusdrawcallbackstruct-data-bitmap! ((POINTER UNION) UNSIGNED-LONG) VOID "set_XIMStatusDrawCallbackStruct_data_bitmap")
;;; STRUCT:XSizeHints
(foreign-function make-xsizehints () (POINTER STRUCT) "alloc_XSizeHints")
(foreign-function free-xsizehints ((POINTER STRUCT)) VOID "free_XSizeHints")
(foreign-function xsizehints-flags ((POINTER STRUCT)) INT "get_XSizeHints_flags")
(foreign-function set-xsizehints-flags! ((POINTER STRUCT) INT) VOID "set_XSizeHints_flags")
(foreign-function xsizehints-x ((POINTER STRUCT)) INT "get_XSizeHints_x")
(foreign-function set-xsizehints-x! ((POINTER STRUCT) INT) VOID "set_XSizeHints_x")
(foreign-function xsizehints-y ((POINTER STRUCT)) INT "get_XSizeHints_y")
(foreign-function set-xsizehints-y! ((POINTER STRUCT) INT) VOID "set_XSizeHints_y")
(foreign-function xsizehints-width ((POINTER STRUCT)) INT "get_XSizeHints_width")
(foreign-function set-xsizehints-width! ((POINTER STRUCT) INT) VOID "set_XSizeHints_width")
(foreign-function xsizehints-height ((POINTER STRUCT)) INT "get_XSizeHints_height")
(foreign-function set-xsizehints-height! ((POINTER STRUCT) INT) VOID "set_XSizeHints_height")
(foreign-function xsizehints-min_width ((POINTER STRUCT)) INT "get_XSizeHints_min_width")
(foreign-function set-xsizehints-min_width! ((POINTER STRUCT) INT) VOID "set_XSizeHints_min_width")
(foreign-function xsizehints-min_height ((POINTER STRUCT)) INT "get_XSizeHints_min_height")
(foreign-function set-xsizehints-min_height! ((POINTER STRUCT) INT) VOID "set_XSizeHints_min_height")
(foreign-function xsizehints-max_width ((POINTER STRUCT)) INT "get_XSizeHints_max_width")
(foreign-function set-xsizehints-max_width! ((POINTER STRUCT) INT) VOID "set_XSizeHints_max_width")
(foreign-function xsizehints-max_height ((POINTER STRUCT)) INT "get_XSizeHints_max_height")
(foreign-function set-xsizehints-max_height! ((POINTER STRUCT) INT) VOID "set_XSizeHints_max_height")
(foreign-function xsizehints-width_inc ((POINTER STRUCT)) INT "get_XSizeHints_width_inc")
(foreign-function set-xsizehints-width_inc! ((POINTER STRUCT) INT) VOID "set_XSizeHints_width_inc")
(foreign-function xsizehints-height_inc ((POINTER STRUCT)) INT "get_XSizeHints_height_inc")
(foreign-function set-xsizehints-height_inc! ((POINTER STRUCT) INT) VOID "set_XSizeHints_height_inc")
(foreign-function xsizehints-min_aspect-x ((POINTER STRUCT)) INT "get_XSizeHints_min_aspect_x")
(foreign-function set-xsizehints-min_aspect-x! ((POINTER STRUCT) INT) VOID "set_XSizeHints_min_aspect_x")
(foreign-function xsizehints-min_aspect-y ((POINTER STRUCT)) INT "get_XSizeHints_min_aspect_y")
(foreign-function set-xsizehints-min_aspect-y! ((POINTER STRUCT) INT) VOID "set_XSizeHints_min_aspect_y")
(foreign-function xsizehints-max_aspect-x ((POINTER STRUCT)) INT "get_XSizeHints_max_aspect_x")
(foreign-function set-xsizehints-max_aspect-x! ((POINTER STRUCT) INT) VOID "set_XSizeHints_max_aspect_x")
(foreign-function xsizehints-max_aspect-y ((POINTER STRUCT)) INT "get_XSizeHints_max_aspect_y")
(foreign-function set-xsizehints-max_aspect-y! ((POINTER STRUCT) INT) VOID "set_XSizeHints_max_aspect_y")
(foreign-function xsizehints-base_width ((POINTER STRUCT)) INT "get_XSizeHints_base_width")
(foreign-function set-xsizehints-base_width! ((POINTER STRUCT) INT) VOID "set_XSizeHints_base_width")
(foreign-function xsizehints-base_height ((POINTER STRUCT)) INT "get_XSizeHints_base_height")
(foreign-function set-xsizehints-base_height! ((POINTER STRUCT) INT) VOID "set_XSizeHints_base_height")
(foreign-function xsizehints-win_gravity ((POINTER STRUCT)) INT "get_XSizeHints_win_gravity")
(foreign-function set-xsizehints-win_gravity! ((POINTER STRUCT) INT) VOID "set_XSizeHints_win_gravity")
;;; STRUCT:XWMHints
(foreign-function make-xwmhints () (POINTER STRUCT) "alloc_XWMHints")
(foreign-function free-xwmhints ((POINTER STRUCT)) VOID "free_XWMHints")
(foreign-function xwmhints-flags ((POINTER STRUCT)) INT "get_XWMHints_flags")
(foreign-function set-xwmhints-flags! ((POINTER STRUCT) INT) VOID "set_XWMHints_flags")
(foreign-function xwmhints-input ((POINTER STRUCT)) INT "get_XWMHints_input")
(foreign-function set-xwmhints-input! ((POINTER STRUCT) INT) VOID "set_XWMHints_input")
(foreign-function xwmhints-initial_state ((POINTER STRUCT)) INT "get_XWMHints_initial_state")
(foreign-function set-xwmhints-initial_state! ((POINTER STRUCT) INT) VOID "set_XWMHints_initial_state")
(foreign-function xwmhints-icon_pixmap ((POINTER STRUCT)) UNSIGNED-LONG "get_XWMHints_icon_pixmap")
(foreign-function set-xwmhints-icon_pixmap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWMHints_icon_pixmap")
(foreign-function xwmhints-icon_window ((POINTER STRUCT)) UNSIGNED-LONG "get_XWMHints_icon_window")
(foreign-function set-xwmhints-icon_window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWMHints_icon_window")
(foreign-function xwmhints-icon_x ((POINTER STRUCT)) INT "get_XWMHints_icon_x")
(foreign-function set-xwmhints-icon_x! ((POINTER STRUCT) INT) VOID "set_XWMHints_icon_x")
(foreign-function xwmhints-icon_y ((POINTER STRUCT)) INT "get_XWMHints_icon_y")
(foreign-function set-xwmhints-icon_y! ((POINTER STRUCT) INT) VOID "set_XWMHints_icon_y")
(foreign-function xwmhints-icon_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XWMHints_icon_mask")
(foreign-function set-xwmhints-icon_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWMHints_icon_mask")
(foreign-function xwmhints-window_group ((POINTER STRUCT)) UNSIGNED-LONG "get_XWMHints_window_group")
(foreign-function set-xwmhints-window_group! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XWMHints_window_group")
;;; STRUCT:XTextProperty
(foreign-function make-xtextproperty () (POINTER STRUCT) "alloc_XTextProperty")
(foreign-function free-xtextproperty ((POINTER STRUCT)) VOID "free_XTextProperty")
(foreign-function xtextproperty-value ((POINTER STRUCT)) (POINTER UNSIGNED-CHAR) "get_XTextProperty_value")
(foreign-function set-xtextproperty-value! ((POINTER STRUCT) (POINTER UNSIGNED-CHAR)) VOID "set_XTextProperty_value")
(foreign-function xtextproperty-encoding ((POINTER STRUCT)) UNSIGNED-LONG "get_XTextProperty_encoding")
(foreign-function set-xtextproperty-encoding! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XTextProperty_encoding")
(foreign-function xtextproperty-format ((POINTER STRUCT)) INT "get_XTextProperty_format")
(foreign-function set-xtextproperty-format! ((POINTER STRUCT) INT) VOID "set_XTextProperty_format")
(foreign-function xtextproperty-nitems ((POINTER STRUCT)) UNSIGNED-LONG "get_XTextProperty_nitems")
(foreign-function set-xtextproperty-nitems! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XTextProperty_nitems")
;;; STRUCT:XIconSize
(foreign-function make-xiconsize () (POINTER STRUCT) "alloc_XIconSize")
(foreign-function free-xiconsize ((POINTER STRUCT)) VOID "free_XIconSize")
(foreign-function xiconsize-min_width ((POINTER STRUCT)) INT "get_XIconSize_min_width")
(foreign-function set-xiconsize-min_width! ((POINTER STRUCT) INT) VOID "set_XIconSize_min_width")
(foreign-function xiconsize-min_height ((POINTER STRUCT)) INT "get_XIconSize_min_height")
(foreign-function set-xiconsize-min_height! ((POINTER STRUCT) INT) VOID "set_XIconSize_min_height")
(foreign-function xiconsize-max_width ((POINTER STRUCT)) INT "get_XIconSize_max_width")
(foreign-function set-xiconsize-max_width! ((POINTER STRUCT) INT) VOID "set_XIconSize_max_width")
(foreign-function xiconsize-max_height ((POINTER STRUCT)) INT "get_XIconSize_max_height")
(foreign-function set-xiconsize-max_height! ((POINTER STRUCT) INT) VOID "set_XIconSize_max_height")
(foreign-function xiconsize-width_inc ((POINTER STRUCT)) INT "get_XIconSize_width_inc")
(foreign-function set-xiconsize-width_inc! ((POINTER STRUCT) INT) VOID "set_XIconSize_width_inc")
(foreign-function xiconsize-height_inc ((POINTER STRUCT)) INT "get_XIconSize_height_inc")
(foreign-function set-xiconsize-height_inc! ((POINTER STRUCT) INT) VOID "set_XIconSize_height_inc")
;;; STRUCT:XClassHint
(foreign-function make-xclasshint () (POINTER STRUCT) "alloc_XClassHint")
(foreign-function free-xclasshint ((POINTER STRUCT)) VOID "free_XClassHint")
(foreign-function xclasshint-res_name ((POINTER STRUCT)) (POINTER CHAR) "get_XClassHint_res_name")
(foreign-function set-xclasshint-res_name! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XClassHint_res_name")
(foreign-function xclasshint-res_class ((POINTER STRUCT)) (POINTER CHAR) "get_XClassHint_res_class")
(foreign-function set-xclasshint-res_class! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XClassHint_res_class")
;;; STRUCT:XComposeStatus
(foreign-function make-xcomposestatus () (POINTER STRUCT) "alloc_XComposeStatus")
(foreign-function free-xcomposestatus ((POINTER STRUCT)) VOID "free_XComposeStatus")
(foreign-function xcomposestatus-compose_ptr ((POINTER STRUCT)) (POINTER CHAR) "get_XComposeStatus_compose_ptr")
(foreign-function set-xcomposestatus-compose_ptr! ((POINTER STRUCT) (POINTER CHAR)) VOID "set_XComposeStatus_compose_ptr")
(foreign-function xcomposestatus-chars_matched ((POINTER STRUCT)) INT "get_XComposeStatus_chars_matched")
(foreign-function set-xcomposestatus-chars_matched! ((POINTER STRUCT) INT) VOID "set_XComposeStatus_chars_matched")
;;; STRUCT:XVisualInfo
(foreign-function make-xvisualinfo () (POINTER STRUCT) "alloc_XVisualInfo")
(foreign-function free-xvisualinfo ((POINTER STRUCT)) VOID "free_XVisualInfo")
(foreign-function xvisualinfo-visual ((POINTER STRUCT)) (POINTER STRUCT) "get_XVisualInfo_visual")
(foreign-function set-xvisualinfo-visual! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XVisualInfo_visual")
(foreign-function xvisualinfo-visualid ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisualInfo_visualid")
(foreign-function set-xvisualinfo-visualid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisualInfo_visualid")
(foreign-function xvisualinfo-screen ((POINTER STRUCT)) INT "get_XVisualInfo_screen")
(foreign-function set-xvisualinfo-screen! ((POINTER STRUCT) INT) VOID "set_XVisualInfo_screen")
(foreign-function xvisualinfo-depth ((POINTER STRUCT)) INT "get_XVisualInfo_depth")
(foreign-function set-xvisualinfo-depth! ((POINTER STRUCT) INT) VOID "set_XVisualInfo_depth")
(foreign-function xvisualinfo-class ((POINTER STRUCT)) INT "get_XVisualInfo_class")
(foreign-function set-xvisualinfo-class! ((POINTER STRUCT) INT) VOID "set_XVisualInfo_class")
(foreign-function xvisualinfo-red_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisualInfo_red_mask")
(foreign-function set-xvisualinfo-red_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisualInfo_red_mask")
(foreign-function xvisualinfo-green_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisualInfo_green_mask")
(foreign-function set-xvisualinfo-green_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisualInfo_green_mask")
(foreign-function xvisualinfo-blue_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XVisualInfo_blue_mask")
(foreign-function set-xvisualinfo-blue_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XVisualInfo_blue_mask")
(foreign-function xvisualinfo-colormap_size ((POINTER STRUCT)) INT "get_XVisualInfo_colormap_size")
(foreign-function set-xvisualinfo-colormap_size! ((POINTER STRUCT) INT) VOID "set_XVisualInfo_colormap_size")
(foreign-function xvisualinfo-bits_per_rgb ((POINTER STRUCT)) INT "get_XVisualInfo_bits_per_rgb")
(foreign-function set-xvisualinfo-bits_per_rgb! ((POINTER STRUCT) INT) VOID "set_XVisualInfo_bits_per_rgb")
;;; STRUCT:XStandardColormap
(foreign-function make-xstandardcolormap () (POINTER STRUCT) "alloc_XStandardColormap")
(foreign-function free-xstandardcolormap ((POINTER STRUCT)) VOID "free_XStandardColormap")
(foreign-function xstandardcolormap-colormap ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_colormap")
(foreign-function set-xstandardcolormap-colormap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_colormap")
(foreign-function xstandardcolormap-red_max ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_red_max")
(foreign-function set-xstandardcolormap-red_max! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_red_max")
(foreign-function xstandardcolormap-red_mult ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_red_mult")
(foreign-function set-xstandardcolormap-red_mult! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_red_mult")
(foreign-function xstandardcolormap-green_max ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_green_max")
(foreign-function set-xstandardcolormap-green_max! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_green_max")
(foreign-function xstandardcolormap-green_mult ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_green_mult")
(foreign-function set-xstandardcolormap-green_mult! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_green_mult")
(foreign-function xstandardcolormap-blue_max ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_blue_max")
(foreign-function set-xstandardcolormap-blue_max! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_blue_max")
(foreign-function xstandardcolormap-blue_mult ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_blue_mult")
(foreign-function set-xstandardcolormap-blue_mult! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_blue_mult")
(foreign-function xstandardcolormap-base_pixel ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_base_pixel")
(foreign-function set-xstandardcolormap-base_pixel! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_base_pixel")
(foreign-function xstandardcolormap-visualid ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_visualid")
(foreign-function set-xstandardcolormap-visualid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_visualid")
(foreign-function xstandardcolormap-killid ((POINTER STRUCT)) UNSIGNED-LONG "get_XStandardColormap_killid")
(foreign-function set-xstandardcolormap-killid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XStandardColormap_killid")

;;; *** UNIONS ***
;;; UNION:XEvent
(foreign-function make-xevent () (POINTER UNION) "alloc_XEvent")
(foreign-function free-xevent ((POINTER UNION)) VOID "free_XEvent")
(foreign-function xevent-type ((POINTER UNION)) INT "get_XEvent_type")
(foreign-function set-xevent-type! ((POINTER UNION) INT) VOID "set_XEvent_type")
(foreign-function xevent-xany-type ((POINTER STRUCT)) INT "get_XEvent_xany_type")
(foreign-function set-xevent-xany-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xany_type")
(foreign-function xevent-xany-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xany_serial")
(foreign-function set-xevent-xany-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xany_serial")
(foreign-function xevent-xany-send_event ((POINTER STRUCT)) INT "get_XEvent_xany_send_event")
(foreign-function set-xevent-xany-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xany_send_event")
(foreign-function xevent-xany-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xany_display")
(foreign-function set-xevent-xany-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xany_display")
(foreign-function xevent-xany-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xany_window")
(foreign-function set-xevent-xany-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xany_window")
(foreign-function xevent-xkey-type ((POINTER STRUCT)) INT "get_XEvent_xkey_type")
(foreign-function set-xevent-xkey-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_type")
(foreign-function xevent-xkey-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkey_serial")
(foreign-function set-xevent-xkey-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkey_serial")
(foreign-function xevent-xkey-send_event ((POINTER STRUCT)) INT "get_XEvent_xkey_send_event")
(foreign-function set-xevent-xkey-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_send_event")
(foreign-function xevent-xkey-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xkey_display")
(foreign-function set-xevent-xkey-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xkey_display")
(foreign-function xevent-xkey-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkey_window")
(foreign-function set-xevent-xkey-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkey_window")
(foreign-function xevent-xkey-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkey_root")
(foreign-function set-xevent-xkey-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkey_root")
(foreign-function xevent-xkey-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkey_subwindow")
(foreign-function set-xevent-xkey-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkey_subwindow")
(foreign-function xevent-xkey-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkey_time")
(foreign-function set-xevent-xkey-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkey_time")
(foreign-function xevent-xkey-x ((POINTER STRUCT)) INT "get_XEvent_xkey_x")
(foreign-function set-xevent-xkey-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_x")
(foreign-function xevent-xkey-y ((POINTER STRUCT)) INT "get_XEvent_xkey_y")
(foreign-function set-xevent-xkey-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_y")
(foreign-function xevent-xkey-x_root ((POINTER STRUCT)) INT "get_XEvent_xkey_x_root")
(foreign-function set-xevent-xkey-x_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_x_root")
(foreign-function xevent-xkey-y_root ((POINTER STRUCT)) INT "get_XEvent_xkey_y_root")
(foreign-function set-xevent-xkey-y_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_y_root")
(foreign-function xevent-xkey-state ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xkey_state")
(foreign-function set-xevent-xkey-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xkey_state")
(foreign-function xevent-xkey-keycode ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xkey_keycode")
(foreign-function set-xevent-xkey-keycode! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xkey_keycode")
(foreign-function xevent-xkey-same_screen ((POINTER STRUCT)) INT "get_XEvent_xkey_same_screen")
(foreign-function set-xevent-xkey-same_screen! ((POINTER STRUCT) INT) VOID "set_XEvent_xkey_same_screen")
(foreign-function xevent-xbutton-type ((POINTER STRUCT)) INT "get_XEvent_xbutton_type")
(foreign-function set-xevent-xbutton-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_type")
(foreign-function xevent-xbutton-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xbutton_serial")
(foreign-function set-xevent-xbutton-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xbutton_serial")
(foreign-function xevent-xbutton-send_event ((POINTER STRUCT)) INT "get_XEvent_xbutton_send_event")
(foreign-function set-xevent-xbutton-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_send_event")
(foreign-function xevent-xbutton-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xbutton_display")
(foreign-function set-xevent-xbutton-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xbutton_display")
(foreign-function xevent-xbutton-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xbutton_window")
(foreign-function set-xevent-xbutton-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xbutton_window")
(foreign-function xevent-xbutton-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xbutton_root")
(foreign-function set-xevent-xbutton-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xbutton_root")
(foreign-function xevent-xbutton-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xbutton_subwindow")
(foreign-function set-xevent-xbutton-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xbutton_subwindow")
(foreign-function xevent-xbutton-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xbutton_time")
(foreign-function set-xevent-xbutton-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xbutton_time")
(foreign-function xevent-xbutton-x ((POINTER STRUCT)) INT "get_XEvent_xbutton_x")
(foreign-function set-xevent-xbutton-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_x")
(foreign-function xevent-xbutton-y ((POINTER STRUCT)) INT "get_XEvent_xbutton_y")
(foreign-function set-xevent-xbutton-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_y")
(foreign-function xevent-xbutton-x_root ((POINTER STRUCT)) INT "get_XEvent_xbutton_x_root")
(foreign-function set-xevent-xbutton-x_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_x_root")
(foreign-function xevent-xbutton-y_root ((POINTER STRUCT)) INT "get_XEvent_xbutton_y_root")
(foreign-function set-xevent-xbutton-y_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_y_root")
(foreign-function xevent-xbutton-state ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xbutton_state")
(foreign-function set-xevent-xbutton-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xbutton_state")
(foreign-function xevent-xbutton-button ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xbutton_button")
(foreign-function set-xevent-xbutton-button! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xbutton_button")
(foreign-function xevent-xbutton-same_screen ((POINTER STRUCT)) INT "get_XEvent_xbutton_same_screen")
(foreign-function set-xevent-xbutton-same_screen! ((POINTER STRUCT) INT) VOID "set_XEvent_xbutton_same_screen")
(foreign-function xevent-xmotion-type ((POINTER STRUCT)) INT "get_XEvent_xmotion_type")
(foreign-function set-xevent-xmotion-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_type")
(foreign-function xevent-xmotion-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmotion_serial")
(foreign-function set-xevent-xmotion-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmotion_serial")
(foreign-function xevent-xmotion-send_event ((POINTER STRUCT)) INT "get_XEvent_xmotion_send_event")
(foreign-function set-xevent-xmotion-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_send_event")
(foreign-function xevent-xmotion-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xmotion_display")
(foreign-function set-xevent-xmotion-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xmotion_display")
(foreign-function xevent-xmotion-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmotion_window")
(foreign-function set-xevent-xmotion-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmotion_window")
(foreign-function xevent-xmotion-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmotion_root")
(foreign-function set-xevent-xmotion-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmotion_root")
(foreign-function xevent-xmotion-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmotion_subwindow")
(foreign-function set-xevent-xmotion-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmotion_subwindow")
(foreign-function xevent-xmotion-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmotion_time")
(foreign-function set-xevent-xmotion-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmotion_time")
(foreign-function xevent-xmotion-x ((POINTER STRUCT)) INT "get_XEvent_xmotion_x")
(foreign-function set-xevent-xmotion-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_x")
(foreign-function xevent-xmotion-y ((POINTER STRUCT)) INT "get_XEvent_xmotion_y")
(foreign-function set-xevent-xmotion-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_y")
(foreign-function xevent-xmotion-x_root ((POINTER STRUCT)) INT "get_XEvent_xmotion_x_root")
(foreign-function set-xevent-xmotion-x_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_x_root")
(foreign-function xevent-xmotion-y_root ((POINTER STRUCT)) INT "get_XEvent_xmotion_y_root")
(foreign-function set-xevent-xmotion-y_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_y_root")
(foreign-function xevent-xmotion-state ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xmotion_state")
(foreign-function set-xevent-xmotion-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xmotion_state")
(foreign-function xevent-xmotion-is_hint ((POINTER STRUCT)) CHAR "get_XEvent_xmotion_is_hint")
(foreign-function set-xevent-xmotion-is_hint! ((POINTER STRUCT) CHAR) VOID "set_XEvent_xmotion_is_hint")
(foreign-function xevent-xmotion-same_screen ((POINTER STRUCT)) INT "get_XEvent_xmotion_same_screen")
(foreign-function set-xevent-xmotion-same_screen! ((POINTER STRUCT) INT) VOID "set_XEvent_xmotion_same_screen")
(foreign-function xevent-xcrossing-type ((POINTER STRUCT)) INT "get_XEvent_xcrossing_type")
(foreign-function set-xevent-xcrossing-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_type")
(foreign-function xevent-xcrossing-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcrossing_serial")
(foreign-function set-xevent-xcrossing-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcrossing_serial")
(foreign-function xevent-xcrossing-send_event ((POINTER STRUCT)) INT "get_XEvent_xcrossing_send_event")
(foreign-function set-xevent-xcrossing-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_send_event")
(foreign-function xevent-xcrossing-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xcrossing_display")
(foreign-function set-xevent-xcrossing-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xcrossing_display")
(foreign-function xevent-xcrossing-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcrossing_window")
(foreign-function set-xevent-xcrossing-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcrossing_window")
(foreign-function xevent-xcrossing-root ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcrossing_root")
(foreign-function set-xevent-xcrossing-root! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcrossing_root")
(foreign-function xevent-xcrossing-subwindow ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcrossing_subwindow")
(foreign-function set-xevent-xcrossing-subwindow! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcrossing_subwindow")
(foreign-function xevent-xcrossing-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcrossing_time")
(foreign-function set-xevent-xcrossing-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcrossing_time")
(foreign-function xevent-xcrossing-x ((POINTER STRUCT)) INT "get_XEvent_xcrossing_x")
(foreign-function set-xevent-xcrossing-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_x")
(foreign-function xevent-xcrossing-y ((POINTER STRUCT)) INT "get_XEvent_xcrossing_y")
(foreign-function set-xevent-xcrossing-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_y")
(foreign-function xevent-xcrossing-x_root ((POINTER STRUCT)) INT "get_XEvent_xcrossing_x_root")
(foreign-function set-xevent-xcrossing-x_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_x_root")
(foreign-function xevent-xcrossing-y_root ((POINTER STRUCT)) INT "get_XEvent_xcrossing_y_root")
(foreign-function set-xevent-xcrossing-y_root! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_y_root")
(foreign-function xevent-xcrossing-mode ((POINTER STRUCT)) INT "get_XEvent_xcrossing_mode")
(foreign-function set-xevent-xcrossing-mode! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_mode")
(foreign-function xevent-xcrossing-detail ((POINTER STRUCT)) INT "get_XEvent_xcrossing_detail")
(foreign-function set-xevent-xcrossing-detail! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_detail")
(foreign-function xevent-xcrossing-same_screen ((POINTER STRUCT)) INT "get_XEvent_xcrossing_same_screen")
(foreign-function set-xevent-xcrossing-same_screen! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_same_screen")
(foreign-function xevent-xcrossing-focus ((POINTER STRUCT)) INT "get_XEvent_xcrossing_focus")
(foreign-function set-xevent-xcrossing-focus! ((POINTER STRUCT) INT) VOID "set_XEvent_xcrossing_focus")
(foreign-function xevent-xcrossing-state ((POINTER STRUCT)) UNSIGNED-INT "get_XEvent_xcrossing_state")
(foreign-function set-xevent-xcrossing-state! ((POINTER STRUCT) UNSIGNED-INT) VOID "set_XEvent_xcrossing_state")
(foreign-function xevent-xfocus-type ((POINTER STRUCT)) INT "get_XEvent_xfocus_type")
(foreign-function set-xevent-xfocus-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xfocus_type")
(foreign-function xevent-xfocus-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xfocus_serial")
(foreign-function set-xevent-xfocus-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xfocus_serial")
(foreign-function xevent-xfocus-send_event ((POINTER STRUCT)) INT "get_XEvent_xfocus_send_event")
(foreign-function set-xevent-xfocus-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xfocus_send_event")
(foreign-function xevent-xfocus-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xfocus_display")
(foreign-function set-xevent-xfocus-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xfocus_display")
(foreign-function xevent-xfocus-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xfocus_window")
(foreign-function set-xevent-xfocus-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xfocus_window")
(foreign-function xevent-xfocus-mode ((POINTER STRUCT)) INT "get_XEvent_xfocus_mode")
(foreign-function set-xevent-xfocus-mode! ((POINTER STRUCT) INT) VOID "set_XEvent_xfocus_mode")
(foreign-function xevent-xfocus-detail ((POINTER STRUCT)) INT "get_XEvent_xfocus_detail")
(foreign-function set-xevent-xfocus-detail! ((POINTER STRUCT) INT) VOID "set_XEvent_xfocus_detail")
(foreign-function xevent-xexpose-type ((POINTER STRUCT)) INT "get_XEvent_xexpose_type")
(foreign-function set-xevent-xexpose-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_type")
(foreign-function xevent-xexpose-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xexpose_serial")
(foreign-function set-xevent-xexpose-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xexpose_serial")
(foreign-function xevent-xexpose-send_event ((POINTER STRUCT)) INT "get_XEvent_xexpose_send_event")
(foreign-function set-xevent-xexpose-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_send_event")
(foreign-function xevent-xexpose-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xexpose_display")
(foreign-function set-xevent-xexpose-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xexpose_display")
(foreign-function xevent-xexpose-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xexpose_window")
(foreign-function set-xevent-xexpose-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xexpose_window")
(foreign-function xevent-xexpose-x ((POINTER STRUCT)) INT "get_XEvent_xexpose_x")
(foreign-function set-xevent-xexpose-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_x")
(foreign-function xevent-xexpose-y ((POINTER STRUCT)) INT "get_XEvent_xexpose_y")
(foreign-function set-xevent-xexpose-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_y")
(foreign-function xevent-xexpose-width ((POINTER STRUCT)) INT "get_XEvent_xexpose_width")
(foreign-function set-xevent-xexpose-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_width")
(foreign-function xevent-xexpose-height ((POINTER STRUCT)) INT "get_XEvent_xexpose_height")
(foreign-function set-xevent-xexpose-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_height")
(foreign-function xevent-xexpose-count ((POINTER STRUCT)) INT "get_XEvent_xexpose_count")
(foreign-function set-xevent-xexpose-count! ((POINTER STRUCT) INT) VOID "set_XEvent_xexpose_count")
(foreign-function xevent-xgraphicsexpose-type ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_type")
(foreign-function set-xevent-xgraphicsexpose-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_type")
(foreign-function xevent-xgraphicsexpose-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xgraphicsexpose_serial")
(foreign-function set-xevent-xgraphicsexpose-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xgraphicsexpose_serial")
(foreign-function xevent-xgraphicsexpose-send_event ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_send_event")
(foreign-function set-xevent-xgraphicsexpose-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_send_event")
(foreign-function xevent-xgraphicsexpose-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xgraphicsexpose_display")
(foreign-function set-xevent-xgraphicsexpose-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xgraphicsexpose_display")
(foreign-function xevent-xgraphicsexpose-drawable ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xgraphicsexpose_drawable")
(foreign-function set-xevent-xgraphicsexpose-drawable! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xgraphicsexpose_drawable")
(foreign-function xevent-xgraphicsexpose-x ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_x")
(foreign-function set-xevent-xgraphicsexpose-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_x")
(foreign-function xevent-xgraphicsexpose-y ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_y")
(foreign-function set-xevent-xgraphicsexpose-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_y")
(foreign-function xevent-xgraphicsexpose-width ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_width")
(foreign-function set-xevent-xgraphicsexpose-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_width")
(foreign-function xevent-xgraphicsexpose-height ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_height")
(foreign-function set-xevent-xgraphicsexpose-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_height")
(foreign-function xevent-xgraphicsexpose-count ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_count")
(foreign-function set-xevent-xgraphicsexpose-count! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_count")
(foreign-function xevent-xgraphicsexpose-major_code ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_major_code")
(foreign-function set-xevent-xgraphicsexpose-major_code! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_major_code")
(foreign-function xevent-xgraphicsexpose-minor_code ((POINTER STRUCT)) INT "get_XEvent_xgraphicsexpose_minor_code")
(foreign-function set-xevent-xgraphicsexpose-minor_code! ((POINTER STRUCT) INT) VOID "set_XEvent_xgraphicsexpose_minor_code")
(foreign-function xevent-xnoexpose-type ((POINTER STRUCT)) INT "get_XEvent_xnoexpose_type")
(foreign-function set-xevent-xnoexpose-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xnoexpose_type")
(foreign-function xevent-xnoexpose-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xnoexpose_serial")
(foreign-function set-xevent-xnoexpose-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xnoexpose_serial")
(foreign-function xevent-xnoexpose-send_event ((POINTER STRUCT)) INT "get_XEvent_xnoexpose_send_event")
(foreign-function set-xevent-xnoexpose-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xnoexpose_send_event")
(foreign-function xevent-xnoexpose-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xnoexpose_display")
(foreign-function set-xevent-xnoexpose-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xnoexpose_display")
(foreign-function xevent-xnoexpose-drawable ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xnoexpose_drawable")
(foreign-function set-xevent-xnoexpose-drawable! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xnoexpose_drawable")
(foreign-function xevent-xnoexpose-major_code ((POINTER STRUCT)) INT "get_XEvent_xnoexpose_major_code")
(foreign-function set-xevent-xnoexpose-major_code! ((POINTER STRUCT) INT) VOID "set_XEvent_xnoexpose_major_code")
(foreign-function xevent-xnoexpose-minor_code ((POINTER STRUCT)) INT "get_XEvent_xnoexpose_minor_code")
(foreign-function set-xevent-xnoexpose-minor_code! ((POINTER STRUCT) INT) VOID "set_XEvent_xnoexpose_minor_code")
(foreign-function xevent-xvisibility-type ((POINTER STRUCT)) INT "get_XEvent_xvisibility_type")
(foreign-function set-xevent-xvisibility-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xvisibility_type")
(foreign-function xevent-xvisibility-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xvisibility_serial")
(foreign-function set-xevent-xvisibility-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xvisibility_serial")
(foreign-function xevent-xvisibility-send_event ((POINTER STRUCT)) INT "get_XEvent_xvisibility_send_event")
(foreign-function set-xevent-xvisibility-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xvisibility_send_event")
(foreign-function xevent-xvisibility-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xvisibility_display")
(foreign-function set-xevent-xvisibility-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xvisibility_display")
(foreign-function xevent-xvisibility-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xvisibility_window")
(foreign-function set-xevent-xvisibility-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xvisibility_window")
(foreign-function xevent-xvisibility-state ((POINTER STRUCT)) INT "get_XEvent_xvisibility_state")
(foreign-function set-xevent-xvisibility-state! ((POINTER STRUCT) INT) VOID "set_XEvent_xvisibility_state")
(foreign-function xevent-xcreatewindow-type ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_type")
(foreign-function set-xevent-xcreatewindow-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_type")
(foreign-function xevent-xcreatewindow-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcreatewindow_serial")
(foreign-function set-xevent-xcreatewindow-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcreatewindow_serial")
(foreign-function xevent-xcreatewindow-send_event ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_send_event")
(foreign-function set-xevent-xcreatewindow-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_send_event")
(foreign-function xevent-xcreatewindow-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xcreatewindow_display")
(foreign-function set-xevent-xcreatewindow-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xcreatewindow_display")
(foreign-function xevent-xcreatewindow-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcreatewindow_parent")
(foreign-function set-xevent-xcreatewindow-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcreatewindow_parent")
(foreign-function xevent-xcreatewindow-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcreatewindow_window")
(foreign-function set-xevent-xcreatewindow-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcreatewindow_window")
(foreign-function xevent-xcreatewindow-x ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_x")
(foreign-function set-xevent-xcreatewindow-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_x")
(foreign-function xevent-xcreatewindow-y ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_y")
(foreign-function set-xevent-xcreatewindow-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_y")
(foreign-function xevent-xcreatewindow-width ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_width")
(foreign-function set-xevent-xcreatewindow-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_width")
(foreign-function xevent-xcreatewindow-height ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_height")
(foreign-function set-xevent-xcreatewindow-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_height")
(foreign-function xevent-xcreatewindow-border_width ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_border_width")
(foreign-function set-xevent-xcreatewindow-border_width! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_border_width")
(foreign-function xevent-xcreatewindow-override_redirect ((POINTER STRUCT)) INT "get_XEvent_xcreatewindow_override_redirect")
(foreign-function set-xevent-xcreatewindow-override_redirect! ((POINTER STRUCT) INT) VOID "set_XEvent_xcreatewindow_override_redirect")
(foreign-function xevent-xdestroywindow-type ((POINTER STRUCT)) INT "get_XEvent_xdestroywindow_type")
(foreign-function set-xevent-xdestroywindow-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xdestroywindow_type")
(foreign-function xevent-xdestroywindow-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xdestroywindow_serial")
(foreign-function set-xevent-xdestroywindow-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xdestroywindow_serial")
(foreign-function xevent-xdestroywindow-send_event ((POINTER STRUCT)) INT "get_XEvent_xdestroywindow_send_event")
(foreign-function set-xevent-xdestroywindow-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xdestroywindow_send_event")
(foreign-function xevent-xdestroywindow-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xdestroywindow_display")
(foreign-function set-xevent-xdestroywindow-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xdestroywindow_display")
(foreign-function xevent-xdestroywindow-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xdestroywindow_event")
(foreign-function set-xevent-xdestroywindow-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xdestroywindow_event")
(foreign-function xevent-xdestroywindow-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xdestroywindow_window")
(foreign-function set-xevent-xdestroywindow-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xdestroywindow_window")
(foreign-function xevent-xunmap-type ((POINTER STRUCT)) INT "get_XEvent_xunmap_type")
(foreign-function set-xevent-xunmap-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xunmap_type")
(foreign-function xevent-xunmap-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xunmap_serial")
(foreign-function set-xevent-xunmap-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xunmap_serial")
(foreign-function xevent-xunmap-send_event ((POINTER STRUCT)) INT "get_XEvent_xunmap_send_event")
(foreign-function set-xevent-xunmap-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xunmap_send_event")
(foreign-function xevent-xunmap-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xunmap_display")
(foreign-function set-xevent-xunmap-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xunmap_display")
(foreign-function xevent-xunmap-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xunmap_event")
(foreign-function set-xevent-xunmap-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xunmap_event")
(foreign-function xevent-xunmap-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xunmap_window")
(foreign-function set-xevent-xunmap-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xunmap_window")
(foreign-function xevent-xunmap-from_configure ((POINTER STRUCT)) INT "get_XEvent_xunmap_from_configure")
(foreign-function set-xevent-xunmap-from_configure! ((POINTER STRUCT) INT) VOID "set_XEvent_xunmap_from_configure")
(foreign-function xevent-xmap-type ((POINTER STRUCT)) INT "get_XEvent_xmap_type")
(foreign-function set-xevent-xmap-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xmap_type")
(foreign-function xevent-xmap-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmap_serial")
(foreign-function set-xevent-xmap-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmap_serial")
(foreign-function xevent-xmap-send_event ((POINTER STRUCT)) INT "get_XEvent_xmap_send_event")
(foreign-function set-xevent-xmap-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xmap_send_event")
(foreign-function xevent-xmap-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xmap_display")
(foreign-function set-xevent-xmap-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xmap_display")
(foreign-function xevent-xmap-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmap_event")
(foreign-function set-xevent-xmap-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmap_event")
(foreign-function xevent-xmap-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmap_window")
(foreign-function set-xevent-xmap-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmap_window")
(foreign-function xevent-xmap-override_redirect ((POINTER STRUCT)) INT "get_XEvent_xmap_override_redirect")
(foreign-function set-xevent-xmap-override_redirect! ((POINTER STRUCT) INT) VOID "set_XEvent_xmap_override_redirect")
(foreign-function xevent-xmaprequest-type ((POINTER STRUCT)) INT "get_XEvent_xmaprequest_type")
(foreign-function set-xevent-xmaprequest-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xmaprequest_type")
(foreign-function xevent-xmaprequest-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmaprequest_serial")
(foreign-function set-xevent-xmaprequest-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmaprequest_serial")
(foreign-function xevent-xmaprequest-send_event ((POINTER STRUCT)) INT "get_XEvent_xmaprequest_send_event")
(foreign-function set-xevent-xmaprequest-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xmaprequest_send_event")
(foreign-function xevent-xmaprequest-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xmaprequest_display")
(foreign-function set-xevent-xmaprequest-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xmaprequest_display")
(foreign-function xevent-xmaprequest-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmaprequest_parent")
(foreign-function set-xevent-xmaprequest-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmaprequest_parent")
(foreign-function xevent-xmaprequest-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmaprequest_window")
(foreign-function set-xevent-xmaprequest-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmaprequest_window")
(foreign-function xevent-xreparent-type ((POINTER STRUCT)) INT "get_XEvent_xreparent_type")
(foreign-function set-xevent-xreparent-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xreparent_type")
(foreign-function xevent-xreparent-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xreparent_serial")
(foreign-function set-xevent-xreparent-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xreparent_serial")
(foreign-function xevent-xreparent-send_event ((POINTER STRUCT)) INT "get_XEvent_xreparent_send_event")
(foreign-function set-xevent-xreparent-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xreparent_send_event")
(foreign-function xevent-xreparent-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xreparent_display")
(foreign-function set-xevent-xreparent-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xreparent_display")
(foreign-function xevent-xreparent-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xreparent_event")
(foreign-function set-xevent-xreparent-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xreparent_event")
(foreign-function xevent-xreparent-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xreparent_window")
(foreign-function set-xevent-xreparent-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xreparent_window")
(foreign-function xevent-xreparent-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xreparent_parent")
(foreign-function set-xevent-xreparent-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xreparent_parent")
(foreign-function xevent-xreparent-x ((POINTER STRUCT)) INT "get_XEvent_xreparent_x")
(foreign-function set-xevent-xreparent-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xreparent_x")
(foreign-function xevent-xreparent-y ((POINTER STRUCT)) INT "get_XEvent_xreparent_y")
(foreign-function set-xevent-xreparent-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xreparent_y")
(foreign-function xevent-xreparent-override_redirect ((POINTER STRUCT)) INT "get_XEvent_xreparent_override_redirect")
(foreign-function set-xevent-xreparent-override_redirect! ((POINTER STRUCT) INT) VOID "set_XEvent_xreparent_override_redirect")
(foreign-function xevent-xconfigure-type ((POINTER STRUCT)) INT "get_XEvent_xconfigure_type")
(foreign-function set-xevent-xconfigure-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_type")
(foreign-function xevent-xconfigure-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigure_serial")
(foreign-function set-xevent-xconfigure-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigure_serial")
(foreign-function xevent-xconfigure-send_event ((POINTER STRUCT)) INT "get_XEvent_xconfigure_send_event")
(foreign-function set-xevent-xconfigure-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_send_event")
(foreign-function xevent-xconfigure-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xconfigure_display")
(foreign-function set-xevent-xconfigure-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xconfigure_display")
(foreign-function xevent-xconfigure-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigure_event")
(foreign-function set-xevent-xconfigure-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigure_event")
(foreign-function xevent-xconfigure-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigure_window")
(foreign-function set-xevent-xconfigure-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigure_window")
(foreign-function xevent-xconfigure-x ((POINTER STRUCT)) INT "get_XEvent_xconfigure_x")
(foreign-function set-xevent-xconfigure-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_x")
(foreign-function xevent-xconfigure-y ((POINTER STRUCT)) INT "get_XEvent_xconfigure_y")
(foreign-function set-xevent-xconfigure-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_y")
(foreign-function xevent-xconfigure-width ((POINTER STRUCT)) INT "get_XEvent_xconfigure_width")
(foreign-function set-xevent-xconfigure-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_width")
(foreign-function xevent-xconfigure-height ((POINTER STRUCT)) INT "get_XEvent_xconfigure_height")
(foreign-function set-xevent-xconfigure-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_height")
(foreign-function xevent-xconfigure-border_width ((POINTER STRUCT)) INT "get_XEvent_xconfigure_border_width")
(foreign-function set-xevent-xconfigure-border_width! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_border_width")
(foreign-function xevent-xconfigure-above ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigure_above")
(foreign-function set-xevent-xconfigure-above! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigure_above")
(foreign-function xevent-xconfigure-override_redirect ((POINTER STRUCT)) INT "get_XEvent_xconfigure_override_redirect")
(foreign-function set-xevent-xconfigure-override_redirect! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigure_override_redirect")
(foreign-function xevent-xgravity-type ((POINTER STRUCT)) INT "get_XEvent_xgravity_type")
(foreign-function set-xevent-xgravity-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xgravity_type")
(foreign-function xevent-xgravity-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xgravity_serial")
(foreign-function set-xevent-xgravity-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xgravity_serial")
(foreign-function xevent-xgravity-send_event ((POINTER STRUCT)) INT "get_XEvent_xgravity_send_event")
(foreign-function set-xevent-xgravity-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xgravity_send_event")
(foreign-function xevent-xgravity-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xgravity_display")
(foreign-function set-xevent-xgravity-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xgravity_display")
(foreign-function xevent-xgravity-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xgravity_event")
(foreign-function set-xevent-xgravity-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xgravity_event")
(foreign-function xevent-xgravity-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xgravity_window")
(foreign-function set-xevent-xgravity-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xgravity_window")
(foreign-function xevent-xgravity-x ((POINTER STRUCT)) INT "get_XEvent_xgravity_x")
(foreign-function set-xevent-xgravity-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xgravity_x")
(foreign-function xevent-xgravity-y ((POINTER STRUCT)) INT "get_XEvent_xgravity_y")
(foreign-function set-xevent-xgravity-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xgravity_y")
(foreign-function xevent-xresizerequest-type ((POINTER STRUCT)) INT "get_XEvent_xresizerequest_type")
(foreign-function set-xevent-xresizerequest-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xresizerequest_type")
(foreign-function xevent-xresizerequest-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xresizerequest_serial")
(foreign-function set-xevent-xresizerequest-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xresizerequest_serial")
(foreign-function xevent-xresizerequest-send_event ((POINTER STRUCT)) INT "get_XEvent_xresizerequest_send_event")
(foreign-function set-xevent-xresizerequest-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xresizerequest_send_event")
(foreign-function xevent-xresizerequest-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xresizerequest_display")
(foreign-function set-xevent-xresizerequest-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xresizerequest_display")
(foreign-function xevent-xresizerequest-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xresizerequest_window")
(foreign-function set-xevent-xresizerequest-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xresizerequest_window")
(foreign-function xevent-xresizerequest-width ((POINTER STRUCT)) INT "get_XEvent_xresizerequest_width")
(foreign-function set-xevent-xresizerequest-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xresizerequest_width")
(foreign-function xevent-xresizerequest-height ((POINTER STRUCT)) INT "get_XEvent_xresizerequest_height")
(foreign-function set-xevent-xresizerequest-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xresizerequest_height")
(foreign-function xevent-xconfigurerequest-type ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_type")
(foreign-function set-xevent-xconfigurerequest-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_type")
(foreign-function xevent-xconfigurerequest-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigurerequest_serial")
(foreign-function set-xevent-xconfigurerequest-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigurerequest_serial")
(foreign-function xevent-xconfigurerequest-send_event ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_send_event")
(foreign-function set-xevent-xconfigurerequest-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_send_event")
(foreign-function xevent-xconfigurerequest-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xconfigurerequest_display")
(foreign-function set-xevent-xconfigurerequest-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xconfigurerequest_display")
(foreign-function xevent-xconfigurerequest-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigurerequest_parent")
(foreign-function set-xevent-xconfigurerequest-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigurerequest_parent")
(foreign-function xevent-xconfigurerequest-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigurerequest_window")
(foreign-function set-xevent-xconfigurerequest-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigurerequest_window")
(foreign-function xevent-xconfigurerequest-x ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_x")
(foreign-function set-xevent-xconfigurerequest-x! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_x")
(foreign-function xevent-xconfigurerequest-y ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_y")
(foreign-function set-xevent-xconfigurerequest-y! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_y")
(foreign-function xevent-xconfigurerequest-width ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_width")
(foreign-function set-xevent-xconfigurerequest-width! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_width")
(foreign-function xevent-xconfigurerequest-height ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_height")
(foreign-function set-xevent-xconfigurerequest-height! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_height")
(foreign-function xevent-xconfigurerequest-border_width ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_border_width")
(foreign-function set-xevent-xconfigurerequest-border_width! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_border_width")
(foreign-function xevent-xconfigurerequest-above ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigurerequest_above")
(foreign-function set-xevent-xconfigurerequest-above! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigurerequest_above")
(foreign-function xevent-xconfigurerequest-detail ((POINTER STRUCT)) INT "get_XEvent_xconfigurerequest_detail")
(foreign-function set-xevent-xconfigurerequest-detail! ((POINTER STRUCT) INT) VOID "set_XEvent_xconfigurerequest_detail")
(foreign-function xevent-xconfigurerequest-value_mask ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xconfigurerequest_value_mask")
(foreign-function set-xevent-xconfigurerequest-value_mask! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xconfigurerequest_value_mask")
(foreign-function xevent-xcirculate-type ((POINTER STRUCT)) INT "get_XEvent_xcirculate_type")
(foreign-function set-xevent-xcirculate-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculate_type")
(foreign-function xevent-xcirculate-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculate_serial")
(foreign-function set-xevent-xcirculate-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculate_serial")
(foreign-function xevent-xcirculate-send_event ((POINTER STRUCT)) INT "get_XEvent_xcirculate_send_event")
(foreign-function set-xevent-xcirculate-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculate_send_event")
(foreign-function xevent-xcirculate-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xcirculate_display")
(foreign-function set-xevent-xcirculate-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xcirculate_display")
(foreign-function xevent-xcirculate-event ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculate_event")
(foreign-function set-xevent-xcirculate-event! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculate_event")
(foreign-function xevent-xcirculate-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculate_window")
(foreign-function set-xevent-xcirculate-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculate_window")
(foreign-function xevent-xcirculate-place ((POINTER STRUCT)) INT "get_XEvent_xcirculate_place")
(foreign-function set-xevent-xcirculate-place! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculate_place")
(foreign-function xevent-xcirculaterequest-type ((POINTER STRUCT)) INT "get_XEvent_xcirculaterequest_type")
(foreign-function set-xevent-xcirculaterequest-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculaterequest_type")
(foreign-function xevent-xcirculaterequest-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculaterequest_serial")
(foreign-function set-xevent-xcirculaterequest-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculaterequest_serial")
(foreign-function xevent-xcirculaterequest-send_event ((POINTER STRUCT)) INT "get_XEvent_xcirculaterequest_send_event")
(foreign-function set-xevent-xcirculaterequest-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculaterequest_send_event")
(foreign-function xevent-xcirculaterequest-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xcirculaterequest_display")
(foreign-function set-xevent-xcirculaterequest-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xcirculaterequest_display")
(foreign-function xevent-xcirculaterequest-parent ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculaterequest_parent")
(foreign-function set-xevent-xcirculaterequest-parent! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculaterequest_parent")
(foreign-function xevent-xcirculaterequest-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcirculaterequest_window")
(foreign-function set-xevent-xcirculaterequest-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcirculaterequest_window")
(foreign-function xevent-xcirculaterequest-place ((POINTER STRUCT)) INT "get_XEvent_xcirculaterequest_place")
(foreign-function set-xevent-xcirculaterequest-place! ((POINTER STRUCT) INT) VOID "set_XEvent_xcirculaterequest_place")
(foreign-function xevent-xproperty-type ((POINTER STRUCT)) INT "get_XEvent_xproperty_type")
(foreign-function set-xevent-xproperty-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xproperty_type")
(foreign-function xevent-xproperty-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xproperty_serial")
(foreign-function set-xevent-xproperty-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xproperty_serial")
(foreign-function xevent-xproperty-send_event ((POINTER STRUCT)) INT "get_XEvent_xproperty_send_event")
(foreign-function set-xevent-xproperty-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xproperty_send_event")
(foreign-function xevent-xproperty-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xproperty_display")
(foreign-function set-xevent-xproperty-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xproperty_display")
(foreign-function xevent-xproperty-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xproperty_window")
(foreign-function set-xevent-xproperty-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xproperty_window")
(foreign-function xevent-xproperty-atom ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xproperty_atom")
(foreign-function set-xevent-xproperty-atom! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xproperty_atom")
(foreign-function xevent-xproperty-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xproperty_time")
(foreign-function set-xevent-xproperty-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xproperty_time")
(foreign-function xevent-xproperty-state ((POINTER STRUCT)) INT "get_XEvent_xproperty_state")
(foreign-function set-xevent-xproperty-state! ((POINTER STRUCT) INT) VOID "set_XEvent_xproperty_state")
(foreign-function xevent-xselectionclear-type ((POINTER STRUCT)) INT "get_XEvent_xselectionclear_type")
(foreign-function set-xevent-xselectionclear-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xselectionclear_type")
(foreign-function xevent-xselectionclear-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionclear_serial")
(foreign-function set-xevent-xselectionclear-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionclear_serial")
(foreign-function xevent-xselectionclear-send_event ((POINTER STRUCT)) INT "get_XEvent_xselectionclear_send_event")
(foreign-function set-xevent-xselectionclear-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xselectionclear_send_event")
(foreign-function xevent-xselectionclear-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xselectionclear_display")
(foreign-function set-xevent-xselectionclear-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xselectionclear_display")
(foreign-function xevent-xselectionclear-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionclear_window")
(foreign-function set-xevent-xselectionclear-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionclear_window")
(foreign-function xevent-xselectionclear-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionclear_selection")
(foreign-function set-xevent-xselectionclear-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionclear_selection")
(foreign-function xevent-xselectionclear-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionclear_time")
(foreign-function set-xevent-xselectionclear-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionclear_time")
(foreign-function xevent-xselectionrequest-type ((POINTER STRUCT)) INT "get_XEvent_xselectionrequest_type")
(foreign-function set-xevent-xselectionrequest-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xselectionrequest_type")
(foreign-function xevent-xselectionrequest-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_serial")
(foreign-function set-xevent-xselectionrequest-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_serial")
(foreign-function xevent-xselectionrequest-send_event ((POINTER STRUCT)) INT "get_XEvent_xselectionrequest_send_event")
(foreign-function set-xevent-xselectionrequest-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xselectionrequest_send_event")
(foreign-function xevent-xselectionrequest-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xselectionrequest_display")
(foreign-function set-xevent-xselectionrequest-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xselectionrequest_display")
(foreign-function xevent-xselectionrequest-owner ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_owner")
(foreign-function set-xevent-xselectionrequest-owner! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_owner")
(foreign-function xevent-xselectionrequest-requestor ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_requestor")
(foreign-function set-xevent-xselectionrequest-requestor! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_requestor")
(foreign-function xevent-xselectionrequest-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_selection")
(foreign-function set-xevent-xselectionrequest-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_selection")
(foreign-function xevent-xselectionrequest-target ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_target")
(foreign-function set-xevent-xselectionrequest-target! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_target")
(foreign-function xevent-xselectionrequest-property ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_property")
(foreign-function set-xevent-xselectionrequest-property! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_property")
(foreign-function xevent-xselectionrequest-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselectionrequest_time")
(foreign-function set-xevent-xselectionrequest-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselectionrequest_time")
(foreign-function xevent-xselection-type ((POINTER STRUCT)) INT "get_XEvent_xselection_type")
(foreign-function set-xevent-xselection-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xselection_type")
(foreign-function xevent-xselection-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_serial")
(foreign-function set-xevent-xselection-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_serial")
(foreign-function xevent-xselection-send_event ((POINTER STRUCT)) INT "get_XEvent_xselection_send_event")
(foreign-function set-xevent-xselection-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xselection_send_event")
(foreign-function xevent-xselection-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xselection_display")
(foreign-function set-xevent-xselection-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xselection_display")
(foreign-function xevent-xselection-requestor ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_requestor")
(foreign-function set-xevent-xselection-requestor! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_requestor")
(foreign-function xevent-xselection-selection ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_selection")
(foreign-function set-xevent-xselection-selection! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_selection")
(foreign-function xevent-xselection-target ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_target")
(foreign-function set-xevent-xselection-target! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_target")
(foreign-function xevent-xselection-property ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_property")
(foreign-function set-xevent-xselection-property! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_property")
(foreign-function xevent-xselection-time ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xselection_time")
(foreign-function set-xevent-xselection-time! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xselection_time")
(foreign-function xevent-xcolormap-type ((POINTER STRUCT)) INT "get_XEvent_xcolormap_type")
(foreign-function set-xevent-xcolormap-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xcolormap_type")
(foreign-function xevent-xcolormap-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcolormap_serial")
(foreign-function set-xevent-xcolormap-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcolormap_serial")
(foreign-function xevent-xcolormap-send_event ((POINTER STRUCT)) INT "get_XEvent_xcolormap_send_event")
(foreign-function set-xevent-xcolormap-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xcolormap_send_event")
(foreign-function xevent-xcolormap-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xcolormap_display")
(foreign-function set-xevent-xcolormap-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xcolormap_display")
(foreign-function xevent-xcolormap-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcolormap_window")
(foreign-function set-xevent-xcolormap-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcolormap_window")
(foreign-function xevent-xcolormap-colormap ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xcolormap_colormap")
(foreign-function set-xevent-xcolormap-colormap! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xcolormap_colormap")
(foreign-function xevent-xcolormap-new ((POINTER STRUCT)) INT "get_XEvent_xcolormap_new")
(foreign-function set-xevent-xcolormap-new! ((POINTER STRUCT) INT) VOID "set_XEvent_xcolormap_new")
(foreign-function xevent-xcolormap-state ((POINTER STRUCT)) INT "get_XEvent_xcolormap_state")
(foreign-function set-xevent-xcolormap-state! ((POINTER STRUCT) INT) VOID "set_XEvent_xcolormap_state")
(foreign-function xevent-xclient-type ((POINTER STRUCT)) INT "get_XEvent_xclient_type")
(foreign-function set-xevent-xclient-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xclient_type")
(foreign-function xevent-xclient-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xclient_serial")
(foreign-function set-xevent-xclient-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xclient_serial")
(foreign-function xevent-xclient-send_event ((POINTER STRUCT)) INT "get_XEvent_xclient_send_event")
(foreign-function set-xevent-xclient-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xclient_send_event")
(foreign-function xevent-xclient-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xclient_display")
(foreign-function set-xevent-xclient-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xclient_display")
(foreign-function xevent-xclient-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xclient_window")
(foreign-function set-xevent-xclient-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xclient_window")
(foreign-function xevent-xclient-message_type ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xclient_message_type")
(foreign-function set-xevent-xclient-message_type! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xclient_message_type")
(foreign-function xevent-xclient-format ((POINTER STRUCT)) INT "get_XEvent_xclient_format")
(foreign-function set-xevent-xclient-format! ((POINTER STRUCT) INT) VOID "set_XEvent_xclient_format")
(foreign-function xevent-xclient-data-b ((POINTER UNION)) POINTER "get_XEvent_xclient_data_b")
(foreign-function xevent-xclient-data-s ((POINTER UNION)) POINTER "get_XEvent_xclient_data_s")
(foreign-function xevent-xclient-data-l ((POINTER UNION)) POINTER "get_XEvent_xclient_data_l")
(foreign-function xevent-xmapping-type ((POINTER STRUCT)) INT "get_XEvent_xmapping_type")
(foreign-function set-xevent-xmapping-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xmapping_type")
(foreign-function xevent-xmapping-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmapping_serial")
(foreign-function set-xevent-xmapping-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmapping_serial")
(foreign-function xevent-xmapping-send_event ((POINTER STRUCT)) INT "get_XEvent_xmapping_send_event")
(foreign-function set-xevent-xmapping-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xmapping_send_event")
(foreign-function xevent-xmapping-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xmapping_display")
(foreign-function set-xevent-xmapping-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xmapping_display")
(foreign-function xevent-xmapping-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xmapping_window")
(foreign-function set-xevent-xmapping-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xmapping_window")
(foreign-function xevent-xmapping-request ((POINTER STRUCT)) INT "get_XEvent_xmapping_request")
(foreign-function set-xevent-xmapping-request! ((POINTER STRUCT) INT) VOID "set_XEvent_xmapping_request")
(foreign-function xevent-xmapping-first_keycode ((POINTER STRUCT)) INT "get_XEvent_xmapping_first_keycode")
(foreign-function set-xevent-xmapping-first_keycode! ((POINTER STRUCT) INT) VOID "set_XEvent_xmapping_first_keycode")
(foreign-function xevent-xmapping-count ((POINTER STRUCT)) INT "get_XEvent_xmapping_count")
(foreign-function set-xevent-xmapping-count! ((POINTER STRUCT) INT) VOID "set_XEvent_xmapping_count")
(foreign-function xevent-xerror-type ((POINTER STRUCT)) INT "get_XEvent_xerror_type")
(foreign-function set-xevent-xerror-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xerror_type")
(foreign-function xevent-xerror-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xerror_display")
(foreign-function set-xevent-xerror-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xerror_display")
(foreign-function xevent-xerror-resourceid ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xerror_resourceid")
(foreign-function set-xevent-xerror-resourceid! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xerror_resourceid")
(foreign-function xevent-xerror-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xerror_serial")
(foreign-function set-xevent-xerror-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xerror_serial")
(foreign-function xevent-xerror-error_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XEvent_xerror_error_code")
(foreign-function set-xevent-xerror-error_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XEvent_xerror_error_code")
(foreign-function xevent-xerror-request_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XEvent_xerror_request_code")
(foreign-function set-xevent-xerror-request_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XEvent_xerror_request_code")
(foreign-function xevent-xerror-minor_code ((POINTER STRUCT)) UNSIGNED-CHAR "get_XEvent_xerror_minor_code")
(foreign-function set-xevent-xerror-minor_code! ((POINTER STRUCT) UNSIGNED-CHAR) VOID "set_XEvent_xerror_minor_code")
(foreign-function xevent-xkeymap-type ((POINTER STRUCT)) INT "get_XEvent_xkeymap_type")
(foreign-function set-xevent-xkeymap-type! ((POINTER STRUCT) INT) VOID "set_XEvent_xkeymap_type")
(foreign-function xevent-xkeymap-serial ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkeymap_serial")
(foreign-function set-xevent-xkeymap-serial! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkeymap_serial")
(foreign-function xevent-xkeymap-send_event ((POINTER STRUCT)) INT "get_XEvent_xkeymap_send_event")
(foreign-function set-xevent-xkeymap-send_event! ((POINTER STRUCT) INT) VOID "set_XEvent_xkeymap_send_event")
(foreign-function xevent-xkeymap-display ((POINTER STRUCT)) (POINTER STRUCT) "get_XEvent_xkeymap_display")
(foreign-function set-xevent-xkeymap-display! ((POINTER STRUCT) (POINTER STRUCT)) VOID "set_XEvent_xkeymap_display")
(foreign-function xevent-xkeymap-window ((POINTER STRUCT)) UNSIGNED-LONG "get_XEvent_xkeymap_window")
(foreign-function set-xevent-xkeymap-window! ((POINTER STRUCT) UNSIGNED-LONG) VOID "set_XEvent_xkeymap_window")
(foreign-function xevent-xkeymap-key_vector ((POINTER STRUCT)) POINTER "get_XEvent_xkeymap_key_vector")
(foreign-function xevent-pad ((POINTER UNION)) POINTER "get_XEvent_pad")
;;; UNION:XEDataObject
(foreign-function make-xedataobject () (POINTER UNION) "alloc_XEDataObject")
(foreign-function free-xedataobject ((POINTER UNION)) VOID "free_XEDataObject")
(foreign-function xedataobject-display ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_display")
(foreign-function set-xedataobject-display! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_display")
(foreign-function xedataobject-gc ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_gc")
(foreign-function set-xedataobject-gc! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_gc")
(foreign-function xedataobject-visual ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_visual")
(foreign-function set-xedataobject-visual! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_visual")
(foreign-function xedataobject-screen ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_screen")
(foreign-function set-xedataobject-screen! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_screen")
(foreign-function xedataobject-pixmap_format ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_pixmap_format")
(foreign-function set-xedataobject-pixmap_format! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_pixmap_format")
(foreign-function xedataobject-font ((POINTER UNION)) (POINTER STRUCT) "get_XEDataObject_font")
(foreign-function set-xedataobject-font! ((POINTER UNION) (POINTER STRUCT)) VOID "set_XEDataObject_font")

;; Finally provide :XLIB and 'XLIB
(provide :xlib)
(provide 'xlib)
