/* dbench_load.c */
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>

#include "trivial.h"
#include "programs.h"
#include "sysinfo.h"
#include "dbench_load.h"

static pid_t pid;

static volatile sig_atomic_t can_exit=0;

static void sig_term(int whatever gcc_unused);

int do_dbench_load(void)
{
	int cpus;
	char procs[20];
	struct sigaction sa;

	if(get_cpus(&cpus)){
		printw("no information on number of cpus, using default=1\n");
		cpus=1;
	}
	snprintf(procs, 20, "%d", cpus*16);

	sa.sa_handler=&sig_term;
	sigfillset(&sa.sa_mask);
	sa.sa_flags=SA_RESTART;
	for(;;){
		if((pid=fork())<0){
			printsys("error forking new dbench process\n");
		} else if(!pid){	/* child */
			int dev_null;
			if((dev_null=open("/dev/null", O_WRONLY))==-1){
				printsys("could not open /dev/null for writing\n");
			}
			if(dup2(dev_null, STDOUT_FILENO)==-1){
				printsys("error redirecting stdout to /dev/null\n");
			}
			if(dup2(dev_null, STDERR_FILENO)==-1){
				printsys("error redirecting stderr to /dev/null\n");
			}
			if(execlp("dbench", "dbench", procs, NULL)){
				printsys("error execing \"dbench %s\"\n", procs);
			}
		}
		/* parent */
		sigaction(SIGTERM, &sa, NULL);
		if(wait4(pid, NULL, 0, NULL)!=pid){
			printsys("error waiting for pid %d\n", pid);
		}
		if(can_exit){
			printd("exiting\n");
			exit(0);
		}
		report_progress();
		/* hmm... we could get sigterm here. oh well */
	}
	return 0;
}

static void sig_term(int whatever gcc_unused)
{
	printd("killing process %d\n", pid);
	if(kill(pid, SIGTERM)){
		printsys("could not kill pid %d\n", pid);
	}
	can_exit=1;
	exit(0);
}

int cleanup_dbench_load(void)
{
	if(system("rm -rf NBSIMULD")){
		printe("could not remove directory \"NBSIMULD\"\n");
		return 1;
	}
	return 0;
}
