/*
 * save_pud.c
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <gtk/gtk.h>
#include "save_pud.h"
#include "iolib.h"
#include "crafted.h"
#include "unit.h"
#include "tileset.h"

void save_pud(GtkFileSelection *file_selection)
{
  gchar *pud;
  FILE  *file;
  long   section_length;
  gushort  word;
  char   desc[32];
  gint   i;
  gchar  byte;
  GList *tmp_list;

  srand(time(NULL));

  if (!Pud.is_loaded)
    return;
  
  pud = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selection)));

  g_print("saving: %s\n", pud);

  file = fopen(pud, "w");
  /* Section 'Type' */
  fprintf(file, "TYPE");
  section_length = 16;
  fwrite(&section_length, sizeof(long), 1, file);
  fprintf(file, "WAR2 MAP%c%c%c%c%c%c%c%c", 0, rand()%256, rand()%256, rand()%256,
                                   rand()%256, rand()%256, rand()%256, rand()%256);
  /* Section 'Ver' */
  fprintf(file, "VER ");
  section_length = 2;
  fwrite(&section_length, sizeof(long), 1, file);
  word = 0x0011; /* XXX */
  fwrite(&word, sizeof(short), 1, file);

  /* Section 'Desc' */
  fprintf(file, "DESC");
  section_length = 32;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<32 ; i++)
    desc[i] = 0;
  strncpy(desc, Pud.description, 31);
  fwrite(desc, 1, 32, file);
  
  /* Section 'Owner' */
  fprintf(file, "OWNR");
  section_length = 16;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
    fwrite(&Pud.player[i].owner, 1, 1, file);
  
  /* Section 'Era': terrain type */
  fprintf(file, "ERA ");
  section_length = 2;
  fwrite(&section_length, sizeof(long), 1, file);
  word = Pud.terrain;
  fwrite(&word, sizeof(short), 1, file);

  /* Section 'Dim' : pud size */
  fprintf(file, "DIM ");
  section_length = 4;
  fwrite(&section_length, sizeof(long), 1, file);
  word = Pud.width;
  fwrite(&word, sizeof(short), 1, file);
  word = Pud.height;
  fwrite(&word, sizeof(short), 1, file);
  
  /* Section 'Unit Data' (optional) */
  /* FIXME */

  /* Section 'Upgrade Data' (optional) */
  /* FIXME */
  
  /* Section 'SIDE' (Race) */
  fprintf(file, "SIDE");
  section_length = 16;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
    fwrite(&Pud.player[i].side, 1, 1, file);

  /* Section 'SGLD', starting gold */
  fprintf(file, "SGLD");
  section_length = 32;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
    fwrite(&Pud.player[i].gold, 2, 1, file);

  /* Section 'SLBR', starting lumber */
  fprintf(file, "SLBR");
  section_length = 32;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
    fwrite(&Pud.player[i].wood, 2, 1, file);

  /* Section 'SOIL', starting oil */
  fprintf(file, "SOIL");
  section_length = 32;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
    fwrite(&Pud.player[i].oil, 2, 1, file);

  /* Section 'AIPL', AI for players */
  fprintf(file, "AIPL");
  section_length = 16;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i<16 ; i++)
  {
    byte = Pud.player[i].ai;
    fwrite(&byte, 1, 1, file);
  }
  
  /* Section 'MTXM', tiles map */
  fprintf(file, "MTXM");
  section_length = 2 * Pud.width * Pud.height;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i < Pud.width * Pud.height ; i++)
    fwrite(&Pud.fields[i], 2, 1, file);

  /* Section 'SQM ', movement map */
  fprintf(file, "SQM ");
  section_length = 2 * Pud.width * Pud.height;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i < Pud.width * Pud.height ; i++)
  {
    gushort tile;

    tile = Pud.fields[i];
    switch (tile >> 8)
    {
      case 0: /* plain tile */
        switch (tile >> 4)
        {
          case 1: /* light water */
          case 2: /* dark water */
            word = 0x0040;
            break;
          case 3: /* light coast */
            word = 0x0011;
            break;
          case 4: /* dark coast */
            word = 0x0011;
            break;
          case 5: /* light grass */
            word = 0x0001;
            break;
          case 6: /* dark grass */
            word = 0x0001;
            break;
          case 7: /* forest */
            word = 0x0081;
            break;
          case 8: /* rocks */
            word = 0x0081;
            break;
          case BRIDGE:
            word = 0x0091;	// land+water no building
            break;
          default:
            g_print("FIXME!!!\n");
        }
        break;
      case 1: /* dark water/light water */
        word = 0x0040; 
        break;
      case 2: /* light water/light coast */
        word = 0x0082;
        break;
      case 3: /* dark coast/light coast */
        word = 0x0011;
        break;
      case 4: /* rocks/light coast */
        word = 0x0081;
        break;
      case 5: /* light coast/light grass */
        word = 0x0011;
        break;
      case 6: /* dark grass/light grass */
        word = 0x0001;
        break;
      case 7: /* forest/light grass */
        word = 0x0081;
        break;
      case BRIDGE_LIGHT_COAST:
	word = 0x0091;	// land+water no building
	break;
      default:
        g_print("FIXME!!!\n");
    }
    fwrite(&word, 2, 1, file);
  }
  
  /* Section 'OILM', obsolete oil map */
  fprintf(file, "OILM");
  section_length = Pud.width * Pud.height;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i < Pud.width * Pud.height ; i++)
  {
    byte = 0;
    fwrite(&byte, 1, 1, file);
  }
  
  /* Section 'REGM', movement map */
  fprintf(file, "REGM");
  section_length = 2 * Pud.width * Pud.height;
  fwrite(&section_length, sizeof(long), 1, file);
  for (i=0 ; i < Pud.width * Pud.height ; i++)
  {
    gushort tile;

    tile = Pud.fields[i];
    switch (tile >> 8)
    {
      case 0: /* plain tile */
        switch (tile >> 4)
        {
          case 1: /* light water */
          case 2: /* dark water */
            word = 0x0001;
            break;
          case 3: /* light coast */
            word = 0x4006;
            break;
          case 4: /* dark coast */
            word = 0x4006;
            break;
          case 5: /* light grass */
            word = 0x4003;
            break;
          case 6: /* dark grass */
            word = 0x4003;
            break;
          case 7: /* forest */
            word = 0xFFFE;
            break;
          case 8: /* rocks */
            word = 0xFFFD;
            break;
          default:
            g_print("FIXME!!!\n");
        }
        break;
      case 1: /* dark water/light water */
        word = 0x0001; 
        break;
      case 2: /* light water/light coast */
        word = 0x4003;
        break;
      case 3: /* dark coast/light coast */
        word = 0x4003;
        break;
      case 4: /* rocks/light coast */
        word = 0xFFFD;
        break;
      case 5: /* light coast/light grass */
        word = 0x4003;
        break;
      case 6: /* dark grass/light grass */
        word = 0x0001;
        break;
      case 7: /* forest/light grass */
        word = 0xFFFE;
        break;
      default:
        g_print("FIXME!!!\n");
    }
    fwrite(&word, 2, 1, file);
  }
  /* Section 'UNIT', Units */
  fprintf(file, "UNIT");
  section_length = 8 * g_list_length(Pud.units);
  fwrite(&section_length, sizeof(long), 1, file);
  for (tmp_list = Pud.units ; tmp_list ; tmp_list = g_list_next(tmp_list))
  {
    pud_unit_t *pud_unit;

    pud_unit = tmp_list->data;
    word = pud_unit->x;
    fwrite(&word, 2, 1, file);
    word = pud_unit->y;
    fwrite(&word, 2, 1, file);
    byte = pud_unit->type;
    fwrite(&byte, 1, 1, file);
    byte = pud_unit->player_number;
    fwrite(&byte, 1, 1, file);
    word = pud_unit->value;
    fwrite(&word, 2, 1, file);
  }
  /* close the file */
  Pud.modified = FALSE;
  fclose(file);
}

