#!/usr/bin/env python
# -*- Mode: python -*-
#
# Copyright (C) 2003 Mark Ferrell <xrxgrok@yahoo.com>
#
# -----------------------------------------------------------------------
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# -----------------------------------------------------------------------

synonyms = ['ann']
summary  = """Show last changeset where each line was modified"""
usage = """Usage: cscvs annotate [-P[branch.]cset] [files...]
        -P[branch.]cset	Annotate file as of specified changeset/tag
			If the provided changeset descriptor evaluates to
			more than one changeset, only the first will be used."""

def annotate(config):
	import sys, os, getopt, string
	from RangeArgParser import RangeArgParser
	import StorageLayer
	SCM = StorageLayer.convertingImport('SCM')
	CVS = StorageLayer.convertingImport('CVS')

	catalog = SCM.Catalog.Catalog(config)
	selectedChangeset = RangeArgParser(catalog)

	opts, args = getopt.getopt(config.args, 'P:')

	for opt, val in opts:
		if opt == '-P' and selectedChangeset.parseArg(val): pass
		else: raise CVS.Usage

	try: changeset = selectedChangeset.getChangesetIterator().next()
	except StopIteration: changeset = None

	if args:
		for file in args:
			if changeset:
				rev = changeset.getLatestRevisionForFile(file)
				if rev is None: continue
				os.system("cvs annotate -r%s %s" % (rev.revision, rev.filename))
			else:
				os.system("cvs annotate %s" % file)
	else:
		if changeset:
			for rev in changeset.getAllRevisionsIterator():
				os.system("cvs annotate -r%s %s" % (rev.revision, rev.filename))
		else: os.system("cvs annotate")

	catalog.close()


if __name__ == '__main__':
	import sys, os
	sys.path.append('modules')
	import CVS
	config = CVS.Config(os.path.curdir())
	config.cmd = 'annotate'
	config.args = sys.args[1:]
	config.cat_path = os.path.join(config.topdir, "CVS/Catalog.sqlite")

	try:	annotate(config)
	except CVS.Usage:
		sys.stderr.write("%s\n" % usage)
		sys.exit(1)

# tag: Mark Ferrell Tue Jun 17 23:42:21 CDT 2003 (cmds/annotate.py)
#
