#!/usr/bin/env python
# -*- Mode: python -*-
#
# Copyright (C) 2002-2003 Mark Ferrell <xrxgrok@yahoo.com>
#
# -----------------------------------------------------------------------
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# -----------------------------------------------------------------------

import SCM.ChangeSet
import SCM.Revision

from StorageLayer import CatalogDAO

class Catalog(CatalogDAO):

	def __init__(self, revisionList = []):
		for revision in revisionList:
			## TODO: make a branch if needed?
			revision.branch.addRevision(revision)

	def append(self, changeset):
		changeset.branch.addChangeset(changeset)


if __name__ == '__main__':
	import os
	import sys
	import getopt
	import time
	import RLogParse

	verbose = RLogParse.RLogParse.OUTPUT_NORM
	reverse = 0
	lint = 0
	
	class BadUsage: pass
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'ldrvqh')

		for opt, val in opts:
			if opt == '-r':
				reverse = 1
			elif opt == '-v':
				verbose = RLogParse.RLogParse.OUTPUT_VERB
			elif opt == '-d':
				verbose = RLogParse.RLogParse.OUTPUT_DEBG
			elif opt == '-q':
				verbose = RLogParse.RLogParse.OUTPUT_NONE
			elif opt == '-l':
				lint = 1
			elif opt == '-h':
				raise BadUsage

		if args: raise BadUsage

		parser = RLogParse.RLogParse(os.popen("cvs -q log", "r"), verbose)
		revisions = parser.Revisions()
		catalog = Catalog(revisions)
		changesets = catalog.changesets()

		if lint: catalog.lint()
		elif verbose >= RLogParse.RLogParse.OUTPUT_VERB:

			if reverse: changesets.reverse()

			for changeset in changesets:
				print "==================="
				print "ChangeSet: %d" % (int(changesets.index(changeset))+1)
				print "Author: %s" % changeset.author()
				(start, end) = changeset.time()
				start = time.asctime(time.gmtime(start))
				end = time.asctime(time.gmtime(end))
				print "Date: %s => %s" % (start, end)

				if changeset.tags():
					print "Tags: %s" % changeset.tags()

				print "\nLog:\n%s" % changeset.log()

				print "\nFiles:"
				for revision in changeset.revisions():
					filename = revision.filename()
					sys.stdout.write("\t%s" % filename)
					if revision.type() == RCSRevision.Revision.REMOVE:
						print " [dead]"
					elif revision.type() != RCSRevision.Revision.ADD:
						(plus, minus) = revision.count()
						print " +%d-%d" % (plus, minus)
					else:	sys.stdout.write("\n")
				sys.stdout.write("\n")

			print "-------------------------------------------------------------------"

		if verbose >= RLogParse.RLogParse.OUTPUT_NORM:

			print "%d changesets from %d revisions" % (len(changesets), len(revisions))
			for author in catalog.authors():
				print " %d by %s " % (len(catalog.author(author)), author)
			print "elapsed time: %d seconds" % time.clock()


	except (getopt.error, BadUsage):
		print """usage %s: [-drvh]

	-r		reverse sort order
	-v		verbose output [default]
	-d		display debugging information
	-q		supress normal output
	-h		display this help
"""

# tag: Mark Ferrell Fri May 23 11:04:25 CDT 2003 (modules/SCM/Catalog.py)
