<?php
/**
 * Used to count hits on links
 *
 * daCode http://www.dacode.org/
 * src/phplib/hits.php3
 * $Id: hits.php3,v 1.30.2.4 2002/08/03 22:46:58 ruffy Exp $
 *@author Fabien Penso <penso@linuxfr.org>
 *
 * Depends: Config Db
 */

Class Hits {

	/**
	 * Db abstraction layer
	 *@var object Db
	 */
	var $db;

	/**
	 * Class constructor
	 */
	Function Hits() {
		$this->db = LoadClass('Db');
	}

	/**
	 * return number of hits 
	 * Calls echo on SQL failure
	 * Used anywhere???
	 *@param integer link ID
	 *@return mixed integer 61 on SQL failure, string "xxx hit(s)" on success
	 *@access public
	 */
	Function view($id) {
		global $config;

		$sqlc_q = "SELECT hits FROM ".$config->tables['urls_hits']." WHERE ".
			"news_urls_id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL failed: ".$this->db->error();
			return -1;
		}
		if ($this->db->num_rows()) {
			$row = $this->db->fetch_array();
		} else {
			$row['hits'] = 0;
		}
		if ($row['hits'] <= 1) {
			$out = $row['hits'] . " hit";
		} else {
			$out = $row['hits'] . " hits";
		}
		$this->db->free();

		return $out;
	}

	/**
	 * Add hits+1 or create it 
	 * Calls echo on SQL failure
	 *@param integer link ID
	 *@return mixed integer -1 on failure, void on success
	 *@access private
	 */
	Function add($id) {
		global $config;

		$sqlc_q = "SELECT hits FROM ".$config->tables['urls_hits'].
			" WHERE news_urls_id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL failed: ".$this->db->error();
			return -1;
		}

		if (!$this->db->num_rows()) {
			$sqlc_q = "INSERT INTO ".$config->tables['urls_hits'].
				" (news_urls_id,hits) VALUES".
				" ('".addslashes($id)."', '1')";
		} else {
			$sqlc_q = "UPDATE ".$config->tables['urls_hits'].
				" set hits=hits+1 WHERE ".
				"news_urls_id='".addslashes($id)."'";
		}

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL failed: ".$this->db->error();
			return -1;
		}
	}

	/**
	 * Returns a <a href="url">name</a> link with appropriate redirect 
	 *@param array 'id' => string link ID, 'url' =>string, 'name' => string label, 'hits' => integer number of hits
	 *@return string the 'a' element.
	 *@access public
	 */
	Function make($make_tempo) {
		global $config;

		$out = "<a href=\"".
				$config->basehref.
				$config->redirecthref.
				"?i=".$make_tempo['id']."\"".
				" onmouseover=\"javascript: window.status='".
				htmlentities(str_replace("'",'\'',$make_tempo['url']))."'; ".
				"return true;\" onmouseout=\"javascript: self.status=''; return ".
				"true;\">".
				$make_tempo['name']."</a> (".$make_tempo['hits']." ";
		if ($make_tempo['hits'] <= 1) {
			$out .= lecho("hit");
		} else {
			$out .= lecho("hits");
		}
		$out .= ")";

		return $out;
	}

	/**
	 * Header the url  
	 * Class header to redirect to requested URL, then exit.
	 *@param integer ID of the link.
	 *@access public
	 */
	Function header($id) {
		global $config;

		$this->add($id);
		$sqlc_q = "SELECT ".$config->tables['urls'].".url FROM ".
			$config->tables['urls'].",".$config->tables['news_urls']
			." WHERE ".$config->tables['news_urls'].".urls_id=".
			$config->tables['urls'].".id AND ".
			$config->tables['news_urls'].".id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			echo lecho("SQL command was: ").$sqlc_q;
			return -1;
		}
		$tmp = $this->db->fetch_array();
		header('Location: '.$tmp['url']);
		exit;
	}

}


?>
