\begin{code}

module AtExit ( atexit,
                with_atexit 
              ) where

import Control.Concurrent.MVar
import Control.Exception (bracket_, catch, block, unblock)
import System.IO.Unsafe (unsafePerformIO)
import System.IO (hPutStrLn, stderr)
import Prelude hiding (catch)

{-# NOINLINE atexit_actions #-}
atexit_actions :: MVar (Maybe [IO ()])
atexit_actions = unsafePerformIO (newMVar (Just []))

atexit :: IO () -> IO ()
atexit action = do
    modifyMVar_ atexit_actions $ \ml -> do
        case ml of
            Just l -> do
                return (Just (action : l))
            Nothing -> do
                hPutStrLn stderr "It's too late to use atexit"
                return Nothing

with_atexit :: IO a -> IO a
with_atexit prog = do
    bracket_
        (return ())
        exit
        prog
  where
    exit = block $ do
        Just actions <- swapMVar atexit_actions Nothing
        -- from now on atexit will not register new actions
        mapM_ runAction actions
    runAction action = do
        catch (unblock action) $ \exn -> do
            hPutStrLn stderr $ "Exception thrown by an atexit registered action:"
            hPutStrLn stderr $ show exn

\end{code}
