/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    private XStringForFSB(String string) {
        super(string);
        throw new IllegalArgumentException("XStringForFSB can not take a string for an argument!");
    }

    public XStringForFSB(FastStringBuffer fastStringBuffer, int n, int n2) {
        super(fastStringBuffer);
        this.m_start = n;
        this.m_length = n2;
        if (fastStringBuffer == null) {
            throw new IllegalArgumentException("The FastStringBuffer argument can not be null!!");
        }
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append(this.str());
    }

    public char charAt(int n) {
        return this.fsb().charAt(this.m_start + n);
    }

    public int compareTo(XMLString xMLString) {
        int n = this.m_length;
        int n2 = xMLString.length();
        int n3 = Math.min(n, n2);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n4 = this.m_start;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = fastStringBuffer.charAt(n4);
            if (c2 != (c = xMLString.charAt(n5))) {
                return c2 - c;
            }
            ++n4;
            ++n5;
        }
        return n - n2;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        int n = this.m_length;
        int n2 = xMLString.length();
        int n3 = Math.min(n, n2);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n4 = this.m_start;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2 = Character.toLowerCase(fastStringBuffer.charAt(n4));
            if (c2 != (c = Character.toLowerCase(xMLString.charAt(n5)))) {
                return c2 - c;
            }
            ++n4;
            ++n5;
        }
        return n - n2;
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        this.fsb().sendSAXComment(lexicalHandler, this.m_start, this.m_length);
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        this.fsb().sendSAXcharacters(contentHandler, this.m_start, this.m_length);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XStringForFSB) {
            return this.equals(this);
        }
        return this.equals(object.toString());
    }

    public boolean equals(String string) {
        int n = this.m_length;
        if (n == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != string.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XMLString xMLString) {
        if (this == xMLString) {
            return true;
        }
        int n = this.m_length;
        if (n == xMLString.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != xMLString.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XObject xObject) {
        if (this == xObject) {
            return true;
        }
        int n = this.m_length;
        String string = xObject.str();
        if (n == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n2 = this.m_start;
            int n3 = 0;
            while (n-- != 0) {
                if (fastStringBuffer.charAt(n2) != string.charAt(n3)) {
                    return false;
                }
                ++n2;
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        return this.m_length == string.length() ? this.str().equalsIgnoreCase(string) : false;
    }

    public XMLString fixWhiteSpace(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = this.m_length + this.m_start;
        char[] cArray = new char[this.m_length];
        FastStringBuffer fastStringBuffer = this.fsb();
        boolean bl4 = false;
        int n3 = 0;
        boolean bl5 = false;
        int n4 = this.m_start;
        while (n4 < n2) {
            n = fastStringBuffer.charAt(n4);
            if (XStringForFSB.isSpace((char)n)) {
                if (!bl5) {
                    if (n != 32) {
                        bl4 = true;
                    }
                    cArray[n3++] = 32;
                    if (bl3 && n3 != 0) {
                        char c = cArray[n3 - 1];
                        if (c != '.' && c != '!' && c != '?') {
                            bl5 = true;
                        }
                    } else {
                        bl5 = true;
                    }
                } else {
                    bl4 = true;
                    bl5 = true;
                }
            } else {
                cArray[n3++] = n;
                bl5 = false;
            }
            ++n4;
        }
        if (bl2 && n3 >= 1 && cArray[n3 - 1] == ' ') {
            bl4 = true;
            --n3;
        }
        n = 0;
        if (bl && n3 > 0 && cArray[0] == ' ') {
            bl4 = true;
            ++n;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl4 ? xMLStringFactory.newstr(cArray, n, n3 - n) : this;
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4 = n2 - n;
        if (n4 > this.m_length) {
            n4 = this.m_length;
        }
        if (n4 > cArray.length - n3) {
            n4 = cArray.length - n3;
        }
        int n5 = n + this.m_start + n4;
        int n6 = n3;
        FastStringBuffer fastStringBuffer = this.fsb();
        int n7 = n + this.m_start;
        while (n7 < n5) {
            cArray[n6++] = fastStringBuffer.charAt(n7);
            ++n7;
        }
    }

    public boolean hasString() {
        return this.m_strCache != null;
    }

    public int hashCode() {
        int n = this.m_hash;
        if (n == 0) {
            int n2 = this.m_start;
            int n3 = this.m_length;
            FastStringBuffer fastStringBuffer = this.fsb();
            int n4 = 0;
            while (n4 < n3) {
                n = 31 * n + fastStringBuffer.charAt(n2);
                ++n2;
                ++n4;
            }
            this.m_hash = n;
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3 = this.m_start + this.m_length;
        FastStringBuffer fastStringBuffer = this.fsb();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.m_length) {
            return -1;
        }
        int n4 = this.m_start + n2;
        while (n4 < n3) {
            if (fastStringBuffer.charAt(n4) == n) {
                return n4 - this.m_start;
            }
            ++n4;
        }
        return -1;
    }

    private static boolean isSpace(char c) {
        return XMLCharacterRecognizer.isWhiteSpace(c);
    }

    public int length() {
        return this.m_length;
    }

    public Object object() {
        return this.str();
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString var1_1, int var2_2) {
        var3_3 = this.fsb();
        var4_4 = this.m_start + var2_2;
        var5_5 = this.m_start + this.m_length;
        var6_6 = 0;
        var7_7 = var1_1.length();
        if (var2_2 >= 0 && var2_2 <= this.m_length - var7_7) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (var3_3.charAt(var4_4) != var1_1.charAt(var6_6)) {
                return false;
            }
            ++var4_4;
            ++var6_6;
lbl12:
            // 2 sources

            ** while (--var7_7 >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    public String str() {
        if (this.m_strCache == null) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    public XMLString substring(int n) {
        int n2 = this.m_length - n;
        if (n2 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n3 = this.m_start + n;
        return new XStringForFSB(this.fsb(), n3, n2);
    }

    public XMLString substring(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > this.m_length) {
            n3 = this.m_length;
        }
        if (n3 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n4 = this.m_start + n;
        return new XStringForFSB(this.fsb(), n4, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int n = this.m_start;
        int n2 = this.m_length + n;
        if (n2 == 0) {
            return Double.NaN;
        }
        double d = 0.0;
        int n3 = n2 - 1;
        FastStringBuffer fastStringBuffer = this.fsb();
        int n4 = n;
        while (n4 < n2) {
            char c = fastStringBuffer.charAt(n4);
            if (!XMLCharacterRecognizer.isWhiteSpace(c)) break;
            ++n;
            ++n4;
        }
        double d2 = 1.0;
        if (n < n2 && fastStringBuffer.charAt(n) == '-') {
            d2 = -1.0;
            ++n;
        }
        int n5 = 0;
        int n6 = n;
        while (n6 < n2) {
            char c = fastStringBuffer.charAt(n6);
            if (c != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c)) break;
                if (!Character.isDigit(c)) return Double.NaN;
                d = d * 10.0 + (double)(c - 48);
                ++n5;
            } else {
                n3 = n6;
                break;
            }
            ++n6;
        }
        if (fastStringBuffer.charAt(n3) == '.') {
            double d3 = 0.0;
            int n7 = n2 - 1;
            while (n7 > n3) {
                char c = fastStringBuffer.charAt(n7);
                if (!XMLCharacterRecognizer.isWhiteSpace(c)) {
                    if (!Character.isDigit(c)) return Double.NaN;
                    d3 = d3 / 10.0 + (double)(c - 48);
                    ++n5;
                }
                --n7;
            }
            d += d3 / 10.0;
        }
        if (n5 != 0) return d * d2;
        return Double.NaN;
    }

    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }
}

