/*
 * datefudge.c: Twist system date back N seconds
 *
 * Copyright (C) 2001-2003, Matthias Urlichs <smurf@noris.de>
 */
#define _GNU_SOURCE

#include <sys/file.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <assert.h>
#include <asm/unistd.h>
#include <features.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>

#define _NAME(foo) #foo
#define NAME(foo) _NAME(foo)

#if 0
#define N_open "open"
#else
#if __GLIBC_MINOR__ >= 1
#define N_open NAME(__libc_open)
#else
#define N_open NAME(__open)
#endif
#endif

int fudge = 0;

static void
init_fudge (void)
{
	const char *fud;

	if(fudge)return;

	fud = getenv("DATEFUDGE");
	if(fud == NULL) return;
	fudge = atoi(fud);
}

/*
 * This won't work...
 *
text_set_element (__libc_subinit, init_logger);
 */

time_t time(time_t *x) {
	static time_t (*libc_time)(time_t *) = NULL;
	time_t res;

	init_fudge();
	if(!libc_time)
		libc_time = (typeof(libc_time))dlsym (RTLD_NEXT, NAME(time));
	res = (*libc_time)(x);
	if(x) *x -= fudge;
	res -= fudge;
	return res;
}

int __gettimeofday(struct timeval *x, struct timezone *y) {
	static time_t (*libc_gettimeofday)(struct timeval *, struct timezone *) = NULL;
	int res;

	init_fudge();
	if(!libc_gettimeofday)
		libc_gettimeofday = (typeof(libc_gettimeofday))dlsym (RTLD_NEXT, NAME(__gettimeofday));
	res = (*libc_gettimeofday)(x,y);
	if(res) return res;
	x->tv_sec -= fudge;
	return 0;
}
int gettimeofday(struct timeval *x, struct timezone *y)
	{ return __gettimeofday(x,y); }

