#include "DBSignalHandler.hh"
#include "DBBalancerDaemon.hh"


DBSignalHandler::DBSignalHandler(DBBalancerDaemon *d) {
  ACE_DEBUG((LM_DEBUG,"(%t,%T) DBSignalHandler registering signals.\n"));;
  // Autoregister into the Reactor.
  ACE_Reactor::instance()->register_handler(SIGWINCH,this);
  ACE_Reactor::instance()->register_handler(SIGTERM,this);
  ACE_Reactor::instance()->register_handler(SIGHUP,this);
  ACE_Reactor::instance()->register_handler(SIGINT,this);
  ACE_Reactor::instance()->register_handler(SIGPIPE,this);

  _daemon = d;
  _processed = false;
  
}

int DBSignalHandler::handle_exit(ACE_Process *p) {

  ACE_DEBUG((LM_DEBUG,"(%t,%T) Received END OF PROCESS \n"));
  return 0;

}

int DBSignalHandler::handle_signal(int signum, siginfo_t*,ucontext_t*) {

  //ACE_DEBUG((LM_DEBUG,"(%t,%T) Received signal %d\n",signum));

  _mutex.acquire();

  if (!_processed) {

    ACE_DEBUG((LM_DEBUG,"(%t,%T) Thread %t won the signal %d race.\n",signum));    
    _processed = true;
    _mutex.release();

    switch(signum){
    case SIGWINCH:
      ACE_DEBUG((LM_NOTICE, "Received SIGWINCH \n"));
      break;
    case SIGPIPE:
      ACE_DEBUG((LM_NOTICE, "Received SIGPIPE \n"));
      break;
    case SIGHUP:
      ACE_DEBUG((LM_NOTICE, "Received SIGHUP \n"));
      break;
    case SIGTERM:
      ACE_DEBUG((LM_NOTICE, "(%t,%T) SIGTERM: Notifying DBBalancerDaemon to close. \n"));
      _daemon->shutdown(0);
      break;
    case SIGINT:
      ACE_DEBUG((LM_NOTICE, "(%t,%T) SIGINT: Notifying DBBalancerDaemon to close. \n"));
      _daemon->shutdown(0);
      break;
    default:
      ACE_DEBUG((LM_ERROR, "(%t,%T) Received unhandled signal: %d\n",signum));
    }
    return 0;

  } else {

    ACE_DEBUG((LM_DEBUG,"(%t,%T) Thread %t lost the signal %d race.\n",signum));
    _mutex.release();

  }

}


