# Which are the ports of the backends.
# "localhost" is assumed as hostname. If you want to change this, you should have to change the end of this script 
# (search "localhost" and modify and recompile if needed the TESTER programs 
STANDALONE_DB_PORT=5432
STANDALONE_DB_PORT2=5433

# Where is DBBalancer listening
DBBALANCER_PORT=6666
DBBALANCER_WRITER_PORT=6667

# Number of requests for test and tester program.
# There are C, C++ and TCL versions.
NUMBER_OF_REQUESTS=1000
#TESTER=../postgres_cc/pgtest_cc
#TESTER=../cliente/pg_cliente.tcl  
TESTER=../postgres/pgtest


echo 
echo "----------------------------------------------------------"
echo "DBBalancer test script. Version 0.2.3"
echo "----------------------------------------------------------"
echo 
echo "For this script to work, you should have:"
echo " a) Created the db's in every host included in the pool (pgsql/create_db.sh)"
echo " b) Modified the variables on top of this script to point to your real config"
echo " c) Modified the \$TESTER script or program to also point to your real config"
echo " d) Configured and started your backend databases and DBBalancerDaemon processes"
echo

echo "----------------------------------------------------------"

sleep 2
echo -n "Checking reader process ......"
READER=`netstat -na | grep LISTEN | grep $DBBALANCER_PORT`

if [ -z "$READER" ]
then
	echo "WARNING: It doesn't seem that there's anybody listening at port $DBBALANCER_PORT"
	echo "		We'll interpret that there's no Reader process running and will skip Pooling and Load Balancing tests"
	
else 

	echo "OK!"
	echo
	echo "----------------------------------------------------------"
	echo "1. One concurrent user test".
	echo "----------------------------------------------------------"
	echo
	echo "----------------------------------------------------------"
	echo " 1.1 Direct to Postgres ($STANDALONE_DB_PORT)".
	echo

	$TESTER $NUMBER_OF_REQUESTS $STANDALONE_DB_PORT

	echo
	echo "----------------------------------------------------------"
	echo " 1.2 Thru DBBalancer ($DBBALANCER_PORT)"
	echo

	$TESTER $NUMBER_OF_REQUESTS $DBBALANCER_PORT

	echo "----------------------------------------------------------"
	echo "2. Five concurrent user test".
	echo "----------------------------------------------------------"
	echo
	echo "----------------------------------------------------------"
	echo " 2.1 Direct to Postgres ($STANDALONE_DB_PORT). You'll have to aggregate the results.".
	echo
	echo "**** Press ENTER when you see all the results to resume with next test"
	sleep 2
	./launch_a_lot.sh 5 "$TESTER $NUMBER_OF_REQUESTS $STANDALONE_DB_PORT"
	read

	echo
	echo "----------------------------------------------------------"
	echo " 2.2 Thru DBBalancer ($DBBALANCER_PORT). You'll have to aggregate the results."
	echo	
	echo "**** Press ENTER when you see all the results to resume with next test"	
	sleep 2
	./launch_a_lot.sh 5 "$TESTER $NUMBER_OF_REQUESTS $DBBALANCER_PORT"
	read	

fi

echo -n "Checking writer process ......"
WRITER=`netstat -na | grep LISTEN | grep $DBBALANCER_WRITER_PORT`

if [ -z "$WRITER" ]
then
	echo "WARNING: It doesn't seem that there's anybody listening at port $DBBALANCER_WRITER_PORT"
	echo "		We'll interpret that there's no Writer process running and will skip replication tests"
	

else

	echo "OK!"
	echo
	echo "----------------------------------------------------------"
	echo "3. Write replication test. A DBBalancerDaemon, configured with '-w' flag, should be running at port $DBBALANCER_WRITER_PORT"
	echo "----------------------------------------------------------"
	echo
	echo "----------------------------------------------------------"
	echo " 3.1 Do replicated writes "
	$TESTER 1 6667 "delete from tb_three"
	$TESTER 100 6667 "insert into tb_three values ('Shelovesyou','yeayeayea')"


	echo
	echo "----------------------------------------------------------"
	echo " 3.2 Test that the data has been correctly replicated "
	echo
	./test_sync.tcl dbbalancer tb_three "localhost 5432" "localhost 5433"

fi





echo
echo "END of the test script !!!"
echo

