/* Distributed Checksum Clearinghouse
 *
 * kludge replacement for getifaddrs(3) for systems that lack it
 *
 * Copyright (c) 2005 by Rhyolite Software
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND RHYOLITE SOFTWARE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL RHYOLITE SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * Rhyolite Software DCC 1.2.74-1.8 $Revision$
 */


#ifndef DCC_IFADDRS_H
#define DCC_IFADDRS_H

#include <net/if.h>

#ifndef USE_DCC_GETIFADDRS
#include <ifaddrs.h>

#else
#define HAVE_GETIFADDRS
#define HAVE_FREEIFADDRS

struct ifaddrs {
    struct ifaddrs  *ifa_next;
    char	    *ifa_name;
    u_int	    ifa_flags;
    struct sockaddr *ifa_addr;
};

struct ifaddrs_all {
    struct ifaddrs  ifa;
    DCC_SOCKU	    addr;
    char	    name[IFNAMSIZ];
};

#define getifaddrs(pif) dcc_getifaddrs(pif)
extern int dcc_getifaddrs(struct ifaddrs **);
#define freeifaddrs(p) dcc_free(p)

#endif /* USE_DCC_GETIFADDRS */
#endif /* DCC_IFADDRS_H */
