/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * gtk_helper.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: gtk_helper.c,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <gnome.h>

#include "main.h"
#include "gtk_helper.h"
#include "misc_gtk.h"

/* ========================================================================================== */
/* set/get gtk label by widget */

/***********************************************************************/
/* set a string in the given GtkLabel                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_label(GtkLabel *lbl, const char *string)
{
	if(utf8_mode==TRUE)
	{
		gtk_label_set(lbl,string);
	}
	else
	{
		gchar *utf8;

		utf8=g_locale_to_utf8(string,-1,NULL,NULL,NULL);
		gtk_label_set(lbl,utf8);
		g_free(utf8);
	}
}

/***********************************************************************/
/* get the string from the given GtkLabel                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_label(GtkLabel *lbl)
{
	const char *txt;

	txt=gtk_label_get_text(lbl);
	if(txt==NULL)
		return NULL;

	if(utf8_mode==TRUE)
	{
		return g_strdup(txt);
	}
	else
	{
		return g_locale_from_utf8(txt,-1,NULL,NULL,NULL);
	}
}

/* ========================================================================================== */
/* set/get gtk entry by widget */

/***********************************************************************/
/* set a string in the given GtkEntry                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_entry(GtkEntry *lbl, const char *string)
{
	if(utf8_mode==TRUE)
	{
		gtk_entry_set_text(lbl,string);
	}
	else
	{
		gchar *utf8;

		utf8=g_locale_to_utf8(string,-1,NULL,NULL,NULL);
		gtk_entry_set_text(lbl,utf8);
		g_free(utf8);
	}
}

/***********************************************************************/
/* get the string from the given GtkEntry                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_entry(GtkEntry *lbl)
{
	const char *txt;

	txt=gtk_entry_get_text(lbl);
	if(txt==NULL)
		return NULL;

	if(utf8_mode==TRUE)
	{
		return g_strdup(txt);
	}
	else
	{
		return g_locale_from_utf8(txt,-1,NULL,NULL,NULL);
	}
}

/* ========================================================================================== */
/* set/get gtk label by name */

/***********************************************************************/
/* set a string in the given GtkLabel                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_label_by_name(GtkWidget *root_window,const char *label_name, const char *string)
{
	GtkLabel *lbl=GTK_LABEL(get_widget_by_widget_name(root_window,label_name));

	if(utf8_mode==TRUE)
	{
		gtk_label_set(lbl,string);
	}
	else
	{
		gchar *utf8;

		utf8=g_locale_to_utf8(string,-1,NULL,NULL,NULL);
		gtk_label_set(lbl,utf8);
		g_free(utf8);
	}
}

/***********************************************************************/
/* get the string from the given GtkLabel                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_label_by_name(GtkWidget *root_window,const char *label_name)
{
	const char *txt;
	GtkLabel *lbl=GTK_LABEL(get_widget_by_widget_name(root_window,label_name));

	txt=gtk_label_get_text(lbl);
	if(txt==NULL)
		return NULL;

	if(utf8_mode==TRUE)
	{
		return g_strdup(txt);
	}
	else
	{
		return g_locale_from_utf8(txt,-1,NULL,NULL,NULL);
	}
}

/* ========================================================================================== */
/* set/get gtk entry by name */

/***********************************************************************/
/* set a string in the given GtkEntry                                  */
/* the function performs locale to UTF8 conversion if utf8_mode is set */
/***********************************************************************/
void set_gtk_entry_by_name(GtkWidget *root_window,const char *label_name, const char *string)
{
	GtkEntry *lbl=GTK_ENTRY(get_widget_by_widget_name(root_window,label_name));

	if(utf8_mode==TRUE)
	{
		gtk_entry_set_text(lbl,string);
	}
	else
	{
		gchar *utf8;

		utf8=g_locale_to_utf8(string,-1,NULL,NULL,NULL);
		gtk_entry_set_text(lbl,utf8);
		g_free(utf8);
	}
}

/***********************************************************************/
/* get the string from the given GtkEntry                              */
/* the function performs UTF8 to locale conversion if utf8_mode is set */
/* output: a copy of the string (must be free)                         */
/***********************************************************************/
gchar *get_gtk_entry_by_name(GtkWidget *root_window,const char *label_name)
{
	const char *txt;
	GtkEntry *lbl=GTK_ENTRY(get_widget_by_widget_name(root_window,label_name));

	txt=gtk_entry_get_text(lbl);
	if(txt==NULL)
		return NULL;

	if(utf8_mode==TRUE)
	{
		return g_strdup(txt);
	}
	else
	{
		return g_locale_from_utf8(txt,-1,NULL,NULL,NULL);
	}
}

/***************************************************************************************************************/
/* automatically scroll the textview at the bottom but only if the user has not changed its automatic position */
/***************************************************************************************************************/
/* gtv is the GTK_TEXT_VIEW extracted from base_widget. base_widget is a GtkTextView, it is needed to */
/* access to its parent (the GtkScrolledWindow)                                                       */
/******************************************************************************************************/
void auto_scroll_view(GtkTextView *gtv, GtkTextBuffer *gtb, GtkWidget *base_widget)
{
	GtkAdjustment *adj=gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(base_widget->parent));

	if( ((adj->lower==0)&&(adj->upper==adj->page_size)&&(adj->value==0))  ||		/* we are at the top position */
		 (adj->upper==(adj->value+adj->page_size)) )											/* we are at the bottom position */
	{
		/* keep the window at the bottom place, we must use a mark, an iter does not work here */
		gtk_text_view_scroll_to_mark(gtv,gtk_text_buffer_get_mark(gtb,"end"),0,TRUE,0,1.0);
	}
}

