<?php
/*
 * $Id: class.htmlAttributesets.inc.php,v 1.2.2.1.2.2 2003/11/11 05:50:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('attr');

class htmlAttributesets
{
	function createCombo($default = 0, $cbName = 'setid', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		print $this->GetCombo($default, $cbName, $longShort, $size, $activeOnly);
	}

	function GetCombo($default = 0, $cbName = 'setid', $longShort = 'name', $size = 0, $activeOnly = true)
	{
		$obj = CreateObject('dcl.dbAttributesets');
		$obj->Connect();
		$obj->cacheEnabled = false;

		$query = 'SELECT id,name FROM attributesets ';

		if ($activeOnly)
			$query .= 'WHERE active=\'Y\' ';

		$query .= "ORDER BY $longShort";
		$obj->Query($query);

		$str = "<select name=\"$cbName";
		if ($size > 0)
			$str .= '[]" multiple size="' . $size;

		$str .= '">';
		if ($size == 0)
			$str .= sprintf('<option value="0">%s</option>', STR_ATTR_SELECTONE);

		while ($obj->next_record())
		{
			$id = $obj->f(0);
			$text = $obj->f(1);
			$str .= '<option value="'. $id . '"';
			if ($id == $default)
				$str .= ' selected';
			$str .= '>' . $text . '</option>';
		}

		$str .= '</select>';

		return $str;
	}

	function PrintAll($orderBy = 'name')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$objDBStatus = CreateObject('dcl.dbAttributesets');
		$objDBStatus->Connect();

		$objDBStatus->Query("SELECT id,active,short,name FROM attributesets ORDER BY $orderBy");
		$allRecs = $objDBStatus->FetchAllRows();

		$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boAttributesets.add') . '">' . STR_ATTR_NEW . '</a>';
		$titleLink .= '&nbsp;|&nbsp;';
		$titleLink .= '<a class="adark" href="' . menuLink('', 'menuAction=boAdmin.ShowSystemConfig') . '">' . DCL_MENU_SYSTEMSETUP . '</a>';

		if (count($allRecs) > 0)
		{
			$allName = array(
					0 => STR_ATTR_ID, 
					1 => STR_ATTR_ACTIVE, 
					2 => STR_ATTR_SHORT, 
					3 => STR_ATTR_NAME);

			if (count($allRecs) > 0 && $GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			{
				$allName[] = 'Options';
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boAttributesets.view&id=' . $allRecs[$i][0]) . '">' . STR_ATTR_MAP . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAttributesets.modify&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
					$options .= '&nbsp;|&nbsp;';
					$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boAttributesets.delete&id=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					$allRecs[$i][] = $options;
				}
			}
			PrintArrayAsChocoTable($allName, $allRecs, STR_ATTR_ATTRIBUTESETS, '', $titleLink);
		}
		else
		{
			print('<CENTER>');
			PrintWithChocoFont(STR_ATTR_NOATTRIBUTESETS);
			print('</CENTER>');
		}
	}

	function ShowEntryForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlAttributesetsForm.tpl'));

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', STR_ATTR_EDITATTRIBUTESET);
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$Template->set_var('VAL_SHORT', $obj->short);
			$Template->set_var('VAL_NAME', $obj->name);
			$hiddenvars = '<input type="hidden" name="menuAction" value="boAttributesets.dbmodify">' .
				'<input type="hidden" name="id" value="' . $GLOBALS['id'] . '">';
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_ATTR_ADDATTRIBUTESET);
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('VAL_SHORT', '');
			$Template->set_var('VAL_NAME', '');
			$hiddenvars = '<input type="hidden" name="menuAction" value="boAttributesets.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_ACTIVE', STR_ATTR_ACTIVE);
		$Template->set_var('TXT_SHORT', STR_ATTR_SHORT);
		$Template->set_var('TXT_NAME', STR_ATTR_NAME);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_ATTR_HIGHLIGHTEDNOTE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=boAttributesets.showall'));

		$Template->pparse('out', 'hForm');
	}
}
?>
