%define version 0.85.9
%define rh_release %(rh_release="`rpm -q --queryformat='%{VERSION}' redhat-release | grep -v install 2>/dev/null`" ; if test $? != 0 ; then rh_release="0" ; fi ; echo "$rh_release")
%define fdr_release %(fdr_release="`rpm -q --queryformat='%{VERSION}' fedora-release | grep -v install 2>/dev/null`" ; if test $? != 0 ; then fdr_release="0" ; fi ; echo "$fdr_release")

Name: dctc
Summary: DCTC is a Direct Connect clone.
Version: %{version}
Release: 1
License: GPL
Group: Applications/Internet
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/build-root-%{name}
Packager: Eric <eric@a2pb.gotdns.org>
Provides: dctc
Prefix: /usr
Url: http://ac2i.homelinux.com/dctc/

BuildRequires: openssl-devel, automake >= 1.7, zlib-devel >= 1.1
Requires(post,preun): chkconfig
Requires: openssl >= 0.9.6b, zlib >= 1.1

%if %{rh_release}
	%if "%{os_major_version}" >= "8"
BuildRequires: glibc-devel >= 2.3.2, libglib2-devel >= 2.0, libdb-devel >= 3.3
Requires: glibc >= 2.3.2, libglib2 >= 2.0
	%else
BuildRequires: glibc-devel >= 2.2, libglib2-devel >= 2.0, libdb-devel >= 3.3
Requires: glibc >= 2.2, libglib2 >= 2.0
	%endif
%else
	%if %{fdr_release}
BuildRequires: glibc-devel >= 2.3.2, glib-devel >= 2.0, db4-devel >= 3.3
Requires: glibc >= 2.3.2, glib >= 2.0
	%else
BuildRequires: glibc-devel >= 2.2, libglib2-devel >= 2.0, libdb-devel >= 3.3
Requires: glibc >= 2.2, libglib2 >= 2.0
	%endif
%endif

%description
DCTC is a clone of Direct Connect, a Windows client allowing users to share their files and talk (like IRC but more software sharing oriented) using a proprietary protocol.

%prep
rm -rf $RPM_BUILD_ROOT 
mkdir $RPM_BUILD_ROOT

%setup -q

%build
export CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"
%configure --prefix=%{prefix}
make -j 2

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir} install-strip

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root,0755)
%doc NEWS README AUTHORS ChangeLog TODO
%{_mandir}/*/*
%{_bindir}/*

