/*  Higlight code	
*  Copyright (C) 1999 by:
*Mikael Hermansson <mikeh@bahnhof.se>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef HIGLIGHT_H__
#define HIGLIGHT_H__
#ifdef __cplusplus
extern "C" {
#endif

#define GTK_TYPE_EXTEXT_HIGHLIGHT                  (gtk_extext_highlight_get_type ())
#define GTK_EXTEXT_HIGHLIGHT(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_EXTEXT_HIGHLIGHT, GtkExTextHighlight))
#define GTK_EXTEXT_HIGHLIGHT_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_EXTEXT_HIGHLIGHT, GtkExTextHighlightClass))
#define GTK_IS_EXTEXT_HIGHLIGHT(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_EXTEXT_HIGHLIGHT))
#define GTK_IS_EXTEXT_HIGHLIGHT_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_EXTEXT_HIGHLIGHT))

#define IS_SYNTAX_TABLE_ENTRIES(l) 
#define SYNTAX_TABLE 1
#define PATTERN_TABLE 2

#ifdef _NETBSD
	#include "gnu-regex.h"
#endif
#ifdef _FREEBSD
	#include <gnuregex.h>
#endif
#ifdef _LINUX
	#include <regex.h>
#endif

#include "gtkextext.h"
typedef struct _GtkExTextHighlightSyntaxEntry
{
  gchar *start;

  Regex regex_start;
  Regex regex_end;

  gchar key[32];
  GdkFont *font;
  GdkColor *bg_color;
  GdkColor *fg_color;
    

} GtkExTextHighlightSyntaxEntry;

typedef struct _GtkExTextHighlightPatternEntry
{
  Regex regex;

  gchar key[32];
  GdkFont *font;
  GdkColor *bg_color;
  GdkColor *fg_color;

  gint ref_count;
} GtkExTextHighlightPatternEntry;


typedef struct _GtkExTextHighlightTable
{
  gint16 type;

  GList *entries; 

  Regex regex_all;
  
} GtkExTextHighlightTable;

typedef struct _GtkExTextHighlight
{
  GtkExText ExText;
  gint highlight :1;
  gint check_brackets :1;

  GtkExTextHighlightTable *syntax_table;
  GtkExTextHighlightTable *pattern_table;
  
} GtkExTextHighlight;

typedef struct _GtkExTextHighlightClass
{
  GtkExTextClass parent_class;

} GtkExTextHighlightClass;

GtkWidget* gtk_extext_highlight_new();

GtkExTextHighlightTable *gtk_extext_highlight_syntax_table_new(GList *list);
GtkExTextHighlightTable *gtk_extext_highlight_pattern_table_new(GList *list);

/* free up the table AND the members */
void gtk_extext_highlight_table_free(GtkExTextHighlightTable *table);

GList *gtk_extext_highlight_syntax_entry_new(GList *entries,gchar *name,gchar *start,gchar *end,GdkFont *f,GdkColor *fg,GdkColor*bg);
GList *gtk_extext_highlight_pattern_entry_new(GList *entries,gchar *name,gchar *start,GdkFont *f,GdkColor *fg, GdkColor*bg);

/* pass created tables to widget */

void gtk_extext_highlight_install_table(GtkExTextHighlight *text,GtkExTextHighlightTable *table);
void gtk_extext_highlight_set_check_brackets(GtkExTextHighlight *text,gboolean check);
void gtk_extext_highlight_set(GtkExTextHighlight *text,gboolean set);
gboolean gtk_extext_highlight_compile_regex (const gchar *pattern, Regex *regex);

GtkType gtk_extext_highlight_get_type(void);

#ifdef __cplusplus
}
#endif
#endif 