/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void gla_ejecutar(void)
{
	gchar *comando;
	gchar *glade_interface_file;
	gchar *glade_project_file;
	gchar *glade_file;
	gchar *tmp;
	FILE *archivo;
	gchar *nombre,*nombre_completo;
	GtkTreeIter nodo_arbol;
	gboolean guardar_proyecto;
	xmlDocPtr doc;
	xmlNodePtr nodo_project, nodo_children;
	gint retorno;
	gchar *libs;
	
	guardar_proyecto=FALSE;
	libs=pro_librerias_lincado();
	glade_interface_file=pro_glade_file(UTF8);
	glade_project_file = g_strconcat (glade_interface_file, "p", NULL);
	if (glade_interface_file!=NULL) {
		edit_guardar_todo();
		tmp=pro_nombre_completo_archivo(glade_interface_file,TRUE, LOCALE);
		archivo=fopen(tmp,"r");
		if (archivo==NULL) {
			gla_crear(glade_interface_file);
		} else {
			fclose(archivo);
		}
		g_free(tmp);
		tmp = pro_nombre_completo_archivo(glade_interface_file, TRUE, LOCALE);
		comando=g_strdup_printf("glade-2 %s\n",tmp);
		gen_comando(comando,NULL);
		g_free(tmp);
		g_free(comando);
		nombre=pro_nombre_completo_archivo("main.c",FALSE, UTF8);
		if (gen_existe_fichero(nombre)) {
			if (!pro_existe_archivo("main.c")) {
				arch_anadir("main.c",&nodo_arbol);
				edit_anadir(nombre,&nodo_arbol);
				pro_anadir("main.c");
				guardar_proyecto=TRUE;
			}
		}
		g_free(nombre);
		tmp=pro_nombre_completo_archivo(glade_project_file,TRUE, LOCALE);
		doc=xmlParseFile(glade_project_file);
		g_free(tmp);
		nodo_project=doc->xmlChildrenNode;
		//We look for the "glade-project" named ELEMENT node, not DTD node.
		while (nodo_project != NULL) {
			if (!strcmp(nodo_project->name,"glade-project")) {
				if (nodo_project->type == XML_ELEMENT_NODE)	
					break;
			}
			nodo_project = nodo_project->next;
		}
		if (nodo_project != NULL) {
			//interface source file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"main_source_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("interface.c");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}

			//interface header file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"main_header_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("interface.h");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}
			
			//callback source file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"handler_source_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("callbacks.c");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}

			//callback header file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"handler_header_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("callbacks.h");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}

			//support source file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"support_source_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("support.c");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}

			//support header file
			nodo_children = nodo_project->xmlChildrenNode;
			if ((libs[LLIBGLADE2]=='0') && (nodo_children != NULL)) {
				nombre=NULL;
				do {
					if (!strcmp(nodo_children->name,"support_header_file")) {
						nombre=xmlNodeGetContent(nodo_children);
					}
					nodo_children=nodo_children->next;
				} while (nodo_children!=NULL);
				if (nombre!=NULL) {
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				} else {
					nombre=g_strdup("support.h");
					nombre_completo=pro_nombre_completo_archivo(nombre,FALSE, UTF8);
				}
				if (gen_existe_fichero(nombre_completo)) {
					if (pro_existe_archivo(nombre)) {
						edit_recargar_archivo(nombre);
					} else {
						arch_anadir(nombre,&nodo_arbol);
						edit_anadir(nombre_completo,&nodo_arbol);
						pro_anadir(nombre);
						guardar_proyecto=TRUE;
					}
				}
				g_free(nombre);
				g_free(nombre_completo);
			}
		} //end if nodo_project != NULL
		xmlFreeDoc(doc);
		if (guardar_proyecto) {
			pro_guardar();

		}
		//At last, rebuild the GUI TreeView and rebuild the glade_window_list
		//with the new info.
		gla_free_glade_window_list();
		glade_window_list = NULL;
		glade_file = pro_nombre_completo_archivo(glade_interface_file, FALSE, UTF8);
		retorno = gla_create_glade_window_list(glade_file);
		if (retorno == 0)
			gla_gui_treeview_populate();
		g_free(glade_file);
		glade_widget_list = NULL;
		glade_widget_list_last_widget = NULL;
		glade_file = pro_nombre_completo_archivo(glade_interface_file, FALSE, LOCALE);
		gla_parse_glade_project_file (glade_file);
		g_free(glade_file);
	} else {
		gen_ventana_mensaje(_( "You have not loaded a Project file or you must activate the Glade project file checkbox in the Project Properties menu."),
			GTK_MESSAGE_ERROR);
	}
	g_free(glade_interface_file);
	g_free(glade_project_file);
	g_free(libs);
}

//"nombre" must be passed in UTF8 encoding
void gla_crear(gchar *nombre)
{
	xmlDocPtr doc;
	xmlNodePtr nodo;
	gchar *proyecto;
	gchar *pixdir;
	gchar *srcdir;
	gchar *libs;
	gchar *lenguaje;
	gchar *ejecutable;
	gchar *nombrep;
	gchar *nombre_locale;
	gchar *strings_file;
	gsize read, written;
	GError *error;
	
	DEBUG_MSG(creando archivo para el glade);
	ejecutable=pro_ejecutable(UTF8);
	lenguaje=pro_lenguaje();
	libs=pro_librerias_lincado();
	proyecto=pro_nombre(UTF8);
	pixdir=pro_pixdir(UTF8);
	srcdir=pro_srcdir(UTF8);
	//the glade interface file
	doc=xmlNewDoc("1.0");
	nodo=xmlNewNode(NULL,"glade-interface");
	doc->xmlRootNode=nodo;
	nombre_locale = g_locale_from_utf8(nombre, -1, &read, &written, &error);
	xmlSaveFile(nombre_locale,doc);
	g_free(nombre_locale);
	xmlFreeDoc(doc);
	//the glade project file
	nombrep = g_strconcat(nombre, "p", NULL);
	doc=xmlNewDoc("1.0");
	nodo=xmlNewNode(NULL,"glade-interface");
	doc->xmlRootNode=nodo;
	xmlNewChild(nodo,NULL,"name",proyecto);
	xmlNewChild(nodo,NULL,"program_name",ejecutable);
	if (libs[LGNOME2]!='1') {
		xmlNewChild(nodo,NULL,"gnome_support","FALSE");
	}
	xmlNewChild(nodo,NULL,"source_directory",srcdir);
	xmlNewChild(nodo,NULL,"pixmaps_directory",pixdir);
	xmlNewChild(nodo,NULL,"output_build_files","FALSE");
	if (libs[LGETTEXT]!='1') {
		xmlNewChild(nodo,NULL,"gettext_support","FALSE");
	}
	if ((libs[LLIBGLADE2]=='1') && (libs[LGETTEXT]=='1')) {
		strings_file=g_strdup_printf("%s/translatable_strings_file.c",srcdir);
		xmlNewChild(nodo,NULL,"output_translatable_strings","TRUE");
		xmlNewChild(nodo,NULL,"translatable_strings_file",strings_file);
		g_free(strings_file);
	}
	nombre_locale = g_locale_from_utf8(nombrep, -1, &read, &written, &error);
	xmlSaveFile(nombre_locale,doc);
	g_free(nombre_locale);
	xmlFreeDoc(doc);
	g_free(proyecto);
	g_free(srcdir);
	g_free(pixdir);
	g_free(libs);
	g_free(lenguaje);
	g_free(ejecutable);
	g_free(nombrep);
}

/****************************************************************************************
   This function parses the glade project file and makes a list of project 
   windows.
***************************************************************************************/
gint gla_create_glade_window_list (gchar *glade_file) 
{
	xmlDocPtr glade_project;
	xmlNodePtr glade_node;
	gchar *name, *class;
	struct s_glade_project_window *list_node;
	gchar *glade_file_locale;
	gsize read, written;
	GError *error;
	
	glade_file_locale = g_locale_from_utf8(glade_file, -1, &read, &written, &error);
	glade_project = xmlParseFile (glade_file_locale);
	g_free(glade_file_locale);
	if (glade_project == NULL)
		return -1;
	
	//The main windows are toplevel childs in the glade project file.
	glade_node = glade_project->xmlRootNode;
	if (glade_node == NULL)
		return -2;
	//We look for the XML_ELEMENT_NODE called glade-interface, not the XML_DTD_NODE.
	while (glade_node != NULL) {
		if (!strcmp(glade_node->name,"glade-interface")) {
			if (glade_node->type == XML_ELEMENT_NODE)	
				break;
		}
		glade_node = glade_node->next;
	}
	if (glade_node == NULL) {
		return -3;
	} else {
		glade_node = glade_node->xmlChildrenNode;
	}
	
	while (glade_node != NULL) {
		if (!strcmp (glade_node->name, "widget")) {
			//"widget" found, main window.
			name = xmlGetProp(glade_node, "id");
			class = xmlGetProp(glade_node, "class");
			if (glade_window_list == NULL) {
				glade_window_list = g_malloc(sizeof(struct s_glade_project_window));
				list_node=glade_window_list;
				list_node->previous=NULL;
			} else {
				list_node=glade_window_list;
				while (list_node->next != NULL) {
					list_node=list_node->next;
				}
				list_node->next=g_malloc(sizeof(struct s_glade_project_window));
				list_node->next->previous=list_node;
				list_node=list_node->next;
			}
			list_node->next = NULL;
			list_node->window_widget = NULL;
			list_node->widgets = NULL;
			list_node->window_name = g_strdup (name);
			list_node->window_class = g_strdup (class);
			g_free(name);
			g_free(class);
			
			glade_node = glade_node->next;
		} else {
			glade_node = glade_node->next;
		}
	}
	xmlFreeDoc(glade_project);

	return 0;
}

/*******************************************************************************
  This function frees the glade window list
*******************************************************************************/
void gla_free_glade_window_list (void)
{
	struct s_glade_project_window *list_node;
	
	if (glade_window_list == NULL)
		return;
	list_node = glade_window_list;
	while (list_node->next != NULL) {
		list_node = list_node->next;
	}
	while (list_node->previous != NULL) {
		g_free(list_node->window_name);
		g_free(list_node->window_class);
		if (list_node->window_widget != NULL)
			gtk_widget_destroy(list_node->window_widget);
		gla_free_glade_widget_list(list_node->widgets);
		list_node->widgets = NULL;
		list_node = list_node->previous;
		g_free(list_node->next);
		list_node->next = NULL;
	}
	g_free(list_node->window_name);
	g_free(list_node->window_class);
	gla_free_glade_widget_list(list_node->widgets);
	list_node->widgets = NULL;
	if (list_node->window_widget != NULL)
		gtk_widget_destroy(list_node->window_widget);
	g_free(list_node);
	glade_window_list = NULL; 
}

/********************************************************************************
  This function initializes the GUI GtkTreeView
*******************************************************************************/
void gla_gui_treeview_init (void)
{
	GtkTreeView *tree_view;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *selection;

	glade_window_list = NULL;
	glade_widget_list = NULL;
	glade_widget_list_last_widget = NULL;
	
	DEBUG_MSG(->gla_gui_treeview_init);
	gui_store=gtk_tree_store_new(TOTAL_COLUMNS,GDK_TYPE_PIXBUF,G_TYPE_STRING);
		
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"gui_treeview"));
	gtk_tree_view_set_model(tree_view,GTK_TREE_MODEL(gui_store));
//	gtk_tree_view_set_rules_hint(tree_view, TRUE);
	
	renderer=gtk_cell_renderer_pixbuf_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"pixbuf",COL_ICON,NULL);
	gtk_tree_view_append_column(tree_view,column);
	renderer=gtk_cell_renderer_text_new();
	column=gtk_tree_view_column_new_with_attributes(NULL,renderer,"text",COL_NAME,NULL);
	gtk_tree_view_append_column(tree_view,column);
	
	selection=gtk_tree_view_get_selection(tree_view);
	gtk_tree_selection_set_mode(selection,GTK_SELECTION_SINGLE);
	g_signal_connect(G_OBJECT(selection),"changed",G_CALLBACK(on_gui_treeview_select_row),NULL);
	
	gtk_tree_sortable_set_default_sort_func(GTK_TREE_SORTABLE(gui_store),(GtkTreeIterCompareFunc)gen_GtkTreeIterCompareFunc,(gpointer)COL_NOMBRE,NULL);
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(gui_store),GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,GTK_SORT_ASCENDING);
		
	DEBUG_MSG(<-gla_gui_treeview_init);	
}


/********************************************************************************
  This function puts the glade_window_list in the GUI GtkTreeView
********************************************************************************/
gint gla_gui_treeview_populate (void)
{
	GtkTreeIter iter, parent_iter;
	struct s_glade_project_window *list_node;
	gchar *name;
	GtkTreeView *tree_view;
	
	DEBUG_MSG(->gla_gui_treeview_populate);
	
	gtk_tree_store_clear (gui_store);
	
	name = g_strdup(_("GUI Window List"));
	gtk_tree_store_append(gui_store, &parent_iter, NULL);
	gtk_tree_store_set (gui_store, &parent_iter, COL_ICON, pixbufs[PROYECTO], COL_NAME, name, -1);
	g_free(name);
	
	list_node = glade_window_list;
	
	while (list_node != NULL) {
		gtk_tree_store_append (gui_store, &iter, &parent_iter);
		gtk_tree_store_set (gui_store, &iter, COL_ICON, pixbufs[PROYECTO], COL_NAME, list_node->window_name, -1);
		list_node = list_node->next;
	}
	
	tree_view=GTK_TREE_VIEW(glade_xml_get_widget(david_ventana,"gui_treeview"));
	gtk_tree_view_expand_all(tree_view);

	return 0;
}

/*****************************************************************************************
 This function makes a copy of the Glade project file, and modifies it, deleting
 all signals to the widgets and adding a singal to the button_press_event of
 all widgets.
*****************************************************************************************/
gint gla_parse_glade_project_file (gchar *glade_project_file)
{
	
	xmlDocPtr glade_project_doc;
	xmlNodePtr glade_node;
	struct s_glade_widget *glade_widget;
	struct s_glade_project_window *window_list_node;
	gint status;
	gchar *glade_project_file_locale;
	gsize read, written;
	GError *error;
	
	glade_project_file_locale = g_locale_from_utf8(glade_project_file, -1, &read, &written, &error);
	glade_project_doc = xmlParseFile (glade_project_file_locale);
	g_free(glade_project_file_locale);
	if (glade_project_doc == NULL)
		return -1;
	glade_node = glade_project_doc->xmlRootNode;
	if (glade_node == NULL)
		return -2;
	//We look for the XML_ELEMENT_NODE called glade-interface, not the XML_DTD_NODE.
	while (glade_node != NULL) {
		if (!strcmp(glade_node->name,"glade-interface")) {
			if (glade_node->type == XML_ELEMENT_NODE)	
				break;
		}
		glade_node = glade_node->next;
	}
	if (glade_node == NULL)		
		return -3;
	glade_node = glade_node->xmlChildrenNode;
	//variable initialization
	glade_widget_list = NULL;
	glade_widget_list_last_widget = NULL;
	
	while (glade_node != NULL) {
		if (!strcmp (glade_node->name, "widget")) {
			//main window found. Process all the children widgets.
			glade_widget = gla_process_glade_widget_node(glade_node, &status);
			if (glade_widget_list == NULL) {
				glade_widget_list = glade_widget;
				glade_widget_list_last_widget = glade_widget_list;
			} else {
				glade_widget_list_last_widget->next = glade_widget;
				glade_widget->previous = glade_widget_list_last_widget;
				glade_widget_list_last_widget = glade_widget;
			}
			//attach the newly created widget list to the appropiate element of the
			//glade_window_list.
			window_list_node = glade_window_list;
			while (window_list_node != NULL) {
				if (strcmp(window_list_node->window_name, glade_widget->widget_name) == 0) {
					window_list_node->widgets = glade_widget_list;
					glade_widget_list = NULL;
					glade_widget_list_last_widget = NULL;
					window_list_node = NULL;
				} else {
					window_list_node = window_list_node->next;
				}
					
			}
			glade_node = glade_node->next;
		} else {
			//process next node looking for a main window.
			glade_node = glade_node->next;
		}
	}
	
	xmlFreeDoc(glade_project_doc);
	
	return 0;	
}

/****************************************************************************************
 This function processes a "widget" node of the glade file. It fills a  newly
 allocated s_glade_widget structure with the name and signal info.
It returns the allocated s_glade_widget structure. It's up to the user to free it.
****************************************************************************************/
struct s_glade_widget *gla_process_glade_widget_node (xmlNodePtr widget_node, gint *error)
{
	struct s_glade_widget *glade_widget, *glade_widget_in_child;
	struct s_glade_widget_property *widget_property, *temp_property_pointer;
	struct s_glade_signal *signal, *temp_signal_pointer;
	xmlNodePtr temp_widget_node, temp_child_node;
	gint status;
	
	//we don't want the original pointer to be modified
	temp_widget_node = widget_node;
	
	glade_widget = g_malloc (sizeof(struct s_glade_widget));
	glade_widget->widget_name = xmlGetProp(temp_widget_node, "id");
	glade_widget->class = xmlGetProp(temp_widget_node, "class");
	glade_widget->properties = NULL;
	glade_widget->signals = NULL;
	glade_widget->next = NULL;
	glade_widget->previous = NULL;
	//all the properties, child and signals
	temp_widget_node = temp_widget_node->xmlChildrenNode;
	while (temp_widget_node != NULL) {
		switch (temp_widget_node->name[0]) {
			case 'p':  //property
				widget_property = g_malloc(sizeof(struct s_glade_widget_property));
				widget_property->property_name = xmlGetProp(temp_widget_node, "name");
				widget_property->translatable = xmlGetProp (temp_widget_node, "translatable");
				widget_property->value = xmlNodeGetContent(temp_widget_node);
				widget_property->next = NULL;
				temp_property_pointer = glade_widget->properties;
				if (temp_property_pointer != NULL) {
					while (temp_property_pointer->next != NULL) {
						temp_property_pointer = temp_property_pointer->next;
					}
					temp_property_pointer->next = widget_property;
					widget_property->previous = temp_property_pointer;
				} else {
					glade_widget->properties = widget_property;
					widget_property->previous = NULL;
				}
				break;
			case 's':  //signal
				signal = g_malloc(sizeof(struct s_glade_signal));
				signal->signal_name = xmlGetProp(temp_widget_node, "name");
				signal->handler_function = xmlGetProp(temp_widget_node, "handler");
				signal->after = xmlGetProp(temp_widget_node, "after");
				signal->next = NULL;
				temp_signal_pointer = glade_widget->signals;
				if (temp_signal_pointer != NULL) {
					while (temp_signal_pointer->next != NULL) {
						temp_signal_pointer = temp_signal_pointer->next;
					}
					temp_signal_pointer->next = signal;
					signal->previous = temp_signal_pointer;
				} else {
					glade_widget->signals = signal;
					signal->previous = NULL;
				}
				break;
			case 'c':  //child
				temp_child_node = temp_widget_node;
				temp_child_node = temp_child_node->xmlChildrenNode;
				while (temp_child_node != NULL) {
					switch (temp_child_node->name[0]) {
						case 'p':  //packing
							break;
						case 'w': //widget
							glade_widget_in_child = gla_process_glade_widget_node (temp_child_node, &status);
							if (glade_widget_list == NULL) {
								glade_widget_list = glade_widget_in_child;
								glade_widget_list_last_widget = glade_widget_list;
							} else {
								glade_widget_list_last_widget->next = glade_widget_in_child;
								glade_widget_in_child->previous = glade_widget_list_last_widget;
								glade_widget_list_last_widget = glade_widget_in_child;
							}
							break;
						default:
							break;
					}
					temp_child_node = temp_child_node->next;
				}
				break;
			default:
				break;
		}
		temp_widget_node = temp_widget_node->next;
	}
	
	return glade_widget;
}

/**************************************************************************************
 This function frees a list of glade widget property structures
**************************************************************************************/
gint gla_free_glade_widget_property_list (struct s_glade_widget_property *widget_property_list)
{
	if (widget_property_list == NULL)
		return 0;
	while (widget_property_list->next != NULL) {
		widget_property_list = widget_property_list->next;
	}
	while (widget_property_list->previous != NULL) {
		g_free (widget_property_list->property_name);
		if (widget_property_list->translatable != NULL)
			g_free (widget_property_list->translatable);
		g_free (widget_property_list->value);
		widget_property_list = widget_property_list->previous;
		g_free(widget_property_list->next);
		widget_property_list->next = NULL;
	}
	g_free (widget_property_list->property_name);
	if (widget_property_list->translatable != NULL)
		g_free (widget_property_list->translatable);
	g_free (widget_property_list->value);
	widget_property_list->next = NULL;
	g_free(widget_property_list);
		
	return 0;
}
/**************************************************************************************
 This function frees a list of glade signal structures
**************************************************************************************/

gint gla_free_glade_signal_list (struct s_glade_signal *signal_list) 
{
	if (signal_list == NULL)
		return 0;
	while (signal_list->next != NULL) {
		signal_list = signal_list->next;
	}
	while (signal_list->previous != NULL) {
		g_free (signal_list->signal_name);
		g_free (signal_list->handler_function);
		g_free (signal_list->after);
		signal_list = signal_list->previous;
		g_free(signal_list->next);
		signal_list->next = NULL;
	}
	g_free (signal_list->signal_name);
	g_free (signal_list->handler_function);
	g_free (signal_list->after);
	signal_list->next = NULL;
	g_free(signal_list);
		
	return 0;
	
}

/**************************************************************************************
 This function frees a list of glade widget structures
**************************************************************************************/
gint gla_free_glade_widget_list (struct s_glade_widget *widget_list)
{
	
	if (widget_list == NULL)
		return 0;
	while (widget_list->next != NULL) {
		widget_list = widget_list->next;
	}
	while (widget_list->previous != NULL) {
		g_free(widget_list->widget_name);
		g_free(widget_list->class);
		gla_free_glade_widget_property_list(widget_list->properties);
		widget_list->properties = NULL;
		gla_free_glade_signal_list(widget_list->signals);
		widget_list->signals = NULL;
		widget_list = widget_list->previous;
		g_free(widget_list->next);
		widget_list->next = NULL;
	}
	g_free(widget_list->widget_name);
	g_free(widget_list->class);
	gla_free_glade_widget_property_list(widget_list->properties);
	widget_list->properties = NULL;
	gla_free_glade_signal_list(widget_list->signals);
	widget_list->signals = NULL;
	widget_list->next = NULL;
	g_free(widget_list);
	
	return 0;
}

void gla_leer_proyecto_druid(void)
{
	GtkWidget *entrada;
	gchar *nombre_entrada;
	gchar *nombre;
	gsize read, written;
	GError *error;
	xmlDocPtr doc;
	xmlNodePtr nodo,nodo_proyecto;
	gint cont;
	gchar *tmp;
	
	entrada=glade_xml_get_widget(druida_glade_ventana,"glade_project_entry");
	nombre_entrada=gtk_editable_get_chars(GTK_EDITABLE(entrada),0,-1);
	nombre=g_locale_from_utf8(nombre_entrada, -1,&read,&written,&error);
	doc=xmlParseFile(nombre);
	if (doc==NULL) return;

	nodo_proyecto=doc->xmlChildrenNode;
	while (nodo_proyecto!=NULL) {
		if (!strcmp(nodo_proyecto->name,"glade-project")) {
			if (nodo_proyecto->type==XML_ELEMENT_NODE)	
				break;
		}
		nodo_proyecto=nodo_proyecto->next;
	}
	
	nodo=buscar_nodo_xml(nodo_proyecto,"name");
	glade_druid_data.name=xmlNodeGetContent(nodo);
	nodo=buscar_nodo_xml(nodo_proyecto,"program_name");
	glade_druid_data.program=xmlNodeGetContent(nodo);
	glade_druid_data.directory=g_strdup(nombre_entrada);
	for (cont=0;glade_druid_data.directory[cont]!=0;cont++);
	for (;glade_druid_data.directory[cont]!='/';cont--);
	cont++;
	glade_druid_data.directory[cont]=0;	
	nodo=buscar_nodo_xml(nodo_proyecto,"source_directory");
	if (nodo!=NULL) {
		tmp=xmlNodeGetContent(nodo);
		glade_druid_data.sources=g_strdup_printf("%s/",tmp);
		g_free(tmp);
	} else {
		glade_druid_data.sources=g_strdup("src/");
	}
	nodo=buscar_nodo_xml(nodo_proyecto,"pixmaps_directory");
	if (nodo!=NULL) {
		tmp=xmlNodeGetContent(nodo);
		glade_druid_data.pixmaps=g_strdup_printf("%s/",tmp);
		g_free(tmp);
	} else {
		glade_druid_data.pixmaps=g_strdup("pixmaps/");
	}
	tmp=g_strdup(nombre_entrada);
	for (cont=0;tmp[cont]!=0;cont++);
	cont--;
	tmp[cont]=0;
	for (;tmp[cont]!='/';cont--);
	cont++;
	glade_druid_data.interface=g_strdup(tmp+cont);
	g_free(tmp);
	nodo=buscar_nodo_xml(nodo_proyecto,"gnome_support");
	glade_druid_data.gnome=!(nodo!=NULL);
	nodo=buscar_nodo_xml(nodo_proyecto,"gettext_support");
	glade_druid_data.gettext=!(nodo!=NULL);
	nodo=buscar_nodo_xml(nodo_proyecto,"translatable_strings_file");
	if (nodo!=NULL) {
		glade_druid_data.strings=xmlNodeGetContent(nodo);
		glade_druid_data.libglade=TRUE;
	} else {
		glade_druid_data.strings=g_strdup("");
		glade_druid_data.libglade=FALSE;
	}

	g_free(nombre_entrada);
	g_free(nombre);
	xmlFreeDoc(doc);
}

void gla_mostrar_datos_druid(void)
{
	GtkWidget *widget;
	
	widget=glade_xml_get_widget(druida_glade_ventana,"name_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.name);
	widget=glade_xml_get_widget(druida_glade_ventana,"program_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.program);
	widget=glade_xml_get_widget(druida_glade_ventana,"directory_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.directory);
	widget=glade_xml_get_widget(druida_glade_ventana,"sources_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.sources);
	widget=glade_xml_get_widget(druida_glade_ventana,"pixmaps_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.pixmaps);
	widget=glade_xml_get_widget(druida_glade_ventana,"interface_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.interface);
	widget=glade_xml_get_widget(druida_glade_ventana,"gnome_checkbutton_glade_druid");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),glade_druid_data.gnome);
	widget=glade_xml_get_widget(druida_glade_ventana,"libglade_checkbutton_glade_druid");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),glade_druid_data.libglade);
	widget=glade_xml_get_widget(druida_glade_ventana,"gettext_checkbutton_glade_druid");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),glade_druid_data.gettext);
	widget=glade_xml_get_widget(druida_glade_ventana,"strings_entry_glade_druid");
	gtk_entry_set_text(GTK_ENTRY(widget),glade_druid_data.strings);
}
