/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

struct s_preferencias {
	xmlDocPtr xml;
	gchar *nombre;
	gchar *e_mail;
	gchar *directorio;
	gboolean texto_barras;
	gboolean auto_indentacion;
	gboolean super_indentacion;
	gboolean completar_llaves;
	gint tabulador;
	gchar *fuente;
	gboolean numeros;
	gchar *ultimos[5];
	gchar *ayuda[TOTAL_AYUDAS];
	gboolean negrita_nada,negrita_comentario,negrita_directiva,negrita_cadena_cs,negrita_cadena_cd,negrita_etiqueta,negrita_entero,negrita_real,negrita_hexadecimal,negrita_octal,negrita_prelight;
	gboolean cursiba_nada,cursiba_comentario,cursiba_directiva,cursiba_cadena_cs,cursiba_cadena_cd,cursiba_etiqueta,cursiba_entero,cursiba_real,cursiba_hexadecimal,cursiba_octal,cursiba_prelight;
	gchar *inc[LTOTALES];
	gchar *lib[LTOTALES];
	gchar *lib_electric_fence;
};

//*******************************************************************

struct s_preferencias preferencias;

//*******************************************************************

void pref_crear(void);

void pref_abrir(guint estado);

void pref_guardar(void);

void pref_actualizar(GtkWidget *widget);

void pref_mostrar(GtkWidget *widget);

void pref_xml_struct(void);

void pref_cerrar(void);

void pref_aplicar(void);
