/*
    latex.c - Belegloser Datentrgeraustausch mit einer Bank
    Copyright (c) 2004  Martin Schulze <joey@infodrom.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111, USA.

    $Id: latex.c,v 1.1 2004/08/06 20:21:28 joey Exp $
 */

#include <stdio.h>
#include "bigint.h"

#define LATEX_HEADER	"%% Automatically generated by dtaus, requires dtaus.cls from the\n\
%% source distribution or derivative class.\n\
%%\n\
\\documentclass{dtaus}\n\
\n\
\\begin{document}\n\
\n\
\\header\n\
\n\
\\headline{Begleitzettel}\n\
\n\
\\subheadline{Belegloser Datentrgeraustausch}\n\
"

#define LATEX_FOOTER	"\\vfill\n\
\n\
\\signature\n\
\n\
\\footer\n\
\n\
\\end{document}\n\
"

#define LATEX_TYPE	"\\subheadline{%s}\n\n"

#define LATEX_TAB_BEGIN	"\\begin{tabular}{l@{ : }l}\n"
#define LATEX_TAB_END	"\\end{tabular}\n\n"
#define LATEX_TAB_ROW	"\\tabline{%s}{%s}\n"

void generate_latex_receipt (
			     char *fname,
			     char *type,
			     char *created,
			     char *todo,
			     char *currency,
			     int quantity,
			     char *sum_val,
			     char *sum_kto,
			     char *sum_blz,
			     char *kto,
			     char *blz
			     )
{
  FILE *f;
  char tmp[10];

  if (!(f = fopen(fname, "w"))) {
    fprintf (stderr, "Cannot open LaTeX output file %s, ignoring.\n", fname);
    return;
  }

  /* fopen() */
  fprintf (f, LATEX_HEADER);
  fprintf (f, LATEX_TYPE, type);

  fprintf (f, LATEX_TAB_BEGIN);
  fprintf (f, LATEX_TAB_ROW, "VOL", "");
  fprintf (f, LATEX_TAB_ROW, "Erstellungsdatum", created);
  if (todo)
    fprintf (f, LATEX_TAB_ROW, "Ausfhrugsdatum", todo);
  fprintf (f, LATEX_TAB_ROW, "Whrung", currency);
  snprintf (tmp, sizeof (tmp), "%d", quantity);
  fprintf (f, LATEX_TAB_ROW, "Anzahl", tmp);
  fprintf (f, LATEX_TAB_ROW, "Summe", sum_val);
  fprintf (f, LATEX_TAB_ROW, "Kontrollsumme Kontonummern", sum_kto);
  fprintf (f, LATEX_TAB_ROW, "Kontrollsumme Bankleitzahlen", sum_blz);
  fprintf (f, LATEX_TAB_ROW, "Unsere Kontonummer", kto);
  fprintf (f, LATEX_TAB_ROW, "Unsere Bankleitzahl", blz);
  fprintf (f, LATEX_TAB_END);

  fprintf (f, LATEX_FOOTER);

  fclose (f);
}

/* --------------------
\subheadline{Sammeleinziehungsauftrag}

\begin{tabular}{l@{ : }l}
\tabline{VOL}{}
\tabline{Erstellungsdatum}{05.08.04}
\tabline{Ausfhrugsdatum}{24.12.2001}
\tabline{Whrung}{Euro}
\tabline{Anzahl}{2}
\tabline{Summe}{50.00}
\tabline{Kontrollsumme Kontonummern}{2469134}
\tabline{Kontrollsumme Bankleitzahlen}{94221630}
\tabline{Unsere Kontonummer}{0000123545}
\tabline{Unsere Bankleitzahl}{02004002}
\end{tabular}
-------------------- */

