/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Author: Stéphane Démurget  <stephane.demurget@enst-bretagne.fr>
 */

#ifndef __EF_BACKEND_H__
#define __EF_BACKEND_H__

#include <glib.h>

typedef enum
{
	GOV_PERFORMANCE = 1 << 0,
	GOV_USERSPACE   = 1 << 1,
	GOV_POWERSAVE   = 1 << 2,
	GOV_LAST	= 1 << 3  /* always keep this one the last */
} EFBackendGovernors;

typedef enum {
	EMIFREQ_INIT_ERROR = 1,
	EMIFREQ_NOTHRMDIR_ERROR = 2
} EmiFreqError;

#define EMIFREQ_ERROR emifreq_error_quark ()

/* Note: the returned values mustn't be freed ! */

gboolean	   ef_backend_is_available	    	(void);
gboolean  	   ef_backend_init 	            	(GError **error);

void     	   ef_backend_reload 	            	(void);
void     	   ef_backend_reload_usage          	(void);

char      	  *ef_backend_get_driver            	(void);
char      	  *ef_backend_get_governor_name     	(void);
EFBackendGovernors ef_backend_get_governor	    	(void);
int 		   ef_backend_get_temperature       	(gboolean metric_units);
int   	           ef_backend_get_frequency         	(void);
float 		   ef_backend_get_usage             	(void);

int		   ef_backend_governors_count 		(EFBackendGovernors gov);
EFBackendGovernors ef_backend_get_avail_governors   	(void); /* returned value is an OR'ed bits mask */ 
GPtrArray         *ef_backend_get_avail_frequencies 	(void); /* returned value musn't be freed */
gboolean	   ef_backend_is_avail_frequency    	(int freq);
int		   ef_backend_get_medium_frequency  	(void);

void   		   ef_backend_shutdown	            	(void);

/* Note: off course the process needs to have the write rights to the sysfs */
void		   ef_backend_set_governor 	    	(EFBackendGovernors gov);
void		   ef_backend_set_frequency 	    	(int freq);

#endif
