# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Font Dialog instead of the Qt Font Dialog.
"""

try:
    import os
    if os.getenv("e3nokde"):
        raise ImportError
        
    from kdeui import KFontDialog
    from qt import QFont
    
    def getFont(initial, parent = None, name = None):
        """
        Public function to pop up a modal dialog to select a font.
        
        @param initial initial font to select (QFont)
        @param parent parent widget of the dialog (QWidget)
        @param name name of the dialog (ignored)
        @return the selected font or the initial font, if the
            canceled the dialog (QColor) and a flag indicating
            the user selection of the OK button (boolean)
        """
        font = QFont(initial)
        res = KFontDialog.getFont(font, 0, parent)[0]
        if res == KFontDialog.Accepted:
            return font, 1
        else:
            return initial, 0
    
except (ImportError, RuntimeError):
    import qt
    getFont = qt.QFontDialog.getFont
