;;  antares.asm : Extended-IPL/scorpius
;;
;;	multi OS boot utility for IBM PC/AT and compatibles, Since 1993
;;
;;					Auther : takamiti@tsden.org
;;					last update : 1999/04/05
;;
;;	This program requires NASM - "The Netwide Assembler"
;;		(http://www.web-sites.co.uk/nasm/)
;;
;;  $Id: antares.asm,v 1.1.1.1 2000/11/29 11:58:06 takamiti Exp $
;;

%include	"biosdef.inc"
%include	"ipldef.inc"

		bits	16
		org	0x0600		;; BOOT_LOC

		section .text

		cli
		xor	ax,ax
		mov	ss,ax
		mov	es,ax
		mov	ds,ax
		xchg	ax,dx
		mov	sp,BIOS_LOC
		mov	si,sp
		sti
		cld
		mov	di,BOOT_LOC
		mov	cx,256
		repnz	movsw
%ifdef FDTEST
		jmp	launcher - BIOS_LOC + BOOT_LOC
%else
		jmp	start - BIOS_LOC + BOOT_LOC
%endif

start:		test	byte [kbd_stat],SHIFT_BIT
		jnz	doselect
		test	byte [fd_stat],0x0F
		jnz	start
		jmp	short chkTable

doselect:	inc	dx
chkTable:	call	initCRT
		push	word chkTable
		mov	cx,4
		mov	di,BOOT_LOC + PART_TBL_OFS
		mov	bx,0x3130
		mov	si,guid_msg
		call	putstr
chtabloop:	inc	bx
		test	byte [di],0x80
		jz	prntab
		or	dx,dx
		jz	bootProc
		mov	bh,bl
		and	byte [di],0x7F
prntab:		mov	ah,1
		mov	al,bl
		call	putSPC
		mov	al,[di+4]
		or	al,al
		jz	nosys
		push	ax
		mov	ax,0x0473
		call	putSPC
		pop	ax
		call	hex2
nosys:		add	di,byte 16
		call	putCRLF
		loop	chtabloop
		inc	dx

retry0:		mov	bl,bh
retry1:		push	bx
retry:		mov	si,selmsg
		call	putstr
keyin:		pop	ax
		call	putch
keyin1:		xor	ah,ah
		int	KEYBIOS
		cmp	al,0x30
		jc	selOK
		cmp	al,0x34
		ja	keyin1
		xchg	ax,bx
		jmp	short retry1

selOK:		cmp	ah,EXEC_KEY		; check key-scan code
		jz	bootProc
		cmp	ah,ENTER_KEY
		jnz	keyin1

bootProc:	push	dx
		mov	bh,bl
		sub	bl,0x30
		jz	switch_HD

		xchg	ax,bp			; boot condition flag save to bp
		dec	bx
		mov	al,16
		mul	bl
		add	ax,BOOT_LOC + PART_TBL_OFS
		xchg	ax,si			; partition table address in si
		push	si
		lodsw
		xchg	ax,dx
		lodsw
		xchg	ax,cx
		lodsw
		pop	si
		or	al,al			; check system-identity
		jnz	bootcontinue
		pop	dx
		push	word retry0
bell:		mov	al,BELL
		jmp	putch

bootcontinue:	mov	dl,byte [drive]
		add	dl,0x50
		push	ax			; save system identity
		call	HDread
		pop	ax
		cmp	word [BIOS_LOC + 0x1FE],IPL_MAGIC
		jz	checksysid
		pop	dx
		jmp	short bell

checksysid:	mov	ah,byte [prompt]
		inc	ah
		cmp	al,EXTDOS_PART
		jz	moveTable
		cmp	al,EXTLINUX_PART
		jz	moveTable
		cmp	al,EXTDOSLBA_PART
		jz	moveTable

		mov	byte [si],dl
		cmp	dl,0x80			; first drive unit ?
		jnz	kickOS
		cmp	byte [prompt],PS0	; master boot sector ?
		jnz	kickOS
		xchg	ax,bp			; load boot condition flag
		cmp	ah,EXEC_KEY		; spcified write table ?
		jnz	kickOS
		xor	dh,dh
		mov	cx,1
		mov	ax,0x301
		mov	bx,BOOT_LOC
		call	HDio

kickOS:		call	initCRT
		jmp	BIOS_LOC		;; jmp	far BIOS_LOC

;  try next drive unit
switch_HD:	mov	al,byte [drive]
		sub	al,0x30
		inc	ax
		cmp	al,byte [nr_hdds]
		jc	swhd1
		xor	ax,ax
swhd1:		push	ax
		add	al,0x30
		mov	byte [drive],al
		pop	dx
		xor	dh,dh
rdsector00:	or	dl,0x80
		mov	cx,1
		call	HDread
		mov	ah,PS0
moveTable:	mov	byte [prompt],ah
		mov	si,(BIOS_LOC + 0x01BE)
		mov	di,BOOT_LOC + PART_TBL_OFS
		mov	cx,33
		repnz	movsw
		pop	dx
return:		ret

HDread:		mov	bx,BIOS_LOC		; load address 0x7C00L
		mov	ax,0x0201
HDio:		int	DISKBIOS
		jnc	return

		push	ax			; disk BIOS error code
		call	bell
		mov	ax,0x043F
		call	putSPC
		pop	ax
		mov	al,ah
		call	hex2
		hlt
		jmp	short $

initCRT:	mov	ax,2
		jmp	short putch1
putspace:	mov	al,0x20
putch:		mov	ah,14
putch1:		int	VIDEOBIOS
		ret

putCRLF:	mov	si,crlf_msg
putstr:		lodsb
		or	al,al
		jz	return
		call	putch
		jmp	short putstr

hex2:		push	ax
		push	cx
		mov	cl,4
		shr	al,cl
		pop	cx
		call	hex1
		pop	ax
hex1:		and	al,0x0F
		add	al,0x30
		cmp	al,0x3A
		jc	putch
		add	al,7
		jmp	short putch

putSPC:		push	ax
		call	putspace
		pop	ax
		dec	ah
		jnz	putSPC
		jmp	short putch

guid_msg:	db	"Part  Sys"
crlf_msg:	db	CR, LF, NULL
selmsg:		db	CR, "Boot#"
drive:		db	"0:"
prompt:		db	PS0, ".", NULL

%ifdef FDTEST
launcher:	push	word start
		xor	dx,dx
		push	dx
		jmp	rdsector00
%endif

; end of antares.asm
