/*  extipl.h -  header for extipl modules
 *		Auther:	KIMURA Takamiti<takamiti@tsden.org>
 *
 *  $Id: extipl.h,v 1.7 2002/03/25 13:48:52 takamiti Exp $
 */

#define VERSION			"5.04"
#define DATE			"2002/03/26"

#define SECTOR_SIZE		512
#define IPL_SIZE		446
#define TABLE_OFFSET		446
#define NR_PARTITION		4
#define TBL_ENTRY_SIZE		16
#define TABLE_SIZE		(NR_PARTITION * TBL_ENTRY_SIZE)
#define IPL_MAGIC_POS		510
#define IPL_MAGIC		0xaa55

#define LBUF_SIZE		256

#define EXTDOS_PART		0x05
#define EXTLINUX_PART		0x85
#define EXTDOSLBA_PART		0x0f
#define is_extpart(n)		((n)==EXTDOS_PART || (n)==EXTLINUX_PART || (n)==EXTDOSLBA_PART)

#define GEMINI_BLKLEN		18
#define GEMINI_SIZE		(GEMINI_BLKLEN * SECTOR_SIZE)
#define GEMINI_CODELN		(GEMINI_SIZE - SECTOR_SIZE)
#define IPLNAME_LEN		14
#define DIG_LIMIT		16

#define Boot_Maybe		0x00
#define Boot_Enable		0x01
#define Boot_SwapDrv		0x02
#define Boot_Disable		0x80

#define ctrl(c)			((c) - 0x40)
#define between(a, l, u)	((unsigned short)((a)-(l)) <= ((u)-(l)))
#define bell()			printf("\007")

typedef unsigned char byte;
typedef unsigned long long ul_long;

typedef struct hdadr_s {
	byte  head;
	byte  sect;
	byte  cyl;
    } hdadr_s;

typedef struct partition_s {
	byte	       bootind;
	hdadr_s        start_chs;
	byte	       sysind;
	hdadr_s        end_chs;
	unsigned long  sector_offset;
	unsigned long  nr_sector;
    } partition_s;

typedef struct offset_s {
	hdadr_s	chs;
	ul_long	lba;
    } offset_s;

typedef struct extinfo_s {
	struct offset_s	    offset;
	struct partition_s  table[4];
	struct extinfo_s    *next;
    } extinfo_s;

typedef struct sysident_s {
	int   id;
	int   bootable;
	char  *name;
    } sysident_s;

typedef struct incode_s {
	char  *code;
	int   len;
    } incode_s;

typedef struct inneripl_s {
	char		*iplname;
	int		nr_part;
	char		*note;
	struct incode_s hd_code[2];
	struct incode_s fd_code[2];
    } internslipl_s;

/* end of extipl.h */
