/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:41:15 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_notw_noinline_c -simd -compact -variables 4 -sign 1 -n 16 -name m2bv_16 -with-ostride 2 -include n2b.h */

/*
 * This function contains 72 FP additions, 12 FP multiplications,
 * (or, 68 additions, 8 multiplications, 4 fused multiply/add),
 * 27 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_noinline_c.ml,v 1.1 2003/04/17 10:44:21 athena Exp $
 */

#include "n2b.h"

static void m2bv_16_0(const R *xi, R *xo, stride is, int ivs, int ovs)
{
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  V Tp, T13, Tu, TY, Tm, T14, Tv, TU, T7, T16, Tx, TN, Te, T17, Ty;
	  V TQ;
	  {
	       V Tn, To, TX, Ts, Tt, TW;
	       Tn = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
	       To = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
	       TX = VADD(Tn, To);
	       Ts = LD(&(xi[0]), ivs, &(xi[0]));
	       Tt = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
	       TW = VADD(Ts, Tt);
	       Tp = VSUB(Tn, To);
	       T13 = VADD(TW, TX);
	       Tu = VSUB(Ts, Tt);
	       TY = VSUB(TW, TX);
	  }
	  {
	       V Ti, TS, Tl, TT;
	       {
		    V Tg, Th, Tj, Tk;
		    Tg = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    Th = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Ti = VSUB(Tg, Th);
		    TS = VADD(Tg, Th);
		    Tj = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
		    Tk = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tl = VSUB(Tj, Tk);
		    TT = VADD(Tj, Tk);
	       }
	       Tm = VMUL(LDK(KP707106781), VSUB(Ti, Tl));
	       T14 = VADD(TS, TT);
	       Tv = VMUL(LDK(KP707106781), VADD(Ti, Tl));
	       TU = VSUB(TS, TT);
	  }
	  {
	       V T3, TL, T6, TM;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    TL = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    TM = VADD(T4, T5);
	       }
	       T7 = VFNMS(LDK(KP382683432), T6, VMUL(LDK(KP923879532), T3));
	       T16 = VADD(TL, TM);
	       Tx = VFMA(LDK(KP382683432), T3, VMUL(LDK(KP923879532), T6));
	       TN = VSUB(TL, TM);
	  }
	  {
	       V Ta, TO, Td, TP;
	       {
		    V T8, T9, Tb, Tc;
		    T8 = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
		    T9 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    Ta = VSUB(T8, T9);
		    TO = VADD(T8, T9);
		    Tb = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tc = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TP = VADD(Tb, Tc);
	       }
	       Te = VFMA(LDK(KP923879532), Ta, VMUL(LDK(KP382683432), Td));
	       T17 = VADD(TO, TP);
	       Ty = VFNMS(LDK(KP382683432), Ta, VMUL(LDK(KP923879532), Td));
	       TQ = VSUB(TO, TP);
	  }
	  {
	       V T15, T18, T19, T1a;
	       T15 = VSUB(T13, T14);
	       T18 = VBYI(VSUB(T16, T17));
	       ST(&(xo[24]), VSUB(T15, T18), ovs, &(xo[0]));
	       ST(&(xo[8]), VADD(T15, T18), ovs, &(xo[0]));
	       T19 = VADD(T13, T14);
	       T1a = VADD(T16, T17);
	       ST(&(xo[16]), VSUB(T19, T1a), ovs, &(xo[0]));
	       ST(&(xo[0]), VADD(T19, T1a), ovs, &(xo[0]));
	  }
	  {
	       V TV, T11, T10, T12, TR, TZ;
	       TR = VMUL(LDK(KP707106781), VSUB(TN, TQ));
	       TV = VBYI(VSUB(TR, TU));
	       T11 = VBYI(VADD(TU, TR));
	       TZ = VMUL(LDK(KP707106781), VADD(TN, TQ));
	       T10 = VSUB(TY, TZ);
	       T12 = VADD(TY, TZ);
	       ST(&(xo[12]), VADD(TV, T10), ovs, &(xo[0]));
	       ST(&(xo[28]), VSUB(T12, T11), ovs, &(xo[0]));
	       ST(&(xo[20]), VSUB(T10, TV), ovs, &(xo[0]));
	       ST(&(xo[4]), VADD(T11, T12), ovs, &(xo[0]));
	  }
	  {
	       V Tr, TB, TA, TC;
	       {
		    V Tf, Tq, Tw, Tz;
		    Tf = VSUB(T7, Te);
		    Tq = VSUB(Tm, Tp);
		    Tr = VBYI(VSUB(Tf, Tq));
		    TB = VBYI(VADD(Tq, Tf));
		    Tw = VSUB(Tu, Tv);
		    Tz = VSUB(Tx, Ty);
		    TA = VSUB(Tw, Tz);
		    TC = VADD(Tw, Tz);
	       }
	       ST(&(xo[10]), VADD(Tr, TA), ovs, &(xo[2]));
	       ST(&(xo[26]), VSUB(TC, TB), ovs, &(xo[2]));
	       ST(&(xo[22]), VSUB(TA, Tr), ovs, &(xo[2]));
	       ST(&(xo[6]), VADD(TB, TC), ovs, &(xo[2]));
	  }
	  {
	       V TF, TJ, TI, TK;
	       {
		    V TD, TE, TG, TH;
		    TD = VADD(Tu, Tv);
		    TE = VADD(T7, Te);
		    TF = VADD(TD, TE);
		    TJ = VSUB(TD, TE);
		    TG = VADD(Tp, Tm);
		    TH = VADD(Tx, Ty);
		    TI = VBYI(VADD(TG, TH));
		    TK = VBYI(VSUB(TH, TG));
	       }
	       ST(&(xo[30]), VSUB(TF, TI), ovs, &(xo[2]));
	       ST(&(xo[14]), VADD(TJ, TK), ovs, &(xo[2]));
	       ST(&(xo[2]), VADD(TF, TI), ovs, &(xo[2]));
	       ST(&(xo[18]), VSUB(TJ, TK), ovs, &(xo[2]));
	  }
     }
}

static void m2bv_16(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     int i;
     BEGIN_SIMD();
     for (i = 0; i < v; i += VL) {
	  m2bv_16_0(ii, io, is, ivs, ovs);
	  ii += VL * ivs;
	  io += VL * ovs;
     }
     END_SIMD();
}

static const kdft_desc desc = { 16, "m2bv_16", {68, 8, 4, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_m2bv_16) (planner *p) {
     X(kdft_register) (p, m2bv_16, &desc);
}
