/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:41:08 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_notw_noinline_c -simd -compact -variables 4 -n 16 -name m2fv_16 -with-ostride 2 -include n2f.h */

/*
 * This function contains 72 FP additions, 12 FP multiplications,
 * (or, 68 additions, 8 multiplications, 4 fused multiply/add),
 * 27 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_noinline_c.ml,v 1.1 2003/04/17 10:44:21 athena Exp $
 */

#include "n2f.h"

static void m2fv_16_0(const R *xi, R *xo, stride is, int ivs, int ovs)
{
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  V Tp, T13, Tu, TN, Tm, T14, Tv, TY, T7, T17, Ty, TT, Te, T16, Tx;
	  V TQ;
	  {
	       V Tn, To, TM, Ts, Tt, TL;
	       Tn = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
	       To = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
	       TM = VADD(Tn, To);
	       Ts = LD(&(xi[0]), ivs, &(xi[0]));
	       Tt = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
	       TL = VADD(Ts, Tt);
	       Tp = VSUB(Tn, To);
	       T13 = VADD(TL, TM);
	       Tu = VSUB(Ts, Tt);
	       TN = VSUB(TL, TM);
	  }
	  {
	       V Ti, TW, Tl, TX;
	       {
		    V Tg, Th, Tj, Tk;
		    Tg = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
		    Th = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Ti = VSUB(Tg, Th);
		    TW = VADD(Tg, Th);
		    Tj = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    Tk = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Tl = VSUB(Tj, Tk);
		    TX = VADD(Tj, Tk);
	       }
	       Tm = VMUL(LDK(KP707106781), VSUB(Ti, Tl));
	       T14 = VADD(TX, TW);
	       Tv = VMUL(LDK(KP707106781), VADD(Tl, Ti));
	       TY = VSUB(TW, TX);
	  }
	  {
	       V T3, TR, T6, TS;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    TR = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    TS = VADD(T4, T5);
	       }
	       T7 = VFNMS(LDK(KP923879532), T6, VMUL(LDK(KP382683432), T3));
	       T17 = VADD(TR, TS);
	       Ty = VFMA(LDK(KP923879532), T3, VMUL(LDK(KP382683432), T6));
	       TT = VSUB(TR, TS);
	  }
	  {
	       V Ta, TO, Td, TP;
	       {
		    V T8, T9, Tb, Tc;
		    T8 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T9 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    Ta = VSUB(T8, T9);
		    TO = VADD(T8, T9);
		    Tb = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    Tc = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TP = VADD(Tb, Tc);
	       }
	       Te = VFMA(LDK(KP382683432), Ta, VMUL(LDK(KP923879532), Td));
	       T16 = VADD(TO, TP);
	       Tx = VFNMS(LDK(KP382683432), Td, VMUL(LDK(KP923879532), Ta));
	       TQ = VSUB(TO, TP);
	  }
	  {
	       V T15, T18, T19, T1a;
	       T15 = VADD(T13, T14);
	       T18 = VADD(T16, T17);
	       ST(&(xo[16]), VSUB(T15, T18), ovs, &(xo[0]));
	       ST(&(xo[0]), VADD(T15, T18), ovs, &(xo[0]));
	       T19 = VSUB(T13, T14);
	       T1a = VBYI(VSUB(T17, T16));
	       ST(&(xo[24]), VSUB(T19, T1a), ovs, &(xo[0]));
	       ST(&(xo[8]), VADD(T19, T1a), ovs, &(xo[0]));
	  }
	  {
	       V TV, T11, T10, T12, TU, TZ;
	       TU = VMUL(LDK(KP707106781), VADD(TQ, TT));
	       TV = VADD(TN, TU);
	       T11 = VSUB(TN, TU);
	       TZ = VMUL(LDK(KP707106781), VSUB(TT, TQ));
	       T10 = VBYI(VADD(TY, TZ));
	       T12 = VBYI(VSUB(TZ, TY));
	       ST(&(xo[28]), VSUB(TV, T10), ovs, &(xo[0]));
	       ST(&(xo[12]), VADD(T11, T12), ovs, &(xo[0]));
	       ST(&(xo[4]), VADD(TV, T10), ovs, &(xo[0]));
	       ST(&(xo[20]), VSUB(T11, T12), ovs, &(xo[0]));
	  }
	  {
	       V Tr, TB, TA, TC;
	       {
		    V Tf, Tq, Tw, Tz;
		    Tf = VSUB(T7, Te);
		    Tq = VSUB(Tm, Tp);
		    Tr = VBYI(VSUB(Tf, Tq));
		    TB = VBYI(VADD(Tq, Tf));
		    Tw = VADD(Tu, Tv);
		    Tz = VADD(Tx, Ty);
		    TA = VSUB(Tw, Tz);
		    TC = VADD(Tw, Tz);
	       }
	       ST(&(xo[14]), VADD(Tr, TA), ovs, &(xo[2]));
	       ST(&(xo[30]), VSUB(TC, TB), ovs, &(xo[2]));
	       ST(&(xo[18]), VSUB(TA, Tr), ovs, &(xo[2]));
	       ST(&(xo[2]), VADD(TB, TC), ovs, &(xo[2]));
	  }
	  {
	       V TF, TJ, TI, TK;
	       {
		    V TD, TE, TG, TH;
		    TD = VSUB(Tu, Tv);
		    TE = VADD(Te, T7);
		    TF = VADD(TD, TE);
		    TJ = VSUB(TD, TE);
		    TG = VADD(Tp, Tm);
		    TH = VSUB(Ty, Tx);
		    TI = VBYI(VADD(TG, TH));
		    TK = VBYI(VSUB(TH, TG));
	       }
	       ST(&(xo[26]), VSUB(TF, TI), ovs, &(xo[2]));
	       ST(&(xo[10]), VADD(TJ, TK), ovs, &(xo[2]));
	       ST(&(xo[6]), VADD(TF, TI), ovs, &(xo[2]));
	       ST(&(xo[22]), VSUB(TJ, TK), ovs, &(xo[2]));
	  }
     }
}

static void m2fv_16(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     int i;
     BEGIN_SIMD();
     for (i = 0; i < v; i += VL) {
	  m2fv_16_0(ri, ro, is, ivs, ovs);
	  ri += VL * ivs;
	  ro += VL * ovs;
     }
     END_SIMD();
}

static const kdft_desc desc = { 16, "m2fv_16", {68, 8, 4, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_m2fv_16) (planner *p) {
     X(kdft_register) (p, m2fv_16, &desc);
}
