/*
 *	fhist - file history and comparison tools
 *	Copyright (C) 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate undo.cs
 */

#include <ac/unistd.h>

#include <mem.h>
#include <str.h>
#include <undo.h>


typedef struct list_t list_t;
struct list_t
{
    list_t          *next;
    string_ty       *path;
};

static list_t   *head_p;


void
undo(void)
{
    while (head_p)
    {
	list_t *lp = head_p;
	head_p = lp->next;

	/*
	 * Ignore any error.  They are usually ENOENT errors,
	 * indicating the the file is already gone.
	 */
	unlink(lp->path->str_text);

	str_free(lp->path);
	mem_free(lp);
    }
}


void
undo_unlink(const char *path)
{
    list_t          *lp;

    lp = mem_alloc(sizeof(list_t));
    lp->path = str_from_c(path);
    lp->next = head_p;
    head_p = lp;
}
