2001-01-24  Joseph S. Myers  <jsm28@cam.ac.uk>

	* cpp.1: Regenerate.

2001-01-24  Jakub Jelinek  <jakub@redhat.com>

	* cppfiles.c (_cpp_read_file): Add to dependencies if requested.
	* cppinit.c (cpp_start_read): Remove deps_add_dep call.
	* tradcpp.c (main): Add -imacros or -include'd dependencies
	for -M*.
	* cpp.texi (-M, -MM): Document -M -include behaviour.

2001-01-23  Chris Demetriou  <cgd@sibyte.com>
	    Neil Booth  <neil@daikokuya.demon.co.uk>

        * cpperror.c: Merge handlers of PEDWARN and WARNING.
        Have -Werror make pedantic warnings errors, like the
        rest of GCC.

2001-01-22  Alan Modra <alan@linuxcare.com.au>

        * cppexp.c (parse_charconst):  Change `mask' type to agree
        with parse_escape.

2001-01-20  Michael Sokolov  <msokolov@ivan.Harhan.ORG>

	* cppinit.c (INO_T_EQ): Don't use #elif, fix formatting.

2001-01-20  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cppmacro.c (funlike_invocation_p): Don't move back up to the
        context of the top of the stack.

2001-01-18  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cpplib.c (_cpp_handle_directive): Use buffer->was_skipping,
	not pfile->skipping (== 0).

2001-01-16  Alan Modra <alan@linuxcare.com.au>

	* cppmain.c (general_init): Don't use ANSI prototype.

2001-01-16  Tom Tromey  <tromey@redhat.com>

	* gcc.c (cpp_options): Added `*' to specs for -MF, -MQ, and -MT.

2001-01-14  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (cpp_cleanup): Rename cpp_destroy for clarity.
	Return the number of errors encountered.
	* cpplib.h (cpp_cleanup): Rename cpp_destroy, return int.
	* cppmain.c (main): Don't call cpp_destroy.

2001-01-14  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppmain.c (do_preprocessing): New function; most of the old
	main.
	(main): Call it to do most of the work.
	(cb): Move from global scope to set_callbacks ().
	(setup_callbacks): Get the callback pointer.
	(general_init, printer_init): Clean up code and comments.

2001-01-13  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppfiles.c (_cpp_fake_include): New function.
	* cpphash.h (_cpp_fake_include): New.
	* cpplib.c (do_line): Call _cpp_fake_include when entering
	header files in preprocessed input.
	* cppmain.c (cb_pragma_implementation): Remove handling.
	(setup_callbacks): Don't register pragmas.

2001-01-13  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cpplib.h (cpp_pool, mi_state, mi_ind, struct cpp_macro,
	struct cpp_chunk, struct htab, struct toklist,
	struct cpp_context, CPP_STACK_MAX, struct lexer_state,
	struct spec_nodes, struct cpp_reader, CPP_OPTION, CPP_BUFFER,
	CPP_BUF_LINE, CPP_BUF_COL, CPP_BUF_COLUMN, U, ustrcmp, ustrncmp,
	ustrlen, uxstrdup, ustrchr, ufputs): Move to cpphash.h.
	(struct macro_args): Delete.
	* cpphash.h: See above.

2001-01-13  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppmain.c (struct printer): Remove no_line_dirs.
	(options, cb): New.
	(main, setup_callbacks, scan_buffer, printer_init, cb_define)
	: Use options rather than CPP_OPTION.
	(setup_callbacks): Use cb rather than pfile->cb.
	(main): No need to check for a buffer.  Use cpp_errors.
	(printer_init): Don't set no_line_dirs.
	(maybe_print_line): Use options not no_line_dirs.
	(cb_file_change): Don't call print_line if -P.

2001-01-13  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (cpp_handle_option): help_only is now part of the
	cpp_options structure.
	* cpplib.c (cpp_errors, cpp_get_options, cpp_get_callbacks,
	cpp_set_callbacks): New functions.
	* cpplib.h (cpp_callbacks): Break out as a named structure.
	(cpp_options): Move help_only here from cpp_reader.
	(CPP_FATAL_ERRORS): Update to use cpp_errors.
	(cpp_errors, cpp_get_options, cpp_get_callbacks,
	cpp_set_callbacks): New prototypes.
	* cppmain.c (main): Update for help_only.

2001-01-11  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (do_includes): Fix typo.

2001-01-11  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppspec.c (DEFAULT_WORD_SWITCH_TAKES_ARG): Add -MQ.

2001-01-11  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (cpp_start_read): If -fpreprocessed, ignore
	-D, -U and -A, and don't initialize the builtins.
	(do_includes): Error if -include or -imacros with -fpreprocessed.
	* cppmain.c (cb_define, cb_undef): Unconditionally process
	the callback.
	* tradcpp.c (main): Fix typo.

2000-01-11  Mark Elbrecht  <snowball3@bigfoot.com>

	 * cppfiles.c (cpp_included, find_include_file, _cpp_execute_include)
	   (read_name_map): Use IS_ABSOLUTE_PATH.
	 * tradcpp.c (get_filename): Likewise.

2001-01-10  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (cpp_start_read): Update comment, remove unneeded
	if statement.
	* tradcpp.c: Include mkdeps.h.
	(deps, print_deps_phony_targets, deps_append, output_deps,
	init_dependency_output, output_deps): New.
	(deps_buffer, deps_allocated_size, deps_size, deps_column,
	deps_output): Delete.
	(print_deps_missing_files): Rename deps_missing_files.
	(inhibit_output): Make global.
	(main): Delete inhibit_output, deps_stream, deps_target.
	Use mkdeps functionality in the same way as cpplib.  Remove
	-g3 handling.  Handle -MF, -MP, -MQ, -MT.  Update handling of
	-M and -MM.  Remove old handling of deps via deps_out, and
	old reading of environment variables.
	(get_filename): Update to use deps_add_dep.

2001-01-10  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (OPT_g): Remove.
	(cpp_handle_option): Update for removed -g3.
	(print_help): Update.
	* cpplib.h (struct cpp_options): Remove debug_output.
	* cppmain.c (setup_callbacks, cb_define): Update.
	* gcc.c (cpp_options): Translate -g3 to -dD.

2001-01-09  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (OPT_MD, OPT_MMD): Restore.
	(cpp_handle_option): Handle them.
	(cpp_post_options): Ensure one of -M or -MM is specified with
	any other -M? option.
	(init_dependency_output): Suppress output with -MG.

20001-01-09  Graham Stott  <grahams@redhat.com>

	* cppfiles.c (_cpp_execute_include): Move `len` initialisation
	after `ptr` is initialised.

2001-01-09  Alexandre Oliva  <aoliva@redhat.com>

	* cppinit.c (cpp_cleanup): NULLify macro_buffer and zero
	macro_buffer_len.
	* cppmacro.c (cpp_macro_definition): Reset macro_buffer_len when
	realloc()ing macro_buffer.

2001-01-08  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (init): Rename init_library.
	(cpp_create_reader): Update.
	* gcc.c (cpp_options): If -o given, use it as the target of
	any -M options.

2001-01-07  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppmain.c (main): Similarly.
	* cppinit.c (cpp_start_read): Move option consistency checks
	to cpp_post_options.  Don't call init_dependency_output.
	If needed, add default target and main file dependency.
	(OPT_MD, OPT_MMD): Remove.
	(OPT_MF): New.
	(cpp_handle_option): Update for OPT_* changes.
	(cpp_post_options): New.
	(init_dependency_output): Command line -MF overrides environment
	variables.  Don't set default target etc.  Suppress output
	if dependencies are going to stdout.
	(print_help): Update.
	* cpplib.h (cpp_post_options): New.
	* gcc.c (cpp_options): Update for -MD, -MMD, -MF.

2001-01-07  Neil Booth  <neil@daikokuya.demon.co.uk>

	* (initialize, initialize_builtins,
	initialize_dependency_output, initialize_standard_includes):
	Rename s/initialize/init. Update.
	(init_dependency_output): Move to after
	cpp_handle_options, the correct location temporally at least.
	(opt_comp): Move next to init (), its caller.  Fix prototype.
	(init): Make "initialized" local scope.
	(cpp_create_reader): Always call init ().
	(cpp_start_read): Update.
	(output_deps): New function, broken out of cpp_finish.
	(cpp_finish): Break out output_deps.

2001-01-05  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (cpp_create_reader): Always create pfile->deps.
	(cpp_cleanup): Always free pfile->deps.
	(initialize_dependency_output): Don't create pfile->deps.
	(cpp_handle_option): Similarly.
	(OPT_MQ): New.
	* gcc.c (cpp_options): Handle -MQ.
	(DEFAULT_WORD_SWITCH_TAKES_ARG): Add -MQ.
	* mkdeps.c (base_name): Remove.
	(deps_init): Don't allocate vector space until it's needed.
	(deps_free): Only free vectors if allocated.
	(deps_add_target, deps_add_dep): Update for initial allocation.
	(deps_add_default_target): Don't strip to the base_name.

2001-01-05  Zack Weinberg  <zack@wolery.stanford.edu>

	* cpplib.h (struct cpp_reader): Add help_only field.
	* cppinit.c (COMMAND_LINE_OPTIONS): Add OPT_version.
	(cpp_handle_option): Set pfile->help_only if we see -h,
	--help, -target-help, or --version.  Print version string but
	do not set help_only if we see -v or -version.  Make text
	printed by -v match that printed by (-)-version.

	* cppmain.c (main): Exit after option parsing if
	pfile->help_only is true.

2001-01-05  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (initialize_dependency_output):  Update.
	(cpp_finish): Output dummy targets for -MP.
	(OPT_MP): New.
	(cpp_handle_option): Handle -MP.  Don't quote -MT options.
	* cpplib.h (struct cpp_options): Add deps_phony_targets.
	* gcc.c (cpp_options): Update to handle -MP.
	* mkdeps.c (deps_add_target, deps_add_default_target): Update
	to quote only the default target.
	(deps_phony_targets): Insert a preceding newline.  Rename from
	deps_dummy_targets for consistency.
	* mkdeps.h: Update

2001-01-04  Jakub Jelinek  <jakub@redhat.com>

	* tradcpp.c (deps_file, print_deps_missing_files): New variables.
	(main): Handle -MG, -MD, -MMD.  Bail out if -MG is given without -M
	or -MM.
	(do_include): Handle missing headers like cpp0.
	* cppfiles.c (_cpp_execute_include): Don't prefix absolute header
	paths with first include pathname.  Don't strcat to uninitialized
	string.

2001-01-04  Neil Booth  <neil@daikokuya.demon.co.uk>

	* cppinit.c (initialize_dependency_output): Add a default
	target if none has been given already.
	(no_tgt, OPT_MT): New.
	(cpp_handle_option): Handle -MT.  Update -M etc.
	* cpplib.h (struct cpp_options): Remove deps_target.
	* gcc.c (cpp_options): Handle -MT.
	* mkdeps.c (struct deps): Move from mkdeps.h.
	(deps_calc_target): Rename deps_add_default_target.  Add a
	default target if none has been specified already.
	* mkdeps.h (struct deps): Move to mkdeps.c.
	(deps_calc_target): Rename deps_add_default_target.

2001-01-03  Franz Sirl  <Franz.Sirl-kernel@lauterbach.com>

	* tradcpp.c (main): Make sure finclude() is called with a valid
	indepth value while handling -include.

2000-12-18  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cppmain.c: Update print.lineno with -P.

2000-12-18  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cpplib.h: s/change_file/file_change
        * cppmain.c: Similarly.
        * cppfiles.c (stack_include_file): Pass the buffer location and
        size to cpp_push_buffer.  Generate the file_change callback,
        so that sysp is already set.
        * cpphash.h: Add _cpp_do_file_change.
        * cpplib.c (do_line): Set buffer->sysp directly. Generate the
        file_change callback after setting sysp.
        (_cpp_do_file_change): Handle FC_ENTER and the FC_RENAME exception
        here.
        (cpp_push_buffer): Don't generate a callback.  Clear sysp.
        (cpp_pop_buffer): Clean up logic.

2000-12-18  Benjamin Kosnik  <bkoz@redhat.com>

	* cppdefault.c (GPLUSPLUS_TOOL_INCLUDE_DIR): Add search path.

2000-12-17  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cpplib.h (struct cpp_reader): Remove references to string_pool
        and temp_string_pool.
        * cppinit.c (cpp_create_reader, cpp_cleanup): Similarly; using
        ident_pool in place.
        * cpplex.c (parse_number, unescaped_terminator_p, parse_string,
        save_comment, cpp_token_as_text): Similarly.
        * cpplib.c (do_define, glue_header_name, parse_assertion): Similarly.
        * cppmacro.c (make_number_token, builtin_macro, lock_pools,
        unlock_pools, stringify_arg, paste_tokens): Similarly.

2000-12-17  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cppmain.c (check_multiline_token): New function.
        (scan_buffer): Use it.
        (cb_change_file): Restructure to avoid warning.
        * cpperror.c (print_location): Initialize col.

2000-12-14  Philipp Thomas  <pthomas@suse.de>

	* cppmain.c (general_init): Correctly set locale categories.

2000-12-17  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cpperror.c (print_containing_files): Get right line number.
        (print_location): Output column of 1 if 0.
        * cppfiles.c (stack_include_file): cpp_push_buffer handles
        the callback.
        * cpphash.h (_cpp_do_file_change): No longer external.
        * cpplib.c (do_file_change): Now local to cpplib.c.
        (do_line): Fake a buffer stack for preprocessed files.
        (cpp_push_buffer): Create a file_change callback.  Handle faked
        buffers.
        (cpp_pop_buffer): Similarly.
        * cpplib.h: BUF_FAKE: New buffer type.
        * cppmain.c: Update to handle correct file renaming where a
        #line is the first line of the main file, and produce only
        the renamed file, not the original file, as output.

2000-12-16  Neil Booth  <neil@daikokuya.demon.co.uk>

        * tradcpp.c: T_WARNING: New.
        (do_warning): New function.
        (finclude): Skip past the newline and increase the line number
        before calling output_line_command.
        (do_line): Skip the new line after output_line_command.  Don't
        pre-decrement the line number.

2000-12-15  Jakub Jelinek  <jakub@redhat.com>

	* gcc.c (cpp_options): Pass -fno-operator-names.
	* cpplib.h (struct cpp_options): Add operator_names.
	* cppinit.c (cpp_create_reader): Initialize it.
	(initialize_builtins): If -fno-operator-names, don't add
	C++ alternate operator names.
	(COMMAND_LINE_OPTIONS): Add -fno-operator-names.
	(cpp_handle_option): Clear operator_names.

2000-12-14  Zack Weinberg  <zack@wolery.stanford.edu>

	* cppfiles.c (hack_vms_include_specification): Delete function
	(not used since 1998).

2000-12-14  Neil Booth  <neil@daikokuya.demon.co.uk>

	* gcc.c (cpp_options): Add -remap.

2000-12-13  Neil Booth  <neil@daikokuya.demon.co.uk>

        * tradcpp.c (special_symbol): Improve test for definedness,
        though it is still not perfect.
        (do_define): Don't define illegal macro names.

2000-12-13  Neil Booth  <neil@daikokuya.demon.co.uk>

        * cppfiles.c (read_name_map): Return null if open () fails.
        (remap_filename): Simplify logic.  Add ICE if it doesn't work
        as expected. Perform secondary lookup attempt on base filename
        only.

2000-12-12  Brad Lucier <lucier@math.purdue.edu>

        * tradcpp.c (do_error): Cast difference of pointers to int
        for error message.

2000-12-12  Neil Booth  <neil@daikokuya.demon.co.uk>

        * tradcpp.c (enum node_type): Add T_ERROR.
        (do_error): New function.
        (directive_table): Add #error handler.

2000-12-11  Neil Booth  <neilb@earthling.net>

	* tradcpp.h: For tradcpp, NUL is not whitespace.

2000-12-11  Neil Booth  <neilb@earthling.net>

	* cpperror.c (print_location): New function.
	(print_containing_files): Simplify.
	(_cpp_begin_message): Simplify and use print_location.
	* cppfiles.c (stack_include_file): Update.
	(_cpp_pop_file_buffer): Update.
	* cpphash.h (struct cpp_buffer): New members
	include_stack_listed and type.
	* cpplib.c (_cpp_handle_directive): Buffer->inc is not null.
	(run_directive): Take buffer type.  cpp_push_buffer cannot fail.
	(_cpp_do__Pragma, cpp_define, _cpp_define_builtin, cpp_undef,
	handle_assertion): Update.
	(cpp_push_buffer): Take a buffer type and file name.
	(cpp_pop_buffer): Update.  Clear include_stack_listed.
	* cpplib.h (input_stack_listing_current): Remove.
	(enum cpp_buffer_type): New.
	(cpp_push_buffer): New prototype.
	* cppmacro.c (builtin_macro): Simplify; buffer cannot be null.

22000-12-09  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (NEVER_REREAD, DO_NOT_REREAD): Move from cpphash.h.
	* cpphash.h (NEVER_REREAD, DO_NOT_REREAD, ABSOLUTE_PATH): Delete.
	* cpplex.c (parse_identifier): Improve diagnostic.
	(_cpp_lex_token): Return unconditionally at the end of a directive.
	* cpplib.c (read_flag): Verify legality of each flag.
	(end_directive): Resotre pfile->skipping before skip_rest_of_line.
	(do_line): Use the new read_flag.
	* cppmacro.c (struct cpp_macro, parse_arg, replace_args,
	check_macro_redefinition, parse_params): Rename var_args to
	variadic.

2000-12-08  Brad Lucier <lucier@math.purdue.edu>

	* tradcpp.c (do_include): Make pointer differences 64-bit clean.

2000-12-07  Zack Weinberg  <zack@wolery.stanford.edu>

	* Makefile.in (HOST_RTL): Add safe-ctype.o.
	(safe-ctype.o): New rule.
	* system.h: Include safe-ctype.h, not ctype.h.  No need to
	wrap ctype macros.

	* cpphash.h: Zap IStable and related macros.  Define is_* in
	terms of safe-ctype.h macros.
	* cppinit.c: Delete the IStable and all related code.

	* tradcpp.c: Delete is_idchar, is_idstart, is_hor_space, and
	is_space arrays.  Delete initialize_char_syntax.  Change all
	references to the above arrays to use macros instead.
	* tradcpp.h: Define is_idchar, is_idstart, is_space, and
	is_nvspace in terms of safe_ctype.h's macros.
	* tradcif.y: is_idchar, is_idstart are macros not arrays.

2000-12-07  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (struct include_file): Move from cpphash.h.
	(_cpp_never_reread): New function.
	(open_file, read_include_file): Use it.
	(stack_include_file): Set the buffer's sysp according to the
	path in which the file was found.
	(find_include_file): Don't set sysp.
	(cpp_make_system_header, actual_directory): Update.
	(_cpp_execute_include): Do #include_next lookup handling here,
	not in cpplib.c.  Use _cpp_never_reread.
	* cpphash.h (struct_include_file): Remove.
	(struct cpp_buffer): New member sysp.
	(CPP_IN_SYSTEM_HEADER, _cpp_execute_include): Update.
	(_cpp_never_reread): New.
	* cpplib.c (read_line_number): Rename read_flag.  Rework slightly.
	(end_directive): Clear line_extension flag.
	(_cpp_handle_directive): Set line_extension flag for #number.
	(do_include_next): Handle path lookup in _cpp_execute_include.
	(do_line): Cleanup to use read_flag.  Don't allow flags in #line.
	(_cpp_do_file_change): Update.
	(do_pragma_once): Use cpp_never_reread.  Clean up.
	* cpplib.h (struct lexer_state): New member line_extension.

2000-12-07  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (_cpp_fake_include): Remove.
	* cpphash.h: Similarly.
	* cpplib.c (do_line): Don't call _cpp_fake_include.  A valid
	#line always creates a callback; FC_RENAME if there are no
	#line flags.

2000-12-06  Rodney Brown  <RodneyBrown@mynd.com>

	* cpplib.h cppexp.c: Standarize copyright statement.

2000-12-06  Sylvain Pion  <Sylvain.Pion@sophia.inria.fr>

	* cpplex.c (skip_escaped_newlines): Don't warn for spaces between
	backslash and newline, when inside a comment.

2000-12-05  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (stack_include_file): Push zero-length buffers
	in case of failure.  Return void, as we don't fail any more.
	(read_include_file): Check for files we shouldn't re-read.
	Don't return an error code; errors are implied by marking the
	file NEVER_REREAD.
	(_cpp_execute_include): Move the recursion and in-macro checks
	here.  Update for stack_include_file not failing.
	* cpplib.c (cpp_push_buffer): Always succeed, since
	_cpp_execute_include performs the recursion check.  Tidy up.
	* cpplib.h (cpp_push_buffer): Update prototype.

2000-12-04  Neil Booth  <neilb@earthling.net>

	* tradcif.y: Move lexptr to top of file.  Add rule to handle
	assertions in conditional expressions.
	* tradcpp.c (parse_answer): Assertions do not need to go to
	end of line in conditional directives.
	(parse_assertion): Get first character of identifiers correct.
	(test_assertion): New function.
	* tradcpp.h (test_assertion): New prototype.

2000-12-04  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (cpp_make_system_header): Take 2 booleans,
	and operate on current buffer.
	(cpp_read_file): Rename _cpp_read_file.
	* cpplib.c (do_line, do_pragma_system_header): Update calls to
	cpp_make_system_header.
	* fix-header.c: Similarly.
	* cpphash.h (_cpp_read_file): Move from...
	* cpplib.h: ... here.
	* cppinit.c (do_includes, cpp_start_read): Update appropriately.

2000-12-03  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (funlike_invocation_p): Re-disable macros enabled
	by contexts drops AFTER argument pre-expansion, so that they
	remain enabled during argument pre-expansion.
	(_cpp_pop_context): Unconditionally re-enable a macro when
	dropping a context level.

2000-12-02  Geoffrey Keating  <geoffk@redhat.com>

	* cpplib.c (do_ifdef): Add check_eol() call.
	(do_ifndef): Likewise.

2000-12-02  Neil Booth  <neilb@earthling.net>

	* tradcpp.c (struct answer, parse_assertion, parse_answer,
	canonicalize_text, find_answer): New.
	(do_assert, do_unassert): Provide appropriate function bodies.
	(union hashval): New member answers.

2000-12-02  Neil Booth  <neilb@earthling.net>

	* cppexp.c (parse_number): Update diagnostic test.

2000-12-01  Neil Booth  <neilb@earthling.net>

	* cppinit.c (initialize): Forgotten prototype.
	* cpplex.c (_cpp_lex_token): Loop until not skipping.
	Always clear PREV_WHITE upon meeting a new line.
	* cpplib.c (end_directive): Set pfile->skipping after
	skip_rest_of_line.
	* cpplib.h (cpp_reader): Remove macro_pos.
	* cppmacro.c (cpp_get_line): Don't do anything special inside
	macros.
	(parse_arg): Add PREV_WHITE if a token appears after new lines.
	(funlike_invocation_p): Save and restore the output position
	over a successful check for a '('.
	(enter_macro_context): Delete uses of macro_pos.
	(cpp_get_token): Don't use pfile->skipping.

2000-11-28  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (cpp_scan_buffer_nooutput): Take a boolean
	indicating whether to scan all buffers on the stack or
	just one.
	* cppinit.c (do_includes): Update.
	* cppmain.c (main): Update.
	* cpplib.h: Update prototype.

2000-11-28  Neil Booth  <neilb@earthling.net>

	* cppinit.c (cpp_init): Rename initialize.
	(cpp_reader_init): Rename cpp_create_reader.  Create the
	reader.  Initialize cpplib if appropriate.
	* cpplib.h (cpp_create_reader) New prototype.
	(cpp_init, cpp_reader_init): Delete prototypes.
	* cppmain.c (general_init, setup_callbacks): New functions.
	(main): Use them.
	* fix-header.c (scan_in): Change type to cpp_reader *.
	(read_scan_file): Update for new cpplib interface and scan_in type.

2000-11-28  Neil Booth  <neilb@earthling.net>

	* tradcpp.c (enum node_type): New hash types T_ASSERT, T_UNASSERT.
	(struct directive): Drop 4th argument from handlers.
	(do_define, do_line, do_include, do_undef, do_else, do_elif,
	do_endif): Similarly.
	(do_assert, do_unassert, do_ifdef, do_ifndef): New handlers.
	(do_ifxdef): Update as common handler of do_ifdef and do_ifndef.
	(make_definition, make_undef): Take a const char*.
	(make_assertion): New function.
	(struct directive_table): Update.
	(main): Handle -A command line argument.
	(handle_directive): Drop fourth handler argument.

2000-11-27  Neil Booth  <neilb@earthling.net>

	* cppinit.c (cpp_reader_init): Remove handling of warn_paste
	command line options.
	(cpp_handle_option): Similarly.
	* cpplib.h (struct cpp_options): Remove warn_paste.
	* cppmacro.c (paste_tokens): Apart from assembler, make
	unpasteable token warning mandatory.

2000-11-27  Neil Booth  <neilb@earthling.net>

	* tradcpp.c (enum pending_dir_t, struct pending_dir): New.
	(main): Allocate a pending directive set of these.  Use it.
	Merge handling of -D and -U.  Update handling of pending
	directives.  Free the memory after use.

2000-11-27  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (stack_include_file): Use _cpp_do_file_change.
	(cpp_syshdr_flags): Delete.
	* cpphash.h (_cpp_do_file_change): New prototype.
	Move struct cpp_buffer here from...
	* cpplib.h (struct cpp_buffer): ... here.
	(enum cpp_fc_reason, struct cpp_file_loc,
	struct_cpp_file_change, change_file): New.
	(enter_file, leave_file, rename_file, cpp_syshdr_flags): Delete.
	* cpplib.c (do_line): Update for new cb_change_file callback.
	(_cpp_do_file_change): New function.
	(_cpp_pop_buffer): Update to use it.
	* cppmain.c (move_printer): Delete.
	(main): Set up single callback cb_change_file.
	(cb_enter_file, cb_leave_file, cb_rename_file): Delete.
	(cb_change_file): New.

2000-11-26  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (cpp_scan_buffer_nooutput): Only scan the
	current buffer.

2000-11-26  Neil Booth	<neilb@earthling.net>

	* cpplib.h (struct cpp_reader): Remove lang_asm.
	(struct cpp_options): Remove c89. New members lang,
	extended_numbers.
	* cppexp.c (parse_number): Use them.
	* cpphash.h (VALID_SIGN): Use them.
	* cppinit.c (set_lang, cpp_start_read): Update.
	* cpplex.c (parse_string, _cpp_lex_token): Update.
	* cpplib.c (_cpp_handle_directive): Update.
	* cppmacro.c (parse_args): Update.
	* cppmain.c (scan_buffer): Update.

Sun Nov 26 10:02:37 2000  Richard Kenner  <kenner@vlsi1.ultra.nyu.edu>

	* fold-const.c (fold, case CONVERT_EXPR): Always return tree of
	proper type.

2000-11-26  Neil Booth	<neilb@earthling.net>

	* cppinit.c: Call set_lang after allocating pfile->pending.

2000-11-22  Neil Booth  <neilb@earthling.net>

	* cpplex.c (trigraph_ok): Ensure we don't warn twice.
	* cpplib.h (struct cpp_buffer): New member last_Wtrigraphs.

2000-11-21  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* tradcpp.c (output_line_command): Mark system headers as such in
	`line' commands.

2000-11-20  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (paste_tokens): Rename from paste_payloads.
	Change token type after pasting spellings.
	(paste_all_tokens): Use it.
	* gcc.dg/cpp/paste2.c: Update test.

2000-11-20  Neil Booth  <neilb@earthling.net>

	* cppmain.c (main): Update call to cpp_reader_init.
	* cppexp.c (parse_number): Only warn for unextended C89.
	* cppinit.c (set_lang): New function.
	(cpp_reader_init): Take a LANG argument and pass it to set_lang.
	(COMMAND_LINE_OPTIONS): New option std=c++98.
	(cpp_handle_option): Use set_lang.
	* cpplex.c (_cpp_lex_token): Warn pedantically if not C99.
	* cppib.h (enum_c_lang): New enumeration.  Update comments.

2000-11-19  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* cppmacro.c (builtin_macro): Avoid needlessly casting away
	const-ness.
	* tradcpp.c (rescan, do_line, macroexpand, macarg): Use
	ISALNUM/ISDIGIT/ISPRINT, not isalnum/isdigit/isprint.

2000-11-18  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* Makefile.in (tradcpp.o, tradcif.o): Depend on tradcpp.h.

	* tradcif.y: Include tradcpp.h.  Constify.  Make functions static.
	Move extern function declarations to tradcpp.h.

	* tradcpp.c: Likewise.

	* tradcpp.h: New file.

2000-11-18  Neil Booth  <neilb@earthling.net>

	* cppinit.c: Update comments.
	(cpp_reader_init): Make -imacro and -include use the standard
	#include "" search path.
	(do_includes): New function.

2000-11-17  Neil Booth  <neilb@earthling.net>

	* cpperror.c (print_file_and_line): Don't display line number if 0.

2000-11-16  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* cpplib.c (glue_header_name): Call xmalloc/xrealloc, not
	malloc/realloc.

	* mkdeps.c (munge): Likewise.

2000-11-15  Neil Booth  <neilb@earthling.net>

	* cpplib.c (start_directive, end_directive): New functions.
	(_cpp_handle_directive, run_directive): Use them.
	(_cpp_handle_directive): Don't -Wtraditional on indented
	null directives.
	(_cpp_push_buffer): Don't re-clear was_skipping.
	* cpplib.h (struct cpp_reader): New member la_saved.
	* cppmacro.c (cpp_get_token): Don't interpret _Pragma in
	directives.

	gcc.dg/cpp/_Pragma1.c: Update.
	gcc.dg/cpp/_Pragma2.c: New test.

2000-11-14  Neil Booth  <neilb@earthling.net>

	* cppexp.c (parse_defined): Call cpp_get_token not
	_cpp_get_token.
	(lex): Similarly.
	* cpplex.c (cpp_output_line): Similarly.
	* cpplib.c (glue_header_name, do_line, do_ident,
	parse_answer, parse_assertion): Similarly.
	(_cpp_handle_diretive): Don't save to lookaheads
	when processing directives.
	* cppmacro.c (parse_arg, expand_arg): Call cpp_get_token not
	_cpp_get_token.
	(funlike_invocation_p): Don't save to lookaheads
	when pre-expanding arguments.
	(_cpp_get_token): Delete.
	(cpp_get_token): Merge contents of _cpp_get_token.

2000-11-14  Zack Weinberg  <zack@wolery.stanford.edu>

	* tradcpp.c, tradcif.y: Update FSF mailing address, delete
	reference to GPLv1.

2000-11-13  Neil Booth  <neilb@earthling.net>

	* cpplex.c (_cpp_lex_token): CPP_COMMENT and true CPP_EOF
	cases return without MI check.
	* cpplib.c (do_diagnostic): Take boolean of whether to
	print the directive name.
	(do_error, do_warning): Update.
	(do_pragma_dependency): Use it.
	* cpplib.h (VARARGS_FIRST): Delete.
	(struct cpp_token): Delete integer.
	* cppmacro.c (enter_macro_context): Move disabled check
	to _cpp_get_token.
	(_cpp_get_token): Simplify into a single loop.

2000-11-13  Joseph S. Myers  <jsm28@cam.ac.uk>

	* tradcpp.c (v_message, warning, error, fatal, error_with_line):
	Add ATTRIBUTE_PRINTF*.

2000-11-12  Neil Booth  <neilb@earthling.net>

	* cppexp.c: Don't worry about pfile->skipping.
	* cpplib.c (struct if_stack): Make was_skipping unsigned char.
	(cpp_handle_directive): Save pfile->skipping in struct cpp_buffer
	for handled directives.
	(skip_rest_of_line): Use _cpp_lex_token after popping contexts
	and releasing lookaheads.
	(do_ifdef, do_ifndef, do_if): Use buffer->was_skipping.
	(do_else, do_elif, push_conditional): Update logic.
	(do_endif): Set buffer->was_skipping rather than pfile->skipping.
	(unwind_if_stack): Inline into cpp_pop_buffer.
	(cpp_push_buffer): Clear ifs->was_skipping for cpp_handle_directive.
	* cpplex.c (_cpp_lex_token): Clear skipping on EOF.  Handle
	multiple-include optimisation.
	* cpplib.h (struct cpp_buffer): New member was_skipping.
	* cppmacro.c (_cpp_get_token): Loop whilst pfile->skipping.  This
	works because skipping == 0 in directives.
	(_cpp_release_lookahead): Renamed from release_lookahead.
	(cpp_get_token): No need to check skipping as _cpp_get_token does
	this for us.  No need to handle MI optimisation.

2000-11-11  Neil Booth  <neilb@earthling.net>

	Remove CPP_PLACEMARKERs.

	* cppexp.c (lex): Don't handle CPP_PLACEMARKER.
	* cpplex.c (_cpp_lex_token): Rename skip_newlines to next_bol
	* cpplib.c (skip_rest_of_line, check_eol, cpp_push_buffer):
		   Similarly.
	* cpplib.h: Remove CPP_PLACEMARKER.
	(struct lexer_state): Rename skip_newlines to next_bol.
	* cppmacro.c (stringify_arg): Don't handle CPP_PLACEMARKER.
	Simplify prev_white handling as a result.
	(paste_all_tokens): Don't worry about CPP_PLACEMARKERs.
	(parse_arg): Empty arguments are now empty, not CPP_PLACEMARKERs.
	(parse_args): Similarly.  Update argument count tests.
	(enter_macro_context): Return 2 to indicate an empty macro.
	(replace_args): Don't bother pre-expanding an empty argument.
	Handle placemarkers and ## extension during pre-expansion.
	(cpp_get_token): Handle empty macro expansions.  Don't worry
	about CPP_PLACEMARKERs.
	(_cpp_create_definition): Empty macros are now empty.
	(cpp_macro_defintion): Don't special case empty macros.

2000-11-09  Neil Booth  <neilb@earthling.net>

	* cpphash.c: Move cpp_defined here from cpplib.c.
	* cpplib.c: Update comments, move cpp_defined to cpphash.c.
	* cpplex.c (_cpp_lex_token): Don't leave the lexer at EOL.
	* cppmacro.c (cpp_get_token): Update comments, no need now
	to catch the CPP_EOF meaning EOL case.

2000-11-08  Neil Booth  <neilb@earthling.net>

	Move directive handling into the lexer itself.

	* cpplex.c (_cpp_lex_token): Handle directives directly.
	In the case of a directive interrupting a function-like
	macro invocation, use extra_char since read_ahead is
	used to store the '#'.  Return a CPP_EOF in this case.
	* cppmacro.c (parse_arg): No need to handle CPP_DHASH any more.
	(cpp_get_token): Don't handle directives here.
	* cpplib.h: Remove CPP_DHASH token type.

2000-11-06  Neil Booth  <neilb@earthling.net>

	* tradcpp.c (special_symbol): Assign an null string rather
	than writing to an unallocated buffer.

2000-11-06  Neil Booth  <neilb@earthling.net>

	* cpplex.c (_cpp_equiv_tokens): Check arg_no in the
	CPP_MACRO_ARG case.

2000-11-06  Neil Booth  <neilb@earthling.net>

	* cppexp.c (lex): Replace tok.val.aux with tok.val.c or
	tok.val.arg_no as appropriate.
	* cpplex.c (_cpp_lex_token, cpp_spell_token, cpp_output_token,
	cpp_equiv_tokens, cpp_can_paste, cpp_avoid_paste): Similarly.
	* cppmacro.c (stringify_arg, replace_args, lex_expansion_token,
	cpp_macro_definition): Similarly.
	* cpplib.h (struct cpp_token): Replace aux with c and arg_no.

2000-11-04  Neil Booth  <neilb@earthling.net>

	* cpplex.c (parse_string): Don't allow multiline strings in
	#include family directives.

2000-11-04  Neil Booth  <neilb@earthling.net>

	* cpplib.c (do_line): Only warn pedantically if not reading
	preprocessed input.

2000-11-03  Nathan Sidwell  <nathan@codesourcery.com>

	* cppfiles.c (open_file): If already read, then don't reopen.
	Immediately close an empty file.

2000-11-01  Neil Booth  <neilb@earthling.net>

	* cpplib.c (run_directive): Use correct line number for output
	of _Pragma.  Remember any in-progress directive.

	* gcc.dg/cpp/vararg2.c, gcc.dg/cpp/_Pragm1.c: New tests.

2000-11-01  Richard Henderson  <rth@redhat.com>

	* cppmain.c (scan_buffer): Don't avoid paste for assembly.

2000-11-01  Neil Booth  <neilb@earthling.net>

	* cpplex.c (_cpp_lex_token): Backslashes are now CPP_OTHER.
	* cppmacro.c (stringify_arg): Similarly.
	* cpplib.h (CPP_BACKSLASH): Delete.

2000-10-31  Neil Booth  <neilb@earthling.net>

	* cpplib.c (cpp_define): Simplify a bit.
	(cpp_assert, cpp_unassert): Use handle_assertion.
	(handle_assertion): New function; accept new command line
	syntax with '='.
	* testsuite/gcc.dg/cpp/assert3.c: New tests.

2000-10-31  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (STDC_0_IN_SYSTEM_HEADERS): Define to 0 if
	undefined.  Remove #ifdef check.

2000-10-30  Neil Booth  <neilb@earthling.net>

	* cppfiles.c (stack_include_file): Check for stacked contexts
	here.
	* cpphash.h (_cpp_do__Pragma): New prototype.
	* cppinit.c (cpp_reader_init): Add _Pragma keyword to hash table.

	* cpplex.c (skip_escaped_newlines): Only process trigraphs and
	escaped newlines if !(buffer->from_stage3).
	(_cpp_lex_token): Warn about missing newlines iff
	!buffer->from_stage3.

	* cpplib.c (get__Pragma_string, destringize,
	_cpp_do__Pragma): New functions.
	(run_directive): Set output_line for _Pragma to avoid line
	markers in output.  Set from_stage3 and prevent macro expansion
	for _Pragma and command-line options.  Check buffer exhaustion.
	(cpp_push_buffer): Don't check for stacked macro contexts, as
	this is perfectly legitimate for _Pragma.  Move the check to
	stack_include_file instead. Set from_stage3 iff buffer is
	preprocessed input.

	* cpplib.h (struct cpp_buffer): Make warned_cplusplus_comments
	unsigned. New boolean from_stage3.
	(struct spec_nodes): Add n__Pragma.

	* cppmacro.c (enter_macro_context): Flip sense of return value.
	(_cpp_get_token): Handle _Pragma operator.

2000-10-30  Mark Mitchell  <mark@codesourcery.com>

	* cppmacro.c (builtin_macro): Use NT_VOID, not T_VOID.

2000-10-29  Neil Booth  <neilb@earthling.net>

	* cpplib.c (skip_rest_of_line):  Use _cpp_get_token.

2000-10-29  Neil Booth  <neilb@earthling.net>

	* cppmacro.c (_cpp_create_definition): Optimize the case of
	a macro defined to itself.

2000-10-29  Neil Booth  <neilb@earthling.net>

	* cpplex.c (save_comment): Don't store new lines in C++ comments.

2000-10-28  Geoffrey Keating  <geoffk@cygnus.com>

	* cpphash.c (cpp_forall_identifiers): Add context variable
	for callback routine.
	* cppmain.c (dump_macro): Update to match cpp_forall_identifiers
	change.
	(main): Call cpp_forall_identifiers with null context.
	* cpplib.h (cpp_forall_identifiers): Update prototype.

	* cppmain.c: Make `parse_in' and `print' static.

2000-10-28  Richard Henderson  <rth@redhat.com>

	* cpplib.c (run_directive): Fix prototype.

2000-10-28  Neil Booth  <neilb@earthling.net>

	New macro expander.

	* cpplib.c (struct answer): New.
	(struct if_stack): Use cpp_lexer_pos rather than line and col.
	Rename cmacro mi_cmacro.
	(struct directive, KANDR, STDC89, EXTENSION, COND, IF_COND, INCL,
	IN_I): New directive and flags.
	(skip_rest_of_line, check_eol, run_directive, glue_header_name,
	parse_answer, parse_assertion, find_answer): New functions.
	(parse_ifdef, detect_if_not_defined, validate_else): Remove.
	(lex_macro_node): New function to replace parse_ifdef and
	get_define_node.

	(_cpp_handle_directive): New function, combines _cpp_check_directive
	and _cpp_check_linemarker.

	(do_define, do_undef, parse_include, do_include, do_import,
	do_include_next, read_line_number, do_line, do_ident, do_pragma,
	do_pragma_once, do_pragma_poison, do_pragma_dependency):
	Update for new token getting interface.

	(do_ifdef, do_ifndef, do_if, do_else, do_endif, push_conditional)
	: Update for new multiple-include optimisation technique.
	(do_elif): Don't forget to invalidate controlling macros.

	(unwind_if_stack, cpp_defined, cpp_push_buffer, cpp_pop_buffer): Update.
	(parse_assertion, parse_answer, find_answer, _cpp_test_assertion):
	Functions to handle assertions with the new token interface.
	(do_assert, do_unassert): Use them.

	(cpp_define, _cpp_define_builtin, cpp_undef, cpp_assert, cpp_unassert):
	Use run_directive.

	(_cpp_init_stacks): Register directive names.  Don't register special
	nodes.

	* cpperror.c (print_containing_files, _cpp_begin_message): Update to
	new position recording regime.
	(cpp_ice, cpp_fatal, cpp_error, cpp_error_with_line, cpp_warning,
	cpp_warning_with_line, cpp_pedwarn, cpp_pedwarn_with_line,
	cpp_pedwarn_with_file_and_line): Update for _cpp_begin_message changes.
	(cpp_type2name): Move to cpplex.c.

	* cppexp.c (parse_charconst): spec_nodes is no longer a pointer.
	(parse_defined): Update to handle new multiple include optimisation
	method.  Remove poisoned identifier warning.
	(parse_assertion, TYPE_NAME): Delete.
	(lex): Update for multiple include optimisation, removal of
	CPP_DEFINED, to use _cpp_test_assertion for assertions and
	cpp_token_as_text.
	(_cpp_parse_expr): Update for MI optimisation, and to use op_as_text.
	(op_as_text): New function, to wrap cpp_token_as_text.

	* cppfiles.c (stack_include_file, _cpp_pop_file_buffer):
	Update for MI optimisation.
	(_cpp_execute_include): Take a token rather than 3 arguments.  Fix
	segfault on diagnostic.
	(_cpp_compare_file_date): Take a token rather than 3 args.
	(cpp_read_file): Work correctly for zero-length files.

	* cpphash.c (_cpp_init_macros, _cpp_cleanup_macros): Rename
	_cpp_init_hashtable and _cpp_cleanup_hashtable.
	(cpp_lookup): Place identifiers at front of identifier pool
	for _cpp_lookup_with_hash.
	(_cpp_lookup_with_hash): Require identifiers to be at the front of
	the identifier pool.  Commit the memory if not already in the
	hash table.

	* cppinit.c (cpp_reader_init): Move cpp_init_completed test to top.
	Initialise various members of cpp_reader, memory pools, and the
	special nodes.
	(cpp_printer_init): Delete.
	(cpp_cleanup): Update.
	(struct builtin, builtin_array, initialize_builtins): Update for new
	hashnode definition and builtin handling.
	(cpp_start_read, cpp_finish): Don't take or initialise a
	printer.  Update.

	* cpplib.h (cpp_printer, cpp_toklist, CPP_DEFINED, BOL,
	PASTED, VAR_ARGS, BEG_OF_FILE, IN_DIRECTIVE, KNOWN_DIRECTIVE,
	T_VOID, T_SPECLINE, T_DATE, T_FILE, T_BASE_FILE, T_INCLUDE_LEVEL,
	T_TIME, T_STDC, T_OPERATOR, T_POISON, T_MACRO, T_ASSERTION): Delete.
	(struct cpp_pool, struct cpp_macro, struct cpp_lexer_pos,
	struct cpp_lookahead, CPP_DHASH, enum mi_state, enum mi_ind,
	NO_EXPAND, VARARGS_FIRST, struct cpp_token_with_pos,
	struct toklist, struct cpp_context, struct specnodes,
	TOKEN_LOOKAHEAD, TOKEN_BUFFSIZE, NODE_OPERATOR, NODE_POISONED,
	NODE_BUILTIN, NODE_DIAGNOSTIC, NT_VOID, NT_MACRO, NT_ASSERTION,
	enum builtin_type, cpp_can_paste): New.
	(struct cpp_token): Delete line and col members.
	(struct cpp_buffer): New member output_lineno.
	(struct lexer_state): Delete indented, in_lex_line, seen_dot.
	Add va_args_ok, poisoned_ok, prevent_expansion, parsing_args.
	(struct cpp_reader): New members lexer_pos, macro_pos, directive_pos,
	ident_pool, temp_string_pool, macro_pool, argument_pool, string_pool,
	base_context, context, directive, mi_state, mi_if_not_defined,
	mi_lexed, mi_cmacro, mi_ind_cmacro, la_read, la_write, la_unused,
	mlstring_pos, macro_buffer, macro_buffer_len.
	Delete members mls_line, mls_column, token_list, potential_control_macro,
	temp_tokens, temp_cap, temp_alloced, temp_used, first_directive_token,
	context_cap, cur_context, no_expand_level, paste_level, contexts, args,
	save_parameter_spellings, need_newline, .
	Change type of date, time and spec_nodes members.
	Change prototypes for include and ident callbacks.
	(struct cpp_hashnode): Change type of name.  Remove union members
	expansion and code.  Add members macro, operator and builtin.

	(cpp_token_len, cpp_token_as_text, cpp_spell_token, cpp_start_read,
	cpp_finish, cpp_avoid_paste, cpp_get_token, cpp_get_line,
	cpp_get_output_line, cpp_macro_definition, cpp_start_lookahead,
	cpp_stop_lookahead): New prototypes.
	(cpp_printer_init, cpp_dump_definition): Delete prototypes.

	(U_CHAR, U, ustrcmp, ustrncmp, ustrlen, uxstrdup, ustrchr, ufputs):
	Move from cpphash.h.

	* cpphash.h (U_CHAR, U, ustrcmp, ustrncmp, ustrlen, uxstrdup, ustrchr,
	ufputs): Move to cpplib.h.
	(enum spell_type, struct token_spelling, _cpp_token_spellings, TOKEN_SPELL,
	TOKEN_NAME, struct answer, FREE_ANSWER, KANDR, STDC89, EXTENSION,
	COND, EXPAND, INCL, COMMENTS, IN_I, struct directive, directive_handler,
	struct spec_nodes, _cpp_digraph_spellings, _cpp_free_temp_tokens,
	_cpp_init_input_buffer, _cpp_grow_token_buffer, _cpp_init_toklist,
	_cpp_clear_toklist, _cpp_expand_token_space, _cpp_expand_name_space,
	_cpp_equiv_tokens, _cpp_equiv_toklists, _cpp_process_directive,
	_cpp_run_directive, _cpp_get_line, _cpp_get_raw_token, _cpp_glue_header_name,
	_cpp_can_paste, _cpp_check_directive, _cpp_check_linemarker,
	_cpp_parse_assertion, _cpp_find_answer): Delete.
	(VALID_SIGN, ALIGN, POOL_FRONT, POOL_LIMIT, POOL_BASE, POOL_SIZE,
	POOL_USED, POOL_COMMIT, struct cpp_chunk, _cpp_lex_token, _cpp_init_pool,
	_cpp_free_pool, _cpp_pool_reserve, _cpp_pool_alloc, _cpp_next_chunk,
	_cpp_lock_pool, _cpp_unlock_pool, _cpp_test_assertion,
	_cpp_handle_directive, DSC): New.
	(struct include_file): New member defined.

	(DO_NOT_REREAD, _cpp_begin_message, _cpp_execute_include,
	_cpp_compare_file_date): Update.
	(_cpp_pop_context, _cpp_get_token, _cpp_free_lookaheads, _cpp_push_token): New.
	(_cpp_init_macros, _cpp_cleanup_macros): Rename to _cpp_init_hashtable,
	_cpp_cleanup_hashtable.

	* Makefile.in: Remove cppoutput.c.

	* cppoutput.c: Delete

	* fixheader.c (read_scan_file): Update for new cpp_get_token
	prototype.
	(recognized_function): New argument LINE.

	* scan-decls.c (skip_to_closing_brace, scan_decls): Update for
	new cpp_get_token prototype.

	* scan.h (recognized_function): Update prototype.

	* po/POTFILES.in: Remove cppoutput.c.

2000-10-20  Tom Tromey  <tromey@cygnus.com>

	* cppspec.c (DEFAULT_WORD_SWITCH_TAKES_ARG): Added -MF and -MT.
	* gcc.c (DEFAULT_WORD_SWITCH_TAKES_ARG): Added -MF and -MT.

2000-10-17  Chandrakala Chavva  <cchavva@redhat.com>

	* cppinit.c (new_pending_directive) : New option OPT_target__help.
	(cpp_handle_option): Support this new option.

2000-09-28  Neil Booth  <neilb@earthling.net>

	* cpperror.c (_cpp_begin_message):  Do the test for suppression
	of warnings and pedantic warnings before the "is a warning an
	error" tests.
	* cppinit.c (cpp_handle_option): Remove surplus \n.
	* cpplex.c (ON_REST_ARG): Delete.
	(skip_block_comment): Initialise prevc.
	(parse_args): Improve error messages.
	(maybe_paste_with_next): Use CONTEXT_VARARGS rather
	than ON_REST_ARG.
	* cpplib.c (cpp_push_buffer): Fix grammar in message.
	* cppmain.c (main): Set callbacks for #ident and #pragma
	only if no_output option is false.
	(do_pragma_implementation): Only call the #pragma handler
	if it is set in the cpp_reader structure.

Tue 26-Sep-2000 18:25:38 BST  Neil Booth  <neilb@earthling.net>

	* gcc.c (cpp_options): Add spec for -ftabstop=.

Tue 26-Sep-2000 00:16:22 BST  Neil Booth  <neilb@earthling.net>

	* cpplex.c (parse_args): Don't set VOID_REST flag.
	(CONTEXT_VARARGS): New flag.
	(maybe_paste_with_next): Set context earlier in loop.  Use
	it.  Do varargs test with CONTEXT_VARARGS flag.
	(push_arg_context): Set CONTEXT_VARARGS flag if we're
	pushing an argument context for a varargs argument.
	* cpplib.h (VOID_REST): Delete.
	* gcc.dg/cpp/vararg1.c: Add test case.

2000-09-25  Branko Cibej  <branko.cibej@hermes.si>

	* cpplib.h (cpp_options): New member warn_system_headers.
	* cpphash.h (CPP_PEDANTIC, CPP_WTRADITIONAL): Don't test
	CPP_IN_SYSTEM_HEADER.
	* cpplib.c (do_import, do_pragma_once): Likewise.
	* cpperror.c (_cpp_begin_message): Test warn_system_headers
	and CPP_IN_SYSTEM_HEADER.
	* cppinit.c (handle_option): Recognize -Wsystem_headers.
	(print_help): Describe -Wsystem_headers.
	* cpplex.c (lex_line): Reorganize condition so that warnings
	about C++ comments in system headers can be enabled. Remove
	label do_line_comment.

Mon 25-Sep-2000 23:38:27 BST  Neil Booth  <neilb@earthling.net>

	* cpplex.c (save_comment): Only store the initial '/'
	now.
	(lex_token): Combine handling of the two comment types.
	Pass everything but the initial '/' to save_comment.

Mon 25-Sep-2000 23:31:45 BST  Neil Booth  <neilb@earthling.net>

	* cpphash.h (_cpp_digraph_spellings, _cpp_process_directive,
	_cpp_can_paste): New library-internal prototypes.
	* cpplex.c (dump_param_spelling, output_line_command,
	output_token, cpp_scan_buffer, cpp_scan_buffer_nooutput,
	cpp_printf, cpp_output_list): Move to cppoutput.c.
	(process_directive, can_paste, digraph_spellings): Add _cpp_ prefix.
	* cppmacro.c (dump_macro_args, cpp_dump_definition) Move to
	cppoutput.c.
	* cppoutput.c (dump_macro_args, cpp_dump_definition, output_token,
	dump_param_spelling, output_line_command, cpp_scan_buffer,
	cpp_scan_buffer_nooutput, cpp_printf, cpp_output_list): Moved
	from elsewhere.
	* Makefile.in: Add cppoutput.c.
	* po/POTFILES.in: Add cppoutput.c.

Sun 24-Sep-2000 11:40:23 BST  Neil Booth  <NeilB@earthling.net>

	* cpplex.c: Update TODO comment.
	* cpplib.c (do_error, do_warning): Merge common code of
	do_error and do_warning	into do_diagnostic.  Use it.
	(do_diagnostic): New function.
	* cpplib.h: Fix comment typo.

Sat 23-Sep-2000 22:39:18 BST  Neil Booth  <NeilB@earthling.net>

	* cpphash.h (CPP_RESERVE, CPP_PUTS_Q, CPP_PUTS, CPP_PUTC_Q,
	CPP_PUTC, DUMMY_TOKEN, NO_DUMMY_TOKEN): Delete.
	* cpplex.c (_cpp_expand_token_space, _cpp_init_toklist,
	_cpp_free_toklist): No need to worry about extra dummy token
	at the start of token lists any more.
	(trigraph_ok): Only warn outside comments.
	(skip_block_comment): Set and clear lexing_comment.
	(skip_line_comment): Take a cpp_reader not cpp_buffer.
	Set and clear lexing_comment.
	(parse_number): Handle leading '.' indicated by pfile->seen_dot.
	(check_long_token): Delete.
	(lex_percent, lex_dot): New subroutines of lex_token to
	handle lexing of '.' and '%' without lookback.
	(lex_token): Use lex_dot and lex_percent.
	(lex_line): Don't check for LIST_OFFSET.
	(_cpp_init_input_buffer): Update for new _cpp_init_toklist.
	* cpplib.c (_cpp_parse_assertion): Similarly.
	(cpp_push_buffer): Initialize extra_char.
	* cpplib.h (LIST_OFFSET): Delete.
	(struct cpp_buffer): New member extra_char.
	(struct lexer_state): New members lexing_comment and seen_dot.

Thu 21-Sep-2000 18:19:05 BST  Neil Booth  <NeilB@earthling.net>

	* cppfiles.c (lookup_include_file): Rename to open_file.
	Always create a splay tree value, even on syscall failures.
	Negative entries indicated by fd == -2.
	Re-open files closed in the meantime.
	(_cpp_fake_include): Create a negative splay tree entry.
	(find_include_file, cpp_read_file): Update for function name
	change.
	* gcc.gd/cpp/mi4.c: Testcase.

Tue 19-Sep-2000 22:38:57 BST  Neil Booth  <NeilB@earthling.net>

	* cpplex.c (lex_line): Drop the EOF token for unknown
	directives in assembler.

Tue 19-Sep-2000 18:26:57 BST  Neil Booth  <NeilB@earthling.net>

	* cppfiles.c (read_include_file): Take no special action for
	zero-length files.

Mon 18-Sep-2000 19:21:35 BST  Neil Booth  <NeilB@earthling.net>

	* cpphash.h (HASHSTEP): Take character rather than pointer
	to character.
	(_cpp_check_directive, _cpp_check_linemarker): Update prototypes.

	* cpphash.c (cpp_loookup): Update for new HASHSTEP.

	* cpplex.c (auto_expand_name_space, trigraph_replace,
	backslash_start, handle_newline, parse_name, INIT_TOKEN_STR,
	IMMED_TOKEN, PREV_TOKEN_TYPE, PUSH_TOKEN, REVISE_TOKEN,
	BACKUP_TOKEN, BACKUP_TRIGRAPH, MIGHT_BE_DIRECTIVE,
	KNOWN_DIRECTIVE): Delete.

	(handle_newline, check_long_token, skip_escaped_newlines,
	unterminated): New functions.
	(ACCEPT_CHAR, SAVE_STATE, RESTORE_STATE): New macros.

	(parse_identifier): Was parse_name, new implementation.
	(skip_line_comment, skip_block_comment, skip_whitespace,
	parse_number, parse_string, trigraph_ok, save_comment,
	adjust_column, _cpp_get_line): New implementations.

	(lex_token): New function.  Lexes a token at a time, looking
	forwards.  Contains most of the guts of the old lex_line.
	(lex_line): New implementation, using lex_token to obtain
	individual tokens.
	(cpp_scan_buffer): Use the token's line, not the list's line.

	* cpplib.c (_cpp_check_directive, _cpp_check_linemarker):
	 New implementations.
	(do_assert): Don't bother setting the answer's list's line.
	(cpp_push_buffer): Initialise new pfile and read_ahead members
	of struct cpp_buffer.

	* cpplib.h (cppchar_t): New typedef.
	(struct cpp_buffer): read_ahead, pfile and col_adjust are
	new members.
	(struct lexer_state): New structure that determines the state
	and behaviour of the lexer.
	(IN_DIRECTIVE, KNOWN_DIRECTIVE): New macros.
	(struct cpp_reader): New member "state". Rename
	multiline_string_line and multiline_string_column. Delete
	col_adjust, in_lex_line members.
	(CPP_BUF_COLUMN): Update.

2000-09-17  Mark Mitchell  <mark@codesourcery.com>

	* cppinit.c (cpp_init): Don't use ANSI prototypes.

Sat Sep 16 19:14:00 2000  Laurynas Biveinis <lauras@softhome.net>

	* cppfiles.c (purge_cache): Use munmap only if MMAP_THRESHOLD defined.
	(read_include_file): Ensure inc->mmaped is initialized.

2000-09-16  Richard Henderson  <rth@cygnus.com>

	* cppiles.c (purge_cache): Use PTR not caddr_t.

Sat 16-Sep-2000 08:13:45 BST  Neil Booth  <NeilB@earthling.net>

	* cpplex.c (push_macro_context): Set an argument's level after
	calling parse_args.  We could loop infinitely otherwise.

2000-09-15  Greg McGary  <greg@mcgary.org>

	* cppmacro.c (check_trad_stringification): Check token
	text pointers against limit before dereferencing.

Fri 15-Sep-2000 06:49:07 BST  Neil Booth  <NeilB@earthling.net>

	* cpplex.c (ON_REST_ARG): Correct the test.
	(maybe_paste_with_next): Duplicate a token that fail pasting,
	and clear its PASTE_LEFT flag, so that nested pasting attempts
	do not occur.

2000-09-11  Zack Weinberg  <zack@wolery.cumb.org>

	* cppfiles.c: Move all default-#defines to top of file.
	(open_include_file): Replace by lookup_include_file.
	(read_with_read, read_file): Merged into read_include_file.
	(stack_include_file, purge_cache): New functions.
	(close_cached_fd): Delete.
	(lookup_include_file, read_include_file, _cpp_pop_file_buffer):
	Cache the in-memory buffer, not the file descriptor.

	* cpphash.h (struct include_file): Add buffer, st, refcnt,
	mapped fields.
	(xcnew): New utility macro.
	(DO_NOT_REREAD, NEVER_REREAD): Move up by struct include_file.
	* cpplib.h (struct cpp_buffer): Remove mapped field.

2000-09-11  Zack Weinberg  <zack@wolery.cumb.org>

	* cpplex.c (parse_string): Accept backslash space newline as a
	line continuation.
	(lex_line): Likewise.
	(_cpp_get_token): Remove hard limit on macro nesting.

2000-09-10  Zack Weinberg  <zack@wolery.cumb.org>

	* defaults.h: Provide default definitions for: CHAR_TYPE_SIZE,
	LONG_TYPE_SIZE.

2000-09-09  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* cppmacro.c (check_trad_stringification): New function.
	(save_expansion): If -Wtraditional, warn about stringification of
	macro arguments.

2000-09-07  Zack Weinberg  <zack@wolery.cumb.org>

	* cpplib.h (struct cpp_options): Add user_label_prefix member,
	left out of commit which removed cppulp.c.

2000-09-07  Zack Weinberg  <zack@wolery.cumb.org>

	* cpplib.h: Don't typedef struct cpp_reader if c-pragma.h has
	already done it.

Thu 07-Sep-2000 21:29:00 BST  Neil Booth  <NeilB@earthling.net>

	* Makefile.in: Remove references to cppulp.{c,o}.
	* cppinit.c (initialize_builtins, cpp_start_read,
	cpp_handle_option): Update to use cpp_options structure.
	* cppulp.c: Remove.

2000-09-04  Jakub Jelinek  <jakub@redhat.com>

	* cpplex.c (ON_REST_ARG): Check VAR_ARGS flag of current context,
	use posn - 1 to index into tokens array.
	(maybe_paste_with_next): Adjust caller.

2000-08-29  Zack Weinberg  <zack@wolery.cumb.org>

	* cpperror.c (print_file_and_line): If line is (unsigned int)-1,
	print just the filename.
	* cpplex.c (_cpp_run_directive): Add additional argument, the
	name to give the synthetic buffer.  This defaults to
	translated "<command line>".
	* cpplib.c (cpp_define, cpp_undef, cpp_assert, cpp_unassert):
	Adjust to match.
	(_cpp_define_builtin): New function.
	* cppinit.c (initialize_builtins): Use _cpp_define_builtin.
	* cpphash.h: Update prototypes.

	* tradcpp.c (main): Process -D and -U simultaneously, in the
	order they appeared on the command line.

2000-08-27  Greg McGary  <greg@mcgary.org>

	* cpplex.c (parse_string): Don't look for backslash
	before first char in `namebuf'.

Fri 25-Aug-2000 08:03:27 BST  Neil Booth  <NeilB@earthling.net>

	* cpplex.c (is_macro_disabled): Caller has already checked
	that we're not a preprocessed file.

2000-08-24  Zack Weinberg  <zack@wolery.cumb.org>

	* cppfiles.c (read_include_file): Rearrange initializations.

2000-08-24  Greg McGary  <greg@mcgary.org>

	* cppfiles.c (actual_directory): Don't write beyond `dir'
	when it contains "".

2000-08-23  Zack Weinberg  <zack@wolery.cumb.org>

	* cpphash.h (IN_I): New flag for directive table.
	* cpplib.c (DIRECTIVE_TABLE): Mark #define, #undef, #ident, and
	#pragma with IN_I.
	(_cpp_check_directive): If -fpreprocessed, execute directives
	marked with IN_I.  Issue no warnings in this case.
	* cpplex.c (_cpp_get_token): Expand no macros if -fpreprocessed.

2000-08-20  Zack Weinberg  <zack@wolery.cumb.org>

	* cppinit.c (cpp_init): Set global flag when called.
	(cpp_reader_init): Bomb out if cpp_init hasn't been called.

Sun Aug 20 01:41:35 2000  Dennis Chernoivanov  <cdi@sparc.spb.su>

	* cpplex.c (cpp_scan_buffer): Move `output_line_command' just
	before `process_directive' so that newlines won't be missed
	for directives.
	(cpp_printf): Increment `print->lineno' when newline is emitted.

	* cppmain.c (cb_ident): Likewise.
	(cb_define): Likewise.
	(cb_undef): Likewise.
	(cb_include): Likewise.
	(cb_def_pragma): Likewise.
	(dump_macros_helper): Likewise.

2000-08-18  Zack Weinberg  <zack@wolery.cumb.org>

	* cpplib.c (cpp_register_pragma_space): Just return if the
	namespace is already registered.

Fri 18-Aug-2000 18:33:45 BST  Neil Booth  <NeilB@earthling.net>

	* cpphash.h: Use HAVE_DESIGNATED_INITIALIZERS.
	(_cpp_trigraph_map): Declaration moved from cpplex.c

	* cppinit.c: Define _cpp_trigraph_map.  Use UCHAR_MAX + 1
	instead	of 256.  Use consistent test for designated initializers.
	(cpp_init): Initialize trigraph_map.
	(initialize_standard_includes, parse_option):  Use memcmp
	instead of strncmp.

	* cpplex.c (init_trigraph_map): Remove.
	(trigraph_ok, trigraph_replace, lex_line): Refer to
	_cpp_trigraph_map.

	* cpplib.c (str_match, WARNING, ERROR, ICE): Delete.
	(do_unassert): Remove unused "next" local.

	* system.h (HAVE_DESIGNATED_INITIALIZERS): New prototype.

2000-08-17  Neil Booth  <NeilB@earthling.net>

	* (cppinit.c) merge_include_chains: Use remove_dup_dir,
	remove_dup_dirs.  If qtail == brack, remove brack not
	qtail.
	(remove_dup_dir, remove_dup_dirs): New functions.

2000-08-17  Neil Booth  <NeilB@earthling.net>

	* cppinit.c (cpp_cleanup): Free include dir chains.
	* cpplib.c (do_undef): Let _cpp_free_definition make the node void.
	(do_unassert): Free the assert with _cpp_free_definition.
	* cppmacro.c (_cpp_free_definition): Free memory allocated for
	assertions.  Make the node a T_VOID node.

2000-08-17  Neil Booth  <NeilB@earthling.net>

	* cppinit.c (path_include, append_include_chain):
	Remove 2nd parameter (struct cpp_pending *).
	(path_include, initialize_standard_includes, cpp_handle_option):
	Update callers appropriately.
	(cpp_handle_option): Use pend.

2000-08-17  Neil Booth  <NeilB@earthling.net>

	* cppinit.c (sort_options): Remove, put functionality in
	cpp_init.
	(cpp_init): New.
	(initialize_builtins): Free memory.
	(cpp_start_read): Move init_IStable to cpp_init.

	* cpplib.h (cpp_init): New prototype.
	* cppmain.c (main): Call cpp_init.

2000-08-10  Kaveh R. Ghazi  <ghazi@caip.rutgers.edu>

	* cppexp.c (parse_number): For -Wtraditional, issue a
	warning about non-traditional numeric constant suffixes.

2000-08-09  Zack Weinberg  <zack@wolery.cumb.org>

	* cpperror.c (cpp_type2name): New function.
	* cpplex.c (lex_line): If we issued an error for an invalid
	preprocessing directive, discard that logical line.
	* cpplib.c (do_line): Call a hook function if the current file
	is renamed by #line.
	(do_ident): Pass the contents of the string, not the entire
	token, to the callback function.
	* cpplib.h (CPP_LAST_PUNCTUATOR): New #define.
	(cb.rename_file): New hook function.
	(cb.ident): Adjust prototype.
	(cpp_type2name): Prototype.
	* cppmacro.c (dump_macro_args): Correct precedence lossage.

	* cppmain.c (cb_ident): Update for changed interface.
	(cb_rename_file): New function.
	(main): Set rename callback.

2000-08-04  Andreas Schwab  <schwab@suse.de>

	* cppmain.c (cb_def_pragma): Skip the first two tokens from the
	token list, which are always `#' and `pragma'.

2000-08-04  Joseph S. Myers  <jsm28@cam.ac.uk>

	* cppdefault.h (WINT_TYPE): Define.
	* cppinit.c (builtin_array): Define __WINT_TYPE__.
	* tradcpp.c (initialize_builtins): Define __WINT_TYPE__.

2000-08-03  Zack Weinberg  <zack@wolery.cumb.org>

	* cpplex.c (parse_name): Might have to glue a CPP_OTHER token
	before the name.
	(lex_line): Glue @ onto the beginning of identifiers and
	string constants, in Objective-C mode.
	(output_token, spell_token): Handle CPP_OSTRING.
	(can_paste, maybe_paste_with_next): Handle pasting @ onto the
	beginning of a NAME or a STRING, in objc mode.

	* cpplib.c (get_define_node): Do not permit identifiers that
	begin with @ to be #defined.
	* cppmacro.c (CAN_PASTE_AFTER): Add CPP_OTHER.
	* cpplib.h (TTYPE_TABLE): Add CPP_OSTRING.

2000-08-02  Zack Weinberg  <zack@wolery.cumb.org>

	* cppspec.c, gccspec.c: Adjust type of second argument to
	lang_specific_driver, and update code as necessary.

2000-08-02  Zack Weinberg  <zack@wolery.cumb.org>

	* cppexp.c, cppinit.c, cpplex.c, cpplib.c, cppmacro.c,
	cppspec.c: Do not use 'legal' or 'illegal' in error messages
	and comments.

	* cppmain.c (cb_define, cb_undef): Don't generate any output
	if not done_initializing.
	* cpplex.c (maybe_paste_with_next): When the token after a ##
	is an omitted rest argument, only delete the token before it
	if that token is a comma.  Do not warn about bogus token
	pastes for , ## rest_arg.

	* cpp.1: Regenerate.

2000-08-01  Zack Weinberg  <zack@wolery.cumb.org>

	* cpperror.c (v_message): Split into _cpp_begin_message and
	v_message macro.  All callers updated.
	(_cpp_begin_message): Do inhibit_errors/inhibit_warnings
	checks here.

	* cppfiles.c (cpp_syshdr_flags): New function.
	(read_include_file): Don't call cpp_output_tokens.  Call
	enter_file hook.
	* cppinit.c (dump_macros_helper): Moved to cppmain.c.
	(cpp_reader_init): Don't initialize token_buffer.  Call
	_cpp_init_internal_pragmas.
	(cpp_cleanup): Don't clear token_buffer.
	(cpp_start_read): Don't worry about output from -D processing.
	Don't call cpp_output_tokens.
	(cpp_finish): Don't dump macros here.  Don't call
	cpp_output_tokens.
	* cppmacro.c (_cpp_dump_definition): Rename
	cpp_dump_definition.  Write directly to a FILE *.
	(dump_funlike_macro): Delete.
	(dump_macro_args): New.

	* cpplex.c (TOKEN_LEN): Convert to inline function.
	(_cpp_grow_token_buffer, safe_fwrite, cpp_output_tokens,
	cpp_scan_line, _cpp_dump_list): Delete.
	(cpp_printf, cpp_output_list): New.
	(output_line_command): Don't worry about entering or leaving files.
	(cpp_scan_buffer): Just output each token as we hit it.
	(process_directive): Don't call cpp_output_tokens.
	(_cpp_glue_header_name): Don't use token_buffer.
	(output_token, dump_param_spelling): Write directly to a FILE *.

	* cpplib.c (pass_thru_directive, dump_macro_name,
	pragma_dispatch, do_pragma_gcc): Delete.
	(do_define, do_undef, parse_include, do_line, do_ident, do_pragma,
	do_pragma_poison, cpp_pop_buffer): Call the appropriate hook
	functions.
	(do_error, do_warning, pragma_dependency): Call
	_cpp_begin_message, then cpp_output_list.
	(cpp_register_pragma, cpp_register_pragma_space,
	_cpp_init_internal_pragmas): New.
	(do_pragma): Walk the pragmas table here.
	(do_pragma_once, do_pragma_poison, do_pragma_system_header,
	do_pragma_dependency): Return void.
	(do_pragma_implementation): Moved to cppmain.c.

	* cpplib.h: Update prototypes.
	 (struct cpp_reader): Remove printer, token_buffer,
	token_buffer_size, and limit.  Add struct cb, and pragmas.
	(struct cpp_printer): Remove last_id and written.
	(CPP_WRITTEN, CPP_PWRITTEN, CPP_SET_WRITTEN,
	CPP_ADJUST_WRITTEN): Delete.
	* cpphash.h: Update prototypes.
	(ufputs): New wrapper.

	* cppmain.c (cb_define, cb_undef, cb_include, cb_ident,
	cb_enter_file, cb_leave_file, cb_def_pragma): New functions.
	(main): Set up callbacks.  Register #pragma implementation.
	Dump macros from here.

