/*
  GNOME Comics Organizer
  Copyright (C) 1999-2000 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ctype.h>
#include <stdlib.h>
#include <glib.h>

#include "config.h"
#include "fileops.h"
#include "functions.h"
#include "comiclist.h"
#include "debug.h"

#if USE_GNOME_VFS
#include <libgnomevfs/gnome-vfs.h>
#endif

#if USE_GNOME_VFS
//#define blocksize 1024
#define blocksize 1
GnomeVFSHandle   *vfs_h;
GnomeVFSResult    result;
GnomeVFSURI      *uri;
gchar            *text_uri;
GnomeVFSFileSize bytes_read, bytes_written;
guint8           data [blocksize];
int              read_so_far = blocksize;
#else
FILE *fp;
#endif

gboolean file_exists (char *f)
{
  gboolean returnme;

#if USE_GNOME_VFS
  GnomeVFSHandle   *vfs_h;
  GnomeVFSResult    result;
  GnomeVFSURI      *uri;
  gchar            *text_uri;
  
  uri = gnome_vfs_uri_new (f);
  if (uri == NULL) {
    dprintf ("URI not valid.\n");
    return FALSE;
  }

  text_uri = gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE);
  result = gnome_vfs_open (&vfs_h, text_uri, GNOME_VFS_OPEN_READ);
  if (result == GNOME_VFS_OK)
    {
      returnme = TRUE;
      gnome_vfs_close (vfs_h);
    }
  else
    returnme = FALSE;

  return returnme;
#else
  FILE *fp;

  fp = fopen (f, "r");
  if (fp!=NULL)
    {
      returnme = TRUE;
      fclose (fp);
    }
  else
    returnme = FALSE;

  return returnme;
#endif
}

void *my_open (const char *path, const char *mode)
{
#if USE_GNOME_VFS
  uri = gnome_vfs_uri_new (path);
  if (uri == NULL) {
    dprintf ("URI not valid.\n");
    return NULL;
  }

  text_uri = gnome_vfs_uri_to_string (uri, GNOME_VFS_URI_HIDE_NONE);
  if (strcmp (mode, "r")==0) {
    result = gnome_vfs_open (&vfs_h, text_uri, GNOME_VFS_OPEN_READ);}
  if (strcmp (mode, "w")==0) {
    result = gnome_vfs_create (&vfs_h, text_uri, GNOME_VFS_OPEN_WRITE, FALSE, 0600);}

  if (result == GNOME_VFS_OK) {
    return (void *) 1; // something different from NULL
  }
  else { // Error during opening - return NULL
    return NULL;
  }
#else
  fp = fopen (path, mode); // Update our filepointer
  return fp;
#endif
}

int my_close ()
{
#if USE_GNOME_VFS
  result = gnome_vfs_close (vfs_h);
  if (result == GNOME_VFS_OK) {
    return 0;
  }
  else {
    return EOF;
  }
#else
  return fclose (fp);
#endif
}

int my_getc ()
{
#if USE_GNOME_VFS
  gboolean get_new_block = FALSE;

  if (read_so_far == blocksize)
    {
      get_new_block = TRUE;
    }
  else
    {
      if (read_so_far == bytes_read)
	{
	  return EOF;
	}
    }
  read_so_far %= (blocksize);
  
  if (get_new_block)
    {
      result = gnome_vfs_read (vfs_h, data, blocksize, &bytes_read);
      if (bytes_read == 0)
	return EOF;
      
      if (!(bytes_read >  0 &&
	    bytes_read <= blocksize))
	{
	  // g_warning ("Weird error from vfs_read");
	}
    }
  read_so_far++;
  return data[read_so_far-1];
#else
  return getc (fp);
#endif
}

int my_ungetc (int c)
{
#if USE_GNOME_VFS
  read_so_far--;
  return c;
#else
 return ungetc (c, fp);
#endif
}

int my_putc (int c, FILE *temp)
{
#if USE_GNOME_VFS
  unsigned char a;
  a = (unsigned char) c;

  gnome_vfs_write (vfs_h, &a, sizeof(a), &bytes_written);

  return c;
#else
 return fputc (c, fp);
#endif
}

int my_puts (const char *s, FILE *temp)
{
#if USE_GNOME_VFS
  gnome_vfs_write (vfs_h, s, strlen(s), &bytes_written);
  return 1;
#else
 return fputs (s, fp);
#endif
}
