// genesis

/**********************************************************************
**
**	DO NOT EDIT THIS FILE IN THE neurokit DIRECTORY!
**
**	Make a copy of this file in every directory that contains .p
**	files and edit the copies, in order to customize neurokit for
**	different simulations. When you run neurokit from other
**	directories, the simulator will look for the local version of
**	userprefs.g, and if it cannot find it there will look for the
**	default in the neurokit directory. This version of userprefs is
**	set up to run Ca channel testing simulations
**	
**	There are three aspects to customisation :
**	
**	1	Include the appropriate script files from the /neuron/prototype
**		directory and from wherever you have defined new prototype
**		elements.
**
**	2	Invoke the functions that make the prototypes you want for
**		your simulation.
**
**	3	Put your preferences for the user_variables defined in
** 		defaults.g in the copies of this file.
**
**********************************************************************/

echo using user prefs for ionchannels

/**********************************************************************
**
**	1	Including script files for prototype functions
**
**********************************************************************/

/* file for standard compartments */
include compartments

/* file for Hodgkin-Huxley Squid Na and K channels */
include hhchan

/* file for Upi's mitral cell channels */
include	mitchan

include FNTchan

include CSchan

include ASTchan

include traubchan

include yamadachan

include SMSNNchan

/**********************************************************************
**
**	2	Invoking functions to make prototypes in the /library element
**
**********************************************************************/

	/* To ensure that all subsequent elements are made in the library */
	ce /library




	/* These make the standard types of compartments that can be
	**	invoked in .p files */
	make_cylind_compartment			/* makes "compartment" */
	make_sphere_compartment			/* makes "compartment_sphere" */
	make_cylind_symcompartment		/* makes "symcompartment" */
	make_sphere_symcompartment		/* makes "symcompartment_sphere" */


	/* These are some standard channels used in .p files */
	make_Na_squid_hh				/* makes "Na_squid_hh" */
	make_K_squid_hh					/* makes "K_squid_hh" */
	make_Na_mit_tchan				/* makes "Na_mit_hh" */
	make_K_mit_tchan				/* makes "K_mit_hh" */
	make_Ca_mit_tab					/* makes "Ca_mit_tab" */
	make_Kca_mit_tab				/* makes "Kca_mit_tab" */
	make_Ca_mit_conc				/* makes "Ca_mit_conc" */
	make_NCa_drg_fnt
	make_K_moll_cs
	make_KA_moll_cs
	make_Na_moll_cs
	make_Ca_aplysia_ag
	make_K_trit_agt
	make_K_hip_traub
	make_KA_bsg_yka
	make_Na_bsg_yka
	make_K_bsg_yka
	make_Ca_bsg_yka
	make_Ca_bsg_conc
	make_Na_rat_smsnn



	/* returning to the root element */
	ce /



/**********************************************************************
**
**	3	Setting preferences for user-variables.
**
**********************************************************************/

	user_cell = "/soma"
	user_pfile = "soma.p"
	user_name = "Upinder S. Bhalla"
	user_ymin1 = -0.1
	user_ymax1 = 0.09
	user_xmax1 = 0.2
	user_inject = 0.05
	user_refresh = 20
	user_runtime = 0.2

/*****************************************************************************/
