/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  keymap.inl - Gdk::KeymapKey and Gdk::Keymap inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gdk::KeymapKey
 */

inline GdkKeymapKey*
GFC::Gdk::KeymapKey::gdk_keymap_key() const
{
	return const_cast<GdkKeymapKey*>(&key_);
}

inline unsigned int
GFC::Gdk::KeymapKey::keycode() const
{
	return key_.keycode;
}

inline int
GFC::Gdk::KeymapKey::group() const
{
	return key_.group;
}

inline int
GFC::Gdk::KeymapKey::level() const
{
	return key_.level;
}

/*  Gdk::Keymap
 */

inline GdkKeymap*
GFC::Gdk::Keymap::gdk_keymap() const
{
	return reinterpret_cast<GdkKeymap*>(instance_);
}

inline GFC::Gdk::Keymap::operator GdkKeymap* () const
{
	return this ? gdk_keymap() : 0;
}

inline GFC::Pango::Direction
GFC::Gdk::Keymap::get_direction() const
{
	return (Pango::Direction)gdk_keymap_get_direction(gdk_keymap());
}

inline const GFC::Gdk::Keymap::DirectionChangedSignalProxy
GFC::Gdk::Keymap::sig_direction_changed()
{
	return DirectionChangedSignalProxy(this, &direction_changed_signal);
}

inline const GFC::Gdk::Keymap::KeysChangedSignalProxy
GFC::Gdk::Keymap::sig_keys_changed()
{
	return KeysChangedSignalProxy(this, &keys_changed_signal);
}

