/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  texttag.inl - Gtk::TextTag and Gtk::TextTagTable inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gtk::TextAppearance
 */

inline GtkTextAppearance*
GFC::Gtk::TextAppearance::gtk_text_appearance() const
{
	return const_cast<GtkTextAppearance*>(&appearence_);
}

inline int
GFC::Gtk::TextAppearance::rise() const
{
	return appearence_.rise;
}

inline GFC::Pango::Underline
GFC::Gtk::TextAppearance::underline() const
{
	return (Pango::Underline)appearence_.underline;
}

inline bool
GFC::Gtk::TextAppearance::strikethrough() const
{
	return appearence_.strikethrough;
}

inline void
GFC::Gtk::TextAppearance::set_rise(int rise)
{
	appearence_.rise = rise;
}

inline void
GFC::Gtk::TextAppearance::set_underline(Pango::Underline underline)
{
	appearence_.underline = (unsigned int)underline;
}

inline void
GFC::Gtk::TextAppearance::set_strikethrough(bool setting)
{
	appearence_.strikethrough = setting;
}

/*  Gtk::TextAttributes
 */

inline GtkTextAttributes*
GFC::Gtk::TextAttributes::gtk_text_attributes() const
{
	return reinterpret_cast<GtkTextAttributes*>(boxed_);
}

inline GFC::Gtk::TextAttributes::operator GtkTextAttributes* () const
{
	return this ? gtk_text_attributes() : 0;
}

inline GFC::Gtk::Justification
GFC::Gtk::TextAttributes::justification() const
{
	return (Justification)gtk_text_attributes()->justification;
}

inline GFC::Gtk::TextDirection
GFC::Gtk::TextAttributes::direction() const
{
	return (TextDirection)gtk_text_attributes()->direction;
}

inline double
GFC::Gtk::TextAttributes::font_scale() const
{
	return gtk_text_attributes()->font_scale;
}

inline int
GFC::Gtk::TextAttributes::left_margin() const
{
	return gtk_text_attributes()->left_margin;
}

inline int
GFC::Gtk::TextAttributes::indent() const
{
	return gtk_text_attributes()->indent;
}

inline int
GFC::Gtk::TextAttributes::right_margin() const
{
	return gtk_text_attributes()->right_margin;
}

inline int
GFC::Gtk::TextAttributes::pixels_above_lines() const
{
	return gtk_text_attributes()->pixels_above_lines;
}

inline int
GFC::Gtk::TextAttributes::pixels_below_lines() const
{
	return gtk_text_attributes()->pixels_below_lines;
}

inline int
GFC::Gtk::TextAttributes::pixels_inside_wrap() const
{
	return gtk_text_attributes()->pixels_inside_wrap;
}

inline GFC::Gtk::WrapMode
GFC::Gtk::TextAttributes::wrap_mode() const
{
	return (WrapMode)gtk_text_attributes()->wrap_mode;
}

inline bool
GFC::Gtk::TextAttributes::invisible() const
{
	return gtk_text_attributes()->invisible;
}

inline bool
GFC::Gtk::TextAttributes::bg_full_height() const
{
	return gtk_text_attributes()->bg_full_height;
}

inline bool
GFC::Gtk::TextAttributes::editable() const
{
	return gtk_text_attributes()->editable;
}

inline bool
GFC::Gtk::TextAttributes::realized() const
{
	return gtk_text_attributes()->realized;
}

inline void
GFC::Gtk::TextAttributes::set_justification(Justification justification)
{
	gtk_text_attributes()->justification = (GtkJustification)justification;
}

inline void
GFC::Gtk::TextAttributes::set_direction(TextDirection direction)
{
	gtk_text_attributes()->direction = (GtkTextDirection)direction;
}

inline void
GFC::Gtk::TextAttributes::set_left_margin(int margin)
{
	gtk_text_attributes()->left_margin = margin;
}

inline void
GFC::Gtk::TextAttributes::set_right_margin(int margin)
{
	gtk_text_attributes()->right_margin = margin;
}

inline void
GFC::Gtk::TextAttributes::set_indent(int indent)
{
	gtk_text_attributes()->indent = indent;
}

inline void
GFC::Gtk::TextAttributes::set_pixels_above_lines(int pixels)
{
	gtk_text_attributes()->pixels_above_lines = pixels;
}

inline void
GFC::Gtk::TextAttributes::set_pixels_below_lines(int pixels)
{
	gtk_text_attributes()->pixels_below_lines = pixels;
}

inline void
GFC::Gtk::TextAttributes::set_pixels_inside_wrap(int pixels)
{
	gtk_text_attributes()->pixels_inside_wrap = pixels;
}

inline void
GFC::Gtk::TextAttributes::set_wrap_mode(WrapMode wrap_mode)
{
	gtk_text_attributes()->wrap_mode = (GtkWrapMode)wrap_mode;
}

inline void
GFC::Gtk::TextAttributes::set_invisible(bool setting)
{
	gtk_text_attributes()->invisible = setting;
}

inline void
GFC::Gtk::TextAttributes::set_bg_full_height(bool setting)
{
	gtk_text_attributes()->bg_full_height = setting;
}

inline void
GFC::Gtk::TextAttributes::set_editable(bool setting)
{
	gtk_text_attributes()->editable = setting;
}

/*  Gtk::TextTag
 */

inline GtkTextTag*
GFC::Gtk::TextTag::gtk_text_tag() const
{
	return reinterpret_cast<GtkTextTag*>(instance_);
}

inline GFC::Gtk::TextTag::operator GtkTextTag* () const
{
	return this ? gtk_text_tag() : 0;
}

inline int
GFC::Gtk::TextTag::get_priority() const
{
	return gtk_text_tag_get_priority(gtk_text_tag());
}

inline void
GFC::Gtk::TextTag::set_priority(int priority)
{
	gtk_text_tag_set_priority(gtk_text_tag(), priority);
}

inline const GFC::Gtk::TextTag::NamePropertyProxy
GFC::Gtk::TextTag::prop_name()
{
	return NamePropertyProxy(this, &name_property);
}

inline const GFC::Gtk::TextTag::BackgroundPropertyProxy
GFC::Gtk::TextTag::prop_background()
{
	return BackgroundPropertyProxy(this, &background_property);
}

inline const GFC::Gtk::TextTag::BackgroundGdkPropertyProxy
GFC::Gtk::TextTag::prop_background_gdk()
{
	return BackgroundGdkPropertyProxy(this, &background_gdk_property);
}

inline const GFC::Gtk::TextTag::BackgroundFullHeightPropertyProxy
GFC::Gtk::TextTag::prop_background_full_height()
{
	return BackgroundFullHeightPropertyProxy(this, &background_full_height_property);
}

inline const GFC::Gtk::TextTag::BackgroundStipplePropertyProxy
GFC::Gtk::TextTag::prop_background_stipple()
{
	return BackgroundStipplePropertyProxy(this, &background_stipple_property);
}

inline const GFC::Gtk::TextTag::ForegroundPropertyProxy
GFC::Gtk::TextTag::prop_foreground()
{
	return ForegroundPropertyProxy(this, &foreground_property);
}

inline const GFC::Gtk::TextTag::ForegroundGdkPropertyProxy
GFC::Gtk::TextTag::prop_foreground_gdk()
{
	return ForegroundGdkPropertyProxy(this, &foreground_gdk_property);
}

inline const GFC::Gtk::TextTag::ForegroundStipplePropertyProxy
GFC::Gtk::TextTag::prop_foreground_stipple()
{
	return ForegroundStipplePropertyProxy(this, &foreground_stipple_property);
}

inline const GFC::Gtk::TextTag::DirectionPropertyProxy
GFC::Gtk::TextTag::prop_direction()
{
	return DirectionPropertyProxy(this, &direction_property);
}

inline const GFC::Gtk::TextTag::EditablePropertyProxy
GFC::Gtk::TextTag::prop_editable()
{
	return EditablePropertyProxy(this, &editable_property);
}

inline const GFC::Gtk::TextTag::FontPropertyProxy
GFC::Gtk::TextTag::prop_font()
{
	return FontPropertyProxy(this, &font_property);
}

inline const GFC::Gtk::TextTag::FontDescPropertyProxy
GFC::Gtk::TextTag::prop_font_desc()
{
	return FontDescPropertyProxy(this, &font_desc_property);
}

inline const GFC::Gtk::TextTag::FamilyPropertyProxy
GFC::Gtk::TextTag::prop_family()
{
	return FamilyPropertyProxy(this, &family_property);
}

inline const GFC::Gtk::TextTag::StylePropertyProxy
GFC::Gtk::TextTag::prop_style()
{
	return StylePropertyProxy(this, &style_property);
}

inline const GFC::Gtk::TextTag::VariantPropertyProxy
GFC::Gtk::TextTag::prop_variant()
{
	return VariantPropertyProxy(this, &variant_property);
}

inline const GFC::Gtk::TextTag::WeightPropertyProxy
GFC::Gtk::TextTag::prop_weight()
{
	return WeightPropertyProxy(this, &weight_property);
}

inline const GFC::Gtk::TextTag::StretchPropertyProxy
GFC::Gtk::TextTag::prop_stretch()
{
	return StretchPropertyProxy(this, &stretch_property);
}

inline const GFC::Gtk::TextTag::SizePropertyProxy
GFC::Gtk::TextTag::prop_size()
{
	return SizePropertyProxy(this, &size_property);
}

inline const GFC::Gtk::TextTag::ScalePropertyProxy
GFC::Gtk::TextTag::prop_scale()
{
	return ScalePropertyProxy(this, &scale_property);
}

inline const GFC::Gtk::TextTag::SizePointsPropertyProxy
GFC::Gtk::TextTag::prop_size_points()
{
	return SizePointsPropertyProxy(this, &size_points_property);
}

inline const GFC::Gtk::TextTag::JustificationPropertyProxy
GFC::Gtk::TextTag::prop_justification()
{
	return JustificationPropertyProxy(this, &justification_property);
}

inline const GFC::Gtk::TextTag::LanguagePropertyProxy
GFC::Gtk::TextTag::prop_language()
{
	return LanguagePropertyProxy(this, &language_property);
}

inline const GFC::Gtk::TextTag::LeftMarginPropertyProxy
GFC::Gtk::TextTag::prop_left_margin()
{
	return LeftMarginPropertyProxy(this, &left_margin_property);
}

inline const GFC::Gtk::TextTag::RightMarginPropertyProxy
GFC::Gtk::TextTag::prop_right_margin()
{
	return RightMarginPropertyProxy(this, &right_margin_property);
}

inline const GFC::Gtk::TextTag::IndentPropertyProxy
GFC::Gtk::TextTag::prop_indent()
{
	return IndentPropertyProxy(this, &indent_property);
}

inline const GFC::Gtk::TextTag::RisePropertyProxy
GFC::Gtk::TextTag::prop_rise()
{
	return RisePropertyProxy(this, &rise_property);
}

inline const GFC::Gtk::TextTag::PixelsAboveLinesPropertyProxy
GFC::Gtk::TextTag::prop_pixels_above_lines()
{
	return PixelsAboveLinesPropertyProxy(this, &pixels_above_lines_property);
}

inline const GFC::Gtk::TextTag::PixelsBelowLinesPropertyProxy
GFC::Gtk::TextTag::prop_pixels_below_lines()
{
	return PixelsBelowLinesPropertyProxy(this, &pixels_below_lines_property);
}

inline const GFC::Gtk::TextTag::PixelsInsideWrapPropertyProxy
GFC::Gtk::TextTag::prop_pixels_inside_wrap()
{
	return PixelsInsideWrapPropertyProxy(this, &pixels_inside_wrap_property);
}

inline const GFC::Gtk::TextTag::StrikethroughPropertyProxy
GFC::Gtk::TextTag::prop_strikethrough()
{
	return StrikethroughPropertyProxy(this, &strikethrough_property);
}

inline const GFC::Gtk::TextTag::UnderlinePropertyProxy
GFC::Gtk::TextTag::prop_underline()
{
	return UnderlinePropertyProxy(this, &underline_property);
}

inline const GFC::Gtk::TextTag::WrapModePropertyProxy
GFC::Gtk::TextTag::prop_wrap_mode()
{
	return WrapModePropertyProxy(this, &wrap_mode_property);
}

inline const GFC::Gtk::TextTag::TabsPropertyProxy
GFC::Gtk::TextTag::prop_tabs()
{
	return TabsPropertyProxy(this, &tabs_property);
}

inline const GFC::Gtk::TextTag::InvisiblePropertyProxy
GFC::Gtk::TextTag::prop_invisible()
{
	return InvisiblePropertyProxy(this, &invisible_property);
}

inline const GFC::Gtk::TextTag::BackgroundSetPropertyProxy
GFC::Gtk::TextTag::prop_background_set()
{
	return BackgroundSetPropertyProxy(this, &background_set_property);
}

inline const GFC::Gtk::TextTag::BackgroundFullHeightSetPropertyProxy
GFC::Gtk::TextTag::prop_background_full_height_set()
{
	return BackgroundFullHeightSetPropertyProxy(this, &background_full_height_set_property);
}

inline const GFC::Gtk::TextTag::BackgroundStippleSetPropertyProxy
GFC::Gtk::TextTag::prop_background_stipple_set()
{
	return BackgroundStippleSetPropertyProxy(this, &background_stipple_set_property);
}

inline const GFC::Gtk::TextTag::ForegroundSetPropertyProxy
GFC::Gtk::TextTag::prop_foreground_set()
{
	return ForegroundSetPropertyProxy(this, &foreground_set_property);
}

inline const GFC::Gtk::TextTag::ForegroundStippleSetPropertyProxy
GFC::Gtk::TextTag::prop_foreground_stipple_set()
{
	return ForegroundStippleSetPropertyProxy(this, &foreground_stipple_set_property);
}

inline const GFC::Gtk::TextTag::EditableSetPropertyProxy
GFC::Gtk::TextTag::prop_editable_set()
{
	return EditableSetPropertyProxy(this, &editable_set_property);
}

inline const GFC::Gtk::TextTag::FamilySetPropertyProxy
GFC::Gtk::TextTag::prop_family_set()
{
	return FamilySetPropertyProxy(this, &family_set_property);
}

inline const GFC::Gtk::TextTag::StyleSetPropertyProxy
GFC::Gtk::TextTag::prop_style_set()
{
	return StyleSetPropertyProxy(this, &style_set_property);
}

inline const GFC::Gtk::TextTag::VariantSetPropertyProxy
GFC::Gtk::TextTag::prop_variant_set()
{
	return VariantSetPropertyProxy(this, &variant_set_property);
}

inline const GFC::Gtk::TextTag::WeightSetPropertyProxy
GFC::Gtk::TextTag::prop_weight_set()
{
	return WeightSetPropertyProxy(this, &weight_set_property);
}

inline const GFC::Gtk::TextTag::StretchSetPropertyProxy
GFC::Gtk::TextTag::prop_stretch_set()
{
	return StretchSetPropertyProxy(this, &stretch_set_property);
}

inline const GFC::Gtk::TextTag::SizeSetPropertyProxy
GFC::Gtk::TextTag::prop_size_set()
{
	return SizeSetPropertyProxy(this, &size_set_property);
}

inline const GFC::Gtk::TextTag::ScaleSetPropertyProxy
GFC::Gtk::TextTag::prop_scale_set()
{
	return ScaleSetPropertyProxy(this, &scale_set_property);
}

inline const GFC::Gtk::TextTag::JustificationSetPropertyProxy
GFC::Gtk::TextTag::prop_justification_set()
{
	return JustificationSetPropertyProxy(this, &justification_set_property);
}

inline const GFC::Gtk::TextTag::LanguageSetPropertyProxy
GFC::Gtk::TextTag::prop_language_set()
{
	return LanguageSetPropertyProxy(this, &language_set_property);
}

inline const GFC::Gtk::TextTag::LeftMarginSetPropertyProxy
GFC::Gtk::TextTag::prop_left_margin_set()
{
	return LeftMarginSetPropertyProxy(this, &left_margin_set_property);
}

inline const GFC::Gtk::TextTag::IndentSetPropertyProxy
GFC::Gtk::TextTag::prop_indent_set()
{
	return IndentSetPropertyProxy(this, &indent_set_property);
}

inline const GFC::Gtk::TextTag::RiseSetPropertyProxy
GFC::Gtk::TextTag::prop_rise_set()
{
	return RiseSetPropertyProxy(this, &rise_set_property);
}

inline const GFC::Gtk::TextTag::PixelsAboveLinesSetPropertyProxy
GFC::Gtk::TextTag::prop_pixels_above_lines_set()
{
	return PixelsAboveLinesSetPropertyProxy(this, &pixels_above_lines_set_property);
}

inline const GFC::Gtk::TextTag::PixelsBelowLinesSetPropertyProxy
GFC::Gtk::TextTag::prop_pixels_below_lines_set()
{
	return PixelsBelowLinesSetPropertyProxy(this, &pixels_below_lines_set_property);
}

inline const GFC::Gtk::TextTag::PixelsInsideWrapSetPropertyProxy
GFC::Gtk::TextTag::prop_pixels_inside_wrap_set()
{
	return PixelsInsideWrapSetPropertyProxy(this, &pixels_inside_wrap_set_property);
}

inline const GFC::Gtk::TextTag::StrikethroughSetPropertyProxy
GFC::Gtk::TextTag::prop_strikethrough_set()
{
	return StrikethroughSetPropertyProxy(this, &strikethrough_set_property);
}

inline const GFC::Gtk::TextTag::RightMarginSetPropertyProxy
GFC::Gtk::TextTag::prop_right_margin_set()
{
	return RightMarginSetPropertyProxy(this, &right_margin_set_property);
}

inline const GFC::Gtk::TextTag::UnderlineSetPropertyProxy
GFC::Gtk::TextTag::prop_underline_set()
{
	return UnderlineSetPropertyProxy(this, &underline_set_property);
}

inline const GFC::Gtk::TextTag::WrapModeSetPropertyProxy
GFC::Gtk::TextTag::prop_wrap_mode_set()
{
	return WrapModeSetPropertyProxy(this, &wrap_mode_set_property);
}

inline const GFC::Gtk::TextTag::TabsSetPropertyProxy
GFC::Gtk::TextTag::prop_tabs_set()
{
	return TabsSetPropertyProxy(this, &tabs_set_property);
}

inline const GFC::Gtk::TextTag::InvisibleSetPropertyProxy
GFC::Gtk::TextTag::prop_invisible_set()
{
	return InvisibleSetPropertyProxy(this, &invisible_set_property);
}

inline const GFC::Gtk::TextTag::EventSignalProxy
GFC::Gtk::TextTag::sig_event()
{
	return EventSignalProxy(this, &event_signal);
}

/*  Gtk::TextTagTable
 */

inline GtkTextTagTable*
GFC::Gtk::TextTagTable::gtk_text_tag_table() const
{
	return reinterpret_cast<GtkTextTagTable*>(instance_);
}

inline GFC::Gtk::TextTagTable::operator GtkTextTagTable* () const
{
	return this ? gtk_text_tag_table() : 0;
}

inline int
GFC::Gtk::TextTagTable::get_size() const
{
	return gtk_text_tag_table_get_size(gtk_text_tag_table());
}

inline const GFC::Gtk::TextTagTable::TagChangedSignalProxy
GFC::Gtk::TextTagTable::sig_tag_changed()
{
	return TagChangedSignalProxy(this, &tag_changed_signal);
}

inline const GFC::Gtk::TextTagTable::TagAddedSignalProxy
GFC::Gtk::TextTagTable::sig_tag_added()
{
	return TagAddedSignalProxy(this, &tag_added_signal);
}

inline const GFC::Gtk::TextTagTable::TagRemovedSignalProxy
GFC::Gtk::TextTagTable::sig_tag_removed()
{
	return TagRemovedSignalProxy(this, &tag_removed_signal);
}

