/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  treesortable.cc - GtkTreeSortable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "treesortable.hh"
#include "private/marshal.hh"
#include "treemodel.hh"
#include <gfc/glib/object.hh>

using namespace GFC;

/*  Gtk::TreeSortable
 */

Gtk::TreeSortable::TreeSortable()
{
}

Gtk::TreeSortable::~TreeSortable()
{
}
	
namespace { // CompareCallback

struct CompareCallback
{
	typedef Gtk::TreeSortable::CompareSlot CompareSlot;
	CompareSlot slot_;

	CompareCallback(const CompareSlot& slot)
	: slot_(slot)
	{
	}

	static int notify(GtkTreeModel* model, GtkTreeIter *a, GtkTreeIter *b, void *data)
	{
		CompareCallback *cb = static_cast<CompareCallback*>(data);
		G::Object *object = G::Object::pointer((GObject*)model);
		Gtk::TreeModel *tmp_model = dynamic_cast<Gtk::TreeModel*>(object);
		Gtk::TreeIter tmp_a(a);
		Gtk::TreeIter tmp_b(b);
		return cb->slot_(*tmp_model, tmp_a, tmp_b);
	}

	static void destroy(void *data)
	{
		CompareCallback *cb = static_cast<CompareCallback*>(data);
		delete cb;
	}
};

} // namespace

void
Gtk::TreeSortable::set_sort_func(int sort_column_id, const CompareSlot& compare)
{
	CompareCallback *cb = new CompareCallback(compare);
	gtk_tree_sortable_set_sort_func(gtk_tree_sortable(), sort_column_id, &CompareCallback::notify, cb, &CompareCallback::destroy);
}

void
Gtk::TreeSortable::set_default_sort_func(const CompareSlot& compare)
{
	CompareCallback *cb = new CompareCallback(compare);
	gtk_tree_sortable_set_default_sort_func(gtk_tree_sortable(), &CompareCallback::notify, cb, &CompareCallback::destroy);
}

/*  Gtk::TreeSortable signals
 */

const Gtk::TreeSortable::SortColumnChangedSignalType Gtk::TreeSortable::sort_column_changed_signal("sort_column_changed", (GCallback)&G::Marshal::void_callback);
