// ERRUTIL.H : Handle simple error messages and Yes/No problems
//             will use GNOME/GTK dialogue boxes if available.

// Copyright (C) 2000 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef ERRUTIL_H
#define ERRUTIL_H

/*################################################################################################*/

class err_util;
class console_err_util;

/*################################################################################################*/

/**	Various user-visible error routines depending on severity. These may be 
	overloaded by subclasses (e.g. GUI dialogues).
*/

class err_util
{
	protected:
	
	public:
	
	err_util(void) { }
	virtual ~err_util(void) { }
	
	virtual void Message(const char *) = 0;
	virtual void WarningMessage(const char *) = 0;
	virtual void ErrorMessage(const char *) = 0;
	
	virtual bool Question(const char *) = 0;
};

/*################################################################################################*/

/**	This is the console version; use cin/cout for i/o...
*/

class console_err_util : public err_util
{
	protected:
	
	public:
	
	console_err_util(void);
	~console_err_util(void);
	
	void Message(const char *);		// virtual
	void WarningMessage(const char *);	// virtual
	void ErrorMessage(const char *);	// virtual
	
	bool Question(const char *);		// virtual
};

/*################################################################################################*/

#endif	// ERRUTIL_H

// eof
