// PREFS.CPP: Handle user preferences/configuration 
//             Can be overloaded by subclasses, e.g. GNOME config

// Copyright (C) 2001 Geoffrey Hutchison

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "prefs.h"
#include "utility.h"

#include <string.h>

#include <fstream>
using namespace std;

/*################################################################################################*/

// Constructor -- shouldn't need to do anything
console_prefs::console_prefs(void) : prefs()
{
}

// Destructor --shouldn't need to do anything
console_prefs::~console_prefs(void)
{
}

// 2001-07-22 TH : i added these add's because my compiler refused to link otherwise...

void console_prefs::Add(const char *, const char *)
{
}

void console_prefs::Add(const char *, const int)
{
}

void console_prefs::Add(const char *, const double)
{
}

void console_prefs::Add(const char *, const bool)
{
}

void console_prefs::Add(const char *, const float, const float, const float)
{
}

void console_prefs::Add(const char *, const float, const float, const float, const float)
{
}

char * console_prefs::Find(const char *key, const char * def)
{
  char *temp = new char [strlen(def) + 1];
  strncpy(temp, def, strlen(def) + 1);
  return temp;
}

int    console_prefs::Value(const char *key, const int def)
{
  int temp = def;
  return temp;
}

double console_prefs::Double(const char *key, const double def)
{
  double temp = def;
  return temp;
}

bool   console_prefs::Boolean(const char *key, const bool def)
{
  bool temp = def;
  return temp;
}

float *console_prefs::ColorRGB(const char *key, const float def[3])
{
  float *temp = new float[3];
  temp[0] = def[0]; temp[1] = def[1]; temp[2] = def[2];
  return temp;
}
	
float *console_prefs::ColorRGBA(const char *key, const float def[4])
{
  float *temp = new float[4];
  temp[0] = def[0]; temp[1] = def[1]; temp[2] = def[2]; temp[3] = def[3];
  return temp;
}

/*################################################################################################*/

// eof
